/*
 * Decompiled with CFR 0.152.
 */
package cib.util.update;

import cib.util.coll.CollUtilities;
import cib.util.coll.ObservableSet;
import cib.util.update.Graph;
import cib.util.update.GraphException;
import cib.util.update.Node;
import cib.util.update.Updatable;
import cib.util.update.UpdatableGraph;
import cib.util.update.Update;
import cib.util.update.UpdateInterface;
import cib.util.update._Graph;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;

@Deprecated
public class _UpdatableGraph
implements UpdatableGraph,
Serializable {
    private static final long serialVersionUID = 0L;
    private Graph m_linkGraph = null;
    private transient boolean[][] m_link = null;
    private transient boolean[][] m_hull = null;
    private UpdateInterface m_updateInterface = null;
    private ObservableSet<Node> m_nodeSet = null;
    private Set<Node> m_changedSet = null;
    private transient Update m_update = null;

    public _UpdatableGraph(UpdateInterface updateInterface) {
        this.m_updateInterface = updateInterface;
        this.m_linkGraph = new _Graph();
        this.m_nodeSet = CollUtilities.observableSet(new HashSet());
        this.m_changedSet = CollUtilities.subSet(new HashSet(), this.m_nodeSet);
    }

    @Override
    public Graph getLinkGraph() {
        return this.m_linkGraph;
    }

    public UpdateInterface getUpdateInterface() {
        return this.m_updateInterface;
    }

    @Override
    public Set<Node> getNodeSet() {
        return this.m_nodeSet;
    }

    @Override
    public Set<Node> getChangedNodeSet() {
        return this.m_changedSet;
    }

    @Override
    public boolean[][] getLink() {
        this.computeLink();
        return this.m_link;
    }

    @Override
    public boolean[][] getHull() {
        this.computeLink();
        this.computeHull();
        return this.m_hull;
    }

    @Override
    public void setUpdate(Update update) {
        this.m_update = update;
    }

    @Override
    public void update(Object context) {
        if (this.m_update != null) {
            this.computeHull();
            if (!this.m_changedSet.isEmpty()) {
                this.m_update.update(context);
            }
        } else {
            System.err.println("Update does not exist.");
        }
    }

    @Override
    public void wasChanged(Node node) {
        if (node != null) {
            this.m_changedSet.add(node);
        }
    }

    @Override
    public void updateNode(Node node, Object context) {
        Updatable u = this.m_updateInterface.getUpdatable(node);
        u.update(context);
        this.m_changedSet.remove(node);
    }

    @Override
    public Node[] getNodes() {
        return this.m_linkGraph.getNodes();
    }

    @Override
    public Node[] getEdges(Node node) {
        return this.m_linkGraph.getEdges(node);
    }

    @Override
    public boolean addNode(Node node) {
        if (!this.m_linkGraph.addNode(node)) {
            if (this.m_nodeSet.contains(node)) {
                throw new IllegalArgumentException("Inconsistent data structure.");
            }
            return false;
        }
        if (!this.m_nodeSet.add(node)) {
            throw new IllegalArgumentException("Inconsistent data structure.");
        }
        return true;
    }

    @Override
    public boolean removeNode(Node node) {
        if (!this.m_nodeSet.remove(node)) {
            if (this.m_linkGraph.containsNode(node)) {
                throw new IllegalArgumentException("Inconsistent data structure.");
            }
            return false;
        }
        if (!this.m_linkGraph.removeNode(node)) {
            throw new IllegalArgumentException("Inconsistent data structure.");
        }
        return true;
    }

    @Override
    public boolean addEdge(Node src, Node dest) throws GraphException {
        return this.m_linkGraph.addEdge(src, dest);
    }

    @Override
    public boolean removeEdge(Node src, Node dest) {
        return this.m_linkGraph.removeEdge(src, dest);
    }

    @Override
    public boolean containsNode(Node node) {
        return this.m_linkGraph.containsNode(node);
    }

    @Override
    public boolean hasCycle() {
        return this.m_linkGraph.hasCycle();
    }

    private void computeLink() {
        ArrayList<Node> nodes = ((_Graph)this.m_linkGraph).getNodeList();
        int dim = nodes.size();
        this.m_link = new boolean[dim][dim];
        int i = 0;
        while (i < dim) {
            int j = 0;
            while (j < dim) {
                this.m_link[i][j] = false;
                ++j;
            }
            ++i;
        }
        int i2 = 0;
        while (i2 < dim) {
            ArrayList<Node> edges = nodes.get(i2).getEdges();
            int e = 0;
            while (e < edges.size()) {
                int index = nodes.indexOf(edges.get(e));
                this.m_link[i2][index] = true;
                ++e;
            }
            ++i2;
        }
    }

    private void computeHull() {
        this.computeLink();
        int dim = this.m_link.length;
        this.m_hull = new boolean[dim][dim];
        boolean[] mark = new boolean[dim];
        int row = 0;
        while (row < dim) {
            boolean hit;
            System.arraycopy(this.m_link[row], 0, this.m_hull[row], 0, dim);
            int m = 0;
            while (m < dim) {
                mark[m] = false;
                ++m;
            }
            mark[row] = true;
            do {
                hit = false;
                int col = 0;
                while (col < dim) {
                    hit = this.m_hull[row][col] && !mark[col];
                    if (hit) break;
                    ++col;
                }
                if (!hit) continue;
                mark[col] = true;
                m = 0;
                while (m < dim) {
                    boolean[] blArray = this.m_hull[row];
                    int n = m;
                    blArray[n] = blArray[n] | this.m_link[col][m];
                    ++m;
                }
            } while (hit);
            ++row;
        }
    }
}

