/*
 * Decompiled with CFR 0.152.
 */
package cib.util.update;

import cib.util.coll.CollUtilities;
import cib.util.update.Node;
import cib.util.update.UpdatableGraph;
import cib.util.update.Update;
import cib.util.update._Graph;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

@Deprecated
public class _Update
implements Update,
Serializable {
    private static final long serialVersionUID = 0L;
    private Set<Node> m_destinationSet = null;
    private Set<Node> m_domainSet = null;
    private UpdatableGraph m_linkGraph = null;
    private ArrayList<Node> m_domainNodes = null;
    private transient boolean[][] m_domainLink = null;
    private transient int[][] m_domainChronos = null;
    private transient int[] m_domainAge = null;
    private transient Node m_currentUpdatedNode = null;

    public _Update() {
    }

    public _Update(UpdatableGraph ug) {
        this.m_linkGraph = ug;
        this.m_destinationSet = CollUtilities.subSet(new HashSet(), CollUtilities.observableSet(this.m_linkGraph.getNodeSet()));
        this.m_domainSet = CollUtilities.subSet(new HashSet(), CollUtilities.observableSet(this.m_linkGraph.getNodeSet()));
    }

    @Override
    public void setUpdatableGraph(UpdatableGraph up) {
        this.m_linkGraph = up;
        this.m_destinationSet = CollUtilities.subSet(new HashSet(), CollUtilities.observableSet(this.m_linkGraph.getNodeSet()));
        this.m_domainSet = CollUtilities.subSet(new HashSet(), CollUtilities.observableSet(this.m_linkGraph.getNodeSet()));
    }

    @Override
    public void update(Object context) {
        this.setDomainSet();
        this.computeDomainLink();
        this.computeDomainChronos();
        this.computeDomainAge();
        this.callDomainUpdates(context);
        this.m_currentUpdatedNode = null;
    }

    @Override
    public boolean addDestNode(Node node) {
        return this.m_destinationSet.add(node);
    }

    @Override
    public boolean removeDestNode(Node node) {
        return this.m_destinationSet.remove(node);
    }

    @Override
    public Set<Node> getDomainSet() {
        return this.m_domainSet;
    }

    @Override
    public Set<Node> getDestSet() {
        return this.m_destinationSet;
    }

    private void setDomainSet() {
        boolean[][] hull = this.m_linkGraph.getHull();
        Set<Node> changed = this.m_linkGraph.getChangedNodeSet();
        for (Node node_aa : changed) {
            int index_aa = ((_Graph)this.m_linkGraph.getLinkGraph()).getNodeList().indexOf(node_aa);
            for (Node node_az : this.m_destinationSet) {
                int index_az = ((_Graph)this.m_linkGraph.getLinkGraph()).getNodeList().indexOf(node_az);
                if (!hull[index_aa][index_az]) continue;
                this.m_domainSet.add(node_aa);
            }
        }
        for (Node node_zz : this.m_destinationSet) {
            int index_zz = ((_Graph)this.m_linkGraph.getLinkGraph()).getNodeList().indexOf(node_zz);
            for (Node node_za : changed) {
                int index_za = ((_Graph)this.m_linkGraph.getLinkGraph()).getNodeList().indexOf(node_za);
                if (!hull[index_za][index_zz]) continue;
                this.m_domainSet.add(node_zz);
            }
        }
        Iterator<Node> it_ez = this.m_destinationSet.iterator();
        while (it_ez.hasNext()) {
            ArrayList<Node> e_z = new ArrayList<Node>();
            Node node_ez = it_ez.next();
            int index_ez = ((_Graph)this.m_linkGraph.getLinkGraph()).getNodeList().indexOf(node_ez);
            int i = 0;
            while (i < hull.length) {
                if (hull[i][index_ez]) {
                    Node node_ee = ((_Graph)this.m_linkGraph.getLinkGraph()).getNodeList().get(i);
                    e_z.add(node_ee);
                }
                ++i;
            }
            for (Node node_ea : changed) {
                int index_ea = ((_Graph)this.m_linkGraph.getLinkGraph()).getNodeList().indexOf(node_ea);
                int j = 0;
                while (j < e_z.size()) {
                    int index_ee = ((_Graph)this.m_linkGraph.getLinkGraph()).getNodeList().indexOf(e_z.get(j));
                    if (hull[index_ea][index_ee]) {
                        this.m_domainSet.add((Node)e_z.get(j));
                    }
                    ++j;
                }
            }
        }
        for (Node node_a : changed) {
            if (!this.m_destinationSet.contains(node_a)) continue;
            this.m_domainSet.add(node_a);
        }
    }

    private void computeDomainLink() {
        boolean[][] link = this.m_linkGraph.getLink();
        this.m_domainNodes = new ArrayList();
        Iterator<Node> it = this.m_domainSet.iterator();
        while (it.hasNext()) {
            this.m_domainNodes.add(it.next());
        }
        int dim = this.m_domainNodes.size();
        this.m_domainLink = new boolean[dim][dim];
        int i = 0;
        while (i < dim) {
            int j = 0;
            while (j < dim) {
                int i_link = ((_Graph)this.m_linkGraph.getLinkGraph()).getNodeList().indexOf(this.m_domainNodes.get(i));
                int j_link = ((_Graph)this.m_linkGraph.getLinkGraph()).getNodeList().indexOf(this.m_domainNodes.get(j));
                this.m_domainLink[i][j] = link[i_link][j_link];
                ++j;
            }
            ++i;
        }
    }

    private void computeDomainChronos() {
        int NONE = -1;
        int dim = this.m_domainLink.length;
        this.m_domainChronos = new int[dim][dim];
        int i = 0;
        while (i < dim) {
            int j = 0;
            while (j < dim) {
                this.m_domainChronos[i][j] = i == j ? 0 : (this.m_domainLink[i][j] ? 1 : -1);
                ++j;
            }
            ++i;
        }
        int k = 0;
        while (k < dim) {
            int i2 = 0;
            while (i2 < dim) {
                if (this.m_domainChronos[i2][k] != -1) {
                    int j = 0;
                    while (j < dim) {
                        int test;
                        if (this.m_domainChronos[k][j] != -1 && (test = this.m_domainChronos[i2][k] + this.m_domainChronos[k][j]) > this.m_domainChronos[i2][j]) {
                            this.m_domainChronos[i2][j] = test;
                        }
                        ++j;
                    }
                }
                ++i2;
            }
            ++k;
        }
    }

    private void computeDomainAge() {
        int dim = this.m_domainChronos.length;
        this.m_domainAge = new int[dim];
        int j = 0;
        while (j < dim) {
            int test = 0;
            int i = 0;
            while (i < dim) {
                int m = this.m_domainChronos[i][j];
                if (test < m) {
                    test = m;
                }
                ++i;
            }
            this.m_domainAge[j] = test;
            ++j;
        }
    }

    private void callDomainUpdates(Object context) {
        int i = 0;
        while (i < this.m_domainAge.length) {
            int j = 0;
            while (j < this.m_domainAge.length) {
                if (this.m_domainAge[j] == i) {
                    Node n;
                    this.m_currentUpdatedNode = n = this.m_domainNodes.get(j);
                    this.m_linkGraph.updateNode(n, context);
                }
                ++j;
            }
            ++i;
        }
    }

    @Override
    public boolean stillToUpdate(Node n) {
        if (this.m_currentUpdatedNode != null) {
            if (this.m_domainNodes.contains(n)) {
                int ci;
                int ca;
                int ni = this.m_domainNodes.indexOf(n);
                int na = this.m_domainAge[ni];
                return na >= (ca = this.m_domainAge[ci = this.m_domainNodes.indexOf(this.m_currentUpdatedNode)]);
            }
            return false;
        }
        throw new IllegalStateException("No update in progress!");
    }

    @Override
    public boolean alreadyUpdated(Node n) {
        if (this.m_currentUpdatedNode != null) {
            if (this.m_domainNodes.contains(n)) {
                int ci;
                int ca;
                int ni = this.m_domainNodes.indexOf(n);
                int na = this.m_domainAge[ni];
                return na <= (ca = this.m_domainAge[ci = this.m_domainNodes.indexOf(this.m_currentUpdatedNode)]);
            }
            return false;
        }
        throw new IllegalStateException("No update in progress!");
    }
}

