/*
 * Decompiled with CFR 0.152.
 */
package cib.util.view;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.plaf.basic.BasicComboPopup;

public class ScrollableJPopupMenu
implements ItemListener {
    private static final long serialVersionUID = 1L;
    private JComboBox m_comboBox;
    private JPopupMenu m_popupMenu;

    public static void main(String[] args) {
        JFrame frame = new JFrame("Test");
        frame.setSize(300, 200);
        frame.setDefaultCloseOperation(3);
        final JButton button = new JButton("Press");
        frame.add((Component)button, "North");
        ScrollableJPopupMenu m = new ScrollableJPopupMenu();
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ScrollableJPopupMenu.this.removeAll();
                int i = 0;
                while (i < 100) {
                    JMenuItem item = new JMenuItem("item " + i);
                    item.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            ScrollableJPopupMenu.this.setVisible(false);
                        }
                    });
                    ScrollableJPopupMenu.this.add(item);
                    ++i;
                }
                ScrollableJPopupMenu.this.show(button, 0, 0);
            }
        });
        frame.setVisible(true);
    }

    public ScrollableJPopupMenu() {
        this._init();
    }

    private void _init() {
        this.m_comboBox = new JComboBox();
        this.m_popupMenu = new BasicComboPopup(this.m_comboBox);
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (e.getStateChange() == 1) {
            ComboBoxItem item = (ComboBoxItem)e.getItem();
            item.getItem().doClick();
        }
    }

    public JMenuItem add(JMenuItem menuItem) {
        this.m_comboBox.addItem(new ComboBoxItem(menuItem));
        return menuItem;
    }

    public void addSeparator() {
        JMenuItem menuItem = new JMenuItem("\u2500\u2500\u2500\u2500\u2500\u2500");
        this.m_comboBox.addItem(new ComboBoxItem(menuItem));
    }

    public void removeAll() {
        this._init();
    }

    public int getSelectedIndex() {
        return this.m_comboBox.getSelectedIndex();
    }

    public boolean isVisible() {
        return this.m_popupMenu.isVisible();
    }

    public void show(final Component invoker, final int x, final int y) {
        this.m_comboBox.setSelectedIndex(-1);
        this.m_comboBox.addItemListener(this);
        this.m_popupMenu.setPreferredSize(this._preferredPopupMenuSize());
        SwingUtilities.invokeLater(new Thread(){

            @Override
            public void run() {
                ScrollableJPopupMenu.this.m_popupMenu.show(invoker, x, y);
            }
        });
    }

    public void setVisible(boolean b) {
        this.m_comboBox.setSelectedIndex(-1);
        if (b) {
            this.m_comboBox.addItemListener(this);
        } else {
            this.m_comboBox.removeItemListener(this);
        }
        this.m_popupMenu.setPreferredSize(this._preferredPopupMenuSize());
        this.m_popupMenu.setVisible(b);
    }

    private Dimension _preferredPopupMenuSize() {
        int n = Math.min(this.m_comboBox.getItemCount(), 8);
        int height = (int)(18.4 * (double)n) + 2;
        int width = this.m_popupMenu.getPreferredSize().width;
        return new Dimension(width, height);
    }

    public class ComboBoxItem {
        private JMenuItem m_item;

        public ComboBoxItem(JMenuItem item) {
            this.m_item = item;
        }

        public JMenuItem getItem() {
            return this.m_item;
        }

        public String toString() {
            return this.m_item.getText();
        }
    }
}

