/*
 * Decompiled with CFR 0.152.
 */
package org.diylc.swingframework;

import java.awt.Color;
import java.awt.Dimension;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.ListModel;
import org.diylc.swingframework.ButtonDialog;
import org.diylc.swingframework.CheckBoxList;

public class CheckBoxListDialog
extends ButtonDialog {
    private static final long serialVersionUID = 1L;
    private Object[] options;
    private CheckBoxList list;

    public CheckBoxListDialog(JFrame owner, String title, Object[] options) {
        this(owner, title, new String[]{"OK", "Cancel"}, options);
    }

    public CheckBoxListDialog(JFrame owner, String title, String[] buttonCaptions, Object[] options) {
        super(owner, title, buttonCaptions);
        this.options = options;
        this.setPreferredSize(new Dimension(320, 400));
        this.layoutGui();
    }

    private CheckBoxList getList() {
        if (this.list == null) {
            CheckBoxList.CheckListItem[] items = new CheckBoxList.CheckListItem[this.options.length];
            for (int i = 0; i < this.options.length; ++i) {
                items[i] = new CheckBoxList.CheckListItem(this.options[i]);
                items[i].setSelected(false);
            }
            this.list = new CheckBoxList(items);
        }
        return this.list;
    }

    @Override
    protected JComponent getMainComponent() {
        JScrollPane scrollPane = new JScrollPane(this.getList());
        scrollPane.setHorizontalScrollBarPolicy(30);
        scrollPane.setVerticalScrollBarPolicy(20);
        scrollPane.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, Color.gray));
        return scrollPane;
    }

    public Object[] getSelectedOptions() {
        ArrayList<Object> selected = new ArrayList<Object>();
        ListModel model = this.getList().getModel();
        for (int i = 0; i < model.getSize(); ++i) {
            CheckBoxList.CheckListItem item = (CheckBoxList.CheckListItem)model.getElementAt(i);
            if (!item.isSelected()) continue;
            selected.add(item.getValue());
        }
        return selected.toArray();
    }
}

