/*
 * Decompiled with CFR 0.152.
 */
package org.diylc.swingframework.ruler;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.geom.Rectangle2D;
import java.awt.image.VolatileImage;
import javax.swing.JComponent;

public class Ruler
extends JComponent {
    private static final long serialVersionUID = 1L;
    public static final Color COLOR = Color.decode("#C0FF3E");
    public static final Color SELECTION_COLOR = Color.red;
    public static final Color CURSOR_COLOR = Color.blue;
    public static final int PIXELS_PER_INCH = Toolkit.getDefaultToolkit().getScreenResolution();
    public static final int HORIZONTAL = 0;
    public static final int VERTICAL = 1;
    public static final int SIZE = 18;
    public int orientation;
    private boolean isMetric;
    private float unitSize;
    private int indicatorValue = -1;
    private float ticksPerUnit;
    private Graphics bufferGraphics;
    private Image bufferImage;
    private GraphicsConfiguration screenGraphicsConfiguration;
    public boolean useHardwareAcceleration = false;
    private double zoomLevel = 1.0;
    private double cmSpacing;
    private double inSpacing;
    private double zeroLocation = 0.0;
    private Rectangle2D selectionRect = null;

    public Ruler(int orientation, boolean isMetric) {
        this(orientation, isMetric, 0.0, 0.0);
    }

    public Ruler(int orientation, boolean isMetric, double cmSpacing, double inSpacing) {
        this.orientation = orientation;
        this.isMetric = isMetric;
        this.cmSpacing = cmSpacing;
        this.inSpacing = inSpacing;
        this.setIncrementAndUnits();
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                Ruler.this.bufferImage = null;
            }
        });
    }

    protected void createBufferImage() {
        if (this.useHardwareAcceleration) {
            this.bufferImage = this.getScreenGraphicsConfiguration().createCompatibleVolatileImage(this.getWidth(), this.getHeight());
            ((VolatileImage)this.bufferImage).validate(this.screenGraphicsConfiguration);
        } else {
            this.bufferImage = this.createImage(this.getWidth(), this.getHeight());
        }
        this.bufferGraphics = this.bufferImage.getGraphics();
    }

    public void setUseHardwareAcceleration(boolean useHardwareAcceleration) {
        this.useHardwareAcceleration = useHardwareAcceleration;
        this.bufferImage = null;
    }

    public void setSelectionRect(Rectangle2D selectionRect) {
        this.selectionRect = selectionRect;
        this.repaint();
    }

    public void setZoomLevel(double zoomLevel) {
        this.zoomLevel = zoomLevel;
        this.setIncrementAndUnits();
        this.repaint();
    }

    public void setIsMetric(boolean isMetric) {
        this.isMetric = isMetric;
        this.setIncrementAndUnits();
        this.repaint();
    }

    public void setZeroLocation(double zeroLocation) {
        this.zeroLocation = zeroLocation;
        this.repaint();
    }

    public void setIndicatorValue(int indicatortValue) {
        this.indicatorValue = indicatortValue;
    }

    private GraphicsConfiguration getScreenGraphicsConfiguration() {
        if (this.screenGraphicsConfiguration == null) {
            GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
            GraphicsDevice[] devices = graphicsEnvironment.getScreenDevices();
            this.screenGraphicsConfiguration = devices[0].getDefaultConfiguration();
        }
        return this.screenGraphicsConfiguration;
    }

    private void setIncrementAndUnits() {
        if (this.isMetric) {
            this.unitSize = (float)((this.cmSpacing == 0.0 ? (double)((float)PIXELS_PER_INCH / 2.54f) : this.cmSpacing) * this.zoomLevel);
            this.ticksPerUnit = 4.0f;
        } else {
            this.ticksPerUnit = 10.0f;
            this.unitSize = (float)((this.inSpacing == 0.0 ? (double)PIXELS_PER_INCH : this.inSpacing) * this.zoomLevel);
        }
    }

    public boolean isMetric() {
        return this.isMetric;
    }

    public void setPreferredHeight(int ph) {
        this.setPreferredSize(new Dimension(18, ph));
    }

    public void setPreferredWidth(int pw) {
        this.setPreferredSize(new Dimension(pw, 18));
    }

    @Override
    protected void paintComponent(Graphics g) {
        int firstUnit;
        if (this.bufferImage == null) {
            this.createBufferImage();
        }
        if (this.bufferGraphics == null) {
            return;
        }
        Rectangle clipRect = g.getClipBounds();
        this.bufferGraphics.setColor(COLOR);
        this.bufferGraphics.fillRect(clipRect.x, clipRect.y, clipRect.width, clipRect.height);
        this.bufferGraphics.setFont(new Font("SansSerif", 0, 10));
        this.bufferGraphics.setColor(Color.black);
        double offset = (int)(this.zeroLocation * (double)this.unitSize);
        double start = 0.0;
        int tickLength = 0;
        String text = null;
        double increment = this.unitSize / this.ticksPerUnit;
        if (this.orientation == 0) {
            firstUnit = (int)((float)clipRect.x / this.unitSize);
            start = (float)((int)((float)clipRect.x / this.unitSize)) * this.unitSize;
        } else {
            firstUnit = (int)((float)clipRect.y / this.unitSize);
            start = (float)((int)((float)clipRect.y / this.unitSize)) * this.unitSize;
        }
        start += offset;
        int x = 0;
        int i = (int)(-offset);
        while (x < (this.orientation == 0 ? clipRect.x + clipRect.width : clipRect.y + clipRect.height)) {
            if (this.ticksPerUnit <= 1.0f || i % Math.round(this.ticksPerUnit) == 0) {
                tickLength = 10;
                text = Integer.toString(firstUnit + Math.round((float)i / this.ticksPerUnit));
            } else {
                tickLength = 7;
                if (this.isMetric) {
                    tickLength -= 2 * (i % Math.round(this.ticksPerUnit) % 2);
                } else if (i % Math.round(this.ticksPerUnit) != 5) {
                    tickLength -= 2;
                }
                text = null;
            }
            x = (int)(start + (double)i * increment);
            if (tickLength != 0) {
                if (this.orientation == 0) {
                    this.bufferGraphics.drawLine(x, 17, x, 18 - tickLength - 1);
                    if (text != null) {
                        this.bufferGraphics.drawString(text, x + 2, 15);
                    }
                } else {
                    this.bufferGraphics.drawLine(17, x, 18 - tickLength - 1, x);
                    if (text != null) {
                        FontMetrics fm = this.bufferGraphics.getFontMetrics();
                        this.bufferGraphics.drawString(text, 18 - (int)fm.getStringBounds(text, this.bufferGraphics).getWidth() - 2, x + 10);
                    }
                }
            }
            ++i;
        }
        if (this.indicatorValue >= 0) {
            this.bufferGraphics.setColor(CURSOR_COLOR);
            if (this.orientation == 0) {
                if (this.indicatorValue < this.getWidth()) {
                    this.bufferGraphics.drawLine(this.indicatorValue, 0, this.indicatorValue, 17);
                }
            } else if (this.indicatorValue < this.getHeight()) {
                this.bufferGraphics.drawLine(0, this.indicatorValue, 17, this.indicatorValue);
            }
        }
        if (this.selectionRect != null) {
            this.bufferGraphics.setColor(SELECTION_COLOR);
            if (this.orientation == 0) {
                this.bufferGraphics.drawLine((int)this.selectionRect.getX(), 0, (int)this.selectionRect.getX(), 17);
                this.bufferGraphics.drawLine((int)(this.selectionRect.getX() + this.selectionRect.getWidth()), 0, (int)(this.selectionRect.getX() + this.selectionRect.getWidth()), 17);
            } else {
                this.bufferGraphics.drawLine(0, (int)this.selectionRect.getY(), 17, (int)this.selectionRect.getY());
                this.bufferGraphics.drawLine(0, (int)(this.selectionRect.getY() + this.selectionRect.getHeight()), 17, (int)(this.selectionRect.getY() + this.selectionRect.getHeight()));
            }
        }
        this.bufferGraphics.setColor(Color.black);
        if (this.orientation == 0) {
            this.bufferGraphics.drawLine(0, 17, this.getWidth(), 17);
        } else {
            this.bufferGraphics.drawLine(17, 0, 17, this.getHeight());
        }
        g.drawImage(this.bufferImage, 0, 0, this);
    }

    @Override
    public void update(Graphics g) {
        this.paint(g);
    }
}

