/*
 * Decompiled with CFR 0.152.
 */
package org.diylc.swing.gui.editor;

import java.awt.Color;
import java.awt.Dimension;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.diylc.common.PropertyWrapper;
import org.diylc.swing.gui.components.HTMLTextArea;
import org.diylc.utils.Constants;

public class MultiLineStringEditor
extends JScrollPane {
    private static final long serialVersionUID = 1L;
    private Color oldBg;
    private JTextArea textArea;
    private final PropertyWrapper property;
    private static final Border border = new JTextField().getBorder();

    public MultiLineStringEditor(PropertyWrapper propertyWrapper) {
        this.property = propertyWrapper;
        this.setViewportView(this.getTextArea());
        this.setPreferredSize(new Dimension(192, 64));
        this.setBorder(border);
    }

    public JTextArea getTextArea() {
        if (this.textArea == null) {
            this.textArea = new HTMLTextArea(this.property.getValue() == null ? "" : (String)this.property.getValue());
            this.textArea.setFont(this.getFont());
            this.oldBg = this.textArea.getBackground();
            this.textArea.getDocument().addDocumentListener(new DocumentListener(){

                @Override
                public void changedUpdate(DocumentEvent documentEvent) {
                    MultiLineStringEditor.this.textChanged();
                }

                @Override
                public void insertUpdate(DocumentEvent documentEvent) {
                    MultiLineStringEditor.this.textChanged();
                }

                @Override
                public void removeUpdate(DocumentEvent documentEvent) {
                    MultiLineStringEditor.this.textChanged();
                }
            });
            if (!this.property.isUnique()) {
                this.textArea.setBackground(Constants.MULTI_VALUE_COLOR);
            }
        }
        return this.textArea;
    }

    private void textChanged() {
        this.property.setChanged(true);
        this.getTextArea().setBackground(this.oldBg);
        this.property.setValue((Object)this.getTextArea().getText());
    }
}

