/*
 * Decompiled with CFR 0.152.
 */
package org.diylc.swing.plugins.tree;

import java.awt.KeyEventDispatcher;
import java.awt.KeyboardFocusManager;
import java.awt.event.KeyEvent;
import java.util.EnumSet;
import javax.swing.JComponent;
import org.apache.log4j.Logger;
import org.diylc.appframework.miscutils.ConfigurationManager;
import org.diylc.appframework.miscutils.IConfigListener;
import org.diylc.common.BadPositionException;
import org.diylc.common.EventType;
import org.diylc.common.IPlugIn;
import org.diylc.common.IPlugInPort;
import org.diylc.swing.ISwingUI;
import org.diylc.swing.plugins.statusbar.StatusBar;
import org.diylc.swing.plugins.tree.TreePanel;

public class ComponentTree
implements IPlugIn {
    private static final Logger LOG = Logger.getLogger(StatusBar.class);
    private ISwingUI swingUI;
    private IPlugInPort plugInPort;
    private TreePanel treePanel;
    private JComponent canvasPanel;

    public ComponentTree(ISwingUI iSwingUI, JComponent jComponent) {
        this.swingUI = iSwingUI;
        this.canvasPanel = jComponent;
    }

    public void connect(IPlugInPort iPlugInPort) {
        this.plugInPort = iPlugInPort;
        try {
            this.swingUI.injectGUIComponent(this.getTreePanel(), 2);
        }
        catch (BadPositionException badPositionException) {
            LOG.error((Object)"Could not install the component tree", (Throwable)badPositionException);
        }
        ConfigurationManager.getInstance().addConfigListener("componentBrowser", new IConfigListener(){

            @Override
            public void valueChanged(String string, Object object) {
                ComponentTree.this.getTreePanel().setVisible("componentBrowser".equals(string) && "Searchable Tree".equals(object));
            }
        });
        this.getTreePanel().setVisible(ConfigurationManager.getInstance().readString("componentBrowser", "Searchable Tree").equals("Searchable Tree"));
        KeyboardFocusManager.getCurrentKeyboardFocusManager().addKeyEventDispatcher(new KeyEventDispatcher(){

            @Override
            public boolean dispatchKeyEvent(KeyEvent keyEvent) {
                if ((ComponentTree.this.canvasPanel.hasFocus() || ComponentTree.this.treePanel.hasFocus()) && keyEvent.getKeyChar() == 'q' && ConfigurationManager.getInstance().readString("componentBrowser", "Searchable Tree").equals("Searchable Tree")) {
                    ComponentTree.this.getTreePanel().getSearchField().requestFocusInWindow();
                    return true;
                }
                return false;
            }
        });
    }

    public TreePanel getTreePanel() {
        if (this.treePanel == null) {
            this.treePanel = new TreePanel(this.plugInPort, this.swingUI);
        }
        return this.treePanel;
    }

    public EnumSet<EventType> getSubscribedEventTypes() {
        return null;
    }

    public void processMessage(EventType eventType, Object ... objectArray) {
    }
}

