/*
 * Decompiled with CFR 0.152.
 */
package org.diylc.appframework.miscutils;

import java.awt.Color;
import java.lang.reflect.Field;
import java.util.Map;
import java.util.Properties;
import org.apache.log4j.Logger;

public class PropertyInjector {
    private static final Logger LOG = Logger.getLogger(PropertyInjector.class);

    private PropertyInjector() {
    }

    public static void injectProperties(Properties properties) {
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            String key = entry.getKey().toString();
            String value = entry.getValue().toString();
            try {
                String className = key.substring(0, key.lastIndexOf(46));
                String fieldName = key.substring(key.lastIndexOf(46) + 1);
                Class<?> clazz = Class.forName(className);
                try {
                    LOG.info((Object)("Injecting " + key + " = " + value));
                    Field field = clazz.getField(fieldName);
                    field.setAccessible(true);
                    Class<?> fieldType = field.getType();
                    if (String.class.isAssignableFrom(fieldType)) {
                        field.set(null, value);
                        continue;
                    }
                    if (Integer.class.isAssignableFrom(fieldType) || Integer.TYPE.isAssignableFrom(fieldType)) {
                        int intValue = Integer.parseInt(value);
                        field.set(null, intValue);
                        continue;
                    }
                    if (Double.class.isAssignableFrom(fieldType) || Double.TYPE.isAssignableFrom(fieldType)) {
                        double doubleValue = Double.parseDouble(value);
                        field.set(null, doubleValue);
                        continue;
                    }
                    if (Boolean.class.isAssignableFrom(fieldType) || Boolean.TYPE.isAssignableFrom(fieldType)) {
                        boolean booleanValue = Boolean.parseBoolean(value);
                        field.set(null, booleanValue);
                        continue;
                    }
                    if (Color.class.isAssignableFrom(fieldType)) {
                        Color color = Color.decode(value);
                        field.set(null, color);
                        continue;
                    }
                    LOG.warn((Object)"Property type not supported.");
                }
                catch (SecurityException e) {
                    LOG.warn((Object)("Could not inject " + key + ". Field access denied: " + fieldName));
                }
                catch (NoSuchFieldException e) {
                    LOG.warn((Object)("Could not inject " + key + ". Field not found: " + fieldName));
                }
                catch (IllegalArgumentException e) {
                    LOG.warn((Object)("Could not inject " + key + ". Illegal access: " + fieldName));
                }
                catch (IllegalAccessException e) {
                    LOG.warn((Object)("Could not inject " + key + ". Field illegal access: " + fieldName));
                }
            }
            catch (StringIndexOutOfBoundsException e) {
                LOG.warn((Object)("Property name does not match format ClassName.FIELD_NAME: " + key));
            }
            catch (ClassNotFoundException e) {
                LOG.warn((Object)("Could not inject " + key + ". Class not found: " + key));
            }
        }
    }
}

