/*
 * Decompiled with CFR 0.152.
 */
package org.diylc.components.boards;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Shape;
import org.diylc.common.SimpleComponentTransformer;
import org.diylc.components.boards.AbstractBoard;
import org.diylc.core.ComponentState;
import org.diylc.core.IDrawingObserver;
import org.diylc.core.Project;
import org.diylc.core.annotations.BomPolicy;
import org.diylc.core.annotations.ComponentDescriptor;
import org.diylc.core.annotations.EditableProperty;
import org.diylc.core.annotations.KeywordPolicy;
import org.diylc.core.annotations.PositiveNonZeroMeasureValidator;
import org.diylc.core.measures.Size;
import org.diylc.core.measures.SizeUnit;
import org.diylc.utils.Constants;

@ComponentDescriptor(name="Marshall Style Perf Board", category="Boards", author="Branislav Stojkovic", zOrder=2.0, instanceNamePrefix="Board", description="Perforated board as found on some Marshall and Trainwreck amps", bomPolicy=BomPolicy.SHOW_ONLY_TYPE_NAME, autoEdit=false, keywordPolicy=KeywordPolicy.SHOW_TAG, keywordTag="Perf Board", transformer=SimpleComponentTransformer.class)
public class MarshallPerfBoard
extends AbstractBoard {
    private static final long serialVersionUID = 1L;
    public static Color BOARD_COLOR = Color.decode("#CD8500");
    public static Color BORDER_COLOR = BOARD_COLOR.darker();
    public static Size SPACING = new Size(Double.valueOf(0.375), SizeUnit.in);
    public static Size HOLE_SIZE = new Size(Double.valueOf(0.125), SizeUnit.in);
    protected Size spacing = SPACING;

    public MarshallPerfBoard() {
        this.boardColor = BOARD_COLOR;
        this.borderColor = BORDER_COLOR;
    }

    @Override
    public void draw(Graphics2D g2d, ComponentState componentState, boolean outlineMode, Project project, IDrawingObserver drawingObserver) {
        Shape clip = g2d.getClip();
        if (this.checkPointsClipped(clip) && !clip.contains(this.firstPoint.x, this.secondPoint.y) && !clip.contains(this.secondPoint.x, this.firstPoint.y)) {
            return;
        }
        super.draw(g2d, componentState, outlineMode, project, drawingObserver);
        if (componentState != ComponentState.DRAGGING) {
            if (this.alpha < MAX_ALPHA) {
                g2d.setComposite(AlphaComposite.getInstance(3, 1.0f * (float)this.alpha / (float)MAX_ALPHA));
            }
            Point p = new Point(this.firstPoint);
            int holeDiameter = this.getClosestOdd((int)HOLE_SIZE.convertToPixels());
            int spacing = (int)this.spacing.convertToPixels();
            while (p.y < this.secondPoint.y - spacing) {
                p.x = this.firstPoint.x;
                p.y += spacing;
                while (p.x < this.secondPoint.x - spacing - holeDiameter) {
                    p.x += spacing;
                    g2d.setColor(Constants.CANVAS_COLOR);
                    g2d.fillOval(p.x - holeDiameter / 2, p.y - holeDiameter / 2, holeDiameter, holeDiameter);
                    g2d.setColor(this.borderColor);
                    g2d.drawOval(p.x - holeDiameter / 2, p.y - holeDiameter / 2, holeDiameter, holeDiameter);
                }
            }
            super.drawCoordinates(g2d, spacing, project);
        }
    }

    @EditableProperty(validatorClass=PositiveNonZeroMeasureValidator.class)
    public Size getSpacing() {
        return this.spacing;
    }

    public void setSpacing(Size spacing) {
        this.spacing = spacing;
    }

    public String getControlPointNodeName(int index) {
        return null;
    }

    public void drawIcon(Graphics2D g2d, int width, int height) {
        int factor = 32 / width;
        g2d.setColor(BOARD_COLOR);
        g2d.fillRect(2 / factor, 2 / factor, width - 4 / factor, height - 4 / factor);
        g2d.setColor(BORDER_COLOR);
        g2d.drawRect(2 / factor, 2 / factor, width - 4 / factor, height - 4 / factor);
        g2d.setColor(Constants.CANVAS_COLOR);
        g2d.fillOval(width / 3 - 2 / factor, width / 3 - 2 / factor, this.getClosestOdd(5.0 / (double)factor), this.getClosestOdd(5.0 / (double)factor));
        g2d.setColor(BORDER_COLOR);
        g2d.drawOval(width / 3 - 2 / factor, width / 3 - 2 / factor, this.getClosestOdd(5.0 / (double)factor), this.getClosestOdd(5.0 / (double)factor));
        g2d.setColor(Constants.CANVAS_COLOR);
        g2d.fillOval(2 * width / 3 - 2 / factor, width / 3 - 2 / factor, this.getClosestOdd(5.0 / (double)factor), this.getClosestOdd(5.0 / (double)factor));
        g2d.setColor(BORDER_COLOR);
        g2d.drawOval(2 * width / 3 - 2 / factor, width / 3 - 2 / factor, this.getClosestOdd(5.0 / (double)factor), this.getClosestOdd(5.0 / (double)factor));
        g2d.setColor(Constants.CANVAS_COLOR);
        g2d.fillOval(width / 3 - 2 / factor, 2 * width / 3 - 2 / factor, this.getClosestOdd(5.0 / (double)factor), this.getClosestOdd(5.0 / (double)factor));
        g2d.setColor(BORDER_COLOR);
        g2d.drawOval(width / 3 - 2 / factor, 2 * width / 3 - 2 / factor, this.getClosestOdd(5.0 / (double)factor), this.getClosestOdd(5.0 / (double)factor));
        g2d.setColor(Constants.CANVAS_COLOR);
        g2d.fillOval(2 * width / 3 - 2 / factor, 2 * width / 3 - 2 / factor, this.getClosestOdd(5.0 / (double)factor), this.getClosestOdd(5.0 / (double)factor));
        g2d.setColor(BORDER_COLOR);
        g2d.drawOval(2 * width / 3 - 2 / factor, 2 * width / 3 - 2 / factor, this.getClosestOdd(5.0 / (double)factor), this.getClosestOdd(5.0 / (double)factor));
    }
}

