/*
 * Decompiled with CFR 0.152.
 */
package org.diylc.components.connectivity;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import org.diylc.common.SimpleComponentTransformer;
import org.diylc.components.AbstractComponent;
import org.diylc.core.ComponentState;
import org.diylc.core.IDrawingObserver;
import org.diylc.core.Project;
import org.diylc.core.VisibilityPolicy;
import org.diylc.core.annotations.BomPolicy;
import org.diylc.core.annotations.ComponentDescriptor;
import org.diylc.core.annotations.EditableProperty;
import org.diylc.core.annotations.PositiveNonZeroMeasureValidator;
import org.diylc.core.measures.Size;
import org.diylc.core.measures.SizeUnit;

@ComponentDescriptor(name="Dot", category="Connectivity", author="Branislav Stojkovic", description="Connector dot", instanceNamePrefix="Dot", zOrder=4.0, bomPolicy=BomPolicy.NEVER_SHOW, autoEdit=false, transformer=SimpleComponentTransformer.class)
public class Dot
extends AbstractComponent<Void> {
    private static final long serialVersionUID = 1L;
    public static Size SIZE = new Size(Double.valueOf(1.0), SizeUnit.mm);
    public static Color COLOR = Color.black;
    private Size size = SIZE;
    private Color color = COLOR;
    private Point point = new Point(0, 0);

    public void draw(Graphics2D g2d, ComponentState componentState, boolean outlineMode, Project project, IDrawingObserver drawingObserver) {
        if (this.checkPointsClipped(g2d.getClip())) {
            return;
        }
        int diameter = this.getClosestOdd((int)this.getSize().convertToPixels());
        g2d.setColor(componentState == ComponentState.SELECTED || componentState == ComponentState.DRAGGING ? SELECTION_COLOR : this.color);
        g2d.fillOval(this.point.x - diameter / 2, this.point.y - diameter / 2, diameter, diameter);
    }

    public void drawIcon(Graphics2D g2d, int width, int height) {
        int diameter = 7 * width / 32;
        g2d.setColor(COLOR);
        g2d.fillOval((width - diameter) / 2, (height - diameter) / 2, diameter, diameter);
    }

    @EditableProperty(validatorClass=PositiveNonZeroMeasureValidator.class)
    public Size getSize() {
        return this.size;
    }

    public void setSize(Size size) {
        this.size = size;
    }

    public String getName() {
        return super.getName();
    }

    public int getControlPointCount() {
        return 1;
    }

    public boolean isControlPointSticky(int index) {
        return true;
    }

    public VisibilityPolicy getControlPointVisibilityPolicy(int index) {
        return VisibilityPolicy.NEVER;
    }

    public Point getControlPoint(int index) {
        return this.point;
    }

    public void setControlPoint(Point point, int index) {
        this.point.setLocation(point);
    }

    @EditableProperty(name="Color")
    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public Void getValue() {
        return null;
    }

    public void setValue(Void value) {
    }

    public String getControlPointNodeName(int index) {
        return null;
    }
}

