/*
 * Decompiled with CFR 0.152.
 */
package org.diylc.components.connectivity;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Path2D;
import org.diylc.common.ObjectCache;
import org.diylc.common.SimpleComponentTransformer;
import org.diylc.components.AbstractCurvedComponent;
import org.diylc.components.connectivity.AWG;
import org.diylc.core.ComponentState;
import org.diylc.core.IContinuity;
import org.diylc.core.IDrawingObserver;
import org.diylc.core.annotations.BomPolicy;
import org.diylc.core.annotations.ComponentDescriptor;
import org.diylc.core.annotations.EditableProperty;

@ComponentDescriptor(name="Hookup Wire", author="Branislav Stojkovic", category="Connectivity", instanceNamePrefix="W", description="Flexible wire with two control points", zOrder=4.0, flexibleZOrder=true, bomPolicy=BomPolicy.NEVER_SHOW, autoEdit=false, transformer=SimpleComponentTransformer.class)
public class HookupWire
extends AbstractCurvedComponent<Void>
implements IContinuity {
    private static final long serialVersionUID = 1L;
    public static Color COLOR = Color.green;
    public static Color STRIPE_COLOR = Color.yellow;
    public static double INSULATION_THICKNESS_PCT = 0.3;
    protected AWG gauge = AWG._22;
    protected boolean striped = false;
    protected Color stripeColor = STRIPE_COLOR;

    protected Color getDefaultColor() {
        return COLOR;
    }

    protected void drawCurve(Path2D curve, Graphics2D g2d, ComponentState componentState, IDrawingObserver drawingObserver) {
        int thickness = (int)(this.gauge.diameterIn() * 200.0 * (1.0 + 2.0 * INSULATION_THICKNESS_PCT)) - 1;
        Color curveColor = componentState == ComponentState.SELECTED || componentState == ComponentState.DRAGGING ? SELECTION_COLOR : this.color;
        g2d.setColor(curveColor);
        Stroke stroke = null;
        switch (this.getStyle()) {
            case SOLID: {
                stroke = ObjectCache.getInstance().fetchBasicStroke((float)thickness);
                break;
            }
            case DASHED: {
                stroke = ObjectCache.getInstance().fetchStroke((float)thickness, new float[]{thickness * 2, thickness * 3}, (float)(thickness * 4), 2);
                break;
            }
            case DOTTED: {
                stroke = ObjectCache.getInstance().fetchStroke((float)thickness, new float[]{thickness / 4, thickness * 3}, 0.0f, 1);
            }
        }
        Shape s = stroke.createStrokedShape(curve);
        g2d.fill(s);
        if (this.getStriped()) {
            stroke = ObjectCache.getInstance().fetchStroke((float)thickness, new float[]{thickness / 2, thickness * 2}, (float)(thickness * 10), 0);
            Shape stripe = stroke.createStrokedShape(curve);
            g2d.setColor(this.getStripeColor());
            drawingObserver.stopTracking();
            g2d.fill(stripe);
            drawingObserver.startTracking();
        }
        if (componentState == ComponentState.NORMAL) {
            g2d.setColor(this.color.darker());
            g2d.setStroke(ObjectCache.getInstance().fetchBasicStroke(1.0f));
            g2d.draw(s);
        }
    }

    @EditableProperty(name="AWG")
    public AWG getGauge() {
        return this.gauge;
    }

    public void setGauge(AWG gauge) {
        this.gauge = gauge;
    }

    public Void getValue() {
        return null;
    }

    public void setValue(Void value) {
    }

    @EditableProperty(name="Stripe")
    public boolean getStriped() {
        return this.striped;
    }

    public void setStriped(boolean striped) {
        this.striped = striped;
    }

    @EditableProperty(name="Stripe Color")
    public Color getStripeColor() {
        if (this.stripeColor == null) {
            this.stripeColor = STRIPE_COLOR;
        }
        return this.stripeColor;
    }

    public void setStripeColor(Color stripeColor) {
        this.stripeColor = stripeColor;
    }

    public boolean arePointsConnected(int index1, int index2) {
        return Math.abs(index1 - index2) == this.getControlPointCount() - 1;
    }
}

