/*
 * Decompiled with CFR 0.152.
 */
package org.diylc.components.electromechanical;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Rectangle2D;
import org.diylc.appframework.miscutils.ConfigurationManager;
import org.diylc.common.Display;
import org.diylc.common.ObjectCache;
import org.diylc.common.OrientationHV;
import org.diylc.components.AbstractMultiPartComponent;
import org.diylc.core.ComponentState;
import org.diylc.core.IDrawingObserver;
import org.diylc.core.Project;
import org.diylc.core.Theme;
import org.diylc.core.VisibilityPolicy;
import org.diylc.core.annotations.ComponentDescriptor;
import org.diylc.core.annotations.EditableProperty;
import org.diylc.core.measures.Size;
import org.diylc.core.measures.SizeUnit;
import org.diylc.utils.Constants;

@ComponentDescriptor(name="Fuse Holder (Panel)", category="Electro-Mechanical", author="Branislav Stojkovic", description="Panel mounted fuse holder", zOrder=4.0, instanceNamePrefix="FH", autoEdit=false)
public class FuseHolderPanel
extends AbstractMultiPartComponent<String> {
    private static final long serialVersionUID = 1L;
    private static Size SPACING = new Size(Double.valueOf(0.2), SizeUnit.in);
    private static Size LUG_WIDTH = new Size(Double.valueOf(4.0), SizeUnit.mm);
    private static Size LUG_THICKNESS = new Size(Double.valueOf(0.8), SizeUnit.mm);
    private static Size INNER_DIAMETER = new Size(Double.valueOf(0.5), SizeUnit.in);
    private static Size OUTER_DIAMETER = new Size(Double.valueOf(0.6), SizeUnit.in);
    private static Color BODY_COLOR = Color.decode("#555555");
    private static Color BORDER_COLOR = BODY_COLOR.darker();
    private static Color LABEL_COLOR = Color.white;
    protected Point[] controlPoints = new Point[]{new Point(0, 0), new Point(0, 0)};
    protected transient Area[] body;
    protected String name;
    protected String value = "";
    private OrientationHV orientation = OrientationHV.VERTICAL;
    private boolean hasFuse = false;
    private Display display = Display.VALUE;
    private Color bodyColor = BODY_COLOR;
    private Color borderColor = BORDER_COLOR;
    private Color labelColor = LABEL_COLOR;

    public FuseHolderPanel() {
        this.updateControlPoints();
    }

    private void updateControlPoints() {
        Point firstPoint = this.controlPoints[0];
        int spacing = (int)SPACING.convertToPixels();
        this.controlPoints[1].setLocation(firstPoint.x + (this.orientation == OrientationHV.HORIZONTAL ? spacing : 0), firstPoint.y + (this.orientation == OrientationHV.HORIZONTAL ? 0 : spacing));
    }

    public Point getControlPoint(int index) {
        return this.controlPoints[index];
    }

    public boolean isControlPointSticky(int index) {
        return true;
    }

    public VisibilityPolicy getControlPointVisibilityPolicy(int index) {
        return VisibilityPolicy.NEVER;
    }

    public int getControlPointCount() {
        return this.controlPoints.length;
    }

    public void setControlPoint(Point point, int index) {
        this.controlPoints[index].setLocation(point);
        this.body = null;
    }

    @EditableProperty
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @EditableProperty
    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    @EditableProperty
    public OrientationHV getOrientation() {
        return this.orientation;
    }

    public void setOrientation(OrientationHV orientation) {
        this.orientation = orientation;
        this.updateControlPoints();
        this.body = null;
    }

    @EditableProperty(name="Fuse")
    public boolean getHasFuse() {
        return this.hasFuse;
    }

    public void setHasFuse(boolean hasFuse) {
        this.hasFuse = hasFuse;
        this.body = null;
    }

    public void draw(Graphics2D g2d, ComponentState componentState, boolean outlineMode, Project project, IDrawingObserver drawingObserver) {
        if (this.checkPointsClipped(g2d.getClip())) {
            return;
        }
        Area[] body = this.getBody();
        Theme theme = (Theme)ConfigurationManager.getInstance().readObject("theme", (Object)Constants.DEFAULT_THEME);
        if (body != null) {
            Composite oldComposite = g2d.getComposite();
            if (this.alpha < MAX_ALPHA) {
                g2d.setComposite(AlphaComposite.getInstance(3, 1.0f * (float)this.alpha / (float)MAX_ALPHA));
            }
            g2d.setColor(outlineMode ? Constants.TRANSPARENT_COLOR : this.getBodyColor());
            for (Area a : body) {
                if (a == null) continue;
                g2d.fill(a);
                break;
            }
            g2d.setComposite(oldComposite);
            g2d.setStroke(ObjectCache.getInstance().fetchBasicStroke(1.0f));
            Color finalBorderColor = outlineMode ? theme.getOutlineColor() : this.getBorderColor();
            g2d.setColor(finalBorderColor);
            for (Area a : body) {
                if (a == null) continue;
                g2d.draw(a);
            }
        }
        drawingObserver.stopTracking();
        int lugWidth = this.getClosestOdd((int)LUG_WIDTH.convertToPixels());
        int lugHeight = this.getClosestOdd((int)LUG_THICKNESS.convertToPixels());
        if (this.orientation == OrientationHV.HORIZONTAL) {
            int p = lugHeight;
            lugHeight = lugWidth;
            lugWidth = p;
        }
        for (Point p : this.controlPoints) {
            if (outlineMode) {
                g2d.setColor(theme.getOutlineColor());
                g2d.drawRect(p.x - lugWidth / 2, p.y - lugHeight / 2, lugWidth, lugHeight);
                continue;
            }
            g2d.setColor(METAL_COLOR);
            g2d.fillRect(p.x - lugWidth / 2, p.y - lugHeight / 2, lugWidth, lugHeight);
        }
        g2d.setFont(project.getFont());
        Color finalLabelColor = outlineMode ? (componentState == ComponentState.SELECTED || componentState == ComponentState.DRAGGING ? LABEL_COLOR_SELECTED : theme.getOutlineColor()) : (componentState == ComponentState.SELECTED || componentState == ComponentState.DRAGGING ? LABEL_COLOR_SELECTED : this.labelColor);
        g2d.setColor(finalLabelColor);
        FontMetrics fontMetrics = g2d.getFontMetrics(g2d.getFont());
        String label = "";
        String string = label = this.display == Display.VALUE ? this.getValue() : this.getName();
        if (this.display == Display.NONE) {
            label = "";
        }
        if (this.display == Display.BOTH) {
            label = this.getName() + "  " + (this.getValue() == null ? "" : this.getValue().toString());
        }
        Rectangle2D rect = fontMetrics.getStringBounds(label, g2d);
        int textHeight = (int)rect.getHeight();
        int textWidth = (int)rect.getWidth();
        Rectangle bounds = body[0].getBounds();
        int x = bounds.x + (bounds.width - textWidth) / 2;
        int y = bounds.y + (bounds.height - textHeight) / 2 + fontMetrics.getAscent();
        g2d.drawString(label, x, y);
        this.drawSelectionOutline(g2d, componentState, outlineMode, project, drawingObserver);
    }

    @Override
    public Area[] getBody() {
        if (this.body == null) {
            Point firstPoint = this.controlPoints[0];
            int spacing = (int)SPACING.convertToPixels();
            int outerDiameter = (int)OUTER_DIAMETER.convertToPixels();
            int innerDiameter = (int)INNER_DIAMETER.convertToPixels();
            int dx = 0;
            int dy = 0;
            if (this.orientation == OrientationHV.HORIZONTAL) {
                dx = spacing / 2;
            } else {
                dy = spacing / 2;
            }
            this.body = new Area[2];
            this.body[0] = new Area(new Ellipse2D.Double(firstPoint.x + dx - outerDiameter / 2, firstPoint.y + dy - outerDiameter / 2, outerDiameter, outerDiameter));
            this.body[1] = new Area(new Ellipse2D.Double(firstPoint.x + dx - innerDiameter / 2, firstPoint.y + dy - innerDiameter / 2, innerDiameter, innerDiameter));
        }
        return this.body;
    }

    public void drawIcon(Graphics2D g2d, int width, int height) {
        g2d.setColor(BODY_COLOR);
        int margin = (int)(2.0f * (float)width / 32.0f);
        int terminal = (int)(5.0f * (float)width / 32.0f);
        int terminalSpacingV = width / 4;
        Ellipse2D.Double body = new Ellipse2D.Double(margin, margin, width - 2 * margin, height - 2 * margin);
        g2d.fill(body);
        g2d.setColor(BORDER_COLOR);
        g2d.draw(body);
        g2d.setColor(METAL_COLOR);
        g2d.setStroke(ObjectCache.getInstance().fetchBasicStroke(2.0f));
        g2d.drawLine(width / 2 - terminal / 2, height / 2 - terminalSpacingV / 2, width / 2 + terminal / 2, height / 2 - terminalSpacingV / 2);
        g2d.drawLine(width / 2 - terminal / 2, height / 2 + terminalSpacingV / 2, width / 2 + terminal / 2, height / 2 + terminalSpacingV / 2);
    }

    @EditableProperty(name="Body")
    public Color getBodyColor() {
        if (this.bodyColor == null) {
            this.bodyColor = BODY_COLOR;
        }
        return this.bodyColor;
    }

    public void setBodyColor(Color bodyColor) {
        this.bodyColor = bodyColor;
    }

    @EditableProperty(name="Border")
    public Color getBorderColor() {
        if (this.borderColor == null) {
            this.borderColor = BORDER_COLOR;
        }
        return this.borderColor;
    }

    public void setBorderColor(Color borderColor) {
        this.borderColor = borderColor;
    }

    @EditableProperty
    public Display getDisplay() {
        return this.display;
    }

    public void setDisplay(Display display) {
        this.display = display;
    }

    @EditableProperty(name="Label")
    public Color getLabelColor() {
        return this.labelColor;
    }

    public void setLabelColor(Color labelColor) {
        this.labelColor = labelColor;
    }

    public boolean canPointMoveFreely(int pointIndex) {
        return false;
    }
}

