/*
 * Decompiled with CFR 0.152.
 */
package org.diylc.components.electromechanical;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.RoundRectangle2D;
import org.diylc.appframework.miscutils.ConfigurationManager;
import org.diylc.common.ObjectCache;
import org.diylc.common.Orientation;
import org.diylc.components.AbstractMultiPartComponent;
import org.diylc.components.RoundedPolygon;
import org.diylc.core.ComponentState;
import org.diylc.core.IDrawingObserver;
import org.diylc.core.Project;
import org.diylc.core.Theme;
import org.diylc.core.VisibilityPolicy;
import org.diylc.core.annotations.ComponentDescriptor;
import org.diylc.core.annotations.EditableProperty;
import org.diylc.core.measures.Size;
import org.diylc.core.measures.SizeUnit;
import org.diylc.utils.Constants;

@ComponentDescriptor(name="IEC Socket", category="Electro-Mechanical", author="Branislav Stojkovic", description="Panel mounted IEC power socket", zOrder=4.0, instanceNamePrefix="IEC", autoEdit=false)
public class IECSocket
extends AbstractMultiPartComponent<String> {
    private static final long serialVersionUID = 1L;
    private static Size HORIZONTAL_SPACING = new Size(Double.valueOf(0.3), SizeUnit.in);
    private static Size VERTICAL_SPACING = new Size(Double.valueOf(0.2), SizeUnit.in);
    private static Size LUG_WIDTH = new Size(Double.valueOf(4.0), SizeUnit.mm);
    private static Size LUG_THICKNESS = new Size(Double.valueOf(0.8), SizeUnit.mm);
    private static Size SIMPLE_CUTOUT_LENGTH = new Size(Double.valueOf(27.5), SizeUnit.mm);
    private static Size SIMPLE_CUTOUT_WIDTH = new Size(Double.valueOf(19.5), SizeUnit.mm);
    private static Size SIMPLE_BASE_LENGTH = new Size(Double.valueOf(30.8), SizeUnit.mm);
    private static Size SIMPLE_BASE_WIDTH = new Size(Double.valueOf(22.6), SizeUnit.mm);
    private static Size SIMPLE_BASE_RADIUS = new Size(Double.valueOf(3.0), SizeUnit.mm);
    private static Size SIMPLE_CUTOUT_SLANT = new Size(Double.valueOf(5.0), SizeUnit.mm);
    private static Size SIMPLE_CUTOUT_RADIUS = new Size(Double.valueOf(1.0), SizeUnit.mm);
    private static Size SIMPLE_LENGTH = new Size(Double.valueOf(50.0), SizeUnit.mm);
    private static Size SIMPLE_OUTER_RADIUS = new Size(Double.valueOf(6.0), SizeUnit.mm);
    private static Size HOLE_SPACING = new Size(Double.valueOf(40.0), SizeUnit.mm);
    private static Size HOLE_DIAMETER = new Size(Double.valueOf(3.0), SizeUnit.mm);
    private static Color BODY_COLOR = Color.decode("#555555");
    private static Color BORDER_COLOR = BODY_COLOR.darker();
    protected Point[] controlPoints = new Point[]{new Point(0, 0), new Point(0, 0), new Point(0, 0)};
    protected transient Area[] body;
    protected String name;
    protected String value;
    private Orientation orientation = Orientation.DEFAULT;
    private Color bodyColor = BODY_COLOR;
    private Color borderColor = BORDER_COLOR;

    public IECSocket() {
        this.updateControlPoints();
    }

    private void updateControlPoints() {
        Point firstPoint = this.controlPoints[0];
        int hSpacing = (int)HORIZONTAL_SPACING.convertToPixels();
        int vSpacing = (int)VERTICAL_SPACING.convertToPixels();
        this.controlPoints[1].setLocation(firstPoint.x - hSpacing, firstPoint.y + vSpacing);
        this.controlPoints[2].setLocation(firstPoint.x + hSpacing, firstPoint.y + vSpacing);
        if (this.orientation != Orientation.DEFAULT) {
            double theta = 0.0;
            switch (this.orientation) {
                case _90: {
                    theta = 1.5707963267948966;
                    break;
                }
                case _180: {
                    theta = Math.PI;
                    break;
                }
                case _270: {
                    theta = 4.71238898038469;
                }
            }
            AffineTransform rotation = AffineTransform.getRotateInstance(theta, firstPoint.x, firstPoint.y);
            for (int i = 1; i < this.controlPoints.length; ++i) {
                rotation.transform(this.controlPoints[i], this.controlPoints[i]);
            }
        }
    }

    public Point getControlPoint(int index) {
        return this.controlPoints[index];
    }

    public boolean isControlPointSticky(int index) {
        return true;
    }

    public VisibilityPolicy getControlPointVisibilityPolicy(int index) {
        return VisibilityPolicy.NEVER;
    }

    public int getControlPointCount() {
        return this.controlPoints.length;
    }

    public void setControlPoint(Point point, int index) {
        this.controlPoints[index].setLocation(point);
        this.body = null;
    }

    @EditableProperty
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    @EditableProperty
    public Orientation getOrientation() {
        if (this.orientation == null) {
            this.orientation = Orientation.DEFAULT;
        }
        return this.orientation;
    }

    public void setOrientation(Orientation orientation) {
        this.orientation = orientation;
        this.updateControlPoints();
        this.body = null;
    }

    public void draw(Graphics2D g2d, ComponentState componentState, boolean outlineMode, Project project, IDrawingObserver drawingObserver) {
        if (this.checkPointsClipped(g2d.getClip())) {
            return;
        }
        Area[] body = this.getBody();
        Theme theme = (Theme)ConfigurationManager.getInstance().readObject("theme", (Object)Constants.DEFAULT_THEME);
        if (body != null) {
            Composite oldComposite = g2d.getComposite();
            if (this.alpha < MAX_ALPHA) {
                g2d.setComposite(AlphaComposite.getInstance(3, 1.0f * (float)this.alpha / (float)MAX_ALPHA));
            }
            g2d.setColor(outlineMode ? Constants.TRANSPARENT_COLOR : this.getBodyColor());
            for (Area a : body) {
                if (a == null) continue;
                g2d.fill(a);
                break;
            }
            g2d.setComposite(oldComposite);
            g2d.setStroke(ObjectCache.getInstance().fetchBasicStroke(1.0f));
            Color finalBorderColor = outlineMode ? theme.getOutlineColor() : this.getBorderColor();
            g2d.setColor(finalBorderColor);
            for (Area a : body) {
                if (a == null) continue;
                g2d.draw(a);
            }
        }
        drawingObserver.stopTracking();
        int lugWidth = this.getClosestOdd((int)LUG_WIDTH.convertToPixels());
        int lugHeight = this.getClosestOdd((int)LUG_THICKNESS.convertToPixels());
        if (this.orientation == Orientation._90 || this.orientation == Orientation._270) {
            int p = lugHeight;
            lugHeight = lugWidth;
            lugWidth = p;
        }
        for (Point p : this.controlPoints) {
            if (outlineMode) {
                g2d.setColor(theme.getOutlineColor());
                g2d.drawRect(p.x - lugWidth / 2, p.y - lugHeight / 2, lugWidth, lugHeight);
                continue;
            }
            g2d.setColor(METAL_COLOR);
            g2d.fillRect(p.x - lugWidth / 2, p.y - lugHeight / 2, lugWidth, lugHeight);
        }
        this.drawSelectionOutline(g2d, componentState, outlineMode, project, drawingObserver);
    }

    @Override
    public Area[] getBody() {
        if (this.body == null) {
            Point firstPoint = this.controlPoints[0];
            int vSpacing = (int)VERTICAL_SPACING.convertToPixels();
            double baseWidth = SIMPLE_BASE_WIDTH.convertToPixels();
            double holeDiameter = HOLE_DIAMETER.convertToPixels();
            double holeSpacing = HOLE_SPACING.convertToPixels();
            this.body = new Area[3];
            double cutoutRadius = SIMPLE_CUTOUT_RADIUS.convertToPixels();
            double baseRadius = SIMPLE_BASE_RADIUS.convertToPixels();
            double cutoutLength = SIMPLE_CUTOUT_LENGTH.convertToPixels();
            double cutoutWidth = SIMPLE_CUTOUT_WIDTH.convertToPixels();
            double cutoutSlant = SIMPLE_CUTOUT_SLANT.convertToPixels();
            double baseLength = SIMPLE_BASE_LENGTH.convertToPixels();
            double length = SIMPLE_LENGTH.convertToPixels();
            double outerRadius = SIMPLE_OUTER_RADIUS.convertToPixels();
            Point[] outerPoints = new Point[]{new Point(Math.round(firstPoint.x), (int)Math.round((double)(firstPoint.y + vSpacing / 2) - baseWidth / 2.0)), new Point((int)Math.round((double)firstPoint.x + baseLength / 2.0), (int)Math.round((double)(firstPoint.y + vSpacing / 2) - baseWidth / 2.0)), new Point((int)Math.round((double)firstPoint.x + length / 2.0), Math.round(firstPoint.y + vSpacing / 2)), new Point((int)Math.round((double)firstPoint.x + baseLength / 2.0), (int)Math.round((double)(firstPoint.y + vSpacing / 2) + baseWidth / 2.0)), new Point((int)Math.round((double)firstPoint.x - baseLength / 2.0), (int)Math.round((double)(firstPoint.y + vSpacing / 2) + baseWidth / 2.0)), new Point((int)Math.round((double)firstPoint.x - length / 2.0), Math.round(firstPoint.y + vSpacing / 2)), new Point((int)Math.round((double)firstPoint.x - baseLength / 2.0), (int)Math.round((double)(firstPoint.y + vSpacing / 2) - baseWidth / 2.0))};
            double[] outerRadiuses = new double[]{baseRadius / 2.0, outerRadius, baseRadius / 2.0, baseRadius / 2.0, outerRadius, baseRadius / 2.0};
            this.body[0] = new Area(new RoundedPolygon(outerPoints, outerRadiuses));
            this.body[0].subtract(new Area(new Ellipse2D.Double((double)firstPoint.x - holeSpacing / 2.0 - holeDiameter / 2.0, (double)(firstPoint.y + vSpacing / 2) - holeDiameter / 2.0, holeDiameter, holeDiameter)));
            this.body[0].subtract(new Area(new Ellipse2D.Double((double)firstPoint.x + holeSpacing / 2.0 - holeDiameter / 2.0, (double)(firstPoint.y + vSpacing / 2) - holeDiameter / 2.0, holeDiameter, holeDiameter)));
            this.body[1] = new Area(new RoundRectangle2D.Double((double)firstPoint.x - baseLength / 2.0, (double)(firstPoint.y + vSpacing / 2) - baseWidth / 2.0, baseLength, baseWidth, baseRadius, baseRadius));
            Point[] cutoutPoints = new Point[]{new Point(firstPoint.x, (int)((double)(firstPoint.y + vSpacing / 2) - cutoutWidth / 2.0)), new Point((int)((double)firstPoint.x + cutoutLength / 2.0 - cutoutSlant), (int)((double)(firstPoint.y + vSpacing / 2) - cutoutWidth / 2.0)), new Point((int)((double)firstPoint.x + cutoutLength / 2.0), (int)((double)(firstPoint.y + vSpacing / 2) - cutoutWidth / 2.0 + cutoutSlant)), new Point((int)((double)firstPoint.x + cutoutLength / 2.0), (int)((double)(firstPoint.y + vSpacing / 2) + cutoutWidth / 2.0)), new Point((int)((double)firstPoint.x - cutoutLength / 2.0), (int)((double)(firstPoint.y + vSpacing / 2) + cutoutWidth / 2.0)), new Point((int)((double)firstPoint.x - cutoutLength / 2.0), (int)((double)(firstPoint.y + vSpacing / 2) - cutoutWidth / 2.0 + cutoutSlant)), new Point((int)((double)firstPoint.x - cutoutLength / 2.0 + cutoutSlant), (int)((double)(firstPoint.y + vSpacing / 2) - cutoutWidth / 2.0))};
            double[] cutoutRadiuses = new double[]{cutoutRadius};
            this.body[2] = new Area(new RoundedPolygon(cutoutPoints, cutoutRadiuses));
            if (this.orientation != Orientation.DEFAULT) {
                double theta = 0.0;
                switch (this.orientation) {
                    case _90: {
                        theta = 1.5707963267948966;
                        break;
                    }
                    case _180: {
                        theta = Math.PI;
                        break;
                    }
                    case _270: {
                        theta = 4.71238898038469;
                    }
                }
                AffineTransform rotation = AffineTransform.getRotateInstance(theta, firstPoint.x, firstPoint.y);
                for (Area a : this.body) {
                    if (a == null) continue;
                    a.transform(rotation);
                }
            }
        }
        return this.body;
    }

    public void drawIcon(Graphics2D g2d, int width, int height) {
        g2d.setColor(BODY_COLOR);
        int margin = (int)(2.0f * (float)width / 32.0f);
        int slant = (int)(5.0f * (float)width / 32.0f);
        int terminal = (int)(4.0f * (float)width / 32.0f);
        int terminalSpacingH = (int)(7.0f * (float)width / 32.0f);
        int terminalSpacingV = (int)(4.0f * (float)width / 32.0f);
        RoundedPolygon poly = new RoundedPolygon(new Point[]{new Point(width / 2, height / 5), new Point(width - margin - slant, height / 5), new Point(width - margin, height / 5 + slant), new Point(width - margin, height * 4 / 5), new Point(margin, height * 4 / 5), new Point(margin, height / 5 + slant), new Point(margin + slant, height / 5)}, new double[]{2.0});
        g2d.fill(poly);
        g2d.setColor(BORDER_COLOR);
        g2d.draw(poly);
        g2d.setColor(METAL_COLOR);
        for (int i = -1; i <= 1; ++i) {
            g2d.drawLine(width / 2 + terminalSpacingH * i - terminal / 2, height / 2 + terminalSpacingV * Math.abs(i) - terminalSpacingV / 2, width / 2 + terminalSpacingH * i + terminal / 2, height / 2 + terminalSpacingV * Math.abs(i) - terminalSpacingV / 2);
        }
    }

    @EditableProperty(name="Body")
    public Color getBodyColor() {
        if (this.bodyColor == null) {
            this.bodyColor = BODY_COLOR;
        }
        return this.bodyColor;
    }

    public void setBodyColor(Color bodyColor) {
        this.bodyColor = bodyColor;
    }

    @EditableProperty(name="Border")
    public Color getBorderColor() {
        if (this.borderColor == null) {
            this.borderColor = BORDER_COLOR;
        }
        return this.borderColor;
    }

    public void setBorderColor(Color borderColor) {
        this.borderColor = borderColor;
    }

    public boolean canPointMoveFreely(int pointIndex) {
        return false;
    }
}

