/*
 * Decompiled with CFR 0.152.
 */
package org.diylc.components.guitar;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import org.diylc.appframework.miscutils.ConfigurationManager;
import org.diylc.common.ObjectCache;
import org.diylc.common.Orientation;
import org.diylc.components.AbstractTransparentComponent;
import org.diylc.core.ComponentState;
import org.diylc.core.IDrawingObserver;
import org.diylc.core.ISwitch;
import org.diylc.core.Project;
import org.diylc.core.Theme;
import org.diylc.core.VisibilityPolicy;
import org.diylc.core.annotations.ComponentDescriptor;
import org.diylc.core.annotations.EditableProperty;
import org.diylc.core.measures.Size;
import org.diylc.core.measures.SizeUnit;
import org.diylc.utils.Constants;

@ComponentDescriptor(name="LP Toggle Switch", category="Guitar", author="Branislav Stojkovic", description="Les Paul style 3 position toggle switch", zOrder=4.0, instanceNamePrefix="SW")
public class LPSwitch
extends AbstractTransparentComponent<String>
implements ISwitch {
    private static final long serialVersionUID = 1L;
    private static Color BASE_COLOR = Color.lightGray;
    private static Color WAFER_COLOR = Color.decode("#CD8500");
    private static Size LENGTH = new Size(Double.valueOf(1.3), SizeUnit.in);
    private static Size BASE_LENGTH = new Size(Double.valueOf(18.0), SizeUnit.mm);
    private static Size WAFER_THICKNESS = new Size(Double.valueOf(0.05), SizeUnit.in);
    private static Size TERMINAL_SPACING = new Size(Double.valueOf(0.2), SizeUnit.in);
    private String value = "";
    private Point[] controlPoints = new Point[]{new Point(0, 0), new Point(0, 0), new Point(0, 0), new Point(0, 0)};
    transient Shape[] body;
    private Orientation orientation = Orientation.DEFAULT;

    public LPSwitch() {
        this.updateControlPoints();
    }

    public void draw(Graphics2D g2d, ComponentState componentState, boolean outlineMode, Project project, IDrawingObserver drawingObserver) {
        Color finalBorderColor;
        Theme theme;
        Shape[] body = this.getBody();
        g2d.setStroke(ObjectCache.getInstance().fetchBasicStroke(1.0f));
        if (componentState != ComponentState.DRAGGING) {
            Composite oldComposite = g2d.getComposite();
            if (this.alpha < MAX_ALPHA) {
                g2d.setComposite(AlphaComposite.getInstance(3, 1.0f * (float)this.alpha / (float)MAX_ALPHA));
            }
            g2d.setColor(outlineMode ? Constants.TRANSPARENT_COLOR : WAFER_COLOR);
            g2d.fill(body[1]);
            g2d.setColor(outlineMode ? Constants.TRANSPARENT_COLOR : BASE_COLOR);
            g2d.fill(body[0]);
            g2d.setComposite(oldComposite);
        }
        if (outlineMode) {
            theme = (Theme)ConfigurationManager.getInstance().readObject("theme", (Object)Constants.DEFAULT_THEME);
            finalBorderColor = componentState == ComponentState.SELECTED || componentState == ComponentState.DRAGGING ? SELECTION_COLOR : theme.getOutlineColor();
        } else {
            finalBorderColor = componentState == ComponentState.SELECTED || componentState == ComponentState.DRAGGING ? SELECTION_COLOR : WAFER_COLOR.darker();
        }
        g2d.setColor(finalBorderColor);
        g2d.draw(body[0]);
        if (outlineMode) {
            theme = (Theme)ConfigurationManager.getInstance().readObject("theme", (Object)Constants.DEFAULT_THEME);
            finalBorderColor = componentState == ComponentState.SELECTED || componentState == ComponentState.DRAGGING ? SELECTION_COLOR : theme.getOutlineColor();
        } else {
            finalBorderColor = componentState == ComponentState.SELECTED || componentState == ComponentState.DRAGGING ? SELECTION_COLOR : BASE_COLOR.darker();
        }
        g2d.setColor(finalBorderColor);
        g2d.draw(body[1]);
        g2d.setStroke(ObjectCache.getInstance().fetchBasicStroke(2.0f));
        g2d.setColor(METAL_COLOR);
        g2d.draw(body[2]);
    }

    public Shape[] getBody() {
        if (this.body == null) {
            this.body = new Shape[3];
            int x = this.controlPoints[0].x;
            int y = this.controlPoints[0].y;
            int baseLength = (int)BASE_LENGTH.convertToPixels();
            int length = (int)LENGTH.convertToPixels();
            int waferThickness = this.getClosestOdd(WAFER_THICKNESS.convertToPixels());
            Rectangle2D.Double ground = new Rectangle2D.Double(x - waferThickness / 2, y, waferThickness - 1, baseLength + (length - baseLength) / 2);
            this.body[0] = new Area(ground);
            int bodyY = y + (length - baseLength) / 2;
            Area waferArea = new Area();
            waferArea.add(new Area(new Rectangle2D.Double(x + waferThickness / 2, bodyY, waferThickness * 3, baseLength)));
            waferArea.add(new Area(new Rectangle2D.Double(x - waferThickness * 5 / 2, bodyY, waferThickness, baseLength)));
            waferArea.add(new Area(new Rectangle2D.Double(x + waferThickness * 3 / 2, bodyY, waferThickness, baseLength)));
            waferArea.add(new Area(new Rectangle2D.Double(x - waferThickness * 7 / 2, bodyY, waferThickness * 3, baseLength)));
            this.body[1] = waferArea;
            double theta = 0.0;
            if (this.orientation != Orientation.DEFAULT) {
                switch (this.orientation) {
                    case _90: {
                        theta = 1.5707963267948966;
                        break;
                    }
                    case _180: {
                        theta = Math.PI;
                        break;
                    }
                    case _270: {
                        theta = 4.71238898038469;
                    }
                }
            }
            int terminalSpacing = (int)TERMINAL_SPACING.convertToPixels();
            GeneralPath terminalPath = new GeneralPath(0);
            terminalPath.moveTo(x - waferThickness * 3 / 2, bodyY + 1);
            terminalPath.lineTo(x - waferThickness * 3 / 2, bodyY + baseLength);
            terminalPath.lineTo(x, y + length);
            terminalPath.moveTo(x + waferThickness * 3 / 2, bodyY + 1);
            terminalPath.lineTo(x + waferThickness * 3 / 2, bodyY + baseLength);
            terminalPath.lineTo(x, y + length);
            terminalPath.moveTo(x - waferThickness * 5 / 2, bodyY + 1);
            terminalPath.lineTo(x - waferThickness * 5 / 2, bodyY + baseLength);
            terminalPath.lineTo(x - terminalSpacing, y + length);
            terminalPath.moveTo(x + waferThickness * 5 / 2, bodyY + 1);
            terminalPath.lineTo(x + waferThickness * 5 / 2, bodyY + baseLength);
            terminalPath.lineTo(x + terminalSpacing, y + length);
            this.body[2] = terminalPath;
            if (theta != 0.0) {
                AffineTransform rotation = AffineTransform.getRotateInstance(theta, x, y);
                for (int i = 0; i < this.body.length; ++i) {
                    Shape shape = this.body[i];
                    if (shape instanceof Area) {
                        Area area = (Area)shape;
                        area.transform(rotation);
                        continue;
                    }
                    if (!(shape instanceof GeneralPath)) continue;
                    GeneralPath path = (GeneralPath)shape;
                    path.transform(rotation);
                }
            }
        }
        return this.body;
    }

    private void updateControlPoints() {
        int x = this.controlPoints[0].x;
        int y = this.controlPoints[0].y;
        int terminalSpacing = (int)TERMINAL_SPACING.convertToPixels();
        int length = (int)LENGTH.convertToPixels();
        this.controlPoints[1].setLocation(x - terminalSpacing, y + length);
        this.controlPoints[2].setLocation(x, y + length);
        this.controlPoints[3].setLocation(x + terminalSpacing, y + length);
        if (this.orientation != Orientation.DEFAULT) {
            double theta = 0.0;
            switch (this.orientation) {
                case _90: {
                    theta = 1.5707963267948966;
                    break;
                }
                case _180: {
                    theta = Math.PI;
                    break;
                }
                case _270: {
                    theta = 4.71238898038469;
                }
            }
            AffineTransform rotation = AffineTransform.getRotateInstance(theta, x, y);
            for (Point point : this.controlPoints) {
                rotation.transform(point, point);
            }
        }
    }

    public void drawIcon(Graphics2D g2d, int width, int height) {
        g2d.rotate(0.7853981633974483, width / 2, height / 2);
        int baseLength = 20 * width / 32;
        g2d.setStroke(ObjectCache.getInstance().fetchBasicStroke(3.0f));
        g2d.setColor(BASE_COLOR);
        g2d.drawLine(width / 2, 0, width / 2, baseLength + (width - baseLength) / 2);
        g2d.setColor(WAFER_COLOR);
        g2d.fillRect(8 * width / 32, (width - baseLength) / 2, 16 * width / 32, baseLength);
        g2d.setColor(METAL_COLOR);
        g2d.setStroke(ObjectCache.getInstance().fetchBasicStroke(1.0f));
        g2d.drawLine(width / 2 - 2, (width - baseLength) / 2, width / 2 - 2, baseLength + (width - baseLength) / 2);
        g2d.drawLine(width / 2 + 2, (width - baseLength) / 2, width / 2 + 2, baseLength + (width - baseLength) / 2);
        g2d.drawLine(width / 2 - 5, (width - baseLength) / 2, width / 2 - 5, baseLength + (width - baseLength) / 2);
        g2d.drawLine(width / 2 + 5, (width - baseLength) / 2, width / 2 + 5, baseLength + (width - baseLength) / 2);
        int dx = 2 * width / 32;
        int dy = 4 * width / 32;
        g2d.drawLine(width / 2 - 2, baseLength + (width - baseLength) / 2, width / 2 - 2 + dx, baseLength + (width - baseLength) / 2 + dy);
        g2d.drawLine(width / 2 + 2, baseLength + (width - baseLength) / 2, width / 2 + 2 - dx, baseLength + (width - baseLength) / 2 + dy);
        g2d.drawLine(width / 2 - 5, baseLength + (width - baseLength) / 2, width / 2 - 5 - dx, baseLength + (width - baseLength) / 2 + dy);
        g2d.drawLine(width / 2 + 5, baseLength + (width - baseLength) / 2, width / 2 + 5 + dx, baseLength + (width - baseLength) / 2 + dy);
    }

    public int getControlPointCount() {
        return this.controlPoints.length;
    }

    public VisibilityPolicy getControlPointVisibilityPolicy(int index) {
        return VisibilityPolicy.ALWAYS;
    }

    public boolean isControlPointSticky(int index) {
        return true;
    }

    public Point getControlPoint(int index) {
        return this.controlPoints[index];
    }

    public void setControlPoint(Point point, int index) {
        this.controlPoints[index].setLocation(point);
        this.body = null;
    }

    public boolean canPointMoveFreely(int pointIndex) {
        return false;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    @EditableProperty
    public Orientation getOrientation() {
        return this.orientation;
    }

    public void setOrientation(Orientation orientation) {
        this.orientation = orientation;
        this.updateControlPoints();
        this.body = null;
    }

    public int getPositionCount() {
        return 3;
    }

    public String getPositionName(int position) {
        switch (position) {
            case 0: {
                return "Treble";
            }
            case 1: {
                return "Middle";
            }
            case 2: {
                return "Rhythm";
            }
        }
        return null;
    }

    public boolean arePointsConnected(int index1, int index2, int position) {
        switch (position) {
            case 0: {
                return index1 == 1 && index2 == 2;
            }
            case 1: {
                return index1 > 0;
            }
            case 2: {
                return index1 == 2 && index2 == 3;
            }
        }
        return false;
    }
}

