/*
 * Decompiled with CFR 0.152.
 */
package org.diylc.components.guitar;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.RoundRectangle2D;
import org.diylc.appframework.miscutils.ConfigurationManager;
import org.diylc.common.ObjectCache;
import org.diylc.common.Orientation;
import org.diylc.common.OrientationHV;
import org.diylc.components.guitar.AbstractSingleOrHumbuckerPickup;
import org.diylc.core.ComponentState;
import org.diylc.core.IDrawingObserver;
import org.diylc.core.Project;
import org.diylc.core.Theme;
import org.diylc.core.annotations.ComponentDescriptor;
import org.diylc.core.annotations.EditableProperty;
import org.diylc.core.annotations.KeywordPolicy;
import org.diylc.core.measures.Size;
import org.diylc.core.measures.SizeUnit;
import org.diylc.utils.Constants;

@ComponentDescriptor(name="P- Bass Pickup", category="Guitar", author="Branislav Stojkovic", description="Split-coil pickup for P-Bass and similar guitars", zOrder=4.0, instanceNamePrefix="PKP", autoEdit=false, keywordPolicy=KeywordPolicy.SHOW_TAG, keywordTag="Guitar Wiring Diagram")
public class PBassPickup
extends AbstractSingleOrHumbuckerPickup {
    private static final long serialVersionUID = 1L;
    private static Color BODY_COLOR = Color.decode("#333333");
    private static Size WIDTH = new Size(Double.valueOf(1.1), SizeUnit.in);
    private static Size LENGTH = new Size(Double.valueOf(2.2), SizeUnit.in);
    private static Size EDGE_RADIUS = new Size(Double.valueOf(0.08), SizeUnit.in);
    private static Size LIP_RADIUS = new Size(Double.valueOf(0.45), SizeUnit.in);
    private static Size LIP_HOLE_SIZE = new Size(Double.valueOf(0.1), SizeUnit.in);
    private static Size LIP_HOLE_SPACING = new Size(Double.valueOf(0.1), SizeUnit.in);
    private static Size POINT_MARGIN = new Size(Double.valueOf(1.5), SizeUnit.mm);
    private static Size POINT_SIZE = new Size(Double.valueOf(2.0), SizeUnit.mm);
    private static Size POLE_SIZE = new Size(Double.valueOf(4.0), SizeUnit.mm);
    private static Size POLE_SPACING = new Size(Double.valueOf(0.38), SizeUnit.in);
    private Color color = BODY_COLOR;
    private Color poleColor = METAL_COLOR;

    public void draw(Graphics2D g2d, ComponentState componentState, boolean outlineMode, Project project, IDrawingObserver drawingObserver) {
        Color finalBorderColor;
        Shape[] body = this.getBody();
        g2d.setStroke(ObjectCache.getInstance().fetchBasicStroke(1.0f));
        Composite oldComposite = g2d.getComposite();
        if (this.alpha < MAX_ALPHA) {
            g2d.setComposite(AlphaComposite.getInstance(3, 1.0f * (float)this.alpha / (float)MAX_ALPHA));
        }
        g2d.setColor(outlineMode ? Constants.TRANSPARENT_COLOR : this.color);
        g2d.fill(body[0]);
        g2d.fill(body[1]);
        g2d.setComposite(oldComposite);
        if (outlineMode) {
            Theme theme = (Theme)ConfigurationManager.getInstance().readObject("theme", (Object)Constants.DEFAULT_THEME);
            finalBorderColor = componentState == ComponentState.SELECTED || componentState == ComponentState.DRAGGING ? SELECTION_COLOR : theme.getOutlineColor();
        } else {
            finalBorderColor = componentState == ComponentState.SELECTED || componentState == ComponentState.DRAGGING ? SELECTION_COLOR : this.color.darker();
        }
        g2d.setColor(finalBorderColor);
        g2d.draw(body[0]);
        g2d.draw(body[1]);
        if (!outlineMode) {
            g2d.setColor(this.getPoleColor());
            g2d.fill(body[3]);
            g2d.setColor(this.darkerOrLighter(this.getPoleColor()));
            g2d.draw(body[3]);
        }
        this.drawMainLabel(g2d, project, outlineMode, componentState);
        this.drawlTerminalLabels(g2d, finalBorderColor, project);
    }

    @Override
    public Shape[] getBody() {
        if (this.body == null) {
            this.body = new Shape[4];
            Point[] points = this.getControlPoints();
            int x = points[0].x;
            int y = points[0].y;
            int width = (int)WIDTH.convertToPixels();
            int length = (int)LENGTH.convertToPixels();
            int edgeRadius = (int)EDGE_RADIUS.convertToPixels();
            int pointMargin = (int)POINT_MARGIN.convertToPixels();
            int lipRadius = (int)LIP_RADIUS.convertToPixels();
            int pointSize = this.getClosestOdd(POINT_SIZE.convertToPixels());
            int lipHoleSize = this.getClosestOdd(LIP_HOLE_SIZE.convertToPixels());
            int lipHoleSpacing = this.getClosestOdd(LIP_HOLE_SPACING.convertToPixels());
            this.body[0] = new Area(new RoundRectangle2D.Double(x - length, y - pointMargin, length, width, edgeRadius, edgeRadius));
            Area lip = new Area(new Ellipse2D.Double(-lipRadius / 2, -lipRadius / 2, lipRadius, lipRadius));
            lip.subtract(new Area(new Ellipse2D.Double(-lipHoleSize / 2 + lipHoleSpacing, -lipHoleSize / 2, lipHoleSize, lipHoleSize)));
            lip.transform(AffineTransform.getTranslateInstance(x, y - pointMargin + width / 2));
            Area lip2 = new Area(new Ellipse2D.Double(-lipRadius / 2, -lipRadius / 2, lipRadius, lipRadius));
            lip2 = new Area(new Ellipse2D.Double(-lipRadius / 2, -lipRadius / 2, lipRadius, lipRadius));
            lip2.subtract(new Area(new Ellipse2D.Double(-lipHoleSize / 2 - lipHoleSpacing, -lipHoleSize / 2, lipHoleSize, lipHoleSize)));
            lip2.transform(AffineTransform.getTranslateInstance(x - length, y - pointMargin + width / 2));
            lip.add(lip2);
            this.body[1] = new Area(lip);
            ((Area)this.body[1]).subtract((Area)this.body[0]);
            this.body[2] = new Area(new Ellipse2D.Double(x - pointSize / 2, y - pointSize / 2, pointSize, pointSize));
            int poleSize = (int)POLE_SIZE.convertToPixels();
            int poleSpacing = (int)POLE_SPACING.convertToPixels();
            int poleMargin = (length - poleSpacing * 3) / 2;
            Area poleArea = new Area();
            for (int i = 0; i < 4; ++i) {
                Ellipse2D.Double pole = new Ellipse2D.Double(x - length + poleMargin + i * poleSpacing - poleSize / 2, y - pointMargin - poleSize / 2 + width / 2, poleSize, poleSize);
                poleArea.add(new Area(pole));
            }
            this.body[3] = poleArea;
            if (this.orientation != Orientation.DEFAULT) {
                double theta = 0.0;
                switch (this.orientation) {
                    case _90: {
                        theta = 1.5707963267948966;
                        break;
                    }
                    case _180: {
                        theta = Math.PI;
                        break;
                    }
                    case _270: {
                        theta = 4.71238898038469;
                    }
                }
                AffineTransform rotation = AffineTransform.getRotateInstance(theta, x, y);
                for (Shape shape : this.body) {
                    Area area = (Area)shape;
                    if (shape == null) continue;
                    area.transform(rotation);
                }
            }
        }
        return this.body;
    }

    @Override
    protected int getMainLabelYOffset() {
        return (int)(WIDTH.convertToPixels() / 2.0 - 20.0);
    }

    public void drawIcon(Graphics2D g2d, int width, int height) {
        g2d.rotate(0.7853981633974483, width / 2, height / 2);
        int bodyWidth = (int)(13.0f * (float)width / 32.0f);
        int bodyLength = (int)(30.0f * (float)width / 32.0f);
        g2d.setStroke(ObjectCache.getInstance().fetchBasicStroke(1.0f));
        g2d.setColor(BODY_COLOR);
        g2d.fillRoundRect((width - bodyWidth) / 2, (height - bodyLength) / 2, bodyWidth, bodyLength, 3, 3);
        int lipSize = (int)(5.0f * (float)width / 32.0f);
        g2d.fillRoundRect((width - lipSize) / 2, (height - bodyLength) / 2 - lipSize + 1, lipSize, bodyLength + 2 * lipSize - 2, lipSize, lipSize);
        g2d.setColor(BODY_COLOR.darker());
        g2d.drawRoundRect((width - bodyWidth) / 2, (height - bodyLength) / 2, bodyWidth, bodyLength, 3, 3);
        g2d.setColor(METAL_COLOR);
        int poleSize = 2;
        int poleSpacing = (int)(15.0 * (double)width / 32.0);
        for (int i = 0; i < 4; ++i) {
            g2d.fillOval((width - poleSize) / 2, (height - poleSpacing) / 2 + i * poleSpacing / 3, poleSize, poleSize);
        }
    }

    @Override
    protected OrientationHV getControlPointDirection() {
        return OrientationHV.VERTICAL;
    }

    @EditableProperty
    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    @EditableProperty(name="Pole Color")
    public Color getPoleColor() {
        if (this.poleColor == null) {
            this.poleColor = METAL_COLOR;
        }
        return this.poleColor;
    }

    public void setPoleColor(Color poleColor) {
        this.poleColor = poleColor;
    }
}

