/*
 * Decompiled with CFR 0.152.
 */
package org.diylc.components.passive;

import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Path2D;
import org.diylc.common.SimpleComponentTransformer;
import org.diylc.components.AbstractSchematicLeadedSymbol;
import org.diylc.core.CreationMethod;
import org.diylc.core.annotations.ComponentDescriptor;
import org.diylc.core.annotations.EditableProperty;
import org.diylc.core.annotations.KeywordPolicy;
import org.diylc.core.measures.Current;
import org.diylc.core.measures.Size;
import org.diylc.core.measures.SizeUnit;

@ComponentDescriptor(name="Fuse", author="Branislav Stojkovic", category="Schematic Symbols", creationMethod=CreationMethod.POINT_BY_POINT, instanceNamePrefix="F", description="Fuse schematic symbol", zOrder=4.0, keywordPolicy=KeywordPolicy.SHOW_VALUE, keywordTag="Schematic", transformer=SimpleComponentTransformer.class)
public class FuseSymbol
extends AbstractSchematicLeadedSymbol<Current> {
    private static final long serialVersionUID = 1L;
    public static Size DEFAULT_LENGTH = new Size(Double.valueOf(0.3), SizeUnit.in);
    public static Size DEFAULT_WIDTH = new Size(Double.valueOf(0.12), SizeUnit.in);
    private Current value = null;

    @EditableProperty
    public Current getValue() {
        return this.value;
    }

    public void setValue(Current value) {
        this.value = value;
    }

    public String getValueForDisplay() {
        return this.getValue().toString();
    }

    public void drawIcon(Graphics2D g2d, int width, int height) {
        g2d.rotate(-0.7853981633974483, width / 2, height / 2);
        g2d.setColor(LEAD_COLOR);
        g2d.drawLine(0, height / 2, 4, height / 2);
        g2d.drawLine(width - 4, height / 2, width, height / 2);
        int d = 3;
        g2d.setColor(COLOR);
        g2d.drawOval(4, height / 2 - 1, d, d);
        g2d.drawOval(width - 4 - d, height / 2 - 1, d, d);
        Path2D.Double path = new Path2D.Double();
        ((Path2D)path).moveTo(4 + d, height / 2);
        double w = 5.0;
        ((Path2D)path).curveTo(4 + 2 * d, (double)(height / 2) + w, width / 2 - d, (double)(height / 2) + w, width / 2, height / 2);
        ((Path2D)path).curveTo(width / 2 + d, (double)(height / 2) - w, width - 4 - 2 * d, (double)(height / 2) - w, width - 4 - d, height / 2);
        g2d.draw(path);
    }

    @Override
    protected Size getDefaultWidth() {
        return DEFAULT_WIDTH;
    }

    @Override
    protected Size getDefaultLength() {
        return DEFAULT_LENGTH;
    }

    @Override
    protected Shape getBodyShape() {
        Path2D.Double polyline = new Path2D.Double();
        double length = this.getLength().convertToPixels();
        double width = this.getWidth().convertToPixels();
        double radius = width / 6.0;
        ((Path2D)polyline).moveTo(2.0 * radius, width / 2.0);
        ((Path2D)polyline).curveTo(3.0 * radius, width, length / 2.0 - radius, width, length / 2.0, width / 2.0);
        ((Path2D)polyline).curveTo(length / 2.0 + radius, 0.0, length - 3.0 * radius, 0.0, length - 2.0 * radius, width / 2.0);
        polyline.append(new Ellipse2D.Double(0.0, width / 2.0 - radius, radius * 2.0, radius * 2.0), false);
        polyline.append(new Ellipse2D.Double(length - radius * 2.0, width / 2.0 - radius, radius * 2.0, radius * 2.0), false);
        return polyline;
    }

    @Override
    protected boolean useShapeRectAsPosition() {
        return false;
    }
}

