/*
 * Decompiled with CFR 0.152.
 */
package org.diylc.components.passive;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.text.DecimalFormat;
import java.text.Format;
import org.diylc.appframework.miscutils.ConfigurationManager;
import org.diylc.awt.StringUtils;
import org.diylc.common.Display;
import org.diylc.common.HorizontalAlignment;
import org.diylc.common.ObjectCache;
import org.diylc.common.Orientation;
import org.diylc.common.VerticalAlignment;
import org.diylc.components.AbstractTransparentComponent;
import org.diylc.core.ComponentState;
import org.diylc.core.IDrawingObserver;
import org.diylc.core.Project;
import org.diylc.core.Theme;
import org.diylc.core.VisibilityPolicy;
import org.diylc.core.annotations.ComponentDescriptor;
import org.diylc.core.annotations.EditableProperty;
import org.diylc.core.annotations.KeywordPolicy;
import org.diylc.core.measures.Capacitance;
import org.diylc.core.measures.Size;
import org.diylc.core.measures.SizeUnit;
import org.diylc.core.measures.Voltage;
import org.diylc.utils.Constants;

@ComponentDescriptor(name="Multi-Section Capacitor", author="Branislav Stojkovic", category="Passive", instanceNamePrefix="C", description="Multi-section vertically mounted electrolytic capacitor, similar to JJ, CE and others", zOrder=4.0, keywordPolicy=KeywordPolicy.SHOW_VALUE)
public class MultiSectionCapacitor
extends AbstractTransparentComponent<Capacitance[]> {
    private static final long serialVersionUID = 1L;
    public static Color BODY_COLOR = Color.decode("#6B6DCE");
    public static Color BASE_COLOR = Color.decode("#333333");
    public static Color BORDER_COLOR = BODY_COLOR.darker();
    public static Color PIN_COLOR = METAL_COLOR;
    public static Color LABEL_COLOR = Color.white;
    public static Size PIN_SIZE = new Size(Double.valueOf(0.08), SizeUnit.in);
    public static Size BODY_DIAMETER = new Size(Double.valueOf(1.0), SizeUnit.in);
    private static double[] RELATIVE_DIAMETERS = new double[]{0.4, 0.6};
    private static final Format format = new DecimalFormat("0.#####");
    private Capacitance[] value = new Capacitance[3];
    private Voltage voltage = null;
    private Orientation orientation = Orientation.DEFAULT;
    private Point[] controlPoints = new Point[]{new Point(0, 0), new Point(0, 0), new Point(0, 0)};
    private transient Area[] body;
    private Color bodyColor = BODY_COLOR;
    private Color baseColor = BASE_COLOR;
    private Color borderColor = BORDER_COLOR;
    private Color labelColor = LABEL_COLOR;
    private Color pinColor = PIN_COLOR;
    protected Display display = Display.NAME;
    private Size diameter = BODY_DIAMETER;

    public MultiSectionCapacitor() {
        this.updateControlPoints();
    }

    @EditableProperty
    public Capacitance[] getValue() {
        return this.value;
    }

    public void setValue(Capacitance[] value) {
        boolean needsUpdate = false;
        if ((this.value == null ? 0 : this.value.length) != (value == null ? 0 : value.length)) {
            needsUpdate = true;
        }
        this.value = value;
        if (needsUpdate) {
            this.updateControlPoints();
            this.body = null;
        }
    }

    private String getStringValue() {
        if (this.value == null || this.value.length == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        boolean isFirst = true;
        for (Capacitance c : this.value) {
            if (isFirst) {
                isFirst = false;
            } else {
                sb.append("/");
            }
            sb.append(c == null || c.getValue() == null ? "" : format.format(c.getValue()));
        }
        if (this.value[0] != null) {
            sb.append(" " + this.value[0].getUnit() == null ? "" : this.value[0].getUnit());
        }
        return sb.toString();
    }

    @EditableProperty
    public Voltage getVoltage() {
        return this.voltage;
    }

    public void setVoltage(Voltage voltage) {
        this.voltage = voltage;
    }

    @EditableProperty
    public Size getDiameter() {
        return this.diameter;
    }

    public void setDiameter(Size diameter) {
        this.diameter = diameter;
        this.updateControlPoints();
        this.body = null;
    }

    @EditableProperty
    public Orientation getOrientation() {
        return this.orientation;
    }

    public void setOrientation(Orientation orientation) {
        this.orientation = orientation;
        this.updateControlPoints();
        this.body = null;
    }

    public int getControlPointCount() {
        return this.controlPoints.length;
    }

    public Point getControlPoint(int index) {
        return this.controlPoints[index];
    }

    public boolean isControlPointSticky(int index) {
        return true;
    }

    public VisibilityPolicy getControlPointVisibilityPolicy(int index) {
        return VisibilityPolicy.NEVER;
    }

    public void setControlPoint(Point point, int index) {
        this.controlPoints[index].setLocation(point);
        this.body = null;
    }

    private void updateControlPoints() {
        block22: {
            double theta0;
            double centerY;
            double centerX;
            int y;
            int x;
            int newCount;
            int pinSpacing;
            block23: {
                block21: {
                    pinSpacing = (int)(this.getDiameter().convertToPixels() * RELATIVE_DIAMETERS[this.value == null || this.value.length == 1 ? 0 : 1]);
                    newCount = this.value.length + 1;
                    if (newCount != this.controlPoints.length) {
                        Point[] newPoints = new Point[newCount];
                        newPoints[0] = this.controlPoints[0];
                        for (int i = 1; i < newCount; ++i) {
                            newPoints[i] = new Point(0, 0);
                        }
                        this.controlPoints = newPoints;
                    }
                    x = this.controlPoints[0].x;
                    y = this.controlPoints[0].y;
                    if (newCount != 2) break block21;
                    switch (this.orientation) {
                        case DEFAULT: {
                            this.controlPoints[1].setLocation(x, y + pinSpacing);
                            break block22;
                        }
                        case _90: {
                            this.controlPoints[1].setLocation(x - pinSpacing, y);
                            break block22;
                        }
                        case _180: {
                            this.controlPoints[1].setLocation(x, y - pinSpacing);
                            break block22;
                        }
                        case _270: {
                            this.controlPoints[1].setLocation(x + pinSpacing, y);
                            break block22;
                        }
                        default: {
                            throw new RuntimeException("Unexpected orientation: " + this.orientation);
                        }
                    }
                }
                if (newCount != 3) break block23;
                switch (this.orientation) {
                    case DEFAULT: {
                        this.controlPoints[1].setLocation(x + pinSpacing / 2, y + pinSpacing / 2);
                        this.controlPoints[2].setLocation(x - pinSpacing / 2, y + pinSpacing / 2);
                        break block22;
                    }
                    case _90: {
                        this.controlPoints[1].setLocation(x - pinSpacing / 2, y - pinSpacing / 2);
                        this.controlPoints[2].setLocation(x - pinSpacing / 2, y + pinSpacing / 2);
                        break block22;
                    }
                    case _180: {
                        this.controlPoints[1].setLocation(x - pinSpacing / 2, y - pinSpacing / 2);
                        this.controlPoints[2].setLocation(x + pinSpacing / 2, y - pinSpacing / 2);
                        break block22;
                    }
                    case _270: {
                        this.controlPoints[1].setLocation(x + pinSpacing / 2, y - pinSpacing / 2);
                        this.controlPoints[2].setLocation(x + pinSpacing / 2, y + pinSpacing / 2);
                        break block22;
                    }
                    default: {
                        throw new RuntimeException("Unexpected orientation: " + this.orientation);
                    }
                }
            }
            double theta = Math.PI * 2 / (double)newCount;
            switch (this.orientation) {
                case DEFAULT: {
                    centerX = x;
                    centerY = y + pinSpacing / 2;
                    theta0 = -1.5707963267948966;
                    break;
                }
                case _90: {
                    centerX = x - pinSpacing / 2;
                    centerY = y;
                    theta0 = 0.0;
                    break;
                }
                case _180: {
                    centerX = x;
                    centerY = y - pinSpacing / 2;
                    theta0 = 1.5707963267948966;
                    break;
                }
                case _270: {
                    centerX = x + pinSpacing / 2;
                    centerY = y;
                    theta0 = -Math.PI;
                    break;
                }
                default: {
                    throw new RuntimeException("Unexpected orientation: " + this.orientation);
                }
            }
            for (int i = 1; i < newCount; ++i) {
                this.controlPoints[i].setLocation(centerX + Math.cos(theta0 + theta * (double)i) * (double)pinSpacing / 2.0, centerY + Math.sin(theta0 + theta * (double)i) * (double)pinSpacing / 2.0);
            }
        }
    }

    public Area[] getBody() {
        block12: {
            double centerY;
            double centerX;
            block14: {
                int pinSpacing;
                int y;
                int x;
                block13: {
                    if (this.body != null) break block12;
                    x = this.controlPoints[0].x;
                    y = this.controlPoints[0].y;
                    pinSpacing = (int)(this.getDiameter().convertToPixels() * RELATIVE_DIAMETERS[this.value == null || this.value.length == 1 ? 0 : 1]);
                    if (this.controlPoints.length != 2 && this.controlPoints.length != 3) break block13;
                    switch (this.orientation) {
                        case DEFAULT: {
                            centerX = x;
                            centerY = y + pinSpacing / 2;
                            break block14;
                        }
                        case _90: {
                            centerX = x - pinSpacing / 2;
                            centerY = y;
                            break block14;
                        }
                        case _180: {
                            centerX = x;
                            centerY = y - pinSpacing / 2;
                            break block14;
                        }
                        case _270: {
                            centerX = x + pinSpacing / 2;
                            centerY = y;
                            break block14;
                        }
                        default: {
                            throw new RuntimeException("Unexpected orientation: " + this.orientation);
                        }
                    }
                }
                switch (this.orientation) {
                    case DEFAULT: {
                        centerX = x;
                        centerY = y + pinSpacing / 2;
                        break;
                    }
                    case _90: {
                        centerX = x - pinSpacing / 2;
                        centerY = y;
                        break;
                    }
                    case _180: {
                        centerX = x;
                        centerY = y - pinSpacing / 2;
                        break;
                    }
                    case _270: {
                        centerX = x + pinSpacing / 2;
                        centerY = y;
                        break;
                    }
                    default: {
                        throw new RuntimeException("Unexpected orientation: " + this.orientation);
                    }
                }
            }
            int bodyDiameter = this.getClosestOdd(this.getDiameter().convertToPixels());
            int innerDiameter = this.getClosestOdd(this.getDiameter().convertToPixels() * 0.85);
            this.body = new Area[]{new Area(new Ellipse2D.Double(centerX - (double)(bodyDiameter / 2), centerY - (double)(bodyDiameter / 2), bodyDiameter, bodyDiameter)), new Area(new Ellipse2D.Double(centerX - (double)(innerDiameter / 2), centerY - (double)(innerDiameter / 2), innerDiameter, innerDiameter))};
        }
        return this.body;
    }

    public void draw(Graphics2D g2d, ComponentState componentState, boolean outlineMode, Project project, IDrawingObserver drawingObserver) {
        if (this.checkPointsClipped(g2d.getClip())) {
            return;
        }
        int pinSize = (int)PIN_SIZE.convertToPixels() / 2 * 2;
        Area[] area = this.getBody();
        Composite oldComposite = g2d.getComposite();
        if (this.alpha < MAX_ALPHA) {
            g2d.setComposite(AlphaComposite.getInstance(3, 1.0f * (float)this.alpha / (float)MAX_ALPHA));
        }
        g2d.setColor(outlineMode ? Constants.TRANSPARENT_COLOR : this.bodyColor);
        g2d.fill(area[0]);
        drawingObserver.startTracking();
        g2d.setComposite(oldComposite);
        Theme theme = (Theme)ConfigurationManager.getInstance().readObject("theme", (Object)Constants.DEFAULT_THEME);
        Color finalBorderColor = outlineMode ? (componentState == ComponentState.SELECTED || componentState == ComponentState.DRAGGING ? SELECTION_COLOR : theme.getOutlineColor()) : (componentState == ComponentState.SELECTED || componentState == ComponentState.DRAGGING ? SELECTION_COLOR : this.borderColor);
        g2d.setColor(finalBorderColor);
        g2d.setStroke(ObjectCache.getInstance().fetchBasicStroke(1.0f));
        g2d.draw(area[0]);
        g2d.setColor(outlineMode ? Constants.TRANSPARENT_COLOR : this.baseColor);
        g2d.fill(area[1]);
        if (outlineMode) {
            g2d.setColor(this.baseColor.darker());
            g2d.draw(area[1]);
        }
        for (Point point : this.controlPoints) {
            if (!outlineMode) {
                g2d.setColor(this.pinColor);
                g2d.fillOval(point.x - pinSize / 2, point.y - pinSize / 2, pinSize, pinSize);
            }
            g2d.setColor(outlineMode ? theme.getOutlineColor() : this.pinColor.darker());
            g2d.drawOval(point.x - pinSize / 2, point.y - pinSize / 2, pinSize, pinSize);
        }
        g2d.setFont(project.getFont());
        Color finalLabelColor = outlineMode ? (componentState == ComponentState.SELECTED || componentState == ComponentState.DRAGGING ? LABEL_COLOR_SELECTED : theme.getOutlineColor()) : (componentState == ComponentState.SELECTED || componentState == ComponentState.DRAGGING ? LABEL_COLOR_SELECTED : this.getLabelColor());
        g2d.setColor(finalLabelColor);
        String label = "";
        String string = label = this.getDisplay() == Display.NAME ? this.getName() : this.getStringValue();
        if (this.getDisplay() == Display.NONE) {
            label = "";
        } else if (this.getDisplay() == Display.NAME) {
            label = this.getName();
        } else if (this.getDisplay() == Display.VALUE) {
            label = this.getStringValue();
        } else if (this.getDisplay() == Display.BOTH) {
            label = this.getName() + "\n" + this.getStringValue();
        }
        Rectangle bounds = area[0].getBounds();
        StringUtils.drawCenteredText(g2d, label, bounds.x + bounds.width / 2, bounds.y + bounds.height / 2, HorizontalAlignment.CENTER, VerticalAlignment.CENTER);
        g2d.setColor(this.pinColor.darker());
        g2d.setStroke(ObjectCache.getInstance().fetchBasicStroke(2.0f));
        double markerSize = (double)pinSize * 0.7;
        for (int i = 0; i < this.controlPoints.length; ++i) {
            int x = this.controlPoints[i].x;
            int y = this.controlPoints[i].y;
            g2d.drawLine((int)((double)x - markerSize / 2.0), y, (int)((double)x + markerSize / 2.0), y);
            if (i <= 0) continue;
            g2d.drawLine(x, (int)((double)y - markerSize / 2.0), x, (int)((double)y + markerSize / 2.0));
        }
    }

    public void drawIcon(Graphics2D g2d, int width, int height) {
        int margin = 2 * width / 32;
        Area area = new Area(new Ellipse2D.Double(margin, margin, width - 2 * margin, width - 2 * margin));
        g2d.setColor(BODY_COLOR);
        g2d.fill(area);
        g2d.setColor(BORDER_COLOR);
        g2d.draw(area);
        g2d.setColor(BASE_COLOR);
        margin = 6 * width / 32;
        area = new Area(new Ellipse2D.Double(margin, margin, width - 2 * margin + 1, width - 2 * margin + 1));
        g2d.fill(area);
        g2d.setColor(PIN_COLOR);
        int pinSize = 2 * width / 32;
        for (int i = 0; i < 3; ++i) {
            g2d.fillOval((i == 1 ? width * 3 / 8 : width / 2) - pinSize / 2, height / 2 + (i - 1) * (height / 5), pinSize, pinSize);
        }
    }

    @EditableProperty(name="Body")
    public Color getBodyColor() {
        return this.bodyColor;
    }

    public void setBodyColor(Color bodyColor) {
        this.bodyColor = bodyColor;
    }

    @EditableProperty(name="Base")
    public Color getBaseColor() {
        return this.baseColor;
    }

    public void setBaseColor(Color baseColor) {
        this.baseColor = baseColor;
    }

    @EditableProperty(name="Border")
    public Color getBorderColor() {
        return this.borderColor;
    }

    public void setBorderColor(Color borderColor) {
        this.borderColor = borderColor;
    }

    @EditableProperty(name="Label")
    public Color getLabelColor() {
        return this.labelColor;
    }

    public void setLabelColor(Color labelColor) {
        this.labelColor = labelColor;
    }

    @EditableProperty
    public Display getDisplay() {
        if (this.display == null) {
            this.display = Display.NAME;
        }
        return this.display;
    }

    public void setDisplay(Display display) {
        this.display = display;
    }

    @EditableProperty(name="Pin Color")
    public Color getPinColor() {
        return this.pinColor;
    }

    public void setPinColor(Color pinColor) {
        this.pinColor = pinColor;
    }

    public boolean canPointMoveFreely(int pointIndex) {
        return false;
    }
}

