/*
 * Decompiled with CFR 0.152.
 */
package org.diylc.components.passive;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import org.diylc.appframework.miscutils.ConfigurationManager;
import org.diylc.common.Display;
import org.diylc.common.ObjectCache;
import org.diylc.common.Orientation;
import org.diylc.components.passive.AbstractPotentiometer;
import org.diylc.core.ComponentState;
import org.diylc.core.CreationMethod;
import org.diylc.core.IDrawingObserver;
import org.diylc.core.Project;
import org.diylc.core.Theme;
import org.diylc.core.annotations.ComponentDescriptor;
import org.diylc.core.annotations.EditableProperty;
import org.diylc.core.measures.Size;
import org.diylc.core.measures.SizeUnit;
import org.diylc.utils.Constants;

@ComponentDescriptor(name="Trimmer Potentiometer", author="Branislav Stojkovic", category="Passive", creationMethod=CreationMethod.SINGLE_CLICK, instanceNamePrefix="VR", description="Various types of board mounted trimmer potentiometers", zOrder=4.0)
public class TrimmerPotentiometer
extends AbstractPotentiometer {
    private static final long serialVersionUID = 1L;
    protected static Size FLAT_BODY_SIZE = new Size(Double.valueOf(9.5), SizeUnit.mm);
    protected static Size FLAT_LARGE_BODY_SIZE = new Size(Double.valueOf(13.0), SizeUnit.mm);
    protected static Size FLAT_SMALL_BODY_SIZE = new Size(Double.valueOf(5.0), SizeUnit.mm);
    protected static Size FLAT_SMALL2_BODY_SIZE = new Size(Double.valueOf(9.5), SizeUnit.mm);
    protected static Size FLAT_SHAFT_SIZE = new Size(Double.valueOf(4.5), SizeUnit.mm);
    protected static Size VERTICAL_BODY_LENGTH = new Size(Double.valueOf(9.5), SizeUnit.mm);
    protected static Size VERTICAL_BODY_WIDTH = new Size(Double.valueOf(4.5), SizeUnit.mm);
    protected static Size ROUNDED_EDGE = new Size(Double.valueOf(1.0), SizeUnit.mm);
    protected static Size SPACING = new Size(Double.valueOf(0.1), SizeUnit.in);
    private static Color BODY_COLOR = Color.decode("#FFFFE0");
    private static Color BORDER_COLOR = Color.decode("#8E8E38");
    private static Color SHAFT_COLOR = Color.decode("#FFFFE0");
    private static Color SHAFT_BORDER_COLOR = Color.decode("#8E8E38");
    public static Color PIN_COLOR = Color.decode("#00B2EE");
    public static Color PIN_BORDER_COLOR = PIN_COLOR.darker();
    public static Size PIN_SIZE = new Size(Double.valueOf(0.03), SizeUnit.in);
    protected static Display DISPLAY = Display.NAME;
    protected Color bodyColor = BODY_COLOR;
    protected Color borderColor = BORDER_COLOR;
    protected Display display = DISPLAY;
    protected transient Shape[] body = null;
    protected TrimmerType type = TrimmerType.FLAT_SMALL;

    public TrimmerPotentiometer() {
        this.controlPoints = new Point[]{new Point(0, 0), new Point(0, 0), new Point(0, 0)};
        this.updateControlPoints();
    }

    protected void updateControlPoints() {
        int spacing = (int)SPACING.convertToPixels();
        int dx1 = 0;
        int dy1 = 0;
        int dx2 = 0;
        int dy2 = 0;
        switch (this.getOrientation()) {
            case DEFAULT: {
                switch (this.getType()) {
                    case FLAT_SMALL: 
                    case FLAT_XSMALL: {
                        dx1 = 2 * spacing;
                        dy1 = spacing;
                        dx2 = 0;
                        dy2 = 2 * spacing;
                        break;
                    }
                    case FLAT_SMALL2: {
                        dx1 = 4 * spacing;
                        dy1 = spacing;
                        dx2 = 0;
                        dy2 = 2 * spacing;
                        break;
                    }
                    case FLAT_LARGE: {
                        dx1 = 4 * spacing;
                        dy1 = spacing;
                        dx2 = 0;
                        dy2 = 2 * spacing;
                        break;
                    }
                    case FLAT_XLARGE: {
                        dx1 = 5 * spacing;
                        dy1 = 2 * spacing;
                        dx2 = 0;
                        dy2 = 4 * spacing;
                        break;
                    }
                    case VERTICAL_INLINE: {
                        dx1 = 0;
                        dy1 = spacing;
                        dx2 = 0;
                        dy2 = 2 * spacing;
                        break;
                    }
                    case VERTICAL_OFFSET: {
                        dx1 = spacing;
                        dy1 = spacing;
                        dx2 = 0;
                        dy2 = 2 * spacing;
                        break;
                    }
                    case VERTICAL_OFFSET_BIG_GAP: {
                        dx1 = 2 * spacing;
                        dy1 = spacing;
                        dx2 = 0;
                        dy2 = 2 * spacing;
                    }
                }
                break;
            }
            case _90: {
                switch (this.getType()) {
                    case FLAT_SMALL: 
                    case FLAT_XSMALL: {
                        dx1 = -spacing;
                        dy1 = 2 * spacing;
                        dx2 = -2 * spacing;
                        dy2 = 0;
                        break;
                    }
                    case FLAT_SMALL2: {
                        dx1 = -spacing;
                        dy1 = 4 * spacing;
                        dx2 = -2 * spacing;
                        dy2 = 0;
                        break;
                    }
                    case FLAT_LARGE: {
                        dx1 = -spacing;
                        dy1 = 4 * spacing;
                        dx2 = -2 * spacing;
                        dy2 = 0;
                        break;
                    }
                    case FLAT_XLARGE: {
                        dx1 = -2 * spacing;
                        dy1 = 5 * spacing;
                        dx2 = -4 * spacing;
                        dy2 = 0;
                        break;
                    }
                    case VERTICAL_INLINE: {
                        dx1 = -spacing;
                        dy1 = 0;
                        dx2 = -2 * spacing;
                        dy2 = 0;
                        break;
                    }
                    case VERTICAL_OFFSET: {
                        dx1 = -spacing;
                        dy1 = spacing;
                        dx2 = -2 * spacing;
                        dy2 = 0;
                        break;
                    }
                    case VERTICAL_OFFSET_BIG_GAP: {
                        dx1 = -spacing;
                        dy1 = 2 * spacing;
                        dx2 = -2 * spacing;
                        dy2 = 0;
                    }
                }
                break;
            }
            case _180: {
                switch (this.getType()) {
                    case FLAT_SMALL: 
                    case FLAT_XSMALL: {
                        dx1 = -2 * spacing;
                        dy1 = -spacing;
                        dx2 = 0;
                        dy2 = -2 * spacing;
                        break;
                    }
                    case FLAT_SMALL2: {
                        dx1 = -4 * spacing;
                        dy1 = -spacing;
                        dx2 = 0;
                        dy2 = -2 * spacing;
                        break;
                    }
                    case FLAT_LARGE: {
                        dx1 = -4 * spacing;
                        dy1 = -spacing;
                        dx2 = 0;
                        dy2 = -2 * spacing;
                        break;
                    }
                    case FLAT_XLARGE: {
                        dx1 = -5 * spacing;
                        dy1 = -2 * spacing;
                        dx2 = 0;
                        dy2 = -4 * spacing;
                        break;
                    }
                    case VERTICAL_INLINE: {
                        dx1 = 0;
                        dy1 = -spacing;
                        dx2 = 0;
                        dy2 = -2 * spacing;
                        break;
                    }
                    case VERTICAL_OFFSET: {
                        dx1 = -spacing;
                        dy1 = -spacing;
                        dx2 = 0;
                        dy2 = -2 * spacing;
                        break;
                    }
                    case VERTICAL_OFFSET_BIG_GAP: {
                        dx1 = -2 * spacing;
                        dy1 = -spacing;
                        dx2 = 0;
                        dy2 = -2 * spacing;
                    }
                }
                break;
            }
            case _270: {
                switch (this.getType()) {
                    case FLAT_SMALL: 
                    case FLAT_XSMALL: {
                        dx1 = spacing;
                        dy1 = -2 * spacing;
                        dx2 = 2 * spacing;
                        dy2 = 0;
                        break;
                    }
                    case FLAT_SMALL2: {
                        dx1 = spacing;
                        dy1 = -4 * spacing;
                        dx2 = 2 * spacing;
                        dy2 = 0;
                        break;
                    }
                    case FLAT_LARGE: {
                        dx1 = spacing;
                        dy1 = -4 * spacing;
                        dx2 = 2 * spacing;
                        dy2 = 0;
                        break;
                    }
                    case FLAT_XLARGE: {
                        dx1 = 2 * spacing;
                        dy1 = -5 * spacing;
                        dx2 = 4 * spacing;
                        dy2 = 0;
                        break;
                    }
                    case VERTICAL_INLINE: {
                        dx1 = spacing;
                        dy1 = 0;
                        dx2 = 2 * spacing;
                        dy2 = 0;
                        break;
                    }
                    case VERTICAL_OFFSET: {
                        dx1 = spacing;
                        dy1 = -spacing;
                        dx2 = 2 * spacing;
                        dy2 = 0;
                        break;
                    }
                    case VERTICAL_OFFSET_BIG_GAP: {
                        dx1 = spacing;
                        dy1 = -2 * spacing;
                        dx2 = 2 * spacing;
                        dy2 = 0;
                    }
                }
                break;
            }
        }
        this.controlPoints[1].setLocation(this.controlPoints[0].x + dx1, this.controlPoints[0].y + dy1);
        this.controlPoints[2].setLocation(this.controlPoints[0].x + dx2, this.controlPoints[0].y + dy2);
    }

    public Shape[] getBody() {
        if (this.body == null) {
            this.body = new Shape[2];
            int centerX = (Math.max(Math.max(this.controlPoints[0].x, this.controlPoints[1].x), this.controlPoints[2].x) + Math.min(Math.min(this.controlPoints[0].x, this.controlPoints[1].x), this.controlPoints[2].x)) / 2;
            int centerY = (Math.max(Math.max(this.controlPoints[0].y, this.controlPoints[1].y), this.controlPoints[2].y) + Math.min(Math.min(this.controlPoints[0].y, this.controlPoints[1].y), this.controlPoints[2].y)) / 2;
            int length = 0;
            int width = 0;
            switch (this.getType()) {
                case FLAT_SMALL: 
                case FLAT_XSMALL: 
                case FLAT_SMALL2: 
                case FLAT_LARGE: 
                case FLAT_XLARGE: {
                    length = this.getType() == TrimmerType.FLAT_XSMALL ? this.getClosestOdd(FLAT_SMALL_BODY_SIZE.convertToPixels()) : (this.getType() == TrimmerType.FLAT_XLARGE ? this.getClosestOdd(FLAT_LARGE_BODY_SIZE.convertToPixels()) : (this.getType() == TrimmerType.FLAT_SMALL2 ? this.getClosestOdd(FLAT_SMALL2_BODY_SIZE.convertToPixels()) : this.getClosestOdd(FLAT_BODY_SIZE.convertToPixels())));
                    width = length;
                    int shaftSize = this.getClosestOdd(FLAT_SHAFT_SIZE.convertToPixels());
                    Area shaft = new Area(new Ellipse2D.Double(centerX - shaftSize / 2, centerY - shaftSize / 2, shaftSize, shaftSize));
                    Area slot = new Area(new Rectangle2D.Double(centerX - shaftSize / 2, centerY - shaftSize / 8, shaftSize, shaftSize / 4));
                    slot.transform(AffineTransform.getRotateInstance(0.7853981633974483, centerX, centerY));
                    shaft.subtract(slot);
                    this.body[1] = shaft;
                    break;
                }
                case VERTICAL_INLINE: 
                case VERTICAL_OFFSET: 
                case VERTICAL_OFFSET_BIG_GAP: {
                    length = this.getClosestOdd(VERTICAL_BODY_LENGTH.convertToPixels());
                    width = this.getClosestOdd(VERTICAL_BODY_WIDTH.convertToPixels());
                }
            }
            if (this.orientation == Orientation.DEFAULT || this.orientation == Orientation._180) {
                int p = length;
                length = width;
                width = p;
            }
            double edge = ROUNDED_EDGE.convertToPixels();
            this.body[0] = this.getType() == TrimmerType.FLAT_SMALL2 ? new Ellipse2D.Double(centerX - length / 2, centerY - width / 2, length, width) : new RoundRectangle2D.Double(centerX - length / 2, centerY - width / 2, length, width, edge, edge);
        }
        return this.body;
    }

    @Override
    public void setControlPoint(Point point, int index) {
        super.setControlPoint(point, index);
        this.body = null;
    }

    @Override
    public void setOrientation(Orientation orientation) {
        super.setOrientation(orientation);
        this.updateControlPoints();
        this.body = null;
    }

    public void draw(Graphics2D g2d, ComponentState componentState, boolean outlineMode, Project project, IDrawingObserver drawingObserver) {
        if (this.checkPointsClipped(g2d.getClip())) {
            return;
        }
        g2d.setStroke(ObjectCache.getInstance().fetchBasicStroke(1.0f));
        Shape mainShape = this.getBody()[0];
        Shape shaftShape = this.getBody()[1];
        Theme theme = (Theme)ConfigurationManager.getInstance().readObject("theme", (Object)Constants.DEFAULT_THEME);
        if (mainShape != null) {
            g2d.setColor(this.bodyColor);
            Composite oldComposite = g2d.getComposite();
            if (this.alpha < MAX_ALPHA) {
                g2d.setComposite(AlphaComposite.getInstance(3, 1.0f * (float)this.alpha / (float)MAX_ALPHA));
            }
            if (!outlineMode) {
                g2d.fill(mainShape);
            }
            if (!outlineMode && shaftShape != null) {
                g2d.setColor(SHAFT_COLOR);
                g2d.fill(shaftShape);
                g2d.setColor(SHAFT_BORDER_COLOR);
                g2d.draw(shaftShape);
            }
            g2d.setComposite(oldComposite);
            Color finalBorderColor = outlineMode ? (componentState == ComponentState.SELECTED || componentState == ComponentState.DRAGGING ? SELECTION_COLOR : theme.getOutlineColor()) : (componentState == ComponentState.SELECTED || componentState == ComponentState.DRAGGING ? SELECTION_COLOR : this.borderColor);
            g2d.setColor(finalBorderColor);
            g2d.draw(mainShape);
        }
        int pinSize = this.getClosestOdd(PIN_SIZE.convertToPixels());
        for (Point point : this.controlPoints) {
            if (!outlineMode) {
                g2d.setColor(PIN_COLOR);
                g2d.fillOval(point.x - pinSize / 2, point.y - pinSize / 2, pinSize, pinSize);
            }
            g2d.setColor(outlineMode ? theme.getOutlineColor() : PIN_BORDER_COLOR);
            g2d.drawOval(point.x - pinSize / 2, point.y - pinSize / 2, pinSize, pinSize);
        }
        g2d.setFont(project.getFont());
        Color finalLabelColor = outlineMode ? (componentState == ComponentState.SELECTED || componentState == ComponentState.DRAGGING ? LABEL_COLOR_SELECTED : theme.getOutlineColor()) : (componentState == ComponentState.SELECTED || componentState == ComponentState.DRAGGING ? LABEL_COLOR_SELECTED : LABEL_COLOR);
        String label = "";
        String string = this.getDisplay() == Display.NAME ? this.getName() : (label = this.getValue() == null ? "" : this.getValue().toString());
        if (this.getDisplay() == Display.NONE) {
            label = "";
        }
        if (this.getDisplay() == Display.BOTH) {
            label = this.getName() + "  " + (this.getValue() == null ? "" : this.getValue().toString());
        }
        g2d.setColor(finalLabelColor);
        FontMetrics fontMetrics = g2d.getFontMetrics();
        Rectangle2D bodyRect = this.getBody()[0].getBounds2D();
        Rectangle2D rect = fontMetrics.getStringBounds(label, g2d);
        int textHeight = (int)rect.getHeight();
        int textWidth = (int)rect.getWidth();
        int panelHeight = (int)bodyRect.getHeight();
        int panelWidth = (int)bodyRect.getWidth();
        int x = (panelWidth - textWidth) / 2;
        int y = (panelHeight - textHeight) / 2 + fontMetrics.getAscent();
        g2d.drawString(label, (int)(bodyRect.getX() + (double)x), (int)(bodyRect.getY() + (double)y));
    }

    public void drawIcon(Graphics2D g2d, int width, int height) {
        int margin = 4;
        g2d.setColor(BODY_COLOR);
        g2d.fillRect(margin, margin, width - 2 * margin, width - 2 * margin);
        g2d.setColor(BORDER_COLOR);
        g2d.setStroke(ObjectCache.getInstance().fetchBasicStroke(1.0f));
        g2d.drawRect(margin, margin, width - 2 * margin, width - 2 * margin);
        int shaftSize = 11;
        int slotSize = 2;
        Area area = new Area(new Ellipse2D.Double(width / 2 - shaftSize / 2, width / 2 - shaftSize / 2, shaftSize, shaftSize));
        Area slot = new Area(new Rectangle2D.Double(0.0, width / 2 - slotSize / 2, width, slotSize));
        slot.transform(AffineTransform.getRotateInstance(0.7853981633974483, width / 2, width / 2));
        area.subtract(slot);
        g2d.setColor(SHAFT_COLOR);
        g2d.fill(area);
        g2d.setColor(SHAFT_BORDER_COLOR);
        g2d.draw(area);
        int pinSize = 3;
        g2d.setColor(PIN_COLOR);
        g2d.fillOval(margin - pinSize / 2, 10 - pinSize / 2, pinSize, pinSize);
        g2d.setColor(PIN_BORDER_COLOR);
        g2d.drawOval(margin - pinSize / 2, 10 - pinSize / 2, pinSize, pinSize);
        g2d.setColor(PIN_COLOR);
        g2d.fillOval(margin - pinSize / 2, 21 - pinSize / 2, pinSize, pinSize);
        g2d.setColor(PIN_BORDER_COLOR);
        g2d.drawOval(margin - pinSize / 2, 21 - pinSize / 2, pinSize, pinSize);
        g2d.setColor(PIN_COLOR);
        g2d.fillOval(width - margin - pinSize / 2, width / 2 - pinSize / 2, pinSize, pinSize);
        g2d.setColor(PIN_BORDER_COLOR);
        g2d.drawOval(width - margin - pinSize / 2, width / 2 - pinSize / 2, pinSize, pinSize);
    }

    @EditableProperty(name="Body")
    public Color getBodyColor() {
        return this.bodyColor;
    }

    public void setBodyColor(Color bodyColor) {
        this.bodyColor = bodyColor;
    }

    @EditableProperty
    public Display getDisplay() {
        if (this.display == null) {
            this.display = DISPLAY;
        }
        return this.display;
    }

    public void setDisplay(Display display) {
        this.display = display;
    }

    @EditableProperty(name="Border")
    public Color getBorderColor() {
        return this.borderColor;
    }

    public void setBorderColor(Color borderColor) {
        this.borderColor = borderColor;
    }

    @EditableProperty
    public TrimmerType getType() {
        return this.type;
    }

    public void setType(TrimmerType type) {
        this.type = type;
        this.updateControlPoints();
        this.body = null;
    }

    public boolean canPointMoveFreely(int pointIndex) {
        return false;
    }

    public static enum TrimmerType {
        FLAT_SMALL("Horizontal Small 1"),
        FLAT_SMALL2("Horizontal Small 2"),
        FLAT_XSMALL("Horizontal X-Small"),
        FLAT_LARGE("Horizontal Medium"),
        FLAT_XLARGE("Horizontal Large"),
        VERTICAL_INLINE("Vertical Inline"),
        VERTICAL_OFFSET("Vertical Offset 1"),
        VERTICAL_OFFSET_BIG_GAP("Vertical Offset 2");

        String label;

        private TrimmerType(String label) {
            this.label = label;
        }

        public String toString() {
            return this.label;
        }
    }
}

