/*
 * Decompiled with CFR 0.152.
 */
package org.diylc.components.semiconductors;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Shape;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Path2D;
import java.awt.geom.Rectangle2D;
import org.diylc.appframework.miscutils.ConfigurationManager;
import org.diylc.awt.StringUtils;
import org.diylc.common.Display;
import org.diylc.common.HorizontalAlignment;
import org.diylc.common.ObjectCache;
import org.diylc.common.VerticalAlignment;
import org.diylc.components.AbstractTransparentComponent;
import org.diylc.core.ComponentState;
import org.diylc.core.IDrawingObserver;
import org.diylc.core.Project;
import org.diylc.core.Theme;
import org.diylc.core.VisibilityPolicy;
import org.diylc.core.annotations.ComponentDescriptor;
import org.diylc.core.annotations.EditableProperty;
import org.diylc.core.annotations.KeywordPolicy;
import org.diylc.core.measures.Size;
import org.diylc.core.measures.SizeUnit;
import org.diylc.utils.Constants;

@ComponentDescriptor(name="Logic Gate", author="Branislav Stojkovic", category="Schematic Symbols", instanceNamePrefix="LG", description="Basic logic gate schematic symbols", zOrder=4.0, keywordPolicy=KeywordPolicy.SHOW_TAG_AND_VALUE, keywordTag="Schematic")
public class LogicGateSymbol
extends AbstractTransparentComponent<String> {
    private static final long serialVersionUID = 1L;
    public static Size PIN_SPACING = new Size(Double.valueOf(0.1), SizeUnit.in);
    public static Color BODY_COLOR = Color.white;
    public static Color BORDER_COLOR = Color.black;
    protected GateType gateType = GateType.Not;
    protected String value = "";
    protected Point[] controlPoints = new Point[]{new Point(0, 0), new Point(0, 0), new Point(0, 0)};
    protected Color bodyColor = BODY_COLOR;
    protected Color borderColor = BORDER_COLOR;
    protected Display display = Display.NONE;
    private transient Shape[] body;

    public LogicGateSymbol() {
        this.updateControlPoints();
    }

    public void draw(Graphics2D g2d, ComponentState componentState, boolean outlineMode, Project project, IDrawingObserver drawingObserver) {
        Color finalLabelColor;
        Color finalBorderColor;
        if (this.checkPointsClipped(g2d.getClip())) {
            return;
        }
        int pinSpacing = (int)PIN_SPACING.convertToPixels();
        Composite oldComposite = g2d.getComposite();
        if (this.alpha < MAX_ALPHA) {
            g2d.setComposite(AlphaComposite.getInstance(3, 1.0f * (float)this.alpha / (float)MAX_ALPHA));
        }
        Shape[] body = this.getBody();
        g2d.setColor(outlineMode ? Constants.TRANSPARENT_COLOR : this.bodyColor);
        g2d.fill(body[0]);
        g2d.setComposite(oldComposite);
        if (outlineMode) {
            Theme theme = (Theme)ConfigurationManager.getInstance().readObject("theme", (Object)Constants.DEFAULT_THEME);
            finalBorderColor = theme.getOutlineColor();
        } else {
            finalBorderColor = this.borderColor;
        }
        g2d.setColor(finalBorderColor);
        g2d.setStroke(ObjectCache.getInstance().fetchBasicStroke(1.0f));
        g2d.draw(body[1]);
        g2d.setStroke(ObjectCache.getInstance().fetchBasicStroke(2.0f));
        g2d.draw(body[0]);
        if (body[2] != null) {
            g2d.draw(body[2]);
        }
        g2d.setFont(project.getFont());
        if (outlineMode) {
            Theme theme = (Theme)ConfigurationManager.getInstance().readObject("theme", (Object)Constants.DEFAULT_THEME);
            finalLabelColor = componentState == ComponentState.SELECTED || componentState == ComponentState.DRAGGING ? LABEL_COLOR_SELECTED : theme.getOutlineColor();
        } else {
            finalLabelColor = componentState == ComponentState.SELECTED || componentState == ComponentState.DRAGGING ? LABEL_COLOR_SELECTED : LABEL_COLOR;
        }
        g2d.setColor(finalLabelColor);
        int x = (this.controlPoints[0].x + this.controlPoints[this.getControlPointCount() == 2 ? 1 : 2].x) / 2;
        String label = "";
        String string = label = this.display == Display.VALUE ? this.getValue() : this.getName();
        if (this.display == Display.NONE) {
            label = "";
        }
        if (this.display == Display.BOTH) {
            label = this.getName() + "  " + (this.getValue() == null ? "" : this.getValue().toString());
        }
        StringUtils.drawCenteredText(g2d, label, x, this.controlPoints[0].y + (this.getControlPointCount() == 2 ? 0 : pinSpacing), HorizontalAlignment.CENTER, VerticalAlignment.CENTER);
    }

    public void drawIcon(Graphics2D g2d, int width, int height) {
        int margin = 3 * width / 32;
        Path2D.Double path = new Path2D.Double();
        ((Path2D)path).moveTo(margin, margin);
        ((Path2D)path).curveTo(margin * 4, margin * 2, margin * 4, height - margin * 2, margin, height - margin);
        ((Path2D)path).quadTo(width - 2 * margin, height - margin * 2, width - margin, height / 2);
        ((Path2D)path).quadTo(width - margin * 2, margin * 2, margin, margin);
        Area area = new Area(path);
        area.intersect(new Area(new Rectangle2D.Double(2 * margin, 0.0, width, height)));
        g2d.setColor(BODY_COLOR);
        g2d.fill(area);
        g2d.setColor(BORDER_COLOR);
        g2d.setFont(LABEL_FONT.deriveFont(8.0f));
        g2d.draw(area);
    }

    public Point getControlPoint(int index) {
        return this.controlPoints[index];
    }

    public int getControlPointCount() {
        return this.getGateType() == GateType.Not || this.getGateType() == GateType.Buffer ? 2 : 3;
    }

    private void updateControlPoints() {
        int pinSpacing = (int)PIN_SPACING.convertToPixels();
        int x = this.controlPoints[0].x;
        int y = this.controlPoints[0].y;
        if (this.getControlPointCount() == 2) {
            this.controlPoints[1].x = x + pinSpacing * 6;
            this.controlPoints[1].y = y;
        } else {
            this.controlPoints[1].x = x;
            this.controlPoints[1].y = y + pinSpacing * 2;
            this.controlPoints[2].x = x + pinSpacing * 6;
            this.controlPoints[2].y = y + pinSpacing;
        }
    }

    public Shape[] getBody() {
        if (this.body == null) {
            this.body = new Shape[3];
            int pinSpacing = (int)PIN_SPACING.convertToPixels();
            int x = this.controlPoints[0].x;
            int y = this.controlPoints[0].y;
            Area main = null;
            switch (this.getGateType()) {
                case Not: 
                case Buffer: {
                    main = new Area(new Polygon(new int[]{x + pinSpacing * 3 / 2, x + pinSpacing * 9 / 2, x + pinSpacing * 3 / 2}, new int[]{y - pinSpacing * 2, y, y + pinSpacing * 2}, 3));
                    break;
                }
                case And: 
                case Nand: {
                    Path2D.Double path1 = new Path2D.Double();
                    ((Path2D)path1).moveTo(x + pinSpacing * 3 / 2, y - pinSpacing);
                    ((Path2D)path1).lineTo(x + pinSpacing * 3 / 2, y + pinSpacing * 3);
                    ((Path2D)path1).quadTo(x + pinSpacing * 9 / 2, y + pinSpacing * 3, x + pinSpacing * 9 / 2, y + pinSpacing);
                    ((Path2D)path1).quadTo(x + pinSpacing * 9 / 2, y - pinSpacing, x + pinSpacing * 3 / 2, y - pinSpacing);
                    main = new Area(path1);
                    break;
                }
                default: {
                    Path2D.Double path2 = new Path2D.Double();
                    ((Path2D)path2).moveTo(x + pinSpacing, y - pinSpacing);
                    ((Path2D)path2).curveTo(x + pinSpacing * 2, y, x + pinSpacing * 2, y + 2 * pinSpacing, x + pinSpacing, y + pinSpacing * 3);
                    ((Path2D)path2).quadTo(x + pinSpacing * 7 / 2, y + pinSpacing * 5 / 2, x + pinSpacing * 9 / 2, y + pinSpacing);
                    ((Path2D)path2).quadTo(x + pinSpacing * 7 / 2, y - pinSpacing / 2, x + pinSpacing, y - pinSpacing);
                    main = new Area(path2);
                }
            }
            if (this.getGateType().getNeedsCircle()) {
                Area circle = new Area(new Ellipse2D.Double(x + pinSpacing * 9 / 2, y - pinSpacing / 4 + (this.getControlPointCount() == 2 ? 0 : pinSpacing), pinSpacing / 2, pinSpacing / 2));
                main.add(circle);
            }
            this.body[0] = main;
            GeneralPath connections = new GeneralPath();
            if (this.getControlPointCount() == 2) {
                connections.moveTo(this.controlPoints[0].x, this.controlPoints[0].y);
                connections.lineTo(this.controlPoints[0].x + pinSpacing * 3 / 2, this.controlPoints[0].y);
                connections.moveTo(this.controlPoints[1].x, this.controlPoints[1].y);
                if (this.getGateType().getNeedsCircle()) {
                    connections.lineTo(this.controlPoints[1].x - pinSpacing, this.controlPoints[1].y);
                } else {
                    connections.lineTo(this.controlPoints[1].x - pinSpacing * 3 / 2, this.controlPoints[1].y);
                }
            } else {
                connections.moveTo(this.controlPoints[0].x, this.controlPoints[0].y);
                connections.lineTo(this.controlPoints[0].x + pinSpacing * 3 / 2, this.controlPoints[0].y);
                connections.moveTo(this.controlPoints[1].x, this.controlPoints[1].y);
                connections.lineTo(this.controlPoints[1].x + pinSpacing * 3 / 2, this.controlPoints[1].y);
                connections.moveTo(this.controlPoints[2].x, this.controlPoints[2].y);
                if (this.getGateType().getNeedsCircle()) {
                    connections.lineTo(this.controlPoints[2].x - pinSpacing, this.controlPoints[2].y);
                } else {
                    connections.lineTo(this.controlPoints[2].x - pinSpacing * 3 / 2, this.controlPoints[2].y);
                }
            }
            this.body[1] = connections;
            if (this.getGateType().toString().startsWith("X")) {
                Path2D.Double path = new Path2D.Double();
                ((Path2D)path).moveTo(x + pinSpacing / 2, y - pinSpacing);
                ((Path2D)path).curveTo(x + pinSpacing * 3 / 2, y, x + pinSpacing * 3 / 2, y + 2 * pinSpacing, x + pinSpacing / 2, y + pinSpacing * 3);
                this.body[2] = path;
            }
        }
        return this.body;
    }

    public VisibilityPolicy getControlPointVisibilityPolicy(int index) {
        return VisibilityPolicy.WHEN_SELECTED;
    }

    @EditableProperty
    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public boolean isControlPointSticky(int index) {
        return true;
    }

    public void setControlPoint(Point point, int index) {
        this.controlPoints[index].setLocation(point);
        this.body = null;
    }

    @EditableProperty(name="Type")
    public GateType getGateType() {
        return this.gateType;
    }

    public void setGateType(GateType gateType) {
        this.gateType = gateType;
        this.updateControlPoints();
        this.body = null;
    }

    @EditableProperty(name="Body")
    public Color getBodyColor() {
        return this.bodyColor;
    }

    public void setBodyColor(Color bodyColor) {
        this.bodyColor = bodyColor;
    }

    @EditableProperty(name="Border")
    public Color getBorderColor() {
        return this.borderColor;
    }

    public void setBorderColor(Color borderColor) {
        this.borderColor = borderColor;
    }

    @EditableProperty
    public Display getDisplay() {
        return this.display;
    }

    public void setDisplay(Display display) {
        this.display = display;
    }

    public boolean canPointMoveFreely(int pointIndex) {
        return false;
    }

    public static enum GateType {
        Buffer(false),
        Not(true),
        Or(false),
        And(false),
        Xor(false),
        Nor(true),
        Nand(true),
        Xnor(true);

        boolean needsCircle;

        private GateType(boolean needsCircle) {
            this.needsCircle = needsCircle;
        }

        public boolean getNeedsCircle() {
            return this.needsCircle;
        }
    }
}

