/*
 * Decompiled with CFR 0.152.
 */
package org.diylc.components.shapes;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.Point;
import java.util.Arrays;
import org.diylc.common.ObjectCache;
import org.diylc.common.SimpleComponentTransformer;
import org.diylc.components.shapes.AbstractShape;
import org.diylc.core.ComponentState;
import org.diylc.core.IDrawingObserver;
import org.diylc.core.Project;
import org.diylc.core.annotations.BomPolicy;
import org.diylc.core.annotations.ComponentDescriptor;
import org.diylc.core.annotations.EditableProperty;

@ComponentDescriptor(name="Polygon", author="Branislav Stojkovic", category="Shapes", instanceNamePrefix="POLY", description="Polygonal area", zOrder=4.0, flexibleZOrder=true, bomPolicy=BomPolicy.SHOW_ALL_NAMES, autoEdit=false, transformer=SimpleComponentTransformer.class)
public class Polygon
extends AbstractShape {
    private static final long serialVersionUID = 1L;
    protected PointCount pointCount = PointCount._4;

    public Polygon() {
        this.controlPoints = new Point[]{new Point(0, 0), new Point(0, (int)DEFAULT_HEIGHT.convertToPixels()), new Point((int)DEFAULT_WIDTH.convertToPixels(), (int)DEFAULT_HEIGHT.convertToPixels()), new Point((int)DEFAULT_WIDTH.convertToPixels(), 0)};
    }

    public void draw(Graphics2D g2d, ComponentState componentState, boolean outlineMode, Project project, IDrawingObserver drawingObserver) {
        g2d.setStroke(ObjectCache.getInstance().fetchBasicStroke((float)((int)this.borderThickness.convertToPixels())));
        g2d.setColor(this.color);
        int[] xPoints = new int[this.controlPoints.length];
        int[] yPoints = new int[this.controlPoints.length];
        for (int i = 0; i < this.controlPoints.length; ++i) {
            xPoints[i] = this.controlPoints[i].x;
            yPoints[i] = this.controlPoints[i].y;
        }
        Composite oldComposite = g2d.getComposite();
        if (this.alpha < MAX_ALPHA) {
            g2d.setComposite(AlphaComposite.getInstance(3, 1.0f * (float)this.alpha / (float)MAX_ALPHA));
        }
        g2d.fillPolygon(xPoints, yPoints, this.controlPoints.length);
        g2d.setComposite(oldComposite);
        drawingObserver.stopTracking();
        Color lineColor = componentState == ComponentState.SELECTED || componentState == ComponentState.DRAGGING ? SELECTION_COLOR : this.borderColor;
        g2d.setColor(lineColor);
        g2d.drawPolygon(xPoints, yPoints, this.controlPoints.length);
    }

    @EditableProperty(name="Edges")
    public PointCount getPointCount() {
        return this.pointCount;
    }

    public void setPointCount(PointCount pointCount) {
        if (this.pointCount == pointCount) {
            return;
        }
        int oldPointCount = Integer.parseInt(this.pointCount.toString());
        int newPointCount = Integer.parseInt(pointCount.toString());
        this.controlPoints = Arrays.copyOf(this.controlPoints, newPointCount);
        if (oldPointCount < newPointCount) {
            this.controlPoints[newPointCount - 1] = this.controlPoints[oldPointCount - 1];
            for (int i = oldPointCount - 1; i < newPointCount - 1; ++i) {
                this.controlPoints[i] = new Point((this.controlPoints[i - 1].x + this.controlPoints[newPointCount - 1].x) / 2, (this.controlPoints[i - 1].y + this.controlPoints[newPointCount - 1].y) / 2);
            }
        }
        this.pointCount = pointCount;
    }

    public void drawIcon(Graphics2D g2d, int width, int height) {
        int factor = 32 / width;
        g2d.setColor(COLOR);
        int[] x = new int[]{2 / factor, width - 2 / factor, width - 4 / factor, 3 / factor};
        int[] y = new int[]{4 / factor, 2 / factor, height - 5 / factor, height - 2 / factor};
        g2d.fillPolygon(x, y, 4);
        g2d.setColor(BORDER_COLOR);
        g2d.drawPolygon(x, y, 4);
    }

    public static enum PointCount {
        _3,
        _4,
        _5,
        _6,
        _7,
        _8;


        public String toString() {
            return this.name().substring(1);
        }
    }
}

