/*
 * Decompiled with CFR 0.152.
 */
package org.diylc.components.tube;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Rectangle2D;
import org.diylc.appframework.miscutils.ConfigurationManager;
import org.diylc.common.Display;
import org.diylc.common.ObjectCache;
import org.diylc.common.Orientation;
import org.diylc.components.AbstractTransparentComponent;
import org.diylc.core.ComponentState;
import org.diylc.core.IDrawingObserver;
import org.diylc.core.Project;
import org.diylc.core.Theme;
import org.diylc.core.VisibilityPolicy;
import org.diylc.core.annotations.EditableProperty;
import org.diylc.core.measures.Size;
import org.diylc.core.measures.SizeUnit;
import org.diylc.utils.Constants;

public class SubminiTube
extends AbstractTransparentComponent<String> {
    private static final long serialVersionUID = 1L;
    public static Color BODY_COLOR = Color.lightGray;
    public static Color BORDER_COLOR = Color.gray;
    public static Color PIN_COLOR = Color.decode("#00B2EE");
    public static Color PIN_BORDER_COLOR = PIN_COLOR.darker();
    public static Color LABEL_COLOR = Color.white;
    public static Size PIN_SIZE = new Size(Double.valueOf(0.03), SizeUnit.in);
    public static Size PIN_SPACING = new Size(Double.valueOf(0.1), SizeUnit.in);
    public static Size BODY_WIDTH = new Size(Double.valueOf(0.4), SizeUnit.in);
    public static Size BODY_THICKNESS = new Size(Double.valueOf(4.5), SizeUnit.mm);
    public static Size BODY_HEIGHT = new Size(Double.valueOf(9.0), SizeUnit.mm);
    public static Size DIAMETER = new Size(Double.valueOf(0.4), SizeUnit.in);
    public static Size LENGTH = new Size(Double.valueOf(1.375), SizeUnit.in);
    public static Size LEAD_LENGTH = new Size(Double.valueOf(0.2), SizeUnit.in);
    public static Size LEAD_THICKNESS = new Size(Double.valueOf(0.8), SizeUnit.mm);
    private String value = "";
    private Orientation orientation = Orientation.DEFAULT;
    private Point[] controlPoints = new Point[]{new Point(0, 0), new Point(0, 0), new Point(0, 0)};
    private transient Shape[] body;
    private Color bodyColor = BODY_COLOR;
    private Color borderColor = BORDER_COLOR;
    private Display display = Display.NAME;
    private boolean folded = false;
    private Size leadLength = LEAD_LENGTH;
    private PinArrangement leadArrangement = PinArrangement.Circular;
    private boolean topLead = false;
    private Size diameter = DIAMETER;
    private Size length = LENGTH;
    private PinCount pinCount = PinCount._8;
    private Size leadSpacing = PIN_SPACING;

    public SubminiTube() {
        this.updateControlPoints();
    }

    @EditableProperty
    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    @EditableProperty
    public Orientation getOrientation() {
        return this.orientation;
    }

    public void setOrientation(Orientation orientation) {
        this.orientation = orientation;
        this.updateControlPoints();
        this.body = null;
    }

    public int getControlPointCount() {
        return this.controlPoints.length;
    }

    public Point getControlPoint(int index) {
        return this.controlPoints[index];
    }

    public boolean isControlPointSticky(int index) {
        return true;
    }

    public VisibilityPolicy getControlPointVisibilityPolicy(int index) {
        return VisibilityPolicy.NEVER;
    }

    public void setControlPoint(Point point, int index) {
        this.controlPoints[index].setLocation(point);
        this.body = null;
    }

    private void updateControlPoints() {
        int pinSpacing = (int)PIN_SPACING.convertToPixels();
        int x = this.controlPoints[0].x;
        int y = this.controlPoints[0].y;
        int newPointCount = this.getPinCount().getValue();
        if (newPointCount != this.controlPoints.length) {
            this.controlPoints = new Point[newPointCount];
            for (int i = 0; i < this.controlPoints.length; ++i) {
                this.controlPoints[i] = new Point(x, y);
            }
        }
        if (this.folded) {
            int dy;
            int dx;
            switch (this.orientation) {
                case DEFAULT: {
                    dx = 0;
                    dy = pinSpacing;
                    break;
                }
                case _90: {
                    dx = -pinSpacing;
                    dy = 0;
                    break;
                }
                case _180: {
                    dx = 0;
                    dy = -pinSpacing;
                    break;
                }
                case _270: {
                    dx = pinSpacing;
                    dy = 0;
                    break;
                }
                default: {
                    throw new RuntimeException("Unexpected orientation: " + this.orientation);
                }
            }
            for (int i = 1; i < this.controlPoints.length; ++i) {
                this.controlPoints[i].setLocation(this.controlPoints[0].x + i * dx, this.controlPoints[0].y + i * dy);
            }
        } else {
            switch (this.orientation) {
                case DEFAULT: {
                    this.controlPoints[1].setLocation(x, y + pinSpacing);
                    this.controlPoints[2].setLocation(x, y + 2 * pinSpacing);
                    break;
                }
                case _90: {
                    this.controlPoints[1].setLocation(x - pinSpacing, y);
                    this.controlPoints[2].setLocation(x - 2 * pinSpacing, y);
                    break;
                }
                case _180: {
                    this.controlPoints[1].setLocation(x, y - pinSpacing);
                    this.controlPoints[2].setLocation(x, y - 2 * pinSpacing);
                    break;
                }
                case _270: {
                    this.controlPoints[1].setLocation(x + pinSpacing, y);
                    this.controlPoints[2].setLocation(x + 2 * pinSpacing, y);
                    break;
                }
                default: {
                    throw new RuntimeException("Unexpected orientation: " + this.orientation);
                }
            }
        }
    }

    public Shape[] getBody() {
        if (this.body == null) {
            this.body = new Shape[2];
            int x = this.controlPoints[0].x;
            int y = this.controlPoints[0].y;
            int pinSpacing = (int)PIN_SPACING.convertToPixels();
            int bodyWidth = this.getClosestOdd(BODY_WIDTH.convertToPixels());
            int bodyThickness = this.getClosestOdd(BODY_THICKNESS.convertToPixels());
            int bodyHeight = this.getClosestOdd(BODY_HEIGHT.convertToPixels());
            int tabThickness = 0;
            int tabHeight = 0;
            int tabHoleDiameter = 0;
            double leadLength = this.getLeadLength().convertToPixels();
            switch (this.orientation) {
                case DEFAULT: {
                    if (this.folded) {
                        this.body[0] = new Rectangle2D.Double((double)x + leadLength, y + pinSpacing - bodyWidth / 2, bodyHeight, bodyWidth);
                        this.body[1] = new Area(new Rectangle2D.Double((double)x + leadLength + (double)bodyHeight, y + pinSpacing - bodyWidth / 2, tabHeight, bodyWidth));
                        ((Area)this.body[1]).subtract(new Area(new Ellipse2D.Double((double)x + leadLength + (double)bodyHeight + (double)(tabHeight / 2) - (double)(tabHoleDiameter / 2), y + pinSpacing - tabHoleDiameter / 2, tabHoleDiameter, tabHoleDiameter)));
                        break;
                    }
                    this.body[0] = new Rectangle2D.Double(x - bodyThickness / 2, y + pinSpacing - bodyWidth / 2, bodyThickness, bodyWidth);
                    this.body[1] = new Rectangle2D.Double(x + bodyThickness / 2 - tabThickness, y + pinSpacing - bodyWidth / 2, tabThickness, bodyWidth);
                    break;
                }
                case _90: {
                    if (this.folded) {
                        this.body[0] = new Rectangle2D.Double(x - pinSpacing - bodyWidth / 2, (double)y + leadLength, bodyWidth, bodyHeight);
                        this.body[1] = new Area(new Rectangle2D.Double(x - pinSpacing - bodyWidth / 2, (double)y + leadLength + (double)bodyHeight, bodyWidth, tabHeight));
                        ((Area)this.body[1]).subtract(new Area(new Ellipse2D.Double(x - pinSpacing - tabHoleDiameter / 2, (double)y + leadLength + (double)bodyHeight + (double)(tabHeight / 2) - (double)(tabHoleDiameter / 2), tabHoleDiameter, tabHoleDiameter)));
                        break;
                    }
                    this.body[0] = new Rectangle2D.Double(x - pinSpacing - bodyWidth / 2, y - bodyThickness / 2, bodyWidth, bodyThickness);
                    this.body[1] = new Rectangle2D.Double(x - pinSpacing - bodyWidth / 2, y + bodyThickness / 2 - tabThickness, bodyWidth, tabThickness);
                    break;
                }
                case _180: {
                    if (this.folded) {
                        this.body[0] = new Rectangle2D.Double((double)x - leadLength - (double)bodyHeight, y - pinSpacing - bodyWidth / 2, bodyHeight, bodyWidth);
                        this.body[1] = new Area(new Rectangle2D.Double((double)x - leadLength - (double)bodyHeight - (double)tabHeight, y - pinSpacing - bodyWidth / 2, tabHeight, bodyWidth));
                        ((Area)this.body[1]).subtract(new Area(new Ellipse2D.Double((double)x - leadLength - (double)bodyHeight - (double)(tabHeight / 2) - (double)(tabHoleDiameter / 2), y - pinSpacing - tabHoleDiameter / 2, tabHoleDiameter, tabHoleDiameter)));
                        break;
                    }
                    this.body[0] = new Rectangle2D.Double(x - bodyThickness / 2, y - pinSpacing - bodyWidth / 2, bodyThickness, bodyWidth);
                    this.body[1] = new Rectangle2D.Double(x - bodyThickness / 2, y - pinSpacing - bodyWidth / 2, tabThickness, bodyWidth);
                    break;
                }
                case _270: {
                    if (this.folded) {
                        this.body[0] = new Rectangle2D.Double(x + pinSpacing - bodyWidth / 2, (double)y - leadLength - (double)bodyHeight, bodyWidth, bodyHeight);
                        this.body[1] = new Area(new Rectangle2D.Double(x + pinSpacing - bodyWidth / 2, (double)y - leadLength - (double)bodyHeight - (double)tabHeight, bodyWidth, tabHeight));
                        ((Area)this.body[1]).subtract(new Area(new Ellipse2D.Double(x + pinSpacing - tabHoleDiameter / 2, (double)y - leadLength - (double)bodyHeight - (double)(tabHeight / 2) - (double)(tabHoleDiameter / 2), tabHoleDiameter, tabHoleDiameter)));
                        break;
                    }
                    this.body[0] = new Rectangle2D.Double(x + pinSpacing - bodyWidth / 2, y - bodyThickness / 2, bodyWidth, bodyThickness);
                    this.body[1] = new Rectangle2D.Double(x + pinSpacing - bodyWidth / 2, y - bodyThickness / 2, bodyWidth, tabThickness);
                    break;
                }
                default: {
                    throw new RuntimeException("Unexpected orientation: " + this.orientation);
                }
            }
        }
        return this.body;
    }

    public void draw(Graphics2D g2d, ComponentState componentState, boolean outlineMode, Project project, IDrawingObserver drawingObserver) {
        if (this.checkPointsClipped(g2d.getClip())) {
            return;
        }
        int pinSize = (int)PIN_SIZE.convertToPixels() / 2 * 2;
        Shape mainArea = this.getBody()[0];
        Shape tabArea = this.getBody()[1];
        Composite oldComposite = g2d.getComposite();
        if (this.alpha < MAX_ALPHA) {
            g2d.setComposite(AlphaComposite.getInstance(3, 1.0f * (float)this.alpha / (float)MAX_ALPHA));
        }
        g2d.setColor(outlineMode ? Constants.TRANSPARENT_COLOR : this.bodyColor);
        g2d.fill(mainArea);
        Theme theme = (Theme)ConfigurationManager.getInstance().readObject("theme", (Object)Constants.DEFAULT_THEME);
        if (this.folded) {
            Color finalPinBorderColor;
            Color finalPinColor;
            int leadThickness = this.getClosestOdd(LEAD_THICKNESS.convertToPixels());
            int leadLength = (int)this.getLeadLength().convertToPixels();
            if (outlineMode) {
                finalPinColor = new Color(0, 0, 0, 0);
                finalPinBorderColor = componentState == ComponentState.SELECTED || componentState == ComponentState.DRAGGING ? SELECTION_COLOR : theme.getOutlineColor();
            } else {
                finalPinColor = METAL_COLOR;
                finalPinBorderColor = METAL_COLOR.darker();
            }
            block6: for (Point point : this.controlPoints) {
                switch (this.orientation) {
                    case DEFAULT: {
                        g2d.setStroke(ObjectCache.getInstance().fetchBasicStroke((float)leadThickness));
                        g2d.setColor(finalPinBorderColor);
                        g2d.drawLine(point.x, point.y, point.x + leadLength - leadThickness / 2, point.y);
                        g2d.setStroke(ObjectCache.getInstance().fetchBasicStroke((float)(leadThickness - 2)));
                        g2d.setColor(finalPinColor);
                        g2d.drawLine(point.x, point.y, point.x + leadLength - leadThickness / 2, point.y);
                        continue block6;
                    }
                    case _90: {
                        g2d.setStroke(ObjectCache.getInstance().fetchBasicStroke((float)leadThickness));
                        g2d.setColor(finalPinBorderColor);
                        g2d.drawLine(point.x, point.y, point.x, point.y + leadLength - leadThickness / 2);
                        g2d.setStroke(ObjectCache.getInstance().fetchBasicStroke((float)(leadThickness - 2)));
                        g2d.setColor(finalPinColor);
                        g2d.drawLine(point.x, point.y, point.x, point.y + leadLength - leadThickness / 2);
                        continue block6;
                    }
                    case _180: {
                        g2d.setStroke(ObjectCache.getInstance().fetchBasicStroke((float)leadThickness));
                        g2d.setColor(finalPinBorderColor);
                        g2d.drawLine(point.x, point.y, point.x - leadLength - leadThickness / 2, point.y);
                        g2d.setStroke(ObjectCache.getInstance().fetchBasicStroke((float)(leadThickness - 2)));
                        g2d.setColor(finalPinColor);
                        g2d.drawLine(point.x, point.y, point.x - leadLength - leadThickness / 2, point.y);
                        continue block6;
                    }
                    case _270: {
                        g2d.setStroke(ObjectCache.getInstance().fetchBasicStroke((float)leadThickness));
                        g2d.setColor(finalPinBorderColor);
                        g2d.drawLine(point.x, point.y, point.x, point.y - leadLength);
                        g2d.setStroke(ObjectCache.getInstance().fetchBasicStroke((float)(leadThickness - 2)));
                        g2d.setColor(finalPinColor);
                        g2d.drawLine(point.x, point.y, point.x, point.y - leadLength);
                    }
                }
            }
        } else if (!outlineMode) {
            for (Point point : this.controlPoints) {
                g2d.setColor(PIN_COLOR);
                g2d.fillOval(point.x - pinSize / 2, point.y - pinSize / 2, pinSize, pinSize);
                g2d.setColor(outlineMode ? theme.getOutlineColor() : PIN_BORDER_COLOR);
                g2d.drawOval(point.x - pinSize / 2, point.y - pinSize / 2, pinSize, pinSize);
            }
        }
        g2d.setFont(project.getFont());
        Color finalLabelColor = outlineMode ? (componentState == ComponentState.SELECTED || componentState == ComponentState.DRAGGING ? LABEL_COLOR_SELECTED : theme.getOutlineColor()) : (componentState == ComponentState.SELECTED || componentState == ComponentState.DRAGGING ? LABEL_COLOR_SELECTED : LABEL_COLOR);
        g2d.setColor(finalLabelColor);
        String label = "";
        String string = label = this.getDisplay() == Display.NAME ? this.getName() : this.getValue();
        if (this.getDisplay() == Display.NONE) {
            label = "";
        }
        if (this.getDisplay() == Display.BOTH) {
            label = this.getName() + "  " + (this.getValue() == null ? "" : this.getValue().toString());
        }
        FontMetrics fontMetrics = g2d.getFontMetrics(g2d.getFont());
        Rectangle2D rect = fontMetrics.getStringBounds(label, g2d);
        int textHeight = (int)rect.getHeight();
        int textWidth = (int)rect.getWidth();
        Rectangle bounds = mainArea.getBounds();
        int x = bounds.x + (bounds.width - textWidth) / 2;
        int y = bounds.y + (bounds.height - textHeight) / 2 + fontMetrics.getAscent();
        g2d.drawString(label, x, y);
    }

    public void drawIcon(Graphics2D g2d, int width, int height) {
        int margin = 2 * width / 32;
        int bodySize = width * 5 / 10;
        int tabSize = bodySize * 6 / 10;
        int holeSize = 5 * width / 32;
        Area a = new Area(new Rectangle2D.Double((width - bodySize) / 2, margin, bodySize, tabSize));
        a.subtract(new Area(new Ellipse2D.Double(width / 2 - holeSize / 2, margin + tabSize / 2 - holeSize / 2, holeSize, holeSize)));
        g2d.setColor(BORDER_COLOR);
        g2d.draw(a);
        g2d.setColor(BODY_COLOR);
        g2d.fillRect((width - bodySize) / 2, margin + tabSize, bodySize, bodySize);
        g2d.setColor(BORDER_COLOR);
        g2d.drawRect((width - bodySize) / 2, margin + tabSize, bodySize, bodySize);
        g2d.setColor(METAL_COLOR);
        g2d.setStroke(ObjectCache.getInstance().fetchBasicStroke(2.0f));
        g2d.drawLine(width / 2, margin + tabSize + bodySize, width / 2, height - margin);
        g2d.drawLine(width / 2 - bodySize / 3, margin + tabSize + bodySize, width / 2 - bodySize / 3, height - margin);
        g2d.drawLine(width / 2 + bodySize / 3, margin + tabSize + bodySize, width / 2 + bodySize / 3, height - margin);
    }

    @EditableProperty(name="Body")
    public Color getBodyColor() {
        return this.bodyColor;
    }

    public void setBodyColor(Color bodyColor) {
        this.bodyColor = bodyColor;
    }

    @EditableProperty(name="Border")
    public Color getBorderColor() {
        return this.borderColor;
    }

    public void setBorderColor(Color borderColor) {
        this.borderColor = borderColor;
    }

    @EditableProperty
    public boolean getFolded() {
        return this.folded;
    }

    public void setFolded(boolean folded) {
        this.folded = folded;
        this.body = null;
    }

    @EditableProperty(name="Lead Length")
    public Size getLeadLength() {
        if (this.leadLength == null) {
            this.leadLength = LEAD_LENGTH;
        }
        return this.leadLength;
    }

    public void setLeadLength(Size leadLength) {
        this.leadLength = leadLength;
        this.body = null;
    }

    @EditableProperty
    public Display getDisplay() {
        if (this.display == null) {
            this.display = Display.NAME;
        }
        return this.display;
    }

    public void setDisplay(Display display) {
        this.display = display;
    }

    @EditableProperty(name="Pin Arrangement")
    public PinArrangement getPinArrangement() {
        return this.leadArrangement;
    }

    public void setPinArrangement(PinArrangement pinArrangement) {
        this.leadArrangement = pinArrangement;
    }

    @EditableProperty(name="Top Lead")
    public boolean getTopLead() {
        return this.topLead;
    }

    public void setTopLead(boolean topLead) {
        this.topLead = topLead;
        this.updateControlPoints();
    }

    @EditableProperty
    public Size getDiameter() {
        return this.diameter;
    }

    public void setDiameter(Size diameter) {
        this.diameter = diameter;
        this.updateControlPoints();
    }

    @EditableProperty
    public Size getLength() {
        return this.length;
    }

    public void setLength(Size length) {
        this.length = length;
    }

    @EditableProperty(name="Lead Count")
    public PinCount getPinCount() {
        return this.pinCount;
    }

    public void setPinCount(PinCount pinCount) {
        this.pinCount = pinCount;
        this.updateControlPoints();
    }

    @EditableProperty(name="Lead Spacing")
    public Size getLeadSpacing() {
        return this.leadSpacing;
    }

    public void setLeadSpacing(Size leadSpacing) {
        this.leadSpacing = leadSpacing;
        this.updateControlPoints();
    }

    public static enum PinCount {
        _3,
        _4,
        _5,
        _6,
        _7,
        _8,
        _9,
        _10;


        public String toString() {
            return this.name().replace("_", "");
        }

        public int getValue() {
            return Integer.parseInt(this.toString());
        }
    }

    public static enum PinArrangement {
        Inline("In-line"),
        Circular("Circular");

        private String label;

        private PinArrangement(String label) {
            this.label = label;
        }

        public String toString() {
            return this.label;
        }
    }
}

