/*
 * Decompiled with CFR 0.152.
 */
package org.diylc.core.annotations;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public final class Defaults {
    private static final Map<Class<?>, Object> DEFAULTS;

    private Defaults() {
    }

    private static <T> void put(Map<Class<?>, Object> map, Class<T> clazz, T t) {
        map.put(clazz, t);
    }

    public static <T> T defaultValue(Class<T> clazz) throws Exception {
        Object object = DEFAULTS.get(clazz);
        if (object == null) {
            return (T)clazz.getConstructors()[0].newInstance(new Object[0]);
        }
        return (T)object;
    }

    static {
        HashMap hashMap = new HashMap();
        Defaults.put(hashMap, Boolean.TYPE, false);
        Defaults.put(hashMap, Boolean.class, false);
        Defaults.put(hashMap, Character.TYPE, Character.valueOf('\u0000'));
        Defaults.put(hashMap, Byte.TYPE, (byte)0);
        Defaults.put(hashMap, Byte.class, (byte)0);
        Defaults.put(hashMap, Short.TYPE, (short)0);
        Defaults.put(hashMap, Short.class, (short)0);
        Defaults.put(hashMap, Integer.TYPE, 0);
        Defaults.put(hashMap, Integer.class, 0);
        Defaults.put(hashMap, Long.TYPE, 0L);
        Defaults.put(hashMap, Long.class, 0L);
        Defaults.put(hashMap, Float.TYPE, Float.valueOf(0.0f));
        Defaults.put(hashMap, Float.class, Float.valueOf(0.0f));
        Defaults.put(hashMap, Double.TYPE, 0.0);
        Defaults.put(hashMap, Double.class, 0.0);
        DEFAULTS = Collections.unmodifiableMap(hashMap);
    }
}

