/*
 * Decompiled with CFR 0.152.
 */
package org.diylc.presenter;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ImageObserver;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.RenderableImage;
import java.text.AttributedCharacterIterator;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.diylc.common.ObjectCache;
import org.diylc.common.ZoomableStroke;
import org.diylc.core.IDrawingObserver;
import org.diylc.presenter.ComponentArea;

class G2DWrapper
extends Graphics2D
implements IDrawingObserver {
    public static int LINE_SENSITIVITY_MARGIN = 2;
    public static int CURVE_SENSITIVITY = 6;
    private boolean drawingComponent = false;
    private boolean trackingAllowed = true;
    private boolean trackingContinuityAllowed = false;
    private boolean trackingContinuityPositive = true;
    private Graphics2D canvasGraphics;
    private Stroke originalStroke;
    private Color originalColor;
    private Composite originalComposite;
    private AffineTransform originalTx;
    private Font originalFont;
    private AffineTransform currentTx;
    private AffineTransform initialTx;
    private Area currentArea;
    private List<Area> continuityPositiveAreas;
    private List<Area> continuityNegativeAreas;
    private Shape lastShape;
    private double zoom;

    public G2DWrapper(Graphics2D graphics2D, double d) {
        this.canvasGraphics = graphics2D;
        this.zoom = d;
        this.currentArea = new Area();
        this.continuityPositiveAreas = new ArrayList<Area>();
        this.continuityNegativeAreas = new ArrayList<Area>();
        this.currentTx = new AffineTransform();
    }

    public void startedDrawingComponent() {
        this.drawingComponent = true;
        this.currentArea = new Area();
        this.continuityPositiveAreas = new ArrayList<Area>();
        this.continuityNegativeAreas = new ArrayList<Area>();
        this.originalStroke = this.canvasGraphics.getStroke();
        this.originalColor = this.canvasGraphics.getColor();
        this.originalTx = this.canvasGraphics.getTransform();
        this.originalComposite = this.canvasGraphics.getComposite();
        this.originalFont = this.canvasGraphics.getFont();
        this.currentTx = new AffineTransform();
        this.initialTx = this.canvasGraphics.getTransform();
        this.lastShape = null;
        this.startTracking();
    }

    public ComponentArea finishedDrawingComponent() {
        this.drawingComponent = false;
        this.canvasGraphics.setStroke(this.originalStroke);
        this.canvasGraphics.setColor(this.originalColor);
        this.canvasGraphics.setTransform(this.originalTx);
        this.canvasGraphics.setComposite(this.originalComposite);
        this.canvasGraphics.setFont(this.originalFont);
        return new ComponentArea(this.currentArea, this.continuityPositiveAreas, this.continuityNegativeAreas);
    }

    @Override
    public void startTracking() {
        this.trackingAllowed = true;
    }

    @Override
    public void stopTracking() {
        this.trackingAllowed = false;
    }

    @Override
    public void startTrackingContinuityArea(boolean bl) {
        this.trackingContinuityAllowed = true;
        this.trackingContinuityPositive = bl;
    }

    @Override
    public void stopTrackingContinuityArea() {
        this.trackingContinuityAllowed = false;
    }

    @Override
    public boolean isTrackingContinuityArea() {
        return this.trackingContinuityAllowed;
    }

    private void appendShape(Shape shape) {
        if (!this.drawingComponent || !this.trackingAllowed && !this.trackingContinuityAllowed) {
            return;
        }
        Rectangle2D rectangle2D = shape.getBounds2D();
        if (rectangle2D.getWidth() > 1.0 && rectangle2D.getHeight() > 1.0) {
            Area area = new Area(shape);
            area.transform(this.currentTx);
            if (this.trackingAllowed) {
                this.currentArea.add(area);
            }
            if (this.trackingContinuityAllowed) {
                if (this.trackingContinuityPositive) {
                    this.continuityPositiveAreas.add(area);
                } else {
                    this.continuityNegativeAreas.add(area);
                }
            }
            this.lastShape = shape;
        }
    }

    private void appendShapeOutline(Shape shape) {
        if (!this.drawingComponent || !this.trackingAllowed || shape.equals(this.lastShape)) {
            return;
        }
        Stroke stroke = this.getStroke();
        if (stroke instanceof BasicStroke) {
            BasicStroke basicStroke = (BasicStroke)stroke;
            if (basicStroke.getLineWidth() < 3.0f) {
                this.appendShape(ObjectCache.getInstance().fetchBasicStroke(3.0f).createStrokedShape(shape));
            } else {
                this.appendShape(this.getStroke().createStrokedShape(shape));
            }
        } else {
            this.appendShape(this.getStroke().createStrokedShape(shape));
        }
    }

    @Override
    public void addRenderingHints(Map<?, ?> map) {
        this.canvasGraphics.addRenderingHints(map);
    }

    @Override
    public void clip(Shape shape) {
        this.canvasGraphics.clip(shape);
    }

    @Override
    public void draw(Shape shape) {
        this.canvasGraphics.draw(shape);
        if (this.drawingComponent && this.trackingAllowed) {
            this.appendShapeOutline(shape);
        }
    }

    @Override
    public void drawGlyphVector(GlyphVector glyphVector, float f, float f2) {
        this.canvasGraphics.drawGlyphVector(glyphVector, f, f2);
    }

    @Override
    public boolean drawImage(Image image, AffineTransform affineTransform, ImageObserver imageObserver) {
        return this.canvasGraphics.drawImage(image, affineTransform, imageObserver);
    }

    @Override
    public void drawImage(BufferedImage bufferedImage, BufferedImageOp bufferedImageOp, int n, int n2) {
        this.canvasGraphics.drawImage(bufferedImage, bufferedImageOp, n, n2);
    }

    @Override
    public void drawRenderableImage(RenderableImage renderableImage, AffineTransform affineTransform) {
        this.canvasGraphics.drawRenderableImage(renderableImage, affineTransform);
    }

    @Override
    public void drawRenderedImage(RenderedImage renderedImage, AffineTransform affineTransform) {
        this.canvasGraphics.drawRenderedImage(renderedImage, affineTransform);
    }

    @Override
    public void drawString(String string, int n, int n2) {
        this.canvasGraphics.drawString(string, n, n2);
        if (this.drawingComponent && this.trackingAllowed) {
            FontMetrics fontMetrics = this.canvasGraphics.getFontMetrics();
            Rectangle2D rectangle2D = fontMetrics.getStringBounds(string, this.canvasGraphics);
            Point2D.Double double_ = new Point2D.Double(n, n2);
            Rectangle2D.Double double_2 = new Rectangle2D.Double(rectangle2D.getX() + ((Point2D)double_).getX(), rectangle2D.getY() + ((Point2D)double_).getY(), rectangle2D.getWidth(), rectangle2D.getHeight());
            this.appendShape(double_2);
        }
    }

    @Override
    public void drawString(String string, float f, float f2) {
        this.canvasGraphics.drawString(string, f, f2);
        if (this.drawingComponent && this.trackingAllowed) {
            FontMetrics fontMetrics = this.canvasGraphics.getFontMetrics();
            Rectangle2D rectangle2D = fontMetrics.getStringBounds(string, this.canvasGraphics);
            this.appendShape(new Rectangle2D.Double(rectangle2D.getX() + (double)f, rectangle2D.getY() + (double)f2, rectangle2D.getWidth(), rectangle2D.getHeight()));
        }
    }

    @Override
    public void drawString(AttributedCharacterIterator attributedCharacterIterator, int n, int n2) {
        this.canvasGraphics.drawString(attributedCharacterIterator, n, n2);
    }

    @Override
    public void drawString(AttributedCharacterIterator attributedCharacterIterator, float f, float f2) {
        this.canvasGraphics.drawString(attributedCharacterIterator, f, f2);
    }

    @Override
    public void fill(Shape shape) {
        this.canvasGraphics.fill(shape);
        this.appendShape(shape);
    }

    @Override
    public Color getBackground() {
        return this.canvasGraphics.getBackground();
    }

    @Override
    public Composite getComposite() {
        return this.canvasGraphics.getComposite();
    }

    @Override
    public GraphicsConfiguration getDeviceConfiguration() {
        return this.canvasGraphics.getDeviceConfiguration();
    }

    @Override
    public FontRenderContext getFontRenderContext() {
        return this.canvasGraphics.getFontRenderContext();
    }

    @Override
    public Paint getPaint() {
        return this.canvasGraphics.getPaint();
    }

    @Override
    public Object getRenderingHint(RenderingHints.Key key) {
        return this.canvasGraphics.getRenderingHint(key);
    }

    @Override
    public RenderingHints getRenderingHints() {
        return this.canvasGraphics.getRenderingHints();
    }

    @Override
    public Stroke getStroke() {
        return this.canvasGraphics.getStroke();
    }

    @Override
    public AffineTransform getTransform() {
        return this.canvasGraphics.getTransform();
    }

    @Override
    public boolean hit(Rectangle rectangle, Shape shape, boolean bl) {
        return this.canvasGraphics.hit(rectangle, shape, bl);
    }

    @Override
    public void rotate(double d) {
        this.canvasGraphics.rotate(d);
        this.currentTx.rotate(d);
    }

    @Override
    public void rotate(double d, double d2, double d3) {
        this.canvasGraphics.rotate(d, d2, d3);
        this.currentTx.rotate(d, d2, d3);
    }

    @Override
    public void scale(double d, double d2) {
        this.canvasGraphics.scale(d, d2);
        this.currentTx.scale(d, d2);
    }

    @Override
    public void setBackground(Color color) {
        this.canvasGraphics.setBackground(color);
    }

    @Override
    public void setComposite(Composite composite) {
        this.canvasGraphics.setComposite(composite);
    }

    @Override
    public void setPaint(Paint paint) {
        this.canvasGraphics.setPaint(paint);
    }

    @Override
    public void setRenderingHint(RenderingHints.Key key, Object object) {
        this.canvasGraphics.setRenderingHint(key, object);
    }

    @Override
    public void setRenderingHints(Map<?, ?> map) {
        this.canvasGraphics.setRenderingHints(map);
    }

    @Override
    public void setStroke(Stroke stroke) {
        BasicStroke basicStroke;
        if (this.zoom > 1.0 && stroke instanceof BasicStroke && (basicStroke = (BasicStroke)stroke).getLineWidth() <= 2.0f && !(stroke instanceof ZoomableStroke)) {
            stroke = ObjectCache.getInstance().fetchStroke((float)((double)basicStroke.getLineWidth() / this.zoom), basicStroke.getDashArray(), basicStroke.getDashPhase(), basicStroke.getEndCap());
        }
        this.canvasGraphics.setStroke(stroke);
    }

    @Override
    public void setTransform(AffineTransform affineTransform) {
        this.canvasGraphics.setTransform(affineTransform);
        this.currentTx = new AffineTransform(affineTransform);
        try {
            AffineTransform affineTransform2 = this.initialTx.createInverse();
            Point2D.Double double_ = new Point2D.Double(this.currentTx.getTranslateX(), this.currentTx.getTranslateY());
            affineTransform2.transform(double_, double_);
            this.currentTx.concatenate(affineTransform2);
            double[] dArray = new double[6];
            this.currentTx.getMatrix(dArray);
            this.currentTx.setTransform(dArray[0], dArray[1], dArray[2], dArray[3], ((Point2D)double_).getX(), ((Point2D)double_).getY());
        }
        catch (NoninvertibleTransformException noninvertibleTransformException) {
            // empty catch block
        }
    }

    @Override
    public void shear(double d, double d2) {
        this.canvasGraphics.shear(d, d2);
        this.currentTx.shear(d, d2);
    }

    @Override
    public void transform(AffineTransform affineTransform) {
        this.canvasGraphics.transform(affineTransform);
        this.currentTx.concatenate(affineTransform);
    }

    @Override
    public void translate(int n, int n2) {
        this.canvasGraphics.translate(n, n2);
        this.currentTx.translate(n, n2);
    }

    @Override
    public void translate(double d, double d2) {
        this.canvasGraphics.translate(d, d2);
        this.currentTx.translate(d, d2);
    }

    @Override
    public void clearRect(int n, int n2, int n3, int n4) {
        this.canvasGraphics.clearRect(n, n2, n3, n4);
    }

    @Override
    public void clipRect(int n, int n2, int n3, int n4) {
        this.canvasGraphics.clipRect(n, n2, n3, n4);
    }

    @Override
    public void copyArea(int n, int n2, int n3, int n4, int n5, int n6) {
        this.canvasGraphics.copyArea(n, n2, n3, n4, n5, n6);
    }

    @Override
    public Graphics create() {
        return this.canvasGraphics.create();
    }

    @Override
    public void dispose() {
        this.canvasGraphics.dispose();
    }

    @Override
    public void drawArc(int n, int n2, int n3, int n4, int n5, int n6) {
        this.canvasGraphics.drawArc(n, n2, n3, n4, n5, n6);
    }

    @Override
    public boolean drawImage(Image image, int n, int n2, ImageObserver imageObserver) {
        boolean bl = this.canvasGraphics.drawImage(image, n, n2, imageObserver);
        this.appendShape(new Rectangle2D.Double(n, n2, image.getWidth(imageObserver), image.getHeight(imageObserver)));
        return bl;
    }

    @Override
    public boolean drawImage(Image image, int n, int n2, Color color, ImageObserver imageObserver) {
        return this.canvasGraphics.drawImage(image, n, n2, color, imageObserver);
    }

    @Override
    public boolean drawImage(Image image, int n, int n2, int n3, int n4, ImageObserver imageObserver) {
        return this.canvasGraphics.drawImage(image, n, n2, n3, n4, imageObserver);
    }

    @Override
    public boolean drawImage(Image image, int n, int n2, int n3, int n4, Color color, ImageObserver imageObserver) {
        return this.canvasGraphics.drawImage(image, n, n2, n3, n4, color, imageObserver);
    }

    @Override
    public boolean drawImage(Image image, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, ImageObserver imageObserver) {
        return this.canvasGraphics.drawImage(image, n, n2, n3, n4, n5, n6, n7, n8, imageObserver);
    }

    @Override
    public boolean drawImage(Image image, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, Color color, ImageObserver imageObserver) {
        return this.drawImage(image, n, n2, n3, n4, n5, n6, n7, n8, color, imageObserver);
    }

    @Override
    public void drawLine(int n, int n2, int n3, int n4) {
        this.canvasGraphics.drawLine(n, n2, n3, n4);
        if (this.drawingComponent && (this.trackingAllowed || this.trackingContinuityAllowed)) {
            this.appendShapeOutline(new Line2D.Double(n, n2, n3, n4));
        }
    }

    @Override
    public void drawOval(int n, int n2, int n3, int n4) {
        this.canvasGraphics.drawOval(n, n2, n3, n4);
        if (this.drawingComponent && (this.trackingAllowed || this.trackingContinuityAllowed)) {
            this.appendShapeOutline(new Ellipse2D.Double(n, n2, n3, n4));
        }
    }

    @Override
    public void drawPolygon(int[] nArray, int[] nArray2, int n) {
        this.canvasGraphics.drawPolygon(nArray, nArray2, n);
        if (this.drawingComponent && (this.trackingAllowed || this.trackingContinuityAllowed)) {
            this.appendShapeOutline(new Polygon(nArray, nArray2, n));
        }
    }

    @Override
    public void drawPolyline(int[] nArray, int[] nArray2, int n) {
        this.canvasGraphics.drawPolyline(nArray, nArray2, n);
    }

    @Override
    public void drawRoundRect(int n, int n2, int n3, int n4, int n5, int n6) {
        this.canvasGraphics.drawRoundRect(n, n2, n3, n4, n5, n6);
        if (this.drawingComponent && (this.trackingAllowed || this.trackingContinuityAllowed)) {
            this.appendShapeOutline(new RoundRectangle2D.Double(n, n2, n3, n4, n5, n6));
        }
    }

    @Override
    public void fillArc(int n, int n2, int n3, int n4, int n5, int n6) {
        this.canvasGraphics.fillArc(n, n2, n3, n4, n5, n6);
        if (this.drawingComponent && (this.trackingAllowed || this.trackingContinuityAllowed)) {
            this.appendShape(new Arc2D.Double(n, n2, n3, n4, n5, n6, 2));
        }
    }

    @Override
    public void fillOval(int n, int n2, int n3, int n4) {
        this.canvasGraphics.fillOval(n, n2, n3, n4);
        if (this.drawingComponent && (this.trackingAllowed || this.trackingContinuityAllowed)) {
            this.appendShape(new Ellipse2D.Double(n, n2, n3, n4));
        }
    }

    @Override
    public void fillPolygon(int[] nArray, int[] nArray2, int n) {
        this.canvasGraphics.fillPolygon(nArray, nArray2, n);
        if (this.drawingComponent && (this.trackingAllowed || this.trackingContinuityAllowed)) {
            this.appendShape(new Polygon(nArray, nArray2, n));
        }
    }

    @Override
    public void drawRect(int n, int n2, int n3, int n4) {
        this.canvasGraphics.drawRect(n, n2, n3, n4);
        if (this.drawingComponent && (this.trackingAllowed || this.trackingContinuityAllowed)) {
            this.appendShapeOutline(new Rectangle(n, n2, n3, n4));
        }
    }

    @Override
    public void fillRect(int n, int n2, int n3, int n4) {
        this.canvasGraphics.fillRect(n, n2, n3, n4);
        if (this.drawingComponent && (this.trackingAllowed || this.trackingContinuityAllowed)) {
            this.appendShape(new Rectangle(n, n2, n3, n4));
        }
    }

    @Override
    public void fillRoundRect(int n, int n2, int n3, int n4, int n5, int n6) {
        this.canvasGraphics.fillRoundRect(n, n2, n3, n4, n5, n6);
        if (this.drawingComponent && (this.trackingAllowed || this.trackingContinuityAllowed)) {
            this.appendShape(new RoundRectangle2D.Double(n, n2, n3, n4, n5, n6));
        }
    }

    @Override
    public Shape getClip() {
        return this.canvasGraphics.getClip();
    }

    @Override
    public Rectangle getClipBounds() {
        return this.canvasGraphics.getClipBounds();
    }

    @Override
    public Color getColor() {
        return this.canvasGraphics.getColor();
    }

    @Override
    public Font getFont() {
        return this.canvasGraphics.getFont();
    }

    @Override
    public FontMetrics getFontMetrics(Font font) {
        return this.canvasGraphics.getFontMetrics(font);
    }

    @Override
    public void setClip(Shape shape) {
        this.canvasGraphics.setClip(shape);
    }

    @Override
    public void setClip(int n, int n2, int n3, int n4) {
        this.canvasGraphics.setClip(n, n2, n3, n4);
    }

    @Override
    public void setColor(Color color) {
        this.canvasGraphics.setColor(color);
    }

    @Override
    public void setFont(Font font) {
        this.canvasGraphics.setFont(font);
    }

    @Override
    public void setPaintMode() {
        this.canvasGraphics.setPaintMode();
    }

    @Override
    public void setXORMode(Color color) {
        this.canvasGraphics.setXORMode(color);
    }
}

