/*
 * Decompiled with CFR 0.152.
 */
package org.diylc.utils;

import java.util.HashSet;
import org.diylc.common.ComponentType;
import org.diylc.core.IDIYComponent;
import org.diylc.core.Project;
import org.diylc.core.annotations.KeywordPolicy;
import org.diylc.presenter.ComponentProcessor;

public class KeywordExtractor {
    private static KeywordExtractor instance;

    public static KeywordExtractor getInstance() {
        if (instance == null) {
            instance = new KeywordExtractor();
        }
        return instance;
    }

    private KeywordExtractor() {
    }

    public String extractKeywords(Project project) {
        HashSet<String> hashSet = new HashSet<String>();
        for (IDIYComponent<?> object : project.getComponents()) {
            ComponentType componentType = ComponentProcessor.getInstance().extractComponentTypeFrom(object.getClass());
            if (componentType.getKeywordPolicy() == KeywordPolicy.SHOW_TYPE_NAME) {
                hashSet.add(componentType.getName().toLowerCase());
            }
            if ((componentType.getKeywordPolicy() == KeywordPolicy.SHOW_VALUE || componentType.getKeywordPolicy() == KeywordPolicy.SHOW_TAG_AND_VALUE) && object.getValueForDisplay() != null && object.getValueForDisplay().trim().length() > 0) {
                hashSet.add(object.getValueForDisplay().trim().toLowerCase());
            }
            if (componentType.getKeywordPolicy() != KeywordPolicy.SHOW_TAG && componentType.getKeywordPolicy() != KeywordPolicy.SHOW_TAG_AND_VALUE || componentType.getKeywordTag() == null || componentType.getKeywordTag().length() <= 0) continue;
            hashSet.add(componentType.getKeywordTag().trim().toLowerCase());
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (String string : hashSet) {
            stringBuilder.append(string).append(",");
        }
        if (stringBuilder.length() > 0) {
            stringBuilder.deleteCharAt(stringBuilder.length() - 1);
        }
        return stringBuilder.toString();
    }
}

