/*
 * Decompiled with CFR 0.152.
 */
package com.eteks.sweethome3d.model;

import com.eteks.sweethome3d.model.DoorOrWindow;
import com.eteks.sweethome3d.model.HomeObject;
import com.eteks.sweethome3d.model.HomePieceOfFurniture;
import com.eteks.sweethome3d.model.Sash;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Arrays;

public class HomeDoorOrWindow
extends HomePieceOfFurniture
implements DoorOrWindow {
    private static final long serialVersionUID = 1L;
    private float wallThickness;
    private float wallDistance;
    private float wallWidth;
    private float wallLeft;
    private float wallHeight;
    private float wallTop;
    private boolean wallCutOutOnBothSides;
    private boolean widthDepthDeformable;
    private Sash[] sashes;
    private String cutOutShape;
    private boolean boundToWall;

    public HomeDoorOrWindow(DoorOrWindow doorOrWindow) {
        this(HomeDoorOrWindow.createId("doorOrWindow"), doorOrWindow);
    }

    public HomeDoorOrWindow(String string, DoorOrWindow doorOrWindow) {
        super(string, doorOrWindow);
        this.wallThickness = doorOrWindow.getWallThickness();
        this.wallDistance = doorOrWindow.getWallDistance();
        this.wallWidth = 1.0f;
        this.wallLeft = 0.0f;
        this.wallHeight = 1.0f;
        this.wallTop = 0.0f;
        this.wallCutOutOnBothSides = doorOrWindow.isWallCutOutOnBothSides();
        this.widthDepthDeformable = doorOrWindow.isWidthDepthDeformable();
        this.sashes = doorOrWindow.getSashes();
        this.cutOutShape = doorOrWindow.getCutOutShape();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.cutOutShape = "M0,0 v1 h1 v-1 z";
        this.widthDepthDeformable = true;
        this.wallWidth = 1.0f;
        this.wallLeft = 0.0f;
        this.wallHeight = 1.0f;
        this.wallTop = 0.0f;
        objectInputStream.defaultReadObject();
    }

    public float getWallThickness() {
        return this.wallThickness;
    }

    public void setWallThickness(float f) {
        if (f != this.wallThickness) {
            float f2 = this.wallThickness;
            this.wallThickness = f;
            this.firePropertyChange(Property.WALL_THICKNESS.name(), Float.valueOf(f2), Float.valueOf(f));
        }
    }

    public float getWallDistance() {
        return this.wallDistance;
    }

    public void setWallDistance(float f) {
        if (f != this.wallDistance) {
            float f2 = this.wallDistance;
            this.wallDistance = f;
            this.firePropertyChange(Property.WALL_DISTANCE.name(), Float.valueOf(f2), Float.valueOf(f));
        }
    }

    public float getWallWidth() {
        return this.wallWidth;
    }

    public void setWallWidth(float f) {
        if (f != this.wallWidth) {
            float f2 = this.wallWidth;
            this.wallWidth = f;
            this.firePropertyChange(Property.WALL_WIDTH.name(), Float.valueOf(f2), Float.valueOf(f));
        }
    }

    public float getWallLeft() {
        return this.wallLeft;
    }

    public void setWallLeft(float f) {
        if (f != this.wallLeft) {
            float f2 = this.wallLeft;
            this.wallLeft = f;
            this.firePropertyChange(Property.WALL_LEFT.name(), Float.valueOf(f2), Float.valueOf(f));
        }
    }

    public float getWallHeight() {
        return this.wallHeight;
    }

    public void setWallHeight(float f) {
        if (f != this.wallHeight) {
            float f2 = this.wallHeight;
            this.wallHeight = f;
            this.firePropertyChange(Property.WALL_HEIGHT.name(), Float.valueOf(f2), Float.valueOf(f));
        }
    }

    public float getWallTop() {
        return this.wallTop;
    }

    public void setWallTop(float f) {
        if (f != this.wallTop) {
            float f2 = this.wallTop;
            this.wallTop = f;
            this.firePropertyChange(Property.WALL_TOP.name(), Float.valueOf(f2), Float.valueOf(f));
        }
    }

    public Sash[] getSashes() {
        if (this.sashes.length == 0) {
            return this.sashes;
        }
        return (Sash[])this.sashes.clone();
    }

    public void setSashes(Sash[] sashArray) {
        if (!Arrays.equals(sashArray, this.sashes)) {
            Sash[] sashArray2 = this.sashes.length == 0 ? this.sashes : (Sash[])this.sashes.clone();
            this.sashes = sashArray.length == 0 ? sashArray : (Sash[])sashArray.clone();
            this.firePropertyChange(Property.SASHES.name(), sashArray2, sashArray);
        }
    }

    public String getCutOutShape() {
        return this.cutOutShape;
    }

    public void setCutOutShape(String string) {
        if (!(string == this.cutOutShape || string != null && string.equals(this.cutOutShape))) {
            String string2 = this.cutOutShape;
            this.cutOutShape = string;
            this.firePropertyChange(Property.CUT_OUT_SHAPE.name(), string2, string);
        }
    }

    public boolean isWallCutOutOnBothSides() {
        return this.wallCutOutOnBothSides;
    }

    public void setWallCutOutOnBothSides(boolean bl) {
        if (bl != this.wallCutOutOnBothSides) {
            this.wallCutOutOnBothSides = bl;
            this.firePropertyChange(Property.WALL_CUT_OUT_ON_BOTH_SIDES.name(), !bl, bl);
        }
    }

    public boolean isWidthDepthDeformable() {
        return this.widthDepthDeformable;
    }

    public void setWidthDepthDeformable(boolean bl) {
        if (bl != this.widthDepthDeformable) {
            this.widthDepthDeformable = bl;
            this.firePropertyChange(Property.WIDTH_DEPTH_DEFORMABLE.name(), !bl, bl);
        }
    }

    public boolean isBoundToWall() {
        return this.boundToWall;
    }

    public void setBoundToWall(boolean bl) {
        if (bl != this.boundToWall) {
            this.boundToWall = bl;
            this.firePropertyChange(Property.BOUND_TO_WALL.name(), !bl, bl);
        }
    }

    public void setX(float f) {
        if (this.getX() != f) {
            this.boundToWall = false;
        }
        super.setX(f);
    }

    public void setY(float f) {
        if (this.getY() != f) {
            this.boundToWall = false;
        }
        super.setY(f);
    }

    public void setAngle(float f) {
        if (this.getAngle() != f) {
            this.boundToWall = false;
        }
        super.setAngle(f);
    }

    public void setDepth(float f) {
        if (this.getDepth() != f) {
            this.boundToWall = false;
        }
        super.setDepth(f);
    }

    public boolean isDoorOrWindow() {
        return true;
    }

    public HomeObject duplicate() {
        HomeDoorOrWindow homeDoorOrWindow = (HomeDoorOrWindow)super.duplicate();
        homeDoorOrWindow.boundToWall = false;
        return homeDoorOrWindow;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Property {
        WALL_THICKNESS,
        WALL_DISTANCE,
        WALL_WIDTH,
        WALL_LEFT,
        WALL_HEIGHT,
        WALL_TOP,
        SASHES,
        CUT_OUT_SHAPE,
        WALL_CUT_OUT_ON_BOTH_SIDES,
        WIDTH_DEPTH_DEFORMABLE,
        BOUND_TO_WALL;

    }
}

