/*
 * Decompiled with CFR 0.152.
 */
package com.eteks.sweethome3d.viewcontroller;

import com.eteks.sweethome3d.model.BackgroundImage;
import com.eteks.sweethome3d.model.Baseboard;
import com.eteks.sweethome3d.model.Camera;
import com.eteks.sweethome3d.model.CollectionEvent;
import com.eteks.sweethome3d.model.CollectionListener;
import com.eteks.sweethome3d.model.Compass;
import com.eteks.sweethome3d.model.DimensionLine;
import com.eteks.sweethome3d.model.Elevatable;
import com.eteks.sweethome3d.model.Home;
import com.eteks.sweethome3d.model.HomeDoorOrWindow;
import com.eteks.sweethome3d.model.HomeFurnitureGroup;
import com.eteks.sweethome3d.model.HomeLight;
import com.eteks.sweethome3d.model.HomeObject;
import com.eteks.sweethome3d.model.HomePieceOfFurniture;
import com.eteks.sweethome3d.model.HomeTexture;
import com.eteks.sweethome3d.model.Label;
import com.eteks.sweethome3d.model.LengthUnit;
import com.eteks.sweethome3d.model.Level;
import com.eteks.sweethome3d.model.ObserverCamera;
import com.eteks.sweethome3d.model.Polyline;
import com.eteks.sweethome3d.model.Room;
import com.eteks.sweethome3d.model.Selectable;
import com.eteks.sweethome3d.model.SelectionEvent;
import com.eteks.sweethome3d.model.SelectionListener;
import com.eteks.sweethome3d.model.TextStyle;
import com.eteks.sweethome3d.model.UserPreferences;
import com.eteks.sweethome3d.model.Wall;
import com.eteks.sweethome3d.viewcontroller.CompassController;
import com.eteks.sweethome3d.viewcontroller.ContentManager;
import com.eteks.sweethome3d.viewcontroller.Controller;
import com.eteks.sweethome3d.viewcontroller.FurnitureController;
import com.eteks.sweethome3d.viewcontroller.LabelController;
import com.eteks.sweethome3d.viewcontroller.LevelController;
import com.eteks.sweethome3d.viewcontroller.LocalizedUndoableEdit;
import com.eteks.sweethome3d.viewcontroller.ObserverCameraController;
import com.eteks.sweethome3d.viewcontroller.PlanView;
import com.eteks.sweethome3d.viewcontroller.PolylineController;
import com.eteks.sweethome3d.viewcontroller.RoomController;
import com.eteks.sweethome3d.viewcontroller.View;
import com.eteks.sweethome3d.viewcontroller.ViewFactory;
import com.eteks.sweethome3d.viewcontroller.WallController;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Path2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoableEditSupport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PlanController
extends FurnitureController
implements Controller {
    private static final String SCALE_VISUAL_PROPERTY = "com.eteks.sweethome3d.SweetHome3D.PlanScale";
    private static final int PIXEL_MARGIN = 4;
    private static final int INDICATOR_PIXEL_MARGIN = 5;
    private static final int WALL_ENDS_PIXEL_MARGIN = 2;
    private final Home home;
    private final UserPreferences preferences;
    private final ViewFactory viewFactory;
    private final ContentManager contentManager;
    private final UndoableEditSupport undoSupport;
    private final PropertyChangeSupport propertyChangeSupport;
    private PlanView planView;
    private SelectionListener selectionListener;
    private PropertyChangeListener wallChangeListener;
    private PropertyChangeListener furnitureSizeChangeListener;
    private final ControllerState selectionState;
    private final ControllerState rectangleSelectionState;
    private final ControllerState selectionMoveState;
    private final ControllerState panningState;
    private final ControllerState dragAndDropState;
    private final ControllerState wallCreationState;
    private final ControllerState wallDrawingState;
    private final ControllerState wallResizeState;
    private final ControllerState wallArcExtentState;
    private final ControllerState pieceOfFurnitureRotationState;
    private final ControllerState pieceOfFurniturePitchRotationState;
    private final ControllerState pieceOfFurnitureRollRotationState;
    private final ControllerState pieceOfFurnitureElevationState;
    private final ControllerState pieceOfFurnitureHeightState;
    private final ControllerState pieceOfFurnitureResizeState;
    private final ControllerState lightPowerModificationState;
    private final ControllerState pieceOfFurnitureNameOffsetState;
    private final ControllerState pieceOfFurnitureNameRotationState;
    private final ControllerState cameraYawRotationState;
    private final ControllerState cameraPitchRotationState;
    private final ControllerState cameraElevationState;
    private final ControllerState dimensionLineCreationState;
    private final ControllerState dimensionLineDrawingState;
    private final ControllerState dimensionLineResizeState;
    private final ControllerState dimensionLineOffsetState;
    private final ControllerState roomCreationState;
    private final ControllerState roomDrawingState;
    private final ControllerState roomResizeState;
    private final ControllerState roomAreaOffsetState;
    private final ControllerState roomAreaRotationState;
    private final ControllerState roomNameOffsetState;
    private final ControllerState roomNameRotationState;
    private final ControllerState polylineCreationState;
    private final ControllerState polylineDrawingState;
    private final ControllerState polylineResizeState;
    private final ControllerState labelCreationState;
    private final ControllerState labelRotationState;
    private final ControllerState labelElevationState;
    private final ControllerState compassRotationState;
    private final ControllerState compassResizeState;
    private ControllerState state;
    private ControllerState previousState;
    private float xLastMousePress;
    private float yLastMousePress;
    private boolean shiftDownLastMousePress;
    private boolean alignmentActivatedLastMousePress;
    private boolean duplicationActivatedLastMousePress;
    private boolean magnetismToggledLastMousePress;
    private View.PointerType pointerTypeLastMousePress;
    private float xLastMouseMove;
    private float yLastMouseMove;
    private Area wallsAreaCache;
    private Area wallsIncludingBaseboardsAreaCache;
    private Area insideWallsAreaCache;
    private List<GeneralPath> roomPathsCache;
    private Map<HomePieceOfFurniture, Area> furnitureSidesCache;
    private List<Selectable> draggedItems;

    public PlanController(Home home, UserPreferences userPreferences, ViewFactory viewFactory, ContentManager contentManager, UndoableEditSupport undoableEditSupport) {
        super(home, userPreferences, viewFactory, contentManager, undoableEditSupport);
        this.home = home;
        this.preferences = userPreferences;
        this.viewFactory = viewFactory;
        this.contentManager = contentManager;
        this.undoSupport = undoableEditSupport;
        this.propertyChangeSupport = new PropertyChangeSupport(this);
        this.furnitureSidesCache = new Hashtable<HomePieceOfFurniture, Area>();
        this.selectionState = new SelectionState();
        this.selectionMoveState = new SelectionMoveState();
        this.rectangleSelectionState = new RectangleSelectionState();
        this.panningState = new PanningState();
        this.dragAndDropState = new DragAndDropState();
        this.wallCreationState = new WallCreationState();
        this.wallDrawingState = new WallDrawingState();
        this.wallResizeState = new WallResizeState();
        this.wallArcExtentState = new WallArcExtentState();
        this.pieceOfFurnitureRotationState = new PieceOfFurnitureRotationState();
        this.pieceOfFurniturePitchRotationState = new PieceOfFurniturePitchRotationState();
        this.pieceOfFurnitureRollRotationState = new PieceOfFurnitureRollRotationState();
        this.pieceOfFurnitureElevationState = new PieceOfFurnitureElevationState();
        this.pieceOfFurnitureHeightState = new PieceOfFurnitureHeightState();
        this.pieceOfFurnitureResizeState = new PieceOfFurnitureResizeState();
        this.lightPowerModificationState = new LightPowerModificationState();
        this.pieceOfFurnitureNameOffsetState = new PieceOfFurnitureNameOffsetState();
        this.pieceOfFurnitureNameRotationState = new PieceOfFurnitureNameRotationState();
        this.cameraYawRotationState = new CameraYawRotationState();
        this.cameraPitchRotationState = new CameraPitchRotationState();
        this.cameraElevationState = new CameraElevationState();
        this.dimensionLineCreationState = new DimensionLineCreationState();
        this.dimensionLineDrawingState = new DimensionLineDrawingState();
        this.dimensionLineResizeState = new DimensionLineResizeState();
        this.dimensionLineOffsetState = new DimensionLineOffsetState();
        this.roomCreationState = new RoomCreationState();
        this.roomDrawingState = new RoomDrawingState();
        this.roomResizeState = new RoomResizeState();
        this.roomAreaOffsetState = new RoomAreaOffsetState();
        this.roomAreaRotationState = new RoomAreaRotationState();
        this.roomNameOffsetState = new RoomNameOffsetState();
        this.roomNameRotationState = new RoomNameRotationState();
        this.polylineCreationState = new PolylineCreationState();
        this.polylineDrawingState = new PolylineDrawingState();
        this.polylineResizeState = new PolylineResizeState();
        this.labelCreationState = new LabelCreationState();
        this.labelRotationState = new LabelRotationState();
        this.labelElevationState = new LabelElevationState();
        this.compassRotationState = new CompassRotationState();
        this.compassResizeState = new CompassResizeState();
        this.setState(this.selectionState);
        this.addModelListeners();
        Number number = home.getNumericProperty(SCALE_VISUAL_PROPERTY);
        if (number != null) {
            this.setScale(number.floatValue());
        }
    }

    @Override
    public PlanView getView() {
        if (this.planView == null) {
            this.planView = this.viewFactory.createPlanView(this.home, this.preferences, this);
        }
        return this.planView;
    }

    protected void setState(ControllerState controllerState) {
        Mode mode = null;
        boolean bl = false;
        boolean bl2 = false;
        if (this.state != null) {
            mode = this.state.getMode();
            bl = this.state.isModificationState();
            bl2 = this.state.isBasePlanModificationState();
            this.state.exit();
        }
        this.previousState = this.state;
        this.state = controllerState;
        this.state.enter();
        if (mode != controllerState.getMode()) {
            this.propertyChangeSupport.firePropertyChange(Property.MODE.name(), mode, controllerState.getMode());
        }
        if (bl != controllerState.isModificationState()) {
            this.propertyChangeSupport.firePropertyChange(Property.MODIFICATION_STATE.name(), bl, !bl);
        }
        if (bl2 != controllerState.isBasePlanModificationState()) {
            this.propertyChangeSupport.firePropertyChange(Property.BASE_PLAN_MODIFICATION_STATE.name(), bl2, !bl2);
        }
    }

    public void addPropertyChangeListener(Property property, PropertyChangeListener propertyChangeListener) {
        this.propertyChangeSupport.addPropertyChangeListener(property.name(), propertyChangeListener);
    }

    public void removePropertyChangeListener(Property property, PropertyChangeListener propertyChangeListener) {
        this.propertyChangeSupport.removePropertyChangeListener(property.name(), propertyChangeListener);
    }

    public Mode getMode() {
        return this.state.getMode();
    }

    public void setMode(Mode mode) {
        Mode mode2 = this.state.getMode();
        if (mode != mode2) {
            this.state.setMode(mode);
            this.propertyChangeSupport.firePropertyChange(Property.MODE.name(), mode2, mode);
        }
    }

    public boolean isModificationState() {
        return this.state.isModificationState();
    }

    public boolean isBasePlanModificationState() {
        return this.state.isBasePlanModificationState();
    }

    @Override
    public void deleteSelection() {
        this.state.deleteSelection();
    }

    public void escape() {
        this.state.escape();
    }

    public void moveSelection(float f, float f2) {
        this.state.moveSelection(f, f2);
    }

    public void toggleMagnetism(boolean bl) {
        this.state.toggleMagnetism(bl);
    }

    public void setAlignmentActivated(boolean bl) {
        this.state.setAlignmentActivated(bl);
    }

    public void setDuplicationActivated(boolean bl) {
        this.state.setDuplicationActivated(bl);
    }

    public void setEditionActivated(boolean bl) {
        this.state.setEditionActivated(bl);
    }

    public void updateEditableProperty(EditableProperty editableProperty, Object object) {
        this.state.updateEditableProperty(editableProperty, object);
    }

    public void pressMouse(float f, float f2, int n, boolean bl, boolean bl2) {
        this.pressMouse(f, f2, n, bl, bl, bl2, bl);
    }

    public void pressMouse(float f, float f2, int n, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        this.pressMouse(f, f2, n, bl, bl2, bl3, bl4, null);
    }

    public void pressMouse(float f, float f2, int n, boolean bl, boolean bl2, boolean bl3, boolean bl4, View.PointerType pointerType) {
        this.xLastMousePress = f;
        this.yLastMousePress = f2;
        this.xLastMouseMove = f;
        this.yLastMouseMove = f2;
        this.shiftDownLastMousePress = bl;
        this.alignmentActivatedLastMousePress = bl2;
        this.duplicationActivatedLastMousePress = bl3;
        this.pointerTypeLastMousePress = pointerType;
        this.magnetismToggledLastMousePress = bl4;
        this.state.pressMouse(f, f2, n, bl, bl3);
    }

    public void releaseMouse(float f, float f2) {
        this.state.releaseMouse(f, f2);
    }

    public void moveMouse(float f, float f2) {
        this.xLastMouseMove = f;
        this.yLastMouseMove = f2;
        this.state.moveMouse(f, f2);
    }

    public void zoom(float f) {
        this.state.zoom(f);
    }

    protected ControllerState getSelectionState() {
        return this.selectionState;
    }

    protected ControllerState getSelectionMoveState() {
        return this.selectionMoveState;
    }

    protected ControllerState getRectangleSelectionState() {
        return this.rectangleSelectionState;
    }

    protected ControllerState getPanningState() {
        return this.panningState;
    }

    protected ControllerState getDragAndDropState() {
        return this.dragAndDropState;
    }

    protected ControllerState getWallCreationState() {
        return this.wallCreationState;
    }

    protected ControllerState getWallDrawingState() {
        return this.wallDrawingState;
    }

    protected ControllerState getWallResizeState() {
        return this.wallResizeState;
    }

    protected ControllerState getWallArcExtentState() {
        return this.wallArcExtentState;
    }

    protected ControllerState getPieceOfFurnitureRotationState() {
        return this.pieceOfFurnitureRotationState;
    }

    protected ControllerState getPieceOfFurniturePitchRotationState() {
        return this.pieceOfFurniturePitchRotationState;
    }

    protected ControllerState getPieceOfFurnitureRollRotationState() {
        return this.pieceOfFurnitureRollRotationState;
    }

    protected ControllerState getPieceOfFurnitureElevationState() {
        return this.pieceOfFurnitureElevationState;
    }

    protected ControllerState getPieceOfFurnitureHeightState() {
        return this.pieceOfFurnitureHeightState;
    }

    protected ControllerState getPieceOfFurnitureResizeState() {
        return this.pieceOfFurnitureResizeState;
    }

    protected ControllerState getLightPowerModificationState() {
        return this.lightPowerModificationState;
    }

    protected ControllerState getPieceOfFurnitureNameOffsetState() {
        return this.pieceOfFurnitureNameOffsetState;
    }

    protected ControllerState getPieceOfFurnitureNameRotationState() {
        return this.pieceOfFurnitureNameRotationState;
    }

    protected ControllerState getCameraYawRotationState() {
        return this.cameraYawRotationState;
    }

    protected ControllerState getCameraPitchRotationState() {
        return this.cameraPitchRotationState;
    }

    protected ControllerState getCameraElevationState() {
        return this.cameraElevationState;
    }

    protected ControllerState getDimensionLineCreationState() {
        return this.dimensionLineCreationState;
    }

    protected ControllerState getDimensionLineDrawingState() {
        return this.dimensionLineDrawingState;
    }

    protected ControllerState getDimensionLineResizeState() {
        return this.dimensionLineResizeState;
    }

    protected ControllerState getDimensionLineOffsetState() {
        return this.dimensionLineOffsetState;
    }

    protected ControllerState getRoomCreationState() {
        return this.roomCreationState;
    }

    protected ControllerState getRoomDrawingState() {
        return this.roomDrawingState;
    }

    protected ControllerState getRoomResizeState() {
        return this.roomResizeState;
    }

    protected ControllerState getRoomAreaOffsetState() {
        return this.roomAreaOffsetState;
    }

    protected ControllerState getRoomAreaRotationState() {
        return this.roomAreaRotationState;
    }

    protected ControllerState getRoomNameOffsetState() {
        return this.roomNameOffsetState;
    }

    protected ControllerState getRoomNameRotationState() {
        return this.roomNameRotationState;
    }

    protected ControllerState getPolylineCreationState() {
        return this.polylineCreationState;
    }

    protected ControllerState getPolylineDrawingState() {
        return this.polylineDrawingState;
    }

    protected ControllerState getPolylineResizeState() {
        return this.polylineResizeState;
    }

    protected ControllerState getLabelCreationState() {
        return this.labelCreationState;
    }

    protected ControllerState getLabelRotationState() {
        return this.labelRotationState;
    }

    protected ControllerState getLabelElevationState() {
        return this.labelElevationState;
    }

    protected ControllerState getCompassRotationState() {
        return this.compassRotationState;
    }

    protected ControllerState getCompassResizeState() {
        return this.compassResizeState;
    }

    protected float getXLastMousePress() {
        return this.xLastMousePress;
    }

    protected float getYLastMousePress() {
        return this.yLastMousePress;
    }

    protected boolean wasShiftDownLastMousePress() {
        return this.shiftDownLastMousePress;
    }

    protected boolean wasMagnetismToggledLastMousePress() {
        return this.magnetismToggledLastMousePress;
    }

    protected boolean wasAlignmentActivatedLastMousePress() {
        return this.alignmentActivatedLastMousePress;
    }

    protected boolean wasDuplicationActivatedLastMousePress() {
        return this.duplicationActivatedLastMousePress;
    }

    protected View.PointerType getPointerTypeLastMousePress() {
        return this.pointerTypeLastMousePress;
    }

    protected float getXLastMouseMove() {
        return this.xLastMouseMove;
    }

    protected float getYLastMouseMove() {
        return this.yLastMouseMove;
    }

    public void modifySelectedItem() {
        List<Selectable> list = this.home.getSelectedItems();
        if (list.size() == 1) {
            Selectable selectable = list.get(0);
            if (selectable instanceof HomePieceOfFurniture) {
                this.modifySelectedFurniture();
            } else if (selectable instanceof Wall) {
                this.modifySelectedWalls();
            } else if (selectable instanceof Room) {
                this.modifySelectedRooms();
            } else if (selectable instanceof Polyline) {
                this.modifySelectedPolylines();
            } else if (selectable instanceof Label) {
                this.modifySelectedLabels();
            } else if (selectable instanceof Compass) {
                this.modifyCompass();
            } else if (selectable instanceof ObserverCamera) {
                this.modifyObserverCamera();
            }
        }
    }

    public void modifySelectedWalls() {
        if (!Home.getWallsSubList(this.home.getSelectedItems()).isEmpty()) {
            new WallController(this.home, this.preferences, this.viewFactory, this.contentManager, this.undoSupport).displayView(this.getView());
        }
    }

    public void lockBasePlan() {
        if (!this.home.isBasePlanLocked()) {
            boolean bl = this.home.isAllLevelsSelection();
            List<Selectable> list = this.home.getSelectedItems();
            Selectable[] selectableArray = list.toArray(new Selectable[list.size()]);
            List<Selectable> list2 = this.getItemsNotPartOfBasePlan(list);
            Selectable[] selectableArray2 = list2.toArray(new Selectable[list2.size()]);
            this.home.setBasePlanLocked(true);
            this.selectItems(list2, bl);
            this.undoSupport.postEdit(new LockingUndoableEdit(this, this.home, this.preferences, selectableArray, bl, selectableArray2));
        }
    }

    protected boolean isItemPartOfBasePlan(Selectable selectable) {
        if (selectable instanceof HomePieceOfFurniture) {
            return this.isPieceOfFurniturePartOfBasePlan((HomePieceOfFurniture)selectable);
        }
        return !(selectable instanceof ObserverCamera);
    }

    private List<Selectable> getItemsNotPartOfBasePlan(List<? extends Selectable> list) {
        ArrayList<Selectable> arrayList = new ArrayList<Selectable>();
        for (Selectable selectable : list) {
            if (this.isItemPartOfBasePlan(selectable)) continue;
            arrayList.add(selectable);
        }
        return arrayList;
    }

    public void unlockBasePlan() {
        if (this.home.isBasePlanLocked()) {
            boolean bl = this.home.isAllLevelsSelection();
            List<Selectable> list = this.home.getSelectedItems();
            Selectable[] selectableArray = list.toArray(new Selectable[list.size()]);
            this.home.setBasePlanLocked(false);
            this.home.setAllLevelsSelection(false);
            this.undoSupport.postEdit(new UnlockingUndoableEdit(this, this.home, this.preferences, selectableArray, bl));
        }
    }

    protected boolean isItemMovable(Selectable selectable) {
        if (selectable instanceof HomePieceOfFurniture) {
            return this.isPieceOfFurnitureMovable((HomePieceOfFurniture)selectable);
        }
        return true;
    }

    protected boolean isItemResizable(Selectable selectable) {
        if (selectable instanceof HomePieceOfFurniture) {
            return ((HomePieceOfFurniture)selectable).isResizable();
        }
        return true;
    }

    protected boolean isItemDeletable(Selectable selectable) {
        if (selectable instanceof HomePieceOfFurniture) {
            return this.isPieceOfFurnitureDeletable((HomePieceOfFurniture)selectable);
        }
        return !(selectable instanceof Compass) && !(selectable instanceof Camera);
    }

    public void flipHorizontally() {
        this.flipSelectedItems(true);
    }

    public void flipVertically() {
        this.flipSelectedItems(false);
    }

    private void flipSelectedItems(boolean bl) {
        List<Selectable> list = this.home.getSelectedItems();
        if (!list.isEmpty()) {
            Selectable[] selectableArray = list.toArray(new Selectable[list.size()]);
            float[][] fArrayArray = new float[selectableArray.length][];
            for (int i = 0; i < fArrayArray.length; ++i) {
                HomeObject homeObject;
                if (selectableArray[i] instanceof HomeFurnitureGroup) {
                    homeObject = (HomeFurnitureGroup)selectableArray[i];
                    List<HomePieceOfFurniture> list2 = ((HomeFurnitureGroup)homeObject).getAllFurniture();
                    fArrayArray[i] = new float[list2.size() + 1];
                    fArrayArray[i][0] = this.getTextBaseOffset(((HomePieceOfFurniture)homeObject).getName(), ((HomePieceOfFurniture)homeObject).getNameStyle(), homeObject.getClass());
                    for (int j = 0; j < list2.size(); ++j) {
                        HomePieceOfFurniture homePieceOfFurniture = list2.get(j);
                        fArrayArray[i][j + 1] = this.getTextBaseOffset(homePieceOfFurniture.getName(), homePieceOfFurniture.getNameStyle(), homePieceOfFurniture.getClass());
                    }
                    continue;
                }
                if (selectableArray[i] instanceof HomePieceOfFurniture) {
                    homeObject = (HomePieceOfFurniture)selectableArray[i];
                    fArrayArray[i] = new float[]{this.getTextBaseOffset(((HomePieceOfFurniture)homeObject).getName(), ((HomePieceOfFurniture)homeObject).getNameStyle(), homeObject.getClass())};
                    continue;
                }
                if (!(selectableArray[i] instanceof Room)) continue;
                homeObject = (Room)selectableArray[i];
                fArrayArray[i] = new float[]{this.getTextBaseOffset(((Room)homeObject).getName(), ((Room)homeObject).getNameStyle(), homeObject.getClass()), this.getTextBaseOffset(this.preferences.getLengthUnit().getAreaFormatWithUnit().format(Float.valueOf(((Room)homeObject).getArea())), ((Room)homeObject).getAreaStyle(), homeObject.getClass())};
            }
            this.doFlipItems(selectableArray, fArrayArray, bl);
            this.selectAndShowItems(list, this.home.isAllLevelsSelection());
            this.undoSupport.postEdit(new FlippingUndoableEdit(this, this.preferences, this.home.isAllLevelsSelection(), list.toArray(new Selectable[list.size()]), fArrayArray, bl));
        }
    }

    private void doFlipItems(Selectable[] selectableArray, float[][] fArray, boolean bl) {
        float f = Float.MAX_VALUE;
        float f2 = Float.MAX_VALUE;
        float f3 = -3.4028235E38f;
        float f4 = -3.4028235E38f;
        for (Selectable selectable : selectableArray) {
            if (selectable instanceof ObserverCamera) continue;
            for (float[] fArray2 : selectable.getPoints()) {
                f = Math.min(f, fArray2[0]);
                f2 = Math.min(f2, fArray2[1]);
                f3 = Math.max(f3, fArray2[0]);
                f4 = Math.max(f4, fArray2[1]);
            }
        }
        float f5 = (f + f3) / 2.0f;
        float f6 = (f2 + f4) / 2.0f;
        List<Selectable> list = Arrays.asList(selectableArray);
        for (int i = 0; i < selectableArray.length; ++i) {
            this.flipItem(selectableArray[i], fArray[i], 0, bl ? f5 : f6, bl, list);
        }
    }

    protected void flipItem(Selectable selectable, float[] fArray, int n, float f, boolean bl, List<Selectable> list) {
        if (selectable instanceof HomePieceOfFurniture) {
            HomePieceOfFurniture homePieceOfFurniture = (HomePieceOfFurniture)selectable;
            if (bl) {
                homePieceOfFurniture.setX(f * 2.0f - homePieceOfFurniture.getX());
                homePieceOfFurniture.setAngle(-homePieceOfFurniture.getAngle());
                PlanController.flipPieceOfFurnitureName(homePieceOfFurniture, fArray[0], bl);
            } else {
                homePieceOfFurniture.setY(f * 2.0f - homePieceOfFurniture.getY());
                homePieceOfFurniture.setAngle((float)Math.PI - homePieceOfFurniture.getAngle());
                PlanController.flipPieceOfFurnitureName(homePieceOfFurniture, fArray[0], bl);
            }
            if (homePieceOfFurniture.isHorizontallyRotatable()) {
                homePieceOfFurniture.setRoll(-homePieceOfFurniture.getRoll());
            }
            if (homePieceOfFurniture.isResizable()) {
                homePieceOfFurniture.setModelMirrored(!homePieceOfFurniture.isModelMirrored());
            }
            if (selectable instanceof HomeFurnitureGroup) {
                List<HomePieceOfFurniture> list2 = ((HomeFurnitureGroup)selectable).getAllFurniture();
                for (int i = 0; i < list2.size(); ++i) {
                    PlanController.flipPieceOfFurnitureName(list2.get(i), fArray[i + 1], bl);
                }
            }
        } else if (selectable instanceof Wall) {
            Serializable serializable;
            Wall wall = (Wall)selectable;
            if (bl) {
                wall.setXStart(f * 2.0f - wall.getXStart());
                serializable = wall.getWallAtStart();
                if (serializable != null && !list.contains(serializable)) {
                    if (((Wall)serializable).getWallAtStart() == wall) {
                        ((Wall)serializable).setXStart(f * 2.0f - ((Wall)serializable).getXStart());
                    } else {
                        ((Wall)serializable).setXEnd(f * 2.0f - ((Wall)serializable).getXEnd());
                    }
                }
                wall.setXEnd(f * 2.0f - wall.getXEnd());
                Wall wall2 = wall.getWallAtEnd();
                if (wall2 != null && !list.contains(wall2)) {
                    if (wall2.getWallAtStart() == wall) {
                        wall2.setXStart(f * 2.0f - wall2.getXStart());
                    } else {
                        wall2.setXEnd(f * 2.0f - wall2.getXEnd());
                    }
                }
            } else {
                wall.setYStart(f * 2.0f - wall.getYStart());
                serializable = wall.getWallAtStart();
                if (serializable != null && !list.contains(serializable)) {
                    if (((Wall)serializable).getWallAtStart() == wall) {
                        ((Wall)serializable).setYStart(f * 2.0f - ((Wall)serializable).getYStart());
                    } else {
                        ((Wall)serializable).setYEnd(f * 2.0f - ((Wall)serializable).getYEnd());
                    }
                }
                wall.setYEnd(f * 2.0f - wall.getYEnd());
                Wall wall3 = wall.getWallAtEnd();
                if (wall3 != null && !list.contains(wall3)) {
                    if (wall3.getWallAtStart() == wall) {
                        wall3.setYStart(f * 2.0f - wall3.getYStart());
                    } else {
                        wall3.setYEnd(f * 2.0f - wall3.getYEnd());
                    }
                }
            }
            serializable = wall.getArcExtent();
            if (serializable != null) {
                wall.setArcExtent(Float.valueOf(-((Float)serializable).floatValue()));
            }
            PlanController.reverseWallSidesStyle(wall);
        } else if (selectable instanceof Room) {
            Room room = (Room)selectable;
            float[][] fArray2 = room.getPoints();
            for (float[] fArray3 : fArray2) {
                if (bl) {
                    fArray3[0] = f * 2.0f - fArray3[0];
                    continue;
                }
                fArray3[1] = f * 2.0f - fArray3[1];
            }
            room.setPoints(fArray2);
            Object object = room.getNameStyle();
            TextStyle textStyle = room.getAreaStyle();
            if (bl) {
                room.setNameXOffset(-room.getNameXOffset());
                room.setAreaXOffset(-room.getAreaXOffset());
                if (object != null) {
                    if (((TextStyle)object).getAlignment() == TextStyle.Alignment.LEFT) {
                        room.setNameStyle(((TextStyle)object).deriveStyle(TextStyle.Alignment.RIGHT));
                    } else if (((TextStyle)object).getAlignment() == TextStyle.Alignment.RIGHT) {
                        room.setNameStyle(((TextStyle)object).deriveStyle(TextStyle.Alignment.LEFT));
                    }
                }
                if (textStyle != null) {
                    if (textStyle.getAlignment() == TextStyle.Alignment.LEFT) {
                        room.setAreaStyle(textStyle.deriveStyle(TextStyle.Alignment.RIGHT));
                    } else if (textStyle.getAlignment() == TextStyle.Alignment.RIGHT) {
                        room.setAreaStyle(textStyle.deriveStyle(TextStyle.Alignment.LEFT));
                    }
                }
            } else {
                room.setNameYOffset(-room.getNameYOffset());
                float f2 = fArray[0];
                room.setNameXOffset(room.getNameXOffset() - f2 * (float)Math.sin(room.getNameAngle()));
                room.setNameYOffset(room.getNameYOffset() - f2 * (float)Math.cos(room.getNameAngle()));
                room.setAreaYOffset(-room.getAreaYOffset());
                f2 = fArray[1];
                room.setAreaXOffset(room.getAreaXOffset() - f2 * (float)Math.sin(room.getAreaAngle()));
                room.setAreaYOffset(room.getAreaYOffset() - f2 * (float)Math.cos(room.getAreaAngle()));
            }
            room.setNameAngle(-room.getNameAngle());
            room.setAreaAngle(-room.getAreaAngle());
        } else if (selectable instanceof Polyline) {
            float[][] fArray4;
            Polyline polyline = (Polyline)selectable;
            for (float[] fArray5 : fArray4 = polyline.getPoints()) {
                if (bl) {
                    fArray5[0] = f * 2.0f - fArray5[0];
                    continue;
                }
                fArray5[1] = f * 2.0f - fArray5[1];
            }
            polyline.setPoints(fArray4);
        } else if (selectable instanceof DimensionLine) {
            DimensionLine dimensionLine = (DimensionLine)selectable;
            if (bl) {
                float f3 = dimensionLine.getXStart();
                dimensionLine.setXStart(f * 2.0f - dimensionLine.getXEnd());
                dimensionLine.setXEnd(f * 2.0f - f3);
                float f4 = dimensionLine.getYStart();
                dimensionLine.setYStart(dimensionLine.getYEnd());
                dimensionLine.setYEnd(f4);
            } else {
                dimensionLine.setYStart(f * 2.0f - dimensionLine.getYStart());
                dimensionLine.setYEnd(f * 2.0f - dimensionLine.getYEnd());
                dimensionLine.setOffset(-dimensionLine.getOffset());
            }
        } else if (selectable instanceof Label) {
            Label label = (Label)selectable;
            if (bl) {
                label.setX(f * 2.0f - label.getX());
                label.setAngle(-label.getAngle());
            } else {
                label.setY(f * 2.0f - label.getY());
                if (label.getPitch() != null) {
                    label.setAngle((float)Math.PI - label.getAngle());
                } else {
                    label.setAngle(-label.getAngle());
                }
            }
            TextStyle textStyle = label.getStyle();
            if (textStyle != null) {
                if (textStyle.getAlignment() == TextStyle.Alignment.LEFT) {
                    label.setStyle(textStyle.deriveStyle(TextStyle.Alignment.RIGHT));
                } else if (textStyle.getAlignment() == TextStyle.Alignment.RIGHT) {
                    label.setStyle(textStyle.deriveStyle(TextStyle.Alignment.LEFT));
                }
            }
        } else if (selectable instanceof Compass) {
            Compass compass = (Compass)selectable;
            if (bl) {
                compass.setX(f * 2.0f - compass.getX());
                compass.setNorthDirection(-compass.getNorthDirection());
            } else {
                compass.setY(f * 2.0f - compass.getY());
                compass.setNorthDirection((float)Math.PI - compass.getNorthDirection());
            }
        }
    }

    private static void flipPieceOfFurnitureName(HomePieceOfFurniture homePieceOfFurniture, float f, boolean bl) {
        if (bl) {
            homePieceOfFurniture.setNameXOffset(-homePieceOfFurniture.getNameXOffset());
            TextStyle textStyle = homePieceOfFurniture.getNameStyle();
            if (textStyle != null) {
                if (textStyle.getAlignment() == TextStyle.Alignment.LEFT) {
                    homePieceOfFurniture.setNameStyle(textStyle.deriveStyle(TextStyle.Alignment.RIGHT));
                } else if (textStyle.getAlignment() == TextStyle.Alignment.RIGHT) {
                    homePieceOfFurniture.setNameStyle(textStyle.deriveStyle(TextStyle.Alignment.LEFT));
                }
            }
        } else {
            homePieceOfFurniture.setNameYOffset(-homePieceOfFurniture.getNameYOffset());
            if (homePieceOfFurniture.getNameXOffset() != 0.0f || homePieceOfFurniture.getNameYOffset() != 0.0f) {
                homePieceOfFurniture.setNameXOffset(homePieceOfFurniture.getNameXOffset() - f * (float)Math.sin(homePieceOfFurniture.getNameAngle()));
                homePieceOfFurniture.setNameYOffset(homePieceOfFurniture.getNameYOffset() - f * (float)Math.cos(homePieceOfFurniture.getNameAngle()));
            }
            homePieceOfFurniture.setNameAngle(-homePieceOfFurniture.getNameAngle());
        }
    }

    private float getTextBaseOffset(String string, TextStyle textStyle, Class<? extends Selectable> clazz) {
        if (textStyle == null) {
            textStyle = this.preferences.getDefaultTextStyle(clazz);
        }
        float[][] fArray = this.getView().getTextBounds(string != null ? string : "Ag", textStyle, 0.0f, 0.0f, 0.0f);
        return (fArray[fArray.length - 1][1] + fArray[0][1]) / 2.0f;
    }

    public void joinSelectedWalls() {
        List<Selectable> list = this.home.getSelectedItems();
        List<Wall> list2 = Home.getWallsSubList(list);
        final Wall[] wallArray = new Wall[]{null, null};
        for (Wall wall : list2) {
            if (wall.getArcExtent() != null && wall.getArcExtent().floatValue() != 0.0f || wall.getWallAtStart() != null && wall.getWallAtEnd() != null) continue;
            if (wallArray[0] == null) {
                wallArray[0] = wall;
                continue;
            }
            wallArray[1] = wall;
            break;
        }
        if (wallArray[1] == null) {
            Collections.sort(list2, new Comparator<Wall>(){

                @Override
                public int compare(Wall wall, Wall wall2) {
                    float[] fArray = PlanController.computeIntersection(wall.getXStart(), wall.getYStart(), wall.getXEnd(), wall.getYEnd(), wallArray[0].getXStart(), wallArray[0].getYStart(), wallArray[0].getXEnd(), wallArray[0].getYEnd());
                    float[] fArray2 = PlanController.computeIntersection(wall2.getXStart(), wall2.getYStart(), wall2.getXEnd(), wall2.getYEnd(), wallArray[0].getXStart(), wallArray[0].getYStart(), wallArray[0].getXEnd(), wallArray[0].getYEnd());
                    double d = Math.min(Point2D.distanceSq(wallArray[0].getXStart(), wallArray[0].getYStart(), fArray[0], fArray[1]), Point2D.distanceSq(wallArray[0].getXEnd(), wallArray[0].getYEnd(), fArray[0], fArray[1]));
                    double d2 = Math.min(Point2D.distanceSq(wallArray[0].getXStart(), wallArray[0].getYStart(), fArray2[0], fArray2[1]), Point2D.distanceSq(wallArray[0].getXEnd(), wallArray[0].getYEnd(), fArray2[0], fArray2[1]));
                    return Double.compare(d, d2);
                }
            });
            if (wallArray[0] != list2.get(1)) {
                wallArray[1] = list2.get(1);
            }
        }
        if (wallArray[1] != null) {
            double d;
            double d2 = Math.atan2(wallArray[0].getYEnd() - wallArray[0].getYStart(), wallArray[0].getXEnd() - wallArray[0].getXStart());
            double d3 = Math.abs(d2 - (d = Math.atan2(wallArray[1].getYEnd() - wallArray[1].getYStart(), wallArray[1].getXEnd() - wallArray[1].getXStart()))) % Math.PI;
            boolean bl = d3 <= Math.PI / 360 || Math.PI - d3 <= Math.PI / 360;
            float[] fArray = null;
            if (!bl) {
                fArray = PlanController.computeIntersection(wallArray[0].getXStart(), wallArray[0].getYStart(), wallArray[0].getXEnd(), wallArray[0].getYEnd(), wallArray[1].getXStart(), wallArray[1].getYStart(), wallArray[1].getXEnd(), wallArray[1].getYEnd());
            } else if (Line2D.ptLineDistSq(wallArray[1].getXStart(), wallArray[1].getYStart(), wallArray[1].getXEnd(), wallArray[1].getYEnd(), wallArray[0].getXStart(), wallArray[0].getYStart()) < 0.01 && Line2D.ptLineDistSq(wallArray[1].getXStart(), wallArray[1].getYStart(), wallArray[1].getXEnd(), wallArray[1].getYEnd(), wallArray[0].getXEnd(), wallArray[0].getYEnd()) < 0.01) {
                if (wallArray[1].getWallAtStart() == null ^ wallArray[1].getWallAtEnd() == null) {
                    fArray = wallArray[1].getWallAtStart() == null ? new float[]{wallArray[1].getXStart(), wallArray[1].getYStart()} : new float[]{wallArray[1].getXEnd(), wallArray[1].getYEnd()};
                } else if (wallArray[1].getWallAtStart() == null && wallArray[1].getWallAtEnd() == null) {
                    double d4 = Line2D.ptSegDistSq(wallArray[1].getXStart(), wallArray[1].getYStart(), wallArray[1].getXEnd(), wallArray[1].getYEnd(), wallArray[0].getXStart(), wallArray[0].getYStart());
                    double d5 = Line2D.ptSegDistSq(wallArray[1].getXStart(), wallArray[1].getYStart(), wallArray[1].getXEnd(), wallArray[1].getYEnd(), wallArray[0].getXEnd(), wallArray[0].getYEnd());
                    if (d4 > 0.01 && d5 > 0.01) {
                        fArray = wallArray[0].getWallAtEnd() != null || wallArray[0].getWallAtStart() == null && d4 <= d5 ? (Point2D.distanceSq(wallArray[1].getXStart(), wallArray[1].getYStart(), wallArray[0].getXStart(), wallArray[0].getYStart()) < Point2D.distanceSq(wallArray[1].getXEnd(), wallArray[1].getYEnd(), wallArray[0].getXStart(), wallArray[0].getYStart()) ? new float[]{wallArray[1].getXStart(), wallArray[1].getYStart()} : new float[]{wallArray[1].getXEnd(), wallArray[1].getYEnd()}) : (Point2D.distanceSq(wallArray[1].getXStart(), wallArray[1].getYStart(), wallArray[0].getXEnd(), wallArray[0].getYEnd()) < Point2D.distanceSq(wallArray[1].getXEnd(), wallArray[1].getYEnd(), wallArray[0].getXEnd(), wallArray[0].getYEnd()) ? new float[]{wallArray[1].getXStart(), wallArray[1].getYStart()} : new float[]{wallArray[1].getXEnd(), wallArray[1].getYEnd()});
                    }
                }
            }
            if (fArray != null) {
                JoinedWall[] joinedWallArray = JoinedWall.getJoinedWalls(Arrays.asList(wallArray[0], wallArray[1]));
                this.doJoinWalls(joinedWallArray, fArray);
                this.undoSupport.postEdit(new WallsJoiningUndoableEdit(this, this.preferences, list.toArray(new Selectable[list.size()]), this.home.isAllLevelsSelection(), joinedWallArray, fArray));
            }
        }
    }

    private void doJoinWalls(JoinedWall[] joinedWallArray, float[] fArray) {
        Wall[] wallArray = new Wall[]{joinedWallArray[0].getWall(), joinedWallArray[1].getWall()};
        boolean bl = false;
        for (int i = 0; i < 2; ++i) {
            boolean bl2;
            boolean bl3 = wallArray[i].getWallAtEnd() == null;
            boolean bl4 = bl2 = wallArray[i].getWallAtStart() == null;
            if (bl2 && bl3) {
                if (Point2D.distanceSq(wallArray[i].getXStart(), wallArray[i].getYStart(), fArray[0], fArray[1]) < Point2D.distanceSq(wallArray[i].getXEnd(), wallArray[i].getYEnd(), fArray[0], fArray[1])) {
                    bl3 = false;
                } else {
                    bl2 = false;
                }
            }
            if (bl3) {
                wallArray[i].setXEnd(fArray[0]);
                wallArray[i].setYEnd(fArray[1]);
            } else if (bl2) {
                wallArray[i].setXStart(fArray[0]);
                wallArray[i].setYStart(fArray[1]);
            }
            if (!bl && wallArray[(i + 1) % 2].getWallAtStart() != null && wallArray[(i + 1) % 2].getWallAtEnd() != null) continue;
            if (bl3) {
                wallArray[i].setWallAtEnd(wallArray[(i + 1) % 2]);
                bl = true;
                continue;
            }
            if (!bl2) continue;
            wallArray[i].setWallAtStart(wallArray[(i + 1) % 2]);
            bl = true;
        }
        if (bl) {
            this.home.setSelectedItems(Arrays.asList(wallArray[0], wallArray[1]));
        } else {
            this.home.setSelectedItems(Arrays.asList(wallArray[0]));
        }
    }

    public void reverseSelectedWallsDirection() {
        List<Selectable> list = this.home.getSelectedItems();
        List<Wall> list2 = Home.getWallsSubList(list);
        if (!list2.isEmpty()) {
            Wall[] wallArray = list2.toArray(new Wall[list2.size()]);
            this.doReverseWallsDirection(wallArray);
            this.selectAndShowItems(Arrays.asList(wallArray), false);
            this.undoSupport.postEdit(new WallsDirectionReversingUndoableEdit(this, this.preferences, list.toArray(new Selectable[list.size()]), this.home.isAllLevelsSelection(), wallArray));
        }
    }

    private void doReverseWallsDirection(Wall[] wallArray) {
        for (Wall wall : wallArray) {
            Wall wall2;
            float f = wall.getXStart();
            float f2 = wall.getYStart();
            float f3 = wall.getXEnd();
            float f4 = wall.getYEnd();
            wall.setXStart(f3);
            wall.setYStart(f4);
            wall.setXEnd(f);
            wall.setYEnd(f2);
            if (wall.getArcExtent() != null) {
                wall.setArcExtent(Float.valueOf(-wall.getArcExtent().floatValue()));
            }
            boolean bl = (wall2 = wall.getWallAtStart()) != null && wall2.getWallAtEnd() == wall;
            boolean bl2 = wall2 != null && wall2.getWallAtStart() == wall;
            Wall wall3 = wall.getWallAtEnd();
            boolean bl3 = wall3 != null && wall3.getWallAtEnd() == wall;
            boolean bl4 = wall3 != null && wall3.getWallAtStart() == wall;
            wall.setWallAtStart(wall3);
            wall.setWallAtEnd(wall2);
            if (bl) {
                wall2.setWallAtEnd(wall);
            } else if (bl2) {
                wall2.setWallAtStart(wall);
            }
            if (bl3) {
                wall3.setWallAtEnd(wall);
            } else if (bl4) {
                wall3.setWallAtStart(wall);
            }
            Float f5 = wall.getHeightAtEnd();
            if (f5 != null) {
                Float f6 = wall.getHeight();
                wall.setHeight(f5);
                wall.setHeightAtEnd(f6);
            }
            PlanController.reverseWallSidesStyle(wall);
        }
    }

    private static void reverseWallSidesStyle(Wall wall) {
        Integer n = wall.getRightSideColor();
        HomeTexture homeTexture = wall.getRightSideTexture();
        float f = wall.getLeftSideShininess();
        Baseboard baseboard = wall.getLeftSideBaseboard();
        Integer n2 = wall.getLeftSideColor();
        HomeTexture homeTexture2 = wall.getLeftSideTexture();
        float f2 = wall.getRightSideShininess();
        Baseboard baseboard2 = wall.getRightSideBaseboard();
        wall.setLeftSideColor(n);
        wall.setLeftSideTexture(homeTexture);
        wall.setLeftSideShininess(f2);
        wall.setLeftSideBaseboard(baseboard2);
        wall.setRightSideColor(n2);
        wall.setRightSideTexture(homeTexture2);
        wall.setRightSideShininess(f);
        wall.setRightSideBaseboard(baseboard);
    }

    public void splitSelectedWall() {
        List<Selectable> list = this.home.getSelectedItems();
        List<Wall> list2 = Home.getWallsSubList(list);
        if (list2.size() == 1) {
            boolean bl = this.home.isAllLevelsSelection();
            boolean bl2 = this.home.isBasePlanLocked();
            Wall wall = list2.get(0);
            JoinedWall joinedWall = new JoinedWall(wall);
            float f = wall.getXStart();
            float f2 = wall.getYStart();
            float f3 = wall.getXEnd();
            float f4 = wall.getYEnd();
            float f5 = (f + f3) / 2.0f;
            float f6 = (f2 + f4) / 2.0f;
            Wall wall2 = wall.getWallAtStart();
            boolean bl3 = wall2 != null && wall2.getWallAtEnd() == wall;
            boolean bl4 = wall2 != null && wall2.getWallAtStart() == wall;
            Wall wall3 = wall.getWallAtEnd();
            boolean bl5 = wall3 != null && wall3.getWallAtEnd() == wall;
            boolean bl6 = wall3 != null && wall3.getWallAtStart() == wall;
            Wall wall4 = (Wall)wall.duplicate();
            this.home.addWall(wall4);
            wall4.setLevel(wall.getLevel());
            Wall wall5 = (Wall)wall.duplicate();
            this.home.addWall(wall5);
            wall5.setLevel(wall.getLevel());
            wall4.setXEnd(f5);
            wall4.setYEnd(f6);
            wall5.setXStart(f5);
            wall5.setYStart(f6);
            if (wall.getHeightAtEnd() != null) {
                Float f7 = Float.valueOf((wall.getHeight().floatValue() + wall.getHeightAtEnd().floatValue()) / 2.0f);
                wall4.setHeightAtEnd(f7);
                wall5.setHeight(f7);
            }
            wall4.setWallAtEnd(wall5);
            wall5.setWallAtStart(wall4);
            wall4.setWallAtStart(wall2);
            if (bl3) {
                wall2.setWallAtEnd(wall4);
            } else if (bl4) {
                wall2.setWallAtStart(wall4);
            }
            wall5.setWallAtEnd(wall3);
            if (bl6) {
                wall3.setWallAtStart(wall5);
            } else if (bl5) {
                wall3.setWallAtEnd(wall5);
            }
            this.home.deleteWall(wall);
            this.selectAndShowItems(Arrays.asList(wall4), false);
            this.undoSupport.postEdit(new WallSplittingUndoableEdit(this, this.preferences, list.toArray(new Selectable[list.size()]), bl2, bl, joinedWall, new JoinedWall(wall4), new JoinedWall(wall5), this.home.isBasePlanLocked()));
        }
    }

    public void modifySelectedRooms() {
        if (!Home.getRoomsSubList(this.home.getSelectedItems()).isEmpty()) {
            new RoomController(this.home, this.preferences, this.viewFactory, this.contentManager, this.undoSupport).displayView(this.getView());
        }
    }

    private void createLabel(float f, float f2) {
        new LabelController(this.home, f, f2, this.preferences, this.viewFactory, this.undoSupport).displayView(this.getView());
    }

    public void modifySelectedLabels() {
        if (!Home.getLabelsSubList(this.home.getSelectedItems()).isEmpty()) {
            new LabelController(this.home, this.preferences, this.viewFactory, this.undoSupport).displayView(this.getView());
        }
    }

    public void modifySelectedPolylines() {
        if (!Home.getPolylinesSubList(this.home.getSelectedItems()).isEmpty()) {
            new PolylineController(this.home, this.preferences, this.viewFactory, this.contentManager, this.undoSupport).displayView(this.getView());
        }
    }

    public void modifyCompass() {
        new CompassController(this.home, this.preferences, this.viewFactory, this.undoSupport).displayView(this.getView());
    }

    public void modifyObserverCamera() {
        new ObserverCameraController(this.home, this.preferences, this.viewFactory).displayView(this.getView());
    }

    public void toggleBoldStyle() {
        Serializable serializable;
        Boolean bl = null;
        for (Selectable cloneable2 : this.home.getSelectedItems()) {
            if (cloneable2 instanceof Label) {
                serializable = Boolean.valueOf(this.getItemTextStyle(cloneable2, ((Label)cloneable2).getStyle()).isBold());
            } else if (cloneable2 instanceof HomePieceOfFurniture && ((HomePieceOfFurniture)cloneable2).isVisible()) {
                serializable = Boolean.valueOf(this.getItemTextStyle(cloneable2, ((HomePieceOfFurniture)cloneable2).getNameStyle()).isBold());
            } else if (cloneable2 instanceof Room) {
                Room room = (Room)cloneable2;
                serializable = Boolean.valueOf(this.getItemTextStyle(room, room.getNameStyle()).isBold());
                if (((Boolean)serializable).booleanValue() != this.getItemTextStyle(room, room.getAreaStyle()).isBold()) {
                    serializable = null;
                }
            } else {
                if (!(cloneable2 instanceof DimensionLine)) continue;
                serializable = Boolean.valueOf(this.getItemTextStyle(cloneable2, ((DimensionLine)cloneable2).getLengthStyle()).isBold());
            }
            if (bl == null) {
                bl = serializable;
                continue;
            }
            if (serializable != null && bl.equals(serializable)) continue;
            bl = null;
            break;
        }
        bl = bl == null ? Boolean.TRUE : Boolean.valueOf(bl == false);
        ArrayList arrayList = new ArrayList();
        ArrayList<TextStyle> arrayList2 = new ArrayList<TextStyle>();
        serializable = new ArrayList();
        for (Selectable selectable : this.home.getSelectedItems()) {
            TextStyle textStyle;
            HomeObject homeObject;
            if (selectable instanceof Label) {
                homeObject = (Label)selectable;
                arrayList.add(homeObject);
                textStyle = this.getItemTextStyle((Selectable)((Object)homeObject), ((Label)homeObject).getStyle());
                arrayList2.add(textStyle);
                serializable.add(textStyle.deriveBoldStyle(bl));
                continue;
            }
            if (selectable instanceof HomePieceOfFurniture) {
                homeObject = (HomePieceOfFurniture)selectable;
                if (!((HomePieceOfFurniture)homeObject).isVisible()) continue;
                arrayList.add(homeObject);
                textStyle = this.getItemTextStyle((Selectable)((Object)homeObject), ((HomePieceOfFurniture)homeObject).getNameStyle());
                arrayList2.add(textStyle);
                serializable.add(textStyle.deriveBoldStyle(bl));
                continue;
            }
            if (selectable instanceof Room) {
                homeObject = (Room)selectable;
                arrayList.add(homeObject);
                textStyle = this.getItemTextStyle((Selectable)((Object)homeObject), ((Room)homeObject).getNameStyle());
                arrayList2.add(textStyle);
                serializable.add(textStyle.deriveBoldStyle(bl));
                TextStyle textStyle2 = this.getItemTextStyle((Selectable)((Object)homeObject), ((Room)homeObject).getAreaStyle());
                arrayList2.add(textStyle2);
                serializable.add(textStyle2.deriveBoldStyle(bl));
                continue;
            }
            if (!(selectable instanceof DimensionLine)) continue;
            homeObject = (DimensionLine)selectable;
            arrayList.add(homeObject);
            textStyle = this.getItemTextStyle((Selectable)((Object)homeObject), ((DimensionLine)homeObject).getLengthStyle());
            arrayList2.add(textStyle);
            serializable.add(textStyle.deriveBoldStyle(bl));
        }
        this.modifyTextStyle(arrayList.toArray(new Selectable[arrayList.size()]), arrayList2.toArray(new TextStyle[arrayList2.size()]), serializable.toArray(new TextStyle[serializable.size()]));
    }

    private TextStyle getItemTextStyle(Selectable selectable, TextStyle textStyle) {
        if (textStyle == null) {
            textStyle = this.preferences.getDefaultTextStyle(selectable.getClass());
        }
        return textStyle;
    }

    public void toggleItalicStyle() {
        Serializable serializable;
        Boolean bl = null;
        for (Selectable cloneable2 : this.home.getSelectedItems()) {
            if (cloneable2 instanceof Label) {
                serializable = Boolean.valueOf(this.getItemTextStyle(cloneable2, ((Label)cloneable2).getStyle()).isItalic());
            } else if (cloneable2 instanceof HomePieceOfFurniture && ((HomePieceOfFurniture)cloneable2).isVisible()) {
                serializable = Boolean.valueOf(this.getItemTextStyle(cloneable2, ((HomePieceOfFurniture)cloneable2).getNameStyle()).isItalic());
            } else if (cloneable2 instanceof Room) {
                Room room = (Room)cloneable2;
                serializable = Boolean.valueOf(this.getItemTextStyle(room, room.getNameStyle()).isItalic());
                if (((Boolean)serializable).booleanValue() != this.getItemTextStyle(room, room.getAreaStyle()).isItalic()) {
                    serializable = null;
                }
            } else {
                if (!(cloneable2 instanceof DimensionLine)) continue;
                serializable = Boolean.valueOf(this.getItemTextStyle(cloneable2, ((DimensionLine)cloneable2).getLengthStyle()).isItalic());
            }
            if (bl == null) {
                bl = serializable;
                continue;
            }
            if (serializable != null && bl.equals(serializable)) continue;
            bl = null;
            break;
        }
        bl = bl == null ? Boolean.TRUE : Boolean.valueOf(bl == false);
        ArrayList arrayList = new ArrayList();
        ArrayList<TextStyle> arrayList2 = new ArrayList<TextStyle>();
        serializable = new ArrayList();
        for (Selectable selectable : this.home.getSelectedItems()) {
            TextStyle textStyle;
            HomeObject homeObject;
            if (selectable instanceof Label) {
                homeObject = (Label)selectable;
                arrayList.add(homeObject);
                textStyle = this.getItemTextStyle((Selectable)((Object)homeObject), ((Label)homeObject).getStyle());
                arrayList2.add(textStyle);
                serializable.add(textStyle.deriveItalicStyle(bl));
                continue;
            }
            if (selectable instanceof HomePieceOfFurniture) {
                homeObject = (HomePieceOfFurniture)selectable;
                if (!((HomePieceOfFurniture)homeObject).isVisible()) continue;
                arrayList.add(homeObject);
                textStyle = this.getItemTextStyle((Selectable)((Object)homeObject), ((HomePieceOfFurniture)homeObject).getNameStyle());
                arrayList2.add(textStyle);
                serializable.add(textStyle.deriveItalicStyle(bl));
                continue;
            }
            if (selectable instanceof Room) {
                homeObject = (Room)selectable;
                arrayList.add(homeObject);
                textStyle = this.getItemTextStyle((Selectable)((Object)homeObject), ((Room)homeObject).getNameStyle());
                arrayList2.add(textStyle);
                serializable.add(textStyle.deriveItalicStyle(bl));
                TextStyle textStyle2 = this.getItemTextStyle((Selectable)((Object)homeObject), ((Room)homeObject).getAreaStyle());
                arrayList2.add(textStyle2);
                serializable.add(textStyle2.deriveItalicStyle(bl));
                continue;
            }
            if (!(selectable instanceof DimensionLine)) continue;
            homeObject = (DimensionLine)selectable;
            arrayList.add(homeObject);
            textStyle = this.getItemTextStyle((Selectable)((Object)homeObject), ((DimensionLine)homeObject).getLengthStyle());
            arrayList2.add(textStyle);
            serializable.add(textStyle.deriveItalicStyle(bl));
        }
        this.modifyTextStyle(arrayList.toArray(new Selectable[arrayList.size()]), arrayList2.toArray(new TextStyle[arrayList2.size()]), serializable.toArray(new TextStyle[serializable.size()]));
    }

    public void increaseTextSize() {
        this.applyFactorToTextSize(1.1f);
    }

    public void decreaseTextSize() {
        this.applyFactorToTextSize(0.9090909f);
    }

    private void applyFactorToTextSize(float f) {
        ArrayList<HomeObject> arrayList = new ArrayList<HomeObject>();
        ArrayList<TextStyle> arrayList2 = new ArrayList<TextStyle>();
        ArrayList<TextStyle> arrayList3 = new ArrayList<TextStyle>();
        for (Selectable selectable : this.home.getSelectedItems()) {
            TextStyle textStyle;
            HomeObject homeObject;
            if (selectable instanceof Label) {
                homeObject = (Label)selectable;
                arrayList.add(homeObject);
                textStyle = this.getItemTextStyle(selectable, ((Label)homeObject).getStyle());
                arrayList2.add(textStyle);
                arrayList3.add(textStyle.deriveStyle(Math.round(textStyle.getFontSize() * f)));
                continue;
            }
            if (selectable instanceof HomePieceOfFurniture) {
                homeObject = (HomePieceOfFurniture)selectable;
                if (!((HomePieceOfFurniture)homeObject).isVisible()) continue;
                arrayList.add(homeObject);
                textStyle = this.getItemTextStyle((Selectable)((Object)homeObject), ((HomePieceOfFurniture)homeObject).getNameStyle());
                arrayList2.add(textStyle);
                arrayList3.add(textStyle.deriveStyle(Math.round(textStyle.getFontSize() * f)));
                continue;
            }
            if (selectable instanceof Room) {
                homeObject = (Room)selectable;
                arrayList.add(homeObject);
                textStyle = this.getItemTextStyle((Selectable)((Object)homeObject), ((Room)homeObject).getNameStyle());
                arrayList2.add(textStyle);
                arrayList3.add(textStyle.deriveStyle(Math.round(textStyle.getFontSize() * f)));
                TextStyle textStyle2 = this.getItemTextStyle((Selectable)((Object)homeObject), ((Room)homeObject).getAreaStyle());
                arrayList2.add(textStyle2);
                arrayList3.add(textStyle2.deriveStyle(Math.round(textStyle2.getFontSize() * f)));
                continue;
            }
            if (!(selectable instanceof DimensionLine)) continue;
            homeObject = (DimensionLine)selectable;
            arrayList.add(homeObject);
            textStyle = this.getItemTextStyle((Selectable)((Object)homeObject), ((DimensionLine)homeObject).getLengthStyle());
            arrayList2.add(textStyle);
            arrayList3.add(textStyle.deriveStyle(Math.round(textStyle.getFontSize() * f)));
        }
        this.modifyTextStyle(arrayList.toArray(new Selectable[arrayList.size()]), arrayList2.toArray(new TextStyle[arrayList2.size()]), arrayList3.toArray(new TextStyle[arrayList3.size()]));
    }

    private void modifyTextStyle(Selectable[] selectableArray, TextStyle[] textStyleArray, TextStyle[] textStyleArray2) {
        boolean bl = this.home.isAllLevelsSelection();
        List<Selectable> list = this.home.getSelectedItems();
        Selectable[] selectableArray2 = list.toArray(new Selectable[list.size()]);
        PlanController.doModifyTextStyle(selectableArray, textStyleArray2);
        this.undoSupport.postEdit(new TextStyleModificationUndoableEdit(this, this.preferences, selectableArray2, bl, textStyleArray, selectableArray, textStyleArray2));
    }

    private static void doModifyTextStyle(Selectable[] selectableArray, TextStyle[] textStyleArray) {
        int n = 0;
        for (Selectable selectable : selectableArray) {
            HomeObject homeObject;
            if (selectable instanceof Label) {
                ((Label)selectable).setStyle(textStyleArray[n++]);
                continue;
            }
            if (selectable instanceof HomePieceOfFurniture) {
                homeObject = (HomePieceOfFurniture)selectable;
                if (!((HomePieceOfFurniture)homeObject).isVisible()) continue;
                ((HomePieceOfFurniture)homeObject).setNameStyle(textStyleArray[n++]);
                continue;
            }
            if (selectable instanceof Room) {
                homeObject = (Room)selectable;
                ((Room)homeObject).setNameStyle(textStyleArray[n++]);
                ((Room)homeObject).setAreaStyle(textStyleArray[n++]);
                continue;
            }
            if (!(selectable instanceof DimensionLine)) continue;
            ((DimensionLine)selectable).setLengthStyle(textStyleArray[n++]);
        }
    }

    public float getMinimumScale() {
        return 0.01f;
    }

    public float getMaximumScale() {
        return 10.0f;
    }

    public float getScale() {
        return this.getView().getScale();
    }

    public void setScale(float f) {
        f = Math.max(this.getMinimumScale(), Math.min(f, this.getMaximumScale()));
        if (f != this.getView().getScale()) {
            float f2 = this.getView().getScale();
            this.furnitureSidesCache.clear();
            if (this.getView() != null) {
                int n = this.getView().convertXModelToScreen(this.getXLastMouseMove());
                int n2 = this.getView().convertXModelToScreen(this.getYLastMouseMove());
                this.getView().setScale(f);
                this.home.getObserverCamera().setPlanScale((double)f < 0.4 ? 0.4f / f : 1.0f);
                this.moveMouse(this.getView().convertXPixelToModel(n), this.getView().convertYPixelToModel(n2));
            }
            this.propertyChangeSupport.firePropertyChange(Property.SCALE.name(), Float.valueOf(f2), Float.valueOf(f));
            this.home.setProperty(SCALE_VISUAL_PROPERTY, String.valueOf(f));
        }
    }

    public final void setSelectedLevel(Level level) {
        this.home.setSelectedLevel(level);
    }

    @Override
    public void selectAll() {
        List<Selectable> list = this.getVisibleItemsAtSelectedLevel();
        if (this.home.isBasePlanLocked()) {
            this.home.setSelectedItems(this.getItemsNotPartOfBasePlan(list));
        } else {
            this.home.setSelectedItems(list);
        }
        this.home.setAllLevelsSelection(false);
    }

    private List<Selectable> getVisibleItemsAtSelectedLevel() {
        ArrayList<Selectable> arrayList = new ArrayList<Selectable>();
        Level level = this.home.getSelectedLevel();
        for (Selectable selectable : this.home.getSelectableViewableItems()) {
            if (selectable instanceof HomePieceOfFurniture) {
                if (!this.isPieceOfFurnitureVisibleAtSelectedLevel((HomePieceOfFurniture)selectable)) continue;
                arrayList.add(selectable);
                continue;
            }
            if (selectable instanceof Elevatable && !((Elevatable)((Object)selectable)).isAtLevel(level)) continue;
            arrayList.add(selectable);
        }
        return arrayList;
    }

    public void selectAllAtAllLevels() {
        List<Selectable> list = new ArrayList<Selectable>(this.home.getSelectableViewableItems());
        if (this.home.isBasePlanLocked()) {
            list = this.getItemsNotPartOfBasePlan(list);
        }
        this.home.setSelectedItems(list);
        this.home.setAllLevelsSelection(true);
    }

    private List<Room> getDetectableRoomsAtSelectedLevel() {
        List<Room> list = this.home.getRooms();
        Level level = this.home.getSelectedLevel();
        List<Level> list2 = this.home.getLevels();
        if (level == null || list2.size() <= 1) {
            return list;
        }
        ArrayList<Room> arrayList = new ArrayList<Room>(list.size());
        int n = list2.indexOf(level);
        boolean bl = list2.get(0) == level || list2.get(n - 1).getElevation() == level.getElevation();
        Level level2 = list2.get(bl && n < list2.size() - 1 ? n + 1 : n - 1);
        for (Room room : list) {
            if (!room.isAtLevel(level) && (level2 == null || !room.isAtLevel(level2) || (!bl || !room.isFloorVisible()) && (bl || !room.isCeilingVisible()))) continue;
            arrayList.add(room);
        }
        return arrayList;
    }

    private Collection<Wall> getDetectableWallsAtSelectedLevel() {
        Collection<Wall> collection = this.home.getWalls();
        Level level = this.home.getSelectedLevel();
        List<Level> list = this.home.getLevels();
        if (level == null || list.size() <= 1) {
            return collection;
        }
        ArrayList<Wall> arrayList = new ArrayList<Wall>(collection.size());
        int n = list.indexOf(level);
        boolean bl = list.get(0) == level || list.get(n - 1).getElevation() == level.getElevation();
        Level level2 = list.get(bl && n < list.size() - 1 ? n + 1 : n - 1);
        for (Wall wall : collection) {
            if (!wall.isAtLevel(level) && (level2 == null || !wall.isAtLevel(level2))) continue;
            arrayList.add(wall);
        }
        return arrayList;
    }

    public View getHorizontalRulerView() {
        return this.getView().getHorizontalRuler();
    }

    public View getVerticalRulerView() {
        return this.getView().getVerticalRuler();
    }

    private void addModelListeners() {
        this.selectionListener = new SelectionListener(){

            public void selectionChanged(SelectionEvent selectionEvent) {
                PlanController.this.selectLevelFromSelectedItems();
                if (PlanController.this.getView() != null) {
                    PlanController.this.getView().makeSelectionVisible();
                }
            }
        };
        this.home.addSelectionListener(this.selectionListener);
        this.home.getObserverCamera().addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (PlanController.this.home.getSelectedItems().contains(propertyChangeEvent.getSource()) && PlanController.this.getView() != null) {
                    PlanController.this.getView().makeSelectionVisible();
                }
            }
        });
        this.wallChangeListener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                String string = propertyChangeEvent.getPropertyName();
                if (Wall.Property.X_START.name().equals(string) || Wall.Property.X_END.name().equals(string) || Wall.Property.Y_START.name().equals(string) || Wall.Property.Y_END.name().equals(string) || Wall.Property.WALL_AT_START.name().equals(string) || Wall.Property.WALL_AT_END.name().equals(string) || Wall.Property.THICKNESS.name().equals(string) || Wall.Property.ARC_EXTENT.name().equals(string) || Wall.Property.LEVEL.name().equals(string) || Wall.Property.HEIGHT.name().equals(string) || Wall.Property.HEIGHT_AT_END.name().equals(string) || Wall.Property.LEFT_SIDE_BASEBOARD.name().equals(string) || Wall.Property.RIGHT_SIDE_BASEBOARD.name().equals(string)) {
                    ArrayList<Selectable> arrayList;
                    PlanController.this.resetAreaCache();
                    Wall wall = (Wall)propertyChangeEvent.getSource();
                    if (!wall.isAtLevel(PlanController.this.home.getSelectedLevel()) && (arrayList = new ArrayList<Selectable>(PlanController.this.home.getSelectedItems())).remove(wall)) {
                        PlanController.this.selectItems(arrayList, PlanController.this.home.isAllLevelsSelection());
                    }
                }
            }
        };
        for (Wall object : this.home.getWalls()) {
            object.addPropertyChangeListener(this.wallChangeListener);
        }
        this.home.addWallsListener(new CollectionListener<Wall>(){

            @Override
            public void collectionChanged(CollectionEvent<Wall> collectionEvent) {
                if (collectionEvent.getType() == CollectionEvent.Type.ADD) {
                    collectionEvent.getItem().addPropertyChangeListener(PlanController.this.wallChangeListener);
                } else if (collectionEvent.getType() == CollectionEvent.Type.DELETE) {
                    collectionEvent.getItem().removePropertyChangeListener(PlanController.this.wallChangeListener);
                }
                PlanController.this.resetAreaCache();
            }
        });
        final PropertyChangeListener propertyChangeListener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                String string = propertyChangeEvent.getPropertyName();
                if (HomePieceOfFurniture.Property.X.name().equals(string) || HomePieceOfFurniture.Property.Y.name().equals(string) || HomePieceOfFurniture.Property.WIDTH_IN_PLAN.name().equals(string) || HomePieceOfFurniture.Property.DEPTH_IN_PLAN.name().equals(string)) {
                    PlanController.this.furnitureSidesCache.remove((HomePieceOfFurniture)propertyChangeEvent.getSource());
                }
            }
        };
        this.furnitureSizeChangeListener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                HomePieceOfFurniture homePieceOfFurniture = (HomePieceOfFurniture)propertyChangeEvent.getSource();
                String string = propertyChangeEvent.getPropertyName();
                if (HomePieceOfFurniture.Property.MODEL.name().equals(string) || HomePieceOfFurniture.Property.MODEL_MIRRORED.name().equals(string) || HomePieceOfFurniture.Property.MODEL_ROTATION.name().equals(string) || HomePieceOfFurniture.Property.WIDTH.name().equals(string) || HomePieceOfFurniture.Property.DEPTH.name().equals(string) || HomePieceOfFurniture.Property.HEIGHT.name().equals(string) || HomePieceOfFurniture.Property.ROLL.name().equals(string) || HomePieceOfFurniture.Property.PITCH.name().equals(string)) {
                    float[] fArray = PlanController.this.getView().getPieceOfFurnitureSizeInPlan(homePieceOfFurniture);
                    if (fArray != null) {
                        homePieceOfFurniture.setWidthInPlan(fArray[0]);
                        homePieceOfFurniture.setDepthInPlan(fArray[1]);
                        homePieceOfFurniture.setHeightInPlan(fArray[2]);
                    } else if (HomePieceOfFurniture.Property.WIDTH.name().equals(string)) {
                        float f = homePieceOfFurniture.getWidth() / ((Number)propertyChangeEvent.getOldValue()).floatValue();
                        homePieceOfFurniture.setWidthInPlan(f * homePieceOfFurniture.getWidthInPlan());
                        homePieceOfFurniture.setDepthInPlan(f * homePieceOfFurniture.getDepthInPlan());
                        homePieceOfFurniture.setHeightInPlan(f * homePieceOfFurniture.getHeightInPlan());
                    }
                }
            }
        };
        for (HomePieceOfFurniture homePieceOfFurniture : this.home.getFurniture()) {
            homePieceOfFurniture.addPropertyChangeListener(propertyChangeListener);
            homePieceOfFurniture.addPropertyChangeListener(this.furnitureSizeChangeListener);
            if (!(homePieceOfFurniture instanceof HomeFurnitureGroup)) continue;
            for (HomePieceOfFurniture homePieceOfFurniture2 : ((HomeFurnitureGroup)homePieceOfFurniture).getAllFurniture()) {
                homePieceOfFurniture2.addPropertyChangeListener(this.furnitureSizeChangeListener);
            }
        }
        this.home.addFurnitureListener(new CollectionListener<HomePieceOfFurniture>(){

            @Override
            public void collectionChanged(CollectionEvent<HomePieceOfFurniture> collectionEvent) {
                block5: {
                    HomePieceOfFurniture homePieceOfFurniture;
                    block4: {
                        homePieceOfFurniture = collectionEvent.getItem();
                        if (collectionEvent.getType() != CollectionEvent.Type.ADD) break block4;
                        homePieceOfFurniture.addPropertyChangeListener(propertyChangeListener);
                        homePieceOfFurniture.addPropertyChangeListener(PlanController.this.furnitureSizeChangeListener);
                        if (!(homePieceOfFurniture instanceof HomeFurnitureGroup)) break block5;
                        for (HomePieceOfFurniture homePieceOfFurniture2 : ((HomeFurnitureGroup)homePieceOfFurniture).getAllFurniture()) {
                            homePieceOfFurniture2.addPropertyChangeListener(PlanController.this.furnitureSizeChangeListener);
                        }
                        break block5;
                    }
                    if (collectionEvent.getType() == CollectionEvent.Type.DELETE) {
                        homePieceOfFurniture.removePropertyChangeListener(propertyChangeListener);
                        PlanController.this.furnitureSidesCache.remove(homePieceOfFurniture);
                        homePieceOfFurniture.removePropertyChangeListener(PlanController.this.furnitureSizeChangeListener);
                        if (homePieceOfFurniture instanceof HomeFurnitureGroup) {
                            for (HomePieceOfFurniture homePieceOfFurniture3 : ((HomeFurnitureGroup)homePieceOfFurniture).getAllFurniture()) {
                                homePieceOfFurniture3.removePropertyChangeListener(PlanController.this.furnitureSizeChangeListener);
                            }
                        }
                    }
                }
            }
        });
        this.home.addPropertyChangeListener(Home.Property.SELECTED_LEVEL, new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                PlanController.this.resetAreaCache();
            }
        });
        this.home.getObserverCamera().setFixedSize(this.home.getLevels().size() >= 2);
        this.home.addLevelsListener(new CollectionListener<Level>(){

            @Override
            public void collectionChanged(CollectionEvent<Level> collectionEvent) {
                PlanController.this.home.getObserverCamera().setFixedSize(PlanController.this.home.getLevels().size() >= 2);
            }
        });
    }

    private SelectionListener getSelectionListener() {
        return this.selectionListener;
    }

    private void resetAreaCache() {
        this.wallsAreaCache = null;
        this.wallsIncludingBaseboardsAreaCache = null;
        this.insideWallsAreaCache = null;
        this.roomPathsCache = null;
    }

    public void startDraggedItems(List<Selectable> list, float f, float f2) {
        this.draggedItems = list;
        if (this.preferences.isMagnetismEnabled()) {
            for (HomePieceOfFurniture homePieceOfFurniture : Home.getFurnitureSubList(list)) {
                if (homePieceOfFurniture.isResizable()) {
                    homePieceOfFurniture.setWidth(this.preferences.getLengthUnit().getMagnetizedLength(homePieceOfFurniture.getWidth(), 0.1f));
                    homePieceOfFurniture.setWidthInPlan(homePieceOfFurniture.getWidth());
                    homePieceOfFurniture.setDepth(this.preferences.getLengthUnit().getMagnetizedLength(homePieceOfFurniture.getDepth(), 0.1f));
                    homePieceOfFurniture.setDepthInPlan(homePieceOfFurniture.getDepth());
                    homePieceOfFurniture.setHeight(this.preferences.getLengthUnit().getMagnetizedLength(homePieceOfFurniture.getHeight(), 0.1f));
                    homePieceOfFurniture.setHeightInPlan(homePieceOfFurniture.getHeight());
                }
                homePieceOfFurniture.setElevation(this.preferences.getLengthUnit().getMagnetizedLength(homePieceOfFurniture.getElevation(), 0.1f));
            }
        }
        if (this.isModificationState()) {
            this.escape();
        }
        this.setState(this.getDragAndDropState());
        this.moveMouse(f, f2);
    }

    public void stopDraggedItems() {
        if (this.state != this.getDragAndDropState()) {
            throw new IllegalStateException("Controller isn't in a drag and drop state");
        }
        this.draggedItems = null;
        this.setState(this.previousState);
    }

    protected void adjustMagnetizedPieceOfFurniture(HomePieceOfFurniture homePieceOfFurniture, float f, float f2) {
        boolean bl = this.adjustPieceOfFurnitureElevation(homePieceOfFurniture) != null;
        Wall wall = this.adjustPieceOfFurnitureOnWallAt(homePieceOfFurniture, f, f2, true);
        if (!bl) {
            this.adjustPieceOfFurnitureSideBySideAt(homePieceOfFurniture, wall == null, wall);
        }
    }

    private Wall adjustPieceOfFurnitureOnWallAt(HomePieceOfFurniture homePieceOfFurniture, float f, float f2, boolean bl) {
        Object object;
        float f3 = 4.0f / this.getScale();
        Level level = this.home.getSelectedLevel();
        float[][] fArray = homePieceOfFurniture.getPoints();
        boolean bl2 = !homePieceOfFurniture.isDoorOrWindow() && homePieceOfFurniture.getElevation() == 0.0f;
        Area area = this.getWallsArea(bl2);
        Collection<Wall> collection = this.home.getWalls();
        Wall wall = null;
        Float f4 = null;
        if (bl || !homePieceOfFurniture.isDoorOrWindow()) {
            for (Wall wall2 : collection) {
                if (!wall2.isAtLevel(level) || !this.isLevelNullOrViewable(wall2.getLevel()) || !wall2.containsPoint(f, f2, bl2, 0.0f) || !(wall2.getStartPointToEndPointDistance() > 0.0f)) continue;
                wall = this.getReferenceWall(wall2, f, f2);
                f4 = wall2.getArcExtent();
                break;
            }
            if (wall == null) {
                for (Wall wall2 : collection) {
                    if (!wall2.isAtLevel(level) || !this.isLevelNullOrViewable(wall2.getLevel()) || !wall2.containsPoint(f, f2, bl2, 0.0f) || !(wall2.getStartPointToEndPointDistance() > 0.0f)) continue;
                    wall = this.getReferenceWall(wall2, f, f2);
                    f4 = wall2.getArcExtent();
                    break;
                }
            }
        }
        if (wall == null) {
            Area area2 = new Area(this.getRotatedRectangle(homePieceOfFurniture.getX() - homePieceOfFurniture.getWidthInPlan() / 2.0f - f3, homePieceOfFurniture.getY() - homePieceOfFurniture.getDepthInPlan() / 2.0f - f3, homePieceOfFurniture.getWidthInPlan() + 2.0f * f3, homePieceOfFurniture.getDepthInPlan() + 2.0f * f3, homePieceOfFurniture.getAngle()));
            float f5 = 0.0f;
            for (Wall wall3 : collection) {
                float f6;
                if (!wall3.isAtLevel(level) || !this.isLevelNullOrViewable(wall3.getLevel()) || !(wall3.getStartPointToEndPointDistance() > 0.0f)) continue;
                float[][] fArray2 = wall3.getPoints(bl2);
                Area area3 = new Area(this.getPath(fArray2));
                area3.intersect(area2);
                if (area3.isEmpty() || !((f6 = this.getArea(area3)) > f5)) continue;
                f5 = f6;
                if (bl) {
                    wall = this.getReferenceWall(wall3, f, f2);
                    f4 = wall3.getArcExtent();
                    continue;
                }
                object = area3.getBounds2D();
                wall = this.getReferenceWall(wall3, (float)((RectangularShape)object).getCenterX(), (float)((RectangularShape)object).getCenterY());
                f4 = wall3.getArcExtent();
            }
        }
        if (wall != null) {
            Shape shape;
            Object object2;
            double d;
            double d2;
            boolean bl3;
            float f7 = f;
            float f8 = f2;
            float f9 = homePieceOfFurniture.getAngle();
            float f10 = homePieceOfFurniture.getWidthInPlan() / 2.0f;
            float f11 = homePieceOfFurniture.getDepthInPlan() / 2.0f;
            double d3 = Math.atan2(wall.getYEnd() - wall.getYStart(), wall.getXEnd() - wall.getXStart());
            object = wall.getPoints(bl2);
            boolean bl4 = d3 > -1.5707963267948966 && d3 <= 1.5707963267948966;
            double d4 = Math.cos(d3);
            double d5 = Math.sin(d3);
            double d6 = object[0][0] != object[0][1] || object[1][0] != object[1][1] ? Line2D.ptLineDist(object[0][0], object[0][1], object[1][0], object[1][1], f, f2) : Point2D.distance(object[0][0], object[0][1], f, f2);
            double d7 = object[2][0] != object[2][1] || object[3][0] != object[3][1] ? Line2D.ptLineDist((double)object[2][0], (double)object[2][1], (double)object[3][0], (double)object[3][1], f, f2) : Point2D.distance((double)object[2][0], (double)object[2][1], f, f2);
            boolean bl5 = bl3 = bl || homePieceOfFurniture.isDoorOrWindow() || wall.containsPoint(f, f2, bl2, f3);
            if (bl3) {
                double d8 = Line2D.ptLineDist(fArray[0][0], fArray[0][1], fArray[3][0], fArray[3][1], f, f2);
                d2 = Line2D.ptLineDist(fArray[1][0], fArray[1][1], fArray[2][0], fArray[2][1], f, f2);
                d = (double)f9 > 4.71238998038469 || (double)f9 < 1.5707973267948965 ? d8 : d2;
                f9 = (float)(d7 < d6 ? d3 : d3 + Math.PI);
                if (homePieceOfFurniture.isDoorOrWindow()) {
                    float f12;
                    if (f4 == null || f4.floatValue() == 0.0f) {
                        f12 = 3.75E-4f;
                        if (homePieceOfFurniture instanceof HomeDoorOrWindow) {
                            object2 = (HomeDoorOrWindow)homePieceOfFurniture;
                            if (homePieceOfFurniture.isResizable() && this.isItemResizable(homePieceOfFurniture) && ((HomeDoorOrWindow)object2).isWidthDepthDeformable() && ((HomePieceOfFurniture)object2).getModelTransformations() == null) {
                                homePieceOfFurniture.setDepth(7.5E-4f + wall.getThickness() / ((HomeDoorOrWindow)object2).getWallThickness());
                                homePieceOfFurniture.setDepthInPlan(homePieceOfFurniture.getDepth());
                                f11 = homePieceOfFurniture.getDepth() / 2.0f;
                                f12 += homePieceOfFurniture.getDepth() * ((HomeDoorOrWindow)object2).getWallDistance();
                            } else {
                                f12 += homePieceOfFurniture.getDepth() * (((HomeDoorOrWindow)object2).getWallDistance() + ((HomeDoorOrWindow)object2).getWallThickness()) - wall.getThickness();
                            }
                        }
                    } else {
                        f12 = -wall.getThickness() / 2.0f;
                        if (homePieceOfFurniture instanceof HomeDoorOrWindow) {
                            object2 = (HomeDoorOrWindow)homePieceOfFurniture;
                            f12 += homePieceOfFurniture.getDepth() * (((HomeDoorOrWindow)object2).getWallDistance() + ((HomeDoorOrWindow)object2).getWallThickness() / 2.0f);
                        }
                    }
                    if (d7 < d6) {
                        f7 = (float)((double)f7 + d5 * (d6 + (double)f12 - (double)f11));
                        f8 = (float)((double)f8 + d4 * (-(d6 + (double)f12) + (double)f11));
                    } else {
                        f7 = (float)((double)f7 + d5 * (-(d7 + (double)f12) + (double)f11));
                        f8 = (float)((double)f8 + d4 * (d7 + (double)f12 - (double)f11));
                    }
                    if (bl4) {
                        f7 = (float)((double)f7 + d4 * ((double)f10 - d));
                        f8 = (float)((double)f8 + d5 * ((double)f10 - d));
                    } else {
                        f7 = (float)((double)f7 + -d4 * ((double)f10 - d));
                        f8 = (float)((double)f8 + -d5 * ((double)f10 - d));
                    }
                } else {
                    int n;
                    if (d7 < d6) {
                        n = Line2D.relativeCCW((double)object[2][0], (double)object[2][1], (double)object[3][0], (double)object[3][1], f, f2);
                        f7 = (float)((double)f7 + ((double)n * d5 * d7 - d5 * (double)f11));
                        f8 = (float)((double)f8 + ((double)(-n) * d4 * d7 + d4 * (double)f11));
                    } else {
                        n = Line2D.relativeCCW((double)object[0][0], (double)object[0][1], (double)object[1][0], (double)object[1][1], f, f2);
                        f7 = (float)((double)f7 + ((double)(-n) * d5 * d6 + d5 * (double)f11));
                        f8 = (float)((double)f8 + ((double)n * d4 * d6 - d4 * (double)f11));
                    }
                    if (bl4) {
                        f7 = (float)((double)f7 + d4 * ((double)f10 - d));
                        f8 = (float)((double)f8 + d5 * ((double)f10 - d));
                    } else {
                        f7 = (float)((double)f7 + -d4 * ((double)f10 - d));
                        f8 = (float)((double)f8 + -d5 * ((double)f10 - d));
                    }
                }
            } else {
                Line2D.Float float_ = new Line2D.Float(wall.getXStart(), wall.getYStart(), wall.getXEnd(), wall.getYEnd());
                shape = this.getRotatedRectangle(0.0f, 0.0f, homePieceOfFurniture.getWidthInPlan(), homePieceOfFurniture.getDepthInPlan(), (float)((double)f9 - d3));
                d2 = shape.getBounds2D().getHeight();
                float f13 = Math.signum(float_.relativeCCW(homePieceOfFurniture.getX(), homePieceOfFurniture.getY()));
                float f14 = Math.signum(float_.relativeCCW(f, f2));
                double d9 = (double)f13 * ((double)(-wall.getThickness() / 2.0f) + float_.ptLineDist(homePieceOfFurniture.getX(), homePieceOfFurniture.getY()) - d2 / 2.0);
                if (bl2) {
                    if (f13 > 0.0f && wall.getLeftSideBaseboard() != null) {
                        d9 -= (double)(f13 * wall.getLeftSideBaseboard().getThickness());
                    } else if (f13 < 0.0f && wall.getRightSideBaseboard() != null) {
                        d9 -= (double)(f13 * wall.getRightSideBaseboard().getThickness());
                    }
                }
                if (f14 != f13) {
                    d9 -= (double)f14 * (d2 + (double)wall.getThickness());
                    if (wall.getLeftSideBaseboard() != null) {
                        d9 -= (double)(f14 * wall.getLeftSideBaseboard().getThickness());
                    }
                    if (wall.getRightSideBaseboard() != null) {
                        d9 -= (double)(f14 * wall.getRightSideBaseboard().getThickness());
                    }
                }
                f7 = homePieceOfFurniture.getX() + (float)(-d9 * d5);
                f8 = homePieceOfFurniture.getY() + (float)(d9 * d4);
            }
            if (!(homePieceOfFurniture.isDoorOrWindow() || wall.getArcExtent() != null && bl3 && Line2D.relativeCCW(wall.getXStart(), wall.getYStart(), wall.getXEnd(), wall.getYEnd(), f, f2) <= 0)) {
                GeneralPath generalPath;
                Area area4 = new Area(area);
                shape = new Area(this.getRotatedRectangle(f7 - f10, f8 - f11, homePieceOfFurniture.getWidthInPlan(), homePieceOfFurniture.getDepthInPlan(), f9));
                area4.subtract(new Area(this.getPath((float[][])object)));
                area4.intersect((Area)shape);
                if (!area4.isEmpty() && (generalPath = this.getClosestPath(this.getAreaPaths(area4), f, f2)) != null) {
                    ((Area)shape).subtract(area);
                    if (((Area)shape).isEmpty()) {
                        return null;
                    }
                    List<GeneralPath> list = this.getAreaPaths((Area)shape);
                    d = (d3 - (double)f9 + Math.PI * 2) % Math.PI;
                    if (d < 1.0E-5 || Math.PI - d < 1.0E-5 || list.size() < 2) {
                        Rectangle2D rectangle2D;
                        GeneralPath generalPath2 = this.getClosestPath(list, f, f2);
                        Area area5 = new Area(generalPath);
                        for (GeneralPath shape22 : list) {
                            if (shape22 == generalPath2) continue;
                            area5.add(new Area(shape22));
                        }
                        object2 = AffineTransform.getRotateInstance(-d3);
                        Rectangle2D rectangle2D2 = area5.createTransformedArea((AffineTransform)object2).getBounds2D();
                        if (!rectangle2D2.contains(rectangle2D = generalPath2.createTransformedShape((AffineTransform)object2).getBounds2D())) {
                            double d8 = Math.signum(rectangle2D.getCenterX() - rectangle2D2.getCenterX());
                            f7 = (float)((double)f7 + rectangle2D2.getWidth() * d4 * d8);
                            f8 = (float)((double)f8 + rectangle2D2.getWidth() * d5 * d8);
                        }
                    }
                }
            }
            homePieceOfFurniture.setAngle(f9);
            homePieceOfFurniture.setX(f7);
            homePieceOfFurniture.setY(f8);
            if (homePieceOfFurniture instanceof HomeDoorOrWindow) {
                ((HomeDoorOrWindow)homePieceOfFurniture).setBoundToWall(f4 == null || f4.floatValue() == 0.0f);
            }
            return wall;
        }
        return null;
    }

    private boolean isLevelNullOrViewable(Level level) {
        return level == null || level.isViewable();
    }

    private Wall getReferenceWall(Wall wall, float f, float f2) {
        Float f3 = wall.getArcExtent();
        if (f3 == null || f3.floatValue() == 0.0f) {
            return wall;
        }
        double d = Math.atan2(wall.getYArcCircleCenter() - f2, f - wall.getXArcCircleCenter());
        double d2 = Point2D.distance(wall.getXArcCircleCenter(), wall.getYArcCircleCenter(), wall.getXStart(), wall.getYStart());
        float f4 = 0.001f;
        Wall wall2 = new Wall((float)((double)wall.getXArcCircleCenter() + Math.cos(d + (double)f4) * d2), (float)((double)wall.getYArcCircleCenter() - Math.sin(d + (double)f4) * d2), (float)((double)wall.getXArcCircleCenter() + Math.cos(d - (double)f4) * d2), (float)((double)wall.getYArcCircleCenter() - Math.sin(d - (double)f4) * d2), wall.getThickness(), 0.0f);
        wall2.setLeftSideBaseboard(wall.getLeftSideBaseboard());
        wall2.setRightSideBaseboard(wall.getRightSideBaseboard());
        return wall2;
    }

    private GeneralPath getClosestPath(List<GeneralPath> list, float f, float f2) {
        GeneralPath generalPath = null;
        double d = Double.MAX_VALUE;
        for (GeneralPath generalPath2 : list) {
            float[][] fArray = this.getPathPoints(generalPath2, true);
            for (int i = 0; i < fArray.length; ++i) {
                double d2 = Line2D.ptSegDistSq(fArray[i][0], fArray[i][1], fArray[(i + 1) % fArray.length][0], fArray[(i + 1) % fArray.length][1], f, f2);
                if (!(d2 < d)) continue;
                d = d2;
                generalPath = generalPath2;
            }
        }
        return generalPath;
    }

    private List<DimensionLine> getDimensionLinesAlongWall(HomePieceOfFurniture homePieceOfFurniture, Wall wall) {
        int n;
        float[] fArray;
        float[] fArray2;
        float[] fArray3;
        float[][] fArray4 = homePieceOfFurniture.getPoints();
        float f = homePieceOfFurniture.getAngle();
        float[][] fArray5 = wall.getPoints();
        float[] fArray6 = fArray3 = homePieceOfFurniture.isDoorOrWindow() ? fArray4[3] : fArray4[0];
        if (Line2D.ptLineDistSq(fArray5[0][0], fArray5[0][1], fArray5[1][0], fArray5[1][1], fArray3[0], fArray3[1]) <= Line2D.ptLineDistSq(fArray5[2][0], fArray5[2][1], fArray5[3][0], fArray5[3][1], fArray3[0], fArray3[1])) {
            fArray2 = PlanController.computeIntersection(fArray5[0], fArray5[1], fArray4[0], fArray4[3]);
            fArray = PlanController.computeIntersection(fArray5[0], fArray5[1], fArray4[1], fArray4[2]);
        } else {
            fArray2 = PlanController.computeIntersection(fArray5[2], fArray5[3], fArray4[0], fArray4[3]);
            fArray = PlanController.computeIntersection(fArray5[2], fArray5[3], fArray4[1], fArray4[2]);
        }
        ArrayList<DimensionLine> arrayList = new ArrayList<DimensionLine>();
        float[] fArray7 = null;
        float[] fArray8 = null;
        List<GeneralPath> list = this.getRoomPathsFromWalls();
        block0: for (n = 0; n < list.size() && fArray7 == null && fArray8 == null; ++n) {
            float[][] fArray9 = this.getPathPoints(list.get(n), true);
            for (int i = 0; i < fArray9.length; ++i) {
                double d;
                double d2;
                boolean bl;
                float[] fArray10 = fArray9[i];
                float[] fArray11 = fArray9[(i + 1) % fArray9.length];
                float f2 = fArray11[0] - fArray10[0];
                float f3 = fArray11[1] - fArray10[1];
                double d3 = (double)Math.abs(f2) < 1.0E-5 ? 1.5707963267948966 : ((double)Math.abs(f3) < 1.0E-5 ? 0.0 : Math.atan2(f3, f2));
                double d4 = (d3 - (double)f + Math.PI * 2) % Math.PI;
                if (!(d4 < 1.0E-5) && !(Math.PI - d4 < 1.0E-5)) continue;
                boolean bl2 = Line2D.ptSegDistSq(fArray10[0], fArray10[1], fArray11[0], fArray11[1], fArray2[0], fArray2[1]) < 1.0E-4;
                boolean bl3 = bl = Line2D.ptSegDistSq(fArray10[0], fArray10[1], fArray11[0], fArray11[1], fArray[0], fArray[1]) < 1.0E-4;
                if (!bl2 && !bl) continue;
                if (bl2) {
                    d2 = Point2D.distanceSq(fArray10[0], fArray10[1], fArray2[0], fArray2[1]);
                    fArray7 = d2 < (d = Point2D.distanceSq(fArray10[0], fArray10[1], fArray[0], fArray[1])) || !bl ? (float[])fArray10.clone() : (float[])fArray11.clone();
                }
                if (!bl) continue block0;
                d2 = Point2D.distanceSq(fArray11[0], fArray11[1], fArray2[0], fArray2[1]);
                if (d2 < (d = Point2D.distanceSq(fArray11[0], fArray11[1], fArray[0], fArray[1])) && bl2) {
                    fArray8 = (float[])fArray10.clone();
                    continue block0;
                }
                fArray8 = (float[])fArray11.clone();
                continue block0;
            }
        }
        int n2 = n = !homePieceOfFurniture.isDoorOrWindow() && Line2D.ptLineDistSq(wall.getXStart(), wall.getYStart(), wall.getXEnd(), wall.getYEnd(), fArray3[0], fArray3[1]) > Line2D.ptLineDistSq(wall.getXStart(), wall.getYStart(), wall.getXEnd(), wall.getYEnd(), fArray4[3][0], fArray4[3][1]) ? 1 : 0;
        if (fArray7 != null) {
            float f4 = n != 0 ? -((float)Point2D.distance(fArray2[0], fArray2[1], fArray4[0][0], fArray4[0][1])) - 10.0f / this.getView().getScale() : (float)Point2D.distance(fArray2[0], fArray2[1], fArray4[3][0], fArray4[3][1]) + 10.0f / this.getView().getScale();
            arrayList.add(this.getDimensionLineBetweenPoints(fArray7, fArray2, f4, 0.0, false));
        }
        if (fArray8 != null) {
            float f5 = n != 0 ? -((float)Point2D.distance(fArray[0], fArray[1], fArray4[1][0], fArray4[1][1])) - 10.0f / this.getView().getScale() : (float)Point2D.distance(fArray[0], fArray[1], fArray4[2][0], fArray4[2][1]) + 10.0f / this.getView().getScale();
            arrayList.add(this.getDimensionLineBetweenPoints(fArray, fArray8, f5, 0.0, false));
        }
        for (int i = arrayList.size() - 1; i >= 0; --i) {
            if (!(((DimensionLine)arrayList.get(i)).getLength() < 0.01f)) continue;
            arrayList.remove(i);
        }
        return arrayList;
    }

    private static float[] computeIntersection(float[] fArray, float[] fArray2, float[] fArray3, float[] fArray4) {
        return PlanController.computeIntersection(fArray[0], fArray[1], fArray2[0], fArray2[1], fArray3[0], fArray3[1], fArray4[0], fArray4[1]);
    }

    static float[] computeIntersection(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8) {
        float f9;
        float f10;
        block6: {
            float f11;
            float f12;
            block9: {
                boolean bl;
                block8: {
                    block7: {
                        f10 = f3;
                        f9 = f4;
                        f12 = (f4 - f2) / (f3 - f);
                        f11 = (f8 - f6) / (f7 - f5);
                        if (f12 == f11) break block6;
                        if (!(Math.abs(f12) > 4000.0f)) break block7;
                        if (Math.abs(f11) < 4000.0f) {
                            f10 = f;
                            float f13 = f8 - f11 * f7;
                            f9 = f11 * f10 + f13;
                        }
                        break block6;
                    }
                    if (!(Math.abs(f11) > 4000.0f)) break block8;
                    if (Math.abs(f12) < 4000.0f) {
                        f10 = f5;
                        float f14 = f4 - f12 * f3;
                        f9 = f12 * f10 + f14;
                    }
                    break block6;
                }
                boolean bl2 = bl = Math.signum(f12) == Math.signum(f11);
                if (!((double)Math.abs(f12 - f11) > 1.0E-5)) break block6;
                if (!bl) break block9;
                float f15 = Math.abs(f12) > Math.abs(f11) ? f12 / f11 : f11 / f12;
                if (!((double)f15 > 1.004)) break block6;
            }
            float f16 = f4 - f12 * f3;
            float f17 = f8 - f11 * f7;
            f10 = (f17 - f16) / (f12 - f11);
            f9 = f12 * f10 + f16;
        }
        return new float[]{f10, f9};
    }

    private HomePieceOfFurniture adjustPieceOfFurnitureElevation(HomePieceOfFurniture homePieceOfFurniture) {
        HomePieceOfFurniture homePieceOfFurniture2;
        if (!homePieceOfFurniture.isDoorOrWindow() && homePieceOfFurniture.getElevation() == 0.0f && (homePieceOfFurniture2 = this.getHighestSurroundingPieceOfFurniture(homePieceOfFurniture)) != null) {
            float f = homePieceOfFurniture2.getElevation();
            f = homePieceOfFurniture2.isHorizontallyRotated() ? (f += homePieceOfFurniture2.getHeightInPlan()) : (f += homePieceOfFurniture2.getHeight() * homePieceOfFurniture2.getDropOnTopElevation());
            if (homePieceOfFurniture2.getLevel() != null) {
                f += homePieceOfFurniture2.getLevel().getElevation() - (homePieceOfFurniture.getLevel() != null ? homePieceOfFurniture.getLevel().getElevation() : this.home.getSelectedLevel().getElevation());
            }
            homePieceOfFurniture.setElevation(Math.max(0.0f, f));
            return homePieceOfFurniture2;
        }
        return null;
    }

    private HomePieceOfFurniture adjustPieceOfFurnitureSideBySideAt(HomePieceOfFurniture homePieceOfFurniture, boolean bl, Wall wall) {
        Object object;
        Shape shape;
        float[][] fArray = homePieceOfFurniture.getPoints();
        Area area = new Area(this.getPath(fArray));
        boolean bl2 = homePieceOfFurniture instanceof HomeDoorOrWindow && ((HomeDoorOrWindow)homePieceOfFurniture).isBoundToWall();
        float f = homePieceOfFurniture.getGroundElevation();
        float f2 = 8.0f / this.getScale();
        HomePieceOfFurniture cloneable = null;
        Object object2 = null;
        float f3 = 0.0f;
        float[][] fArray2 = null;
        for (HomePieceOfFurniture cloneable2 : this.home.getFurniture()) {
            float f4;
            Object object3;
            Object object4;
            float f5 = cloneable2.getGroundElevation();
            if (cloneable2 == homePieceOfFurniture || !this.isPieceOfFurnitureVisibleAtSelectedLevel(cloneable2) || !(f < f5 + cloneable2.getHeightInPlan()) || !(f + homePieceOfFurniture.getHeightInPlan() > f5) || bl2 && !cloneable2.isDoorOrWindow()) continue;
            float[][] fArray3 = cloneable2.getPoints();
            if (bl2 && cloneable2.isDoorOrWindow()) {
                shape = new Area(this.getPath(new Wall(fArray3[1][0], fArray3[1][1], fArray3[2][0], fArray3[2][1], f2, 0.0f).getPoints()));
                ((Area)shape).add(new Area(this.getPath(new Wall(fArray3[3][0], fArray3[3][1], fArray3[0][0], fArray3[0][1], f2, 0.0f).getPoints())));
            } else {
                shape = this.furnitureSidesCache.get(cloneable2);
                if (shape == null) {
                    int n;
                    object4 = new Wall[fArray3.length];
                    for (n = 0; n < ((Object)object4).length; ++n) {
                        object4[n] = new Wall(fArray3[n][0], fArray3[n][1], fArray3[(n + 1) % ((Object)object4).length][0], fArray3[(n + 1) % ((Object)object4).length][1], f2, 0.0f);
                    }
                    for (n = 0; n < ((Object)object4).length; ++n) {
                        ((Wall)object4[(n + 1) % ((Object)object4).length]).setWallAtStart((Wall)object4[n]);
                        ((Wall)object4[n]).setWallAtEnd((Wall)object4[(n + 1) % ((Object)object4).length]);
                    }
                    object = new float[((Object)object4).length * 2 + 2][];
                    object3 = null;
                    for (int i = 0; i < ((Object)object4).length; ++i) {
                        object3 = ((Wall)object4[i]).getPoints();
                        object[i] = object3[0];
                        object[((Object)object).length - i - 1] = object3[3];
                    }
                    object[((Object)object).length / 2 - 1] = object3[1];
                    object[((Object)object).length / 2] = object3[2];
                    shape = new Area(this.getPath((float[][])object));
                    this.furnitureSidesCache.put(cloneable2, (Area)shape);
                }
            }
            object4 = new Area(shape);
            ((Area)object4).intersect(area);
            if (((Area)object4).isEmpty()) continue;
            object = new Area(area);
            ((Area)object).exclusiveOr((Area)object4);
            if (!((Area)object).isSingular()) continue;
            object3 = new Area(this.getPath(fArray3));
            object3.subtract((Area)shape);
            object3.intersect(area);
            if (!object3.isEmpty() || !((f4 = this.getArea((Area)object4)) > f3)) continue;
            f3 = f4;
            cloneable = cloneable2;
            fArray2 = fArray3;
            object2 = object4;
        }
        if (cloneable != null) {
            double d;
            double d2;
            boolean bl3;
            if (bl2 && cloneable.isDoorOrWindow()) {
                bl3 = false;
            } else {
                GeneralPath generalPath = this.getRotatedRectangle(cloneable.getX() - cloneable.getWidthInPlan(), cloneable.getY() - cloneable.getDepthInPlan(), cloneable.getWidthInPlan() * 2.0f, cloneable.getDepthInPlan() * 2.0f, cloneable.getAngle());
                float[][] fArray4 = this.getPathPoints(generalPath, false);
                bl3 = this.isAreaLargerOnFrontOrBackSide((Area)object2, fArray4);
            }
            if (bl) {
                homePieceOfFurniture.setAngle(cloneable.getAngle());
            }
            GeneralPath generalPath = this.getRotatedRectangle(0.0f, 0.0f, homePieceOfFurniture.getWidthInPlan(), homePieceOfFurniture.getDepthInPlan(), homePieceOfFurniture.getAngle() - cloneable.getAngle());
            float f6 = 0.0f;
            float f7 = 0.0f;
            if (!bl3) {
                shape = new Line2D.Float(cloneable.getX(), cloneable.getY(), (fArray2[0][0] + fArray2[1][0]) / 2.0f, (fArray2[0][1] + fArray2[1][1]) / 2.0f);
                d2 = generalPath.getBounds2D().getWidth();
                d = (double)((Line2D)shape).relativeCCW(homePieceOfFurniture.getX(), homePieceOfFurniture.getY()) * ((double)(-cloneable.getWidthInPlan() / 2.0f) + ((Line2D)shape).ptLineDist(homePieceOfFurniture.getX(), homePieceOfFurniture.getY()) - d2 / 2.0);
                f6 = (float)(d * Math.cos(cloneable.getAngle()));
                f7 = (float)(d * Math.sin(cloneable.getAngle()));
            } else {
                shape = new Line2D.Float(cloneable.getX(), cloneable.getY(), (fArray2[2][0] + fArray2[1][0]) / 2.0f, (fArray2[2][1] + fArray2[1][1]) / 2.0f);
                d2 = generalPath.getBounds2D().getHeight();
                d = (double)((Line2D)shape).relativeCCW(homePieceOfFurniture.getX(), homePieceOfFurniture.getY()) * ((double)(-cloneable.getDepthInPlan() / 2.0f) + ((Line2D)shape).ptLineDist(homePieceOfFurniture.getX(), homePieceOfFurniture.getY()) - d2 / 2.0);
                f6 = (float)(-d * Math.sin(cloneable.getAngle()));
                if (!this.isIntersectionEmpty(homePieceOfFurniture, wall, f6, f7 = (float)(d * Math.cos(cloneable.getAngle())))) {
                    f7 = 0.0f;
                    f6 = 0.0f;
                }
            }
            if (!this.isIntersectionEmpty(homePieceOfFurniture, cloneable, f6, f7)) {
                homePieceOfFurniture.move(f6, f7);
                return cloneable;
            }
            if (bl) {
                fArray = homePieceOfFurniture.getPoints();
            }
            boolean bl4 = this.isAreaLargerOnFrontOrBackSide((Area)object2, fArray);
            GeneralPath generalPath2 = this.getRotatedRectangle(0.0f, 0.0f, cloneable.getWidthInPlan(), cloneable.getDepthInPlan(), cloneable.getAngle() - homePieceOfFurniture.getAngle());
            if (!bl4) {
                object = new Line2D.Float(homePieceOfFurniture.getX(), homePieceOfFurniture.getY(), (fArray[0][0] + fArray[1][0]) / 2.0f, (fArray[0][1] + fArray[1][1]) / 2.0f);
                d = generalPath2.getBounds2D().getWidth();
                double d3 = (double)((Line2D)object).relativeCCW(cloneable.getX(), cloneable.getY()) * ((double)(-homePieceOfFurniture.getWidthInPlan() / 2.0f) + ((Line2D)object).ptLineDist(cloneable.getX(), cloneable.getY()) - d / 2.0);
                f6 = -((float)(d3 * Math.cos(homePieceOfFurniture.getAngle())));
                f7 = -((float)(d3 * Math.sin(homePieceOfFurniture.getAngle())));
            } else {
                object = new Line2D.Float(homePieceOfFurniture.getX(), homePieceOfFurniture.getY(), (fArray[2][0] + fArray[1][0]) / 2.0f, (fArray[2][1] + fArray[1][1]) / 2.0f);
                d = generalPath2.getBounds2D().getHeight();
                double d4 = (double)((Line2D)object).relativeCCW(cloneable.getX(), cloneable.getY()) * ((double)(-homePieceOfFurniture.getDepthInPlan() / 2.0f) + ((Line2D)object).ptLineDist(cloneable.getX(), cloneable.getY()) - d / 2.0);
                f6 = -((float)(-d4 * Math.sin(homePieceOfFurniture.getAngle())));
                if (!this.isIntersectionEmpty(homePieceOfFurniture, wall, f6, f7 = -((float)(d4 * Math.cos(homePieceOfFurniture.getAngle()))))) {
                    f7 = 0.0f;
                    f6 = 0.0f;
                }
            }
            if (!this.isIntersectionEmpty(homePieceOfFurniture, cloneable, f6, f7)) {
                homePieceOfFurniture.move(f6, f7);
                return cloneable;
            }
            return cloneable;
        }
        return null;
    }

    private boolean isAreaLargerOnFrontOrBackSide(Area area, float[][] fArray) {
        GeneralPath generalPath = new GeneralPath();
        generalPath.moveTo(fArray[0][0], fArray[0][1]);
        generalPath.lineTo(fArray[2][0], fArray[2][1]);
        generalPath.lineTo(fArray[3][0], fArray[3][1]);
        generalPath.lineTo(fArray[1][0], fArray[1][1]);
        generalPath.closePath();
        Area area2 = new Area(area);
        area2.intersect(new Area(generalPath));
        if (area2.isEmpty()) {
            return false;
        }
        GeneralPath generalPath2 = new GeneralPath();
        generalPath2.moveTo(fArray[0][0], fArray[0][1]);
        generalPath2.lineTo(fArray[2][0], fArray[2][1]);
        generalPath2.lineTo(fArray[1][0], fArray[1][1]);
        generalPath2.lineTo(fArray[3][0], fArray[3][1]);
        generalPath2.closePath();
        Area area3 = new Area(area);
        area3.intersect(new Area(generalPath2));
        return this.getArea(area2) > this.getArea(area3);
    }

    private float getArea(Area area) {
        float[][] fArray = this.getPathPoints(this.getPath(area), false);
        if (fArray.length > 1) {
            return new Room(fArray).getArea();
        }
        return 0.0f;
    }

    private boolean isIntersectionEmpty(HomePieceOfFurniture homePieceOfFurniture, HomePieceOfFurniture homePieceOfFurniture2, float f, float f2) {
        Area area = new Area(this.getRotatedRectangle(homePieceOfFurniture.getX() - homePieceOfFurniture.getWidthInPlan() / 2.0f + f, homePieceOfFurniture.getY() - homePieceOfFurniture.getDepthInPlan() / 2.0f + f2, homePieceOfFurniture.getWidthInPlan(), homePieceOfFurniture.getDepth(), homePieceOfFurniture.getAngle()));
        float f3 = 0.01f;
        area.intersect(new Area(this.getRotatedRectangle(homePieceOfFurniture2.getX() - homePieceOfFurniture2.getWidthInPlan() / 2.0f - f3, homePieceOfFurniture2.getY() - homePieceOfFurniture2.getDepthInPlan() / 2.0f - f3, homePieceOfFurniture2.getWidthInPlan() + 2.0f * f3, homePieceOfFurniture2.getDepthInPlan() + 2.0f * f3, homePieceOfFurniture2.getAngle())));
        return area.isEmpty();
    }

    private boolean isIntersectionEmpty(HomePieceOfFurniture homePieceOfFurniture, Wall wall, float f, float f2) {
        if (wall != null) {
            Area area = new Area(this.getPath(wall.getPoints()));
            area.intersect(new Area(this.getRotatedRectangle(homePieceOfFurniture.getX() - homePieceOfFurniture.getWidthInPlan() / 2.0f + f, homePieceOfFurniture.getY() - homePieceOfFurniture.getDepthInPlan() / 2.0f + f2, homePieceOfFurniture.getWidthInPlan(), homePieceOfFurniture.getDepthInPlan(), homePieceOfFurniture.getAngle())));
            return this.getArea(area) < 1.0E-4f;
        }
        return true;
    }

    private GeneralPath getRotatedRectangle(float f, float f2, float f3, float f4, float f5) {
        Rectangle2D.Float float_ = new Rectangle2D.Float(f, f2, f3, f4);
        AffineTransform affineTransform = AffineTransform.getRotateInstance(f5, f + f3 / 2.0f, f2 + f4 / 2.0f);
        GeneralPath generalPath = new GeneralPath();
        generalPath.append(float_.getPathIterator(affineTransform), false);
        return generalPath;
    }

    private DimensionLine getMeasuringDimensionLineAt(float f, float f2, boolean bl) {
        DimensionLine dimensionLine;
        float f3 = this.getSelectionMargin();
        for (HomePieceOfFurniture cloneable : this.home.getFurniture()) {
            if (!this.isPieceOfFurnitureVisibleAtSelectedLevel(cloneable) || (dimensionLine = this.getDimensionLineBetweenPointsAt(cloneable.getPoints(), f, f2, f3, bl)) == null) continue;
            return dimensionLine;
        }
        for (GeneralPath generalPath : this.getRoomPathsFromWalls()) {
            if (!generalPath.intersects(f - f3, f2 - f3, 2.0f * f3, 2.0f * f3) || (dimensionLine = this.getDimensionLineBetweenPointsAt(this.getPathPoints(generalPath, true), f, f2, f3, bl)) == null) continue;
            return dimensionLine;
        }
        for (Room room : this.home.getRooms()) {
            if (!this.isLevelNullOrViewable(room.getLevel()) || !room.isAtLevel(this.home.getSelectedLevel()) || (dimensionLine = this.getDimensionLineBetweenPointsAt(room.getPoints(), f, f2, f3, bl)) == null) continue;
            return dimensionLine;
        }
        return null;
    }

    private DimensionLine getDimensionLineBetweenPointsAt(float[][] fArray, float f, float f2, float f3, boolean bl) {
        for (int i = 0; i < fArray.length; ++i) {
            int n = (i + 1) % fArray.length;
            double d = Point2D.distanceSq(fArray[i][0], fArray[i][1], fArray[n][0], fArray[n][1]);
            if (!(d > 0.01) || !(Line2D.ptSegDistSq(fArray[i][0], fArray[i][1], fArray[n][0], fArray[n][1], f, f2) <= (double)(f3 * f3))) continue;
            return this.getDimensionLineBetweenPoints(fArray[i], fArray[n], 0.0f, d, bl);
        }
        return null;
    }

    private DimensionLine getDimensionLineBetweenPoints(float[] fArray, float[] fArray2, float f, boolean bl) {
        return this.getDimensionLineBetweenPoints(fArray, fArray2, f, Point2D.distanceSq(fArray[0], fArray[1], fArray2[0], fArray2[1]), bl);
    }

    private DimensionLine getDimensionLineBetweenPoints(float[] fArray, float[] fArray2, float f, double d, boolean bl) {
        float f2;
        float f3;
        float f4;
        float f5;
        boolean bl2;
        double d2 = Math.atan2(fArray[1] - fArray2[1], fArray2[0] - fArray[0]);
        boolean bl3 = bl2 = d2 <= -1.5707963267948966 || d2 > 1.5707963267948966;
        if (bl2) {
            f5 = fArray2[0];
            f4 = fArray2[1];
            f3 = fArray[0];
            f2 = fArray[1];
            f = -f;
        } else {
            f5 = fArray[0];
            f4 = fArray[1];
            f3 = fArray2[0];
            f2 = fArray2[1];
        }
        if (bl) {
            float f6 = this.preferences.getLengthUnit().getMagnetizedLength((float)Math.sqrt(d), this.getView().getPixelLength());
            if (bl2) {
                f3 = fArray2[0] - (float)((double)f6 * Math.cos(d2));
                f2 = fArray2[1] + (float)((double)f6 * Math.sin(d2));
            } else {
                f3 = fArray[0] + (float)((double)f6 * Math.cos(d2));
                f2 = fArray[1] - (float)((double)f6 * Math.sin(d2));
            }
        }
        return new DimensionLine(f5, f4, f3, f2, f);
    }

    public void addLevel() {
        this.addLevel(false);
    }

    public void addLevelAtSameElevation() {
        this.addLevel(true);
    }

    private void addLevel(boolean bl) {
        Level level;
        Level level2;
        String string;
        boolean bl2 = this.home.isAllLevelsSelection();
        List<Selectable> list = this.home.getSelectedItems();
        Selectable[] selectableArray = list.toArray(new Selectable[list.size()]);
        Level level3 = this.home.getSelectedLevel();
        BackgroundImage backgroundImage = this.home.getBackgroundImage();
        List<Level> list2 = this.home.getLevels();
        float f = this.preferences.getNewWallHeight();
        float f2 = this.preferences.getNewFloorThickness();
        if (list2.isEmpty()) {
            string = this.preferences.getLocalizedString(PlanController.class, "levelName", 0);
            level2 = this.createLevel(string, 0.0f, f2, f);
            this.moveHomeItemsToLevel(level2);
            level2.setBackgroundImage(backgroundImage);
            this.home.setBackgroundImage(null);
            list2 = this.home.getLevels();
        } else {
            level2 = null;
        }
        string = this.preferences.getLocalizedString(PlanController.class, "levelName", list2.size());
        if (bl) {
            Level level4 = level2 != null ? level2 : this.home.getSelectedLevel();
            level = this.createLevel(string, level4.getElevation(), level4.getFloorThickness(), level4.getHeight());
        } else {
            float f3 = list2.get(list2.size() - 1).getElevation() + f + f2;
            level = this.createLevel(string, f3, f2, f);
        }
        this.setSelectedLevel(level);
        this.undoSupport.postEdit(new LevelAdditionUndoableEdit(this, this.home, this.preferences, selectableArray, bl2, level3, level2, backgroundImage, level));
    }

    protected Level createLevel(String string, float f, float f2, float f3) {
        Level level = new Level(string, f, f2, f3);
        this.home.addLevel(level);
        return level;
    }

    private void moveHomeItemsToLevel(Level level) {
        for (HomePieceOfFurniture homeObject : this.home.getFurniture()) {
            homeObject.setLevel(level);
        }
        for (Wall wall : this.home.getWalls()) {
            wall.setLevel(level);
        }
        for (Room room : this.home.getRooms()) {
            room.setLevel(level);
        }
        for (Polyline polyline : this.home.getPolylines()) {
            polyline.setLevel(level);
        }
        for (DimensionLine dimensionLine : this.home.getDimensionLines()) {
            dimensionLine.setLevel(level);
        }
        for (Label label : this.home.getLabels()) {
            label.setLevel(level);
        }
    }

    public void toggleSelectedLevelViewability() {
        Level level;
        level.setViewable(!(level = this.home.getSelectedLevel()).isViewable());
        this.undoSupport.postEdit(new LevelViewabilityModificationUndoableEdit(this, this.preferences, level));
    }

    public void setSelectedLevelOnlyViewable() {
        Level[] levelArray = this.getLevels(true);
        Level level = this.home.getSelectedLevel();
        boolean bl = level.isViewable();
        if (levelArray.length != 1 || !bl) {
            PlanController.setLevelsViewability(levelArray, false);
            level.setViewable(true);
            this.undoSupport.postEdit(new LevelsViewabilityModificationUndoableEdit(this, this.preferences, level, bl, levelArray));
        }
    }

    public void setAllLevelsViewable() {
        Level[] levelArray = this.getLevels(false);
        if (levelArray.length > 0) {
            Level level = this.home.getSelectedLevel();
            PlanController.setLevelsViewability(levelArray, true);
            this.undoSupport.postEdit(new AllLevelsViewabilityModificationUndoableEdit(this, this.preferences, level, levelArray));
        }
    }

    private Level[] getLevels(boolean bl) {
        ArrayList<Level> arrayList = new ArrayList<Level>();
        for (Level level : this.home.getLevels()) {
            if (level.isViewable() != bl) continue;
            arrayList.add(level);
        }
        return arrayList.toArray(new Level[arrayList.size()]);
    }

    private static void setLevelsViewability(Level[] levelArray, boolean bl) {
        for (Level level : levelArray) {
            level.setViewable(bl);
        }
    }

    public void modifySelectedLevel() {
        if (this.home.getSelectedLevel() != null) {
            new LevelController(this.home, this.preferences, this.viewFactory, this.undoSupport).displayView(this.getView());
        }
    }

    public void deleteSelectedLevel() {
        boolean bl;
        Float f;
        Level level;
        this.undoSupport.beginUpdate();
        ArrayList<HomePieceOfFurniture> arrayList = new ArrayList<HomePieceOfFurniture>();
        Level level2 = this.home.getSelectedLevel();
        for (HomePieceOfFurniture object2 : this.home.getFurniture()) {
            if (object2.getLevel() != level2) continue;
            arrayList.add(object2);
        }
        this.deleteFurniture(arrayList);
        ArrayList arrayList2 = new ArrayList();
        this.addLevelItemsAtSelectedLevel(this.home.getWalls(), arrayList2);
        this.addLevelItemsAtSelectedLevel(this.home.getRooms(), arrayList2);
        this.addLevelItemsAtSelectedLevel(this.home.getDimensionLines(), arrayList2);
        this.addLevelItemsAtSelectedLevel(this.home.getLabels(), arrayList2);
        this.postDeleteItems(arrayList2, this.home.isBasePlanLocked(), this.home.isAllLevelsSelection());
        this.doDeleteItems(arrayList2);
        this.home.deleteLevel(level2);
        List<Level> list = this.home.getLevels();
        if (list.size() == 1) {
            level = list.get(0);
            f = Float.valueOf(level.getElevation());
            bl = level.isViewable();
            level.setElevation(0.0f);
            level.setViewable(true);
        } else {
            level = null;
            f = null;
            bl = false;
        }
        this.undoSupport.postEdit(new LevelDeletionUndoableEdit(this, this.home, this.preferences, level2, level, f, bl));
        this.undoSupport.endUpdate();
    }

    private void addLevelItemsAtSelectedLevel(Collection<? extends Selectable> collection, List<Selectable> list) {
        Level level = this.home.getSelectedLevel();
        for (Selectable selectable : collection) {
            if (!(selectable instanceof Elevatable) || ((Elevatable)((Object)selectable)).getLevel() != level) continue;
            list.add(selectable);
        }
    }

    protected Wall createWall(float f, float f2, float f3, float f4, Wall wall, Wall wall2) {
        Wall wall3 = new Wall(f, f2, f3, f4, this.preferences.getNewWallThickness(), this.preferences.getNewWallHeight(), this.preferences.getNewWallPattern());
        this.home.addWall(wall3);
        if (wall != null) {
            wall3.setWallAtStart(wall);
            wall.setWallAtStart(wall3);
        } else if (wall2 != null) {
            wall3.setWallAtStart(wall2);
            wall2.setWallAtEnd(wall3);
        }
        return wall3;
    }

    private void joinNewWallEndToWall(Wall wall, Wall wall2, Wall wall3) {
        if (wall2 != null) {
            wall.setWallAtEnd(wall2);
            wall2.setWallAtStart(wall);
            wall.setXEnd(wall2.getXStart());
            wall.setYEnd(wall2.getYStart());
        } else if (wall3 != null) {
            wall.setWallAtEnd(wall3);
            wall3.setWallAtEnd(wall);
            wall.setXEnd(wall3.getXEnd());
            wall.setYEnd(wall3.getYEnd());
        }
    }

    private Wall getWallStartAt(float f, float f2, Wall wall) {
        float f3 = 2.0f / this.getScale();
        for (Wall wall2 : this.home.getWalls()) {
            if (wall2 == wall || !this.isLevelNullOrViewable(wall2.getLevel()) || !wall2.isAtLevel(this.home.getSelectedLevel()) || wall2.getWallAtStart() != null || !wall2.containsWallStartAt(f, f2, f3)) continue;
            return wall2;
        }
        return null;
    }

    private Wall getWallEndAt(float f, float f2, Wall wall) {
        float f3 = 2.0f / this.getScale();
        for (Wall wall2 : this.home.getWalls()) {
            if (wall2 == wall || !this.isLevelNullOrViewable(wall2.getLevel()) || !wall2.isAtLevel(this.home.getSelectedLevel()) || wall2.getWallAtEnd() != null || !wall2.containsWallEndAt(f, f2, f3)) continue;
            return wall2;
        }
        return null;
    }

    private float getIndicatorMargin() {
        float f = 5.0f;
        if (this.getPointerTypeLastMousePress() == View.PointerType.TOUCH) {
            f *= 3.0f;
        }
        return f / this.getScale();
    }

    private Wall getResizedWallStartAt(float f, float f2) {
        List<Selectable> list = this.home.getSelectedItems();
        if (list.size() == 1 && list.get(0) instanceof Wall && this.isItemResizable(list.get(0))) {
            Wall wall = (Wall)list.get(0);
            float f3 = this.getIndicatorMargin();
            if (wall.isAtLevel(this.home.getSelectedLevel()) && wall.containsWallStartAt(f, f2, f3)) {
                return wall;
            }
        }
        return null;
    }

    private Wall getResizedWallEndAt(float f, float f2) {
        List<Selectable> list = this.home.getSelectedItems();
        if (list.size() == 1 && list.get(0) instanceof Wall && this.isItemResizable(list.get(0))) {
            Wall wall = (Wall)list.get(0);
            float f3 = this.getIndicatorMargin();
            if (wall.isAtLevel(this.home.getSelectedLevel()) && wall.containsWallEndAt(f, f2, f3)) {
                return wall;
            }
        }
        return null;
    }

    private Wall getArcExtentWallAt(float f, float f2) {
        List<Selectable> list = this.home.getSelectedItems();
        if (list.size() == 1 && list.get(0) instanceof Wall && this.isItemResizable(list.get(0))) {
            Wall wall = (Wall)list.get(0);
            float f3 = this.getIndicatorMargin();
            if (wall.isAtLevel(this.home.getSelectedLevel()) && wall.isMiddlePointAt(f, f2, f3)) {
                return wall;
            }
        }
        return null;
    }

    protected Room createRoom(float[][] fArray) {
        Room room = new Room(fArray);
        room.setFloorColor(this.preferences.getNewRoomFloorColor());
        this.home.addRoom(room);
        return room;
    }

    private Room getResizedRoomAt(float f, float f2) {
        List<Selectable> list = this.home.getSelectedItems();
        if (list.size() == 1 && list.get(0) instanceof Room && this.isItemResizable(list.get(0))) {
            Room room = (Room)list.get(0);
            float f3 = this.getIndicatorMargin();
            if (room.isAtLevel(this.home.getSelectedLevel()) && room.getPointIndexAt(f, f2, f3) != -1) {
                return room;
            }
        }
        return null;
    }

    private Room getRoomNameAt(float f, float f2) {
        List<Selectable> list = this.home.getSelectedItems();
        if (list.size() == 1 && list.get(0) instanceof Room && this.isItemMovable(list.get(0))) {
            Room room = (Room)list.get(0);
            float f3 = this.getIndicatorMargin();
            if (room.isAtLevel(this.home.getSelectedLevel()) && room.getName() != null && room.getName().trim().length() > 0 && room.isNameCenterPointAt(f, f2, f3)) {
                return room;
            }
        }
        return null;
    }

    private Room getRoomRotatedNameAt(float f, float f2) {
        List<Selectable> list = this.home.getSelectedItems();
        if (list.size() == 1 && list.get(0) instanceof Room && this.isItemMovable(list.get(0))) {
            Room room = (Room)list.get(0);
            float f3 = this.getIndicatorMargin();
            if (room.isAtLevel(this.home.getSelectedLevel()) && room.getName() != null && room.getName().trim().length() > 0 && this.isTextAnglePointAt(room, room.getName(), room.getNameStyle(), room.getXCenter() + room.getNameXOffset(), room.getYCenter() + room.getNameYOffset(), room.getNameAngle(), f, f2, f3)) {
                return room;
            }
        }
        return null;
    }

    private Room getRoomAreaAt(float f, float f2) {
        List<Selectable> list = this.home.getSelectedItems();
        if (list.size() == 1 && list.get(0) instanceof Room && this.isItemMovable(list.get(0))) {
            Room room = (Room)list.get(0);
            float f3 = this.getIndicatorMargin();
            if (room.isAtLevel(this.home.getSelectedLevel()) && room.isAreaVisible() && room.isAreaCenterPointAt(f, f2, f3)) {
                return room;
            }
        }
        return null;
    }

    private Room getRoomRotatedAreaAt(float f, float f2) {
        List<Selectable> list = this.home.getSelectedItems();
        if (list.size() == 1 && list.get(0) instanceof Room && this.isItemMovable(list.get(0))) {
            String string;
            float f3;
            Room room = (Room)list.get(0);
            float f4 = this.getIndicatorMargin();
            if (room.isAtLevel(this.home.getSelectedLevel()) && room.isAreaVisible() && (f3 = room.getArea()) > 0.01f && this.isTextAnglePointAt(room, string = this.preferences.getLengthUnit().getAreaFormatWithUnit().format(Float.valueOf(f3)), room.getAreaStyle(), room.getXCenter() + room.getAreaXOffset(), room.getYCenter() + room.getAreaYOffset(), room.getAreaAngle(), f, f2, f4)) {
                return room;
            }
        }
        return null;
    }

    public void addPointToSelectedRoom(float f, float f2) {
        List<Selectable> list = this.home.getSelectedItems();
        if (list.size() == 1 && list.get(0) instanceof Room && this.isItemResizable(list.get(0))) {
            int n;
            Room room = (Room)list.get(0);
            float[][] fArray = room.getPoints();
            int n2 = -1;
            double d = Double.MAX_VALUE;
            for (n = 0; n < fArray.length; ++n) {
                float[] fArray2 = fArray[n];
                float[] fArray3 = fArray[(n + 1) % fArray.length];
                double d2 = Line2D.ptSegDistSq(fArray2[0], fArray2[1], fArray3[0], fArray3[1], f, f2);
                if (!(d > d2)) continue;
                d = d2;
                n2 = n;
            }
            n = n2 + 1;
            room.addPoint(f, f2, n);
            this.home.setSelectedItems(Arrays.asList(room));
            this.undoSupport.postEdit(new RoomPointAdditionUndoableEdit(this, this.preferences, list.toArray(new Selectable[list.size()]), room, n, f, f2));
        }
    }

    public boolean isRoomPointDeletableAt(Room room, float f, float f2) {
        return this.isItemResizable(room) && room.getPointIndexAt(f, f2, this.getIndicatorMargin()) >= 0;
    }

    public void deletePointFromSelectedRoom(float f, float f2) {
        Room room;
        int n;
        List<Selectable> list = this.home.getSelectedItems();
        if (list.size() == 1 && list.get(0) instanceof Room && this.isItemResizable(list.get(0)) && (n = (room = (Room)list.get(0)).getPointIndexAt(f, f2, this.getIndicatorMargin())) >= 0) {
            float[][] fArray = room.getPoints();
            float[] fArray2 = fArray[n];
            float f3 = fArray2[0];
            float f4 = fArray2[1];
            room.removePoint(n);
            this.home.setSelectedItems(Arrays.asList(room));
            this.undoSupport.postEdit(new RoomPointDeletionUndoableEdit(this, this.preferences, list.toArray(new Selectable[list.size()]), room, n, f3, f4));
        }
    }

    protected DimensionLine createDimensionLine(float f, float f2, float f3, float f4, float f5) {
        DimensionLine dimensionLine = new DimensionLine(f, f2, f3, f4, f5);
        this.home.addDimensionLine(dimensionLine);
        return dimensionLine;
    }

    private DimensionLine getResizedDimensionLineStartAt(float f, float f2) {
        List<Selectable> list = this.home.getSelectedItems();
        if (list.size() == 1 && list.get(0) instanceof DimensionLine && this.isItemResizable(list.get(0))) {
            DimensionLine dimensionLine = (DimensionLine)list.get(0);
            float f3 = this.getIndicatorMargin();
            if (dimensionLine.isAtLevel(this.home.getSelectedLevel()) && dimensionLine.containsStartExtensionLinetAt(f, f2, f3)) {
                return dimensionLine;
            }
        }
        return null;
    }

    private DimensionLine getResizedDimensionLineEndAt(float f, float f2) {
        List<Selectable> list = this.home.getSelectedItems();
        if (list.size() == 1 && list.get(0) instanceof DimensionLine && this.isItemResizable(list.get(0))) {
            DimensionLine dimensionLine = (DimensionLine)list.get(0);
            float f3 = this.getIndicatorMargin();
            if (dimensionLine.isAtLevel(this.home.getSelectedLevel()) && dimensionLine.containsEndExtensionLineAt(f, f2, f3)) {
                return dimensionLine;
            }
        }
        return null;
    }

    private DimensionLine getOffsetDimensionLineAt(float f, float f2) {
        List<Selectable> list = this.home.getSelectedItems();
        if (list.size() == 1 && list.get(0) instanceof DimensionLine && this.isItemResizable(list.get(0))) {
            DimensionLine dimensionLine = (DimensionLine)list.get(0);
            float f3 = this.getIndicatorMargin();
            if (dimensionLine.isAtLevel(this.home.getSelectedLevel()) && dimensionLine.isMiddlePointAt(f, f2, f3)) {
                return dimensionLine;
            }
        }
        return null;
    }

    private Polyline createPolyline(float[][] fArray) {
        Polyline polyline = new Polyline(fArray);
        LengthUnit lengthUnit = this.preferences.getLengthUnit();
        polyline.setThickness(lengthUnit.isMetric() ? 2.0f : LengthUnit.inchToCentimeter(1.0f));
        this.home.addPolyline(polyline);
        return polyline;
    }

    private Polyline getResizedPolylineAt(float f, float f2) {
        List<Selectable> list = this.home.getSelectedItems();
        if (list.size() == 1 && list.get(0) instanceof Polyline && this.isItemResizable(list.get(0))) {
            Polyline polyline = (Polyline)list.get(0);
            float f3 = this.getIndicatorMargin();
            if (polyline.isAtLevel(this.home.getSelectedLevel()) && polyline.getPointIndexAt(f, f2, f3) != -1) {
                return polyline;
            }
        }
        return null;
    }

    private float getSelectionMargin() {
        float f = 4.0f;
        if (this.getPointerTypeLastMousePress() == View.PointerType.TOUCH) {
            f *= 2.0f;
        }
        return f / this.getScale();
    }

    private boolean isItemSelectedAt(float f, float f2) {
        float f3 = this.getSelectionMargin();
        for (Selectable selectable : this.home.getSelectedItems()) {
            if (!selectable.containsPoint(f, f2, f3)) continue;
            return true;
        }
        return false;
    }

    public Selectable getSelectableItemAt(float f, float f2) {
        return this.getSelectableItemAt(f, f2, true);
    }

    private Selectable getSelectableItemAt(float f, float f2, boolean bl) {
        List<Selectable> list = this.getSelectableItemsAt(f, f2, true, bl);
        if (list.size() != 0) {
            return list.get(0);
        }
        return null;
    }

    public List<Selectable> getSelectableItemsAt(float f, float f2) {
        return this.getSelectableItemsAt(f, f2, false, true);
    }

    /*
     * WARNING - void declaration
     */
    private List<Selectable> getSelectableItemsAt(float f, float f2, boolean bl, boolean bl2) {
        void var16_32;
        void var17_44;
        Cloneable cloneable;
        void var12_16;
        ArrayList<Selectable> arrayList = new ArrayList<Selectable>();
        float f3 = this.getSelectionMargin();
        float f4 = f3 / 2.0f;
        ObserverCamera observerCamera = this.home.getObserverCamera();
        if (observerCamera != null && observerCamera == this.home.getCamera() && observerCamera.containsPoint(f, f2, f3)) {
            arrayList.add(observerCamera);
            if (bl) {
                return arrayList;
            }
        }
        boolean bl3 = this.home.isBasePlanLocked();
        Level level = this.home.getSelectedLevel();
        for (Label homeObject : this.home.getLabels()) {
            if (bl3 && this.isItemPartOfBasePlan(homeObject) || !this.isLevelNullOrViewable(homeObject.getLevel()) || !homeObject.isAtLevel(level) || !homeObject.containsPoint(f, f2, f3) && !this.isItemTextAt(homeObject, homeObject.getText(), homeObject.getStyle(), homeObject.getX(), homeObject.getY(), homeObject.getAngle(), f, f2, f4)) continue;
            arrayList.add(homeObject);
            if (!bl) continue;
            return arrayList;
        }
        for (DimensionLine list2 : this.home.getDimensionLines()) {
            if (bl3 && this.isItemPartOfBasePlan(list2) || !this.isLevelNullOrViewable(list2.getLevel()) || !list2.isAtLevel(level) || !list2.containsPoint(f, f2, f3)) continue;
            arrayList.add(list2);
            if (!bl) continue;
            return arrayList;
        }
        List<Polyline> list = this.home.getPolylines();
        int n = list.size() - 1;
        while (var12_16 >= 0) {
            cloneable = (Polyline)list.get((int)var12_16);
            if ((!bl3 || !this.isItemPartOfBasePlan((Selectable)cloneable)) && this.isLevelNullOrViewable(((Polyline)cloneable).getLevel()) && ((Polyline)cloneable).isAtLevel(level) && ((Polyline)cloneable).containsPoint(f, f2, f3)) {
                arrayList.add((Selectable)cloneable);
                if (bl) {
                    return arrayList;
                }
            }
            --var12_16;
        }
        List<HomePieceOfFurniture> list2 = this.home.getFurniture();
        cloneable = new ArrayList();
        HomePieceOfFurniture homePieceOfFurniture = null;
        for (int list5 = list2.size() - 1; list5 >= 0; --list5) {
            String string;
            HomePieceOfFurniture homePieceOfFurniture2 = list2.get(list5);
            if (bl3 && this.isItemPartOfBasePlan(homePieceOfFurniture2) || !this.isPieceOfFurnitureVisibleAtSelectedLevel(homePieceOfFurniture2)) continue;
            if (homePieceOfFurniture2.containsPoint(f, f2, f3)) {
                cloneable.add(homePieceOfFurniture2);
                if (homePieceOfFurniture != null && !(homePieceOfFurniture2.getGroundElevation() > homePieceOfFurniture.getGroundElevation())) continue;
                homePieceOfFurniture = homePieceOfFurniture2;
                continue;
            }
            if (homePieceOfFurniture != null || (string = homePieceOfFurniture2.getName()) == null || !homePieceOfFurniture2.isNameVisible() || !this.isItemTextAt(homePieceOfFurniture2, string, homePieceOfFurniture2.getNameStyle(), homePieceOfFurniture2.getX() + homePieceOfFurniture2.getNameXOffset(), homePieceOfFurniture2.getY() + homePieceOfFurniture2.getNameYOffset(), homePieceOfFurniture2.getNameAngle(), f, f2, f4)) continue;
            cloneable.add(homePieceOfFurniture2);
            homePieceOfFurniture = homePieceOfFurniture2;
        }
        if (homePieceOfFurniture == null && bl3) {
            for (Selectable selectable : this.home.getSelectedItems()) {
                HomePieceOfFurniture homePieceOfFurniture3;
                if (!(selectable instanceof HomePieceOfFurniture) || this.isItemPartOfBasePlan(homePieceOfFurniture3 = (HomePieceOfFurniture)selectable) || !this.isPieceOfFurnitureVisibleAtSelectedLevel(homePieceOfFurniture3) || !homePieceOfFurniture3.containsPoint(f, f2, f3) && (homePieceOfFurniture3.getName() == null || !homePieceOfFurniture3.isNameVisible() || !this.isItemTextAt(homePieceOfFurniture3, homePieceOfFurniture3.getName(), homePieceOfFurniture3.getNameStyle(), homePieceOfFurniture3.getX() + homePieceOfFurniture3.getNameXOffset(), homePieceOfFurniture3.getY() + homePieceOfFurniture3.getNameYOffset(), homePieceOfFurniture3.getNameAngle(), f, f2, f4))) continue;
                cloneable.add(homePieceOfFurniture3);
                homePieceOfFurniture = homePieceOfFurniture3;
                if (!bl) continue;
                break;
            }
        }
        if (homePieceOfFurniture != null && bl) {
            List<Selectable> list3;
            if (!bl2 && homePieceOfFurniture instanceof HomeFurnitureGroup && (list3 = this.home.getSelectedItems()).size() >= 1 && (list3.size() == 1 && list3.get(0) == homePieceOfFurniture || ((HomeFurnitureGroup)homePieceOfFurniture).getAllFurniture().containsAll(list3))) {
                HomePieceOfFurniture homePieceOfFurniture4;
                int n2;
                List<HomePieceOfFurniture> list4;
                for (Selectable selectable : list3) {
                    if (!(selectable instanceof HomeFurnitureGroup)) continue;
                    list4 = ((HomeFurnitureGroup)selectable).getFurniture();
                    for (n2 = list4.size() - 1; n2 >= 0; --n2) {
                        homePieceOfFurniture4 = list4.get(n2);
                        if (bl3 && this.isItemPartOfBasePlan(homePieceOfFurniture4) || list3.contains(homePieceOfFurniture4) || !homePieceOfFurniture4.containsPoint(f, f2, f3)) continue;
                        return Arrays.asList(homePieceOfFurniture4);
                    }
                }
                for (Selectable selectable : list3) {
                    if (!(selectable instanceof HomePieceOfFurniture)) continue;
                    list4 = this.getFurnitureInSameGroup((HomePieceOfFurniture)selectable);
                    for (n2 = list4.size() - 1; n2 >= 0; --n2) {
                        homePieceOfFurniture4 = list4.get(n2);
                        if (bl3 && this.isItemPartOfBasePlan(homePieceOfFurniture4) || !homePieceOfFurniture4.containsPoint(f, f2, f3)) continue;
                        return Arrays.asList(homePieceOfFurniture4);
                    }
                }
            }
            return Arrays.asList(homePieceOfFurniture);
        }
        Collections.sort(cloneable, new Comparator<HomePieceOfFurniture>(){

            @Override
            public int compare(HomePieceOfFurniture homePieceOfFurniture, HomePieceOfFurniture homePieceOfFurniture2) {
                return -Float.compare(homePieceOfFurniture.getGroundElevation(), homePieceOfFurniture2.getGroundElevation());
            }
        });
        arrayList.addAll((Collection<Selectable>)((Object)cloneable));
        for (Wall wall : this.home.getWalls()) {
            if (bl3 && this.isItemPartOfBasePlan(wall) || !this.isLevelNullOrViewable(wall.getLevel()) || !wall.isAtLevel(level) || !wall.containsPoint(f, f2, f3)) continue;
            arrayList.add(wall);
            if (!bl) continue;
            return arrayList;
        }
        List<Room> list5 = this.home.getRooms();
        Object var16_31 = null;
        int n3 = list5.size() - 1;
        while (var17_44 >= 0) {
            Room room = (Room)list5.get((int)var17_44);
            if ((!bl3 || !this.isItemPartOfBasePlan(room)) && this.isLevelNullOrViewable(room.getLevel()) && room.isAtLevel(level)) {
                if (room.containsPoint(f, f2, f3)) {
                    arrayList.add(room);
                    if (var16_32 == null || room.isCeilingVisible() && !var16_32.isCeilingVisible()) {
                        Room room2 = room;
                    }
                } else {
                    String string;
                    String string2 = room.getName();
                    if (string2 != null && this.isItemTextAt(room, string2, room.getNameStyle(), room.getXCenter() + room.getNameXOffset(), room.getYCenter() + room.getNameYOffset(), room.getNameAngle(), f, f2, f4)) {
                        arrayList.add(room);
                        Room room3 = room;
                    }
                    if (room.isAreaVisible() && this.isItemTextAt(room, string = this.preferences.getLengthUnit().getAreaFormatWithUnit().format(Float.valueOf(room.getArea())), room.getAreaStyle(), room.getXCenter() + room.getAreaXOffset(), room.getYCenter() + room.getAreaYOffset(), room.getAreaAngle(), f, f2, f4)) {
                        arrayList.add(room);
                        Room room4 = room;
                    }
                }
            }
            --var17_44;
        }
        if (var16_32 != null && bl) {
            return Arrays.asList(var16_32);
        }
        Compass compass = this.home.getCompass();
        if (!(bl3 && this.isItemPartOfBasePlan(compass) || !compass.containsPoint(f, f2, f4))) {
            arrayList.add(compass);
        }
        return arrayList;
    }

    private boolean isItemTextAt(Selectable selectable, String string, TextStyle textStyle, float f, float f2, float f3, float f4, float f5, float f6) {
        if (textStyle == null) {
            textStyle = this.preferences.getDefaultTextStyle(selectable.getClass());
        }
        float[][] fArray = this.getView().getTextBounds(string, textStyle, f, f2, f3);
        return this.getPath(fArray).intersects(f4 - f6, f5 - f6, 2.0f * f6, 2.0f * f6);
    }

    protected List<Selectable> getSelectableItemsIntersectingRectangle(float f, float f2, float f3, float f4) {
        ArrayList<Selectable> arrayList = new ArrayList<Selectable>();
        boolean bl = this.home.isBasePlanLocked();
        for (Selectable selectable : this.getVisibleItemsAtSelectedLevel()) {
            if (bl && this.isItemPartOfBasePlan(selectable) || !selectable.intersectsRectangle(f, f2, f3, f4)) continue;
            arrayList.add(selectable);
        }
        ObserverCamera observerCamera = this.home.getObserverCamera();
        if (observerCamera != null && observerCamera.intersectsRectangle(f, f2, f3, f4)) {
            arrayList.add(observerCamera);
        }
        return arrayList;
    }

    private HomePieceOfFurniture getRotatedPieceOfFurnitureAt(float f, float f2) {
        float f3;
        HomePieceOfFurniture homePieceOfFurniture = this.getSelectedMovablePieceOfFurniture();
        if (homePieceOfFurniture != null && homePieceOfFurniture.isTopLeftPointAt(f, f2, f3 = this.getIndicatorMargin()) && !homePieceOfFurniture.containsPoint(f, f2, 0.0f)) {
            return homePieceOfFurniture;
        }
        return null;
    }

    private HomePieceOfFurniture getElevatedPieceOfFurnitureAt(float f, float f2) {
        float f3;
        HomePieceOfFurniture homePieceOfFurniture = this.getSelectedMovablePieceOfFurniture();
        if (homePieceOfFurniture != null && homePieceOfFurniture.isTopRightPointAt(f, f2, f3 = this.getIndicatorMargin()) && !homePieceOfFurniture.containsPoint(f, f2, 0.0f)) {
            return homePieceOfFurniture;
        }
        return null;
    }

    private HomePieceOfFurniture getHeightResizedPieceOfFurnitureAt(float f, float f2) {
        HomePieceOfFurniture homePieceOfFurniture = this.getSelectedResizablePieceOfFurniture();
        if (homePieceOfFurniture != null) {
            float f3 = this.getIndicatorMargin();
            if (!homePieceOfFurniture.isHorizontallyRotated() && homePieceOfFurniture.isBottomLeftPointAt(f, f2, f3) && !homePieceOfFurniture.containsPoint(f, f2, 0.0f)) {
                return homePieceOfFurniture;
            }
        }
        return null;
    }

    private HomePieceOfFurniture getPitchRotatedPieceOfFurnitureAt(float f, float f2) {
        HomePieceOfFurniture homePieceOfFurniture = this.getSelectedMovablePieceOfFurniture();
        if (homePieceOfFurniture != null && this.getView().isFurnitureSizeInPlanSupported()) {
            float f3 = this.getIndicatorMargin();
            if (homePieceOfFurniture.getPitch() != 0.0f && homePieceOfFurniture.isBottomLeftPointAt(f, f2, f3) && !homePieceOfFurniture.containsPoint(f, f2, 0.0f)) {
                return homePieceOfFurniture;
            }
        }
        return null;
    }

    private HomePieceOfFurniture getRollRotatedPieceOfFurnitureAt(float f, float f2) {
        HomePieceOfFurniture homePieceOfFurniture = this.getSelectedMovablePieceOfFurniture();
        if (homePieceOfFurniture != null && this.getView().isFurnitureSizeInPlanSupported()) {
            float f3 = this.getIndicatorMargin();
            if (homePieceOfFurniture.getRoll() != 0.0f && homePieceOfFurniture.isBottomLeftPointAt(f, f2, f3) && !homePieceOfFurniture.containsPoint(f, f2, 0.0f)) {
                return homePieceOfFurniture;
            }
        }
        return null;
    }

    private HomePieceOfFurniture getWidthAndDepthResizedPieceOfFurnitureAt(float f, float f2) {
        float f3;
        HomePieceOfFurniture homePieceOfFurniture = this.getSelectedResizablePieceOfFurniture();
        if (homePieceOfFurniture != null && homePieceOfFurniture.isBottomRightPointAt(f, f2, f3 = this.getIndicatorMargin()) && !homePieceOfFurniture.containsPoint(f, f2, 0.0f)) {
            return homePieceOfFurniture;
        }
        return null;
    }

    private HomePieceOfFurniture getSelectedMovablePieceOfFurniture() {
        HomePieceOfFurniture homePieceOfFurniture = this.getSelectedPieceOfFurniture();
        if (homePieceOfFurniture != null && this.isItemMovable(homePieceOfFurniture)) {
            return homePieceOfFurniture;
        }
        return null;
    }

    private HomePieceOfFurniture getSelectedResizablePieceOfFurniture() {
        HomePieceOfFurniture homePieceOfFurniture = this.getSelectedPieceOfFurniture();
        if (homePieceOfFurniture != null && homePieceOfFurniture.isResizable() && this.isItemResizable(homePieceOfFurniture)) {
            return homePieceOfFurniture;
        }
        return null;
    }

    private HomePieceOfFurniture getSelectedPieceOfFurniture() {
        HomePieceOfFurniture homePieceOfFurniture;
        List<Selectable> list = this.home.getSelectedItems();
        if (list.size() == 1 && list.get(0) instanceof HomePieceOfFurniture && this.isPieceOfFurnitureVisibleAtSelectedLevel(homePieceOfFurniture = (HomePieceOfFurniture)list.get(0))) {
            return homePieceOfFurniture;
        }
        return null;
    }

    private HomeLight getModifiedLightPowerAt(float f, float f2) {
        float f3;
        HomePieceOfFurniture homePieceOfFurniture = this.getSelectedPieceOfFurniture();
        if (homePieceOfFurniture instanceof HomeLight && homePieceOfFurniture.isBottomLeftPointAt(f, f2, f3 = this.getIndicatorMargin()) && !homePieceOfFurniture.containsPoint(f, f2, 0.0f)) {
            return (HomeLight)homePieceOfFurniture;
        }
        return null;
    }

    private HomePieceOfFurniture getPieceOfFurnitureNameAt(float f, float f2) {
        HomePieceOfFurniture homePieceOfFurniture = this.getSelectedMovablePieceOfFurniture();
        if (homePieceOfFurniture != null) {
            float f3 = this.getIndicatorMargin();
            if (homePieceOfFurniture.isNameVisible() && homePieceOfFurniture.getName().trim().length() > 0 && homePieceOfFurniture.isNameCenterPointAt(f, f2, f3)) {
                return homePieceOfFurniture;
            }
        }
        return null;
    }

    private HomePieceOfFurniture getPieceOfFurnitureRotatedNameAt(float f, float f2) {
        HomePieceOfFurniture homePieceOfFurniture = this.getSelectedMovablePieceOfFurniture();
        if (homePieceOfFurniture != null) {
            float f3 = this.getIndicatorMargin();
            if (homePieceOfFurniture.isNameVisible() && homePieceOfFurniture.getName().trim().length() > 0 && this.isTextAnglePointAt(homePieceOfFurniture, homePieceOfFurniture.getName(), homePieceOfFurniture.getNameStyle(), homePieceOfFurniture.getX() + homePieceOfFurniture.getNameXOffset(), homePieceOfFurniture.getY() + homePieceOfFurniture.getNameYOffset(), homePieceOfFurniture.getNameAngle(), f, f2, f3)) {
                return homePieceOfFurniture;
            }
        }
        return null;
    }

    private boolean isTextAnglePointAt(Selectable selectable, String string, TextStyle textStyle, float f, float f2, float f3, float f4, float f5, float f6) {
        float f7;
        float f8;
        if (textStyle == null) {
            textStyle = this.preferences.getDefaultTextStyle(selectable.getClass());
        }
        float[][] fArray = this.getView().getTextBounds(string, textStyle, f, f2, f3);
        if (textStyle.getAlignment() == TextStyle.Alignment.LEFT) {
            f8 = fArray[0][0];
            f7 = fArray[0][1];
        } else if (textStyle.getAlignment() == TextStyle.Alignment.RIGHT) {
            f8 = fArray[1][0];
            f7 = fArray[1][1];
        } else {
            f8 = (fArray[0][0] + fArray[1][0]) / 2.0f;
            f7 = (fArray[0][1] + fArray[1][1]) / 2.0f;
        }
        return Math.abs(f4 - f8) <= f6 && Math.abs(f5 - f7) <= f6;
    }

    private Label getRotatedLabelAt(float f, float f2) {
        List<Selectable> list = this.home.getSelectedItems();
        if (list.size() == 1 && list.get(0) instanceof Label && this.isItemMovable(list.get(0))) {
            Label label = (Label)list.get(0);
            float f3 = this.getIndicatorMargin();
            if (label.isAtLevel(this.home.getSelectedLevel()) && this.isTextAnglePointAt(label, label.getText(), label.getStyle(), label.getX(), label.getY(), label.getAngle(), f, f2, f3)) {
                return label;
            }
        }
        return null;
    }

    private Label getElevatedLabelAt(float f, float f2) {
        Label label;
        List<Selectable> list = this.home.getSelectedItems();
        if (list.size() == 1 && list.get(0) instanceof Label && (label = (Label)list.get(0)).getPitch() != null && this.isItemMovable(label)) {
            float f3 = this.getIndicatorMargin();
            if (label.isAtLevel(this.home.getSelectedLevel())) {
                float f4;
                float f5;
                TextStyle textStyle = label.getStyle();
                if (textStyle == null) {
                    textStyle = this.preferences.getDefaultTextStyle(label.getClass());
                }
                float[][] fArray = this.getView().getTextBounds(label.getText(), this.getItemTextStyle(label, label.getStyle()), label.getX(), label.getY(), label.getAngle());
                if (textStyle.getAlignment() == TextStyle.Alignment.LEFT) {
                    f5 = fArray[3][0];
                    f4 = fArray[3][1];
                } else if (textStyle.getAlignment() == TextStyle.Alignment.RIGHT) {
                    f5 = fArray[2][0];
                    f4 = fArray[2][1];
                } else {
                    f5 = (fArray[2][0] + fArray[3][0]) / 2.0f;
                    f4 = (fArray[2][1] + fArray[3][1]) / 2.0f;
                }
                if (Math.abs(f - f5) <= f3 && Math.abs(f2 - f4) <= f3) {
                    return label;
                }
            }
        }
        return null;
    }

    private Camera getYawRotatedCameraAt(float f, float f2) {
        List<Selectable> list = this.home.getSelectedItems();
        if (list.size() == 1 && list.get(0) instanceof Camera && this.isItemResizable(list.get(0))) {
            ObserverCamera observerCamera = (ObserverCamera)list.get(0);
            float f3 = this.getIndicatorMargin();
            float[][] fArray = observerCamera.getPoints();
            float f4 = (fArray[0][0] + fArray[3][0]) / 2.0f;
            float f5 = (fArray[0][1] + fArray[3][1]) / 2.0f;
            if (Math.abs(f - f4) <= f3 && Math.abs(f2 - f5) <= f3 && !observerCamera.containsPoint(f, f2, 0.0f)) {
                return observerCamera;
            }
        }
        return null;
    }

    private Camera getPitchRotatedCameraAt(float f, float f2) {
        List<Selectable> list = this.home.getSelectedItems();
        if (list.size() == 1 && list.get(0) instanceof Camera && this.isItemResizable(list.get(0))) {
            ObserverCamera observerCamera = (ObserverCamera)list.get(0);
            float f3 = this.getIndicatorMargin();
            float[][] fArray = observerCamera.getPoints();
            float f4 = (fArray[1][0] + fArray[2][0]) / 2.0f;
            float f5 = (fArray[1][1] + fArray[2][1]) / 2.0f;
            if (Math.abs(f - f4) <= f3 && Math.abs(f2 - f5) <= f3 && !observerCamera.containsPoint(f, f2, 0.0f)) {
                return observerCamera;
            }
        }
        return null;
    }

    private Camera getElevatedCameraAt(float f, float f2) {
        List<Selectable> list = this.home.getSelectedItems();
        if (list.size() == 1 && list.get(0) instanceof Camera && this.isItemResizable(list.get(0))) {
            ObserverCamera observerCamera = (ObserverCamera)list.get(0);
            float f3 = this.getIndicatorMargin();
            float[][] fArray = observerCamera.getPoints();
            float f4 = (fArray[0][0] + fArray[1][0]) / 2.0f;
            float f5 = (fArray[0][1] + fArray[1][1]) / 2.0f;
            if (Math.abs(f - f4) <= f3 && Math.abs(f2 - f5) <= f3 && !observerCamera.containsPoint(f, f2, 0.0f)) {
                return observerCamera;
            }
        }
        return null;
    }

    private Compass getRotatedCompassAt(float f, float f2) {
        List<Selectable> list = this.home.getSelectedItems();
        if (list.size() == 1 && list.get(0) instanceof Compass && this.isItemMovable(list.get(0))) {
            Compass compass = (Compass)list.get(0);
            float f3 = this.getIndicatorMargin();
            float[][] fArray = compass.getPoints();
            float f4 = (fArray[2][0] + fArray[3][0]) / 2.0f;
            float f5 = (fArray[2][1] + fArray[3][1]) / 2.0f;
            if (Math.abs(f - f4) <= f3 && Math.abs(f2 - f5) <= f3 && !compass.containsPoint(f, f2, 0.0f)) {
                return compass;
            }
        }
        return null;
    }

    private Compass getResizedCompassAt(float f, float f2) {
        List<Selectable> list = this.home.getSelectedItems();
        if (list.size() == 1 && list.get(0) instanceof Compass && this.isItemMovable(list.get(0))) {
            Compass compass = (Compass)list.get(0);
            float f3 = this.getIndicatorMargin();
            float[][] fArray = compass.getPoints();
            float f4 = (fArray[1][0] + fArray[2][0]) / 2.0f;
            float f5 = (fArray[1][1] + fArray[2][1]) / 2.0f;
            if (Math.abs(f - f4) <= f3 && Math.abs(f2 - f5) <= f3 && !compass.containsPoint(f, f2, 0.0f)) {
                return compass;
            }
        }
        return null;
    }

    public void deleteItems(List<? extends Selectable> list) {
        ArrayList<Selectable> arrayList = new ArrayList<Selectable>(list.size());
        for (Selectable cloneable : list) {
            if (!this.isItemDeletable(cloneable)) continue;
            arrayList.add(cloneable);
        }
        if (!arrayList.isEmpty()) {
            this.undoSupport.beginUpdate();
            this.home.removeSelectionListener(this.selectionListener);
            boolean bl = this.home.isAllLevelsSelection();
            ArrayList<? extends Selectable> arrayList2 = new ArrayList<Selectable>(list);
            this.undoSupport.postEdit(new ItemsDeletionStartUndoableEdit(this, this.home, bl, arrayList2.toArray(new Selectable[arrayList2.size()])));
            this.deleteFurniture(Home.getFurnitureSubList(arrayList));
            ArrayList<Selectable> arrayList3 = new ArrayList<Selectable>(Home.getWallsSubList(arrayList));
            arrayList3.addAll(Home.getRoomsSubList(arrayList));
            arrayList3.addAll(Home.getDimensionLinesSubList(arrayList));
            arrayList3.addAll(Home.getPolylinesSubList(arrayList));
            arrayList3.addAll(Home.getLabelsSubList(arrayList));
            this.postDeleteItems(arrayList3, this.home.isBasePlanLocked(), this.home.isAllLevelsSelection());
            this.doDeleteItems(arrayList3);
            this.home.addSelectionListener(this.selectionListener);
            this.undoSupport.postEdit(new ItemsDeletionEndUndoableEdit(this, this.home));
            this.undoSupport.endUpdate();
        }
    }

    private void postDeleteItems(List<? extends Selectable> list, boolean bl, boolean bl2) {
        List<Wall> list2 = Home.getWallsSubList(list);
        JoinedWall[] joinedWallArray = JoinedWall.getJoinedWalls(list2);
        List<Room> list3 = Home.getRoomsSubList(list);
        List<Room> list4 = this.home.getRooms();
        TreeMap<Integer, Room> treeMap = new TreeMap<Integer, Room>();
        for (Room object22 : list3) {
            treeMap.put(list4.indexOf(object22), object22);
        }
        Room[] roomArray = treeMap.values().toArray(new Room[treeMap.size()]);
        int[] nArray = new int[roomArray.length];
        Level[] levelArray = new Level[roomArray.length];
        int n = 0;
        Object object = treeMap.keySet().iterator();
        while (object.hasNext()) {
            int dimensionLineArray;
            nArray[n] = dimensionLineArray = ((Integer)object.next()).intValue();
            levelArray[n] = roomArray[n].getLevel();
            ++n;
        }
        object = Home.getDimensionLinesSubList(list);
        DimensionLine[] dimensionLineArray = object.toArray(new DimensionLine[object.size()]);
        Level[] levelArray2 = new Level[dimensionLineArray.length];
        for (n = 0; n < dimensionLineArray.length; ++n) {
            levelArray2[n] = dimensionLineArray[n].getLevel();
        }
        List<Polyline> list5 = Home.getPolylinesSubList(list);
        List<Polyline> list6 = this.home.getPolylines();
        TreeMap<Integer, Polyline> treeMap2 = new TreeMap<Integer, Polyline>();
        for (Polyline polyline : list5) {
            treeMap2.put(list6.indexOf(polyline), polyline);
        }
        Polyline[] polylineArray = treeMap2.values().toArray(new Polyline[treeMap2.size()]);
        int[] nArray2 = new int[polylineArray.length];
        Level[] levelArray3 = new Level[polylineArray.length];
        n = 0;
        Object object2 = treeMap2.keySet().iterator();
        while (object2.hasNext()) {
            int n2;
            nArray2[n] = n2 = ((Integer)object2.next()).intValue();
            levelArray3[n] = polylineArray[n].getLevel();
            ++n;
        }
        object2 = Home.getLabelsSubList(list);
        Label[] labelArray = object2.toArray(new Label[object2.size()]);
        Level[] levelArray4 = new Level[labelArray.length];
        for (n = 0; n < labelArray.length; ++n) {
            levelArray4[n] = labelArray[n].getLevel();
        }
        this.undoSupport.postEdit(new ItemsDeletionUndoableEdit(this, this.preferences, bl, bl2, list.toArray(new Selectable[list.size()]), joinedWallArray, roomArray, nArray, levelArray, dimensionLineArray, levelArray2, polylineArray, nArray2, levelArray3, labelArray, levelArray4));
    }

    private void doDeleteItems(List<Selectable> list) {
        boolean bl = this.home.isBasePlanLocked();
        for (Selectable selectable : list) {
            if (selectable instanceof Wall) {
                this.home.deleteWall((Wall)selectable);
            } else if (selectable instanceof DimensionLine) {
                this.home.deleteDimensionLine((DimensionLine)selectable);
            } else if (selectable instanceof Room) {
                this.home.deleteRoom((Room)selectable);
            } else if (selectable instanceof Polyline) {
                this.home.deletePolyline((Polyline)selectable);
            } else if (selectable instanceof Label) {
                this.home.deleteLabel((Label)selectable);
            } else if (selectable instanceof HomePieceOfFurniture) {
                this.home.deletePieceOfFurniture((HomePieceOfFurniture)selectable);
            }
            bl &= !this.isItemPartOfBasePlan(selectable);
        }
        this.home.setBasePlanLocked(bl);
        this.home.setAllLevelsSelection(false);
    }

    private void moveAndShowSelectedItems(float f, float f2) {
        List<Selectable> list = this.home.getSelectedItems();
        ArrayList<Selectable> arrayList = new ArrayList<Selectable>(list.size());
        for (Selectable selectable : list) {
            if (!this.isItemMovable(selectable)) continue;
            arrayList.add(selectable);
        }
        if (!arrayList.isEmpty()) {
            this.moveItems(arrayList, f, f2);
            this.selectAndShowItems(arrayList, this.home.isAllLevelsSelection());
            if (arrayList.size() != 1 || !(arrayList.get(0) instanceof Camera)) {
                this.postItemsMove(arrayList, list, f, f2);
            }
        }
    }

    public void moveItems(List<? extends Selectable> list, float f, float f2) {
        for (Selectable selectable : list) {
            if (selectable instanceof Wall) {
                Wall wall = (Wall)selectable;
                wall.removePropertyChangeListener(this.wallChangeListener);
                PlanController.moveWallStartPoint(wall, wall.getXStart() + f, wall.getYStart() + f2, !list.contains(wall.getWallAtStart()));
                PlanController.moveWallEndPoint(wall, wall.getXEnd() + f, wall.getYEnd() + f2, !list.contains(wall.getWallAtEnd()));
                this.resetAreaCache();
                wall.addPropertyChangeListener(this.wallChangeListener);
                continue;
            }
            boolean bl = false;
            if (selectable instanceof HomeDoorOrWindow) {
                bl = ((HomeDoorOrWindow)selectable).isBoundToWall();
            }
            selectable.move(f, f2);
            if (!bl) continue;
            Area area = new Area(this.getPath(selectable.getPoints()));
            area.intersect(this.getWallsArea(true));
            ((HomeDoorOrWindow)selectable).setBoundToWall(!area.isEmpty());
        }
    }

    private static void moveWallStartPoint(Wall wall, float f, float f2, boolean bl) {
        float f3 = wall.getXStart();
        float f4 = wall.getYStart();
        wall.setXStart(f);
        wall.setYStart(f2);
        Wall wall2 = wall.getWallAtStart();
        if (wall2 != null && bl) {
            if (wall2.getWallAtStart() == wall && (wall2.getWallAtEnd() != wall || wall2.getXStart() == f3 && wall2.getYStart() == f4)) {
                wall2.setXStart(f);
                wall2.setYStart(f2);
            } else if (wall2.getWallAtEnd() == wall && (wall2.getWallAtStart() != wall || wall2.getXEnd() == f3 && wall2.getYEnd() == f4)) {
                wall2.setXEnd(f);
                wall2.setYEnd(f2);
            }
        }
    }

    private static void moveWallEndPoint(Wall wall, float f, float f2, boolean bl) {
        float f3 = wall.getXEnd();
        float f4 = wall.getYEnd();
        wall.setXEnd(f);
        wall.setYEnd(f2);
        Wall wall2 = wall.getWallAtEnd();
        if (wall2 != null && bl) {
            if (wall2.getWallAtStart() == wall && (wall2.getWallAtEnd() != wall || wall2.getXStart() == f3 && wall2.getYStart() == f4)) {
                wall2.setXStart(f);
                wall2.setYStart(f2);
            } else if (wall2.getWallAtEnd() == wall && (wall2.getWallAtStart() != wall || wall2.getXEnd() == f3 && wall2.getYEnd() == f4)) {
                wall2.setXEnd(f);
                wall2.setYEnd(f2);
            }
        }
    }

    private static void moveWallPoint(Wall wall, float f, float f2, boolean bl) {
        if (bl) {
            PlanController.moveWallStartPoint(wall, f, f2, true);
        } else {
            PlanController.moveWallEndPoint(wall, f, f2, true);
        }
    }

    private static void moveRoomPoint(Room room, float f, float f2, int n) {
        room.setPoint(f, f2, n);
    }

    private static void moveDimensionLinePoint(DimensionLine dimensionLine, float f, float f2, boolean bl) {
        if (bl) {
            dimensionLine.setXStart(f);
            dimensionLine.setYStart(f2);
        } else {
            dimensionLine.setXEnd(f);
            dimensionLine.setYEnd(f2);
        }
    }

    private static void reverseDimensionLine(DimensionLine dimensionLine) {
        float f = dimensionLine.getXStart();
        float f2 = dimensionLine.getYStart();
        dimensionLine.setXStart(dimensionLine.getXEnd());
        dimensionLine.setYStart(dimensionLine.getYEnd());
        dimensionLine.setXEnd(f);
        dimensionLine.setYEnd(f2);
        dimensionLine.setOffset(-dimensionLine.getOffset());
    }

    protected void selectAndShowItems(List<? extends Selectable> list) {
        this.selectAndShowItems(list, false);
    }

    private void selectAndShowItems(List<? extends Selectable> list, boolean bl) {
        this.selectItems(list, bl);
        this.selectLevelFromSelectedItems();
        this.getView().makeSelectionVisible();
    }

    protected void selectItems(List<? extends Selectable> list) {
        this.selectItems(list, false);
    }

    private void selectItems(List<? extends Selectable> list, boolean bl) {
        this.home.removeSelectionListener(this.selectionListener);
        this.home.setSelectedItems(list);
        this.home.addSelectionListener(this.selectionListener);
        this.home.setAllLevelsSelection(bl);
    }

    public void selectItem(Selectable selectable) {
        this.selectItems(Arrays.asList(selectable));
    }

    public void toggleItemSelection(Selectable selectable) {
        ArrayList<Selectable> arrayList = new ArrayList<Selectable>(this.home.getSelectedItems());
        if (arrayList.contains(selectable)) {
            arrayList.remove(selectable);
        } else {
            arrayList.add(selectable);
        }
        this.selectItems(arrayList, this.home.isAllLevelsSelection());
    }

    private void deselectAll() {
        List list = Collections.emptyList();
        this.selectItems(list);
    }

    public void addItems(List<? extends Selectable> list) {
        this.undoSupport.beginUpdate();
        this.addFurniture(Home.getFurnitureSubList(list));
        this.addWalls(Home.getWallsSubList(list));
        this.addRooms(Home.getRoomsSubList(list));
        this.addPolylines(Home.getPolylinesSubList(list));
        this.addDimensionLines(Home.getDimensionLinesSubList(list));
        this.addLabels(Home.getLabelsSubList(list));
        this.home.setSelectedItems(list);
        this.undoSupport.postEdit(new ItemsAdditionEndUndoableEdit(this.home, this.preferences, list.toArray(new Selectable[list.size()])));
        this.undoSupport.endUpdate();
    }

    @Override
    public void addFurniture(List<HomePieceOfFurniture> list) {
        super.addFurniture(list);
        if (this.preferences.isMagnetismEnabled()) {
            Area area = this.getWallsArea(false);
            for (HomePieceOfFurniture homePieceOfFurniture : list) {
                if (!(homePieceOfFurniture instanceof HomeDoorOrWindow)) continue;
                float[][] fArray = homePieceOfFurniture.getPoints();
                Area area2 = new Area(this.getPath(fArray));
                area2.intersect(area);
                if (area2.isEmpty()) continue;
                Room room = new Room(fArray);
                if (!((double)(room.getArea() / this.getArea(area2)) > 0.999)) continue;
                ((HomeDoorOrWindow)homePieceOfFurniture).setBoundToWall(true);
            }
        }
    }

    public void addWalls(List<Wall> list) {
        for (Wall wall : list) {
            this.home.addWall(wall);
        }
        this.postCreateWalls(list, this.home.getSelectedItems(), this.home.isBasePlanLocked(), this.home.isAllLevelsSelection());
    }

    private void postCreateWalls(List<Wall> list, List<Selectable> list2, boolean bl, boolean bl2) {
        if (list.size() > 0) {
            boolean bl3 = this.home.isBasePlanLocked();
            if (bl3) {
                for (Wall object2 : list) {
                    bl3 &= !this.isItemPartOfBasePlan(object2);
                }
                this.home.setBasePlanLocked(bl3);
            }
            boolean bl4 = bl3;
            JoinedWall[] joinedWallArray = JoinedWall.getJoinedWalls(list);
            Selectable[] selectableArray = list2.toArray(new Selectable[list2.size()]);
            this.undoSupport.postEdit(new WallsCreationUndoableEdit(this, this.preferences, selectableArray, bl, bl2, joinedWallArray, bl4));
        }
    }

    private void doAddWalls(JoinedWall[] joinedWallArray, boolean bl) {
        Wall wall;
        for (JoinedWall joinedWall : joinedWallArray) {
            wall = joinedWall.getWall();
            this.home.addWall(wall);
            wall.setLevel(joinedWall.getLevel());
        }
        this.home.setBasePlanLocked(bl);
        for (JoinedWall joinedWall : joinedWallArray) {
            Wall wall2;
            wall = joinedWall.getWall();
            Wall wall3 = joinedWall.getWallAtStart();
            if (wall3 != null) {
                wall.setWallAtStart(wall3);
                if (joinedWall.isJoinedAtEndOfWallAtStart()) {
                    wall3.setWallAtEnd(wall);
                } else {
                    wall3.setWallAtStart(wall);
                }
            }
            if ((wall2 = joinedWall.getWallAtEnd()) == null) continue;
            wall.setWallAtEnd(wall2);
            if (joinedWall.isJoinedAtStartOfWallAtEnd()) {
                wall2.setWallAtStart(wall);
                continue;
            }
            wall2.setWallAtEnd(wall);
        }
    }

    private void doDeleteWalls(JoinedWall[] joinedWallArray, boolean bl) {
        for (JoinedWall joinedWall : joinedWallArray) {
            this.home.deleteWall(joinedWall.getWall());
        }
        this.home.setBasePlanLocked(bl);
    }

    public void addRooms(List<Room> list) {
        Room[] roomArray = list.toArray(new Room[list.size()]);
        int[] nArray = new int[list.size()];
        int n = this.home.getRooms().size();
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = n++;
            this.home.addRoom(roomArray[i], nArray[i]);
        }
        this.postCreateRooms(roomArray, nArray, this.home.getSelectedItems(), this.home.isBasePlanLocked(), this.home.isAllLevelsSelection());
    }

    private void postCreateRooms(Room[] roomArray, int[] nArray, List<Selectable> list, boolean bl, boolean bl2) {
        if (roomArray.length > 0) {
            boolean bl3 = this.home.isBasePlanLocked();
            if (bl3) {
                for (Room room : roomArray) {
                    bl3 &= !this.isItemPartOfBasePlan(room);
                }
                this.home.setBasePlanLocked(bl3);
            }
            boolean bl4 = bl3;
            Selectable[] selectableArray = list.toArray(new Selectable[list.size()]);
            Level level = this.home.getSelectedLevel();
            this.undoSupport.postEdit(new RoomsCreationUndoableEdit(this, this.preferences, selectableArray, bl, bl2, roomArray, nArray, level, bl4));
        }
    }

    private void postCreateRooms(List<Room> list, List<Selectable> list2, boolean bl, boolean bl2) {
        Room[] roomArray = list.toArray(new Room[list.size()]);
        int[] nArray = new int[list.size()];
        List<Room> list3 = this.home.getRooms();
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = list3.lastIndexOf(roomArray[i]);
        }
        this.postCreateRooms(roomArray, nArray, list2, bl, bl2);
    }

    private void doAddRooms(Room[] roomArray, int[] nArray, Level[] levelArray, Level level, boolean bl) {
        for (int i = 0; i < nArray.length; ++i) {
            this.home.addRoom(roomArray[i], nArray[i]);
            roomArray[i].setLevel(levelArray != null ? levelArray[i] : level);
        }
        this.home.setBasePlanLocked(bl);
    }

    private void doDeleteRooms(Room[] roomArray, boolean bl) {
        for (Room room : roomArray) {
            this.home.deleteRoom(room);
        }
        this.home.setBasePlanLocked(bl);
    }

    public void addDimensionLines(List<DimensionLine> list) {
        for (DimensionLine dimensionLine : list) {
            this.home.addDimensionLine(dimensionLine);
        }
        this.postCreateDimensionLines(list, this.home.getSelectedItems(), this.home.isBasePlanLocked(), this.home.isAllLevelsSelection());
    }

    private void postCreateDimensionLines(List<DimensionLine> list, List<Selectable> list2, boolean bl, boolean bl2) {
        if (list.size() > 0) {
            boolean bl3 = this.home.isBasePlanLocked();
            if (bl3) {
                for (DimensionLine object2 : list) {
                    bl3 &= !this.isItemPartOfBasePlan(object2);
                }
                this.home.setBasePlanLocked(bl3);
            }
            boolean bl4 = bl3;
            DimensionLine[] dimensionLineArray = list.toArray(new DimensionLine[list.size()]);
            Selectable[] selectableArray = list2.toArray(new Selectable[list2.size()]);
            Level level = this.home.getSelectedLevel();
            this.undoSupport.postEdit(new DimensionLinesCreationUndoableEdit(this, this.preferences, selectableArray, bl, bl2, dimensionLineArray, level, bl4));
        }
    }

    private void doAddDimensionLines(DimensionLine[] dimensionLineArray, Level[] levelArray, Level level, boolean bl) {
        for (int i = 0; i < dimensionLineArray.length; ++i) {
            DimensionLine dimensionLine = dimensionLineArray[i];
            this.home.addDimensionLine(dimensionLine);
            dimensionLine.setLevel(levelArray != null ? levelArray[i] : level);
        }
        this.home.setBasePlanLocked(bl);
    }

    private void doDeleteDimensionLines(DimensionLine[] dimensionLineArray, boolean bl) {
        for (DimensionLine dimensionLine : dimensionLineArray) {
            this.home.deleteDimensionLine(dimensionLine);
        }
        this.home.setBasePlanLocked(bl);
    }

    public void addPolylines(List<Polyline> list) {
        Polyline[] polylineArray = list.toArray(new Polyline[list.size()]);
        int[] nArray = new int[list.size()];
        int n = this.home.getPolylines().size();
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = n++;
            this.home.addPolyline(polylineArray[i], nArray[i]);
        }
        this.postCreatePolylines(polylineArray, nArray, this.home.getSelectedItems(), this.home.isBasePlanLocked(), this.home.isAllLevelsSelection());
    }

    private void postCreatePolylines(Polyline[] polylineArray, int[] nArray, List<Selectable> list, boolean bl, boolean bl2) {
        if (polylineArray.length > 0) {
            boolean bl3 = this.home.isBasePlanLocked();
            if (bl3) {
                for (Polyline polyline : polylineArray) {
                    bl3 &= !this.isItemPartOfBasePlan(polyline);
                }
                this.home.setBasePlanLocked(bl3);
            }
            boolean bl4 = bl3;
            Selectable[] selectableArray = list.toArray(new Selectable[list.size()]);
            Level level = this.home.getSelectedLevel();
            this.undoSupport.postEdit(new PolylinesCreationUndoableEdit(this, this.preferences, selectableArray, bl, bl2, polylineArray, nArray, level, bl4));
        }
    }

    private void postCreatePolylines(List<Polyline> list, List<Selectable> list2, boolean bl, boolean bl2) {
        Polyline[] polylineArray = list.toArray(new Polyline[list.size()]);
        int[] nArray = new int[list.size()];
        List<Polyline> list3 = this.home.getPolylines();
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = list3.lastIndexOf(polylineArray[i]);
        }
        this.postCreatePolylines(polylineArray, nArray, list2, bl, bl2);
    }

    private void doAddPolylines(Polyline[] polylineArray, int[] nArray, Level[] levelArray, Level level, boolean bl) {
        for (int i = 0; i < nArray.length; ++i) {
            this.home.addPolyline(polylineArray[i], nArray[i]);
            polylineArray[i].setLevel(levelArray != null ? levelArray[i] : level);
        }
        this.home.setBasePlanLocked(bl);
    }

    private void doDeletePolylines(Polyline[] polylineArray, boolean bl) {
        for (Polyline polyline : polylineArray) {
            this.home.deletePolyline(polyline);
        }
        this.home.setBasePlanLocked(bl);
    }

    public void addLabels(List<Label> list) {
        for (Label label : list) {
            this.home.addLabel(label);
        }
        this.postCreateLabels(list, this.home.getSelectedItems(), this.home.isBasePlanLocked(), this.home.isAllLevelsSelection());
    }

    private void postCreateLabels(List<Label> list, List<Selectable> list2, boolean bl, boolean bl2) {
        if (list.size() > 0) {
            boolean bl3 = this.home.isBasePlanLocked();
            if (bl3) {
                for (Label object2 : list) {
                    bl3 &= !this.isItemPartOfBasePlan(object2);
                }
                this.home.setBasePlanLocked(bl3);
            }
            boolean bl4 = bl3;
            Label[] labelArray = list.toArray(new Label[list.size()]);
            Selectable[] selectableArray = list2.toArray(new Selectable[list2.size()]);
            Level level = this.home.getSelectedLevel();
            this.undoSupport.postEdit(new LabelsCreationUndoableEdit(this, this.preferences, selectableArray, bl, bl2, labelArray, level, bl4));
        }
    }

    private void doAddLabels(Label[] labelArray, Level[] levelArray, Level level, boolean bl) {
        for (int i = 0; i < labelArray.length; ++i) {
            Label label = labelArray[i];
            this.home.addLabel(label);
            label.setLevel(levelArray != null ? levelArray[i] : level);
        }
        this.home.setBasePlanLocked(bl);
    }

    private void doDeleteLabels(Label[] labelArray, boolean bl) {
        for (Label label : labelArray) {
            this.home.deleteLabel(label);
        }
        this.home.setBasePlanLocked(bl);
    }

    private void postLabelRotation(Label label, float f) {
        float f2 = label.getAngle();
        if (f2 != f) {
            this.undoSupport.postEdit(new LabelRotationUndoableEdit(this, this.preferences, f, label, f2));
        }
    }

    private void postLabelElevation(Label label, float f) {
        float f2 = label.getElevation();
        if (f2 != f) {
            this.undoSupport.postEdit(new LabelElevationModificationUndoableEdit(this, this.preferences, f, label, f2));
        }
    }

    private void postItemsMove(List<? extends Selectable> list, List<? extends Selectable> list2, float f, float f2) {
        if (f != 0.0f || f2 != 0.0f) {
            Selectable[] selectableArray = list.toArray(new Selectable[list.size()]);
            boolean bl = this.home.isAllLevelsSelection();
            Selectable[] selectableArray2 = list2.toArray(new Selectable[list2.size()]);
            this.undoSupport.postEdit(new ItemsMovingUndoableEdit(this, this.preferences, selectableArray2, bl, selectableArray, f, f2));
        }
    }

    private void doMoveAndShowItems(Selectable[] selectableArray, Selectable[] selectableArray2, float f, float f2, boolean bl) {
        this.home.setAllLevelsSelection(bl);
        this.moveItems(Arrays.asList(selectableArray), f, f2);
        this.selectAndShowItems(Arrays.asList(selectableArray2), bl);
    }

    private void postPieceOfFurnitureMove(HomePieceOfFurniture homePieceOfFurniture, float f, float f2, float f3, float f4, float f5, boolean bl) {
        float f6 = homePieceOfFurniture.getAngle();
        float f7 = homePieceOfFurniture.getDepth();
        float f8 = homePieceOfFurniture.getElevation();
        if (f != 0.0f || f2 != 0.0f || f6 != f3 || f7 != f4 || f8 != f5) {
            this.undoSupport.postEdit(new PieceOfFurnitureMovingUndoableEdit(this, this.preferences, f3, f4, f5, bl, homePieceOfFurniture, f, f2, f6, f7, f8));
        }
    }

    private void postItemsDuplication(List<Selectable> list, List<Selectable> list2) {
        boolean bl = this.home.isBasePlanLocked();
        boolean bl2 = this.home.isAllLevelsSelection();
        List<HomePieceOfFurniture> list3 = Home.getFurnitureSubList(list);
        for (HomePieceOfFurniture homePieceOfFurniture : list3) {
            this.home.deletePieceOfFurniture(homePieceOfFurniture);
        }
        this.undoSupport.beginUpdate();
        this.undoSupport.postEdit(new DuplicationStartUndoableEdit(this, list2.toArray(new Selectable[list2.size()]), bl2));
        this.addFurniture(list3);
        List list4 = Collections.emptyList();
        this.postCreateWalls(Home.getWallsSubList(list), list4, bl, bl2);
        this.postCreateRooms(Home.getRoomsSubList(list), list4, bl, bl2);
        this.postCreatePolylines(Home.getPolylinesSubList(list), list4, bl, bl2);
        this.postCreateDimensionLines(Home.getDimensionLinesSubList(list), list4, bl, bl2);
        this.postCreateLabels(Home.getLabelsSubList(list), list4, bl, bl2);
        this.undoSupport.postEdit(new DuplicationEndUndoableEdit(this, this.preferences, list.toArray(new Selectable[list.size()])));
        this.undoSupport.endUpdate();
        this.selectItems(list);
    }

    private void postWallResize(Wall wall, float f, float f2, boolean bl) {
        float f3;
        float f4;
        if (bl) {
            f4 = wall.getXStart();
            f3 = wall.getYStart();
        } else {
            f4 = wall.getXEnd();
            f3 = wall.getYEnd();
        }
        if (f4 != f || f3 != f2) {
            this.undoSupport.postEdit(new WallResizingUndoableEdit(this, this.preferences, f, f2, wall, bl, f4, f3));
        }
    }

    private void postWallArcExtent(Wall wall, Float f) {
        Float f2 = wall.getArcExtent();
        if (!(f2 == f || f2 != null && f2.equals(f))) {
            this.undoSupport.postEdit(new WallArcExtentModificationUndoableEdit(this, this.preferences, f, wall, f2));
        }
    }

    private void postRoomResize(Room room, float f, float f2, int n) {
        float[] fArray = room.getPoints()[n];
        float f3 = fArray[0];
        float f4 = fArray[1];
        if (f3 != f || f4 != f2) {
            RoomResizingUndoableEdit roomResizingUndoableEdit = new RoomResizingUndoableEdit(this, this.preferences, f, f2, room, n, f3, f4);
            this.undoSupport.postEdit(roomResizingUndoableEdit);
        }
    }

    private void postRoomNameOffset(Room room, float f, float f2) {
        float f3 = room.getNameXOffset();
        float f4 = room.getNameYOffset();
        if (f3 != f || f4 != f2) {
            this.undoSupport.postEdit(new RoomNameOffsetModificationUndoableEdit(this, this.preferences, f, f2, room, f3, f4));
        }
    }

    private void postRoomNameRotation(Room room, float f) {
        float f2 = room.getNameAngle();
        if (f2 != f) {
            this.undoSupport.postEdit(new RoomNameRotationUndoableEdit(this, this.preferences, f, room, f2));
        }
    }

    private void postRoomAreaOffset(Room room, float f, float f2) {
        float f3 = room.getAreaXOffset();
        float f4 = room.getAreaYOffset();
        if (f3 != f || f4 != f2) {
            this.undoSupport.postEdit(new RoomAreaOffsetModificationUndoableEdit(this, this.preferences, f, f2, room, f3, f4));
        }
    }

    private void postRoomAreaRotation(Room room, float f) {
        float f2 = room.getAreaAngle();
        if (f2 != f) {
            this.undoSupport.postEdit(new RoomAreaRotationUndoableEdit(this, this.preferences, f, room, f2));
        }
    }

    private void postPieceOfFurnitureRotation(HomePieceOfFurniture homePieceOfFurniture, float f, boolean bl) {
        float f2 = homePieceOfFurniture.getAngle();
        if (f2 != f) {
            this.undoSupport.postEdit(new PieceOfFurnitureRotationUndoableEdit(this, this.preferences, f, bl, homePieceOfFurniture, f2));
        }
    }

    private void postPieceOfFurniturePitchRotation(HomePieceOfFurniture homePieceOfFurniture, float f, float f2, float f3, float f4) {
        float f5 = homePieceOfFurniture.getPitch();
        if (f5 != f) {
            this.undoSupport.postEdit(new PieceOfFurniturePitchRotationUndoableEdit(this, this.preferences, f, f2, f3, f4, homePieceOfFurniture, f5, homePieceOfFurniture.getWidthInPlan(), homePieceOfFurniture.getDepthInPlan(), homePieceOfFurniture.getHeightInPlan()));
        }
    }

    private void setPieceOfFurniturePitch(HomePieceOfFurniture homePieceOfFurniture, float f, float f2, float f3, float f4) {
        homePieceOfFurniture.removePropertyChangeListener(this.furnitureSizeChangeListener);
        homePieceOfFurniture.setPitch(f);
        homePieceOfFurniture.setWidthInPlan(f2);
        homePieceOfFurniture.setDepthInPlan(f3);
        homePieceOfFurniture.setHeightInPlan(f4);
        homePieceOfFurniture.addPropertyChangeListener(this.furnitureSizeChangeListener);
    }

    private void postPieceOfFurnitureRollRotation(HomePieceOfFurniture homePieceOfFurniture, float f, float f2, float f3, float f4) {
        float f5 = homePieceOfFurniture.getRoll();
        if (f5 != f) {
            this.undoSupport.postEdit(new PieceOfFurnitureRollRotationUndoableEdit(this, this.preferences, f, f2, f3, f4, homePieceOfFurniture, f5, homePieceOfFurniture.getWidthInPlan(), homePieceOfFurniture.getDepthInPlan(), homePieceOfFurniture.getHeightInPlan()));
        }
    }

    private void setPieceOfFurnitureRoll(HomePieceOfFurniture homePieceOfFurniture, float f, float f2, float f3, float f4) {
        homePieceOfFurniture.removePropertyChangeListener(this.furnitureSizeChangeListener);
        homePieceOfFurniture.setRoll(f);
        homePieceOfFurniture.setWidthInPlan(f2);
        homePieceOfFurniture.setDepthInPlan(f3);
        homePieceOfFurniture.setHeightInPlan(f4);
        homePieceOfFurniture.addPropertyChangeListener(this.furnitureSizeChangeListener);
    }

    private void postPieceOfFurnitureElevation(HomePieceOfFurniture homePieceOfFurniture, float f) {
        float f2 = homePieceOfFurniture.getElevation();
        if (f2 != f) {
            this.undoSupport.postEdit(new PieceOfFurnitureElevationModificationUndoableEdit(this, this.preferences, f, homePieceOfFurniture, f2));
        }
    }

    private void postPieceOfFurnitureHeightResize(ResizedPieceOfFurniture resizedPieceOfFurniture) {
        if (resizedPieceOfFurniture.getPieceOfFurniture().getHeight() != resizedPieceOfFurniture.getHeight()) {
            this.postPieceOfFurnitureResize(resizedPieceOfFurniture, "undoPieceOfFurnitureHeightResizeName");
        }
    }

    private void postPieceOfFurnitureWidthAndDepthResize(ResizedPieceOfFurniture resizedPieceOfFurniture) {
        HomePieceOfFurniture homePieceOfFurniture = resizedPieceOfFurniture.getPieceOfFurniture();
        if (homePieceOfFurniture.getWidth() != resizedPieceOfFurniture.getWidth() || homePieceOfFurniture.getDepth() != resizedPieceOfFurniture.getDepth()) {
            this.postPieceOfFurnitureResize(resizedPieceOfFurniture, "undoPieceOfFurnitureWidthAndDepthResizeName");
        }
    }

    private void postPieceOfFurnitureResize(ResizedPieceOfFurniture resizedPieceOfFurniture, String string) {
        HomePieceOfFurniture homePieceOfFurniture = resizedPieceOfFurniture.getPieceOfFurniture();
        boolean bl = homePieceOfFurniture instanceof HomeDoorOrWindow && ((HomeDoorOrWindow)homePieceOfFurniture).isBoundToWall();
        this.undoSupport.postEdit(new PieceOfFurnitureResizingUndoableEdit(this, this.preferences, string, bl, resizedPieceOfFurniture, homePieceOfFurniture.getX(), homePieceOfFurniture.getY(), homePieceOfFurniture.getWidth(), homePieceOfFurniture.getDepth(), homePieceOfFurniture.getHeight()));
    }

    private void setPieceOfFurnitureSize(ResizedPieceOfFurniture resizedPieceOfFurniture, float f, float f2, float f3) {
        HomePieceOfFurniture homePieceOfFurniture = resizedPieceOfFurniture.getPieceOfFurniture();
        homePieceOfFurniture.removePropertyChangeListener(this.furnitureSizeChangeListener);
        if (homePieceOfFurniture instanceof HomeFurnitureGroup) {
            for (HomePieceOfFurniture homePieceOfFurniture2 : ((HomeFurnitureGroup)homePieceOfFurniture).getAllFurniture()) {
                homePieceOfFurniture2.removePropertyChangeListener(this.furnitureSizeChangeListener);
            }
        }
        ResizedPieceOfFurniture.setPieceOfFurnitureSize(homePieceOfFurniture, f, f2, f3);
        homePieceOfFurniture.addPropertyChangeListener(this.furnitureSizeChangeListener);
        if (homePieceOfFurniture instanceof HomeFurnitureGroup) {
            for (HomePieceOfFurniture homePieceOfFurniture2 : ((HomeFurnitureGroup)homePieceOfFurniture).getAllFurniture()) {
                homePieceOfFurniture2.addPropertyChangeListener(this.furnitureSizeChangeListener);
            }
        }
    }

    private void resetPieceOfFurnitureSize(ResizedPieceOfFurniture resizedPieceOfFurniture) {
        HomePieceOfFurniture homePieceOfFurniture = resizedPieceOfFurniture.getPieceOfFurniture();
        homePieceOfFurniture.removePropertyChangeListener(this.furnitureSizeChangeListener);
        if (homePieceOfFurniture instanceof HomeFurnitureGroup) {
            for (HomePieceOfFurniture homePieceOfFurniture2 : ((HomeFurnitureGroup)homePieceOfFurniture).getAllFurniture()) {
                homePieceOfFurniture2.removePropertyChangeListener(this.furnitureSizeChangeListener);
            }
        }
        resizedPieceOfFurniture.reset();
        homePieceOfFurniture.addPropertyChangeListener(this.furnitureSizeChangeListener);
        if (homePieceOfFurniture instanceof HomeFurnitureGroup) {
            for (HomePieceOfFurniture homePieceOfFurniture2 : ((HomeFurnitureGroup)homePieceOfFurniture).getAllFurniture()) {
                homePieceOfFurniture2.addPropertyChangeListener(this.furnitureSizeChangeListener);
            }
        }
    }

    private void postLightPowerModification(HomeLight homeLight, float f) {
        float f2 = homeLight.getPower();
        if (f2 != f) {
            this.undoSupport.postEdit(new LightPowerModificationUndoableEdit(this, this.preferences, f, homeLight, f2));
        }
    }

    private void postPieceOfFurnitureNameOffset(HomePieceOfFurniture homePieceOfFurniture, float f, float f2) {
        float f3 = homePieceOfFurniture.getNameXOffset();
        float f4 = homePieceOfFurniture.getNameYOffset();
        if (f3 != f || f4 != f2) {
            this.undoSupport.postEdit(new PieceOfFurnitureNameOffsetModificationUndoableEdit(this, this.preferences, f, f2, homePieceOfFurniture, f3, f4));
        }
    }

    private void postPieceOfFurnitureNameRotation(HomePieceOfFurniture homePieceOfFurniture, float f) {
        float f2 = homePieceOfFurniture.getNameAngle();
        if (f2 != f) {
            this.undoSupport.postEdit(new PieceOfFurnitureNameRotationUndoableEdit(this, this.preferences, f, homePieceOfFurniture, f2));
        }
    }

    private void postDimensionLineResize(DimensionLine dimensionLine, float f, float f2, boolean bl, boolean bl2) {
        float f3;
        float f4;
        if (bl) {
            f4 = dimensionLine.getXStart();
            f3 = dimensionLine.getYStart();
        } else {
            f4 = dimensionLine.getXEnd();
            f3 = dimensionLine.getYEnd();
        }
        if (f4 != f || f3 != f2 || bl2) {
            this.undoSupport.postEdit(new DimensionLineResizingUndoableEdit(this, this.preferences, f, f2, dimensionLine, f4, f3, bl, bl2));
        }
    }

    private void postDimensionLineOffset(DimensionLine dimensionLine, float f) {
        float f2 = dimensionLine.getOffset();
        if (f2 != f) {
            this.undoSupport.postEdit(new DimensionLineOffsetModificationUndoableEdit(this, this.preferences, f, dimensionLine, f2));
        }
    }

    private void postPolylineResize(Polyline polyline, float f, float f2, int n) {
        float[] fArray = polyline.getPoints()[n];
        float f3 = fArray[0];
        float f4 = fArray[1];
        if (f3 != f || f4 != f2) {
            this.undoSupport.postEdit(new PolylineResizingUndoableEdit(this, this.preferences, f, f2, polyline, n, f3, f4));
        }
    }

    private void postCompassRotation(Compass compass, float f) {
        float f2 = compass.getNorthDirection();
        if (f2 != f) {
            this.undoSupport.postEdit(new CompassRotationUndoableEdit(this, this.preferences, f, compass, f2));
        }
    }

    private void postCompassResize(Compass compass, float f) {
        float f2 = compass.getDiameter();
        if (f2 != f) {
            this.undoSupport.postEdit(new CompassResizingUndoableEdit(this, this.preferences, f, compass, f2));
        }
    }

    private float[][] getPathPoints(GeneralPath generalPath, boolean bl) {
        ArrayList<float[]> arrayList = new ArrayList<float[]>();
        float[] fArray = null;
        PathIterator pathIterator = generalPath.getPathIterator(null);
        while (!pathIterator.isDone()) {
            float[] fArray2 = new float[2];
            if (!(pathIterator.currentSegment(fArray2) == 4 || fArray != null && Arrays.equals(fArray2, fArray))) {
                boolean bl2 = false;
                if (bl && arrayList.size() > 1) {
                    float[] fArray3;
                    float[] fArray4 = (float[])arrayList.get(arrayList.size() - 2);
                    boolean bl3 = bl2 = Line2D.ptLineDistSq(fArray4[0], fArray4[1], (fArray3 = fArray)[0], fArray3[1], fArray2[0], fArray2[1]) < 1.0E-4;
                }
                if (bl2) {
                    arrayList.set(arrayList.size() - 1, fArray2);
                } else {
                    arrayList.add(fArray2);
                }
                fArray = fArray2;
            }
            pathIterator.next();
        }
        if (arrayList.size() > 1 && Arrays.equals((float[])arrayList.get(0), (float[])arrayList.get(arrayList.size() - 1))) {
            arrayList.remove(arrayList.size() - 1);
        }
        return (float[][])arrayList.toArray((T[])new float[arrayList.size()][]);
    }

    private List<GeneralPath> getRoomPathsFromWalls() {
        if (this.roomPathsCache == null) {
            Area area = this.getWallsArea(false);
            List<GeneralPath> list = this.getAreaPaths(area);
            Area area2 = new Area(area);
            for (GeneralPath generalPath : list) {
                area2.add(new Area(generalPath));
            }
            this.roomPathsCache = list;
            this.insideWallsAreaCache = area2;
        }
        return this.roomPathsCache;
    }

    private List<GeneralPath> getAreaPaths(Area area) {
        ArrayList<GeneralPath> arrayList = new ArrayList<GeneralPath>();
        Path2D path2D = null;
        float[] fArray = null;
        PathIterator pathIterator = area.getPathIterator(null, 0.5);
        while (!pathIterator.isDone()) {
            float[] fArray2 = new float[2];
            switch (pathIterator.currentSegment(fArray2)) {
                case 0: {
                    path2D = new GeneralPath();
                    ((Path2D.Float)path2D).moveTo(fArray2[0], fArray2[1]);
                    fArray = fArray2;
                    break;
                }
                case 1: {
                    if (fArray2[0] == fArray[0] && fArray2[1] == fArray[1] || !(Point2D.distanceSq(fArray2[0], fArray2[1], fArray[0], fArray[1]) > 1.0E-10)) break;
                    ((Path2D.Float)path2D).lineTo(fArray2[0], fArray2[1]);
                    fArray = fArray2;
                    break;
                }
                case 4: {
                    path2D.closePath();
                    arrayList.add((GeneralPath)path2D);
                }
            }
            pathIterator.next();
        }
        return arrayList;
    }

    private Area getInsideWallsArea() {
        if (this.insideWallsAreaCache == null) {
            this.getRoomPathsFromWalls();
        }
        return this.insideWallsAreaCache;
    }

    private Area getWallsArea(boolean bl) {
        if (!bl && this.wallsAreaCache == null || bl && this.wallsIncludingBaseboardsAreaCache == null) {
            Area area = new Area();
            Level level = this.home.getSelectedLevel();
            for (Wall wall : this.home.getWalls()) {
                if (!wall.isAtLevel(level)) continue;
                area.add(new Area(this.getPath(wall.getPoints(bl))));
            }
            if (bl) {
                this.wallsIncludingBaseboardsAreaCache = area;
            } else {
                this.wallsAreaCache = area;
            }
        }
        return bl ? this.wallsIncludingBaseboardsAreaCache : this.wallsAreaCache;
    }

    private GeneralPath getPath(float[][] fArray) {
        GeneralPath generalPath = new GeneralPath();
        generalPath.moveTo(fArray[0][0], fArray[0][1]);
        for (int i = 1; i < fArray.length; ++i) {
            generalPath.lineTo(fArray[i][0], fArray[i][1]);
        }
        generalPath.closePath();
        return generalPath;
    }

    private GeneralPath getPath(Area area) {
        GeneralPath generalPath = new GeneralPath();
        float[] fArray = new float[2];
        PathIterator pathIterator = area.getPathIterator(null, 0.5);
        while (!pathIterator.isDone()) {
            switch (pathIterator.currentSegment(fArray)) {
                case 0: {
                    generalPath.moveTo(fArray[0], fArray[1]);
                    break;
                }
                case 1: {
                    generalPath.lineTo(fArray[0], fArray[1]);
                }
            }
            pathIterator.next();
        }
        return generalPath;
    }

    private void selectLevelFromSelectedItems() {
        Level level = this.home.getSelectedLevel();
        List<Selectable> list = this.home.getSelectedItems();
        for (Selectable selectable : list) {
            if (!(selectable instanceof Elevatable) || !((Elevatable)((Object)selectable)).isAtLevel(level)) continue;
            return;
        }
        for (Selectable selectable : list) {
            if (!(selectable instanceof Elevatable)) continue;
            this.setSelectedLevel(((Elevatable)((Object)selectable)).getLevel());
            break;
        }
    }

    private class CompassResizeState
    extends ControllerState {
        private Compass selectedCompass;
        private float oldDiameter;
        private float deltaXToResizePoint;
        private float deltaYToResizePoint;
        private String resizeToolTipFeedback;

        private CompassResizeState() {
        }

        public Mode getMode() {
            return Mode.SELECTION;
        }

        public boolean isModificationState() {
            return true;
        }

        public boolean isBasePlanModificationState() {
            return true;
        }

        public void enter() {
            this.resizeToolTipFeedback = PlanController.this.preferences.getLocalizedString(PlanController.class, "diameterToolTipFeedback", new Object[0]);
            this.selectedCompass = (Compass)PlanController.this.home.getSelectedItems().get(0);
            float[][] fArray = this.selectedCompass.getPoints();
            float f = (fArray[1][0] + fArray[2][0]) / 2.0f;
            float f2 = (fArray[1][1] + fArray[2][1]) / 2.0f;
            this.deltaXToResizePoint = PlanController.this.getXLastMousePress() - f;
            this.deltaYToResizePoint = PlanController.this.getYLastMousePress() - f2;
            this.oldDiameter = this.selectedCompass.getDiameter();
            PlanView planView = PlanController.this.getView();
            planView.setResizeIndicatorVisible(true);
            planView.setToolTipFeedback(this.getToolTipFeedbackText(this.oldDiameter), PlanController.this.getXLastMousePress(), PlanController.this.getYLastMousePress());
        }

        public void moveMouse(float f, float f2) {
            PlanView planView = PlanController.this.getView();
            float f3 = (float)Point2D.distance(this.selectedCompass.getX(), this.selectedCompass.getY(), f - this.deltaXToResizePoint, f2 - this.deltaYToResizePoint) * 2.0f;
            f3 = PlanController.this.preferences.getLengthUnit().getMagnetizedLength(f3, planView.getPixelLength());
            f3 = Math.min(Math.max(f3, PlanController.this.preferences.getLengthUnit().getMinimumLength()), PlanController.this.preferences.getLengthUnit().getMaximumLength() / 10.0f);
            this.selectedCompass.setDiameter(f3);
            planView.makePointVisible(f, f2);
            planView.setToolTipFeedback(this.getToolTipFeedbackText(f3), f, f2);
        }

        public void releaseMouse(float f, float f2) {
            PlanController.this.postCompassResize(this.selectedCompass, this.oldDiameter);
            PlanController.this.setState(PlanController.this.getSelectionState());
        }

        public void escape() {
            this.selectedCompass.setDiameter(this.oldDiameter);
            PlanController.this.setState(PlanController.this.getSelectionState());
        }

        public void exit() {
            PlanView planView = PlanController.this.getView();
            planView.setResizeIndicatorVisible(false);
            planView.deleteFeedback();
            this.selectedCompass = null;
        }

        private String getToolTipFeedbackText(float f) {
            return String.format(this.resizeToolTipFeedback, PlanController.this.preferences.getLengthUnit().getFormatWithUnit().format(Float.valueOf(f)));
        }
    }

    private class CompassRotationState
    extends ControllerState {
        private Compass selectedCompass;
        private float angleMousePress;
        private float oldNorthDirection;
        private String rotationToolTipFeedback;

        private CompassRotationState() {
        }

        public Mode getMode() {
            return Mode.SELECTION;
        }

        public boolean isModificationState() {
            return true;
        }

        public boolean isBasePlanModificationState() {
            return true;
        }

        public void enter() {
            this.rotationToolTipFeedback = PlanController.this.preferences.getLocalizedString(PlanController.class, "rotationToolTipFeedback", new Object[0]);
            this.selectedCompass = (Compass)PlanController.this.home.getSelectedItems().get(0);
            this.angleMousePress = (float)Math.atan2(this.selectedCompass.getY() - PlanController.this.getYLastMousePress(), PlanController.this.getXLastMousePress() - this.selectedCompass.getX());
            this.oldNorthDirection = this.selectedCompass.getNorthDirection();
            PlanView planView = PlanController.this.getView();
            planView.setResizeIndicatorVisible(true);
            planView.setToolTipFeedback(this.getToolTipFeedbackText(this.oldNorthDirection), PlanController.this.getXLastMousePress(), PlanController.this.getYLastMousePress());
        }

        public void moveMouse(float f, float f2) {
            if (f != this.selectedCompass.getX() || f2 != this.selectedCompass.getY()) {
                float f3 = (float)Math.atan2(this.selectedCompass.getY() - f2, f - this.selectedCompass.getX());
                float f4 = this.oldNorthDirection - f3 + this.angleMousePress;
                float f5 = (float)Math.PI / 180;
                f4 = (float)Math.round(f4 / f5) * f5;
                f4 = (float)(((double)f4 + Math.PI * 2) % (Math.PI * 2));
                this.selectedCompass.setNorthDirection(f4);
                PlanView planView = PlanController.this.getView();
                planView.makePointVisible(f, f2);
                planView.setToolTipFeedback(this.getToolTipFeedbackText(f4), f, f2);
            }
        }

        public void releaseMouse(float f, float f2) {
            PlanController.this.postCompassRotation(this.selectedCompass, this.oldNorthDirection);
            PlanController.this.setState(PlanController.this.getSelectionState());
        }

        public void escape() {
            this.selectedCompass.setNorthDirection(this.oldNorthDirection);
            PlanController.this.setState(PlanController.this.getSelectionState());
        }

        public void exit() {
            PlanView planView = PlanController.this.getView();
            planView.setResizeIndicatorVisible(false);
            planView.deleteFeedback();
            this.selectedCompass = null;
        }

        private String getToolTipFeedbackText(float f) {
            return String.format(this.rotationToolTipFeedback, Math.round(Math.toDegrees(f)));
        }
    }

    private class LabelElevationState
    extends ControllerState {
        private boolean magnetismEnabled;
        private float deltaYToElevationPoint;
        private Label selectedLabel;
        private float oldElevation;
        private String elevationToolTipFeedback;

        private LabelElevationState() {
        }

        public Mode getMode() {
            return Mode.SELECTION;
        }

        public boolean isModificationState() {
            return true;
        }

        public boolean isBasePlanModificationState() {
            return true;
        }

        public void enter() {
            this.elevationToolTipFeedback = PlanController.this.preferences.getLocalizedString(PlanController.class, "elevationToolTipFeedback", new Object[0]);
            this.selectedLabel = (Label)PlanController.this.home.getSelectedItems().get(0);
            TextStyle textStyle = PlanController.this.getItemTextStyle(this.selectedLabel, this.selectedLabel.getStyle());
            float[][] fArray = PlanController.this.getView().getTextBounds(this.selectedLabel.getText(), textStyle, this.selectedLabel.getX(), this.selectedLabel.getY(), this.selectedLabel.getAngle());
            this.deltaYToElevationPoint = PlanController.this.getYLastMousePress() - (fArray[2][1] + fArray[3][1]) / 2.0f;
            this.oldElevation = this.selectedLabel.getElevation();
            this.magnetismEnabled = PlanController.this.preferences.isMagnetismEnabled() ^ PlanController.this.wasMagnetismToggledLastMousePress();
            PlanView planView = PlanController.this.getView();
            planView.setResizeIndicatorVisible(true);
            planView.setToolTipFeedback(this.getToolTipFeedbackText(this.oldElevation), PlanController.this.getXLastMousePress(), PlanController.this.getYLastMousePress());
        }

        public void moveMouse(float f, float f2) {
            PlanView planView = PlanController.this.getView();
            TextStyle textStyle = PlanController.this.getItemTextStyle(this.selectedLabel, this.selectedLabel.getStyle());
            float[][] fArray = PlanController.this.getView().getTextBounds(this.selectedLabel.getText(), textStyle, this.selectedLabel.getX(), this.selectedLabel.getY(), this.selectedLabel.getAngle());
            float f3 = f2 - this.deltaYToElevationPoint - (fArray[2][1] + fArray[3][1]) / 2.0f;
            float f4 = this.oldElevation - f3;
            f4 = Math.min(Math.max(f4, 0.0f), PlanController.this.preferences.getLengthUnit().getMaximumElevation());
            if (this.magnetismEnabled) {
                f4 = PlanController.this.preferences.getLengthUnit().getMagnetizedLength(f4, planView.getPixelLength());
            }
            this.selectedLabel.setElevation(f4);
            planView.makePointVisible(f, f2);
            planView.setToolTipFeedback(this.getToolTipFeedbackText(f4), f, f2);
        }

        public void releaseMouse(float f, float f2) {
            PlanController.this.postLabelElevation(this.selectedLabel, this.oldElevation);
            PlanController.this.setState(PlanController.this.getSelectionState());
        }

        public void toggleMagnetism(boolean bl) {
            this.magnetismEnabled = PlanController.this.preferences.isMagnetismEnabled() ^ bl;
            this.moveMouse(PlanController.this.getXLastMouseMove(), PlanController.this.getYLastMouseMove());
        }

        public void escape() {
            this.selectedLabel.setElevation(this.oldElevation);
            PlanController.this.setState(PlanController.this.getSelectionState());
        }

        public void exit() {
            PlanView planView = PlanController.this.getView();
            planView.setResizeIndicatorVisible(false);
            planView.deleteFeedback();
            this.selectedLabel = null;
        }

        private String getToolTipFeedbackText(float f) {
            return String.format(this.elevationToolTipFeedback, PlanController.this.preferences.getLengthUnit().getFormatWithUnit().format(Float.valueOf(f)));
        }
    }

    private class LabelRotationState
    extends ControllerState {
        private static final int STEP_COUNT = 24;
        private Label selectedLabel;
        private float oldAngle;
        private float angleMousePress;
        private boolean magnetismEnabled;
        private boolean alignmentActivated;

        private LabelRotationState() {
        }

        public Mode getMode() {
            return Mode.SELECTION;
        }

        public boolean isModificationState() {
            return true;
        }

        public boolean isBasePlanModificationState() {
            return true;
        }

        public void enter() {
            this.selectedLabel = (Label)PlanController.this.home.getSelectedItems().get(0);
            this.angleMousePress = (float)Math.atan2(this.selectedLabel.getY() - PlanController.this.getYLastMousePress(), PlanController.this.getXLastMousePress() - this.selectedLabel.getX());
            this.oldAngle = this.selectedLabel.getAngle();
            this.alignmentActivated = PlanController.this.wasAlignmentActivatedLastMousePress();
            this.magnetismEnabled = PlanController.this.preferences.isMagnetismEnabled() ^ PlanController.this.wasMagnetismToggledLastMousePress();
            PlanView planView = PlanController.this.getView();
            planView.setResizeIndicatorVisible(true);
        }

        public void moveMouse(float f, float f2) {
            if (f != this.selectedLabel.getX() || f2 != this.selectedLabel.getY()) {
                float f3 = (float)Math.atan2(this.selectedLabel.getY() - f2, f - this.selectedLabel.getX());
                float f4 = this.oldAngle - f3 + this.angleMousePress;
                if (this.alignmentActivated || this.magnetismEnabled) {
                    float f5 = 0.2617994f;
                    f4 = (float)Math.round(f4 / f5) * f5;
                }
                this.selectedLabel.setAngle(f4);
                PlanController.this.getView().makePointVisible(f, f2);
            }
        }

        public void releaseMouse(float f, float f2) {
            PlanController.this.postLabelRotation(this.selectedLabel, this.oldAngle);
            PlanController.this.setState(PlanController.this.getSelectionState());
        }

        public void toggleMagnetism(boolean bl) {
            this.magnetismEnabled = PlanController.this.preferences.isMagnetismEnabled() ^ bl;
            this.moveMouse(PlanController.this.getXLastMouseMove(), PlanController.this.getYLastMouseMove());
        }

        public void setAlignmentActivated(boolean bl) {
            this.alignmentActivated = bl;
            this.moveMouse(PlanController.this.getXLastMouseMove(), PlanController.this.getYLastMouseMove());
        }

        public void escape() {
            this.selectedLabel.setAngle(this.oldAngle);
            PlanController.this.setState(PlanController.this.getSelectionState());
        }

        public void exit() {
            PlanController.this.getView().setResizeIndicatorVisible(false);
            this.selectedLabel = null;
        }
    }

    private class LabelCreationState
    extends AbstractModeChangeState {
        private LabelCreationState() {
        }

        public Mode getMode() {
            return Mode.LABEL_CREATION;
        }

        public void enter() {
            PlanController.this.getView().setCursor(PlanView.CursorType.DRAW);
        }

        public void pressMouse(float f, float f2, int n, boolean bl, boolean bl2) {
            PlanController.this.createLabel(f, f2);
            if (PlanController.this.getPointerTypeLastMousePress() == View.PointerType.TOUCH) {
                PlanController.this.setState(PlanController.this.getSelectionState());
            }
        }
    }

    private class PolylineResizeState
    extends AbstractPolylineState {
        private Collection<Polyline> polylines;
        private Polyline selectedPolyline;
        private int polylinePointIndex;
        private float oldX;
        private float oldY;
        private float deltaXToResizePoint;
        private float deltaYToResizePoint;
        private boolean magnetismEnabled;
        private boolean alignmentActivated;

        private PolylineResizeState() {
        }

        public Mode getMode() {
            return Mode.SELECTION;
        }

        public boolean isModificationState() {
            return true;
        }

        public boolean isBasePlanModificationState() {
            return true;
        }

        public void enter() {
            super.enter();
            this.selectedPolyline = (Polyline)PlanController.this.home.getSelectedItems().get(0);
            this.polylines = new ArrayList<Polyline>(PlanController.this.home.getPolylines());
            this.polylines.remove(this.selectedPolyline);
            float f = PlanController.this.getIndicatorMargin();
            this.polylinePointIndex = this.selectedPolyline.getPointIndexAt(PlanController.this.getXLastMousePress(), PlanController.this.getYLastMousePress(), f);
            float[][] fArray = this.selectedPolyline.getPoints();
            this.oldX = fArray[this.polylinePointIndex][0];
            this.oldY = fArray[this.polylinePointIndex][1];
            this.deltaXToResizePoint = PlanController.this.getXLastMousePress() - this.oldX;
            this.deltaYToResizePoint = PlanController.this.getYLastMousePress() - this.oldY;
            this.alignmentActivated = PlanController.this.wasAlignmentActivatedLastMousePress();
            this.toggleMagnetism(PlanController.this.wasMagnetismToggledLastMousePress());
            PlanView planView = PlanController.this.getView();
            planView.setResizeIndicatorVisible(true);
            String string = this.getToolTipFeedbackText(this.selectedPolyline, this.polylinePointIndex);
            if (string != null) {
                planView.setToolTipFeedback(string, PlanController.this.getXLastMousePress(), PlanController.this.getYLastMousePress());
                if (this.selectedPolyline.getJoinStyle() != Polyline.JoinStyle.CURVED) {
                    this.showPolylineAngleFeedback(this.selectedPolyline, this.polylinePointIndex);
                }
            }
        }

        public void moveMouse(float f, float f2) {
            PlanView planView = PlanController.this.getView();
            float f3 = f - this.deltaXToResizePoint;
            float f4 = f2 - this.deltaYToResizePoint;
            if (this.alignmentActivated || this.magnetismEnabled) {
                float[][] fArray = this.selectedPolyline.getPoints();
                int n = this.polylinePointIndex == 0 ? (this.selectedPolyline.isClosedPath() ? fArray.length - 1 : 1) : this.polylinePointIndex - 1;
                float f5 = fArray[n][0];
                float f6 = fArray[n][1];
                PointWithAngleMagnetism pointWithAngleMagnetism = new PointWithAngleMagnetism(f5, f6, f3, f4, PlanController.this.preferences.getLengthUnit(), planView.getPixelLength());
                f3 = pointWithAngleMagnetism.getX();
                f4 = pointWithAngleMagnetism.getY();
            }
            this.selectedPolyline.setPoint(f3, f4, this.polylinePointIndex);
            planView.setToolTipFeedback(this.getToolTipFeedbackText(this.selectedPolyline, this.polylinePointIndex), f, f2);
            if (this.selectedPolyline.getJoinStyle() != Polyline.JoinStyle.CURVED) {
                this.showPolylineAngleFeedback(this.selectedPolyline, this.polylinePointIndex);
            }
            planView.makePointVisible(f, f2);
        }

        public void releaseMouse(float f, float f2) {
            PlanController.this.postPolylineResize(this.selectedPolyline, this.oldX, this.oldY, this.polylinePointIndex);
            PlanController.this.setState(PlanController.this.getSelectionState());
        }

        public void toggleMagnetism(boolean bl) {
            this.magnetismEnabled = PlanController.this.preferences.isMagnetismEnabled() ^ bl;
            this.moveMouse(PlanController.this.getXLastMouseMove(), PlanController.this.getYLastMouseMove());
        }

        public void setAlignmentActivated(boolean bl) {
            this.alignmentActivated = bl;
            this.moveMouse(PlanController.this.getXLastMouseMove(), PlanController.this.getYLastMouseMove());
        }

        public void escape() {
            this.selectedPolyline.setPoint(this.oldX, this.oldY, this.polylinePointIndex);
            PlanController.this.setState(PlanController.this.getSelectionState());
        }

        public void exit() {
            PlanView planView = PlanController.this.getView();
            planView.setResizeIndicatorVisible(false);
            planView.deleteFeedback();
            this.selectedPolyline = null;
        }
    }

    private class PolylineDrawingState
    extends AbstractPolylineState {
        private float xPreviousPoint;
        private float yPreviousPoint;
        private Polyline newPolyline;
        private float[] newPoint;
        private List<Selectable> oldSelection;
        private boolean oldBasePlanLocked;
        private boolean oldAllLevelsSelection;
        private boolean magnetismEnabled;
        private boolean alignmentActivated;
        private boolean curvedPolyline;
        private long lastPointCreationTime;

        private PolylineDrawingState() {
        }

        public Mode getMode() {
            return Mode.POLYLINE_CREATION;
        }

        public boolean isModificationState() {
            return true;
        }

        public boolean isBasePlanModificationState() {
            return true;
        }

        public void setMode(Mode mode) {
            this.escape();
            if (mode == Mode.SELECTION) {
                PlanController.this.setState(PlanController.this.getSelectionState());
            } else if (mode == Mode.PANNING) {
                PlanController.this.setState(PlanController.this.getPanningState());
            } else if (mode == Mode.WALL_CREATION) {
                PlanController.this.setState(PlanController.this.getWallCreationState());
            } else if (mode == Mode.ROOM_CREATION) {
                PlanController.this.setState(PlanController.this.getRoomCreationState());
            } else if (mode == Mode.DIMENSION_LINE_CREATION) {
                PlanController.this.setState(PlanController.this.getDimensionLineCreationState());
            } else if (mode == Mode.LABEL_CREATION) {
                PlanController.this.setState(PlanController.this.getLabelCreationState());
            }
        }

        public void enter() {
            super.enter();
            this.oldSelection = PlanController.this.home.getSelectedItems();
            this.oldBasePlanLocked = PlanController.this.home.isBasePlanLocked();
            this.oldAllLevelsSelection = PlanController.this.home.isAllLevelsSelection();
            this.newPolyline = null;
            this.alignmentActivated = PlanController.this.wasAlignmentActivatedLastMousePress();
            this.toggleMagnetism(PlanController.this.wasMagnetismToggledLastMousePress());
            this.xPreviousPoint = PlanController.this.getXLastMousePress();
            this.yPreviousPoint = PlanController.this.getYLastMousePress();
            this.setDuplicationActivated(PlanController.this.wasDuplicationActivatedLastMousePress());
            PlanController.this.deselectAll();
        }

        public void moveMouse(float f, float f2) {
            Object object;
            PlanView planView = PlanController.this.getView();
            float f3 = f;
            float f4 = f2;
            if (this.alignmentActivated || this.magnetismEnabled) {
                object = new PointWithAngleMagnetism(this.xPreviousPoint, this.yPreviousPoint, f, f2, PlanController.this.preferences.getLengthUnit(), planView.getPixelLength());
                f3 = ((PointWithAngleMagnetism)object).getX();
                f4 = ((PointWithAngleMagnetism)object).getY();
            }
            if (this.newPolyline == null) {
                this.newPolyline = this.createAndSelectPolyline(this.xPreviousPoint, this.yPreviousPoint, f3, f4);
            } else if (this.newPoint != null) {
                object = this.newPolyline.getPoints();
                this.xPreviousPoint = object[((float[][])object).length - 1][0];
                this.yPreviousPoint = (float)object[((Object)object).length - 1][1];
                this.newPolyline.addPoint(f3, f4);
                this.newPoint[0] = f3;
                this.newPoint[1] = f4;
                this.newPoint = null;
            } else {
                this.newPolyline.setPoint(f3, f4, this.newPolyline.getPointCount() - 1);
            }
            planView.setAlignmentFeedback(Polyline.class, null, f, f2, false);
            planView.setToolTipFeedback(this.getToolTipFeedbackText(this.newPolyline, this.newPolyline.getPointCount() - 1), f, f2);
            if (this.newPolyline.getJoinStyle() != Polyline.JoinStyle.CURVED) {
                this.showPolylineAngleFeedback(this.newPolyline, this.newPolyline.getPointCount() - 1);
            }
            planView.makePointVisible(f, f2);
        }

        private Polyline createAndSelectPolyline(float f, float f2, float f3, float f4) {
            Polyline polyline = PlanController.this.createPolyline(new float[][]{{f, f2}, {f3, f4}});
            if (this.curvedPolyline) {
                polyline.setJoinStyle(Polyline.JoinStyle.CURVED);
            }
            PlanController.this.selectItems(Arrays.asList(polyline));
            return polyline;
        }

        public void pressMouse(float f, float f2, int n, boolean bl, boolean bl2) {
            if (n == 2) {
                if (this.newPolyline != null) {
                    int n2 = this.newPolyline.getPointIndexAt(f, f2, PlanController.this.getSelectionMargin());
                    if (n2 == 0) {
                        this.newPolyline.removePoint(this.newPolyline.getPointCount() - 1);
                        this.newPolyline.setClosedPath(true);
                    }
                    this.validateDrawnPolyline();
                } else if (PlanController.this.getPointerTypeLastMousePress() == View.PointerType.TOUCH) {
                    PlanController.this.setState(PlanController.this.getSelectionState());
                } else {
                    PlanController.this.setState(PlanController.this.getPolylineCreationState());
                }
            } else {
                this.endPolylineSegment();
            }
        }

        private void validateDrawnPolyline() {
            if (this.newPolyline != null) {
                float[][] fArray = this.newPolyline.getPoints();
                if (fArray.length < 2) {
                    PlanController.this.home.deletePolyline(this.newPolyline);
                } else {
                    PlanController.this.postCreatePolylines(Arrays.asList(this.newPolyline), this.oldSelection, this.oldBasePlanLocked, this.oldAllLevelsSelection);
                }
            }
            if (PlanController.this.getPointerTypeLastMousePress() == View.PointerType.TOUCH) {
                PlanController.this.setState(PlanController.this.getSelectionState());
            } else {
                PlanController.this.setState(PlanController.this.getPolylineCreationState());
            }
        }

        private void endPolylineSegment() {
            if (this.newPolyline != null && this.getPolylineSegmentLength(this.newPolyline, this.newPolyline.getPointCount() - 1) > 0.0f) {
                this.newPoint = new float[2];
                if (this.newPolyline.getPointCount() <= 2 && this.curvedPolyline && this.newPolyline.getJoinStyle() != Polyline.JoinStyle.CURVED) {
                    this.newPolyline.setJoinStyle(Polyline.JoinStyle.CURVED);
                }
            }
        }

        public void setEditionActivated(boolean bl) {
            PlanView planView = PlanController.this.getView();
            if (bl) {
                planView.deleteFeedback();
                if (this.newPolyline == null) {
                    planView.setToolTipEditedProperties(new EditableProperty[]{EditableProperty.X, EditableProperty.Y}, new Object[]{Float.valueOf(this.xPreviousPoint), Float.valueOf(this.yPreviousPoint)}, this.xPreviousPoint, this.yPreviousPoint);
                } else {
                    if (this.newPoint != null) {
                        this.createNextSegment();
                    }
                    float[][] fArray = this.newPolyline.getPoints();
                    planView.setToolTipEditedProperties(new EditableProperty[]{EditableProperty.LENGTH, EditableProperty.ANGLE}, new Object[]{Float.valueOf(this.getPolylineSegmentLength(this.newPolyline, fArray.length - 1)), this.getPolylineSegmentAngle(this.newPolyline, fArray.length - 1)}, fArray[fArray.length - 1][0], fArray[fArray.length - 1][1]);
                }
                this.showPolylineFeedback();
            } else if (this.newPolyline == null) {
                LengthUnit lengthUnit = PlanController.this.preferences.getLengthUnit();
                float f = lengthUnit.isMetric() ? 300.0f : LengthUnit.footToCentimeter(10.0f);
                this.newPolyline = this.createAndSelectPolyline(this.xPreviousPoint, this.yPreviousPoint, this.xPreviousPoint + f, this.yPreviousPoint);
                planView.deleteFeedback();
                this.setEditionActivated(true);
            } else if (System.currentTimeMillis() - this.lastPointCreationTime < 300L) {
                this.escape();
            } else {
                this.endPolylineSegment();
                float[][] fArray = this.newPolyline.getPoints();
                if (fArray.length > 2 && this.newPolyline.getPointIndexAt(fArray[fArray.length - 1][0], fArray[fArray.length - 1][1], 0.001f) == 0) {
                    this.newPolyline.removePoint(this.newPolyline.getPointCount() - 1);
                    this.newPolyline.setClosedPath(true);
                    this.validateDrawnPolyline();
                    return;
                }
                this.createNextSegment();
                planView.deleteToolTipFeedback();
                this.setEditionActivated(true);
            }
        }

        private void createNextSegment() {
            float[][] fArray = this.newPolyline.getPoints();
            this.xPreviousPoint = fArray[fArray.length - 1][0];
            this.yPreviousPoint = fArray[fArray.length - 1][1];
            double d = Math.PI - Math.atan2(fArray[fArray.length - 2][1] - fArray[fArray.length - 1][1], fArray[fArray.length - 2][0] - fArray[fArray.length - 1][0]);
            float f = this.getPolylineSegmentLength(this.newPolyline, fArray.length - 1);
            this.newPolyline.addPoint((float)((double)this.xPreviousPoint + (double)f * Math.cos(d -= 1.5707963267948966)), (float)((double)this.yPreviousPoint - (double)f * Math.sin(d)));
            this.newPoint = null;
            this.lastPointCreationTime = System.currentTimeMillis();
        }

        public void updateEditableProperty(EditableProperty editableProperty, Object object) {
            if (this.newPolyline == null) {
                switch (editableProperty) {
                    case X: {
                        this.xPreviousPoint = object != null ? ((Number)object).floatValue() : 0.0f;
                        this.xPreviousPoint = Math.max(-100000.0f, Math.min(this.xPreviousPoint, 100000.0f));
                        break;
                    }
                    case Y: {
                        this.yPreviousPoint = object != null ? ((Number)object).floatValue() : 0.0f;
                        this.yPreviousPoint = Math.max(-100000.0f, Math.min(this.yPreviousPoint, 100000.0f));
                    }
                }
            } else {
                float f;
                float f2;
                float[][] fArray = this.newPolyline.getPoints();
                float[] fArray2 = fArray[fArray.length - 2];
                float[] fArray3 = fArray[fArray.length - 1];
                switch (editableProperty) {
                    case LENGTH: {
                        float f3 = object != null ? ((Number)object).floatValue() : 0.0f;
                        f3 = Math.max(0.001f, Math.min(f3, PlanController.this.preferences.getLengthUnit().getMaximumLength()));
                        double d = Math.PI - Math.atan2(fArray2[1] - fArray3[1], fArray2[0] - fArray3[0]);
                        f2 = (float)((double)fArray2[0] + (double)f3 * Math.cos(d));
                        f = (float)((double)fArray2[1] - (double)f3 * Math.sin(d));
                        break;
                    }
                    case ANGLE: {
                        double d = Math.toRadians(object != null ? (double)((Number)object).floatValue() : 0.0);
                        if (fArray.length > 2) {
                            d -= Math.atan2(fArray[fArray.length - 3][1] - fArray2[1], fArray[fArray.length - 3][0] - fArray2[0]);
                        }
                        float f4 = this.getPolylineSegmentLength(this.newPolyline, fArray.length - 1);
                        f2 = (float)((double)fArray2[0] + (double)f4 * Math.cos(d));
                        f = (float)((double)fArray2[1] - (double)f4 * Math.sin(d));
                        break;
                    }
                    default: {
                        return;
                    }
                }
                this.newPolyline.setPoint(f2, f, fArray.length - 1);
            }
            this.showPolylineFeedback();
        }

        private void showPolylineFeedback() {
            PlanView planView = PlanController.this.getView();
            if (this.newPolyline == null) {
                planView.setAlignmentFeedback(Polyline.class, null, this.xPreviousPoint, this.yPreviousPoint, true);
                planView.makePointVisible(this.xPreviousPoint, this.yPreviousPoint);
            } else {
                float[][] fArray = this.newPolyline.getPoints();
                float[] fArray2 = fArray[fArray.length - 2];
                float[] fArray3 = fArray[fArray.length - 1];
                if (this.newPolyline.getJoinStyle() != Polyline.JoinStyle.CURVED) {
                    this.showPolylineAngleFeedback(this.newPolyline, fArray.length - 1);
                }
                planView.setAlignmentFeedback(Polyline.class, null, fArray3[0], fArray3[1], false);
                planView.makePointVisible(fArray2[0], fArray2[1]);
                planView.makePointVisible(fArray3[0], fArray3[1]);
            }
        }

        public void toggleMagnetism(boolean bl) {
            this.magnetismEnabled = PlanController.this.preferences.isMagnetismEnabled() ^ bl;
            if (this.newPolyline != null) {
                this.moveMouse(PlanController.this.getXLastMouseMove(), PlanController.this.getYLastMouseMove());
            }
        }

        public void setAlignmentActivated(boolean bl) {
            this.alignmentActivated = bl;
            this.moveMouse(PlanController.this.getXLastMouseMove(), PlanController.this.getYLastMouseMove());
        }

        public void setDuplicationActivated(boolean bl) {
            this.curvedPolyline = bl;
        }

        public void escape() {
            if (this.newPolyline != null && this.newPoint == null) {
                this.newPolyline.removePoint(this.newPolyline.getPointCount() - 1);
            }
            this.validateDrawnPolyline();
        }

        public void exit() {
            PlanController.this.getView().deleteFeedback();
            this.newPolyline = null;
            this.newPoint = null;
            this.oldSelection = null;
        }
    }

    private abstract class AbstractPolylineState
    extends ControllerState {
        private String polylineSegmentLengthToolTipFeedback;
        private String polylineSegmentAngleToolTipFeedback;

        private AbstractPolylineState() {
        }

        public void enter() {
            this.polylineSegmentLengthToolTipFeedback = PlanController.this.preferences.getLocalizedString(PlanController.class, "polylineSegmentLengthToolTipFeedback", new Object[0]);
            try {
                this.polylineSegmentAngleToolTipFeedback = PlanController.this.preferences.getLocalizedString(PlanController.class, "polylineSegmentAngleToolTipFeedback", new Object[0]);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }

        protected String getToolTipFeedbackText(Polyline polyline, int n) {
            float f = this.getPolylineSegmentLength(polyline, n);
            int n2 = this.getPolylineSegmentAngle(polyline, n);
            String string = "<html>" + String.format(this.polylineSegmentLengthToolTipFeedback, PlanController.this.preferences.getLengthUnit().getFormatWithUnit().format(Float.valueOf(f)));
            if (this.polylineSegmentAngleToolTipFeedback != null && this.polylineSegmentAngleToolTipFeedback.length() > 0) {
                string = string + "<br>" + String.format(this.polylineSegmentAngleToolTipFeedback, n2);
            }
            return string;
        }

        protected float getPolylineSegmentLength(Polyline polyline, int n) {
            if (n == 0 && !polyline.isClosedPath()) {
                ++n;
            }
            float[][] fArray = polyline.getPoints();
            float[] fArray2 = fArray[(n + fArray.length - 1) % fArray.length];
            return (float)Point2D.distance(fArray2[0], fArray2[1], fArray[n][0], fArray[n][1]);
        }

        protected Integer getPolylineSegmentAngle(Polyline polyline, int n) {
            if (n == 0 && !polyline.isClosedPath()) {
                ++n;
            }
            float[][] fArray = polyline.getPoints();
            float[] fArray2 = fArray[n];
            float[] fArray3 = fArray[(n + fArray.length - 1) % fArray.length];
            float[] fArray4 = fArray[(n + fArray.length - 2) % fArray.length];
            float f = (float)Point2D.distance(fArray3[0], fArray3[1], fArray[n][0], fArray[n][1]);
            float f2 = (float)Point2D.distance(fArray4[0], fArray4[1], fArray3[0], fArray3[1]);
            if (fArray4 != fArray2 && f != 0.0f && f2 != 0.0f) {
                float f3 = (fArray2[1] - fArray3[1]) / f;
                float f4 = (fArray3[0] - fArray4[0]) / f2;
                float f5 = (fArray2[0] - fArray3[0]) / f;
                float f6 = (fArray3[1] - fArray4[1]) / f2;
                int n2 = (int)Math.round(180.0 - Math.toDegrees(Math.atan2(f3 * f4 - f5 * f6, f5 * f4 + f3 * f6)));
                if (n2 > 180) {
                    n2 -= 360;
                }
                return n2;
            }
            if (f == 0.0f) {
                return 0;
            }
            return (int)Math.round(Math.toDegrees(Math.atan2(fArray3[1] - fArray2[1], fArray2[0] - fArray3[0])));
        }

        protected void showPolylineAngleFeedback(Polyline polyline, int n) {
            float[][] fArray = polyline.getPoints();
            if (this.polylineSegmentAngleToolTipFeedback != null && this.polylineSegmentAngleToolTipFeedback.length() > 0 && (n >= 2 || fArray.length > 2 && polyline.isClosedPath())) {
                float[] fArray2 = fArray[(n + fArray.length - 1) % fArray.length];
                float[] fArray3 = fArray[(n + fArray.length - 2) % fArray.length];
                PlanController.this.getView().setAngleFeedback(fArray2[0], fArray2[1], fArray3[0], fArray3[1], fArray[n][0], fArray[n][1]);
            }
        }
    }

    private class PolylineCreationState
    extends AbstractModeChangeState {
        private PolylineCreationState() {
        }

        public Mode getMode() {
            return Mode.POLYLINE_CREATION;
        }

        public void enter() {
            PlanController.this.getView().setCursor(PlanView.CursorType.DRAW);
        }

        public void pressMouse(float f, float f2, int n, boolean bl, boolean bl2) {
            PlanController.this.setState(PlanController.this.getPolylineDrawingState());
        }

        public void setEditionActivated(boolean bl) {
            if (bl) {
                PlanController.this.setState(PlanController.this.getPolylineDrawingState());
                PlanController.this.setEditionActivated(bl);
            }
        }
    }

    private class RoomAreaRotationState
    extends ControllerState {
        private static final int STEP_COUNT = 24;
        private Room selectedRoom;
        private float oldAreaAngle;
        private float angleMousePress;
        private boolean magnetismEnabled;
        private boolean alignmentActivated;

        private RoomAreaRotationState() {
        }

        public Mode getMode() {
            return Mode.SELECTION;
        }

        public boolean isModificationState() {
            return true;
        }

        public void enter() {
            this.selectedRoom = (Room)PlanController.this.home.getSelectedItems().get(0);
            this.angleMousePress = (float)Math.atan2(this.selectedRoom.getYCenter() + this.selectedRoom.getAreaYOffset() - PlanController.this.getYLastMousePress(), PlanController.this.getXLastMousePress() - this.selectedRoom.getXCenter() - this.selectedRoom.getAreaXOffset());
            this.oldAreaAngle = this.selectedRoom.getAreaAngle();
            this.alignmentActivated = PlanController.this.wasAlignmentActivatedLastMousePress();
            this.magnetismEnabled = PlanController.this.preferences.isMagnetismEnabled() ^ PlanController.this.wasMagnetismToggledLastMousePress();
            PlanView planView = PlanController.this.getView();
            planView.setResizeIndicatorVisible(true);
        }

        public void moveMouse(float f, float f2) {
            if (f != this.selectedRoom.getXCenter() + this.selectedRoom.getAreaXOffset() || f2 != this.selectedRoom.getYCenter() + this.selectedRoom.getAreaYOffset()) {
                float f3 = (float)Math.atan2(this.selectedRoom.getYCenter() + this.selectedRoom.getAreaYOffset() - f2, f - this.selectedRoom.getXCenter() - this.selectedRoom.getAreaXOffset());
                float f4 = this.oldAreaAngle - f3 + this.angleMousePress;
                if (this.alignmentActivated || this.magnetismEnabled) {
                    float f5 = 0.2617994f;
                    f4 = (float)Math.round(f4 / f5) * f5;
                }
                this.selectedRoom.setAreaAngle(f4);
                PlanController.this.getView().makePointVisible(f, f2);
            }
        }

        public void releaseMouse(float f, float f2) {
            PlanController.this.postRoomAreaRotation(this.selectedRoom, this.oldAreaAngle);
            PlanController.this.setState(PlanController.this.getSelectionState());
        }

        public void toggleMagnetism(boolean bl) {
            this.magnetismEnabled = PlanController.this.preferences.isMagnetismEnabled() ^ bl;
            this.moveMouse(PlanController.this.getXLastMouseMove(), PlanController.this.getYLastMouseMove());
        }

        public void setAlignmentActivated(boolean bl) {
            this.alignmentActivated = bl;
            this.moveMouse(PlanController.this.getXLastMouseMove(), PlanController.this.getYLastMouseMove());
        }

        public void escape() {
            this.selectedRoom.setAreaAngle(this.oldAreaAngle);
            PlanController.this.setState(PlanController.this.getSelectionState());
        }

        public void exit() {
            PlanController.this.getView().setResizeIndicatorVisible(false);
            this.selectedRoom = null;
        }
    }

    private class RoomAreaOffsetState
    extends ControllerState {
        private Room selectedRoom;
        private float oldAreaXOffset;
        private float oldAreaYOffset;
        private float xLastMouseMove;
        private float yLastMouseMove;
        private boolean alignmentActivated;

        private RoomAreaOffsetState() {
        }

        public Mode getMode() {
            return Mode.SELECTION;
        }

        public boolean isModificationState() {
            return true;
        }

        public void enter() {
            this.selectedRoom = (Room)PlanController.this.home.getSelectedItems().get(0);
            this.oldAreaXOffset = this.selectedRoom.getAreaXOffset();
            this.oldAreaYOffset = this.selectedRoom.getAreaYOffset();
            this.xLastMouseMove = PlanController.this.getXLastMousePress();
            this.yLastMouseMove = PlanController.this.getYLastMousePress();
            this.alignmentActivated = PlanController.this.wasAlignmentActivatedLastMousePress();
            PlanView planView = PlanController.this.getView();
            planView.setResizeIndicatorVisible(true);
        }

        public void moveMouse(float f, float f2) {
            if (this.alignmentActivated) {
                PointWithAngleMagnetism pointWithAngleMagnetism = new PointWithAngleMagnetism(PlanController.this.getXLastMousePress(), PlanController.this.getYLastMousePress(), f, f2, PlanController.this.preferences.getLengthUnit(), PlanController.this.getView().getPixelLength(), 4);
                f = pointWithAngleMagnetism.getX();
                f2 = pointWithAngleMagnetism.getY();
            }
            this.selectedRoom.setAreaXOffset(this.selectedRoom.getAreaXOffset() + f - this.xLastMouseMove);
            this.selectedRoom.setAreaYOffset(this.selectedRoom.getAreaYOffset() + f2 - this.yLastMouseMove);
            this.xLastMouseMove = f;
            this.yLastMouseMove = f2;
            PlanController.this.getView().makePointVisible(f, f2);
        }

        public void releaseMouse(float f, float f2) {
            PlanController.this.postRoomAreaOffset(this.selectedRoom, this.oldAreaXOffset, this.oldAreaYOffset);
            PlanController.this.setState(PlanController.this.getSelectionState());
        }

        public void setAlignmentActivated(boolean bl) {
            this.alignmentActivated = bl;
            this.moveMouse(PlanController.this.getXLastMouseMove(), PlanController.this.getYLastMouseMove());
        }

        public void escape() {
            this.selectedRoom.setAreaXOffset(this.oldAreaXOffset);
            this.selectedRoom.setAreaYOffset(this.oldAreaYOffset);
            PlanController.this.setState(PlanController.this.getSelectionState());
        }

        public void exit() {
            PlanController.this.getView().setResizeIndicatorVisible(false);
            this.selectedRoom = null;
        }
    }

    private class RoomNameRotationState
    extends ControllerState {
        private static final int STEP_COUNT = 24;
        private Room selectedRoom;
        private float oldNameAngle;
        private float angleMousePress;
        private boolean magnetismEnabled;
        private boolean alignmentActivated;

        private RoomNameRotationState() {
        }

        public Mode getMode() {
            return Mode.SELECTION;
        }

        public boolean isModificationState() {
            return true;
        }

        public void enter() {
            this.selectedRoom = (Room)PlanController.this.home.getSelectedItems().get(0);
            this.angleMousePress = (float)Math.atan2(this.selectedRoom.getYCenter() + this.selectedRoom.getNameYOffset() - PlanController.this.getYLastMousePress(), PlanController.this.getXLastMousePress() - this.selectedRoom.getXCenter() - this.selectedRoom.getNameXOffset());
            this.oldNameAngle = this.selectedRoom.getNameAngle();
            this.alignmentActivated = PlanController.this.wasAlignmentActivatedLastMousePress();
            this.magnetismEnabled = PlanController.this.preferences.isMagnetismEnabled() ^ PlanController.this.wasMagnetismToggledLastMousePress();
            PlanView planView = PlanController.this.getView();
            planView.setResizeIndicatorVisible(true);
        }

        public void moveMouse(float f, float f2) {
            if (f != this.selectedRoom.getXCenter() + this.selectedRoom.getNameXOffset() || f2 != this.selectedRoom.getYCenter() + this.selectedRoom.getNameYOffset()) {
                float f3 = (float)Math.atan2(this.selectedRoom.getYCenter() + this.selectedRoom.getNameYOffset() - f2, f - this.selectedRoom.getXCenter() - this.selectedRoom.getNameXOffset());
                float f4 = this.oldNameAngle - f3 + this.angleMousePress;
                if (this.alignmentActivated || this.magnetismEnabled) {
                    float f5 = 0.2617994f;
                    f4 = (float)Math.round(f4 / f5) * f5;
                }
                this.selectedRoom.setNameAngle(f4);
                PlanController.this.getView().makePointVisible(f, f2);
            }
        }

        public void releaseMouse(float f, float f2) {
            PlanController.this.postRoomNameRotation(this.selectedRoom, this.oldNameAngle);
            PlanController.this.setState(PlanController.this.getSelectionState());
        }

        public void toggleMagnetism(boolean bl) {
            this.magnetismEnabled = PlanController.this.preferences.isMagnetismEnabled() ^ bl;
            this.moveMouse(PlanController.this.getXLastMouseMove(), PlanController.this.getYLastMouseMove());
        }

        public void setAlignmentActivated(boolean bl) {
            this.alignmentActivated = bl;
            this.moveMouse(PlanController.this.getXLastMouseMove(), PlanController.this.getYLastMouseMove());
        }

        public void escape() {
            this.selectedRoom.setNameAngle(this.oldNameAngle);
            PlanController.this.setState(PlanController.this.getSelectionState());
        }

        public void exit() {
            PlanController.this.getView().setResizeIndicatorVisible(false);
            this.selectedRoom = null;
        }
    }

    private class RoomNameOffsetState
    extends ControllerState {
        private Room selectedRoom;
        private float oldNameXOffset;
        private float oldNameYOffset;
        private float xLastMouseMove;
        private float yLastMouseMove;
        private boolean alignmentActivated;

        private RoomNameOffsetState() {
        }

        public Mode getMode() {
            return Mode.SELECTION;
        }

        public boolean isModificationState() {
            return true;
        }

        public void enter() {
            this.selectedRoom = (Room)PlanController.this.home.getSelectedItems().get(0);
            this.oldNameXOffset = this.selectedRoom.getNameXOffset();
            this.oldNameYOffset = this.selectedRoom.getNameYOffset();
            this.xLastMouseMove = PlanController.this.getXLastMousePress();
            this.yLastMouseMove = PlanController.this.getYLastMousePress();
            this.alignmentActivated = PlanController.this.wasAlignmentActivatedLastMousePress();
            PlanView planView = PlanController.this.getView();
            planView.setResizeIndicatorVisible(true);
        }

        public void moveMouse(float f, float f2) {
            if (this.alignmentActivated) {
                PointWithAngleMagnetism pointWithAngleMagnetism = new PointWithAngleMagnetism(PlanController.this.getXLastMousePress(), PlanController.this.getYLastMousePress(), f, f2, PlanController.this.preferences.getLengthUnit(), PlanController.this.getView().getPixelLength(), 4);
                f = pointWithAngleMagnetism.getX();
                f2 = pointWithAngleMagnetism.getY();
            }
            this.selectedRoom.setNameXOffset(this.selectedRoom.getNameXOffset() + f - this.xLastMouseMove);
            this.selectedRoom.setNameYOffset(this.selectedRoom.getNameYOffset() + f2 - this.yLastMouseMove);
            this.xLastMouseMove = f;
            this.yLastMouseMove = f2;
            PlanController.this.getView().makePointVisible(f, f2);
        }

        public void releaseMouse(float f, float f2) {
            PlanController.this.postRoomNameOffset(this.selectedRoom, this.oldNameXOffset, this.oldNameYOffset);
            PlanController.this.setState(PlanController.this.getSelectionState());
        }

        public void setAlignmentActivated(boolean bl) {
            this.alignmentActivated = bl;
            this.moveMouse(PlanController.this.getXLastMouseMove(), PlanController.this.getYLastMouseMove());
        }

        public void escape() {
            this.selectedRoom.setNameXOffset(this.oldNameXOffset);
            this.selectedRoom.setNameYOffset(this.oldNameYOffset);
            PlanController.this.setState(PlanController.this.getSelectionState());
        }

        public void exit() {
            PlanController.this.getView().setResizeIndicatorVisible(false);
            this.selectedRoom = null;
        }
    }

    private class RoomResizeState
    extends AbstractRoomState {
        private Room selectedRoom;
        private int roomPointIndex;
        private float oldX;
        private float oldY;
        private float deltaXToResizePoint;
        private float deltaYToResizePoint;
        private boolean magnetismEnabled;
        private boolean alignmentActivated;

        private RoomResizeState() {
        }

        public Mode getMode() {
            return Mode.SELECTION;
        }

        public boolean isModificationState() {
            return true;
        }

        public boolean isBasePlanModificationState() {
            return true;
        }

        public void enter() {
            super.enter();
            this.selectedRoom = (Room)PlanController.this.home.getSelectedItems().get(0);
            float f = PlanController.this.getIndicatorMargin();
            this.roomPointIndex = this.selectedRoom.getPointIndexAt(PlanController.this.getXLastMousePress(), PlanController.this.getYLastMousePress(), f);
            float[][] fArray = this.selectedRoom.getPoints();
            this.oldX = fArray[this.roomPointIndex][0];
            this.oldY = fArray[this.roomPointIndex][1];
            this.deltaXToResizePoint = PlanController.this.getXLastMousePress() - this.oldX;
            this.deltaYToResizePoint = PlanController.this.getYLastMousePress() - this.oldY;
            this.alignmentActivated = PlanController.this.wasAlignmentActivatedLastMousePress();
            this.toggleMagnetism(PlanController.this.wasMagnetismToggledLastMousePress());
            PlanView planView = PlanController.this.getView();
            planView.setResizeIndicatorVisible(true);
            planView.setToolTipFeedback(this.getToolTipFeedbackText(this.selectedRoom, this.roomPointIndex), PlanController.this.getXLastMousePress(), PlanController.this.getYLastMousePress());
            this.showRoomAngleFeedback(this.selectedRoom, this.roomPointIndex);
            planView.setDimensionLinesFeedback(this.getTriangulationDimensionLines(this.selectedRoom, this.roomPointIndex));
        }

        public void moveMouse(float f, float f2) {
            PlanView planView = PlanController.this.getView();
            float f3 = f - this.deltaXToResizePoint;
            float f4 = f2 - this.deltaYToResizePoint;
            float[][] fArray = this.selectedRoom.getPoints();
            int n = this.roomPointIndex == 0 ? fArray.length - 1 : this.roomPointIndex - 1;
            float f5 = fArray[n][0];
            float f6 = fArray[n][1];
            boolean bl = false;
            if (this.alignmentActivated) {
                PointWithAngleMagnetism pointWithAngleMagnetism = new PointWithAngleMagnetism(f5, f6, f3, f4, PlanController.this.preferences.getLengthUnit(), planView.getPixelLength());
                f3 = pointWithAngleMagnetism.getX();
                f4 = pointWithAngleMagnetism.getY();
            } else if (this.magnetismEnabled) {
                PointMagnetizedToClosestWallOrRoomPoint pointMagnetizedToClosestWallOrRoomPoint = new PointMagnetizedToClosestWallOrRoomPoint(this.selectedRoom, this.roomPointIndex, f3, f4);
                bl = pointMagnetizedToClosestWallOrRoomPoint.isMagnetized();
                if (bl) {
                    f3 = pointMagnetizedToClosestWallOrRoomPoint.getX();
                    f4 = pointMagnetizedToClosestWallOrRoomPoint.getY();
                } else {
                    RoomPointWithAngleMagnetism roomPointWithAngleMagnetism = new RoomPointWithAngleMagnetism(this.selectedRoom, this.roomPointIndex, f5, f6, f3, f4);
                    f3 = roomPointWithAngleMagnetism.getX();
                    f4 = roomPointWithAngleMagnetism.getY();
                }
            }
            PlanController.moveRoomPoint(this.selectedRoom, f3, f4, this.roomPointIndex);
            planView.setToolTipFeedback(this.getToolTipFeedbackText(this.selectedRoom, this.roomPointIndex), f, f2);
            planView.setAlignmentFeedback(Room.class, this.selectedRoom, f3, f4, bl);
            this.showRoomAngleFeedback(this.selectedRoom, this.roomPointIndex);
            planView.setDimensionLinesFeedback(this.getTriangulationDimensionLines(this.selectedRoom, this.roomPointIndex));
            planView.makePointVisible(f, f2);
        }

        public void releaseMouse(float f, float f2) {
            PlanController.this.postRoomResize(this.selectedRoom, this.oldX, this.oldY, this.roomPointIndex);
            PlanController.this.setState(PlanController.this.getSelectionState());
        }

        public void toggleMagnetism(boolean bl) {
            this.magnetismEnabled = PlanController.this.preferences.isMagnetismEnabled() ^ bl;
            this.moveMouse(PlanController.this.getXLastMouseMove(), PlanController.this.getYLastMouseMove());
        }

        public void setAlignmentActivated(boolean bl) {
            this.alignmentActivated = bl;
            this.moveMouse(PlanController.this.getXLastMouseMove(), PlanController.this.getYLastMouseMove());
        }

        public void escape() {
            PlanController.moveRoomPoint(this.selectedRoom, this.oldX, this.oldY, this.roomPointIndex);
            PlanController.this.setState(PlanController.this.getSelectionState());
        }

        public void exit() {
            PlanView planView = PlanController.this.getView();
            planView.setResizeIndicatorVisible(false);
            planView.deleteFeedback();
            this.selectedRoom = null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class RoomDrawingState
    extends AbstractRoomState {
        private float xPreviousPoint;
        private float yPreviousPoint;
        private Room newRoom;
        private float[] newPoint;
        private List<Selectable> oldSelection;
        private boolean oldBasePlanLocked;
        private boolean oldAllLevelsSelection;
        private boolean magnetismEnabled;
        private boolean alignmentActivated;
        private long lastPointCreationTime;

        private RoomDrawingState() {
        }

        @Override
        public Mode getMode() {
            return Mode.ROOM_CREATION;
        }

        @Override
        public boolean isModificationState() {
            return true;
        }

        @Override
        public boolean isBasePlanModificationState() {
            return true;
        }

        @Override
        public void setMode(Mode mode) {
            this.escape();
            if (mode == Mode.SELECTION) {
                PlanController.this.setState(PlanController.this.getSelectionState());
            } else if (mode == Mode.PANNING) {
                PlanController.this.setState(PlanController.this.getPanningState());
            } else if (mode == Mode.WALL_CREATION) {
                PlanController.this.setState(PlanController.this.getWallCreationState());
            } else if (mode == Mode.POLYLINE_CREATION) {
                PlanController.this.setState(PlanController.this.getPolylineCreationState());
            } else if (mode == Mode.DIMENSION_LINE_CREATION) {
                PlanController.this.setState(PlanController.this.getDimensionLineCreationState());
            } else if (mode == Mode.LABEL_CREATION) {
                PlanController.this.setState(PlanController.this.getLabelCreationState());
            }
        }

        @Override
        public void enter() {
            super.enter();
            this.oldSelection = PlanController.this.home.getSelectedItems();
            this.oldBasePlanLocked = PlanController.this.home.isBasePlanLocked();
            this.oldAllLevelsSelection = PlanController.this.home.isAllLevelsSelection();
            this.newRoom = null;
            this.alignmentActivated = PlanController.this.wasAlignmentActivatedLastMousePress();
            this.toggleMagnetism(PlanController.this.wasMagnetismToggledLastMousePress());
            if (this.magnetismEnabled) {
                PointMagnetizedToClosestWallOrRoomPoint pointMagnetizedToClosestWallOrRoomPoint = new PointMagnetizedToClosestWallOrRoomPoint(PlanController.this.getXLastMouseMove(), PlanController.this.getYLastMouseMove());
                if (pointMagnetizedToClosestWallOrRoomPoint.isMagnetized()) {
                    this.xPreviousPoint = pointMagnetizedToClosestWallOrRoomPoint.getX();
                    this.yPreviousPoint = pointMagnetizedToClosestWallOrRoomPoint.getY();
                } else {
                    RoomPointWithAngleMagnetism roomPointWithAngleMagnetism = new RoomPointWithAngleMagnetism(null, -1, PlanController.this.getXLastMouseMove(), PlanController.this.getYLastMouseMove(), PlanController.this.getXLastMouseMove(), PlanController.this.getYLastMouseMove());
                    this.xPreviousPoint = roomPointWithAngleMagnetism.getX();
                    this.yPreviousPoint = roomPointWithAngleMagnetism.getY();
                }
                PlanController.this.getView().setAlignmentFeedback(Room.class, null, this.xPreviousPoint, this.yPreviousPoint, pointMagnetizedToClosestWallOrRoomPoint.isMagnetized());
            } else {
                this.xPreviousPoint = PlanController.this.getXLastMousePress();
                this.yPreviousPoint = PlanController.this.getYLastMousePress();
                PlanController.this.getView().setAlignmentFeedback(Room.class, null, this.xPreviousPoint, this.yPreviousPoint, false);
            }
            PlanController.this.deselectAll();
        }

        @Override
        public void moveMouse(float f, float f2) {
            Object object;
            PlanView planView = PlanController.this.getView();
            float f3 = f;
            float f4 = f2;
            boolean bl = false;
            if (this.alignmentActivated) {
                object = new PointWithAngleMagnetism(this.xPreviousPoint, this.yPreviousPoint, f, f2, PlanController.this.preferences.getLengthUnit(), planView.getPixelLength());
                f3 = ((PointWithAngleMagnetism)object).getX();
                f4 = ((PointWithAngleMagnetism)object).getY();
            } else if (this.magnetismEnabled) {
                object = this.newRoom != null ? new PointMagnetizedToClosestWallOrRoomPoint(this.newRoom, this.newRoom.getPointCount() - 1, f, f2) : new PointMagnetizedToClosestWallOrRoomPoint(f, f2);
                bl = ((PointMagnetizedToClosestWallOrRoomPoint)object).isMagnetized();
                if (bl) {
                    f3 = ((PointMagnetizedToClosestWallOrRoomPoint)object).getX();
                    f4 = ((PointMagnetizedToClosestWallOrRoomPoint)object).getY();
                } else {
                    int n = this.newRoom != null ? this.newRoom.getPointCount() - 1 : -1;
                    RoomPointWithAngleMagnetism roomPointWithAngleMagnetism = new RoomPointWithAngleMagnetism(this.newRoom, n, this.xPreviousPoint, this.yPreviousPoint, f, f2);
                    f3 = roomPointWithAngleMagnetism.getX();
                    f4 = roomPointWithAngleMagnetism.getY();
                }
            }
            if (this.newRoom == null) {
                this.newRoom = this.createAndSelectRoom(this.xPreviousPoint, this.yPreviousPoint, f3, f4);
            } else if (this.newPoint != null) {
                object = this.newRoom.getPoints();
                this.xPreviousPoint = (float)object[((float[][])object).length - 1][0];
                this.yPreviousPoint = (float)object[((Object)object).length - 1][1];
                this.newRoom.addPoint(f3, f4);
                this.newPoint = null;
            } else {
                this.newRoom.setPoint(f3, f4, this.newRoom.getPointCount() - 1);
            }
            planView.setToolTipFeedback(this.getToolTipFeedbackText(this.newRoom, this.newRoom.getPointCount() - 1), f, f2);
            planView.setAlignmentFeedback(Room.class, this.newRoom, f3, f4, bl);
            this.showRoomAngleFeedback(this.newRoom, this.newRoom.getPointCount() - 1);
            planView.setDimensionLinesFeedback(this.getTriangulationDimensionLines(this.newRoom, this.newRoom.getPointCount() - 1));
            planView.makePointVisible(f, f2);
        }

        private Room createAndSelectRoom(float f, float f2, float f3, float f4) {
            Room room = PlanController.this.createRoom(new float[][]{{f, f2}, {f3, f4}});
            Area area = PlanController.this.getInsideWallsArea();
            room.setCeilingVisible(area.contains(f, f2));
            PlanController.this.selectItem(room);
            return room;
        }

        @Override
        public void pressMouse(float f, float f2, int n, boolean bl, boolean bl2) {
            if (n == 2) {
                if (this.newRoom == null) {
                    this.newRoom = this.createRoomAt(f, f2);
                    if (this.newRoom != null) {
                        PlanController.this.selectItem(this.newRoom);
                    }
                }
                this.validateDrawnRoom();
            } else {
                this.endRoomSide();
            }
        }

        private void validateDrawnRoom() {
            if (this.newRoom != null) {
                float[][] fArray = this.newRoom.getPoints();
                if (fArray.length < 3) {
                    PlanController.this.home.deleteRoom(this.newRoom);
                } else {
                    PlanController.this.postCreateRooms(Arrays.asList(this.newRoom), this.oldSelection, this.oldBasePlanLocked, this.oldAllLevelsSelection);
                }
            }
            if (PlanController.this.getPointerTypeLastMousePress() == View.PointerType.TOUCH) {
                PlanController.this.setState(PlanController.this.getSelectionState());
            } else {
                PlanController.this.setState(PlanController.this.getRoomCreationState());
            }
        }

        private void endRoomSide() {
            if (this.newRoom != null && this.getRoomSideLength(this.newRoom, this.newRoom.getPointCount() - 1) > 0.0f) {
                this.newPoint = new float[2];
                if (this.newRoom.isCeilingVisible()) {
                    float[][] fArray = this.newRoom.getPoints();
                    float[] fArray2 = fArray[fArray.length - 1];
                    if (!PlanController.this.getInsideWallsArea().contains(fArray2[0], fArray2[1])) {
                        this.newRoom.setCeilingVisible(false);
                    }
                }
            }
        }

        private Room createRoomAt(float f, float f2) {
            for (GeneralPath generalPath : PlanController.this.getRoomPathsFromWalls()) {
                if (!generalPath.contains(f, f2)) continue;
                for (HomePieceOfFurniture homePieceOfFurniture : this.getVisibleDoorsAndWindowsAtGround(PlanController.this.home.getFurniture())) {
                    Cloneable cloneable;
                    Object object;
                    Cloneable cloneable2;
                    Object object2;
                    Cloneable cloneable3;
                    float[][] fArray = homePieceOfFurniture.getPoints();
                    int n = 0;
                    for (int i = 0; i < fArray.length; ++i) {
                        if (!generalPath.contains(fArray[i][0], fArray[i][1])) continue;
                        ++n;
                    }
                    if (fArray.length != 4) continue;
                    float f3 = 0.05f;
                    Object object3 = null;
                    if (homePieceOfFurniture instanceof HomeDoorOrWindow && ((HomeDoorOrWindow)homePieceOfFurniture).isWallCutOutOnBothSides()) {
                        cloneable3 = (HomeDoorOrWindow)homePieceOfFurniture;
                        object2 = PlanController.this.home.getSelectedLevel();
                        cloneable2 = new Area(PlanController.this.getPath(fArray));
                        Area area = new Area();
                        Object object4 = PlanController.this.home.getWalls().iterator();
                        while (object4.hasNext()) {
                            Wall wall = object4.next();
                            if (!wall.isAtLevel((Level)object2) || !((HomePieceOfFurniture)cloneable3).isParallelToWall(wall)) continue;
                            GeneralPath generalPath2 = PlanController.this.getPath(wall.getPoints());
                            object = new Area(generalPath2);
                            ((Area)object).intersect((Area)cloneable2);
                            if (((Area)object).isEmpty()) continue;
                            cloneable = ((HomePieceOfFurniture)cloneable3).clone();
                            ((HomePieceOfFurniture)cloneable).setDepthInPlan(((HomePieceOfFurniture)cloneable).getDepth() + 4.0f * wall.getThickness());
                            object = new Area(generalPath2);
                            ((Area)object).intersect(new Area(PlanController.this.getPath(((HomePieceOfFurniture)cloneable).getPoints())));
                            area.add((Area)object);
                        }
                        if (!area.isEmpty() && area.isSingular() && ((Object)(object4 = (Object)PlanController.this.getPathPoints(PlanController.this.getPath(area), true))).length == 4) {
                            float f4 = ((HomePieceOfFurniture)cloneable3).getY() + ((HomePieceOfFurniture)cloneable3).getDepth() * (-0.5f + ((HomeDoorOrWindow)cloneable3).getWallDistance() + ((HomeDoorOrWindow)cloneable3).getWallThickness() / 2.0f);
                            float f5 = ((HomePieceOfFurniture)cloneable3).getWidth() / 2.0f;
                            object = new float[]{((HomePieceOfFurniture)cloneable3).getX() - f5, f4, ((HomePieceOfFurniture)cloneable3).getX() + f5, f4};
                            cloneable = AffineTransform.getRotateInstance(((HomePieceOfFurniture)cloneable3).getAngle(), ((HomePieceOfFurniture)cloneable3).getX(), ((HomePieceOfFurniture)cloneable3).getY());
                            ((AffineTransform)cloneable).transform((float[])object, 0, (float[])object, 0, 2);
                            for (int i = 0; i < ((Object)object4).length - 1; ++i) {
                                int n2;
                                int n3;
                                if (!generalPath.intersects((double)(object4[i][0] - f3 / 2.0f), (double)(object4[i][1] - f3 / 2.0f), f3, f3)) continue;
                                int n4 = i;
                                if (generalPath.intersects((double)(object4[i + 1][0] - f3 / 2.0f), (double)(object4[i + 1][1] - f3 / 2.0f), f3, f3)) {
                                    n3 = (i + 2) % 4;
                                    n2 = (i + 3) % 4;
                                } else {
                                    if (!generalPath.intersects((double)(object4[(i + 3) % 4][0] - f3 / 2.0f), (double)(object4[(i + 3) % 4][1] - f3 / 2.0f), f3, f3)) break;
                                    n2 = (i + 1) % 4;
                                    n3 = (i + 2) % 4;
                                }
                                if (Point2D.distanceSq((double)object4[n4][0], (double)object4[n4][1], (double)object[0], (double)object[1]) < Point2D.distanceSq((double)object4[n4][0], (double)object4[n4][1], (double)object[2], (double)object[3])) {
                                    object4[n2][0] = object[0];
                                    object4[n2][1] = object[1];
                                    object4[n3][0] = object[2];
                                    object4[n3][1] = object[3];
                                } else {
                                    object4[n2][0] = object[2];
                                    object4[n2][1] = object[3];
                                    object4[n3][0] = object[0];
                                    object4[n3][1] = object[1];
                                }
                                object3 = object4;
                                break;
                            }
                        }
                    }
                    if (object3 == null && n == 2) {
                        cloneable3 = new Area(PlanController.this.getWallsArea(false));
                        ((Area)cloneable3).intersect(new Area(PlanController.this.getPath(fArray)));
                        object2 = PlanController.this.getPathPoints(PlanController.this.getPath((Area)cloneable3), false);
                        if (((Object)object2).length == 4) {
                            for (int i = 0; i < ((Object)object2).length; ++i) {
                                int n5;
                                int n6;
                                int n7;
                                if (!generalPath.intersects((double)(object2[i][0] - f3 / 2.0f), (double)(object2[i][1] - f3 / 2.0f), f3, f3)) continue;
                                int n8 = i;
                                if (generalPath.intersects((double)(object2[i + 1][0] - f3 / 2.0f), (double)(object2[i + 1][1] - f3 / 2.0f), f3, f3)) {
                                    n7 = i + 1;
                                    n6 = (i + 2) % 4;
                                    n5 = (i + 3) % 4;
                                } else {
                                    n5 = (i + 1) % 4;
                                    n6 = (i + 2) % 4;
                                    n7 = (i + 3) % 4;
                                }
                                object2[n5][0] = (object2[n5][0] + object2[n8][0]) / 2.0f;
                                object2[n5][1] = (object2[n5][1] + object2[n8][1]) / 2.0f;
                                object2[n6][0] = (object2[n6][0] + object2[n7][0]) / 2.0f;
                                object2[n6][1] = (object2[n6][1] + object2[n7][1]) / 2.0f;
                                object3 = object2;
                                break;
                            }
                        }
                    }
                    if (object3 == null) continue;
                    cloneable3 = PlanController.this.getPath(object3);
                    object2 = ((Path2D.Float)cloneable3).getBounds2D();
                    cloneable2 = AffineTransform.getTranslateInstance(((RectangularShape)object2).getCenterX(), ((RectangularShape)object2).getCenterY());
                    double d = Math.min(((RectangularShape)object2).getWidth(), ((RectangularShape)object2).getHeight());
                    double d2 = (d + (double)f3) / d;
                    ((AffineTransform)cloneable2).scale(d2, d2);
                    ((AffineTransform)cloneable2).translate(-((RectangularShape)object2).getCenterX(), -((RectangularShape)object2).getCenterY());
                    object = ((Path2D)cloneable3).createTransformedShape((AffineTransform)cloneable2);
                    cloneable = new Area((Shape)object);
                    ((Area)cloneable).add(new Area(generalPath));
                    generalPath = PlanController.this.getPath((Area)cloneable);
                }
                return PlanController.this.createRoom(PlanController.this.getPathPoints(generalPath, false));
            }
            return null;
        }

        private List<HomePieceOfFurniture> getVisibleDoorsAndWindowsAtGround(List<HomePieceOfFurniture> list) {
            ArrayList<HomePieceOfFurniture> arrayList = new ArrayList<HomePieceOfFurniture>(list.size());
            for (HomePieceOfFurniture homePieceOfFurniture : list) {
                if (!PlanController.this.isPieceOfFurnitureVisibleAtSelectedLevel(homePieceOfFurniture) || homePieceOfFurniture.getElevation() != 0.0f) continue;
                if (homePieceOfFurniture instanceof HomeFurnitureGroup) {
                    arrayList.addAll(this.getVisibleDoorsAndWindowsAtGround(((HomeFurnitureGroup)homePieceOfFurniture).getFurniture()));
                    continue;
                }
                if (!homePieceOfFurniture.isDoorOrWindow()) continue;
                arrayList.add(homePieceOfFurniture);
            }
            return arrayList;
        }

        @Override
        public void setEditionActivated(boolean bl) {
            PlanView planView = PlanController.this.getView();
            if (bl) {
                planView.deleteFeedback();
                if (this.newRoom == null) {
                    planView.setToolTipEditedProperties(new EditableProperty[]{EditableProperty.X, EditableProperty.Y}, new Object[]{Float.valueOf(this.xPreviousPoint), Float.valueOf(this.yPreviousPoint)}, this.xPreviousPoint, this.yPreviousPoint);
                } else {
                    float[][] fArray;
                    if (this.newPoint != null) {
                        this.createNextSide();
                    }
                    if ((fArray = this.newRoom.getPoints()).length > 2) {
                        planView.setToolTipEditedProperties(new EditableProperty[]{EditableProperty.LENGTH, EditableProperty.DIAGONAL, EditableProperty.ANGLE}, new Object[]{Float.valueOf(this.getRoomSideLength(this.newRoom, fArray.length - 1)), Float.valueOf(this.getRoomDiagonalLength(this.newRoom, fArray.length - 1)), this.getRoomSideAngle(this.newRoom, fArray.length - 1)}, fArray[fArray.length - 1][0], fArray[fArray.length - 1][1]);
                    } else {
                        planView.setToolTipEditedProperties(new EditableProperty[]{EditableProperty.LENGTH, EditableProperty.ANGLE}, new Object[]{Float.valueOf(this.getRoomSideLength(this.newRoom, fArray.length - 1)), this.getRoomSideAngle(this.newRoom, fArray.length - 1)}, fArray[fArray.length - 1][0], fArray[fArray.length - 1][1]);
                    }
                }
                this.showRoomFeedback();
            } else if (this.newRoom == null) {
                LengthUnit lengthUnit = PlanController.this.preferences.getLengthUnit();
                float f = lengthUnit.isMetric() ? 300.0f : LengthUnit.footToCentimeter(10.0f);
                this.newRoom = this.createAndSelectRoom(this.xPreviousPoint, this.yPreviousPoint, this.xPreviousPoint + f, this.yPreviousPoint);
                planView.deleteFeedback();
                this.setEditionActivated(true);
            } else if (System.currentTimeMillis() - this.lastPointCreationTime < 300L) {
                this.escape();
            } else {
                this.endRoomSide();
                float[][] fArray = this.newRoom.getPoints();
                if (fArray.length > 2 && this.newRoom.getPointIndexAt(fArray[fArray.length - 1][0], fArray[fArray.length - 1][1], 0.001f) == 0) {
                    this.newRoom.removePoint(this.newRoom.getPointCount() - 1);
                    this.validateDrawnRoom();
                    return;
                }
                this.createNextSide();
                planView.deleteToolTipFeedback();
                this.setEditionActivated(true);
            }
        }

        private void createNextSide() {
            float[][] fArray = this.newRoom.getPoints();
            this.xPreviousPoint = fArray[fArray.length - 1][0];
            this.yPreviousPoint = fArray[fArray.length - 1][1];
            double d = Math.PI - Math.atan2(fArray[fArray.length - 2][1] - fArray[fArray.length - 1][1], fArray[fArray.length - 2][0] - fArray[fArray.length - 1][0]);
            float f = this.getRoomSideLength(this.newRoom, fArray.length - 1);
            this.newRoom.addPoint((float)((double)this.xPreviousPoint + (double)f * Math.cos(d -= 1.5707963267948966)), (float)((double)this.yPreviousPoint - (double)f * Math.sin(d)));
            this.newPoint = null;
            this.lastPointCreationTime = System.currentTimeMillis();
        }

        @Override
        public void updateEditableProperty(EditableProperty editableProperty, Object object) {
            if (this.newRoom == null) {
                float f = PlanController.this.preferences.getLengthUnit().getMaximumLength();
                switch (editableProperty) {
                    case X: {
                        this.xPreviousPoint = object != null ? ((Number)object).floatValue() : 0.0f;
                        this.xPreviousPoint = Math.max(-f, Math.min(this.xPreviousPoint, f));
                        break;
                    }
                    case Y: {
                        this.yPreviousPoint = object != null ? ((Number)object).floatValue() : 0.0f;
                        this.yPreviousPoint = Math.max(-f, Math.min(this.yPreviousPoint, f));
                    }
                }
            } else {
                PlanView planView = PlanController.this.getView();
                float[][] fArray = this.newRoom.getPoints();
                float[] fArray2 = fArray[fArray.length - 2];
                float[] fArray3 = fArray[fArray.length - 1];
                switch (editableProperty) {
                    case LENGTH: {
                        float f = object != null ? ((Number)object).floatValue() : 0.0f;
                        f = Math.max(0.001f, Math.min(f, PlanController.this.preferences.getLengthUnit().getMaximumLength()));
                        double d = Math.PI - Math.atan2(fArray2[1] - fArray3[1], fArray2[0] - fArray3[0]);
                        float f2 = (float)((double)fArray2[0] + (double)f * Math.cos(d));
                        float f3 = (float)((double)fArray2[1] - (double)f * Math.sin(d));
                        this.newRoom.setPoint(f2, f3, fArray.length - 1);
                        if (fArray.length <= 2) break;
                        planView.setToolTipEditedPropertyValue(EditableProperty.DIAGONAL, Float.valueOf(this.getRoomDiagonalLength(this.newRoom, fArray.length - 1)));
                        break;
                    }
                    case DIAGONAL: {
                        float f = object != null ? ((Number)object).floatValue() : 0.0f;
                        float f4 = this.getRoomSideLength(this.newRoom, fArray.length - 1);
                        float f5 = this.getRoomSideLength(this.newRoom, fArray.length - 2);
                        if (!(f >= f4) || !(f <= f4 + f5)) break;
                        float f6 = (f4 * f4 + f5 * f5 - f * f) / (2.0f * f4 * f5);
                        double d = (double)Math.signum(this.getRoomSideAngle(this.newRoom, fArray.length - 1).intValue()) * Math.acos(f6);
                        float f7 = (float)((double)fArray2[0] + (double)f4 * Math.cos(d -= Math.atan2(fArray[fArray.length - 3][1] - fArray2[1], fArray[fArray.length - 3][0] - fArray2[0])));
                        float f8 = (float)((double)fArray2[1] - (double)f4 * Math.sin(d));
                        this.newRoom.setPoint(f7, f8, fArray.length - 1);
                        planView.setToolTipEditedPropertyValue(EditableProperty.ANGLE, this.getRoomSideAngle(this.newRoom, fArray.length - 1));
                        break;
                    }
                    case ANGLE: {
                        double d = Math.toRadians(object != null ? (double)((Number)object).floatValue() : 0.0);
                        if (fArray.length > 2) {
                            d -= Math.atan2(fArray[fArray.length - 3][1] - fArray2[1], fArray[fArray.length - 3][0] - fArray2[0]);
                        }
                        float f = this.getRoomSideLength(this.newRoom, fArray.length - 1);
                        float f9 = (float)((double)fArray2[0] + (double)f * Math.cos(d));
                        float f10 = (float)((double)fArray2[1] - (double)f * Math.sin(d));
                        this.newRoom.setPoint(f9, f10, fArray.length - 1);
                        if (fArray.length <= 2) break;
                        planView.setToolTipEditedPropertyValue(EditableProperty.DIAGONAL, Float.valueOf(this.getRoomDiagonalLength(this.newRoom, fArray.length - 1)));
                        break;
                    }
                    default: {
                        return;
                    }
                }
            }
            this.showRoomFeedback();
        }

        private void showRoomFeedback() {
            PlanView planView = PlanController.this.getView();
            if (this.newRoom == null) {
                planView.setAlignmentFeedback(Room.class, null, this.xPreviousPoint, this.yPreviousPoint, true);
                planView.makePointVisible(this.xPreviousPoint, this.yPreviousPoint);
            } else {
                float[][] fArray = this.newRoom.getPoints();
                float[] fArray2 = fArray[fArray.length - 1];
                planView.setAlignmentFeedback(Room.class, this.newRoom, fArray2[0], fArray2[1], false);
                this.showRoomAngleFeedback(this.newRoom, fArray.length - 1);
                planView.setDimensionLinesFeedback(this.getTriangulationDimensionLines(this.newRoom, fArray.length - 1));
                float[] fArray3 = fArray[fArray.length - 2];
                planView.makePointVisible(fArray3[0], fArray3[1]);
                planView.makePointVisible(fArray2[0], fArray2[1]);
            }
        }

        @Override
        public void toggleMagnetism(boolean bl) {
            this.magnetismEnabled = PlanController.this.preferences.isMagnetismEnabled() ^ bl;
            if (this.newRoom != null) {
                this.moveMouse(PlanController.this.getXLastMouseMove(), PlanController.this.getYLastMouseMove());
            }
        }

        @Override
        public void setAlignmentActivated(boolean bl) {
            this.alignmentActivated = bl;
            this.moveMouse(PlanController.this.getXLastMouseMove(), PlanController.this.getYLastMouseMove());
        }

        @Override
        public void escape() {
            if (this.newRoom != null && this.newPoint == null) {
                this.newRoom.removePoint(this.newRoom.getPointCount() - 1);
            }
            this.validateDrawnRoom();
        }

        @Override
        public void exit() {
            PlanController.this.getView().deleteFeedback();
            this.newRoom = null;
            this.newPoint = null;
            this.oldSelection = null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private abstract class AbstractRoomState
    extends ControllerState {
        private String roomSideLengthToolTipFeedback;
        private String roomDiagonalLengthToolTipFeedback;
        private String roomSideAngleToolTipFeedback;

        private AbstractRoomState() {
        }

        @Override
        public void enter() {
            this.roomSideLengthToolTipFeedback = PlanController.this.preferences.getLocalizedString(PlanController.class, "roomSideLengthToolTipFeedback", new Object[0]);
            try {
                this.roomDiagonalLengthToolTipFeedback = PlanController.this.preferences.getLocalizedString(PlanController.class, "roomDiagonalLengthToolTipFeedback", new Object[0]);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            try {
                this.roomSideAngleToolTipFeedback = PlanController.this.preferences.getLocalizedString(PlanController.class, "roomSideAngleToolTipFeedback", new Object[0]);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }

        protected String getToolTipFeedbackText(Room room, int n) {
            float f = this.getRoomSideLength(room, n);
            int n2 = this.getRoomSideAngle(room, n);
            String string = "<html>" + String.format(this.roomSideLengthToolTipFeedback, PlanController.this.preferences.getLengthUnit().getFormatWithUnit().format(Float.valueOf(f)));
            if (this.roomDiagonalLengthToolTipFeedback != null && this.roomDiagonalLengthToolTipFeedback.length() > 0 && room.getPointCount() > 2) {
                float f2 = this.getRoomDiagonalLength(room, n);
                string = string + "<br>" + String.format(this.roomDiagonalLengthToolTipFeedback, PlanController.this.preferences.getLengthUnit().getFormatWithUnit().format(Float.valueOf(f2)));
            }
            if (this.roomSideAngleToolTipFeedback != null && this.roomSideAngleToolTipFeedback.length() > 0) {
                string = string + "<br>" + String.format(this.roomSideAngleToolTipFeedback, n2);
            }
            return string;
        }

        protected float getRoomSideLength(Room room, int n) {
            float[][] fArray = room.getPoints();
            float[] fArray2 = fArray[(n + fArray.length - 1) % fArray.length];
            return (float)Point2D.distance(fArray2[0], fArray2[1], fArray[n][0], fArray[n][1]);
        }

        protected float getRoomDiagonalLength(Room room, int n) {
            float[][] fArray = room.getPoints();
            if (fArray.length > 2) {
                float[] fArray2 = fArray[(n + fArray.length - 2) % fArray.length];
                return (float)Point2D.distance(fArray[n][0], fArray[n][1], fArray2[0], fArray2[1]);
            }
            throw new IllegalArgumentException("Room doesn't have at least 3 points");
        }

        protected List<DimensionLine> getTriangulationDimensionLines(Room room, int n) {
            float[][] fArray = room.getPoints();
            float[] fArray2 = fArray[(n + fArray.length - 1) % fArray.length];
            ArrayList<DimensionLine> arrayList = new ArrayList<DimensionLine>(3);
            float f = 20.0f / PlanController.this.getView().getScale();
            if (!Arrays.equals(fArray[n], fArray2)) {
                arrayList.add(PlanController.this.getDimensionLineBetweenPoints(fArray2, fArray[n], this.isDimensionInsideRoom(room, fArray2, fArray[n]) ? -f : f, false));
            }
            if (fArray.length > 2) {
                float[] fArray3 = fArray[n + 1 < fArray.length ? n + 1 : 0];
                if (!Arrays.equals(fArray[n], fArray3)) {
                    arrayList.add(PlanController.this.getDimensionLineBetweenPoints(fArray[n], fArray3, this.isDimensionInsideRoom(room, fArray[n], fArray3) ? -f : f, false));
                }
                float[] fArray4 = fArray[(n + fArray.length - 2) % fArray.length];
                if (fArray.length == 3) {
                    arrayList.add(PlanController.this.getDimensionLineBetweenPoints(fArray2, fArray4, this.isDimensionInsideRoom(room, fArray2, fArray4) ? -f : f, false));
                } else if (!Arrays.equals(fArray[n], fArray4)) {
                    arrayList.add(PlanController.this.getDimensionLineBetweenPoints(fArray[n], fArray4, 0.0f, false));
                }
            }
            return arrayList;
        }

        private boolean isDimensionInsideRoom(Room room, float[] fArray, float[] fArray2) {
            AffineTransform affineTransform = AffineTransform.getRotateInstance(Math.atan2(fArray2[1] - fArray[1], fArray2[0] - fArray[0]), fArray[0], fArray[1]);
            float[] fArray3 = new float[]{(float)((double)fArray[0] + Point2D.distance(fArray[0], fArray[1], fArray2[0], fArray2[1]) / 2.0), fArray[1] + 1.0f};
            affineTransform.transform(fArray3, 0, fArray3, 0, 1);
            return room.containsPoint(fArray3[0], fArray3[1], 0.0f);
        }

        protected Integer getRoomSideAngle(Room room, int n) {
            float[][] fArray = room.getPoints();
            float[] fArray2 = fArray[n];
            float[] fArray3 = fArray[(n + fArray.length - 1) % fArray.length];
            float[] fArray4 = fArray[(n + fArray.length - 2) % fArray.length];
            float f = (float)Point2D.distance(fArray3[0], fArray3[1], fArray[n][0], fArray[n][1]);
            float f2 = (float)Point2D.distance(fArray4[0], fArray4[1], fArray3[0], fArray3[1]);
            if (fArray4 != fArray2 && f != 0.0f && f2 != 0.0f) {
                float f3 = (fArray2[1] - fArray3[1]) / f;
                float f4 = (fArray3[0] - fArray4[0]) / f2;
                float f5 = (fArray2[0] - fArray3[0]) / f;
                float f6 = (fArray3[1] - fArray4[1]) / f2;
                int n2 = (int)Math.round(180.0 - Math.toDegrees(Math.atan2(f3 * f4 - f5 * f6, f5 * f4 + f3 * f6)));
                if (n2 > 180) {
                    n2 -= 360;
                }
                return n2;
            }
            if (f == 0.0f) {
                return 0;
            }
            return (int)Math.round(Math.toDegrees(Math.atan2(fArray3[1] - fArray2[1], fArray2[0] - fArray3[0])));
        }

        protected void showRoomAngleFeedback(Room room, int n) {
            float[][] fArray = room.getPoints();
            if (this.roomSideAngleToolTipFeedback != null && this.roomSideAngleToolTipFeedback.length() > 0 && fArray.length > 2) {
                float[] fArray2 = fArray[(n + fArray.length - 1) % fArray.length];
                float[] fArray3 = fArray[(n + fArray.length - 2) % fArray.length];
                if (this.getRoomSideAngle(room, n) > 0) {
                    PlanController.this.getView().setAngleFeedback(fArray2[0], fArray2[1], fArray3[0], fArray3[1], fArray[n][0], fArray[n][1]);
                } else {
                    PlanController.this.getView().setAngleFeedback(fArray2[0], fArray2[1], fArray[n][0], fArray[n][1], fArray3[0], fArray3[1]);
                }
            }
        }
    }

    private class RoomCreationState
    extends AbstractModeChangeState {
        private boolean magnetismEnabled;

        private RoomCreationState() {
        }

        public Mode getMode() {
            return Mode.ROOM_CREATION;
        }

        public void enter() {
            PlanController.this.getView().setCursor(PlanView.CursorType.DRAW);
            this.toggleMagnetism(PlanController.this.wasMagnetismToggledLastMousePress());
        }

        public void moveMouse(float f, float f2) {
            if (this.magnetismEnabled) {
                PointMagnetizedToClosestWallOrRoomPoint pointMagnetizedToClosestWallOrRoomPoint = new PointMagnetizedToClosestWallOrRoomPoint(f, f2);
                if (pointMagnetizedToClosestWallOrRoomPoint.isMagnetized()) {
                    PlanController.this.getView().setAlignmentFeedback(Room.class, null, pointMagnetizedToClosestWallOrRoomPoint.getX(), pointMagnetizedToClosestWallOrRoomPoint.getY(), pointMagnetizedToClosestWallOrRoomPoint.isMagnetized());
                } else {
                    RoomPointWithAngleMagnetism roomPointWithAngleMagnetism = new RoomPointWithAngleMagnetism(null, -1, PlanController.this.getXLastMouseMove(), PlanController.this.getYLastMouseMove(), PlanController.this.getXLastMouseMove(), PlanController.this.getYLastMouseMove());
                    PlanController.this.getView().setAlignmentFeedback(Room.class, null, roomPointWithAngleMagnetism.getX(), roomPointWithAngleMagnetism.getY(), pointMagnetizedToClosestWallOrRoomPoint.isMagnetized());
                }
            } else {
                PlanController.this.getView().setAlignmentFeedback(Room.class, null, f, f2, false);
            }
        }

        public void pressMouse(float f, float f2, int n, boolean bl, boolean bl2) {
            PlanController.this.setState(PlanController.this.getRoomDrawingState());
        }

        public void setEditionActivated(boolean bl) {
            if (bl) {
                PlanController.this.setState(PlanController.this.getRoomDrawingState());
                PlanController.this.setEditionActivated(bl);
            }
        }

        public void toggleMagnetism(boolean bl) {
            this.magnetismEnabled = PlanController.this.preferences.isMagnetismEnabled() ^ bl;
            if (PlanController.this.getPointerTypeLastMousePress() != View.PointerType.TOUCH) {
                this.moveMouse(PlanController.this.getXLastMouseMove(), PlanController.this.getYLastMouseMove());
            }
        }

        public void exit() {
            PlanController.this.getView().deleteFeedback();
        }
    }

    private class DimensionLineOffsetState
    extends ControllerState {
        private DimensionLine selectedDimensionLine;
        private float oldOffset;
        private float deltaXToOffsetPoint;
        private float deltaYToOffsetPoint;

        private DimensionLineOffsetState() {
        }

        public Mode getMode() {
            return Mode.SELECTION;
        }

        public boolean isModificationState() {
            return true;
        }

        public boolean isBasePlanModificationState() {
            return true;
        }

        public void enter() {
            this.selectedDimensionLine = (DimensionLine)PlanController.this.home.getSelectedItems().get(0);
            this.oldOffset = this.selectedDimensionLine.getOffset();
            double d = Math.atan2(this.selectedDimensionLine.getYEnd() - this.selectedDimensionLine.getYStart(), this.selectedDimensionLine.getXEnd() - this.selectedDimensionLine.getXStart());
            float f = (float)(-Math.sin(d)) * this.oldOffset;
            float f2 = (float)Math.cos(d) * this.oldOffset;
            float f3 = (this.selectedDimensionLine.getXStart() + this.selectedDimensionLine.getXEnd()) / 2.0f + f;
            float f4 = (this.selectedDimensionLine.getYStart() + this.selectedDimensionLine.getYEnd()) / 2.0f + f2;
            this.deltaXToOffsetPoint = PlanController.this.getXLastMousePress() - f3;
            this.deltaYToOffsetPoint = PlanController.this.getYLastMousePress() - f4;
            PlanView planView = PlanController.this.getView();
            planView.setResizeIndicatorVisible(true);
        }

        public void moveMouse(float f, float f2) {
            float f3 = f - this.deltaXToOffsetPoint;
            float f4 = f2 - this.deltaYToOffsetPoint;
            float f5 = (float)Line2D.ptLineDist(this.selectedDimensionLine.getXStart(), this.selectedDimensionLine.getYStart(), this.selectedDimensionLine.getXEnd(), this.selectedDimensionLine.getYEnd(), f3, f4);
            int n = Line2D.relativeCCW(this.selectedDimensionLine.getXStart(), this.selectedDimensionLine.getYStart(), this.selectedDimensionLine.getXEnd(), this.selectedDimensionLine.getYEnd(), f3, f4);
            this.selectedDimensionLine.setOffset(-Math.signum(n) * f5);
            PlanController.this.getView().makePointVisible(f, f2);
        }

        public void releaseMouse(float f, float f2) {
            PlanController.this.postDimensionLineOffset(this.selectedDimensionLine, this.oldOffset);
            PlanController.this.setState(PlanController.this.getSelectionState());
        }

        public void escape() {
            this.selectedDimensionLine.setOffset(this.oldOffset);
            PlanController.this.setState(PlanController.this.getSelectionState());
        }

        public void exit() {
            PlanController.this.getView().setResizeIndicatorVisible(false);
            this.selectedDimensionLine = null;
        }
    }

    private class DimensionLineResizeState
    extends ControllerState {
        private DimensionLine selectedDimensionLine;
        private boolean editingStartPoint;
        private float oldX;
        private float oldY;
        private boolean reversedDimensionLine;
        private float deltaXToResizePoint;
        private float deltaYToResizePoint;
        private float distanceFromResizePointToDimensionBaseLine;
        private boolean magnetismEnabled;
        private boolean alignmentActivated;

        private DimensionLineResizeState() {
        }

        public Mode getMode() {
            return Mode.SELECTION;
        }

        public boolean isModificationState() {
            return true;
        }

        public boolean isBasePlanModificationState() {
            return true;
        }

        public void enter() {
            float f;
            float f2;
            PlanView planView = PlanController.this.getView();
            planView.setResizeIndicatorVisible(true);
            this.selectedDimensionLine = (DimensionLine)PlanController.this.home.getSelectedItems().get(0);
            boolean bl = this.editingStartPoint = this.selectedDimensionLine == PlanController.this.getResizedDimensionLineStartAt(PlanController.this.getXLastMousePress(), PlanController.this.getYLastMousePress());
            if (this.editingStartPoint) {
                this.oldX = this.selectedDimensionLine.getXStart();
                this.oldY = this.selectedDimensionLine.getYStart();
            } else {
                this.oldX = this.selectedDimensionLine.getXEnd();
                this.oldY = this.selectedDimensionLine.getYEnd();
            }
            this.reversedDimensionLine = false;
            float f3 = (this.selectedDimensionLine.getYEnd() - this.selectedDimensionLine.getYStart()) / (this.selectedDimensionLine.getXEnd() - this.selectedDimensionLine.getXStart());
            if ((double)Math.abs(f3) > 100000.0) {
                f2 = PlanController.this.getXLastMousePress();
                f = this.editingStartPoint ? this.selectedDimensionLine.getYStart() : this.selectedDimensionLine.getYEnd();
            } else if (this.selectedDimensionLine.getYStart() == this.selectedDimensionLine.getYEnd()) {
                f2 = this.editingStartPoint ? this.selectedDimensionLine.getXStart() : this.selectedDimensionLine.getXEnd();
                f = PlanController.this.getYLastMousePress();
            } else {
                float f4 = PlanController.this.getYLastMousePress() - f3 * PlanController.this.getXLastMousePress();
                float f5 = -1.0f / f3;
                float f6 = this.editingStartPoint ? this.selectedDimensionLine.getYStart() - f5 * this.selectedDimensionLine.getXStart() : this.selectedDimensionLine.getYEnd() - f5 * this.selectedDimensionLine.getXEnd();
                f2 = (f6 - f4) / (f3 - f5);
                f = f3 * f2 + f4;
            }
            this.deltaXToResizePoint = PlanController.this.getXLastMousePress() - f2;
            this.deltaYToResizePoint = PlanController.this.getYLastMousePress() - f;
            if (this.editingStartPoint) {
                this.distanceFromResizePointToDimensionBaseLine = (float)Point2D.distance(f2, f, this.selectedDimensionLine.getXStart(), this.selectedDimensionLine.getYStart());
                planView.setAlignmentFeedback(DimensionLine.class, this.selectedDimensionLine, this.selectedDimensionLine.getXStart(), this.selectedDimensionLine.getYStart(), false);
            } else {
                this.distanceFromResizePointToDimensionBaseLine = (float)Point2D.distance(f2, f, this.selectedDimensionLine.getXEnd(), this.selectedDimensionLine.getYEnd());
                planView.setAlignmentFeedback(DimensionLine.class, this.selectedDimensionLine, this.selectedDimensionLine.getXEnd(), this.selectedDimensionLine.getYEnd(), false);
            }
            this.alignmentActivated = PlanController.this.wasAlignmentActivatedLastMousePress();
            this.toggleMagnetism(PlanController.this.wasMagnetismToggledLastMousePress());
        }

        public void moveMouse(float f, float f2) {
            PlanView planView = PlanController.this.getView();
            float f3 = f - this.deltaXToResizePoint;
            float f4 = f2 - this.deltaYToResizePoint;
            if (this.editingStartPoint) {
                double d = Point2D.distance(f3, f4, this.selectedDimensionLine.getXEnd(), this.selectedDimensionLine.getYEnd());
                double d2 = Math.sqrt(d * d - (double)(this.distanceFromResizePointToDimensionBaseLine * this.distanceFromResizePointToDimensionBaseLine));
                if (d2 > 0.0) {
                    double d3 = -Math.atan2(this.distanceFromResizePointToDimensionBaseLine, d2);
                    if (this.selectedDimensionLine.getOffset() >= 0.0f) {
                        d3 = -d3;
                    }
                    double d4 = Math.atan2(f4 - this.selectedDimensionLine.getYEnd(), f3 - this.selectedDimensionLine.getXEnd());
                    double d5 = d3 + d4;
                    float f5 = this.selectedDimensionLine.getXEnd() + (float)(d2 * Math.cos(d5));
                    float f6 = this.selectedDimensionLine.getYEnd() + (float)(d2 * Math.sin(d5));
                    if (this.alignmentActivated || this.magnetismEnabled) {
                        PointWithAngleMagnetism pointWithAngleMagnetism = new PointWithAngleMagnetism(this.selectedDimensionLine.getXEnd(), this.selectedDimensionLine.getYEnd(), f5, f6, PlanController.this.preferences.getLengthUnit(), planView.getPixelLength());
                        f5 = pointWithAngleMagnetism.getX();
                        f6 = pointWithAngleMagnetism.getY();
                    }
                    PlanController.moveDimensionLinePoint(this.selectedDimensionLine, f5, f6, this.editingStartPoint);
                    this.updateReversedDimensionLine();
                    planView.setAlignmentFeedback(DimensionLine.class, this.selectedDimensionLine, f5, f6, false);
                } else {
                    planView.deleteFeedback();
                }
            } else {
                double d = Point2D.distance(f3, f4, this.selectedDimensionLine.getXStart(), this.selectedDimensionLine.getYStart());
                double d6 = Math.sqrt(d * d - (double)(this.distanceFromResizePointToDimensionBaseLine * this.distanceFromResizePointToDimensionBaseLine));
                if (d6 > 0.0) {
                    double d7 = Math.atan2(this.distanceFromResizePointToDimensionBaseLine, d6);
                    if (this.selectedDimensionLine.getOffset() >= 0.0f) {
                        d7 = -d7;
                    }
                    double d8 = Math.atan2(f4 - this.selectedDimensionLine.getYStart(), f3 - this.selectedDimensionLine.getXStart());
                    double d9 = d7 + d8;
                    float f7 = this.selectedDimensionLine.getXStart() + (float)(d6 * Math.cos(d9));
                    float f8 = this.selectedDimensionLine.getYStart() + (float)(d6 * Math.sin(d9));
                    if (this.alignmentActivated || this.magnetismEnabled) {
                        PointWithAngleMagnetism pointWithAngleMagnetism = new PointWithAngleMagnetism(this.selectedDimensionLine.getXStart(), this.selectedDimensionLine.getYStart(), f7, f8, PlanController.this.preferences.getLengthUnit(), planView.getPixelLength());
                        f7 = pointWithAngleMagnetism.getX();
                        f8 = pointWithAngleMagnetism.getY();
                    }
                    PlanController.moveDimensionLinePoint(this.selectedDimensionLine, f7, f8, this.editingStartPoint);
                    this.updateReversedDimensionLine();
                    planView.setAlignmentFeedback(DimensionLine.class, this.selectedDimensionLine, f7, f8, false);
                } else {
                    planView.deleteFeedback();
                }
            }
            PlanController.this.getView().makePointVisible(f, f2);
        }

        private void updateReversedDimensionLine() {
            double d = this.getDimensionLineAngle();
            if (d < -1.5707963267948966 || d > 1.5707963267948966) {
                PlanController.reverseDimensionLine(this.selectedDimensionLine);
                this.editingStartPoint = !this.editingStartPoint;
                this.reversedDimensionLine = !this.reversedDimensionLine;
            }
        }

        private double getDimensionLineAngle() {
            if (this.selectedDimensionLine.getLength() == 0.0f) {
                return 0.0;
            }
            return Math.atan2(this.selectedDimensionLine.getYStart() - this.selectedDimensionLine.getYEnd(), this.selectedDimensionLine.getXEnd() - this.selectedDimensionLine.getXStart());
        }

        public void releaseMouse(float f, float f2) {
            PlanController.this.postDimensionLineResize(this.selectedDimensionLine, this.oldX, this.oldY, this.editingStartPoint, this.reversedDimensionLine);
            PlanController.this.setState(PlanController.this.getSelectionState());
        }

        public void toggleMagnetism(boolean bl) {
            this.magnetismEnabled = PlanController.this.preferences.isMagnetismEnabled() ^ bl;
            this.moveMouse(PlanController.this.getXLastMouseMove(), PlanController.this.getYLastMouseMove());
        }

        public void setAlignmentActivated(boolean bl) {
            this.alignmentActivated = bl;
            this.moveMouse(PlanController.this.getXLastMouseMove(), PlanController.this.getYLastMouseMove());
        }

        public void escape() {
            if (this.reversedDimensionLine) {
                PlanController.reverseDimensionLine(this.selectedDimensionLine);
                this.editingStartPoint = !this.editingStartPoint;
            }
            PlanController.moveDimensionLinePoint(this.selectedDimensionLine, this.oldX, this.oldY, this.editingStartPoint);
            PlanController.this.setState(PlanController.this.getSelectionState());
        }

        public void exit() {
            PlanView planView = PlanController.this.getView();
            planView.deleteFeedback();
            planView.setResizeIndicatorVisible(false);
            this.selectedDimensionLine = null;
        }
    }

    private class DimensionLineDrawingState
    extends ControllerState {
        private float xStart;
        private float yStart;
        private boolean editingStartPoint;
        private DimensionLine newDimensionLine;
        private List<Selectable> oldSelection;
        private boolean oldBasePlanLocked;
        private boolean oldAllLevelsSelection;
        private boolean magnetismEnabled;
        private boolean alignmentActivated;
        private boolean offsetChoice;

        private DimensionLineDrawingState() {
        }

        public Mode getMode() {
            return Mode.DIMENSION_LINE_CREATION;
        }

        public boolean isModificationState() {
            return true;
        }

        public boolean isBasePlanModificationState() {
            return true;
        }

        public void setMode(Mode mode) {
            this.escape();
            if (mode == Mode.SELECTION) {
                PlanController.this.setState(PlanController.this.getSelectionState());
            } else if (mode == Mode.PANNING) {
                PlanController.this.setState(PlanController.this.getPanningState());
            } else if (mode == Mode.WALL_CREATION) {
                PlanController.this.setState(PlanController.this.getWallCreationState());
            } else if (mode == Mode.ROOM_CREATION) {
                PlanController.this.setState(PlanController.this.getRoomCreationState());
            } else if (mode == Mode.POLYLINE_CREATION) {
                PlanController.this.setState(PlanController.this.getPolylineCreationState());
            } else if (mode == Mode.LABEL_CREATION) {
                PlanController.this.setState(PlanController.this.getLabelCreationState());
            }
        }

        public void enter() {
            this.oldSelection = PlanController.this.home.getSelectedItems();
            this.oldBasePlanLocked = PlanController.this.home.isBasePlanLocked();
            this.oldAllLevelsSelection = PlanController.this.home.isAllLevelsSelection();
            this.xStart = PlanController.this.getXLastMouseMove();
            this.yStart = PlanController.this.getYLastMouseMove();
            this.editingStartPoint = false;
            this.offsetChoice = false;
            this.newDimensionLine = null;
            PlanController.this.deselectAll();
            this.alignmentActivated = PlanController.this.wasAlignmentActivatedLastMousePress();
            this.toggleMagnetism(PlanController.this.wasMagnetismToggledLastMousePress());
            DimensionLine dimensionLine = PlanController.this.getMeasuringDimensionLineAt(PlanController.this.getXLastMousePress(), PlanController.this.getYLastMousePress(), this.magnetismEnabled);
            if (dimensionLine != null) {
                PlanController.this.getView().setDimensionLinesFeedback(Arrays.asList(dimensionLine));
            }
            PlanController.this.getView().setAlignmentFeedback(DimensionLine.class, null, PlanController.this.getXLastMousePress(), PlanController.this.getYLastMousePress(), false);
        }

        public void moveMouse(float f, float f2) {
            PlanView planView = PlanController.this.getView();
            planView.deleteFeedback();
            if (this.offsetChoice) {
                float f3 = (float)Line2D.ptLineDist(this.newDimensionLine.getXStart(), this.newDimensionLine.getYStart(), this.newDimensionLine.getXEnd(), this.newDimensionLine.getYEnd(), f, f2);
                if (this.newDimensionLine.getLength() > 0.0f) {
                    int n = Line2D.relativeCCW(this.newDimensionLine.getXStart(), this.newDimensionLine.getYStart(), this.newDimensionLine.getXEnd(), this.newDimensionLine.getYEnd(), f, f2);
                    this.newDimensionLine.setOffset(-Math.signum(n) * f3);
                }
            } else {
                float f4;
                float f5;
                if (this.magnetismEnabled || this.alignmentActivated) {
                    PointWithAngleMagnetism pointWithAngleMagnetism = new PointWithAngleMagnetism(this.xStart, this.yStart, f, f2, PlanController.this.preferences.getLengthUnit(), planView.getPixelLength());
                    f5 = pointWithAngleMagnetism.getX();
                    f4 = pointWithAngleMagnetism.getY();
                } else {
                    f5 = f;
                    f4 = f2;
                }
                if (this.newDimensionLine == null) {
                    this.newDimensionLine = PlanController.this.createDimensionLine(this.xStart, this.yStart, f5, f4, 0.0f);
                    PlanController.this.getView().setDimensionLinesFeedback(null);
                } else if (this.editingStartPoint) {
                    this.newDimensionLine.setXStart(f5);
                    this.newDimensionLine.setYStart(f4);
                } else {
                    this.newDimensionLine.setXEnd(f5);
                    this.newDimensionLine.setYEnd(f4);
                }
                this.updateReversedDimensionLine();
                planView.setAlignmentFeedback(DimensionLine.class, this.newDimensionLine, f5, f4, false);
            }
            planView.makePointVisible(f, f2);
        }

        private void updateReversedDimensionLine() {
            boolean bl;
            double d = this.getDimensionLineAngle();
            boolean bl2 = bl = d < -1.5707963267948966 || d > 1.5707963267948966;
            if (bl ^ this.editingStartPoint) {
                PlanController.reverseDimensionLine(this.newDimensionLine);
                this.editingStartPoint = !this.editingStartPoint;
            }
        }

        private double getDimensionLineAngle() {
            if (this.newDimensionLine.getLength() == 0.0f) {
                return 0.0;
            }
            if (this.editingStartPoint) {
                return Math.atan2(this.yStart - this.newDimensionLine.getYStart(), this.newDimensionLine.getXStart() - this.xStart);
            }
            return Math.atan2(this.yStart - this.newDimensionLine.getYEnd(), this.newDimensionLine.getXEnd() - this.xStart);
        }

        public void pressMouse(float f, float f2, int n, boolean bl, boolean bl2) {
            Object object;
            if (this.newDimensionLine == null && n == 2) {
                object = PlanController.this.getMeasuringDimensionLineAt(f, f2, this.magnetismEnabled);
                if (object != null) {
                    this.newDimensionLine = PlanController.this.createDimensionLine(((DimensionLine)object).getXStart(), ((DimensionLine)object).getYStart(), ((DimensionLine)object).getXEnd(), ((DimensionLine)object).getYEnd(), ((DimensionLine)object).getOffset());
                    if (PlanController.this.getPointerTypeLastMousePress() == View.PointerType.TOUCH) {
                        this.validateDrawnDimensionLine();
                    }
                } else {
                    PlanController.this.setState(PlanController.this.getDimensionLineCreationState());
                    return;
                }
            }
            if (this.newDimensionLine != null) {
                if (this.offsetChoice) {
                    this.validateDrawnDimensionLine();
                } else {
                    this.offsetChoice = true;
                    object = PlanController.this.getView();
                    object.setCursor(PlanView.CursorType.HEIGHT);
                    object.deleteFeedback();
                }
            }
        }

        public void releaseMouse(float f, float f2) {
            if (PlanController.this.getPointerTypeLastMousePress() == View.PointerType.TOUCH && this.newDimensionLine != null) {
                this.validateDrawnDimensionLine();
            }
        }

        private void validateDrawnDimensionLine() {
            PlanController.this.selectItem(this.newDimensionLine);
            PlanController.this.postCreateDimensionLines(Arrays.asList(this.newDimensionLine), this.oldSelection, this.oldBasePlanLocked, this.oldAllLevelsSelection);
            this.newDimensionLine = null;
            if (PlanController.this.getPointerTypeLastMousePress() == View.PointerType.TOUCH) {
                PlanController.this.setState(PlanController.this.getSelectionState());
            } else {
                PlanController.this.setState(PlanController.this.getDimensionLineCreationState());
            }
        }

        public void setEditionActivated(boolean bl) {
            PlanView planView = PlanController.this.getView();
            if (bl) {
                planView.deleteFeedback();
                if (this.newDimensionLine == null) {
                    planView.setToolTipEditedProperties(new EditableProperty[]{EditableProperty.X, EditableProperty.Y}, new Object[]{Float.valueOf(this.xStart), Float.valueOf(this.yStart)}, this.xStart, this.yStart);
                } else if (this.offsetChoice) {
                    planView.setToolTipEditedProperties(new EditableProperty[]{EditableProperty.OFFSET}, new Object[]{Float.valueOf(this.newDimensionLine.getOffset())}, this.newDimensionLine.getXEnd(), this.newDimensionLine.getYEnd());
                } else {
                    planView.setToolTipEditedProperties(new EditableProperty[]{EditableProperty.LENGTH, EditableProperty.ANGLE}, new Object[]{Float.valueOf(this.newDimensionLine.getLength()), (int)Math.round(Math.toDegrees(this.getDimensionLineAngle()))}, this.newDimensionLine.getXEnd(), this.newDimensionLine.getYEnd());
                }
                this.showDimensionLineFeedback();
            } else if (this.newDimensionLine == null) {
                LengthUnit lengthUnit = PlanController.this.preferences.getLengthUnit();
                float f = lengthUnit.isMetric() ? 100.0f : LengthUnit.footToCentimeter(3.0f);
                this.newDimensionLine = PlanController.this.createDimensionLine(this.xStart, this.yStart, this.xStart + f, this.yStart, 0.0f);
                planView.deleteFeedback();
                this.setEditionActivated(true);
            } else if (this.offsetChoice) {
                this.validateDrawnDimensionLine();
            } else {
                this.offsetChoice = true;
                this.setEditionActivated(true);
            }
        }

        public void updateEditableProperty(EditableProperty editableProperty, Object object) {
            float f = PlanController.this.preferences.getLengthUnit().getMaximumLength();
            if (this.newDimensionLine == null) {
                switch (editableProperty) {
                    case X: {
                        this.xStart = object != null ? ((Number)object).floatValue() : 0.0f;
                        this.xStart = Math.max(-f, Math.min(this.xStart, f));
                        break;
                    }
                    case Y: {
                        this.yStart = object != null ? ((Number)object).floatValue() : 0.0f;
                        this.yStart = Math.max(-f, Math.min(this.yStart, f));
                    }
                }
            } else if (this.offsetChoice) {
                if (editableProperty == EditableProperty.OFFSET) {
                    float f2 = object != null ? ((Number)object).floatValue() : 0.0f;
                    f2 = Math.max(-f, Math.min(f2, f));
                    this.newDimensionLine.setOffset(f2);
                }
            } else {
                float f3;
                float f4;
                switch (editableProperty) {
                    case LENGTH: {
                        float f5 = object != null ? ((Number)object).floatValue() : 0.0f;
                        f5 = Math.max(0.001f, Math.min(f5, f));
                        double d = this.getDimensionLineAngle();
                        f4 = (float)((double)this.xStart + (double)f5 * Math.cos(d));
                        f3 = (float)((double)this.yStart - (double)f5 * Math.sin(d));
                        break;
                    }
                    case ANGLE: {
                        double d = Math.toRadians(object != null ? (double)((Number)object).floatValue() : 0.0);
                        float f6 = this.newDimensionLine.getLength();
                        f4 = (float)((double)this.xStart + (double)f6 * Math.cos(d));
                        f3 = (float)((double)this.yStart - (double)f6 * Math.sin(d));
                        break;
                    }
                    default: {
                        return;
                    }
                }
                if (this.editingStartPoint) {
                    this.newDimensionLine.setXStart(f4);
                    this.newDimensionLine.setYStart(f3);
                } else {
                    this.newDimensionLine.setXEnd(f4);
                    this.newDimensionLine.setYEnd(f3);
                }
            }
            this.showDimensionLineFeedback();
        }

        private void showDimensionLineFeedback() {
            PlanView planView = PlanController.this.getView();
            if (this.newDimensionLine == null) {
                planView.setAlignmentFeedback(DimensionLine.class, null, this.xStart, this.yStart, true);
                planView.makePointVisible(this.xStart, this.yStart);
            } else if (!this.offsetChoice) {
                float f;
                float f2;
                if (this.editingStartPoint) {
                    f2 = this.newDimensionLine.getXStart();
                    f = this.newDimensionLine.getYStart();
                } else {
                    f2 = this.newDimensionLine.getXEnd();
                    f = this.newDimensionLine.getYEnd();
                }
                this.updateReversedDimensionLine();
                planView.setAlignmentFeedback(DimensionLine.class, this.newDimensionLine, f2, f, false);
                planView.makePointVisible(this.xStart, this.yStart);
                planView.makePointVisible(f2, f);
            }
        }

        public void toggleMagnetism(boolean bl) {
            this.magnetismEnabled = PlanController.this.preferences.isMagnetismEnabled() ^ bl;
            if (this.newDimensionLine != null && !this.offsetChoice) {
                this.moveMouse(PlanController.this.getXLastMouseMove(), PlanController.this.getYLastMouseMove());
            }
        }

        public void setAlignmentActivated(boolean bl) {
            this.alignmentActivated = bl;
            this.moveMouse(PlanController.this.getXLastMouseMove(), PlanController.this.getYLastMouseMove());
        }

        public void escape() {
            if (this.newDimensionLine != null) {
                PlanController.this.home.deleteDimensionLine(this.newDimensionLine);
            }
            if (PlanController.this.getPointerTypeLastMousePress() == View.PointerType.TOUCH) {
                PlanController.this.setState(PlanController.this.getSelectionState());
            } else {
                PlanController.this.setState(PlanController.this.getDimensionLineCreationState());
            }
        }

        public void exit() {
            PlanController.this.getView().deleteFeedback();
            this.newDimensionLine = null;
            this.oldSelection = null;
        }
    }

    private class DimensionLineCreationState
    extends AbstractModeChangeState {
        private boolean magnetismEnabled;

        private DimensionLineCreationState() {
        }

        public Mode getMode() {
            return Mode.DIMENSION_LINE_CREATION;
        }

        public void enter() {
            PlanController.this.getView().setCursor(PlanView.CursorType.DRAW);
            this.toggleMagnetism(PlanController.this.wasMagnetismToggledLastMousePress());
        }

        public void moveMouse(float f, float f2) {
            PlanController.this.getView().setAlignmentFeedback(DimensionLine.class, null, f, f2, false);
            DimensionLine dimensionLine = PlanController.this.getMeasuringDimensionLineAt(f, f2, this.magnetismEnabled);
            if (dimensionLine != null) {
                PlanController.this.getView().setDimensionLinesFeedback(Arrays.asList(dimensionLine));
            } else {
                PlanController.this.getView().setDimensionLinesFeedback(null);
            }
        }

        public void pressMouse(float f, float f2, int n, boolean bl, boolean bl2) {
            if (n == 1) {
                PlanController.this.setState(PlanController.this.getDimensionLineDrawingState());
            }
        }

        public void setEditionActivated(boolean bl) {
            if (bl) {
                PlanController.this.setState(PlanController.this.getDimensionLineDrawingState());
                PlanController.this.setEditionActivated(bl);
            }
        }

        public void toggleMagnetism(boolean bl) {
            this.magnetismEnabled = PlanController.this.preferences.isMagnetismEnabled() ^ bl;
            if (PlanController.this.getPointerTypeLastMousePress() != View.PointerType.TOUCH) {
                this.moveMouse(PlanController.this.getXLastMouseMove(), PlanController.this.getYLastMouseMove());
            }
        }

        public void exit() {
            PlanController.this.getView().deleteFeedback();
        }
    }

    private class CameraElevationState
    extends ControllerState {
        private ObserverCamera selectedCamera;
        private float oldElevation;
        private String cameraElevationToolTipFeedback;
        private String observerHeightToolTipFeedback;

        private CameraElevationState() {
        }

        public Mode getMode() {
            return Mode.SELECTION;
        }

        public boolean isModificationState() {
            return true;
        }

        public void enter() {
            this.cameraElevationToolTipFeedback = PlanController.this.preferences.getLocalizedString(PlanController.class, "cameraElevationToolTipFeedback", new Object[0]);
            this.observerHeightToolTipFeedback = PlanController.this.preferences.getLocalizedString(PlanController.class, "observerHeightToolTipFeedback", new Object[0]);
            this.selectedCamera = (ObserverCamera)PlanController.this.home.getSelectedItems().get(0);
            this.oldElevation = this.selectedCamera.getZ();
            PlanView planView = PlanController.this.getView();
            planView.setResizeIndicatorVisible(true);
            planView.setToolTipFeedback(this.getToolTipFeedbackText(this.oldElevation), PlanController.this.getXLastMousePress(), PlanController.this.getYLastMousePress());
        }

        public void moveMouse(float f, float f2) {
            float f3 = this.oldElevation - (f2 - PlanController.this.getYLastMousePress());
            List<Level> list = PlanController.this.home.getLevels();
            float f4 = list.size() == 0 ? 10.0f : 10.0f + list.get(0).getElevation();
            f3 = Math.min(Math.max(f3, f4), PlanController.this.preferences.getLengthUnit().getMaximumElevation());
            this.selectedCamera.setZ(f3);
            PlanController.this.getView().setToolTipFeedback(this.getToolTipFeedbackText(f3), f, f2);
        }

        public void releaseMouse(float f, float f2) {
            PlanController.this.setState(PlanController.this.getSelectionState());
        }

        public void escape() {
            this.selectedCamera.setZ(this.oldElevation);
            PlanController.this.setState(PlanController.this.getSelectionState());
        }

        public void exit() {
            PlanView planView = PlanController.this.getView();
            planView.setResizeIndicatorVisible(false);
            planView.deleteFeedback();
            this.selectedCamera = null;
        }

        private String getToolTipFeedbackText(float f) {
            String string = "<html>" + String.format(this.cameraElevationToolTipFeedback, PlanController.this.preferences.getLengthUnit().getFormatWithUnit().format(Float.valueOf(f)));
            if (!this.selectedCamera.isFixedSize() && f >= 70.0f && f <= 218.75f) {
                string = string + "<br>" + String.format(this.observerHeightToolTipFeedback, PlanController.this.preferences.getLengthUnit().getFormatWithUnit().format(Float.valueOf(f * 15.0f / 14.0f)));
            }
            return string;
        }
    }

    private class CameraPitchRotationState
    extends ControllerState {
        private ObserverCamera selectedCamera;
        private float oldPitch;
        private String rotationToolTipFeedback;

        private CameraPitchRotationState() {
        }

        public Mode getMode() {
            return Mode.SELECTION;
        }

        public boolean isModificationState() {
            return true;
        }

        public void enter() {
            this.rotationToolTipFeedback = PlanController.this.preferences.getLocalizedString(PlanController.class, "cameraPitchRotationToolTipFeedback", new Object[0]);
            this.selectedCamera = (ObserverCamera)PlanController.this.home.getSelectedItems().get(0);
            this.oldPitch = this.selectedCamera.getPitch();
            PlanView planView = PlanController.this.getView();
            planView.setResizeIndicatorVisible(true);
            planView.setToolTipFeedback(this.getToolTipFeedbackText(this.oldPitch), PlanController.this.getXLastMousePress(), PlanController.this.getYLastMousePress());
        }

        public void moveMouse(float f, float f2) {
            float f3 = (float)((double)this.oldPitch + (double)(f2 - PlanController.this.getYLastMousePress()) * Math.cos(this.selectedCamera.getYaw()) * Math.PI / 360.0 - (double)(f - PlanController.this.getXLastMousePress()) * Math.sin(this.selectedCamera.getYaw()) * Math.PI / 360.0);
            f3 = Math.max(f3, -1.5707964f);
            f3 = Math.min(f3, 1.5707964f);
            this.selectedCamera.setPitch(f3);
            PlanController.this.getView().setToolTipFeedback(this.getToolTipFeedbackText(f3), f, f2);
        }

        public void releaseMouse(float f, float f2) {
            PlanController.this.setState(PlanController.this.getSelectionState());
        }

        public void escape() {
            this.selectedCamera.setPitch(this.oldPitch);
            PlanController.this.setState(PlanController.this.getSelectionState());
        }

        public void exit() {
            PlanView planView = PlanController.this.getView();
            planView.setResizeIndicatorVisible(false);
            planView.deleteFeedback();
            this.selectedCamera = null;
        }

        private String getToolTipFeedbackText(float f) {
            return String.format(this.rotationToolTipFeedback, Math.round(Math.toDegrees(f)) % 360L);
        }
    }

    private class CameraYawRotationState
    extends ControllerState {
        private ObserverCamera selectedCamera;
        private float oldYaw;
        private float xLastMouseMove;
        private float yLastMouseMove;
        private float angleLastMouseMove;
        private String rotationToolTipFeedback;

        private CameraYawRotationState() {
        }

        public Mode getMode() {
            return Mode.SELECTION;
        }

        public boolean isModificationState() {
            return true;
        }

        public void enter() {
            this.rotationToolTipFeedback = PlanController.this.preferences.getLocalizedString(PlanController.class, "cameraYawRotationToolTipFeedback", new Object[0]);
            this.selectedCamera = (ObserverCamera)PlanController.this.home.getSelectedItems().get(0);
            this.oldYaw = this.selectedCamera.getYaw();
            this.xLastMouseMove = PlanController.this.getXLastMousePress();
            this.yLastMouseMove = PlanController.this.getYLastMousePress();
            this.angleLastMouseMove = (float)Math.atan2(this.selectedCamera.getY() - this.yLastMouseMove, this.xLastMouseMove - this.selectedCamera.getX());
            PlanView planView = PlanController.this.getView();
            planView.setResizeIndicatorVisible(true);
            planView.setToolTipFeedback(this.getToolTipFeedbackText(this.oldYaw), PlanController.this.getXLastMousePress(), PlanController.this.getYLastMousePress());
        }

        public void moveMouse(float f, float f2) {
            if (f != this.selectedCamera.getX() || f2 != this.selectedCamera.getY()) {
                float f3 = (float)Math.atan2(this.selectedCamera.getY() - f2, f - this.selectedCamera.getX());
                float f4 = this.angleLastMouseMove - f3;
                float f5 = Math.signum((f2 - this.selectedCamera.getY()) * (this.xLastMouseMove - this.selectedCamera.getX()) - (this.yLastMouseMove - this.selectedCamera.getY()) * (f - this.selectedCamera.getX()));
                if (f5 < 0.0f && f4 > 0.0f) {
                    f4 -= (float)Math.PI * 2;
                } else if (f5 > 0.0f && f4 < 0.0f) {
                    f4 += (float)Math.PI * 2;
                }
                float f6 = this.selectedCamera.getYaw() + f4;
                this.selectedCamera.setYaw(f6);
                PlanController.this.getView().setToolTipFeedback(this.getToolTipFeedbackText(f6), f, f2);
                this.xLastMouseMove = f;
                this.yLastMouseMove = f2;
                this.angleLastMouseMove = f3;
            }
        }

        public void releaseMouse(float f, float f2) {
            PlanController.this.setState(PlanController.this.getSelectionState());
        }

        public void escape() {
            this.selectedCamera.setYaw(this.oldYaw);
            PlanController.this.setState(PlanController.this.getSelectionState());
        }

        public void exit() {
            PlanView planView = PlanController.this.getView();
            planView.setResizeIndicatorVisible(false);
            planView.deleteFeedback();
            this.selectedCamera = null;
        }

        private String getToolTipFeedbackText(float f) {
            return String.format(this.rotationToolTipFeedback, (Math.round(Math.toDegrees(f)) + 360L) % 360L);
        }
    }

    private class PieceOfFurnitureNameRotationState
    extends ControllerState {
        private static final int STEP_COUNT = 24;
        private HomePieceOfFurniture selectedPiece;
        private float oldNameAngle;
        private float angleMousePress;
        private boolean magnetismEnabled;
        private boolean alignmentActivated;

        private PieceOfFurnitureNameRotationState() {
        }

        public Mode getMode() {
            return Mode.SELECTION;
        }

        public boolean isModificationState() {
            return true;
        }

        public void enter() {
            this.selectedPiece = (HomePieceOfFurniture)PlanController.this.home.getSelectedItems().get(0);
            this.angleMousePress = (float)Math.atan2(this.selectedPiece.getY() + this.selectedPiece.getNameYOffset() - PlanController.this.getYLastMousePress(), PlanController.this.getXLastMousePress() - this.selectedPiece.getX() - this.selectedPiece.getNameXOffset());
            this.oldNameAngle = this.selectedPiece.getNameAngle();
            this.alignmentActivated = PlanController.this.wasAlignmentActivatedLastMousePress();
            this.magnetismEnabled = PlanController.this.preferences.isMagnetismEnabled() ^ PlanController.this.wasMagnetismToggledLastMousePress();
            PlanView planView = PlanController.this.getView();
            planView.setResizeIndicatorVisible(true);
        }

        public void moveMouse(float f, float f2) {
            if (f != this.selectedPiece.getX() + this.selectedPiece.getNameXOffset() || f2 != this.selectedPiece.getY() + this.selectedPiece.getNameYOffset()) {
                float f3 = (float)Math.atan2(this.selectedPiece.getY() + this.selectedPiece.getNameYOffset() - f2, f - this.selectedPiece.getX() - this.selectedPiece.getNameXOffset());
                float f4 = this.oldNameAngle - f3 + this.angleMousePress;
                if (this.alignmentActivated || this.magnetismEnabled) {
                    float f5 = 0.2617994f;
                    f4 = (float)Math.round(f4 / f5) * f5;
                }
                this.selectedPiece.setNameAngle(f4);
                PlanController.this.getView().makePointVisible(f, f2);
            }
        }

        public void releaseMouse(float f, float f2) {
            PlanController.this.postPieceOfFurnitureNameRotation(this.selectedPiece, this.oldNameAngle);
            PlanController.this.setState(PlanController.this.getSelectionState());
        }

        public void toggleMagnetism(boolean bl) {
            this.magnetismEnabled = PlanController.this.preferences.isMagnetismEnabled() ^ bl;
            this.moveMouse(PlanController.this.getXLastMouseMove(), PlanController.this.getYLastMouseMove());
        }

        public void setAlignmentActivated(boolean bl) {
            this.alignmentActivated = bl;
            this.moveMouse(PlanController.this.getXLastMouseMove(), PlanController.this.getYLastMouseMove());
        }

        public void escape() {
            this.selectedPiece.setNameAngle(this.oldNameAngle);
            PlanController.this.setState(PlanController.this.getSelectionState());
        }

        public void exit() {
            PlanController.this.getView().setResizeIndicatorVisible(false);
            this.selectedPiece = null;
        }
    }

    private class PieceOfFurnitureNameOffsetState
    extends ControllerState {
        private HomePieceOfFurniture selectedPiece;
        private float oldNameXOffset;
        private float oldNameYOffset;
        private float xLastMouseMove;
        private float yLastMouseMove;
        private boolean alignmentActivated;

        private PieceOfFurnitureNameOffsetState() {
        }

        public Mode getMode() {
            return Mode.SELECTION;
        }

        public boolean isModificationState() {
            return true;
        }

        public void enter() {
            this.selectedPiece = (HomePieceOfFurniture)PlanController.this.home.getSelectedItems().get(0);
            this.oldNameXOffset = this.selectedPiece.getNameXOffset();
            this.oldNameYOffset = this.selectedPiece.getNameYOffset();
            this.xLastMouseMove = PlanController.this.getXLastMousePress();
            this.yLastMouseMove = PlanController.this.getYLastMousePress();
            this.alignmentActivated = PlanController.this.wasAlignmentActivatedLastMousePress();
            PlanView planView = PlanController.this.getView();
            planView.setResizeIndicatorVisible(true);
        }

        public void moveMouse(float f, float f2) {
            if (this.alignmentActivated) {
                PointWithAngleMagnetism pointWithAngleMagnetism = new PointWithAngleMagnetism(PlanController.this.getXLastMousePress(), PlanController.this.getYLastMousePress(), f, f2, PlanController.this.preferences.getLengthUnit(), PlanController.this.getView().getPixelLength(), 4);
                f = pointWithAngleMagnetism.getX();
                f2 = pointWithAngleMagnetism.getY();
            }
            this.selectedPiece.setNameXOffset(this.selectedPiece.getNameXOffset() + f - this.xLastMouseMove);
            this.selectedPiece.setNameYOffset(this.selectedPiece.getNameYOffset() + f2 - this.yLastMouseMove);
            this.xLastMouseMove = f;
            this.yLastMouseMove = f2;
            PlanController.this.getView().makePointVisible(f, f2);
        }

        public void releaseMouse(float f, float f2) {
            PlanController.this.postPieceOfFurnitureNameOffset(this.selectedPiece, this.oldNameXOffset, this.oldNameYOffset);
            PlanController.this.setState(PlanController.this.getSelectionState());
        }

        public void escape() {
            this.selectedPiece.setNameXOffset(this.oldNameXOffset);
            this.selectedPiece.setNameYOffset(this.oldNameYOffset);
            PlanController.this.setState(PlanController.this.getSelectionState());
        }

        public void setAlignmentActivated(boolean bl) {
            this.alignmentActivated = bl;
            this.moveMouse(PlanController.this.getXLastMouseMove(), PlanController.this.getYLastMouseMove());
        }

        public void exit() {
            PlanController.this.getView().setResizeIndicatorVisible(false);
            this.selectedPiece = null;
        }
    }

    private class LightPowerModificationState
    extends ControllerState {
        private float deltaXToModificationPoint;
        private HomeLight selectedLight;
        private float oldPower;
        private String lightPowerToolTipFeedback;

        private LightPowerModificationState() {
        }

        public Mode getMode() {
            return Mode.SELECTION;
        }

        public boolean isModificationState() {
            return true;
        }

        public void enter() {
            this.lightPowerToolTipFeedback = PlanController.this.preferences.getLocalizedString(PlanController.class, "lightPowerToolTipFeedback", new Object[0]);
            this.selectedLight = (HomeLight)PlanController.this.home.getSelectedItems().get(0);
            float[] fArray = this.selectedLight.getPoints()[3];
            this.deltaXToModificationPoint = PlanController.this.getXLastMousePress() - fArray[0];
            this.oldPower = this.selectedLight.getPower();
            PlanView planView = PlanController.this.getView();
            planView.setResizeIndicatorVisible(true);
            planView.setToolTipFeedback(this.getToolTipFeedbackText(this.oldPower), PlanController.this.getXLastMousePress(), PlanController.this.getYLastMousePress());
        }

        public void moveMouse(float f, float f2) {
            PlanView planView = PlanController.this.getView();
            float[] fArray = this.selectedLight.getPoints()[3];
            float f3 = f - this.deltaXToModificationPoint - fArray[0];
            float f4 = this.oldPower + f3 / 100.0f * PlanController.this.getScale();
            f4 = Math.min(Math.max(f4, 0.0f), 1.0f);
            this.selectedLight.setPower(f4);
            planView.makePointVisible(f, f2);
            planView.setToolTipFeedback(this.getToolTipFeedbackText(f4), f, f2);
        }

        public void releaseMouse(float f, float f2) {
            PlanController.this.postLightPowerModification(this.selectedLight, this.oldPower);
            PlanController.this.setState(PlanController.this.getSelectionState());
        }

        public void escape() {
            this.selectedLight.setPower(this.oldPower);
            PlanController.this.setState(PlanController.this.getSelectionState());
        }

        public void exit() {
            PlanView planView = PlanController.this.getView();
            planView.setResizeIndicatorVisible(false);
            planView.deleteFeedback();
            this.selectedLight = null;
        }

        private String getToolTipFeedbackText(float f) {
            return String.format(this.lightPowerToolTipFeedback, Math.round(f * 100.0f));
        }
    }

    private class PieceOfFurnitureResizeState
    extends ControllerState {
        private boolean magnetismEnabled;
        private boolean alignmentActivated;
        private boolean widthOrDepthResizingActivated;
        private float deltaXToResizePoint;
        private float deltaYToResizePoint;
        private ResizedPieceOfFurniture resizedPiece;
        private float resizedPieceWidthInPlan;
        private float[] resizePoint;
        private float[] topLeftPoint;
        private String widthResizeToolTipFeedback;
        private String depthResizeToolTipFeedback;
        private String heightResizeToolTipFeedback;

        private PieceOfFurnitureResizeState() {
        }

        public Mode getMode() {
            return Mode.SELECTION;
        }

        public boolean isModificationState() {
            return true;
        }

        public boolean isBasePlanModificationState() {
            return this.resizedPiece != null && PlanController.this.isPieceOfFurniturePartOfBasePlan(this.resizedPiece.getPieceOfFurniture());
        }

        public void enter() {
            this.widthResizeToolTipFeedback = PlanController.this.preferences.getLocalizedString(PlanController.class, "widthResizeToolTipFeedback", new Object[0]);
            this.depthResizeToolTipFeedback = PlanController.this.preferences.getLocalizedString(PlanController.class, "depthResizeToolTipFeedback", new Object[0]);
            this.heightResizeToolTipFeedback = PlanController.this.preferences.getLocalizedString(PlanController.class, "heightResizeToolTipFeedback", new Object[0]);
            HomePieceOfFurniture homePieceOfFurniture = (HomePieceOfFurniture)PlanController.this.home.getSelectedItems().get(0);
            this.resizedPiece = new ResizedPieceOfFurniture(homePieceOfFurniture);
            this.resizedPieceWidthInPlan = homePieceOfFurniture.getWidthInPlan();
            float[][] fArray = homePieceOfFurniture.getPoints();
            this.resizePoint = fArray[2];
            this.deltaXToResizePoint = PlanController.this.getXLastMousePress() - this.resizePoint[0];
            this.deltaYToResizePoint = PlanController.this.getYLastMousePress() - this.resizePoint[1];
            this.topLeftPoint = fArray[0];
            this.magnetismEnabled = PlanController.this.preferences.isMagnetismEnabled() ^ PlanController.this.wasMagnetismToggledLastMousePress();
            this.alignmentActivated = PlanController.this.wasAlignmentActivatedLastMousePress();
            this.widthOrDepthResizingActivated = PlanController.this.wasDuplicationActivatedLastMousePress();
            PlanView planView = PlanController.this.getView();
            planView.setResizeIndicatorVisible(true);
            planView.setToolTipFeedback(this.getToolTipFeedbackText(homePieceOfFurniture.getWidth(), homePieceOfFurniture.getDepth(), homePieceOfFurniture.getHeight()), PlanController.this.getXLastMousePress(), PlanController.this.getYLastMousePress());
        }

        public void moveMouse(float f, float f2) {
            float f3;
            PlanView planView = PlanController.this.getView();
            HomePieceOfFurniture homePieceOfFurniture = this.resizedPiece.getPieceOfFurniture();
            float f4 = homePieceOfFurniture.getAngle();
            double d = Math.cos(f4);
            double d2 = Math.sin(f4);
            float f5 = f - this.deltaXToResizePoint - this.topLeftPoint[0];
            float f6 = f2 - this.deltaYToResizePoint - this.topLeftPoint[1];
            float f7 = (float)((double)f6 * d2 + (double)f5 * d);
            if (this.magnetismEnabled) {
                f7 = PlanController.this.preferences.getLengthUnit().getMagnetizedLength(f7, planView.getPixelLength());
            }
            f7 = Math.min(Math.max(f7, PlanController.this.preferences.getLengthUnit().getMinimumLength()), PlanController.this.preferences.getLengthUnit().getMaximumLength());
            float f8 = this.resizedPiece.getDepth();
            float f9 = this.resizedPiece.getHeight();
            boolean bl = this.resizedPiece.isDoorOrWindowBoundToWall();
            if (this.isProprortionallyResized(homePieceOfFurniture)) {
                f3 = f7 / this.resizedPieceWidthInPlan;
                f7 = this.resizedPiece.getWidth() * f3;
                f8 = this.resizedPiece.getDepth() * f3;
                f9 = this.resizedPiece.getHeight() * f3;
                bl = f8 == this.resizedPiece.getDepth();
            } else if (!homePieceOfFurniture.isWidthDepthDeformable()) {
                f8 = this.resizedPiece.getDepth() * f7 / this.resizedPiece.getWidth();
            } else if (!this.resizedPiece.isDoorOrWindowBoundToWall() || !this.magnetismEnabled || this.widthOrDepthResizingActivated) {
                f8 = (float)((double)f6 * d - (double)f5 * d2);
                if (this.magnetismEnabled) {
                    f8 = PlanController.this.preferences.getLengthUnit().getMagnetizedLength(f8, planView.getPixelLength());
                }
                boolean bl2 = bl = (f8 = Math.min(Math.max(f8, PlanController.this.preferences.getLengthUnit().getMinimumLength()), PlanController.this.preferences.getLengthUnit().getMaximumLength())) == this.resizedPiece.getDepth();
                if (this.widthOrDepthResizingActivated) {
                    if (Math.signum(Line2D.relativeCCW(this.topLeftPoint[0], this.topLeftPoint[1], this.resizePoint[0], this.resizePoint[1], f - this.deltaXToResizePoint, f2 - this.deltaYToResizePoint)) >= 0.0f) {
                        f8 = this.resizedPiece.getDepth();
                    } else {
                        f7 = this.resizedPiece.getWidth();
                    }
                }
            }
            PlanController.this.setPieceOfFurnitureSize(this.resizedPiece, f7, f8, f9);
            if (this.resizedPiece.isDoorOrWindowBoundToWall()) {
                ((HomeDoorOrWindow)homePieceOfFurniture).setBoundToWall(this.magnetismEnabled && bl);
            }
            f3 = (float)((double)this.topLeftPoint[0] + ((double)homePieceOfFurniture.getWidthInPlan() * d - (double)homePieceOfFurniture.getDepthInPlan() * d2) / 2.0);
            float f10 = (float)((double)this.topLeftPoint[1] + ((double)homePieceOfFurniture.getWidthInPlan() * d2 + (double)homePieceOfFurniture.getDepthInPlan() * d) / 2.0);
            homePieceOfFurniture.setX(f3);
            homePieceOfFurniture.setY(f10);
            planView.makePointVisible(f, f2);
            planView.setToolTipFeedback(this.getToolTipFeedbackText(f7, f8, f9), f, f2);
        }

        private boolean isProprortionallyResized(HomePieceOfFurniture homePieceOfFurniture) {
            return !homePieceOfFurniture.isDeformable() || homePieceOfFurniture.isHorizontallyRotated() || homePieceOfFurniture.getModelTransformations() != null || this.alignmentActivated;
        }

        public void releaseMouse(float f, float f2) {
            PlanController.this.postPieceOfFurnitureWidthAndDepthResize(this.resizedPiece);
            PlanController.this.setState(PlanController.this.getSelectionState());
        }

        public void toggleMagnetism(boolean bl) {
            this.magnetismEnabled = PlanController.this.preferences.isMagnetismEnabled() ^ bl;
            this.moveMouse(PlanController.this.getXLastMouseMove(), PlanController.this.getYLastMouseMove());
        }

        public void setAlignmentActivated(boolean bl) {
            this.alignmentActivated = bl;
            this.moveMouse(PlanController.this.getXLastMouseMove(), PlanController.this.getYLastMouseMove());
        }

        public void setDuplicationActivated(boolean bl) {
            this.widthOrDepthResizingActivated = bl;
            this.moveMouse(PlanController.this.getXLastMouseMove(), PlanController.this.getYLastMouseMove());
        }

        public void escape() {
            PlanController.this.resetPieceOfFurnitureSize(this.resizedPiece);
            PlanController.this.setState(PlanController.this.getSelectionState());
        }

        public void exit() {
            PlanView planView = PlanController.this.getView();
            planView.setResizeIndicatorVisible(false);
            planView.deleteFeedback();
            this.resizedPiece = null;
        }

        private String getToolTipFeedbackText(float f, float f2, float f3) {
            String string = "<html>" + String.format(this.widthResizeToolTipFeedback, PlanController.this.preferences.getLengthUnit().getFormatWithUnit().format(Float.valueOf(f)));
            if (!(this.resizedPiece.getPieceOfFurniture() instanceof HomeDoorOrWindow) || !((HomeDoorOrWindow)this.resizedPiece.getPieceOfFurniture()).isBoundToWall() || this.isProprortionallyResized(this.resizedPiece.getPieceOfFurniture())) {
                string = string + "<br>" + String.format(this.depthResizeToolTipFeedback, PlanController.this.preferences.getLengthUnit().getFormatWithUnit().format(Float.valueOf(f2)));
            }
            if (this.isProprortionallyResized(this.resizedPiece.getPieceOfFurniture())) {
                string = string + "<br>" + String.format(this.heightResizeToolTipFeedback, PlanController.this.preferences.getLengthUnit().getFormatWithUnit().format(Float.valueOf(f3)));
            }
            return string;
        }
    }

    private class PieceOfFurnitureHeightState
    extends ControllerState {
        private boolean magnetismEnabled;
        private float deltaYToResizePoint;
        private ResizedPieceOfFurniture resizedPiece;
        private float[] topLeftPoint;
        private float[] resizePoint;
        private String resizeToolTipFeedback;

        private PieceOfFurnitureHeightState() {
        }

        public Mode getMode() {
            return Mode.SELECTION;
        }

        public boolean isModificationState() {
            return true;
        }

        public boolean isBasePlanModificationState() {
            return this.resizedPiece != null && PlanController.this.isPieceOfFurniturePartOfBasePlan(this.resizedPiece.getPieceOfFurniture());
        }

        public void enter() {
            this.resizeToolTipFeedback = PlanController.this.preferences.getLocalizedString(PlanController.class, "heightResizeToolTipFeedback", new Object[0]);
            HomePieceOfFurniture homePieceOfFurniture = (HomePieceOfFurniture)PlanController.this.home.getSelectedItems().get(0);
            this.resizedPiece = new ResizedPieceOfFurniture(homePieceOfFurniture);
            float[][] fArray = homePieceOfFurniture.getPoints();
            this.resizePoint = fArray[3];
            this.deltaYToResizePoint = PlanController.this.getYLastMousePress() - this.resizePoint[1];
            this.topLeftPoint = fArray[0];
            this.magnetismEnabled = PlanController.this.preferences.isMagnetismEnabled() ^ PlanController.this.wasMagnetismToggledLastMousePress();
            PlanView planView = PlanController.this.getView();
            planView.setResizeIndicatorVisible(true);
            planView.setToolTipFeedback(this.getToolTipFeedbackText(homePieceOfFurniture.getHeight()), PlanController.this.getXLastMousePress(), PlanController.this.getYLastMousePress());
        }

        public void moveMouse(float f, float f2) {
            PlanView planView = PlanController.this.getView();
            HomePieceOfFurniture homePieceOfFurniture = this.resizedPiece.getPieceOfFurniture();
            float f3 = f2 - this.deltaYToResizePoint - this.resizePoint[1];
            float f4 = this.resizedPiece.getHeight() - f3;
            f4 = Math.max(f4, 0.0f);
            if (this.magnetismEnabled) {
                f4 = PlanController.this.preferences.getLengthUnit().getMagnetizedLength(f4, planView.getPixelLength());
            }
            f4 = Math.min(Math.max(f4, PlanController.this.preferences.getLengthUnit().getMinimumLength()), PlanController.this.preferences.getLengthUnit().getMaximumLength());
            if (homePieceOfFurniture.isDeformable() && !homePieceOfFurniture.isHorizontallyRotated() && homePieceOfFurniture.getModelTransformations() == null) {
                PlanController.this.setPieceOfFurnitureSize(this.resizedPiece, this.resizedPiece.getWidth(), this.resizedPiece.getDepth(), f4);
            } else {
                float f5 = f4 / this.resizedPiece.getHeight();
                float f6 = this.resizedPiece.getWidth() * f5;
                float f7 = this.resizedPiece.getDepth() * f5;
                float f8 = homePieceOfFurniture.getAngle();
                double d = Math.cos(f8);
                double d2 = Math.sin(f8);
                float f9 = (float)((double)this.topLeftPoint[0] + ((double)f6 * d - (double)f7 * d2) / 2.0);
                float f10 = (float)((double)this.topLeftPoint[1] + ((double)f6 * d2 + (double)f7 * d) / 2.0);
                homePieceOfFurniture.setX(f9);
                homePieceOfFurniture.setY(f10);
                PlanController.this.setPieceOfFurnitureSize(this.resizedPiece, f6, f7, f4);
            }
            planView.makePointVisible(f, f2);
            planView.setToolTipFeedback(this.getToolTipFeedbackText(f4), f, f2);
        }

        public void releaseMouse(float f, float f2) {
            PlanController.this.postPieceOfFurnitureHeightResize(this.resizedPiece);
            PlanController.this.setState(PlanController.this.getSelectionState());
        }

        public void toggleMagnetism(boolean bl) {
            this.magnetismEnabled = PlanController.this.preferences.isMagnetismEnabled() ^ bl;
            this.moveMouse(PlanController.this.getXLastMouseMove(), PlanController.this.getYLastMouseMove());
        }

        public void escape() {
            PlanController.this.resetPieceOfFurnitureSize(this.resizedPiece);
            PlanController.this.setState(PlanController.this.getSelectionState());
        }

        public void exit() {
            PlanView planView = PlanController.this.getView();
            planView.setResizeIndicatorVisible(false);
            planView.deleteFeedback();
            this.resizedPiece = null;
        }

        private String getToolTipFeedbackText(float f) {
            return String.format(this.resizeToolTipFeedback, PlanController.this.preferences.getLengthUnit().getFormatWithUnit().format(Float.valueOf(f)));
        }
    }

    private class PieceOfFurnitureElevationState
    extends ControllerState {
        private boolean magnetismEnabled;
        private float deltaYToElevationPoint;
        private HomePieceOfFurniture selectedPiece;
        private float oldElevation;
        private String elevationToolTipFeedback;

        private PieceOfFurnitureElevationState() {
        }

        public Mode getMode() {
            return Mode.SELECTION;
        }

        public boolean isModificationState() {
            return true;
        }

        public boolean isBasePlanModificationState() {
            return this.selectedPiece != null && PlanController.this.isPieceOfFurniturePartOfBasePlan(this.selectedPiece);
        }

        public void enter() {
            this.elevationToolTipFeedback = PlanController.this.preferences.getLocalizedString(PlanController.class, "elevationToolTipFeedback", new Object[0]);
            this.selectedPiece = (HomePieceOfFurniture)PlanController.this.home.getSelectedItems().get(0);
            float[] fArray = this.selectedPiece.getPoints()[1];
            this.deltaYToElevationPoint = PlanController.this.getYLastMousePress() - fArray[1];
            this.oldElevation = this.selectedPiece.getElevation();
            this.magnetismEnabled = PlanController.this.preferences.isMagnetismEnabled() ^ PlanController.this.wasMagnetismToggledLastMousePress();
            PlanView planView = PlanController.this.getView();
            planView.setResizeIndicatorVisible(true);
            planView.setToolTipFeedback(this.getToolTipFeedbackText(this.oldElevation), PlanController.this.getXLastMousePress(), PlanController.this.getYLastMousePress());
        }

        public void moveMouse(float f, float f2) {
            PlanView planView = PlanController.this.getView();
            float[] fArray = this.selectedPiece.getPoints()[1];
            float f3 = f2 - this.deltaYToElevationPoint - fArray[1];
            float f4 = this.oldElevation - f3;
            f4 = Math.min(Math.max(f4, 0.0f), PlanController.this.preferences.getLengthUnit().getMaximumElevation());
            if (this.magnetismEnabled) {
                f4 = PlanController.this.preferences.getLengthUnit().getMagnetizedLength(f4, planView.getPixelLength());
            }
            this.selectedPiece.setElevation(f4);
            planView.makePointVisible(f, f2);
            planView.setToolTipFeedback(this.getToolTipFeedbackText(f4), f, f2);
        }

        public void releaseMouse(float f, float f2) {
            PlanController.this.postPieceOfFurnitureElevation(this.selectedPiece, this.oldElevation);
            PlanController.this.setState(PlanController.this.getSelectionState());
        }

        public void toggleMagnetism(boolean bl) {
            this.magnetismEnabled = PlanController.this.preferences.isMagnetismEnabled() ^ bl;
            this.moveMouse(PlanController.this.getXLastMouseMove(), PlanController.this.getYLastMouseMove());
        }

        public void escape() {
            this.selectedPiece.setElevation(this.oldElevation);
            PlanController.this.setState(PlanController.this.getSelectionState());
        }

        public void exit() {
            PlanView planView = PlanController.this.getView();
            planView.setResizeIndicatorVisible(false);
            planView.deleteFeedback();
            this.selectedPiece = null;
        }

        private String getToolTipFeedbackText(float f) {
            return String.format(this.elevationToolTipFeedback, PlanController.this.preferences.getLengthUnit().getFormatWithUnit().format(Float.valueOf(f)));
        }
    }

    private class PieceOfFurnitureRollRotationState
    extends ControllerState {
        private HomePieceOfFurniture selectedPiece;
        private float oldRoll;
        private float oldWidthInPlan;
        private float oldDepthInPlan;
        private float oldHeightInPlan;
        private String rollRotationToolTipFeedback;

        private PieceOfFurnitureRollRotationState() {
        }

        public Mode getMode() {
            return Mode.SELECTION;
        }

        public boolean isModificationState() {
            return true;
        }

        public boolean isBasePlanModificationState() {
            return this.selectedPiece != null && PlanController.this.isPieceOfFurniturePartOfBasePlan(this.selectedPiece);
        }

        public void enter() {
            this.rollRotationToolTipFeedback = PlanController.this.preferences.getLocalizedString(PlanController.class, "rollRotationToolTipFeedback", new Object[0]);
            this.selectedPiece = (HomePieceOfFurniture)PlanController.this.home.getSelectedItems().get(0);
            this.oldRoll = this.selectedPiece.getRoll();
            this.oldWidthInPlan = this.selectedPiece.getWidthInPlan();
            this.oldDepthInPlan = this.selectedPiece.getDepthInPlan();
            this.oldHeightInPlan = this.selectedPiece.getHeightInPlan();
            PlanView planView = PlanController.this.getView();
            planView.setResizeIndicatorVisible(true);
            planView.setToolTipFeedback(this.getToolTipFeedbackText(this.oldRoll), PlanController.this.getXLastMousePress(), PlanController.this.getYLastMousePress());
        }

        public void moveMouse(float f, float f2) {
            float f3 = (float)((double)this.oldRoll + (double)(f2 - PlanController.this.getYLastMousePress()) * Math.sin(this.selectedPiece.getAngle()) * Math.PI / 360.0 + (double)(f - PlanController.this.getXLastMousePress()) * Math.cos(this.selectedPiece.getAngle()) * Math.PI / 360.0);
            if ((double)Math.abs(f3) < 1.0E-8) {
                f3 = 0.0f;
            }
            this.selectedPiece.setRoll(f3);
            PlanController.this.getView().setToolTipFeedback(this.getToolTipFeedbackText(f3), f, f2);
        }

        public void releaseMouse(float f, float f2) {
            PlanController.this.postPieceOfFurnitureRollRotation(this.selectedPiece, this.oldRoll, this.oldWidthInPlan, this.oldDepthInPlan, this.oldHeightInPlan);
            PlanController.this.setState(PlanController.this.getSelectionState());
        }

        public void escape() {
            this.selectedPiece.setRoll(this.oldRoll);
            PlanController.this.setState(PlanController.this.getSelectionState());
        }

        public void exit() {
            PlanView planView = PlanController.this.getView();
            planView.setResizeIndicatorVisible(false);
            planView.deleteFeedback();
            this.selectedPiece = null;
        }

        private String getToolTipFeedbackText(float f) {
            return String.format(this.rollRotationToolTipFeedback, (Math.round(Math.toDegrees(f)) + 360L) % 360L);
        }
    }

    private class PieceOfFurniturePitchRotationState
    extends ControllerState {
        private HomePieceOfFurniture selectedPiece;
        private float oldPitch;
        private float oldWidthInPlan;
        private float oldDepthInPlan;
        private float oldHeightInPlan;
        private String pitchRotationToolTipFeedback;

        private PieceOfFurniturePitchRotationState() {
        }

        public Mode getMode() {
            return Mode.SELECTION;
        }

        public boolean isModificationState() {
            return true;
        }

        public boolean isBasePlanModificationState() {
            return this.selectedPiece != null && PlanController.this.isPieceOfFurniturePartOfBasePlan(this.selectedPiece);
        }

        public void enter() {
            this.pitchRotationToolTipFeedback = PlanController.this.preferences.getLocalizedString(PlanController.class, "pitchRotationToolTipFeedback", new Object[0]);
            this.selectedPiece = (HomePieceOfFurniture)PlanController.this.home.getSelectedItems().get(0);
            this.oldPitch = this.selectedPiece.getPitch();
            this.oldWidthInPlan = this.selectedPiece.getWidthInPlan();
            this.oldDepthInPlan = this.selectedPiece.getDepthInPlan();
            this.oldHeightInPlan = this.selectedPiece.getHeightInPlan();
            PlanView planView = PlanController.this.getView();
            planView.setResizeIndicatorVisible(true);
            planView.setToolTipFeedback(this.getToolTipFeedbackText(this.oldPitch), PlanController.this.getXLastMousePress(), PlanController.this.getYLastMousePress());
        }

        public void moveMouse(float f, float f2) {
            float f3 = (float)((double)this.oldPitch - (double)(f2 - PlanController.this.getYLastMousePress()) * Math.cos(this.selectedPiece.getAngle()) * Math.PI / 360.0 + (double)(f - PlanController.this.getXLastMousePress()) * Math.sin(this.selectedPiece.getAngle()) * Math.PI / 360.0);
            if ((double)Math.abs(f3) < 1.0E-8) {
                f3 = 0.0f;
            }
            this.selectedPiece.setPitch(f3);
            PlanController.this.getView().setToolTipFeedback(this.getToolTipFeedbackText(f3), f, f2);
        }

        public void releaseMouse(float f, float f2) {
            PlanController.this.postPieceOfFurniturePitchRotation(this.selectedPiece, this.oldPitch, this.oldWidthInPlan, this.oldDepthInPlan, this.oldHeightInPlan);
            PlanController.this.setState(PlanController.this.getSelectionState());
        }

        public void escape() {
            this.selectedPiece.setPitch(this.oldPitch);
            PlanController.this.setState(PlanController.this.getSelectionState());
        }

        public void exit() {
            PlanView planView = PlanController.this.getView();
            planView.setResizeIndicatorVisible(false);
            planView.deleteFeedback();
            this.selectedPiece = null;
        }

        private String getToolTipFeedbackText(float f) {
            return String.format(this.pitchRotationToolTipFeedback, (Math.round(Math.toDegrees(f)) + 360L) % 360L);
        }
    }

    private class PieceOfFurnitureRotationState
    extends ControllerState {
        private static final int STEP_COUNT = 24;
        private boolean magnetismEnabled;
        private boolean alignmentActivated;
        private HomePieceOfFurniture selectedPiece;
        private float angleMousePress;
        private float oldAngle;
        private boolean doorOrWindowBoundToWall;
        private String rotationToolTipFeedback;

        private PieceOfFurnitureRotationState() {
        }

        public Mode getMode() {
            return Mode.SELECTION;
        }

        public boolean isModificationState() {
            return true;
        }

        public boolean isBasePlanModificationState() {
            return this.selectedPiece != null && PlanController.this.isPieceOfFurniturePartOfBasePlan(this.selectedPiece);
        }

        public void enter() {
            this.rotationToolTipFeedback = PlanController.this.preferences.getLocalizedString(PlanController.class, "rotationToolTipFeedback", new Object[0]);
            this.selectedPiece = (HomePieceOfFurniture)PlanController.this.home.getSelectedItems().get(0);
            this.angleMousePress = (float)Math.atan2(this.selectedPiece.getY() - PlanController.this.getYLastMousePress(), PlanController.this.getXLastMousePress() - this.selectedPiece.getX());
            this.oldAngle = this.selectedPiece.getAngle();
            this.doorOrWindowBoundToWall = this.selectedPiece instanceof HomeDoorOrWindow && ((HomeDoorOrWindow)this.selectedPiece).isBoundToWall();
            this.alignmentActivated = PlanController.this.wasAlignmentActivatedLastMousePress();
            this.magnetismEnabled = PlanController.this.preferences.isMagnetismEnabled() ^ PlanController.this.wasMagnetismToggledLastMousePress();
            PlanView planView = PlanController.this.getView();
            planView.setResizeIndicatorVisible(true);
            planView.setToolTipFeedback(this.getToolTipFeedbackText(this.oldAngle), PlanController.this.getXLastMousePress(), PlanController.this.getYLastMousePress());
        }

        public void moveMouse(float f, float f2) {
            if (f != this.selectedPiece.getX() || f2 != this.selectedPiece.getY()) {
                float f3 = (float)Math.atan2(this.selectedPiece.getY() - f2, f - this.selectedPiece.getX());
                float f4 = this.oldAngle - f3 + this.angleMousePress;
                if (this.alignmentActivated || this.magnetismEnabled) {
                    float f5 = 0.2617994f;
                    f4 = (float)Math.round(f4 / f5) * f5;
                }
                this.selectedPiece.setAngle(f4);
                PlanView planView = PlanController.this.getView();
                planView.makePointVisible(f, f2);
                planView.setToolTipFeedback(this.getToolTipFeedbackText(f4), f, f2);
            }
        }

        public void releaseMouse(float f, float f2) {
            PlanController.this.postPieceOfFurnitureRotation(this.selectedPiece, this.oldAngle, this.doorOrWindowBoundToWall);
            PlanController.this.setState(PlanController.this.getSelectionState());
        }

        public void toggleMagnetism(boolean bl) {
            this.magnetismEnabled = PlanController.this.preferences.isMagnetismEnabled() ^ bl;
            this.moveMouse(PlanController.this.getXLastMouseMove(), PlanController.this.getYLastMouseMove());
        }

        public void setAlignmentActivated(boolean bl) {
            this.alignmentActivated = bl;
            this.moveMouse(PlanController.this.getXLastMouseMove(), PlanController.this.getYLastMouseMove());
        }

        public void escape() {
            this.selectedPiece.setAngle(this.oldAngle);
            if (this.selectedPiece instanceof HomeDoorOrWindow) {
                ((HomeDoorOrWindow)this.selectedPiece).setBoundToWall(this.doorOrWindowBoundToWall);
            }
            PlanController.this.setState(PlanController.this.getSelectionState());
        }

        public void exit() {
            PlanView planView = PlanController.this.getView();
            planView.setResizeIndicatorVisible(false);
            planView.deleteFeedback();
            this.selectedPiece = null;
        }

        private String getToolTipFeedbackText(float f) {
            return String.format(this.rotationToolTipFeedback, (Math.round(Math.toDegrees(f)) + 360L) % 360L);
        }
    }

    private class WallArcExtentState
    extends AbstractWallState {
        private Wall selectedWall;
        private Float oldArcExtent;
        private float deltaXToMiddlePoint;
        private float deltaYToMiddlePoint;
        private boolean magnetismEnabled;
        private boolean alignmentActivated;

        private WallArcExtentState() {
        }

        public Mode getMode() {
            return Mode.SELECTION;
        }

        public boolean isModificationState() {
            return true;
        }

        public boolean isBasePlanModificationState() {
            return true;
        }

        public void enter() {
            super.enter();
            this.selectedWall = (Wall)PlanController.this.home.getSelectedItems().get(0);
            this.oldArcExtent = this.selectedWall.getArcExtent();
            float[][] fArray = this.selectedWall.getPoints();
            int n = fArray.length / 4;
            int n2 = fArray.length - 1 - n;
            if (fArray.length % 4 == 0) {
                --n;
            }
            float f = (fArray[n][0] + fArray[n2][0]) / 2.0f;
            float f2 = (fArray[n][1] + fArray[n2][1]) / 2.0f;
            this.deltaXToMiddlePoint = PlanController.this.getXLastMousePress() - f;
            this.deltaYToMiddlePoint = PlanController.this.getYLastMousePress() - f2;
            this.alignmentActivated = PlanController.this.wasAlignmentActivatedLastMousePress();
            this.magnetismEnabled = PlanController.this.preferences.isMagnetismEnabled() ^ PlanController.this.wasMagnetismToggledLastMousePress();
            PlanView planView = PlanController.this.getView();
            planView.setResizeIndicatorVisible(true);
            planView.setToolTipFeedback(this.getToolTipFeedbackText(this.selectedWall, false), PlanController.this.getXLastMousePress(), PlanController.this.getYLastMousePress());
            this.showWallAngleFeedback(this.selectedWall, false);
        }

        public void moveMouse(float f, float f2) {
            PlanView planView = PlanController.this.getView();
            float f3 = f - this.deltaXToMiddlePoint;
            float f4 = f2 - this.deltaYToMiddlePoint;
            float f5 = this.getArcExtent(this.selectedWall.getXStart(), this.selectedWall.getYStart(), this.selectedWall.getXEnd(), this.selectedWall.getYEnd(), f3, f4);
            if (this.alignmentActivated || this.magnetismEnabled) {
                f5 = (float)Math.toRadians(Math.round(Math.toDegrees(f5)));
            }
            this.selectedWall.setArcExtent(Float.valueOf(f5));
            planView.setToolTipFeedback(this.getToolTipFeedbackText(this.selectedWall, false), f, f2);
            this.showWallAngleFeedback(this.selectedWall, false);
            planView.makePointVisible(f, f2);
        }

        public void releaseMouse(float f, float f2) {
            PlanController.this.postWallArcExtent(this.selectedWall, this.oldArcExtent);
            PlanController.this.setState(PlanController.this.getSelectionState());
        }

        public void toggleMagnetism(boolean bl) {
            this.magnetismEnabled = PlanController.this.preferences.isMagnetismEnabled() ^ bl;
            this.moveMouse(PlanController.this.getXLastMouseMove(), PlanController.this.getYLastMouseMove());
        }

        public void setAlignmentActivated(boolean bl) {
            this.alignmentActivated = bl;
            this.moveMouse(PlanController.this.getXLastMouseMove(), PlanController.this.getYLastMouseMove());
        }

        public void escape() {
            this.selectedWall.setArcExtent(this.oldArcExtent);
            PlanController.this.setState(PlanController.this.getSelectionState());
        }

        public void exit() {
            PlanView planView = PlanController.this.getView();
            planView.setResizeIndicatorVisible(false);
            planView.deleteFeedback();
            this.selectedWall = null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class WallResizeState
    extends AbstractWallState {
        private Wall selectedWall;
        private boolean startPoint;
        private float oldX;
        private float oldY;
        private float deltaXToResizePoint;
        private float deltaYToResizePoint;
        private boolean magnetismEnabled;
        private boolean alignmentActivated;

        private WallResizeState() {
        }

        @Override
        public Mode getMode() {
            return Mode.SELECTION;
        }

        @Override
        public boolean isModificationState() {
            return true;
        }

        @Override
        public boolean isBasePlanModificationState() {
            return true;
        }

        @Override
        public void enter() {
            super.enter();
            this.selectedWall = (Wall)PlanController.this.home.getSelectedItems().get(0);
            boolean bl = this.startPoint = this.selectedWall == PlanController.this.getResizedWallStartAt(PlanController.this.getXLastMousePress(), PlanController.this.getYLastMousePress());
            if (this.startPoint) {
                this.oldX = this.selectedWall.getXStart();
                this.oldY = this.selectedWall.getYStart();
            } else {
                this.oldX = this.selectedWall.getXEnd();
                this.oldY = this.selectedWall.getYEnd();
            }
            this.deltaXToResizePoint = PlanController.this.getXLastMousePress() - this.oldX;
            this.deltaYToResizePoint = PlanController.this.getYLastMousePress() - this.oldY;
            this.alignmentActivated = PlanController.this.wasAlignmentActivatedLastMousePress();
            this.toggleMagnetism(PlanController.this.wasMagnetismToggledLastMousePress());
            PlanView planView = PlanController.this.getView();
            planView.setResizeIndicatorVisible(true);
            planView.setToolTipFeedback(this.getToolTipFeedbackText(this.selectedWall, true), PlanController.this.getXLastMousePress(), PlanController.this.getYLastMousePress());
            planView.setAlignmentFeedback(Wall.class, this.selectedWall, this.oldX, this.oldY, false);
            this.showWallAngleFeedback(this.selectedWall, true);
            planView.setDimensionLinesFeedback(this.getDimensionLinesAlongWall(this.selectedWall));
        }

        @Override
        public void moveMouse(float f, float f2) {
            float f3;
            PlanView planView = PlanController.this.getView();
            float f4 = f - this.deltaXToResizePoint;
            float f5 = f2 - this.deltaYToResizePoint;
            float f6 = this.startPoint ? this.selectedWall.getXEnd() : this.selectedWall.getXStart();
            float f7 = f3 = this.startPoint ? this.selectedWall.getYEnd() : this.selectedWall.getYStart();
            if (this.alignmentActivated) {
                PointWithAngleMagnetism pointWithAngleMagnetism = new PointWithAngleMagnetism(f6, f3, f4, f5, PlanController.this.preferences.getLengthUnit(), planView.getPixelLength());
                f4 = pointWithAngleMagnetism.getX();
                f5 = pointWithAngleMagnetism.getY();
            } else if (this.magnetismEnabled) {
                WallPointWithAngleMagnetism wallPointWithAngleMagnetism = new WallPointWithAngleMagnetism(this.selectedWall, f6, f3, f4, f5);
                f4 = wallPointWithAngleMagnetism.getX();
                f5 = wallPointWithAngleMagnetism.getY();
            }
            PlanController.moveWallPoint(this.selectedWall, f4, f5, this.startPoint);
            planView.setToolTipFeedback(this.getToolTipFeedbackText(this.selectedWall, true), f, f2);
            planView.setAlignmentFeedback(Wall.class, this.selectedWall, f4, f5, false);
            this.showWallAngleFeedback(this.selectedWall, true);
            planView.setDimensionLinesFeedback(this.getDimensionLinesAlongWall(this.selectedWall));
            planView.makePointVisible(f, f2);
        }

        private List<DimensionLine> getDimensionLinesAlongWall(Wall wall) {
            ArrayList<DimensionLine> arrayList = new ArrayList<DimensionLine>();
            if (wall.getArcExtent() == null || wall.getArcExtent().floatValue() == 0.0f) {
                int n;
                float f = 20.0f / PlanController.this.getView().getScale();
                float[][] fArray = wall.getPoints();
                List list = PlanController.this.getRoomPathsFromWalls();
                for (n = 0; n < list.size(); ++n) {
                    float[][] fArray2 = PlanController.this.getPathPoints((GeneralPath)list.get(n), true);
                    for (int i = 0; i < fArray2.length; ++i) {
                        boolean bl;
                        boolean bl2;
                        float[] fArray3 = fArray2[i];
                        float[] fArray4 = fArray2[(i + 1) % fArray2.length];
                        boolean bl3 = bl2 = Line2D.ptLineDistSq(fArray[0][0], fArray[0][1], fArray[1][0], fArray[1][1], fArray3[0], fArray3[1]) < 1.0E-4 && Line2D.ptLineDistSq(fArray[0][0], fArray[0][1], fArray[1][0], fArray[1][1], fArray4[0], fArray4[1]) < 1.0E-4;
                        if (bl2) {
                            bl = Line2D.ptSegDistSq(fArray[0][0], fArray[0][1], fArray[1][0], fArray[1][1], fArray3[0], fArray3[1]) < 1.0E-4 || Line2D.ptSegDistSq(fArray[0][0], fArray[0][1], fArray[1][0], fArray[1][1], fArray4[0], fArray4[1]) < 1.0E-4 || Line2D.ptSegDistSq(fArray3[0], fArray3[1], fArray4[0], fArray4[1], fArray[0][0], fArray[0][1]) < 1.0E-4 || Line2D.ptSegDistSq(fArray3[0], fArray3[1], fArray4[0], fArray4[1], fArray[1][0], fArray[1][1]) < 1.0E-4;
                        } else {
                            boolean bl4 = bl = Line2D.ptLineDistSq(fArray[2][0], fArray[2][1], fArray[3][0], fArray[3][1], fArray3[0], fArray3[1]) < 1.0E-4 && Line2D.ptLineDistSq(fArray[2][0], fArray[2][1], fArray[3][0], fArray[3][1], fArray4[0], fArray4[1]) < 1.0E-4 && (Line2D.ptSegDistSq(fArray[2][0], fArray[2][1], fArray[3][0], fArray[3][1], fArray3[0], fArray3[1]) < 1.0E-4 || Line2D.ptSegDistSq(fArray[2][0], fArray[2][1], fArray[3][0], fArray[3][1], fArray4[0], fArray4[1]) < 1.0E-4 || Line2D.ptSegDistSq(fArray3[0], fArray3[1], fArray4[0], fArray4[1], fArray[2][0], fArray[2][1]) < 1.0E-4 || Line2D.ptSegDistSq(fArray3[0], fArray3[1], fArray4[0], fArray4[1], fArray[3][0], fArray[3][1]) < 1.0E-4);
                        }
                        if (!bl) continue;
                        arrayList.add(PlanController.this.getDimensionLineBetweenPoints(fArray3, fArray4, this.isDimensionInsideWall(wall, fArray3, fArray4) ? -f : f, false));
                    }
                }
                for (n = arrayList.size() - 1; n >= 0; --n) {
                    if (!(((DimensionLine)arrayList.get(n)).getLength() < 0.01f)) continue;
                    arrayList.remove(n);
                }
                if (arrayList.size() == 2 && Math.abs(((DimensionLine)arrayList.get(0)).getLength() - ((DimensionLine)arrayList.get(1)).getLength()) < 0.01f) {
                    arrayList.remove(1);
                }
            }
            return arrayList;
        }

        private boolean isDimensionInsideWall(Wall wall, float[] fArray, float[] fArray2) {
            AffineTransform affineTransform = AffineTransform.getRotateInstance(Math.atan2(fArray2[1] - fArray[1], fArray2[0] - fArray[0]), fArray[0], fArray[1]);
            float[] fArray3 = new float[]{(float)((double)fArray[0] + Point2D.distance(fArray[0], fArray[1], fArray2[0], fArray2[1]) / 2.0), fArray[1] + 0.01f};
            affineTransform.transform(fArray3, 0, fArray3, 0, 1);
            return wall.containsPoint(fArray3[0], fArray3[1], 0.0f);
        }

        @Override
        public void releaseMouse(float f, float f2) {
            PlanController.this.postWallResize(this.selectedWall, this.oldX, this.oldY, this.startPoint);
            PlanController.this.setState(PlanController.this.getSelectionState());
        }

        @Override
        public void toggleMagnetism(boolean bl) {
            this.magnetismEnabled = PlanController.this.preferences.isMagnetismEnabled() ^ bl;
            this.moveMouse(PlanController.this.getXLastMouseMove(), PlanController.this.getYLastMouseMove());
        }

        @Override
        public void setAlignmentActivated(boolean bl) {
            this.alignmentActivated = bl;
            this.moveMouse(PlanController.this.getXLastMouseMove(), PlanController.this.getYLastMouseMove());
        }

        @Override
        public void escape() {
            PlanController.moveWallPoint(this.selectedWall, this.oldX, this.oldY, this.startPoint);
            PlanController.this.setState(PlanController.this.getSelectionState());
        }

        @Override
        public void exit() {
            PlanView planView = PlanController.this.getView();
            planView.setResizeIndicatorVisible(false);
            planView.deleteFeedback();
            this.selectedWall = null;
        }
    }

    private class WallDrawingState
    extends AbstractWallState {
        private float xStart;
        private float yStart;
        private float xLastEnd;
        private float yLastEnd;
        private Wall wallStartAtStart;
        private Wall wallEndAtStart;
        private Wall newWall;
        private Wall wallStartAtEnd;
        private Wall wallEndAtEnd;
        private Wall lastWall;
        private List<Selectable> oldSelection;
        private boolean oldBasePlanLocked;
        private boolean oldAllLevelsSelection;
        private List<Wall> newWalls;
        private boolean magnetismEnabled;
        private boolean alignmentActivated;
        private boolean roundWall;
        private long lastWallCreationTime;
        private Float wallArcExtent;

        private WallDrawingState() {
        }

        public Mode getMode() {
            return Mode.WALL_CREATION;
        }

        public boolean isModificationState() {
            return true;
        }

        public boolean isBasePlanModificationState() {
            return true;
        }

        public void setMode(Mode mode) {
            this.escape();
            if (mode == Mode.SELECTION) {
                PlanController.this.setState(PlanController.this.getSelectionState());
            } else if (mode == Mode.PANNING) {
                PlanController.this.setState(PlanController.this.getPanningState());
            } else if (mode == Mode.ROOM_CREATION) {
                PlanController.this.setState(PlanController.this.getRoomCreationState());
            } else if (mode == Mode.POLYLINE_CREATION) {
                PlanController.this.setState(PlanController.this.getPolylineCreationState());
            } else if (mode == Mode.DIMENSION_LINE_CREATION) {
                PlanController.this.setState(PlanController.this.getDimensionLineCreationState());
            } else if (mode == Mode.LABEL_CREATION) {
                PlanController.this.setState(PlanController.this.getLabelCreationState());
            }
        }

        public void enter() {
            Object object;
            super.enter();
            this.oldSelection = PlanController.this.home.getSelectedItems();
            this.oldBasePlanLocked = PlanController.this.home.isBasePlanLocked();
            this.oldAllLevelsSelection = PlanController.this.home.isAllLevelsSelection();
            this.alignmentActivated = PlanController.this.wasAlignmentActivatedLastMousePress();
            this.toggleMagnetism(PlanController.this.wasMagnetismToggledLastMousePress());
            this.xStart = PlanController.this.getXLastMouseMove();
            this.yStart = PlanController.this.getYLastMouseMove();
            this.wallEndAtStart = PlanController.this.getWallEndAt(this.xStart, this.yStart, null);
            if (this.wallEndAtStart != null) {
                this.wallStartAtStart = null;
                this.xStart = this.wallEndAtStart.getXEnd();
                this.yStart = this.wallEndAtStart.getYEnd();
            } else {
                this.wallStartAtStart = PlanController.this.getWallStartAt(this.xStart, this.yStart, null);
                if (this.wallStartAtStart != null) {
                    this.xStart = this.wallStartAtStart.getXStart();
                    this.yStart = this.wallStartAtStart.getYStart();
                } else if (this.magnetismEnabled) {
                    object = new WallPointWithAngleMagnetism(null, this.xStart, this.yStart, this.xStart, this.yStart);
                    this.xStart = ((PointWithAngleMagnetism)object).getX();
                    this.yStart = ((PointWithAngleMagnetism)object).getY();
                }
            }
            this.newWall = null;
            this.wallStartAtEnd = null;
            this.wallEndAtEnd = null;
            this.lastWall = null;
            this.newWalls = new ArrayList<Wall>();
            this.lastWallCreationTime = -1L;
            PlanController.this.deselectAll();
            this.setDuplicationActivated(PlanController.this.wasDuplicationActivatedLastMousePress());
            object = PlanController.this.getView();
            object.setAlignmentFeedback(Wall.class, null, this.xStart, this.yStart, false);
        }

        public void moveMouse(float f, float f2) {
            float f3;
            float f4;
            PlanView planView = PlanController.this.getView();
            if (this.alignmentActivated) {
                PointWithAngleMagnetism pointWithAngleMagnetism = new PointWithAngleMagnetism(this.xStart, this.yStart, f, f2, PlanController.this.preferences.getLengthUnit(), planView.getPixelLength());
                f4 = pointWithAngleMagnetism.getX();
                f3 = pointWithAngleMagnetism.getY();
            } else if (this.magnetismEnabled) {
                WallPointWithAngleMagnetism wallPointWithAngleMagnetism = new WallPointWithAngleMagnetism(this.newWall, this.xStart, this.yStart, f, f2);
                f4 = wallPointWithAngleMagnetism.getX();
                f3 = wallPointWithAngleMagnetism.getY();
            } else {
                f4 = f;
                f3 = f2;
            }
            if (this.newWall == null) {
                this.newWall = PlanController.this.createWall(this.xStart, this.yStart, f4, f3, this.wallStartAtStart, this.wallEndAtStart);
                this.newWalls.add(this.newWall);
            } else if (this.wallArcExtent != null) {
                this.wallArcExtent = Float.valueOf(this.getArcExtent(this.newWall.getXStart(), this.newWall.getXEnd(), this.newWall.getYStart(), this.newWall.getYEnd(), f, f2));
                if (this.alignmentActivated || this.magnetismEnabled) {
                    this.wallArcExtent = Float.valueOf((float)Math.toRadians(Math.round(Math.toDegrees(this.wallArcExtent.floatValue()))));
                }
                this.newWall.setArcExtent(this.wallArcExtent);
            } else {
                this.newWall.setXEnd(f4);
                this.newWall.setYEnd(f3);
            }
            planView.setToolTipFeedback(this.getToolTipFeedbackText(this.newWall, false), f, f2);
            planView.setAlignmentFeedback(Wall.class, this.newWall, f4, f3, false);
            this.showWallAngleFeedback(this.newWall, false);
            this.wallStartAtEnd = PlanController.this.getWallStartAt(f4, f3, this.newWall);
            if (this.wallStartAtEnd != null) {
                this.wallEndAtEnd = null;
                PlanController.this.selectItem(this.wallStartAtEnd);
            } else {
                this.wallEndAtEnd = PlanController.this.getWallEndAt(f4, f3, this.newWall);
                if (this.wallEndAtEnd != null) {
                    PlanController.this.selectItem(this.wallEndAtEnd);
                } else {
                    PlanController.this.deselectAll();
                }
            }
            planView.makePointVisible(f, f2);
            this.xLastEnd = f4;
            this.yLastEnd = f3;
        }

        public void pressMouse(float f, float f2, int n, boolean bl, boolean bl2) {
            if (n == 2) {
                Selectable selectable = PlanController.this.getSelectableItemAt(f, f2);
                if (this.newWalls.size() == 0 && selectable instanceof Room) {
                    this.createWallsAroundRoom((Room)selectable);
                } else {
                    if (this.roundWall && this.newWall != null) {
                        this.endWallCreation();
                    }
                    if (this.lastWall != null) {
                        PlanController.this.joinNewWallEndToWall(this.lastWall, this.wallStartAtEnd, this.wallEndAtEnd);
                    }
                }
                this.validateDrawnWalls();
            } else if (this.newWall != null && this.newWall.getStartPointToEndPointDistance() > 0.0f) {
                if (this.roundWall && this.wallArcExtent == null) {
                    this.wallArcExtent = Float.valueOf((float)Math.PI);
                    this.newWall.setArcExtent(this.wallArcExtent);
                    PlanController.this.getView().setToolTipFeedback(this.getToolTipFeedbackText(this.newWall, false), f, f2);
                } else {
                    PlanController.this.getView().deleteToolTipFeedback();
                    PlanController.this.selectItem(this.newWall);
                    this.endWallCreation();
                }
            }
        }

        private void createWallsAroundRoom(Room room) {
            if (room.isSingular()) {
                float[] fArray;
                Object object;
                Object object2;
                Object object3;
                Object object4;
                float[][] fArray2 = room.getPoints();
                ArrayList arrayList = new ArrayList(Arrays.asList(fArray2));
                if (!room.isClockwise()) {
                    Collections.reverse(arrayList);
                }
                int n = 0;
                while (n < arrayList.size()) {
                    float[] fArray3;
                    object4 = (float[])arrayList.get(n);
                    if (object4[0] == (fArray3 = (float[])arrayList.get((n + 1) % arrayList.size()))[0] && object4[1] == fArray3[1]) {
                        arrayList.remove(n);
                        continue;
                    }
                    ++n;
                }
                fArray2 = (float[][])arrayList.toArray((T[])new float[arrayList.size()][]);
                float f = PlanController.this.preferences.getNewWallThickness() / 2.0f;
                object4 = new float[fArray2.length][];
                for (int i = 0; i < fArray2.length; ++i) {
                    object3 = fArray2[i];
                    float[] fArray4 = fArray2[(i + fArray2.length - 1) % fArray2.length];
                    float[] fArray5 = fArray2[(i + 1) % fArray2.length];
                    double d = Math.atan2(object3[0] - fArray4[0], fArray4[1] - object3[1]);
                    float f2 = (float)(Math.cos(d) * (double)f);
                    float f3 = (float)(Math.sin(d) * (double)f);
                    object2 = new float[]{fArray4[0] - f2, fArray4[1] - f3};
                    float[] fArray6 = new float[]{object3[0] - f2, object3[1] - f3};
                    double d2 = Math.atan2(fArray5[0] - object3[0], object3[1] - fArray5[1]);
                    f2 = (float)(Math.cos(d2) * (double)f);
                    f3 = (float)(Math.sin(d2) * (double)f);
                    object = new float[]{object3[0] - f2, object3[1] - f3};
                    fArray = new float[]{fArray5[0] - f2, fArray5[1] - f3};
                    object4[i] = (float)PlanController.computeIntersection((float[])object2, fArray6, (float[])object, fArray);
                }
                Wall wall = null;
                object3 = PlanController.this.getWallsArea(false);
                float f4 = 0.05f;
                for (int i = 0; i < ((float[])object4).length; ++i) {
                    Object object5;
                    float f5 = object4[i];
                    float f6 = object4[(i + 1) % fArray2.length];
                    Area area = new Area(PlanController.this.getPath(new Wall((float)f5[0], (float)f5[1], (float)f6[0], (float)f6[1], f4, 0.0f).getPoints()));
                    area.subtract((Area)object3);
                    List list = PlanController.this.getAreaPaths(area);
                    object2 = new ArrayList();
                    int n2 = 0;
                    for (int j = 0; j < list.size(); ++j) {
                        Object object6;
                        Object object7;
                        object5 = PlanController.this.getPathPoints((GeneralPath)list.get(j), false);
                        if (((float[][])object5).length > 4) {
                            object5 = PlanController.this.getPathPoints((GeneralPath)list.get(j), true);
                        }
                        if (((float[][])object5).length != 4) continue;
                        if (Point2D.distanceSq((double)object5[0][0], object5[0][1], object5[1][0], object5[1][1]) < Point2D.distanceSq(object5[0][0], object5[0][1], object5[3][0], object5[3][1])) {
                            object = new float[]{(object5[0][0] + object5[1][0]) / 2.0f, (object5[0][1] + object5[1][1]) / 2.0f};
                            fArray = new float[]{(object5[2][0] + object5[3][0]) / 2.0f, (object5[2][1] + object5[3][1]) / 2.0f};
                        } else {
                            object = new float[]{(object5[0][0] + object5[3][0]) / 2.0f, (object5[0][1] + object5[3][1]) / 2.0f};
                            fArray = new float[]{(object5[1][0] + object5[2][0]) / 2.0f, (object5[1][1] + object5[2][1]) / 2.0f};
                        }
                        if (Point2D.distanceSq((double)object[0], (double)object[1], (double)f5[0], (double)f5[1]) < Point2D.distanceSq(fArray[0], fArray[1], (double)f5[0], (double)f5[1])) {
                            object7 = object;
                            object6 = fArray;
                        } else {
                            object7 = fArray;
                            object6 = object;
                        }
                        if (Point2D.distanceSq((double)object7[0], (double)object7[1], object6[0], object6[1]) > 0.01) {
                            object2.add(PlanController.this.createWall((float)object7[0], (float)object7[1], object6[0], object6[1], null, wall != null && Point2D.distanceSq(wall.getXEnd(), wall.getYEnd(), (double)object7[0], (double)object7[1]) < 0.01 ? wall : null));
                            continue;
                        }
                        ++n2;
                    }
                    if (list.size() > n2 && object2.isEmpty()) {
                        Object object8 = null;
                        object5 = PlanController.this.home.getWalls().iterator();
                        while (object5.hasNext()) {
                            object = (Wall)object5.next();
                            if (!((Wall)object).isAtLevel(PlanController.this.home.getSelectedLevel()) || !((double)Math.abs(((Wall)object).getXStart() - f5[0]) < 0.05) || !((double)Math.abs(((Wall)object).getYStart() - f5[1]) < 0.05) || !((double)Math.abs(((Wall)object).getXEnd() - f6[0]) < 0.05) || !((double)Math.abs(((Wall)object).getYEnd() - f6[1]) < 0.05) || ((Wall)object).getArcExtent() != null && ((Wall)object).getArcExtent().floatValue() != 0.0f) continue;
                            object8 = object;
                            break;
                        }
                        if (object8 == null) {
                            object2.add(PlanController.this.createWall((float)f5[0], (float)f5[1], (float)f6[0], (float)f6[1], null, wall));
                        }
                    }
                    if (object2.size() > 0) {
                        Collections.sort(object2, new Comparator<Wall>((float[])f5){
                            final /* synthetic */ float[] val$sidePoint;
                            {
                                this.val$sidePoint = fArray;
                            }

                            @Override
                            public int compare(Wall wall, Wall wall2) {
                                return Double.compare(Point2D.distanceSq(wall.getXStart(), wall.getYStart(), this.val$sidePoint[0], this.val$sidePoint[1]), Point2D.distanceSq(wall2.getXStart(), wall2.getYStart(), this.val$sidePoint[0], this.val$sidePoint[1]));
                            }
                        });
                        this.newWalls.addAll((Collection<Wall>)object2);
                        wall = (Wall)object2.get(object2.size() - 1);
                        continue;
                    }
                    wall = null;
                }
                if (wall != null && Point2D.distanceSq(wall.getXEnd(), wall.getYEnd(), this.newWalls.get(0).getXStart(), this.newWalls.get(0).getYStart()) < 0.01) {
                    PlanController.this.joinNewWallEndToWall(wall, this.newWalls.get(0), null);
                }
            }
        }

        private void validateDrawnWalls() {
            if (this.newWalls.size() > 0) {
                PlanController.this.postCreateWalls(this.newWalls, this.oldSelection, this.oldBasePlanLocked, this.oldAllLevelsSelection);
                PlanController.this.selectItems(this.newWalls);
            }
            if (PlanController.this.getPointerTypeLastMousePress() == View.PointerType.TOUCH) {
                PlanController.this.setState(PlanController.this.getSelectionState());
            } else {
                PlanController.this.setState(PlanController.this.getWallCreationState());
            }
        }

        private void endWallCreation() {
            this.lastWall = this.wallEndAtStart = this.newWall;
            this.wallStartAtStart = null;
            this.xStart = this.newWall.getXEnd();
            this.yStart = this.newWall.getYEnd();
            this.newWall = null;
            this.wallArcExtent = null;
        }

        public void setEditionActivated(boolean bl) {
            PlanView planView = PlanController.this.getView();
            if (bl) {
                planView.deleteFeedback();
                if (this.newWalls.size() == 0 && this.wallEndAtStart == null && this.wallStartAtStart == null) {
                    planView.setToolTipEditedProperties(new EditableProperty[]{EditableProperty.X, EditableProperty.Y}, new Object[]{Float.valueOf(this.xStart), Float.valueOf(this.yStart)}, this.xStart, this.yStart);
                } else {
                    if (this.newWall == null) {
                        this.createNextWall();
                    }
                    if (this.wallArcExtent == null) {
                        planView.setToolTipEditedProperties(new EditableProperty[]{EditableProperty.LENGTH, EditableProperty.ANGLE, EditableProperty.THICKNESS}, new Object[]{Float.valueOf(this.newWall.getLength()), this.getWallAngleInDegrees(this.newWall), Float.valueOf(this.newWall.getThickness())}, this.newWall.getXEnd(), this.newWall.getYEnd());
                    } else {
                        planView.setToolTipEditedProperties(new EditableProperty[]{EditableProperty.ARC_EXTENT}, new Object[]{new Integer((int)Math.round(Math.toDegrees(this.wallArcExtent.floatValue())))}, this.newWall.getXEnd(), this.newWall.getYEnd());
                    }
                }
                this.showWallFeedback();
            } else if (this.newWall == null) {
                LengthUnit lengthUnit = PlanController.this.preferences.getLengthUnit();
                float f = !lengthUnit.isMetric() ? 300.0f : LengthUnit.footToCentimeter(10.0f);
                this.xLastEnd = this.xStart + f;
                this.yLastEnd = this.yStart;
                this.newWall = PlanController.this.createWall(this.xStart, this.yStart, this.xLastEnd, this.yLastEnd, this.wallStartAtStart, this.wallEndAtStart);
                this.newWalls.add(this.newWall);
                planView.deleteFeedback();
                this.setEditionActivated(true);
            } else if (this.roundWall && this.wallArcExtent == null) {
                this.wallArcExtent = Float.valueOf((float)Math.PI);
                this.newWall.setArcExtent(this.wallArcExtent);
                this.setEditionActivated(true);
            } else if (System.currentTimeMillis() - this.lastWallCreationTime < 300L) {
                if (this.newWalls.size() > 1) {
                    this.newWalls.remove(this.newWall);
                    PlanController.this.home.deleteWall(this.newWall);
                }
                this.validateDrawnWalls();
            } else {
                this.endWallCreation();
                if (this.newWalls.size() > 2 && this.wallStartAtEnd != null) {
                    PlanController.this.joinNewWallEndToWall(this.lastWall, this.wallStartAtEnd, null);
                    this.validateDrawnWalls();
                    return;
                }
                this.createNextWall();
                planView.deleteToolTipFeedback();
                this.setEditionActivated(true);
            }
        }

        private void createNextWall() {
            Wall wall = this.wallEndAtStart != null ? this.wallEndAtStart : this.wallStartAtStart;
            double d = Math.PI - Math.atan2(wall.getYStart() - wall.getYEnd(), wall.getXStart() - wall.getXEnd());
            float f = wall.getStartPointToEndPointDistance();
            this.xLastEnd = (float)((double)this.xStart + (double)f * Math.cos(d -= 1.5707963267948966));
            this.yLastEnd = (float)((double)this.yStart - (double)f * Math.sin(d));
            this.newWall = PlanController.this.createWall(this.xStart, this.yStart, this.xLastEnd, this.yLastEnd, this.wallStartAtStart, wall);
            this.newWall.setThickness(wall.getThickness());
            this.newWalls.add(this.newWall);
            this.lastWallCreationTime = System.currentTimeMillis();
            PlanController.this.deselectAll();
        }

        public void updateEditableProperty(EditableProperty editableProperty, Object object) {
            if (this.newWall == null) {
                float f = PlanController.this.preferences.getLengthUnit().getMaximumLength();
                switch (editableProperty) {
                    case X: {
                        this.xStart = object != null ? ((Number)object).floatValue() : 0.0f;
                        this.xStart = Math.max(-f, Math.min(this.xStart, f));
                        break;
                    }
                    case Y: {
                        this.yStart = object != null ? ((Number)object).floatValue() : 0.0f;
                        this.yStart = Math.max(-f, Math.min(this.yStart, f));
                    }
                }
            } else if (editableProperty == EditableProperty.THICKNESS) {
                float f = object != null ? Math.abs(((Number)object).floatValue()) : 0.0f;
                f = Math.max(0.01f, Math.min(f, 1000.0f));
                this.newWall.setThickness(f);
            } else {
                if (editableProperty == EditableProperty.ARC_EXTENT) {
                    double d = Math.toRadians(object != null ? ((Number)object).doubleValue() : 0.0);
                    this.wallArcExtent = Float.valueOf((float)(Math.signum(d) * Math.min(Math.abs(d), 4.71238898038469)));
                    this.newWall.setArcExtent(this.wallArcExtent);
                    this.showWallAngleFeedback(this.newWall, false);
                    return;
                }
                switch (editableProperty) {
                    case LENGTH: {
                        float f = object != null ? ((Number)object).floatValue() : 0.0f;
                        f = Math.max(0.001f, Math.min(f, PlanController.this.preferences.getLengthUnit().getMaximumLength()));
                        double d = Math.PI - Math.atan2(this.yStart - this.yLastEnd, this.xStart - this.xLastEnd);
                        this.xLastEnd = (float)((double)this.xStart + (double)f * Math.cos(d));
                        this.yLastEnd = (float)((double)this.yStart - (double)f * Math.sin(d));
                        break;
                    }
                    case ANGLE: {
                        double d = Math.toRadians(object != null ? ((Number)object).doubleValue() : 0.0);
                        Wall wall = this.newWall.getWallAtStart();
                        if (wall != null && wall.getStartPointToEndPointDistance() > 0.0f) {
                            d -= Math.atan2(wall.getYStart() - wall.getYEnd(), wall.getXStart() - wall.getXEnd());
                        }
                        float f = this.newWall.getStartPointToEndPointDistance();
                        this.xLastEnd = (float)((double)this.xStart + (double)f * Math.cos(d));
                        this.yLastEnd = (float)((double)this.yStart - (double)f * Math.sin(d));
                        break;
                    }
                    default: {
                        return;
                    }
                }
                this.newWall.setXEnd(this.xLastEnd);
                this.newWall.setYEnd(this.yLastEnd);
            }
            this.showWallFeedback();
        }

        private void showWallFeedback() {
            PlanView planView = PlanController.this.getView();
            if (this.newWall == null) {
                planView.setAlignmentFeedback(Wall.class, null, this.xStart, this.yStart, true);
                planView.makePointVisible(this.xStart, this.yStart);
            } else {
                planView.setAlignmentFeedback(Wall.class, this.newWall, this.xLastEnd, this.yLastEnd, false);
                this.showWallAngleFeedback(this.newWall, false);
                planView.makePointVisible(this.xStart, this.yStart);
                planView.makePointVisible(this.xLastEnd, this.yLastEnd);
                if (this.newWalls.size() > 2 && this.newWalls.get(0).getWallAtStart() == null && this.newWalls.get(0).containsWallStartAt(this.xLastEnd, this.yLastEnd, 0.001f)) {
                    this.wallStartAtEnd = this.newWalls.get(0);
                    PlanController.this.selectItem(this.wallStartAtEnd);
                } else {
                    this.wallStartAtEnd = null;
                    PlanController.this.deselectAll();
                }
            }
        }

        public void toggleMagnetism(boolean bl) {
            this.magnetismEnabled = PlanController.this.preferences.isMagnetismEnabled() ^ bl;
            if (this.newWall != null) {
                this.moveMouse(PlanController.this.getXLastMouseMove(), PlanController.this.getYLastMouseMove());
            }
        }

        public void setAlignmentActivated(boolean bl) {
            this.alignmentActivated = bl;
            this.moveMouse(PlanController.this.getXLastMouseMove(), PlanController.this.getYLastMouseMove());
        }

        public void setDuplicationActivated(boolean bl) {
            this.roundWall = bl;
        }

        public void escape() {
            if (this.newWall != null) {
                PlanController.this.home.deleteWall(this.newWall);
                this.newWalls.remove(this.newWall);
            }
            this.validateDrawnWalls();
        }

        public void exit() {
            PlanView planView = PlanController.this.getView();
            planView.deleteFeedback();
            this.wallStartAtStart = null;
            this.wallEndAtStart = null;
            this.newWall = null;
            this.wallArcExtent = null;
            this.wallStartAtEnd = null;
            this.wallEndAtEnd = null;
            this.lastWall = null;
            this.oldSelection = null;
            this.newWalls = null;
        }
    }

    private abstract class AbstractWallState
    extends ControllerState {
        private String wallLengthToolTipFeedback;
        private String wallAngleToolTipFeedback;
        private String wallArcExtentToolTipFeedback;
        private String wallThicknessToolTipFeedback;

        private AbstractWallState() {
        }

        public void enter() {
            this.wallLengthToolTipFeedback = PlanController.this.preferences.getLocalizedString(PlanController.class, "wallLengthToolTipFeedback", new Object[0]);
            try {
                this.wallAngleToolTipFeedback = PlanController.this.preferences.getLocalizedString(PlanController.class, "wallAngleToolTipFeedback", new Object[0]);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            this.wallArcExtentToolTipFeedback = PlanController.this.preferences.getLocalizedString(PlanController.class, "wallArcExtentToolTipFeedback", new Object[0]);
            try {
                this.wallThicknessToolTipFeedback = PlanController.this.preferences.getLocalizedString(PlanController.class, "wallThicknessToolTipFeedback", new Object[0]);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }

        protected String getToolTipFeedbackText(Wall wall, boolean bl) {
            Float f = wall.getArcExtent();
            if (!bl && f != null) {
                return "<html>" + String.format(this.wallArcExtentToolTipFeedback, Math.round(Math.toDegrees(f.floatValue())));
            }
            float f2 = wall.getStartPointToEndPointDistance();
            String string = "<html>" + String.format(this.wallLengthToolTipFeedback, PlanController.this.preferences.getLengthUnit().getFormatWithUnit().format(Float.valueOf(f2)));
            if (this.wallAngleToolTipFeedback != null && this.wallAngleToolTipFeedback.length() > 0) {
                string = string + "<br>" + String.format(this.wallAngleToolTipFeedback, this.getWallAngleInDegrees(wall, f2));
            }
            if (this.wallThicknessToolTipFeedback != null && this.wallThicknessToolTipFeedback.length() > 0) {
                string = string + "<br>" + String.format(this.wallThicknessToolTipFeedback, PlanController.this.preferences.getLengthUnit().getFormatWithUnit().format(Float.valueOf(wall.getThickness())));
            }
            return string;
        }

        protected Integer getWallAngleInDegrees(Wall wall) {
            return this.getWallAngleInDegrees(wall, wall.getStartPointToEndPointDistance());
        }

        private Integer getWallAngleInDegrees(Wall wall, float f) {
            Wall wall2 = wall.getWallAtStart();
            if (wall2 != null) {
                float f2 = wall2.getStartPointToEndPointDistance();
                if (f != 0.0f && f2 != 0.0f) {
                    int n;
                    float f3 = (wall.getXEnd() - wall.getXStart()) / f;
                    float f4 = (wall.getYEnd() - wall.getYStart()) / f;
                    float f5 = (wall2.getXEnd() - wall2.getXStart()) / f2;
                    float f6 = (wall2.getYEnd() - wall2.getYStart()) / f2;
                    if (wall2.getWallAtStart() == wall) {
                        f5 = -f5;
                        f6 = -f6;
                    }
                    if ((n = (int)Math.round(180.0 - Math.toDegrees(Math.atan2(f4 * f5 - f3 * f6, f3 * f5 + f4 * f6)))) > 180) {
                        n -= 360;
                    }
                    return n;
                }
            }
            if (f == 0.0f) {
                return 0;
            }
            return (int)Math.round(Math.toDegrees(Math.atan2(wall.getYStart() - wall.getYEnd(), wall.getXEnd() - wall.getXStart())));
        }

        protected float getArcExtent(float f, float f2, float f3, float f4, float f5, float f6) {
            float[] fArray = this.getCircumscribedCircleCenter(f, f2, f3, f4, f5, f6);
            double d = Point2D.distance(f, f2, f3, f4) / 2.0;
            double d2 = Float.isInfinite(fArray[0]) || Float.isInfinite(fArray[1]) ? Double.POSITIVE_INFINITY : Line2D.ptLineDist(f, f2, f3, f4, fArray[0], fArray[1]);
            int n = Line2D.relativeCCW(f, f2, f3, f4, f5, f6);
            int n2 = Line2D.relativeCCW(f, f2, f3, f4, fArray[0], fArray[1]);
            float f7 = n2 == n ? (float)(Math.PI + 2.0 * Math.atan2(d2, d)) : (float)(2.0 * Math.atan2(d, d2));
            f7 = Math.min(f7, 4.712389f);
            return f7 *= (float)n;
        }

        private float[] getCircumscribedCircleCenter(float f, float f2, float f3, float f4, float f5, float f6) {
            float[][] fArray = this.getBissectorLine(f, f2, f3, f4);
            float[][] fArray2 = this.getBissectorLine(f, f2, f5, f6);
            float[] fArray3 = PlanController.computeIntersection(fArray[0], fArray[1], fArray2[0], fArray2[1]);
            return fArray3;
        }

        private float[][] getBissectorLine(float f, float f2, float f3, float f4) {
            float f5 = (f + f3) / 2.0f;
            float f6 = (f2 + f4) / 2.0f;
            float f7 = (f - f3) / (f4 - f2);
            if ((double)f7 > 1.0E10) {
                return new float[][]{{f5, f6}, {f5, f6 + 1.0f}};
            }
            return new float[][]{{f5, f6}, {f5 + 1.0f, f7 + f6}};
        }

        protected void showWallAngleFeedback(Wall wall, boolean bl) {
            Wall wall2;
            Float f = wall.getArcExtent();
            if (!bl && f != null) {
                if (f.floatValue() < 0.0f) {
                    PlanController.this.getView().setAngleFeedback(wall.getXArcCircleCenter(), wall.getYArcCircleCenter(), wall.getXStart(), wall.getYStart(), wall.getXEnd(), wall.getYEnd());
                } else {
                    PlanController.this.getView().setAngleFeedback(wall.getXArcCircleCenter(), wall.getYArcCircleCenter(), wall.getXEnd(), wall.getYEnd(), wall.getXStart(), wall.getYStart());
                }
            } else if (this.wallAngleToolTipFeedback != null && this.wallAngleToolTipFeedback.length() > 0 && (wall2 = wall.getWallAtStart()) != null) {
                if (wall2.getWallAtStart() == wall) {
                    if (this.getWallAngleInDegrees(wall) > 0) {
                        PlanController.this.getView().setAngleFeedback(wall.getXStart(), wall.getYStart(), wall2.getXEnd(), wall2.getYEnd(), wall.getXEnd(), wall.getYEnd());
                    } else {
                        PlanController.this.getView().setAngleFeedback(wall.getXStart(), wall.getYStart(), wall.getXEnd(), wall.getYEnd(), wall2.getXEnd(), wall2.getYEnd());
                    }
                } else if (this.getWallAngleInDegrees(wall) > 0) {
                    PlanController.this.getView().setAngleFeedback(wall.getXStart(), wall.getYStart(), wall2.getXStart(), wall2.getYStart(), wall.getXEnd(), wall.getYEnd());
                } else {
                    PlanController.this.getView().setAngleFeedback(wall.getXStart(), wall.getYStart(), wall.getXEnd(), wall.getYEnd(), wall2.getXStart(), wall2.getYStart());
                }
            }
        }
    }

    private class WallCreationState
    extends AbstractModeChangeState {
        private boolean magnetismEnabled;

        private WallCreationState() {
        }

        public Mode getMode() {
            return Mode.WALL_CREATION;
        }

        public void enter() {
            PlanController.this.getView().setCursor(PlanView.CursorType.DRAW);
            this.toggleMagnetism(PlanController.this.wasMagnetismToggledLastMousePress());
        }

        public void moveMouse(float f, float f2) {
            if (this.magnetismEnabled) {
                WallPointWithAngleMagnetism wallPointWithAngleMagnetism = new WallPointWithAngleMagnetism(null, f, f2, f, f2);
                f = wallPointWithAngleMagnetism.getX();
                f2 = wallPointWithAngleMagnetism.getY();
            }
            PlanController.this.getView().setAlignmentFeedback(Wall.class, null, f, f2, false);
        }

        public void pressMouse(float f, float f2, int n, boolean bl, boolean bl2) {
            PlanController.this.setState(PlanController.this.getWallDrawingState());
        }

        public void setEditionActivated(boolean bl) {
            if (bl) {
                PlanController.this.setState(PlanController.this.getWallDrawingState());
                PlanController.this.setEditionActivated(bl);
            }
        }

        public void toggleMagnetism(boolean bl) {
            this.magnetismEnabled = PlanController.this.preferences.isMagnetismEnabled() ^ bl;
            if (PlanController.this.getPointerTypeLastMousePress() != View.PointerType.TOUCH) {
                this.moveMouse(PlanController.this.getXLastMouseMove(), PlanController.this.getYLastMouseMove());
            }
        }

        public void exit() {
            PlanController.this.getView().deleteFeedback();
        }
    }

    private class DragAndDropState
    extends ControllerState {
        private float xLastMouseMove;
        private float yLastMouseMove;
        private HomePieceOfFurniture draggedPieceOfFurniture;
        private float xDraggedPieceOfFurniture;
        private float yDraggedPieceOfFurniture;
        private float angleDraggedPieceOfFurniture;
        private float depthDraggedPieceOfFurniture;
        private float elevationDraggedPieceOfFurniture;

        private DragAndDropState() {
        }

        public Mode getMode() {
            return Mode.SELECTION;
        }

        public boolean isModificationState() {
            return false;
        }

        public boolean isBasePlanModificationState() {
            return this.draggedPieceOfFurniture != null && PlanController.this.isPieceOfFurniturePartOfBasePlan(this.draggedPieceOfFurniture);
        }

        public void enter() {
            this.xLastMouseMove = 0.0f;
            this.yLastMouseMove = 0.0f;
            PlanController.this.getView().setDraggedItemsFeedback(PlanController.this.draggedItems);
            if (PlanController.this.draggedItems.size() == 1 && PlanController.this.draggedItems.get(0) instanceof HomePieceOfFurniture) {
                this.draggedPieceOfFurniture = (HomePieceOfFurniture)PlanController.this.draggedItems.get(0);
                this.xDraggedPieceOfFurniture = this.draggedPieceOfFurniture.getX();
                this.yDraggedPieceOfFurniture = this.draggedPieceOfFurniture.getY();
                this.angleDraggedPieceOfFurniture = this.draggedPieceOfFurniture.getAngle();
                this.depthDraggedPieceOfFurniture = this.draggedPieceOfFurniture.getDepth();
                this.elevationDraggedPieceOfFurniture = this.draggedPieceOfFurniture.getElevation();
            }
        }

        public void moveMouse(float f, float f2) {
            ArrayList<Selectable> arrayList = new ArrayList<Selectable>(PlanController.this.draggedItems);
            PlanController.this.moveItems(PlanController.this.draggedItems, f - this.xLastMouseMove, f2 - this.yLastMouseMove);
            if (this.draggedPieceOfFurniture != null && PlanController.this.preferences.isMagnetismEnabled()) {
                this.draggedPieceOfFurniture.setX(this.xDraggedPieceOfFurniture);
                this.draggedPieceOfFurniture.setY(this.yDraggedPieceOfFurniture);
                this.draggedPieceOfFurniture.setAngle(this.angleDraggedPieceOfFurniture);
                if (this.draggedPieceOfFurniture.isResizable()) {
                    this.draggedPieceOfFurniture.setDepth(this.depthDraggedPieceOfFurniture);
                    this.draggedPieceOfFurniture.setDepthInPlan(this.depthDraggedPieceOfFurniture);
                }
                this.draggedPieceOfFurniture.setElevation(this.elevationDraggedPieceOfFurniture);
                this.draggedPieceOfFurniture.move(f, f2);
                boolean bl = PlanController.this.adjustPieceOfFurnitureElevation(this.draggedPieceOfFurniture) != null;
                Wall wall = PlanController.this.adjustPieceOfFurnitureOnWallAt(this.draggedPieceOfFurniture, f, f2, true);
                if (!bl) {
                    PlanController.this.adjustPieceOfFurnitureSideBySideAt(this.draggedPieceOfFurniture, wall == null, wall);
                }
                if (wall != null) {
                    PlanController.this.getView().setDimensionLinesFeedback(PlanController.this.getDimensionLinesAlongWall(this.draggedPieceOfFurniture, wall));
                } else {
                    PlanController.this.getView().setDimensionLinesFeedback(null);
                }
            }
            PlanController.this.getView().setDraggedItemsFeedback(arrayList);
            this.xLastMouseMove = f;
            this.yLastMouseMove = f2;
        }

        public void exit() {
            this.draggedPieceOfFurniture = null;
            PlanController.this.getView().deleteFeedback();
        }
    }

    private class PanningState
    extends ControllerState {
        private Integer xLastMouseMove;
        private Integer yLastMouseMove;

        private PanningState() {
        }

        public Mode getMode() {
            return Mode.PANNING;
        }

        public void setMode(Mode mode) {
            if (mode == Mode.SELECTION) {
                PlanController.this.setState(PlanController.this.getSelectionState());
            } else if (mode == Mode.WALL_CREATION) {
                PlanController.this.setState(PlanController.this.getWallCreationState());
            } else if (mode == Mode.ROOM_CREATION) {
                PlanController.this.setState(PlanController.this.getRoomCreationState());
            } else if (mode == Mode.POLYLINE_CREATION) {
                PlanController.this.setState(PlanController.this.getPolylineCreationState());
            } else if (mode == Mode.DIMENSION_LINE_CREATION) {
                PlanController.this.setState(PlanController.this.getDimensionLineCreationState());
            } else if (mode == Mode.LABEL_CREATION) {
                PlanController.this.setState(PlanController.this.getLabelCreationState());
            }
        }

        public void enter() {
            PlanController.this.getView().setCursor(PlanView.CursorType.PANNING);
        }

        public void moveSelection(float f, float f2) {
            PlanController.this.getView().moveView(f * 10.0f, f2 * 10.0f);
        }

        public void pressMouse(float f, float f2, int n, boolean bl, boolean bl2) {
            if (n == 1) {
                this.xLastMouseMove = PlanController.this.getView().convertXModelToScreen(f);
                this.yLastMouseMove = PlanController.this.getView().convertYModelToScreen(f2);
            } else {
                this.xLastMouseMove = null;
                this.yLastMouseMove = null;
            }
        }

        public void moveMouse(float f, float f2) {
            if (this.xLastMouseMove != null) {
                int n = PlanController.this.getView().convertXModelToScreen(f);
                int n2 = PlanController.this.getView().convertYModelToScreen(f2);
                PlanController.this.getView().moveView((float)(this.xLastMouseMove - n) / PlanController.this.getScale(), (float)(this.yLastMouseMove - n2) / PlanController.this.getScale());
                this.xLastMouseMove = n;
                this.yLastMouseMove = n2;
            }
        }

        public void releaseMouse(float f, float f2) {
            this.xLastMouseMove = null;
        }

        public void escape() {
            this.xLastMouseMove = null;
        }

        public void zoom(float f) {
            PlanController.this.setScale(PlanController.this.getScale() * f);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class RectangleSelectionState
    extends ControllerState {
        private List<Selectable> selectedItemsMousePressed;
        private boolean ignoreRectangleSelection;
        private boolean mouseMoved;

        private RectangleSelectionState() {
        }

        @Override
        public Mode getMode() {
            return Mode.SELECTION;
        }

        @Override
        public boolean isModificationState() {
            return true;
        }

        @Override
        public void enter() {
            Selectable selectable = PlanController.this.getSelectableItemAt(PlanController.this.getXLastMousePress(), PlanController.this.getYLastMousePress());
            if (selectable == null && !PlanController.this.wasShiftDownLastMousePress()) {
                PlanController.this.deselectAll();
            }
            this.selectedItemsMousePressed = new ArrayList<Selectable>(PlanController.this.home.getSelectedItems());
            List<HomePieceOfFurniture> list = PlanController.this.home.getFurniture();
            this.ignoreRectangleSelection = false;
            for (Selectable selectable2 : this.selectedItemsMousePressed) {
                if (!(selectable2 instanceof HomePieceOfFurniture) || list.contains(selectable2)) continue;
                this.ignoreRectangleSelection = true;
                break;
            }
            this.mouseMoved = false;
        }

        @Override
        public void moveMouse(float f, float f2) {
            this.mouseMoved = true;
            if (!this.ignoreRectangleSelection) {
                this.updateSelectedItems(PlanController.this.getXLastMousePress(), PlanController.this.getYLastMousePress(), f, f2, this.selectedItemsMousePressed);
                PlanView planView = PlanController.this.getView();
                planView.setRectangleFeedback(PlanController.this.getXLastMousePress(), PlanController.this.getYLastMousePress(), f, f2);
                planView.makePointVisible(f, f2);
            }
        }

        @Override
        public void releaseMouse(float f, float f2) {
            Selectable selectable;
            if (!this.mouseMoved && (selectable = PlanController.this.getSelectableItemAt(f, f2, false)) != null) {
                if (this.selectedItemsMousePressed.contains(selectable)) {
                    this.selectedItemsMousePressed.remove(selectable);
                } else {
                    for (int i = this.selectedItemsMousePressed.size() - 1; i >= 0; --i) {
                        Selectable selectable2 = this.selectedItemsMousePressed.get(i);
                        if (!(selectable2 instanceof Camera) && (!(selectable instanceof HomePieceOfFurniture) || !(selectable2 instanceof HomeFurnitureGroup) || !((HomeFurnitureGroup)selectable2).getAllFurniture().contains(selectable)) && (!(selectable instanceof HomeFurnitureGroup) || !(selectable2 instanceof HomePieceOfFurniture) || !((HomeFurnitureGroup)selectable).getAllFurniture().contains(selectable2))) continue;
                        this.selectedItemsMousePressed.remove(i);
                    }
                    if (!(selectable instanceof Camera) || this.selectedItemsMousePressed.size() == 0) {
                        this.selectedItemsMousePressed.add(selectable);
                    }
                }
                PlanController.this.selectItems(this.selectedItemsMousePressed, PlanController.this.home.isAllLevelsSelection() && PlanController.this.wasShiftDownLastMousePress());
            }
            PlanController.this.setState(PlanController.this.getSelectionState());
        }

        @Override
        public void escape() {
            PlanController.this.setState(PlanController.this.getSelectionState());
        }

        @Override
        public void exit() {
            PlanController.this.getView().deleteFeedback();
            this.selectedItemsMousePressed = null;
        }

        private void updateSelectedItems(float f, float f2, float f3, float f4, List<Selectable> list) {
            boolean bl = PlanController.this.wasShiftDownLastMousePress();
            ArrayList<Object> arrayList = bl ? new ArrayList<Selectable>(list) : new ArrayList();
            for (Selectable selectable : PlanController.this.getSelectableItemsIntersectingRectangle(f, f2, f3, f4)) {
                if (selectable instanceof Camera) continue;
                if (bl) {
                    if (list.contains(selectable)) {
                        arrayList.remove(selectable);
                        continue;
                    }
                    arrayList.add(selectable);
                    continue;
                }
                if (list.contains(selectable)) continue;
                arrayList.add(selectable);
            }
            PlanController.this.selectItems(arrayList, PlanController.this.home.isAllLevelsSelection() && bl);
        }
    }

    private class SelectionMoveState
    extends ControllerState {
        private float xLastMouseMove;
        private float yLastMouseMove;
        private boolean mouseMoved;
        private List<Selectable> oldSelection;
        private boolean selectionUpdateNeeded;
        private List<Selectable> movedItems;
        private List<Selectable> duplicatedItems;
        private HomePieceOfFurniture movedPieceOfFurniture;
        private float angleMovedPieceOfFurniture;
        private float depthMovedPieceOfFurniture;
        private float elevationMovedPieceOfFurniture;
        private float xMovedPieceOfFurniture;
        private float yMovedPieceOfFurniture;
        private boolean movedDoorOrWindowBoundToWall;
        private boolean magnetismEnabled;
        private boolean duplicationActivated;
        private boolean alignmentActivated;
        private boolean basePlanModification;

        private SelectionMoveState() {
        }

        public Mode getMode() {
            return Mode.SELECTION;
        }

        public boolean isModificationState() {
            return true;
        }

        public boolean isBasePlanModificationState() {
            return this.basePlanModification;
        }

        public void enter() {
            this.xLastMouseMove = PlanController.this.getXLastMousePress();
            this.yLastMouseMove = PlanController.this.getYLastMousePress();
            this.mouseMoved = false;
            List<Selectable> list = PlanController.this.getSelectableItemsAt(PlanController.this.getXLastMousePress(), PlanController.this.getYLastMousePress());
            ArrayList<Selectable> arrayList = new ArrayList<Selectable>(list);
            float f = PlanController.this.getSelectionMargin();
            for (Selectable object2 : list) {
                if (!(object2 instanceof HomeFurnitureGroup)) continue;
                for (HomePieceOfFurniture homePieceOfFurniture : ((HomeFurnitureGroup)object2).getAllFurniture()) {
                    if (!homePieceOfFurniture.containsPoint(PlanController.this.getXLastMousePress(), PlanController.this.getYLastMousePress(), f)) continue;
                    arrayList.add(homePieceOfFurniture);
                }
            }
            this.oldSelection = PlanController.this.home.getSelectedItems();
            this.toggleMagnetism(PlanController.this.wasMagnetismToggledLastMousePress());
            this.selectionUpdateNeeded = Collections.disjoint(arrayList, this.oldSelection);
            if (this.selectionUpdateNeeded && PlanController.this.getPointerTypeLastMousePress() != View.PointerType.TOUCH) {
                PlanController.this.selectItem(PlanController.this.getSelectableItemAt(PlanController.this.getXLastMousePress(), PlanController.this.getYLastMousePress(), false));
            }
            List<Selectable> list2 = PlanController.this.home.getSelectedItems();
            this.movedItems = new ArrayList<Selectable>(list2.size());
            this.basePlanModification = false;
            Iterator iterator = list2.iterator();
            while (iterator.hasNext()) {
                Selectable selectable = (Selectable)iterator.next();
                if (!PlanController.this.isItemMovable(selectable)) continue;
                this.movedItems.add(selectable);
                if (this.basePlanModification || !PlanController.this.isItemPartOfBasePlan(selectable)) continue;
                this.basePlanModification = true;
            }
            if (this.movedItems.size() == 1 && this.movedItems.get(0) instanceof HomePieceOfFurniture) {
                this.movedPieceOfFurniture = (HomePieceOfFurniture)this.movedItems.get(0);
                this.xMovedPieceOfFurniture = this.movedPieceOfFurniture.getX();
                this.yMovedPieceOfFurniture = this.movedPieceOfFurniture.getY();
                this.angleMovedPieceOfFurniture = this.movedPieceOfFurniture.getAngle();
                this.depthMovedPieceOfFurniture = this.movedPieceOfFurniture.getDepth();
                this.elevationMovedPieceOfFurniture = this.movedPieceOfFurniture.getElevation();
                this.movedDoorOrWindowBoundToWall = this.movedPieceOfFurniture instanceof HomeDoorOrWindow && ((HomeDoorOrWindow)this.movedPieceOfFurniture).isBoundToWall();
            }
            this.duplicatedItems = null;
            this.duplicationActivated = PlanController.this.wasDuplicationActivatedLastMousePress() && !PlanController.this.home.isAllLevelsSelection();
            this.alignmentActivated = PlanController.this.wasAlignmentActivatedLastMousePress();
            if (PlanController.this.getPointerTypeLastMousePress() != View.PointerType.TOUCH || !this.selectionUpdateNeeded) {
                PlanController.this.getView().setCursor(PlanView.CursorType.MOVE);
            }
        }

        public void moveMouse(float f, float f2) {
            if (PlanController.this.getPointerTypeLastMousePress() == View.PointerType.TOUCH && this.selectionUpdateNeeded) {
                PlanController.this.setState(new ControllerStateDecorator(PlanController.this.getPanningState()){

                    public void enter() {
                        super.enter();
                        this.pressMouse(PlanController.this.getXLastMousePress(), PlanController.this.getYLastMousePress(), 1, PlanController.this.wasShiftDownLastMousePress(), PlanController.this.wasDuplicationActivatedLastMousePress());
                        this.moveMouse(PlanController.this.getXLastMouseMove(), PlanController.this.getYLastMouseMove());
                    }

                    public void releaseMouse(float f, float f2) {
                        this.escape();
                    }

                    public void escape() {
                        super.escape();
                        PlanController.this.setState(PlanController.this.getSelectionState());
                    }
                });
            } else {
                if (!this.mouseMoved) {
                    this.toggleDuplication(this.duplicationActivated);
                }
                if (this.alignmentActivated) {
                    PointWithAngleMagnetism pointWithAngleMagnetism = new PointWithAngleMagnetism(PlanController.this.getXLastMousePress(), PlanController.this.getYLastMousePress(), f, f2, PlanController.this.preferences.getLengthUnit(), PlanController.this.getView().getPixelLength(), 4);
                    f = pointWithAngleMagnetism.getX();
                    f2 = pointWithAngleMagnetism.getY();
                }
                if (this.movedPieceOfFurniture != null) {
                    this.movedPieceOfFurniture.setX(this.xMovedPieceOfFurniture);
                    this.movedPieceOfFurniture.setY(this.yMovedPieceOfFurniture);
                    this.movedPieceOfFurniture.setAngle(this.angleMovedPieceOfFurniture);
                    if (this.movedPieceOfFurniture instanceof HomeDoorOrWindow && this.movedPieceOfFurniture.isResizable() && PlanController.this.isItemResizable(this.movedPieceOfFurniture)) {
                        this.movedPieceOfFurniture.setDepth(this.depthMovedPieceOfFurniture);
                    }
                    this.movedPieceOfFurniture.setElevation(this.elevationMovedPieceOfFurniture);
                    this.movedPieceOfFurniture.move(f - PlanController.this.getXLastMousePress(), f2 - PlanController.this.getYLastMousePress());
                    if (this.magnetismEnabled && !this.alignmentActivated) {
                        boolean bl = PlanController.this.adjustPieceOfFurnitureElevation(this.movedPieceOfFurniture) != null;
                        Wall wall = PlanController.this.adjustPieceOfFurnitureOnWallAt(this.movedPieceOfFurniture, f, f2, false);
                        if (!bl) {
                            PlanController.this.adjustPieceOfFurnitureSideBySideAt(this.movedPieceOfFurniture, false, wall);
                        }
                        if (wall != null) {
                            PlanController.this.getView().setDimensionLinesFeedback(PlanController.this.getDimensionLinesAlongWall(this.movedPieceOfFurniture, wall));
                        } else {
                            PlanController.this.getView().setDimensionLinesFeedback(null);
                        }
                    }
                } else {
                    PlanController.this.moveItems(this.movedItems, f - this.xLastMouseMove, f2 - this.yLastMouseMove);
                }
                if (!this.mouseMoved) {
                    PlanController.this.selectItems(this.movedItems, PlanController.this.home.isAllLevelsSelection());
                }
                PlanController.this.getView().makePointVisible(f, f2);
                this.xLastMouseMove = f;
                this.yLastMouseMove = f2;
                this.mouseMoved = true;
            }
        }

        public void releaseMouse(float f, float f2) {
            if (this.mouseMoved) {
                if (this.movedItems.size() > 0 && !(this.movedItems.get(0) instanceof Camera)) {
                    if (this.duplicatedItems != null) {
                        PlanController.this.postItemsDuplication(this.movedItems, this.duplicatedItems);
                    } else if (this.movedPieceOfFurniture != null) {
                        PlanController.this.postPieceOfFurnitureMove(this.movedPieceOfFurniture, this.movedPieceOfFurniture.getX() - this.xMovedPieceOfFurniture, this.movedPieceOfFurniture.getY() - this.yMovedPieceOfFurniture, this.angleMovedPieceOfFurniture, this.depthMovedPieceOfFurniture, this.elevationMovedPieceOfFurniture, this.movedDoorOrWindowBoundToWall);
                    } else {
                        PlanController.this.postItemsMove(this.movedItems, this.oldSelection, this.xLastMouseMove - PlanController.this.getXLastMousePress(), this.yLastMouseMove - PlanController.this.getYLastMousePress());
                    }
                }
            } else if (PlanController.this.getPointerTypeLastMousePress() == View.PointerType.TOUCH || !Collections.disjoint(PlanController.this.home.getSelectedItems(), this.oldSelection)) {
                Selectable selectable = PlanController.this.getSelectableItemAt(f, f2, false);
                if (selectable != null) {
                    PlanController.this.selectItem(selectable);
                } else {
                    PlanController.this.deselectAll();
                }
            }
            PlanController.this.setState(PlanController.this.getSelectionState());
        }

        public void toggleMagnetism(boolean bl) {
            this.magnetismEnabled = PlanController.this.preferences.isMagnetismEnabled() ^ bl;
            if (this.movedPieceOfFurniture != null) {
                this.moveMouse(PlanController.this.getXLastMouseMove(), PlanController.this.getYLastMouseMove());
                if (!this.magnetismEnabled) {
                    PlanController.this.getView().deleteFeedback();
                }
            }
        }

        public void escape() {
            if (this.mouseMoved) {
                if (this.duplicatedItems != null) {
                    PlanController.this.doDeleteItems(this.movedItems);
                    PlanController.this.selectItems(this.duplicatedItems);
                } else if (this.movedPieceOfFurniture != null) {
                    this.movedPieceOfFurniture.setX(this.xMovedPieceOfFurniture);
                    this.movedPieceOfFurniture.setY(this.yMovedPieceOfFurniture);
                    this.movedPieceOfFurniture.setAngle(this.angleMovedPieceOfFurniture);
                    if (this.movedPieceOfFurniture instanceof HomeDoorOrWindow && this.movedPieceOfFurniture.isResizable() && PlanController.this.isItemResizable(this.movedPieceOfFurniture)) {
                        this.movedPieceOfFurniture.setDepth(this.depthMovedPieceOfFurniture);
                    }
                    this.movedPieceOfFurniture.setElevation(this.elevationMovedPieceOfFurniture);
                    if (this.movedPieceOfFurniture instanceof HomeDoorOrWindow) {
                        ((HomeDoorOrWindow)this.movedPieceOfFurniture).setBoundToWall(this.movedDoorOrWindowBoundToWall);
                    }
                } else {
                    PlanController.this.moveItems(this.movedItems, PlanController.this.getXLastMousePress() - this.xLastMouseMove, PlanController.this.getYLastMousePress() - this.yLastMouseMove);
                }
            }
            PlanController.this.setState(PlanController.this.getSelectionState());
        }

        public void setDuplicationActivated(boolean bl) {
            bl &= !PlanController.this.home.isAllLevelsSelection();
            if (this.mouseMoved) {
                this.toggleDuplication(bl);
            }
            this.duplicationActivated = bl;
        }

        public void setAlignmentActivated(boolean bl) {
            if (PlanController.this.getPointerTypeLastMousePress() == View.PointerType.TOUCH && this.selectionUpdateNeeded && !this.duplicationActivated) {
                PlanController.this.setState(PlanController.this.getSelectionState());
                PlanController.this.pressMouse(PlanController.this.getXLastMousePress(), PlanController.this.getYLastMousePress(), 1, true, false, false, false, PlanController.this.getPointerTypeLastMousePress());
            } else {
                this.alignmentActivated = bl;
                if (this.mouseMoved) {
                    this.moveMouse(PlanController.this.getXLastMouseMove(), PlanController.this.getYLastMouseMove());
                }
                if (this.alignmentActivated) {
                    PlanController.this.getView().deleteFeedback();
                }
            }
        }

        private void toggleDuplication(boolean bl) {
            if (this.movedItems.size() > 1 || this.movedItems.size() == 1 && !(this.movedItems.get(0) instanceof Camera) && !(this.movedItems.get(0) instanceof Compass)) {
                if (bl && this.duplicatedItems == null) {
                    this.duplicatedItems = this.movedItems;
                    this.movedItems = new ArrayList<Selectable>();
                    for (Selectable selectable : Home.duplicate(this.duplicatedItems)) {
                        if (selectable instanceof Wall) {
                            PlanController.this.home.addWall((Wall)selectable);
                        } else if (selectable instanceof Room) {
                            PlanController.this.home.addRoom((Room)selectable);
                        } else if (selectable instanceof Polyline) {
                            PlanController.this.home.addPolyline((Polyline)selectable);
                        } else if (selectable instanceof DimensionLine) {
                            PlanController.this.home.addDimensionLine((DimensionLine)selectable);
                        } else if (selectable instanceof HomePieceOfFurniture) {
                            PlanController.this.home.addPieceOfFurniture((HomePieceOfFurniture)selectable);
                        } else {
                            if (!(selectable instanceof Label)) continue;
                            PlanController.this.home.addLabel((Label)selectable);
                        }
                        this.movedItems.add(selectable);
                    }
                    if (this.movedPieceOfFurniture != null) {
                        this.movedPieceOfFurniture.setX(this.xMovedPieceOfFurniture);
                        this.movedPieceOfFurniture.setY(this.yMovedPieceOfFurniture);
                        this.movedPieceOfFurniture.setAngle(this.angleMovedPieceOfFurniture);
                        if (this.movedPieceOfFurniture instanceof HomeDoorOrWindow && this.movedPieceOfFurniture.isResizable() && PlanController.this.isItemResizable(this.movedPieceOfFurniture)) {
                            this.movedPieceOfFurniture.setDepth(this.depthMovedPieceOfFurniture);
                        }
                        this.movedPieceOfFurniture.setElevation(this.elevationMovedPieceOfFurniture);
                        this.movedPieceOfFurniture = (HomePieceOfFurniture)this.movedItems.get(0);
                    } else {
                        PlanController.this.moveItems(this.duplicatedItems, PlanController.this.getXLastMousePress() - this.xLastMouseMove, PlanController.this.getYLastMousePress() - this.yLastMouseMove);
                    }
                    PlanController.this.getView().setCursor(PlanView.CursorType.DUPLICATION);
                } else if (!bl && this.duplicatedItems != null) {
                    PlanController.this.doDeleteItems(this.movedItems);
                    PlanController.this.moveItems(this.duplicatedItems, this.xLastMouseMove - PlanController.this.getXLastMousePress(), this.yLastMouseMove - PlanController.this.getYLastMousePress());
                    this.movedItems = this.duplicatedItems;
                    this.duplicatedItems = null;
                    if (this.movedPieceOfFurniture != null) {
                        this.movedPieceOfFurniture = (HomePieceOfFurniture)this.movedItems.get(0);
                    }
                    PlanController.this.getView().setCursor(PlanView.CursorType.MOVE);
                }
                PlanController.this.selectItems(this.movedItems, PlanController.this.home.isAllLevelsSelection());
            }
        }

        public void exit() {
            PlanController.this.getView().deleteFeedback();
            this.movedItems = null;
            this.duplicatedItems = null;
            this.movedPieceOfFurniture = null;
        }
    }

    private class SelectionState
    extends AbstractModeChangeState {
        private final SelectionListener selectionListener;

        private SelectionState() {
            this.selectionListener = new SelectionListener(){

                public void selectionChanged(SelectionEvent selectionEvent) {
                    List<Selectable> list = PlanController.this.home.getSelectedItems();
                    PlanController.this.getView().setResizeIndicatorVisible(list.size() == 1 && (PlanController.this.isItemResizable(list.get(0)) || PlanController.this.isItemMovable(list.get(0))));
                }
            };
        }

        public Mode getMode() {
            return Mode.SELECTION;
        }

        public void enter() {
            if (PlanController.this.getView() != null) {
                if (PlanController.this.getPointerTypeLastMousePress() != View.PointerType.TOUCH) {
                    this.moveMouse(PlanController.this.getXLastMouseMove(), PlanController.this.getYLastMouseMove());
                }
                PlanController.this.home.addSelectionListener(this.selectionListener);
                this.selectionListener.selectionChanged(null);
            }
        }

        public void moveMouse(float f, float f2) {
            if (PlanController.this.getRotatedLabelAt(f, f2) != null || PlanController.this.getYawRotatedCameraAt(f, f2) != null || PlanController.this.getPitchRotatedCameraAt(f, f2) != null) {
                PlanController.this.getView().setCursor(PlanView.CursorType.ROTATION);
            } else if (PlanController.this.getElevatedLabelAt(f, f2) != null || PlanController.this.getElevatedCameraAt(f, f2) != null) {
                PlanController.this.getView().setCursor(PlanView.CursorType.ELEVATION);
            } else if (PlanController.this.getRoomNameAt(f, f2) != null || PlanController.this.getRoomAreaAt(f, f2) != null) {
                PlanController.this.getView().setCursor(PlanView.CursorType.RESIZE);
            } else if (PlanController.this.getRoomRotatedNameAt(f, f2) != null || PlanController.this.getRoomRotatedAreaAt(f, f2) != null) {
                PlanController.this.getView().setCursor(PlanView.CursorType.ROTATION);
            } else if (PlanController.this.getResizedDimensionLineStartAt(f, f2) != null || PlanController.this.getResizedDimensionLineEndAt(f, f2) != null || PlanController.this.getWidthAndDepthResizedPieceOfFurnitureAt(f, f2) != null || PlanController.this.getResizedWallStartAt(f, f2) != null || PlanController.this.getResizedWallEndAt(f, f2) != null || PlanController.this.getResizedPolylineAt(f, f2) != null || PlanController.this.getResizedRoomAt(f, f2) != null) {
                PlanController.this.getView().setCursor(PlanView.CursorType.RESIZE);
            } else if (PlanController.this.getPitchRotatedPieceOfFurnitureAt(f, f2) != null || PlanController.this.getRollRotatedPieceOfFurnitureAt(f, f2) != null) {
                PlanController.this.getView().setCursor(PlanView.CursorType.ROTATION);
            } else if (PlanController.this.getModifiedLightPowerAt(f, f2) != null) {
                PlanController.this.getView().setCursor(PlanView.CursorType.POWER);
            } else if (PlanController.this.getOffsetDimensionLineAt(f, f2) != null || PlanController.this.getHeightResizedPieceOfFurnitureAt(f, f2) != null || PlanController.this.getArcExtentWallAt(f, f2) != null) {
                PlanController.this.getView().setCursor(PlanView.CursorType.HEIGHT);
            } else if (PlanController.this.getRotatedPieceOfFurnitureAt(f, f2) != null) {
                PlanController.this.getView().setCursor(PlanView.CursorType.ROTATION);
            } else if (PlanController.this.getElevatedPieceOfFurnitureAt(f, f2) != null) {
                PlanController.this.getView().setCursor(PlanView.CursorType.ELEVATION);
            } else if (PlanController.this.getPieceOfFurnitureNameAt(f, f2) != null) {
                PlanController.this.getView().setCursor(PlanView.CursorType.RESIZE);
            } else if (PlanController.this.getPieceOfFurnitureRotatedNameAt(f, f2) != null) {
                PlanController.this.getView().setCursor(PlanView.CursorType.ROTATION);
            } else if (PlanController.this.getRotatedCompassAt(f, f2) != null) {
                PlanController.this.getView().setCursor(PlanView.CursorType.ROTATION);
            } else if (PlanController.this.getResizedCompassAt(f, f2) != null) {
                PlanController.this.getView().setCursor(PlanView.CursorType.RESIZE);
            } else if (PlanController.this.isItemSelectedAt(f, f2)) {
                PlanController.this.getView().setCursor(PlanView.CursorType.MOVE);
            } else {
                PlanController.this.getView().setCursor(PlanView.CursorType.SELECTION);
            }
        }

        public void pressMouse(float f, float f2, int n, boolean bl, boolean bl2) {
            if (n == 1) {
                if (PlanController.this.getPointerTypeLastMousePress() == View.PointerType.TOUCH) {
                    this.moveMouse(f, f2);
                }
                if (PlanController.this.getRotatedLabelAt(f, f2) != null) {
                    PlanController.this.setState(PlanController.this.getLabelRotationState());
                } else if (PlanController.this.getYawRotatedCameraAt(f, f2) != null) {
                    PlanController.this.setState(PlanController.this.getCameraYawRotationState());
                } else if (PlanController.this.getPitchRotatedCameraAt(f, f2) != null) {
                    PlanController.this.setState(PlanController.this.getCameraPitchRotationState());
                } else if (PlanController.this.getElevatedLabelAt(f, f2) != null) {
                    PlanController.this.setState(PlanController.this.getLabelElevationState());
                } else if (PlanController.this.getElevatedCameraAt(f, f2) != null) {
                    PlanController.this.setState(PlanController.this.getCameraElevationState());
                } else if (PlanController.this.getRoomNameAt(f, f2) != null) {
                    PlanController.this.setState(PlanController.this.getRoomNameOffsetState());
                } else if (PlanController.this.getRoomRotatedNameAt(f, f2) != null) {
                    PlanController.this.setState(PlanController.this.getRoomNameRotationState());
                } else if (PlanController.this.getRoomAreaAt(f, f2) != null) {
                    PlanController.this.setState(PlanController.this.getRoomAreaOffsetState());
                } else if (PlanController.this.getRoomRotatedAreaAt(f, f2) != null) {
                    PlanController.this.setState(PlanController.this.getRoomAreaRotationState());
                } else if (PlanController.this.getResizedDimensionLineStartAt(f, f2) != null || PlanController.this.getResizedDimensionLineEndAt(f, f2) != null) {
                    PlanController.this.setState(PlanController.this.getDimensionLineResizeState());
                } else if (PlanController.this.getWidthAndDepthResizedPieceOfFurnitureAt(f, f2) != null) {
                    PlanController.this.setState(PlanController.this.getPieceOfFurnitureResizeState());
                } else if (PlanController.this.getResizedWallStartAt(f, f2) != null || PlanController.this.getResizedWallEndAt(f, f2) != null) {
                    PlanController.this.setState(PlanController.this.getWallResizeState());
                } else if (PlanController.this.getResizedRoomAt(f, f2) != null) {
                    PlanController.this.setState(PlanController.this.getRoomResizeState());
                } else if (PlanController.this.getOffsetDimensionLineAt(f, f2) != null) {
                    PlanController.this.setState(PlanController.this.getDimensionLineOffsetState());
                } else if (PlanController.this.getResizedPolylineAt(f, f2) != null) {
                    PlanController.this.setState(PlanController.this.getPolylineResizeState());
                } else if (PlanController.this.getPitchRotatedPieceOfFurnitureAt(f, f2) != null) {
                    PlanController.this.setState(PlanController.this.getPieceOfFurniturePitchRotationState());
                } else if (PlanController.this.getRollRotatedPieceOfFurnitureAt(f, f2) != null) {
                    PlanController.this.setState(PlanController.this.getPieceOfFurnitureRollRotationState());
                } else if (PlanController.this.getModifiedLightPowerAt(f, f2) != null) {
                    PlanController.this.setState(PlanController.this.getLightPowerModificationState());
                } else if (PlanController.this.getHeightResizedPieceOfFurnitureAt(f, f2) != null) {
                    PlanController.this.setState(PlanController.this.getPieceOfFurnitureHeightState());
                } else if (PlanController.this.getArcExtentWallAt(f, f2) != null) {
                    PlanController.this.setState(PlanController.this.getWallArcExtentState());
                } else if (PlanController.this.getRotatedPieceOfFurnitureAt(f, f2) != null) {
                    PlanController.this.setState(PlanController.this.getPieceOfFurnitureRotationState());
                } else if (PlanController.this.getElevatedPieceOfFurnitureAt(f, f2) != null) {
                    PlanController.this.setState(PlanController.this.getPieceOfFurnitureElevationState());
                } else if (PlanController.this.getPieceOfFurnitureNameAt(f, f2) != null) {
                    PlanController.this.setState(PlanController.this.getPieceOfFurnitureNameOffsetState());
                } else if (PlanController.this.getPieceOfFurnitureRotatedNameAt(f, f2) != null) {
                    PlanController.this.setState(PlanController.this.getPieceOfFurnitureNameRotationState());
                } else if (PlanController.this.getRotatedCompassAt(f, f2) != null) {
                    PlanController.this.setState(PlanController.this.getCompassRotationState());
                } else if (PlanController.this.getResizedCompassAt(f, f2) != null) {
                    PlanController.this.setState(PlanController.this.getCompassResizeState());
                } else if (!(bl || PlanController.this.getPointerTypeLastMousePress() != View.PointerType.TOUCH && PlanController.this.getSelectableItemAt(f, f2) == null)) {
                    PlanController.this.setState(PlanController.this.getSelectionMoveState());
                } else {
                    PlanController.this.setState(PlanController.this.getRectangleSelectionState());
                }
            } else if (n == 2) {
                Selectable selectable = PlanController.this.getSelectableItemAt(f, f2);
                if (!bl && selectable != null) {
                    PlanController.this.modifySelectedItem();
                }
            }
        }

        public void exit() {
            if (PlanController.this.getView() != null) {
                PlanController.this.home.removeSelectionListener(this.selectionListener);
                PlanController.this.getView().setResizeIndicatorVisible(false);
            }
        }
    }

    private abstract class AbstractModeChangeState
    extends ControllerState {
        private AbstractModeChangeState() {
        }

        public void setMode(Mode mode) {
            if (mode == Mode.SELECTION) {
                PlanController.this.setState(PlanController.this.getSelectionState());
            } else if (mode == Mode.PANNING) {
                PlanController.this.setState(PlanController.this.getPanningState());
            } else if (mode == Mode.WALL_CREATION) {
                PlanController.this.setState(PlanController.this.getWallCreationState());
            } else if (mode == Mode.ROOM_CREATION) {
                PlanController.this.setState(PlanController.this.getRoomCreationState());
            } else if (mode == Mode.POLYLINE_CREATION) {
                PlanController.this.setState(PlanController.this.getPolylineCreationState());
            } else if (mode == Mode.DIMENSION_LINE_CREATION) {
                PlanController.this.setState(PlanController.this.getDimensionLineCreationState());
            } else if (mode == Mode.LABEL_CREATION) {
                PlanController.this.setState(PlanController.this.getLabelCreationState());
            }
        }

        public void deleteSelection() {
            PlanController.this.deleteItems(PlanController.this.home.getSelectedItems());
            this.moveMouse(PlanController.this.getXLastMouseMove(), PlanController.this.getYLastMouseMove());
        }

        public void moveSelection(float f, float f2) {
            PlanController.this.moveAndShowSelectedItems(f, f2);
            this.moveMouse(PlanController.this.getXLastMouseMove(), PlanController.this.getYLastMouseMove());
        }

        public void zoom(float f) {
            PlanController.this.setScale(PlanController.this.getScale() * f);
        }
    }

    protected static abstract class ControllerStateDecorator
    extends ControllerState {
        private final ControllerState state;

        public ControllerStateDecorator(ControllerState controllerState) {
            this.state = controllerState;
        }

        public void enter() {
            this.state.enter();
        }

        public void exit() {
            this.state.exit();
        }

        public Mode getMode() {
            return this.state.getMode();
        }

        public void setMode(Mode mode) {
            this.state.setMode(mode);
        }

        public boolean isModificationState() {
            return this.state.isModificationState();
        }

        public boolean isBasePlanModificationState() {
            return this.state.isBasePlanModificationState();
        }

        public void deleteSelection() {
            this.state.deleteSelection();
        }

        public void escape() {
            this.state.escape();
        }

        public void moveSelection(float f, float f2) {
            this.state.moveSelection(f, f2);
        }

        public void toggleMagnetism(boolean bl) {
            this.state.toggleMagnetism(bl);
        }

        public void setAlignmentActivated(boolean bl) {
            this.state.setAlignmentActivated(bl);
        }

        public void setDuplicationActivated(boolean bl) {
            this.state.setDuplicationActivated(bl);
        }

        public void setEditionActivated(boolean bl) {
            this.state.setEditionActivated(bl);
        }

        public void updateEditableProperty(EditableProperty editableProperty, Object object) {
            this.state.updateEditableProperty(editableProperty, object);
        }

        public void pressMouse(float f, float f2, int n, boolean bl, boolean bl2) {
            this.state.pressMouse(f, f2, n, bl, bl2);
        }

        public void releaseMouse(float f, float f2) {
            this.state.releaseMouse(f, f2);
        }

        public void moveMouse(float f, float f2) {
            this.state.moveMouse(f, f2);
        }

        public void zoom(float f) {
            this.state.zoom(f);
        }
    }

    protected static abstract class ControllerState {
        protected ControllerState() {
        }

        public void enter() {
        }

        public void exit() {
        }

        public abstract Mode getMode();

        public void setMode(Mode mode) {
        }

        public boolean isModificationState() {
            return false;
        }

        public boolean isBasePlanModificationState() {
            return false;
        }

        public void deleteSelection() {
        }

        public void escape() {
        }

        public void moveSelection(float f, float f2) {
        }

        public void toggleMagnetism(boolean bl) {
        }

        public void setAlignmentActivated(boolean bl) {
        }

        public void setDuplicationActivated(boolean bl) {
        }

        public void setEditionActivated(boolean bl) {
        }

        public void updateEditableProperty(EditableProperty editableProperty, Object object) {
        }

        public void pressMouse(float f, float f2, int n, boolean bl, boolean bl2) {
        }

        public void releaseMouse(float f, float f2) {
        }

        public void moveMouse(float f, float f2) {
        }

        public void zoom(float f) {
        }
    }

    private class PointMagnetizedToClosestWallOrRoomPoint {
        private float x;
        private float y;
        private boolean magnetized;

        public PointMagnetizedToClosestWallOrRoomPoint(float f, float f2) {
            this(null, -1, f, f2);
        }

        public PointMagnetizedToClosestWallOrRoomPoint(Room room, int n, float f, float f2) {
            float f3 = PlanController.this.getSelectionMargin();
            double d = Double.MAX_VALUE;
            for (Cloneable cloneable : PlanController.this.getRoomPathsFromWalls()) {
                d = this.updateMagnetizedPoint(-1, f, f2, d, PlanController.this.getPathPoints((GeneralPath)cloneable, false));
            }
            for (Cloneable cloneable : PlanController.this.getDetectableRoomsAtSelectedLevel()) {
                d = this.updateMagnetizedPoint(cloneable == room ? n : -1, f, f2, d, ((Room)cloneable).getPoints());
            }
            boolean bl = this.magnetized = d <= (double)(f3 * f3);
            if (!this.magnetized) {
                this.x = f;
                this.y = f2;
            }
        }

        private double updateMagnetizedPoint(int n, float f, float f2, double d, float[][] fArray) {
            for (int i = 0; i < fArray.length; ++i) {
                double d2;
                if (i == n || !((d2 = Point2D.distanceSq(fArray[i][0], fArray[i][1], f, f2)) < d)) continue;
                this.x = fArray[i][0];
                this.y = fArray[i][1];
                d = d2;
            }
            return d;
        }

        public float getX() {
            return this.x;
        }

        public float getY() {
            return this.y;
        }

        public boolean isMagnetized() {
            return this.magnetized;
        }
    }

    private class RoomPointWithAngleMagnetism
    extends PointWithAngleMagnetism {
        public RoomPointWithAngleMagnetism(Room room, int n, float f, float f2, float f3, float f4) {
            int n2;
            Object object;
            super(f, f2, f3, f4, PlanController.this.preferences.getLengthUnit(), PlanController.this.getView().getPixelLength());
            float f5 = PlanController.this.getScale();
            float f6 = 4.0f / f5;
            float f7 = Float.POSITIVE_INFINITY;
            float f8 = Float.POSITIVE_INFINITY;
            float f9 = 0.0f;
            float f10 = 0.0f;
            for (HomeObject homeObject : PlanController.this.getDetectableRoomsAtSelectedLevel()) {
                object = ((Room)homeObject).getPoints();
                for (n2 = 0; n2 < ((float[][])object).length; ++n2) {
                    if (n != -1 && (n2 == n || ((float[][])object).length <= 2)) continue;
                    if (Math.abs(this.getX() - object[n2][0]) < f6 && Math.abs(f8) > Math.abs(this.getY() - object[n2][1])) {
                        f9 = object[n2][0];
                        f8 = this.getY() - object[n2][1];
                    }
                    if (!(Math.abs(this.getY() - object[n2][1]) < f6) || !(Math.abs(f7) > Math.abs(this.getX() - object[n2][0]))) continue;
                    f10 = object[n2][1];
                    f7 = this.getX() - object[n2][0];
                }
            }
            for (HomeObject homeObject : PlanController.this.getDetectableWallsAtSelectedLevel()) {
                object = ((Wall)homeObject).getPoints();
                object = new float[][]{object[0], object[((float[][])object).length / 2 - 1], object[((float[][])object).length / 2], object[((float[][])object).length - 1]};
                for (n2 = 0; n2 < ((float[][])object).length; ++n2) {
                    if (Math.abs(this.getX() - object[n2][0]) < f6 && Math.abs(f8) > Math.abs(this.getY() - object[n2][1])) {
                        f9 = object[n2][0];
                        f8 = this.getY() - object[n2][1];
                    }
                    if (!(Math.abs(this.getY() - object[n2][1]) < f6) || !(Math.abs(f7) > Math.abs(this.getX() - object[n2][0]))) continue;
                    f10 = object[n2][1];
                    f7 = this.getX() - object[n2][0];
                }
            }
            if (room != null) {
                float f11;
                double d;
                double d2 = -Math.tan(this.getAngle());
                double d3 = d = Math.abs(d2) < 1.0E10 ? (double)f2 - d2 * (double)f : Double.POSITIVE_INFINITY;
                if (f7 != Float.POSITIVE_INFINITY && Math.abs(d2) > 1.0E-10) {
                    f11 = (float)(((double)f10 - d) / d2);
                    if (Point2D.distanceSq(this.getX(), this.getY(), f11, f10) <= (double)(f6 * f6)) {
                        this.setX(f11);
                        this.setY(f10);
                        return;
                    }
                }
                if (f8 != Float.POSITIVE_INFINITY && d != Double.POSITIVE_INFINITY) {
                    f11 = (float)(d2 * (double)f9 + d);
                    if (Point2D.distanceSq(this.getX(), this.getY(), f9, f11) <= (double)(f6 * f6)) {
                        this.setX(f9);
                        this.setY(f11);
                    }
                }
            } else {
                if (f7 != Float.POSITIVE_INFINITY) {
                    this.setY(f10);
                }
                if (f8 != Float.POSITIVE_INFINITY) {
                    this.setX(f9);
                }
            }
        }
    }

    private class WallPointWithAngleMagnetism
    extends PointWithAngleMagnetism {
        public WallPointWithAngleMagnetism(Wall wall, float f, float f2, float f3, float f4) {
            super(f, f2, f3, f4, PlanController.this.preferences.getLengthUnit(), PlanController.this.getView().getPixelLength());
            float f5 = 4.0f / PlanController.this.getScale();
            float f6 = Float.POSITIVE_INFINITY;
            float f7 = Float.POSITIVE_INFINITY;
            float f8 = 0.0f;
            float f9 = 0.0f;
            for (Wall wall2 : PlanController.this.getDetectableWallsAtSelectedLevel()) {
                if (wall2 == wall) continue;
                if (Math.abs(this.getX() - wall2.getXStart()) < f5 && (wall == null || !this.equalsWallPoint(wall2.getXStart(), wall2.getYStart(), wall))) {
                    if (Math.abs(f7) > Math.abs(this.getY() - wall2.getYStart())) {
                        f8 = wall2.getXStart();
                        f7 = this.getY() - f9;
                    }
                } else if (Math.abs(this.getX() - wall2.getXEnd()) < f5 && (wall == null || !this.equalsWallPoint(wall2.getXEnd(), wall2.getYEnd(), wall)) && Math.abs(f7) > Math.abs(this.getY() - wall2.getYEnd())) {
                    f8 = wall2.getXEnd();
                    f7 = this.getY() - f9;
                }
                if (Math.abs(this.getY() - wall2.getYStart()) < f5 && (wall == null || !this.equalsWallPoint(wall2.getXStart(), wall2.getYStart(), wall))) {
                    if (!(Math.abs(f6) > Math.abs(this.getX() - wall2.getXStart()))) continue;
                    f9 = wall2.getYStart();
                    f6 = this.getX() - f8;
                    continue;
                }
                if (!(Math.abs(this.getY() - wall2.getYEnd()) < f5) || wall != null && this.equalsWallPoint(wall2.getXEnd(), wall2.getYEnd(), wall) || !(Math.abs(f6) > Math.abs(this.getX() - wall2.getXEnd()))) continue;
                f9 = wall2.getYEnd();
                f6 = this.getX() - f8;
            }
            if (wall != null) {
                float f10;
                double d;
                double d2 = -Math.tan(this.getAngle());
                double d3 = d = Math.abs(d2) < 1.0E10 ? (double)f2 - d2 * (double)f : Double.POSITIVE_INFINITY;
                if (f6 != Float.POSITIVE_INFINITY && Math.abs(d2) > 1.0E-10) {
                    f10 = (float)(((double)f9 - d) / d2);
                    if (Point2D.distanceSq(this.getX(), this.getY(), f10, f9) <= (double)(f5 * f5)) {
                        this.setX(f10);
                        this.setY(f9);
                        return;
                    }
                }
                if (f7 != Float.POSITIVE_INFINITY && d != Double.POSITIVE_INFINITY) {
                    f10 = (float)(d2 * (double)f8 + d);
                    if (Point2D.distanceSq(this.getX(), this.getY(), f8, f10) <= (double)(f5 * f5)) {
                        this.setX(f8);
                        this.setY(f10);
                    }
                }
            } else {
                if (f6 != Float.POSITIVE_INFINITY) {
                    this.setY(f9);
                }
                if (f7 != Float.POSITIVE_INFINITY) {
                    this.setX(f8);
                }
            }
        }

        private boolean equalsWallPoint(float f, float f2, Wall wall) {
            return f == wall.getXStart() && f2 == wall.getYStart() || f == wall.getXEnd() && f2 == wall.getYEnd();
        }
    }

    private static class PointWithAngleMagnetism {
        private static final int CIRCLE_STEPS_15_DEG = 24;
        private float x;
        private float y;
        private float angle;

        public PointWithAngleMagnetism(float f, float f2, float f3, float f4, LengthUnit lengthUnit, float f5) {
            this(f, f2, f3, f4, lengthUnit, f5, 24);
        }

        public PointWithAngleMagnetism(float f, float f2, float f3, float f4, LengthUnit lengthUnit, float f5, int n) {
            this.x = f3;
            this.y = f4;
            if (f == f3) {
                float f6 = lengthUnit.getMagnetizedLength(Math.abs(f2 - f4), f5);
                this.y = f2 + f6 * Math.signum(f4 - f2);
            } else if (f2 == f4) {
                float f7 = lengthUnit.getMagnetizedLength(Math.abs(f - f3), f5);
                this.x = f + f7 * Math.signum(f3 - f);
            } else {
                double d;
                double d2;
                double d3;
                double d4;
                double d5;
                double d6 = Math.PI * 2 / (double)n;
                double d7 = Math.atan2(f2 - f4, f3 - f);
                double d8 = Math.floor(d7 / d6) * d6;
                if (Math.tan(d7) > 0.0) {
                    d5 = d8;
                    d4 = Math.tan(d8);
                    d3 = d8 + d6;
                    d2 = Math.tan(d8 + d6);
                } else {
                    d5 = d8 + d6;
                    d4 = Math.tan(d8 + d6);
                    d3 = d8;
                    d2 = Math.tan(d8);
                }
                double d9 = Math.abs(d4);
                double d10 = Math.abs(d2);
                float f8 = Math.abs(f - f3);
                float f9 = Math.abs(f2 - f4);
                float f10 = 0.0f;
                if (d10 > 1.0E-10) {
                    f10 = (float)((double)f9 / d10);
                }
                float f11 = 0.0f;
                if (d9 < 1.0E10) {
                    f11 = (float)((double)f8 * d9);
                }
                if (Math.abs(f10 - f8) < Math.abs(f11 - f9)) {
                    d = d3;
                    this.x = f + (float)((double)(f2 - f4) / d2);
                } else {
                    d = d5;
                    this.y = f2 - (float)((double)(f3 - f) * d4);
                }
                float f12 = lengthUnit.getMagnetizedLength((float)Point2D.distance(f, f2, this.x, this.y), f5);
                this.x = f + (float)((double)f12 * Math.cos(d));
                this.y = f2 - (float)((double)f12 * Math.sin(d));
                this.angle = (float)d;
            }
        }

        public float getX() {
            return this.x;
        }

        protected void setX(float f) {
            this.x = f;
        }

        public float getY() {
            return this.y;
        }

        protected void setY(float f) {
            this.y = f;
        }

        protected float getAngle() {
            return this.angle;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class JoinedWall {
        private final Wall wall;
        private final Level level;
        private final float xStart;
        private final float yStart;
        private final float xEnd;
        private final float yEnd;
        private final Wall wallAtStart;
        private final Wall wallAtEnd;
        private final boolean joinedAtEndOfWallAtStart;
        private final boolean joinedAtStartOfWallAtEnd;

        public JoinedWall(Wall wall) {
            this.wall = wall;
            this.level = wall.getLevel();
            this.xStart = wall.getXStart();
            this.xEnd = wall.getXEnd();
            this.yStart = wall.getYStart();
            this.yEnd = wall.getYEnd();
            this.wallAtStart = wall.getWallAtStart();
            this.joinedAtEndOfWallAtStart = this.wallAtStart != null && this.wallAtStart.getWallAtEnd() == wall;
            this.wallAtEnd = wall.getWallAtEnd();
            this.joinedAtStartOfWallAtEnd = this.wallAtEnd != null && this.wallAtEnd.getWallAtStart() == wall;
        }

        public Wall getWall() {
            return this.wall;
        }

        public Level getLevel() {
            return this.level;
        }

        public float getXStart() {
            return this.xStart;
        }

        public float getYStart() {
            return this.yStart;
        }

        public float getXEnd() {
            return this.xEnd;
        }

        public float getYEnd() {
            return this.yEnd;
        }

        public Wall getWallAtEnd() {
            return this.wallAtEnd;
        }

        public Wall getWallAtStart() {
            return this.wallAtStart;
        }

        public boolean isJoinedAtEndOfWallAtStart() {
            return this.joinedAtEndOfWallAtStart;
        }

        public boolean isJoinedAtStartOfWallAtEnd() {
            return this.joinedAtStartOfWallAtEnd;
        }

        public static JoinedWall[] getJoinedWalls(List<Wall> list) {
            JoinedWall[] joinedWallArray = new JoinedWall[list.size()];
            for (int i = 0; i < joinedWallArray.length; ++i) {
                joinedWallArray[i] = new JoinedWall(list.get(i));
            }
            return joinedWallArray;
        }

        public static List<Wall> getWalls(JoinedWall[] joinedWallArray) {
            Wall[] wallArray = new Wall[joinedWallArray.length];
            for (int i = 0; i < joinedWallArray.length; ++i) {
                wallArray[i] = joinedWallArray[i].getWall();
            }
            return Arrays.asList(wallArray);
        }
    }

    private static class ResizedPieceOfFurniture {
        private final HomePieceOfFurniture piece;
        private final float x;
        private final float y;
        private final float width;
        private final float depth;
        private final float height;
        private final boolean doorOrWindowBoundToWall;
        private final float[] groupFurnitureX;
        private final float[] groupFurnitureY;
        private final float[] groupFurnitureWidth;
        private final float[] groupFurnitureDepth;
        private final float[] groupFurnitureHeight;

        public ResizedPieceOfFurniture(HomePieceOfFurniture homePieceOfFurniture) {
            this.piece = homePieceOfFurniture;
            this.x = homePieceOfFurniture.getX();
            this.y = homePieceOfFurniture.getY();
            this.width = homePieceOfFurniture.getWidth();
            this.depth = homePieceOfFurniture.getDepth();
            this.height = homePieceOfFurniture.getHeight();
            boolean bl = this.doorOrWindowBoundToWall = homePieceOfFurniture instanceof HomeDoorOrWindow && ((HomeDoorOrWindow)homePieceOfFurniture).isBoundToWall();
            if (homePieceOfFurniture instanceof HomeFurnitureGroup) {
                List<HomePieceOfFurniture> list = ((HomeFurnitureGroup)homePieceOfFurniture).getAllFurniture();
                this.groupFurnitureX = new float[list.size()];
                this.groupFurnitureY = new float[list.size()];
                this.groupFurnitureWidth = new float[list.size()];
                this.groupFurnitureDepth = new float[list.size()];
                this.groupFurnitureHeight = new float[list.size()];
                for (int i = 0; i < list.size(); ++i) {
                    HomePieceOfFurniture homePieceOfFurniture2 = list.get(i);
                    this.groupFurnitureX[i] = homePieceOfFurniture2.getX();
                    this.groupFurnitureY[i] = homePieceOfFurniture2.getY();
                    this.groupFurnitureWidth[i] = homePieceOfFurniture2.getWidth();
                    this.groupFurnitureDepth[i] = homePieceOfFurniture2.getDepth();
                    this.groupFurnitureHeight[i] = homePieceOfFurniture2.getHeight();
                }
            } else {
                this.groupFurnitureX = null;
                this.groupFurnitureY = null;
                this.groupFurnitureWidth = null;
                this.groupFurnitureDepth = null;
                this.groupFurnitureHeight = null;
            }
        }

        public HomePieceOfFurniture getPieceOfFurniture() {
            return this.piece;
        }

        public float getWidth() {
            return this.width;
        }

        public float getDepth() {
            return this.depth;
        }

        public float getHeight() {
            return this.height;
        }

        public boolean isDoorOrWindowBoundToWall() {
            return this.doorOrWindowBoundToWall;
        }

        public void reset() {
            this.piece.setX(this.x);
            this.piece.setY(this.y);
            ResizedPieceOfFurniture.setPieceOfFurnitureSize(this.piece, this.width, this.depth, this.height);
            if (this.piece instanceof HomeDoorOrWindow) {
                ((HomeDoorOrWindow)this.piece).setBoundToWall(this.doorOrWindowBoundToWall);
            }
            if (this.piece instanceof HomeFurnitureGroup) {
                List<HomePieceOfFurniture> list = ((HomeFurnitureGroup)this.piece).getAllFurniture();
                for (int i = 0; i < list.size(); ++i) {
                    HomePieceOfFurniture homePieceOfFurniture = list.get(i);
                    if (!this.piece.isResizable()) continue;
                    homePieceOfFurniture.setX(this.groupFurnitureX[i]);
                    homePieceOfFurniture.setY(this.groupFurnitureY[i]);
                    ResizedPieceOfFurniture.setPieceOfFurnitureSize(homePieceOfFurniture, this.groupFurnitureWidth[i], this.groupFurnitureDepth[i], this.groupFurnitureHeight[i]);
                }
            }
        }

        public static void setPieceOfFurnitureSize(HomePieceOfFurniture homePieceOfFurniture, float f, float f2, float f3) {
            block4: {
                block3: {
                    if (!homePieceOfFurniture.isHorizontallyRotated()) break block3;
                    float f4 = f / homePieceOfFurniture.getWidth();
                    homePieceOfFurniture.scale(f4);
                    homePieceOfFurniture.setWidthInPlan(f4 * homePieceOfFurniture.getWidthInPlan());
                    homePieceOfFurniture.setDepthInPlan(f4 * homePieceOfFurniture.getDepthInPlan());
                    homePieceOfFurniture.setHeightInPlan(f4 * homePieceOfFurniture.getHeightInPlan());
                    if (!(homePieceOfFurniture instanceof HomeFurnitureGroup)) break block4;
                    for (HomePieceOfFurniture homePieceOfFurniture2 : ((HomeFurnitureGroup)homePieceOfFurniture).getAllFurniture()) {
                        homePieceOfFurniture2.setWidthInPlan(f4 * homePieceOfFurniture2.getWidthInPlan());
                        homePieceOfFurniture2.setDepthInPlan(f4 * homePieceOfFurniture2.getDepthInPlan());
                        homePieceOfFurniture2.setHeightInPlan(f4 * homePieceOfFurniture2.getHeightInPlan());
                    }
                    break block4;
                }
                float f5 = homePieceOfFurniture.getWidthInPlan() * f / homePieceOfFurniture.getWidth();
                homePieceOfFurniture.setWidth(f);
                homePieceOfFurniture.setWidthInPlan(f5);
                float f6 = homePieceOfFurniture.getDepthInPlan() * f2 / homePieceOfFurniture.getDepth();
                homePieceOfFurniture.setDepth(f2);
                homePieceOfFurniture.setDepthInPlan(f6);
                float f7 = homePieceOfFurniture.getHeightInPlan() * f3 / homePieceOfFurniture.getHeight();
                homePieceOfFurniture.setHeight(f3);
                homePieceOfFurniture.setHeightInPlan(f7);
                if (homePieceOfFurniture instanceof HomeFurnitureGroup) {
                    for (HomePieceOfFurniture homePieceOfFurniture3 : ((HomeFurnitureGroup)homePieceOfFurniture).getAllFurniture()) {
                        homePieceOfFurniture3.setWidthInPlan(homePieceOfFurniture3.getWidth());
                        homePieceOfFurniture3.setDepthInPlan(homePieceOfFurniture3.getDepth());
                        homePieceOfFurniture3.setHeightInPlan(homePieceOfFurniture3.getHeight());
                    }
                }
            }
        }
    }

    private static class CompassResizingUndoableEdit
    extends LocalizedUndoableEdit {
        private final PlanController controller;
        private final float oldDiameter;
        private final Compass compass;
        private final float newDiameter;

        public CompassResizingUndoableEdit(PlanController planController, UserPreferences userPreferences, float f, Compass compass, float f2) {
            super(userPreferences, PlanController.class, "undoCompassResizeName");
            this.controller = planController;
            this.oldDiameter = f;
            this.compass = compass;
            this.newDiameter = f2;
        }

        public void undo() throws CannotUndoException {
            super.undo();
            this.compass.setDiameter(this.oldDiameter);
            this.controller.selectAndShowItems(Arrays.asList(this.compass));
        }

        public void redo() throws CannotRedoException {
            super.redo();
            this.compass.setDiameter(this.newDiameter);
            this.controller.selectAndShowItems(Arrays.asList(this.compass));
        }
    }

    private static class CompassRotationUndoableEdit
    extends LocalizedUndoableEdit {
        private final PlanController controller;
        private final float oldNorthDirection;
        private final Compass compass;
        private final float newNorthDirection;

        public CompassRotationUndoableEdit(PlanController planController, UserPreferences userPreferences, float f, Compass compass, float f2) {
            super(userPreferences, PlanController.class, "undoCompassRotationName");
            this.controller = planController;
            this.compass = compass;
            this.newNorthDirection = f2;
            this.oldNorthDirection = f;
        }

        public void undo() throws CannotUndoException {
            super.undo();
            this.compass.setNorthDirection(this.oldNorthDirection);
            this.controller.selectAndShowItems(Arrays.asList(this.compass));
        }

        public void redo() throws CannotRedoException {
            super.redo();
            this.compass.setNorthDirection(this.newNorthDirection);
            this.controller.selectAndShowItems(Arrays.asList(this.compass));
        }
    }

    private static class PolylineResizingUndoableEdit
    extends LocalizedUndoableEdit {
        private final PlanController controller;
        private final float oldX;
        private final float oldY;
        private final Polyline polyline;
        private final int pointIndex;
        private final float newX;
        private final float newY;

        public PolylineResizingUndoableEdit(PlanController planController, UserPreferences userPreferences, float f, float f2, Polyline polyline, int n, float f3, float f4) {
            super(userPreferences, PlanController.class, "undoPolylineResizeName");
            this.controller = planController;
            this.oldX = f;
            this.oldY = f2;
            this.polyline = polyline;
            this.pointIndex = n;
            this.newX = f3;
            this.newY = f4;
        }

        public void undo() throws CannotUndoException {
            super.undo();
            this.polyline.setPoint(this.oldX, this.oldY, this.pointIndex);
            this.controller.selectAndShowItems(Arrays.asList(this.polyline));
        }

        public void redo() throws CannotRedoException {
            super.redo();
            this.polyline.setPoint(this.newX, this.newY, this.pointIndex);
            this.controller.selectAndShowItems(Arrays.asList(this.polyline));
        }
    }

    private static class DimensionLineOffsetModificationUndoableEdit
    extends LocalizedUndoableEdit {
        private final PlanController controller;
        private final float oldOffset;
        private final DimensionLine dimensionLine;
        private final float newOffset;

        public DimensionLineOffsetModificationUndoableEdit(PlanController planController, UserPreferences userPreferences, float f, DimensionLine dimensionLine, float f2) {
            super(userPreferences, PlanController.class, "undoDimensionLineOffsetName");
            this.controller = planController;
            this.oldOffset = f;
            this.dimensionLine = dimensionLine;
            this.newOffset = f2;
        }

        public void undo() throws CannotUndoException {
            super.undo();
            this.dimensionLine.setOffset(this.oldOffset);
            this.controller.selectAndShowItems(Arrays.asList(this.dimensionLine));
        }

        public void redo() throws CannotRedoException {
            super.redo();
            this.dimensionLine.setOffset(this.newOffset);
            this.controller.selectAndShowItems(Arrays.asList(this.dimensionLine));
        }
    }

    private static class DimensionLineResizingUndoableEdit
    extends LocalizedUndoableEdit {
        private final PlanController controller;
        private final float oldX;
        private final float oldY;
        private final DimensionLine dimensionLine;
        private final float newX;
        private final float newY;
        private final boolean startPoint;
        private final boolean reversed;

        public DimensionLineResizingUndoableEdit(PlanController planController, UserPreferences userPreferences, float f, float f2, DimensionLine dimensionLine, float f3, float f4, boolean bl, boolean bl2) {
            super(userPreferences, PlanController.class, "undoDimensionLineResizeName");
            this.controller = planController;
            this.oldX = f;
            this.oldY = f2;
            this.dimensionLine = dimensionLine;
            this.newX = f3;
            this.newY = f4;
            this.startPoint = bl;
            this.reversed = bl2;
        }

        public void undo() throws CannotUndoException {
            super.undo();
            if (this.reversed) {
                PlanController.reverseDimensionLine(this.dimensionLine);
                PlanController.moveDimensionLinePoint(this.dimensionLine, this.oldX, this.oldY, !this.startPoint);
            } else {
                PlanController.moveDimensionLinePoint(this.dimensionLine, this.oldX, this.oldY, this.startPoint);
            }
            this.controller.selectAndShowItems(Arrays.asList(this.dimensionLine));
        }

        public void redo() throws CannotRedoException {
            super.redo();
            if (this.reversed) {
                PlanController.moveDimensionLinePoint(this.dimensionLine, this.newX, this.newY, !this.startPoint);
                PlanController.reverseDimensionLine(this.dimensionLine);
            } else {
                PlanController.moveDimensionLinePoint(this.dimensionLine, this.newX, this.newY, this.startPoint);
            }
            this.controller.selectAndShowItems(Arrays.asList(this.dimensionLine));
        }
    }

    private static class PieceOfFurnitureNameRotationUndoableEdit
    extends LocalizedUndoableEdit {
        private final PlanController controller;
        private final float oldNameAngle;
        private final HomePieceOfFurniture piece;
        private final float newNameAngle;

        public PieceOfFurnitureNameRotationUndoableEdit(PlanController planController, UserPreferences userPreferences, float f, HomePieceOfFurniture homePieceOfFurniture, float f2) {
            super(userPreferences, PlanController.class, "undoPieceOfFurnitureNameRotationName");
            this.controller = planController;
            this.oldNameAngle = f;
            this.piece = homePieceOfFurniture;
            this.newNameAngle = f2;
        }

        public void undo() throws CannotUndoException {
            super.undo();
            this.piece.setNameAngle(this.oldNameAngle);
            this.controller.selectAndShowItems(Arrays.asList(this.piece));
        }

        public void redo() throws CannotRedoException {
            super.redo();
            this.piece.setNameAngle(this.newNameAngle);
            this.controller.selectAndShowItems(Arrays.asList(this.piece));
        }
    }

    private static class PieceOfFurnitureNameOffsetModificationUndoableEdit
    extends LocalizedUndoableEdit {
        private final PlanController controller;
        private final float oldNameXOffset;
        private final float oldNameYOffset;
        private final HomePieceOfFurniture piece;
        private final float newNameXOffset;
        private final float newNameYOffset;

        public PieceOfFurnitureNameOffsetModificationUndoableEdit(PlanController planController, UserPreferences userPreferences, float f, float f2, HomePieceOfFurniture homePieceOfFurniture, float f3, float f4) {
            super(userPreferences, PlanController.class, "undoPieceOfFurnitureNameOffsetName");
            this.controller = planController;
            this.oldNameXOffset = f;
            this.oldNameYOffset = f2;
            this.piece = homePieceOfFurniture;
            this.newNameXOffset = f3;
            this.newNameYOffset = f4;
        }

        public void undo() throws CannotUndoException {
            super.undo();
            this.piece.setNameXOffset(this.oldNameXOffset);
            this.piece.setNameYOffset(this.oldNameYOffset);
            this.controller.selectAndShowItems(Arrays.asList(this.piece));
        }

        public void redo() throws CannotRedoException {
            super.redo();
            this.piece.setNameXOffset(this.newNameXOffset);
            this.piece.setNameYOffset(this.newNameYOffset);
            this.controller.selectAndShowItems(Arrays.asList(this.piece));
        }
    }

    private static class LightPowerModificationUndoableEdit
    extends LocalizedUndoableEdit {
        private final PlanController controller;
        private final float oldPower;
        private final HomeLight light;
        private final float newPower;

        public LightPowerModificationUndoableEdit(PlanController planController, UserPreferences userPreferences, float f, HomeLight homeLight, float f2) {
            super(userPreferences, PlanController.class, "undoLightPowerModificationName");
            this.controller = planController;
            this.oldPower = f;
            this.light = homeLight;
            this.newPower = f2;
        }

        public void undo() throws CannotUndoException {
            super.undo();
            this.light.setPower(this.oldPower);
            this.controller.selectAndShowItems(Arrays.asList(this.light));
        }

        public void redo() throws CannotRedoException {
            super.redo();
            this.light.setPower(this.newPower);
            this.controller.selectAndShowItems(Arrays.asList(this.light));
        }
    }

    private static class PieceOfFurnitureResizingUndoableEdit
    extends LocalizedUndoableEdit {
        private final PlanController controller;
        private final boolean doorOrWindowBoundToWall;
        private final ResizedPieceOfFurniture resizedPiece;
        private final float newX;
        private final float newY;
        private final float newWidth;
        private final float newDepth;
        private final float newHeight;

        public PieceOfFurnitureResizingUndoableEdit(PlanController planController, UserPreferences userPreferences, String string, boolean bl, ResizedPieceOfFurniture resizedPieceOfFurniture, float f, float f2, float f3, float f4, float f5) {
            super(userPreferences, PlanController.class, string);
            this.controller = planController;
            this.doorOrWindowBoundToWall = bl;
            this.resizedPiece = resizedPieceOfFurniture;
            this.newX = f;
            this.newY = f2;
            this.newWidth = f3;
            this.newDepth = f4;
            this.newHeight = f5;
        }

        public void undo() throws CannotUndoException {
            super.undo();
            this.controller.resetPieceOfFurnitureSize(this.resizedPiece);
            this.controller.selectAndShowItems(Arrays.asList(this.resizedPiece.getPieceOfFurniture()));
        }

        public void redo() throws CannotRedoException {
            super.redo();
            HomePieceOfFurniture homePieceOfFurniture = this.resizedPiece.getPieceOfFurniture();
            homePieceOfFurniture.setX(this.newX);
            homePieceOfFurniture.setY(this.newY);
            this.controller.setPieceOfFurnitureSize(this.resizedPiece, this.newWidth, this.newDepth, this.newHeight);
            if (homePieceOfFurniture instanceof HomeDoorOrWindow) {
                ((HomeDoorOrWindow)homePieceOfFurniture).setBoundToWall(this.doorOrWindowBoundToWall);
            }
            this.controller.selectAndShowItems(Arrays.asList(homePieceOfFurniture));
        }
    }

    private static class PieceOfFurnitureElevationModificationUndoableEdit
    extends LocalizedUndoableEdit {
        private final PlanController controller;
        private final float oldElevation;
        private final HomePieceOfFurniture piece;
        private final float newElevation;

        public PieceOfFurnitureElevationModificationUndoableEdit(PlanController planController, UserPreferences userPreferences, float f, HomePieceOfFurniture homePieceOfFurniture, float f2) {
            super(userPreferences, PlanController.class, f < f2 ? "undoPieceOfFurnitureRaiseName" : "undoPieceOfFurnitureLowerName");
            this.controller = planController;
            this.oldElevation = f;
            this.piece = homePieceOfFurniture;
            this.newElevation = f2;
        }

        public void undo() throws CannotUndoException {
            super.undo();
            this.piece.setElevation(this.oldElevation);
            this.controller.selectAndShowItems(Arrays.asList(this.piece));
        }

        public void redo() throws CannotRedoException {
            super.redo();
            this.piece.setElevation(this.newElevation);
            this.controller.selectAndShowItems(Arrays.asList(this.piece));
        }
    }

    private static class PieceOfFurnitureRollRotationUndoableEdit
    extends LocalizedUndoableEdit {
        private final PlanController controller;
        private final float oldRoll;
        private final float oldWidthInPlan;
        private final float oldDepthInPlan;
        private final float oldHeightInPlan;
        private final HomePieceOfFurniture piece;
        private final float newRoll;
        private final float newWidthInPlan;
        private final float newDepthInPlan;
        private final float newHeightInPlan;

        public PieceOfFurnitureRollRotationUndoableEdit(PlanController planController, UserPreferences userPreferences, float f, float f2, float f3, float f4, HomePieceOfFurniture homePieceOfFurniture, float f5, float f6, float f7, float f8) {
            super(userPreferences, PlanController.class, "undoPieceOfFurnitureRotationName");
            this.controller = planController;
            this.oldRoll = f;
            this.oldWidthInPlan = f2;
            this.oldDepthInPlan = f3;
            this.oldHeightInPlan = f4;
            this.piece = homePieceOfFurniture;
            this.newRoll = f5;
            this.newWidthInPlan = f6;
            this.newDepthInPlan = f7;
            this.newHeightInPlan = f8;
        }

        public void undo() throws CannotUndoException {
            super.undo();
            this.controller.setPieceOfFurnitureRoll(this.piece, this.oldRoll, this.oldWidthInPlan, this.oldDepthInPlan, this.oldHeightInPlan);
            this.controller.selectAndShowItems(Arrays.asList(this.piece));
        }

        public void redo() throws CannotRedoException {
            super.redo();
            this.controller.setPieceOfFurnitureRoll(this.piece, this.newRoll, this.newWidthInPlan, this.newDepthInPlan, this.newHeightInPlan);
            this.controller.selectAndShowItems(Arrays.asList(this.piece));
        }
    }

    private static class PieceOfFurniturePitchRotationUndoableEdit
    extends LocalizedUndoableEdit {
        private final PlanController controller;
        private final float oldPitch;
        private final float oldWidthInPlan;
        private final float oldDepthInPlan;
        private final float oldHeightInPlan;
        private final HomePieceOfFurniture piece;
        private final float newPitch;
        private final float newWidthInPlan;
        private final float newDepthInPlan;
        private final float newHeightInPlan;

        public PieceOfFurniturePitchRotationUndoableEdit(PlanController planController, UserPreferences userPreferences, float f, float f2, float f3, float f4, HomePieceOfFurniture homePieceOfFurniture, float f5, float f6, float f7, float f8) {
            super(userPreferences, PlanController.class, "undoPieceOfFurnitureRotationName");
            this.controller = planController;
            this.oldPitch = f;
            this.oldWidthInPlan = f2;
            this.oldDepthInPlan = f3;
            this.oldHeightInPlan = f4;
            this.piece = homePieceOfFurniture;
            this.newPitch = f5;
            this.newWidthInPlan = f6;
            this.newDepthInPlan = f7;
            this.newHeightInPlan = f8;
        }

        public void undo() throws CannotUndoException {
            super.undo();
            this.controller.setPieceOfFurniturePitch(this.piece, this.oldPitch, this.oldWidthInPlan, this.oldDepthInPlan, this.oldHeightInPlan);
            this.controller.selectAndShowItems(Arrays.asList(this.piece));
        }

        public void redo() throws CannotRedoException {
            super.redo();
            this.controller.setPieceOfFurniturePitch(this.piece, this.newPitch, this.newWidthInPlan, this.newDepthInPlan, this.newHeightInPlan);
            this.controller.selectAndShowItems(Arrays.asList(this.piece));
        }
    }

    private static class PieceOfFurnitureRotationUndoableEdit
    extends LocalizedUndoableEdit {
        private final PlanController controller;
        private final float oldAngle;
        private final boolean oldDoorOrWindowBoundToWall;
        private final HomePieceOfFurniture piece;
        private final float newAngle;

        public PieceOfFurnitureRotationUndoableEdit(PlanController planController, UserPreferences userPreferences, float f, boolean bl, HomePieceOfFurniture homePieceOfFurniture, float f2) {
            super(userPreferences, PlanController.class, "undoPieceOfFurnitureRotationName");
            this.controller = planController;
            this.oldAngle = f;
            this.oldDoorOrWindowBoundToWall = bl;
            this.piece = homePieceOfFurniture;
            this.newAngle = f2;
        }

        public void undo() throws CannotUndoException {
            super.undo();
            this.piece.setAngle(this.oldAngle);
            if (this.piece instanceof HomeDoorOrWindow) {
                ((HomeDoorOrWindow)this.piece).setBoundToWall(this.oldDoorOrWindowBoundToWall);
            }
            this.controller.selectAndShowItems(Arrays.asList(this.piece));
        }

        public void redo() throws CannotRedoException {
            super.redo();
            this.piece.setAngle(this.newAngle);
            this.controller.selectAndShowItems(Arrays.asList(this.piece));
        }
    }

    private static class RoomAreaRotationUndoableEdit
    extends LocalizedUndoableEdit {
        private final PlanController controller;
        private final float oldAreaAngle;
        private final Room room;
        private final float newAreaAngle;

        public RoomAreaRotationUndoableEdit(PlanController planController, UserPreferences userPreferences, float f, Room room, float f2) {
            super(userPreferences, PlanController.class, "undoRoomAreaRotationName");
            this.controller = planController;
            this.oldAreaAngle = f;
            this.room = room;
            this.newAreaAngle = f2;
        }

        public void undo() throws CannotUndoException {
            super.undo();
            this.room.setAreaAngle(this.oldAreaAngle);
            this.controller.selectAndShowItems(Arrays.asList(this.room));
        }

        public void redo() throws CannotRedoException {
            super.redo();
            this.room.setAreaAngle(this.newAreaAngle);
            this.controller.selectAndShowItems(Arrays.asList(this.room));
        }
    }

    private static class RoomAreaOffsetModificationUndoableEdit
    extends LocalizedUndoableEdit {
        private final PlanController controller;
        private final float oldAreaXOffset;
        private final float oldAreaYOffset;
        private final Room room;
        private final float newAreaXOffset;
        private final float newAreaYOffset;

        public RoomAreaOffsetModificationUndoableEdit(PlanController planController, UserPreferences userPreferences, float f, float f2, Room room, float f3, float f4) {
            super(userPreferences, PlanController.class, "undoRoomAreaOffsetName");
            this.controller = planController;
            this.oldAreaXOffset = f;
            this.oldAreaYOffset = f2;
            this.room = room;
            this.newAreaXOffset = f3;
            this.newAreaYOffset = f4;
        }

        public void undo() throws CannotUndoException {
            super.undo();
            this.room.setAreaXOffset(this.oldAreaXOffset);
            this.room.setAreaYOffset(this.oldAreaYOffset);
            this.controller.selectAndShowItems(Arrays.asList(this.room));
        }

        public void redo() throws CannotRedoException {
            super.redo();
            this.room.setAreaXOffset(this.newAreaXOffset);
            this.room.setAreaYOffset(this.newAreaYOffset);
            this.controller.selectAndShowItems(Arrays.asList(this.room));
        }
    }

    private static class RoomNameRotationUndoableEdit
    extends LocalizedUndoableEdit {
        private final PlanController controller;
        private final float oldNameAngle;
        private final Room room;
        private final float newNameAngle;

        public RoomNameRotationUndoableEdit(PlanController planController, UserPreferences userPreferences, float f, Room room, float f2) {
            super(userPreferences, PlanController.class, "undoRoomNameRotationName");
            this.controller = planController;
            this.oldNameAngle = f;
            this.room = room;
            this.newNameAngle = f2;
        }

        public void undo() throws CannotUndoException {
            super.undo();
            this.room.setNameAngle(this.oldNameAngle);
            this.controller.selectAndShowItems(Arrays.asList(this.room));
        }

        public void redo() throws CannotRedoException {
            super.redo();
            this.room.setNameAngle(this.newNameAngle);
            this.controller.selectAndShowItems(Arrays.asList(this.room));
        }
    }

    private static class RoomNameOffsetModificationUndoableEdit
    extends LocalizedUndoableEdit {
        private final PlanController controller;
        private final float oldNameXOffset;
        private final float oldNameYOffset;
        private final Room room;
        private final float newNameXOffset;
        private final float newNameYOffset;

        public RoomNameOffsetModificationUndoableEdit(PlanController planController, UserPreferences userPreferences, float f, float f2, Room room, float f3, float f4) {
            super(userPreferences, PlanController.class, "undoRoomNameOffsetName");
            this.controller = planController;
            this.oldNameXOffset = f;
            this.oldNameYOffset = f2;
            this.room = room;
            this.newNameXOffset = f3;
            this.newNameYOffset = f4;
        }

        public void undo() throws CannotUndoException {
            super.undo();
            this.room.setNameXOffset(this.oldNameXOffset);
            this.room.setNameYOffset(this.oldNameYOffset);
            this.controller.selectAndShowItems(Arrays.asList(this.room));
        }

        public void redo() throws CannotRedoException {
            super.redo();
            this.room.setNameXOffset(this.newNameXOffset);
            this.room.setNameYOffset(this.newNameYOffset);
            this.controller.selectAndShowItems(Arrays.asList(this.room));
        }
    }

    private static class RoomResizingUndoableEdit
    extends LocalizedUndoableEdit {
        private final PlanController controller;
        private final float oldX;
        private final float oldY;
        private final Room room;
        private final int pointIndex;
        private final float newX;
        private final float newY;

        public RoomResizingUndoableEdit(PlanController planController, UserPreferences userPreferences, float f, float f2, Room room, int n, float f3, float f4) {
            super(userPreferences, PlanController.class, "undoRoomResizeName");
            this.controller = planController;
            this.oldX = f;
            this.oldY = f2;
            this.room = room;
            this.pointIndex = n;
            this.newX = f3;
            this.newY = f4;
        }

        public void undo() throws CannotUndoException {
            super.undo();
            PlanController.moveRoomPoint(this.room, this.oldX, this.oldY, this.pointIndex);
            this.controller.selectAndShowItems(Arrays.asList(this.room));
        }

        public void redo() throws CannotRedoException {
            super.redo();
            PlanController.moveRoomPoint(this.room, this.newX, this.newY, this.pointIndex);
            this.controller.selectAndShowItems(Arrays.asList(this.room));
        }
    }

    private static class WallArcExtentModificationUndoableEdit
    extends LocalizedUndoableEdit {
        private final PlanController controller;
        private final Float oldArcExtent;
        private final Wall wall;
        private final Float newArcExtent;

        public WallArcExtentModificationUndoableEdit(PlanController planController, UserPreferences userPreferences, Float f, Wall wall, Float f2) {
            super(userPreferences, PlanController.class, "undoWallArcExtentName");
            this.controller = planController;
            this.oldArcExtent = f;
            this.wall = wall;
            this.newArcExtent = f2;
        }

        public void undo() throws CannotUndoException {
            super.undo();
            this.wall.setArcExtent(this.oldArcExtent);
            this.controller.selectAndShowItems(Arrays.asList(this.wall));
        }

        public void redo() throws CannotRedoException {
            super.redo();
            this.wall.setArcExtent(this.newArcExtent);
            this.controller.selectAndShowItems(Arrays.asList(this.wall));
        }
    }

    private static class WallResizingUndoableEdit
    extends LocalizedUndoableEdit {
        private final PlanController controller;
        private final float oldX;
        private final float oldY;
        private final Wall wall;
        private final boolean startPoint;
        private final float newX;
        private final float newY;

        public WallResizingUndoableEdit(PlanController planController, UserPreferences userPreferences, float f, float f2, Wall wall, boolean bl, float f3, float f4) {
            super(userPreferences, PlanController.class, "undoWallResizeName");
            this.controller = planController;
            this.oldX = f;
            this.oldY = f2;
            this.wall = wall;
            this.startPoint = bl;
            this.newX = f3;
            this.newY = f4;
        }

        public void undo() throws CannotUndoException {
            super.undo();
            PlanController.moveWallPoint(this.wall, this.oldX, this.oldY, this.startPoint);
            this.controller.selectAndShowItems(Arrays.asList(this.wall));
        }

        public void redo() throws CannotRedoException {
            super.redo();
            PlanController.moveWallPoint(this.wall, this.newX, this.newY, this.startPoint);
            this.controller.selectAndShowItems(Arrays.asList(this.wall));
        }
    }

    private static class DuplicationEndUndoableEdit
    extends LocalizedUndoableEdit {
        private final PlanController controller;
        private final Selectable[] items;

        public DuplicationEndUndoableEdit(PlanController planController, UserPreferences userPreferences, Selectable[] selectableArray) {
            super(userPreferences, PlanController.class, "undoDuplicateSelectionName");
            this.controller = planController;
            this.items = selectableArray;
        }

        public void redo() throws CannotRedoException {
            super.redo();
            this.controller.selectAndShowItems(Arrays.asList(this.items));
        }
    }

    private static class DuplicationStartUndoableEdit
    extends AbstractUndoableEdit {
        private final PlanController controller;
        private final Selectable[] oldSelection;
        private final boolean allLevelsSelection;

        public DuplicationStartUndoableEdit(PlanController planController, Selectable[] selectableArray, boolean bl) {
            this.controller = planController;
            this.oldSelection = selectableArray;
            this.allLevelsSelection = bl;
        }

        public void undo() throws CannotRedoException {
            super.undo();
            this.controller.selectAndShowItems(Arrays.asList(this.oldSelection), this.allLevelsSelection);
        }
    }

    private static class PieceOfFurnitureMovingUndoableEdit
    extends LocalizedUndoableEdit {
        private final PlanController controller;
        private final float oldAngle;
        private final float oldDepth;
        private final float oldElevation;
        private final boolean oldDoorOrWindowBoundToWall;
        private final HomePieceOfFurniture piece;
        private final float dx;
        private final float dy;
        private final float newAngle;
        private final float newDepth;
        private final float newElevation;

        public PieceOfFurnitureMovingUndoableEdit(PlanController planController, UserPreferences userPreferences, float f, float f2, float f3, boolean bl, HomePieceOfFurniture homePieceOfFurniture, float f4, float f5, float f6, float f7, float f8) {
            super(userPreferences, PlanController.class, "undoMoveSelectionName");
            this.controller = planController;
            this.oldAngle = f;
            this.oldDepth = f2;
            this.oldElevation = f3;
            this.oldDoorOrWindowBoundToWall = bl;
            this.piece = homePieceOfFurniture;
            this.dx = f4;
            this.dy = f5;
            this.newAngle = f6;
            this.newDepth = f7;
            this.newElevation = f8;
        }

        public void undo() throws CannotUndoException {
            super.undo();
            this.piece.move(-this.dx, -this.dy);
            this.piece.setAngle(this.oldAngle);
            if (this.piece instanceof HomeDoorOrWindow && this.piece.isResizable() && this.controller.isItemResizable(this.piece)) {
                this.piece.setDepth(this.oldDepth);
            }
            this.piece.setElevation(this.oldElevation);
            if (this.piece instanceof HomeDoorOrWindow) {
                ((HomeDoorOrWindow)this.piece).setBoundToWall(this.oldDoorOrWindowBoundToWall);
            }
            this.controller.selectAndShowItems(Arrays.asList(this.piece));
        }

        public void redo() throws CannotRedoException {
            super.redo();
            this.piece.move(this.dx, this.dy);
            this.piece.setAngle(this.newAngle);
            if (this.piece instanceof HomeDoorOrWindow && this.piece.isResizable() && this.controller.isItemResizable(this.piece)) {
                this.piece.setDepth(this.newDepth);
            }
            this.piece.setElevation(this.newElevation);
            this.controller.selectAndShowItems(Arrays.asList(this.piece));
        }
    }

    private static class ItemsMovingUndoableEdit
    extends LocalizedUndoableEdit {
        private final PlanController controller;
        private final Selectable[] oldSelection;
        private final boolean allLevelsSelection;
        private final Selectable[] itemsArray;
        private final float dx;
        private final float dy;

        public ItemsMovingUndoableEdit(PlanController planController, UserPreferences userPreferences, Selectable[] selectableArray, boolean bl, Selectable[] selectableArray2, float f, float f2) {
            super(userPreferences, PlanController.class, "undoMoveSelectionName");
            this.controller = planController;
            this.oldSelection = selectableArray;
            this.allLevelsSelection = bl;
            this.itemsArray = selectableArray2;
            this.dx = f;
            this.dy = f2;
        }

        public void undo() throws CannotUndoException {
            super.undo();
            this.controller.doMoveAndShowItems(this.itemsArray, this.oldSelection, -this.dx, -this.dy, this.allLevelsSelection);
        }

        public void redo() throws CannotRedoException {
            super.redo();
            this.controller.doMoveAndShowItems(this.itemsArray, this.itemsArray, this.dx, this.dy, this.allLevelsSelection);
        }
    }

    private static class LabelElevationModificationUndoableEdit
    extends LocalizedUndoableEdit {
        private final PlanController controller;
        private final float oldElevation;
        private final Label label;
        private final float newElevation;

        public LabelElevationModificationUndoableEdit(PlanController planController, UserPreferences userPreferences, float f, Label label, float f2) {
            super(userPreferences, PlanController.class, f < f2 ? "undoLabelRaiseName" : "undoLabelLowerName");
            this.controller = planController;
            this.oldElevation = f;
            this.label = label;
            this.newElevation = f2;
        }

        public void undo() throws CannotUndoException {
            super.undo();
            this.label.setElevation(this.oldElevation);
            this.controller.selectAndShowItems(Arrays.asList(this.label));
        }

        public void redo() throws CannotRedoException {
            super.redo();
            this.label.setElevation(this.newElevation);
            this.controller.selectAndShowItems(Arrays.asList(this.label));
        }
    }

    private static class LabelRotationUndoableEdit
    extends LocalizedUndoableEdit {
        private final PlanController controller;
        private final float oldAngle;
        private final Label label;
        private final float newAngle;

        public LabelRotationUndoableEdit(PlanController planController, UserPreferences userPreferences, float f, Label label, float f2) {
            super(userPreferences, PlanController.class, "undoLabelRotationName");
            this.controller = planController;
            this.oldAngle = f;
            this.label = label;
            this.newAngle = f2;
        }

        public void undo() throws CannotUndoException {
            super.undo();
            this.label.setAngle(this.oldAngle);
            this.controller.selectAndShowItems(Arrays.asList(this.label));
        }

        public void redo() throws CannotRedoException {
            super.redo();
            this.label.setAngle(this.newAngle);
            this.controller.selectAndShowItems(Arrays.asList(this.label));
        }
    }

    private static class LabelsCreationUndoableEdit
    extends LocalizedUndoableEdit {
        private final PlanController controller;
        private final Selectable[] oldSelection;
        private final boolean oldBasePlanLocked;
        private final boolean oldAllLevelsSelection;
        private final Label[] labels;
        private final Level labelsLevel;
        private final boolean newBasePlanLocked;

        public LabelsCreationUndoableEdit(PlanController planController, UserPreferences userPreferences, Selectable[] selectableArray, boolean bl, boolean bl2, Label[] labelArray, Level level, boolean bl3) {
            super(userPreferences, PlanController.class, "undoCreateLabelsName");
            this.controller = planController;
            this.oldSelection = selectableArray;
            this.oldBasePlanLocked = bl;
            this.oldAllLevelsSelection = bl2;
            this.labels = labelArray;
            this.labelsLevel = level;
            this.newBasePlanLocked = bl3;
        }

        public void undo() throws CannotUndoException {
            super.undo();
            this.controller.doDeleteLabels(this.labels, this.oldBasePlanLocked);
            this.controller.selectAndShowItems(Arrays.asList(this.oldSelection), this.oldAllLevelsSelection);
        }

        public void redo() throws CannotRedoException {
            super.redo();
            this.controller.doAddLabels(this.labels, null, this.labelsLevel, this.newBasePlanLocked);
            this.controller.selectAndShowItems(Arrays.asList(this.labels), false);
        }
    }

    private static class PolylinesCreationUndoableEdit
    extends LocalizedUndoableEdit {
        private final PlanController controller;
        private final Selectable[] oldSelection;
        private final boolean oldBasePlanLocked;
        private final boolean oldAllLevelsSelection;
        private final Polyline[] newPolylines;
        private final int[] polylinesIndex;
        private final Level polylinesLevel;
        private final boolean newBasePlanLocked;

        public PolylinesCreationUndoableEdit(PlanController planController, UserPreferences userPreferences, Selectable[] selectableArray, boolean bl, boolean bl2, Polyline[] polylineArray, int[] nArray, Level level, boolean bl3) {
            super(userPreferences, PlanController.class, "undoCreatePolylinesName");
            this.controller = planController;
            this.oldSelection = selectableArray;
            this.oldBasePlanLocked = bl;
            this.oldAllLevelsSelection = bl2;
            this.newPolylines = polylineArray;
            this.polylinesIndex = nArray;
            this.polylinesLevel = level;
            this.newBasePlanLocked = bl3;
        }

        public void undo() throws CannotUndoException {
            super.undo();
            this.controller.doDeletePolylines(this.newPolylines, this.oldBasePlanLocked);
            this.controller.selectAndShowItems(Arrays.asList(this.oldSelection), this.oldAllLevelsSelection);
        }

        public void redo() throws CannotRedoException {
            super.redo();
            this.controller.doAddPolylines(this.newPolylines, this.polylinesIndex, null, this.polylinesLevel, this.newBasePlanLocked);
            this.controller.selectAndShowItems(Arrays.asList(this.newPolylines));
        }
    }

    private static class DimensionLinesCreationUndoableEdit
    extends LocalizedUndoableEdit {
        private final PlanController controller;
        private final Selectable[] oldSelection;
        private final boolean oldBasePlanLocked;
        private final boolean oldAllLevelsSelection;
        private final DimensionLine[] dimensionLines;
        private final Level dimensionLinesLevel;
        private final boolean newBasePlanLocked;

        public DimensionLinesCreationUndoableEdit(PlanController planController, UserPreferences userPreferences, Selectable[] selectableArray, boolean bl, boolean bl2, DimensionLine[] dimensionLineArray, Level level, boolean bl3) {
            super(userPreferences, PlanController.class, "undoCreateDimensionLinesName");
            this.controller = planController;
            this.oldSelection = selectableArray;
            this.oldBasePlanLocked = bl;
            this.oldAllLevelsSelection = bl2;
            this.dimensionLines = dimensionLineArray;
            this.dimensionLinesLevel = level;
            this.newBasePlanLocked = bl3;
        }

        public void undo() throws CannotUndoException {
            super.undo();
            this.controller.doDeleteDimensionLines(this.dimensionLines, this.oldBasePlanLocked);
            this.controller.selectAndShowItems(Arrays.asList(this.oldSelection), this.oldAllLevelsSelection);
        }

        public void redo() throws CannotRedoException {
            super.redo();
            this.controller.doAddDimensionLines(this.dimensionLines, null, this.dimensionLinesLevel, this.newBasePlanLocked);
            this.controller.selectAndShowItems(Arrays.asList(this.dimensionLines), false);
        }
    }

    private static class RoomsCreationUndoableEdit
    extends LocalizedUndoableEdit {
        private final PlanController controller;
        private final Selectable[] oldSelection;
        private final boolean oldBasePlanLocked;
        private final boolean oldAllLevelsSelection;
        private final Room[] newRooms;
        private final int[] roomsIndex;
        private final Level roomsLevel;
        private final boolean newBasePlanLocked;

        public RoomsCreationUndoableEdit(PlanController planController, UserPreferences userPreferences, Selectable[] selectableArray, boolean bl, boolean bl2, Room[] roomArray, int[] nArray, Level level, boolean bl3) {
            super(userPreferences, PlanController.class, "undoCreateRoomsName");
            this.controller = planController;
            this.oldSelection = selectableArray;
            this.oldBasePlanLocked = bl;
            this.oldAllLevelsSelection = bl2;
            this.newRooms = roomArray;
            this.roomsIndex = nArray;
            this.roomsLevel = level;
            this.newBasePlanLocked = bl3;
        }

        public void undo() throws CannotUndoException {
            super.undo();
            this.controller.doDeleteRooms(this.newRooms, this.oldBasePlanLocked);
            this.controller.selectAndShowItems(Arrays.asList(this.oldSelection), this.oldAllLevelsSelection);
        }

        public void redo() throws CannotRedoException {
            super.redo();
            this.controller.doAddRooms(this.newRooms, this.roomsIndex, null, this.roomsLevel, this.newBasePlanLocked);
            this.controller.selectAndShowItems(Arrays.asList(this.newRooms), false);
        }
    }

    private static class WallsCreationUndoableEdit
    extends LocalizedUndoableEdit {
        private final PlanController controller;
        private final Selectable[] oldSelection;
        private final boolean oldBasePlanLocked;
        private final boolean oldAllLevelsSelection;
        private final JoinedWall[] joinedNewWalls;
        private final boolean newBasePlanLocked;

        public WallsCreationUndoableEdit(PlanController planController, UserPreferences userPreferences, Selectable[] selectableArray, boolean bl, boolean bl2, JoinedWall[] joinedWallArray, boolean bl3) {
            super(userPreferences, PlanController.class, "undoCreateWallsName");
            this.controller = planController;
            this.oldSelection = selectableArray;
            this.oldBasePlanLocked = bl;
            this.oldAllLevelsSelection = bl2;
            this.joinedNewWalls = joinedWallArray;
            this.newBasePlanLocked = bl3;
        }

        public void undo() throws CannotUndoException {
            super.undo();
            this.controller.doDeleteWalls(this.joinedNewWalls, this.oldBasePlanLocked);
            this.controller.selectAndShowItems(Arrays.asList(this.oldSelection), this.oldAllLevelsSelection);
        }

        public void redo() throws CannotRedoException {
            super.redo();
            this.controller.doAddWalls(this.joinedNewWalls, this.newBasePlanLocked);
            this.controller.selectAndShowItems(JoinedWall.getWalls(this.joinedNewWalls), false);
        }
    }

    private static class ItemsAdditionEndUndoableEdit
    extends LocalizedUndoableEdit {
        private final Home home;
        private final Selectable[] items;

        private ItemsAdditionEndUndoableEdit(Home home, UserPreferences userPreferences, Selectable[] selectableArray) {
            super(userPreferences, PlanController.class, "undoAddItemsName");
            this.home = home;
            this.items = selectableArray;
        }

        public void redo() throws CannotRedoException {
            super.redo();
            this.home.setSelectedItems(Arrays.asList(this.items));
        }
    }

    private static class ItemsDeletionUndoableEdit
    extends LocalizedUndoableEdit {
        private final PlanController controller;
        private final boolean basePlanLocked;
        private final boolean allLevelsSelection;
        private final Selectable[] deletedItems;
        private final JoinedWall[] joinedDeletedWalls;
        private final Room[] rooms;
        private final int[] roomsIndices;
        private final Level[] roomsLevels;
        private final DimensionLine[] dimensionLines;
        private final Level[] dimensionLinesLevels;
        private final Polyline[] polylines;
        private final int[] polylinesIndices;
        private final Level[] polylinesLevels;
        private final Label[] labels;
        private final Level[] labelsLevels;

        public ItemsDeletionUndoableEdit(PlanController planController, UserPreferences userPreferences, boolean bl, boolean bl2, Selectable[] selectableArray, JoinedWall[] joinedWallArray, Room[] roomArray, int[] nArray, Level[] levelArray, DimensionLine[] dimensionLineArray, Level[] levelArray2, Polyline[] polylineArray, int[] nArray2, Level[] levelArray3, Label[] labelArray, Level[] levelArray4) {
            super(userPreferences, PlanController.class, "undoDeleteSelectionName");
            this.controller = planController;
            this.basePlanLocked = bl;
            this.allLevelsSelection = bl2;
            this.deletedItems = selectableArray;
            this.joinedDeletedWalls = joinedWallArray;
            this.rooms = roomArray;
            this.roomsIndices = nArray;
            this.roomsLevels = levelArray;
            this.dimensionLines = dimensionLineArray;
            this.dimensionLinesLevels = levelArray2;
            this.polylines = polylineArray;
            this.polylinesIndices = nArray2;
            this.polylinesLevels = levelArray3;
            this.labels = labelArray;
            this.labelsLevels = levelArray4;
        }

        public void undo() throws CannotUndoException {
            super.undo();
            this.controller.doAddWalls(this.joinedDeletedWalls, this.basePlanLocked);
            this.controller.doAddRooms(this.rooms, this.roomsIndices, this.roomsLevels, null, this.basePlanLocked);
            this.controller.doAddDimensionLines(this.dimensionLines, this.dimensionLinesLevels, null, this.basePlanLocked);
            this.controller.doAddPolylines(this.polylines, this.polylinesIndices, this.polylinesLevels, null, this.basePlanLocked);
            this.controller.doAddLabels(this.labels, this.labelsLevels, null, this.basePlanLocked);
            this.controller.selectAndShowItems(Arrays.asList(this.deletedItems), this.allLevelsSelection);
        }

        public void redo() throws CannotRedoException {
            super.redo();
            this.controller.selectItems(Arrays.asList(this.deletedItems));
            this.controller.doDeleteWalls(this.joinedDeletedWalls, this.basePlanLocked);
            this.controller.doDeleteRooms(this.rooms, this.basePlanLocked);
            this.controller.doDeleteDimensionLines(this.dimensionLines, this.basePlanLocked);
            this.controller.doDeletePolylines(this.polylines, this.basePlanLocked);
            this.controller.doDeleteLabels(this.labels, this.basePlanLocked);
        }
    }

    private static class ItemsDeletionEndUndoableEdit
    extends AbstractUndoableEdit {
        private PlanController controller;
        private Home home;

        public ItemsDeletionEndUndoableEdit(PlanController planController, Home home) {
            this.controller = planController;
            this.home = home;
        }

        public void redo() throws CannotRedoException {
            super.redo();
            this.home.addSelectionListener(this.controller.getSelectionListener());
        }
    }

    private static class ItemsDeletionStartUndoableEdit
    extends AbstractUndoableEdit {
        private final PlanController controller;
        private final Home home;
        private final boolean allLevelsSelection;
        private final Selectable[] selectedItems;

        public ItemsDeletionStartUndoableEdit(PlanController planController, Home home, boolean bl, Selectable[] selectableArray) {
            this.controller = planController;
            this.home = home;
            this.allLevelsSelection = bl;
            this.selectedItems = selectableArray;
        }

        public void undo() throws CannotRedoException {
            super.undo();
            this.controller.selectAndShowItems(Arrays.asList(this.selectedItems), this.allLevelsSelection);
        }

        public void redo() throws CannotRedoException {
            super.redo();
            this.home.removeSelectionListener(this.controller.getSelectionListener());
        }
    }

    private static class RoomPointDeletionUndoableEdit
    extends LocalizedUndoableEdit {
        private final PlanController controller;
        private final Selectable[] oldSelection;
        private final Room room;
        private final int index;
        private final float xPoint;
        private final float yPoint;

        public RoomPointDeletionUndoableEdit(PlanController planController, UserPreferences userPreferences, Selectable[] selectableArray, Room room, int n, float f, float f2) {
            super(userPreferences, PlanController.class, "undoDeleteRoomPointName");
            this.controller = planController;
            this.oldSelection = selectableArray;
            this.room = room;
            this.index = n;
            this.xPoint = f;
            this.yPoint = f2;
        }

        public void undo() throws CannotUndoException {
            super.undo();
            this.room.addPoint(this.xPoint, this.yPoint, this.index);
            this.controller.selectAndShowItems(Arrays.asList(this.oldSelection));
        }

        public void redo() throws CannotRedoException {
            super.redo();
            this.room.removePoint(this.index);
            this.controller.selectAndShowItems(Arrays.asList(this.room));
        }
    }

    private static class RoomPointAdditionUndoableEdit
    extends LocalizedUndoableEdit {
        private final PlanController controller;
        private final Selectable[] oldSelection;
        private final Room room;
        private final int index;
        private final float x;
        private final float y;

        public RoomPointAdditionUndoableEdit(PlanController planController, UserPreferences userPreferences, Selectable[] selectableArray, Room room, int n, float f, float f2) {
            super(userPreferences, PlanController.class, "undoAddRoomPointName");
            this.controller = planController;
            this.oldSelection = selectableArray;
            this.room = room;
            this.index = n;
            this.x = f;
            this.y = f2;
        }

        public void undo() throws CannotUndoException {
            super.undo();
            this.room.removePoint(this.index);
            this.controller.selectAndShowItems(Arrays.asList(this.oldSelection));
        }

        public void redo() throws CannotRedoException {
            super.redo();
            this.room.addPoint(this.x, this.y, this.index);
            this.controller.selectAndShowItems(Arrays.asList(this.room));
        }
    }

    private static class LevelDeletionUndoableEdit
    extends LocalizedUndoableEdit {
        private final PlanController controller;
        private final Home home;
        private final Level oldSelectedLevel;
        private final Level remainingLevel;
        private final Float remainingLevelElevation;
        private final boolean remainingLevelViewable;

        public LevelDeletionUndoableEdit(PlanController planController, Home home, UserPreferences userPreferences, Level level, Level level2, Float f, boolean bl) {
            super(userPreferences, PlanController.class, "undoDeleteSelectedLevel");
            this.controller = planController;
            this.home = home;
            this.oldSelectedLevel = level;
            this.remainingLevel = level2;
            this.remainingLevelElevation = f;
            this.remainingLevelViewable = bl;
        }

        public void undo() throws CannotUndoException {
            super.undo();
            if (this.remainingLevel != null) {
                this.remainingLevel.setElevation(this.remainingLevelElevation.floatValue());
                this.remainingLevel.setViewable(this.remainingLevelViewable);
            }
            this.home.addLevel(this.oldSelectedLevel);
            this.controller.setSelectedLevel(this.oldSelectedLevel);
        }

        public void redo() throws CannotRedoException {
            super.redo();
            this.home.deleteLevel(this.oldSelectedLevel);
            if (this.remainingLevel != null) {
                this.remainingLevel.setElevation(0.0f);
                this.remainingLevel.setViewable(true);
            }
        }
    }

    private static class AllLevelsViewabilityModificationUndoableEdit
    extends LocalizedUndoableEdit {
        private final PlanController controller;
        private final Level selectedLevel;
        private final Level[] unviewableLevels;

        public AllLevelsViewabilityModificationUndoableEdit(PlanController planController, UserPreferences userPreferences, Level level, Level[] levelArray) {
            super(userPreferences, PlanController.class, "undoModifyLevelViewabilityName");
            this.controller = planController;
            this.selectedLevel = level;
            this.unviewableLevels = levelArray;
        }

        public void undo() throws CannotUndoException {
            super.undo();
            this.controller.setSelectedLevel(this.selectedLevel);
            PlanController.setLevelsViewability(this.unviewableLevels, false);
        }

        public void redo() throws CannotRedoException {
            super.redo();
            this.controller.setSelectedLevel(this.selectedLevel);
            PlanController.setLevelsViewability(this.unviewableLevels, true);
        }
    }

    private static class LevelsViewabilityModificationUndoableEdit
    extends LocalizedUndoableEdit {
        private final PlanController controller;
        private final Level selectedLevel;
        private final boolean selectedLevelViewable;
        private final Level[] viewableLevels;

        public LevelsViewabilityModificationUndoableEdit(PlanController planController, UserPreferences userPreferences, Level level, boolean bl, Level[] levelArray) {
            super(userPreferences, PlanController.class, "undoModifyLevelViewabilityName");
            this.controller = planController;
            this.selectedLevel = level;
            this.selectedLevelViewable = bl;
            this.viewableLevels = levelArray;
        }

        public void undo() throws CannotUndoException {
            super.undo();
            this.controller.setSelectedLevel(this.selectedLevel);
            PlanController.setLevelsViewability(this.viewableLevels, true);
            this.selectedLevel.setViewable(this.selectedLevelViewable);
        }

        public void redo() throws CannotRedoException {
            super.redo();
            this.controller.setSelectedLevel(this.selectedLevel);
            PlanController.setLevelsViewability(this.viewableLevels, false);
            this.selectedLevel.setViewable(true);
        }
    }

    private static class LevelViewabilityModificationUndoableEdit
    extends LocalizedUndoableEdit {
        private final PlanController controller;
        private final Level selectedLevel;

        public LevelViewabilityModificationUndoableEdit(PlanController planController, UserPreferences userPreferences, Level level) {
            super(userPreferences, PlanController.class, "undoModifyLevelViewabilityName");
            this.controller = planController;
            this.selectedLevel = level;
        }

        public void undo() throws CannotUndoException {
            super.undo();
            this.controller.setSelectedLevel(this.selectedLevel);
            this.selectedLevel.setViewable(!this.selectedLevel.isViewable());
        }

        public void redo() throws CannotRedoException {
            super.redo();
            this.controller.setSelectedLevel(this.selectedLevel);
            this.selectedLevel.setViewable(!this.selectedLevel.isViewable());
        }
    }

    private static class LevelAdditionUndoableEdit
    extends LocalizedUndoableEdit {
        private final PlanController controller;
        private final Home home;
        private final Selectable[] oldSelection;
        private final boolean allLevelsSelection;
        private final Level oldSelectedLevel;
        private final Level level0;
        private final BackgroundImage homeBackgroundImage;
        private final Level newLevel;

        public LevelAdditionUndoableEdit(PlanController planController, Home home, UserPreferences userPreferences, Selectable[] selectableArray, boolean bl, Level level, Level level2, BackgroundImage backgroundImage, Level level3) {
            super(userPreferences, PlanController.class, "undoAddLevel");
            this.controller = planController;
            this.home = home;
            this.oldSelection = selectableArray;
            this.allLevelsSelection = bl;
            this.oldSelectedLevel = level;
            this.level0 = level2;
            this.homeBackgroundImage = backgroundImage;
            this.newLevel = level3;
        }

        public void undo() throws CannotUndoException {
            super.undo();
            this.controller.setSelectedLevel(this.oldSelectedLevel);
            this.home.deleteLevel(this.newLevel);
            if (this.level0 != null) {
                this.home.setBackgroundImage(this.homeBackgroundImage);
                this.controller.moveHomeItemsToLevel(this.oldSelectedLevel);
                this.home.deleteLevel(this.level0);
            }
            this.controller.selectAndShowItems(Arrays.asList(this.oldSelection), this.allLevelsSelection);
        }

        public void redo() throws CannotRedoException {
            super.redo();
            if (this.level0 != null) {
                this.home.addLevel(this.level0);
                this.controller.moveHomeItemsToLevel(this.level0);
                this.level0.setBackgroundImage(this.homeBackgroundImage);
                this.home.setBackgroundImage(null);
            }
            this.home.addLevel(this.newLevel);
            this.controller.setSelectedLevel(this.newLevel);
        }
    }

    private static class TextStyleModificationUndoableEdit
    extends LocalizedUndoableEdit {
        private final PlanController controller;
        private final Selectable[] oldSelection;
        private final boolean allLevelsSelection;
        private final TextStyle[] oldStyles;
        private final Selectable[] items;
        private final TextStyle[] styles;

        public TextStyleModificationUndoableEdit(PlanController planController, UserPreferences userPreferences, Selectable[] selectableArray, boolean bl, TextStyle[] textStyleArray, Selectable[] selectableArray2, TextStyle[] textStyleArray2) {
            super(userPreferences, PlanController.class, "undoModifyTextStyleName");
            this.controller = planController;
            this.oldSelection = selectableArray;
            this.allLevelsSelection = bl;
            this.oldStyles = textStyleArray;
            this.items = selectableArray2;
            this.styles = textStyleArray2;
        }

        public void undo() throws CannotUndoException {
            super.undo();
            PlanController.doModifyTextStyle(this.items, this.oldStyles);
            this.controller.selectAndShowItems(Arrays.asList(this.oldSelection), this.allLevelsSelection);
        }

        public void redo() throws CannotRedoException {
            super.redo();
            PlanController.doModifyTextStyle(this.items, this.styles);
            this.controller.selectAndShowItems(Arrays.asList(this.oldSelection), this.allLevelsSelection);
        }
    }

    private static class WallSplittingUndoableEdit
    extends LocalizedUndoableEdit {
        private final PlanController controller;
        private final Selectable[] oldSelection;
        private final boolean oldBasePlanLocked;
        private final boolean oldAllLevelsSelection;
        private final JoinedWall splitJoinedWall;
        private final JoinedWall firstJoinedWall;
        private final JoinedWall secondJoinedWall;
        private final boolean newBasePlanLocked;

        public WallSplittingUndoableEdit(PlanController planController, UserPreferences userPreferences, Selectable[] selectableArray, boolean bl, boolean bl2, JoinedWall joinedWall, JoinedWall joinedWall2, JoinedWall joinedWall3, boolean bl3) {
            super(userPreferences, PlanController.class, "undoSplitWallName");
            this.controller = planController;
            this.oldSelection = selectableArray;
            this.oldBasePlanLocked = bl;
            this.oldAllLevelsSelection = bl2;
            this.splitJoinedWall = joinedWall;
            this.firstJoinedWall = joinedWall2;
            this.secondJoinedWall = joinedWall3;
            this.newBasePlanLocked = bl3;
        }

        public void undo() throws CannotUndoException {
            super.undo();
            this.controller.doDeleteWalls(new JoinedWall[]{this.firstJoinedWall, this.secondJoinedWall}, this.oldBasePlanLocked);
            this.controller.doAddWalls(new JoinedWall[]{this.splitJoinedWall}, this.oldBasePlanLocked);
            this.controller.selectAndShowItems(Arrays.asList(this.oldSelection), this.oldAllLevelsSelection);
        }

        public void redo() throws CannotRedoException {
            super.redo();
            this.controller.doDeleteWalls(new JoinedWall[]{this.splitJoinedWall}, this.newBasePlanLocked);
            this.controller.doAddWalls(new JoinedWall[]{this.firstJoinedWall, this.secondJoinedWall}, this.newBasePlanLocked);
            this.controller.selectAndShowItems(Arrays.asList(this.firstJoinedWall.getWall()), false);
        }
    }

    private static class WallsDirectionReversingUndoableEdit
    extends LocalizedUndoableEdit {
        private final PlanController controller;
        private final Selectable[] oldSelection;
        private final boolean allLevelsSelection;
        private final Wall[] walls;

        public WallsDirectionReversingUndoableEdit(PlanController planController, UserPreferences userPreferences, Selectable[] selectableArray, boolean bl, Wall[] wallArray) {
            super(userPreferences, PlanController.class, "undoReverseWallsDirectionName");
            this.controller = planController;
            this.oldSelection = selectableArray;
            this.allLevelsSelection = bl;
            this.walls = wallArray;
        }

        public void undo() throws CannotUndoException {
            super.undo();
            this.controller.doReverseWallsDirection(this.walls);
            this.controller.selectAndShowItems(Arrays.asList(this.oldSelection), this.allLevelsSelection);
        }

        public void redo() throws CannotRedoException {
            super.redo();
            this.controller.doReverseWallsDirection(this.walls);
            this.controller.selectAndShowItems(Arrays.asList(this.walls), false);
        }
    }

    private static class WallsJoiningUndoableEdit
    extends LocalizedUndoableEdit {
        private PlanController controller;
        private final Selectable[] oldSelection;
        private final boolean allLevelsSelection;
        private final JoinedWall[] joinedWalls;
        private final float[] joinPoint;

        public WallsJoiningUndoableEdit(PlanController planController, UserPreferences userPreferences, Selectable[] selectableArray, boolean bl, JoinedWall[] joinedWallArray, float[] fArray) {
            super(userPreferences, PlanController.class, "undoJoinWallsName");
            this.controller = planController;
            this.oldSelection = selectableArray;
            this.allLevelsSelection = bl;
            this.joinedWalls = joinedWallArray;
            this.joinPoint = fArray;
        }

        public void undo() throws CannotUndoException {
            super.undo();
            for (JoinedWall joinedWall : this.joinedWalls) {
                Wall wall = joinedWall.getWall();
                wall.setWallAtStart(joinedWall.getWallAtStart());
                if (joinedWall.getWallAtStart() != null) {
                    if (joinedWall.isJoinedAtEndOfWallAtStart()) {
                        joinedWall.getWallAtStart().setWallAtEnd(wall);
                    } else {
                        joinedWall.getWallAtStart().setWallAtStart(wall);
                    }
                }
                wall.setWallAtEnd(joinedWall.getWallAtEnd());
                if (joinedWall.getWallAtEnd() != null) {
                    if (joinedWall.isJoinedAtStartOfWallAtEnd()) {
                        joinedWall.getWallAtEnd().setWallAtStart(wall);
                    } else {
                        joinedWall.getWallAtEnd().setWallAtEnd(wall);
                    }
                }
                wall.setXStart(joinedWall.getXStart());
                wall.setYStart(joinedWall.getYStart());
                wall.setXEnd(joinedWall.getXEnd());
                wall.setYEnd(joinedWall.getYEnd());
            }
            this.controller.selectAndShowItems(Arrays.asList(this.oldSelection), this.allLevelsSelection);
        }

        public void redo() throws CannotRedoException {
            super.redo();
            this.controller.doJoinWalls(this.joinedWalls, this.joinPoint);
        }
    }

    private static class FlippingUndoableEdit
    extends LocalizedUndoableEdit {
        private final PlanController controller;
        private final boolean allLevelsSelection;
        private final Selectable[] items;
        private final float[][] itemTextBaseOffsets;
        private final boolean horizontalFlip;

        public FlippingUndoableEdit(PlanController planController, UserPreferences userPreferences, boolean bl, Selectable[] selectableArray, float[][] fArray, boolean bl2) {
            super(userPreferences, PlanController.class, "undoFlipName");
            this.controller = planController;
            this.allLevelsSelection = bl;
            this.items = selectableArray;
            this.itemTextBaseOffsets = fArray;
            this.horizontalFlip = bl2;
        }

        public void undo() throws CannotUndoException {
            super.undo();
            this.controller.doFlipItems(this.items, this.itemTextBaseOffsets, this.horizontalFlip);
            this.controller.selectAndShowItems(Arrays.asList(this.items), this.allLevelsSelection);
        }

        public void redo() throws CannotRedoException {
            super.redo();
            this.controller.doFlipItems(this.items, this.itemTextBaseOffsets, this.horizontalFlip);
            this.controller.selectAndShowItems(Arrays.asList(this.items), this.allLevelsSelection);
        }
    }

    private static class UnlockingUndoableEdit
    extends LocalizedUndoableEdit {
        private final PlanController controller;
        private final Home home;
        private final Selectable[] selectedItems;
        private final boolean allLevelsSelection;

        public UnlockingUndoableEdit(PlanController planController, Home home, UserPreferences userPreferences, Selectable[] selectableArray, boolean bl) {
            super(userPreferences, PlanController.class, "undoUnlockBasePlan");
            this.controller = planController;
            this.home = home;
            this.selectedItems = selectableArray;
            this.allLevelsSelection = bl;
        }

        public void undo() throws CannotUndoException {
            super.undo();
            this.home.setBasePlanLocked(true);
            this.controller.selectAndShowItems(Arrays.asList(this.selectedItems), this.allLevelsSelection);
        }

        public void redo() throws CannotRedoException {
            super.redo();
            this.home.setBasePlanLocked(false);
            this.controller.selectAndShowItems(Arrays.asList(this.selectedItems), false);
        }
    }

    private static class LockingUndoableEdit
    extends LocalizedUndoableEdit {
        private final PlanController controller;
        private final Home home;
        private final Selectable[] oldSelection;
        private final boolean allLevelsSelection;
        private final Selectable[] newSelectedItems;

        public LockingUndoableEdit(PlanController planController, Home home, UserPreferences userPreferences, Selectable[] selectableArray, boolean bl, Selectable[] selectableArray2) {
            super(userPreferences, PlanController.class, "undoLockBasePlan");
            this.controller = planController;
            this.home = home;
            this.oldSelection = selectableArray;
            this.allLevelsSelection = bl;
            this.newSelectedItems = selectableArray2;
        }

        public void undo() throws CannotUndoException {
            super.undo();
            this.home.setBasePlanLocked(false);
            this.controller.selectAndShowItems(Arrays.asList(this.oldSelection), this.allLevelsSelection);
        }

        public void redo() throws CannotRedoException {
            super.redo();
            this.home.setBasePlanLocked(true);
            this.controller.selectAndShowItems(Arrays.asList(this.newSelectedItems), this.allLevelsSelection);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EditableProperty {
        X,
        Y,
        LENGTH,
        DIAGONAL,
        ANGLE,
        THICKNESS,
        OFFSET,
        ARC_EXTENT;

    }

    public static class Mode {
        public static final Mode SELECTION = new Mode("SELECTION");
        public static final Mode PANNING = new Mode("PANNING");
        public static final Mode WALL_CREATION = new Mode("WALL_CREATION");
        public static final Mode ROOM_CREATION = new Mode("ROOM_CREATION");
        public static final Mode POLYLINE_CREATION = new Mode("POLYLINE_CREATION");
        public static final Mode DIMENSION_LINE_CREATION = new Mode("DIMENSION_LINE_CREATION");
        public static final Mode LABEL_CREATION = new Mode("LABEL_CREATION");
        private final String name;

        protected Mode(String string) {
            this.name = string;
        }

        public final String name() {
            return this.name;
        }

        public String toString() {
            return this.name;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Property {
        MODE,
        MODIFICATION_STATE,
        BASE_PLAN_MODIFICATION_STATE,
        SCALE;

    }
}

