/*
 * Decompiled with CFR 0.152.
 */
package retypar.gui;

import com.sun.image.codec.jpeg.JPEGCodec;
import com.sun.image.codec.jpeg.JPEGImageDecoder;
import heuser.multilang.Ml;
import heuser.simpleLogger.SimpleLoggerListener;
import heuser.updater.Update;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Image;
import java.awt.MenuItem;
import java.awt.PopupMenu;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.util.Hashtable;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.filechooser.FileFilter;
import retypar.converter.Converter;
import retypar.gui.OptionsFrame;
import retypar.gui.Walker;
import retypar.retypar;
import thirdParty.GifEncoder.GifDecoder;
import thirdParty.ImagePreviewPanel;

public class MainFrame
extends JFrame
implements ActionListener,
ChangeListener,
MouseListener,
SimpleLoggerListener {
    private String filename = "";
    private float wI;
    private float hI;
    private File imgF;
    private BufferedImage convertedImage;
    private Image imConvertedImage;
    private File[] fileArray;
    private File currentDir;
    private Container c = this.getContentPane();
    private Box pictureBox = Box.createVerticalBox();
    private Box userBox = Box.createVerticalBox();
    private Box optionsBox1 = Box.createHorizontalBox();
    private Box optionsBox2 = Box.createHorizontalBox();
    private Box optionsBoxC = Box.createVerticalBox();
    private Box buttonBox = Box.createHorizontalBox();
    private Box langBox1 = Box.createVerticalBox();
    private Box langBox2 = Box.createVerticalBox();
    private Box langBox3 = Box.createVerticalBox();
    private Box langBoxC = Box.createHorizontalBox();
    private final String uCase = "A-Z";
    private final String lCase = "a-z";
    private final String numbers = "0-9";
    private final int strut_small = 10;
    private final int strut_big = 20;
    private JButton loadButton = new JButton();
    private JButton storeButton = new JButton();
    private JButton convertButton = new JButton();
    private JButton viewConvertedButton = new JButton();
    private JButton optionsButton = new JButton();
    private JButton aboutButton = new JButton();
    private JButton cancelButton = new JButton();
    private JCheckBox uppercase = new JCheckBox("A-Z", true);
    private JCheckBox lowercase = new JCheckBox("a-z", true);
    private JCheckBox digits = new JCheckBox("0-9", true);
    private JCheckBox specials = new JCheckBox();
    private JCheckBox colored = new JCheckBox();
    protected JComboBox renderCombo;
    private JSpinner thresholdSpinner;
    private JButton algoInfoButton;
    private Box algoSelectionBox;
    private JComboBox fontCombo;
    private JLabel fontSelectionLabel;
    private Box fontSelectionBox;
    private JScrollPane fontExamplePane;
    private JLabel fontExample1;
    private JLabel fontExample2;
    private JSpinner fontSizeSpinner;
    private JLabel fontSizer;
    private JRadioButton german = new JRadioButton("Deutsch", true);
    private JRadioButton english = new JRadioButton("English", false);
    private JRadioButton french = new JRadioButton("Fran\u00e7aise", false);
    private JRadioButton italian = new JRadioButton("Italiano", false);
    private JRadioButton spanish = new JRadioButton("Espa\u00f1ol", false);
    private JRadioButton blank = new JRadioButton("", false);
    ButtonGroup bg = new ButtonGroup();
    private JScrollPane original;
    private JScrollPane converted;
    private JLabel qualityLabel;
    private Hashtable labelTable;
    private JSlider qualitySlider;
    private JLabel scaleLabel;
    private JSpinner scaleSpinner;
    private JPanel scalePanel;
    private JPanel showColor;
    private JLabel exportFormatLabel;
    private JCheckBox opacityBox;
    private long origFileSizeKB;
    private long convFileSizeKB;
    public Walker walker;
    private Converter converter;
    private JLabel duration;
    protected Ml l;
    private JLabel previewLabel = new JLabel();
    protected String plaf;
    private JSlider slider1;
    private JSlider slider2;
    private JSlider slider3;
    private PopupMenu popUp;
    private MenuItem popReload;
    private MenuItem popLoadNew;
    private MenuItem popSave;
    private MenuItem popConvert;
    private MenuItem popView;
    private MenuItem popAbout;
    private JComboBox exportFormatCombo;
    private Timer memoryCheckTimer;

    public MainFrame() {
        retypar.addLoggerListenerError(this);
        this.initMultiLang();
        this.createInterface();
        this.doPossibleUpdate();
    }

    private void initMultiLang() {
        this.l = new Ml();
        this.l.setOriginalLang("ENG");
        if (!retypar.lang.equals("")) {
            this.l.setLang(retypar.lang);
            return;
        }
        try {
            String string = System.getProperty("user.language");
            if (string.equals("de")) {
                this.l.setLang("GER");
            }
            if (string.equals("fr")) {
                this.l.setLang("FRA");
            }
            if (string.equals("it")) {
                this.l.setLang("ITA");
            }
        }
        catch (Exception exception) {
            retypar.logError("Could not initialize multilanguage module!");
        }
    }

    private void createInterface() {
        this.checkMaxRes();
        BorderLayout borderLayout = new BorderLayout();
        this.c.setLayout(borderLayout);
        this.setResizable(true);
        this.setDefaultCloseOperation(3);
        this.setTitle("retypar 0.9.4 - a tool to convert images into ASCII (Jens Heuser, 2005), http://www.retypar.de.vu");
        Box box = Box.createVerticalBox();
        this.buttonBox.add(Box.createVerticalStrut(10));
        this.loadButton.setEnabled(true);
        this.loadButton.setText(this.l.pr("Open image..."));
        this.loadButton.addActionListener(this);
        this.loadButton.setActionCommand("load");
        this.loadButton.setAlignmentX(1.0f);
        this.storeButton.setEnabled(false);
        this.storeButton.setText(this.l.pr("Store image..."));
        this.storeButton.addActionListener(this);
        this.storeButton.setActionCommand("store");
        this.storeButton.setAlignmentX(1.0f);
        box.add(this.loadButton);
        box.add(Box.createVerticalStrut(10));
        box.add(this.storeButton);
        this.buttonBox.add(box);
        this.buttonBox.add(Box.createHorizontalStrut(10));
        this.convertButton.setEnabled(false);
        this.convertButton.setText(this.l.pr("Convert image!"));
        this.convertButton.addActionListener(this);
        this.convertButton.setActionCommand("convert");
        this.convertButton.setAlignmentX(0.0f);
        this.viewConvertedButton.setEnabled(false);
        this.viewConvertedButton.setText(this.l.pr("View converted image."));
        this.viewConvertedButton.addActionListener(this);
        this.viewConvertedButton.setActionCommand("view");
        this.viewConvertedButton.setAlignmentX(0.0f);
        box = Box.createVerticalBox();
        box.add(this.convertButton);
        box.add(Box.createVerticalStrut(10));
        box.add(this.viewConvertedButton);
        this.buttonBox.add(box);
        this.userBox.add(this.buttonBox);
        this.userBox.add(Box.createVerticalStrut(10));
        this.optionsButton.setEnabled(true);
        this.optionsButton.setText(this.l.pr("Options") + "...");
        this.optionsButton.addActionListener(this);
        this.optionsButton.setActionCommand("options");
        this.optionsButton.setAlignmentX(0.5f);
        this.userBox.add(this.optionsButton);
        this.userBox.add(Box.createVerticalStrut(10));
        this.aboutButton.setEnabled(true);
        this.aboutButton.setText(this.l.pr("About"));
        this.aboutButton.addActionListener(this);
        this.aboutButton.setActionCommand("about");
        this.aboutButton.setAlignmentX(0.5f);
        this.userBox.add(this.aboutButton);
        this.userBox.add(Box.createVerticalStrut(10));
        this.cancelButton.setEnabled(false);
        this.cancelButton.setText(this.l.pr("Cancel!"));
        this.cancelButton.addActionListener(this);
        this.cancelButton.setActionCommand("cancel");
        this.cancelButton.setAlignmentX(0.5f);
        this.userBox.add(this.cancelButton);
        this.userBox.add(Box.createVerticalStrut(20));
        this.userBox.add(Box.createVerticalGlue());
        this.walker = new Walker(this.userBox);
        this.duration = new JLabel("00:00:00");
        this.duration.setAlignmentX(0.5f);
        this.userBox.add(this.duration);
        this.userBox.add(Box.createVerticalGlue());
        this.userBox.add(Box.createVerticalStrut(20));
        this.uppercase.setEnabled(true);
        this.uppercase.addActionListener(this);
        this.uppercase.setActionCommand("uppercase");
        this.optionsBox1.add(this.uppercase);
        this.lowercase.setEnabled(true);
        this.lowercase.addActionListener(this);
        this.lowercase.setActionCommand("lowercase");
        this.optionsBox1.add(this.lowercase);
        this.digits.setEnabled(true);
        this.digits.addActionListener(this);
        this.digits.setActionCommand("digits");
        this.optionsBox1.add(this.digits);
        this.specials.setSelected(false);
        this.specials.setText(this.l.pr("Blank"));
        this.colored.setSelected(true);
        this.colored.setText(this.l.pr("colored"));
        this.optionsBox2.add(this.specials);
        this.optionsBox2.add(this.colored);
        this.optionsBoxC.add(this.optionsBox1);
        this.optionsBoxC.add(this.optionsBox2);
        this.optionsBoxC.setBorder(BorderFactory.createTitledBorder(this.l.pr("Characters")));
        this.showColor = new JPanel(new BorderLayout());
        this.showColor.setBorder(BorderFactory.createTitledBorder(this.l.pr("Background color: ")));
        final JPanel jPanel = new JPanel();
        jPanel.setBackground(Color.WHITE);
        jPanel.setForeground(Color.WHITE);
        this.showColor.setMaximumSize(new Dimension((int)this.optionsBoxC.getPreferredSize().getWidth() * 75 / 100, (int)this.optionsBoxC.getPreferredSize().getHeight()));
        this.showColor.add((Component)jPanel, "Center");
        jPanel.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                Color color = jPanel.getBackground();
                try {
                    Color color2 = JColorChooser.showDialog(MainFrame.this.userBox, MainFrame.this.l.pr("Choose a color"), Color.WHITE);
                    if (color2 != null) {
                        jPanel.setBackground(color2);
                        jPanel.setForeground(color2);
                    }
                }
                catch (Exception exception) {
                    jPanel.setBackground(color);
                    jPanel.setForeground(color);
                }
            }
        });
        Box box2 = Box.createHorizontalBox();
        box2.add(this.optionsBoxC);
        box2.add(this.showColor);
        this.userBox.add(box2);
        this.userBox.add(Box.createVerticalStrut(20));
        this.algoSelectionBox = Box.createVerticalBox();
        this.algoSelectionBox.setBorder(BorderFactory.createTitledBorder(this.l.pr("Algorithm and threshold:")));
        Box box3 = Box.createHorizontalBox();
        this.thresholdSpinner = new JSpinner(new SpinnerNumberModel());
        this.thresholdSpinner.setEditor(new JSpinner.NumberEditor(this.thresholdSpinner));
        this.renderCombo = new JComboBox();
        this.renderCombo.addActionListener(this);
        this.renderCombo.setActionCommand("render");
        this.fillRenderCombo();
        this.algoInfoButton = new JButton("?");
        this.algoInfoButton.addActionListener(this);
        this.algoInfoButton.setActionCommand("algoInfo");
        box3.add(this.renderCombo);
        box3.add(this.thresholdSpinner);
        box3.add(this.algoInfoButton);
        this.algoSelectionBox.add(box3);
        this.algoSelectionBox.setMaximumSize(new Dimension(290, (int)this.algoSelectionBox.getPreferredSize().getHeight()));
        this.userBox.add(this.algoSelectionBox);
        this.userBox.add(Box.createVerticalStrut(20));
        this.fontCombo = new JComboBox();
        for (int i = 0; i < retypar.fonts.length; ++i) {
            this.fontCombo.addItem(retypar.fonts[i].getFontName());
        }
        this.fontCombo.addActionListener(this);
        this.fontCombo.setActionCommand("newFont");
        this.fontCombo.addMouseWheelListener(new MouseWheelListener(){

            public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
                if (MainFrame.this.fontCombo.getSelectedIndex() + mouseWheelEvent.getWheelRotation() >= 0) {
                    MainFrame.this.fontCombo.setSelectedIndex(MainFrame.this.fontCombo.getSelectedIndex() + mouseWheelEvent.getWheelRotation());
                }
            }
        });
        this.fontSizeSpinner = new JSpinner(new SpinnerNumberModel(10, 6, 72, 1));
        this.fontSizeSpinner.addChangeListener(this);
        this.fontSizeSpinner.setEditor(new JSpinner.NumberEditor(this.fontSizeSpinner));
        this.fontSizeSpinner.addMouseWheelListener(new MouseWheelListener(){

            public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
                if (mouseWheelEvent.getWheelRotation() < 0 && MainFrame.this.fontSizeSpinner.getModel().getNextValue() != null) {
                    MainFrame.this.fontSizeSpinner.getModel().setValue(MainFrame.this.fontSizeSpinner.getModel().getNextValue());
                }
                if (mouseWheelEvent.getWheelRotation() > 0 && MainFrame.this.fontSizeSpinner.getModel().getPreviousValue() != null) {
                    MainFrame.this.fontSizeSpinner.getModel().setValue(MainFrame.this.fontSizeSpinner.getModel().getPreviousValue());
                }
            }
        });
        this.fontExample1 = new JLabel();
        this.fontExample1.setFont(new Font(this.fontCombo.getSelectedItem().toString(), retypar.fonts[this.fontCombo.getSelectedIndex()].getStyle(), 22));
        this.fontExample1.setAlignmentX(0.5f);
        this.fontExample1.setText("Font example:");
        this.fontExample2 = new JLabel();
        this.fontExample2.setFont(new Font(this.fontCombo.getSelectedItem().toString(), retypar.fonts[this.fontCombo.getSelectedIndex()].getStyle(), 22));
        this.fontExample2.setAlignmentX(0.5f);
        this.fontExample2.setText("AaBbCcDdEe 0123456789");
        Box box4 = Box.createVerticalBox();
        box4.add(this.fontExample1);
        box4.add(this.fontExample2);
        this.fontExamplePane = new JScrollPane(box4);
        this.fontExamplePane.setHorizontalScrollBarPolicy(31);
        this.fontExamplePane.setVerticalScrollBarPolicy(21);
        this.fontSelectionBox = Box.createVerticalBox();
        Box box5 = Box.createHorizontalBox();
        this.fontSelectionBox.setBorder(BorderFactory.createTitledBorder(this.l.pr("Font and font size: ")));
        box5.add(this.fontCombo);
        box5.add(this.fontSizeSpinner);
        this.fontSelectionBox.add(box5);
        this.fontSelectionBox.add(this.fontExamplePane);
        this.fontSelectionBox.setMaximumSize(this.fontSelectionBox.getPreferredSize());
        this.userBox.add(this.fontSelectionBox);
        this.userBox.add(Box.createVerticalStrut(10));
        this.userBox.add(Box.createVerticalGlue());
        this.scaleSpinner = new JSpinner(new SpinnerNumberModel(100, 1, 10000, 1));
        this.scaleSpinner.setEditor(new JSpinner.NumberEditor(this.scaleSpinner));
        this.scaleSpinner.addMouseWheelListener(new MouseWheelListener(){

            public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
                if (mouseWheelEvent.getWheelRotation() < 0 && MainFrame.this.scaleSpinner.getModel().getNextValue() != null) {
                    MainFrame.this.scaleSpinner.getModel().setValue(MainFrame.this.scaleSpinner.getModel().getNextValue());
                }
                if (mouseWheelEvent.getWheelRotation() > 0 && MainFrame.this.scaleSpinner.getModel().getPreviousValue() != null) {
                    MainFrame.this.scaleSpinner.getModel().setValue(MainFrame.this.scaleSpinner.getModel().getPreviousValue());
                }
            }
        });
        this.exportFormatCombo = new JComboBox<String>(new DefaultComboBoxModel<String>(retypar.availableGraphicalExportFormats));
        this.exportFormatCombo.addActionListener(this);
        this.exportFormatCombo.setActionCommand("newExportFormat");
        this.exportFormatCombo.setEnabled(false);
        this.exportFormatLabel = new JLabel(this.l.pr("Preview as:"));
        Box box6 = Box.createHorizontalBox();
        box6.add(this.exportFormatLabel);
        box6.add(this.exportFormatCombo);
        box6.add(Box.createHorizontalGlue());
        box6.setMaximumSize(new Dimension(290, (int)box6.getPreferredSize().getHeight()));
        this.scaleLabel = new JLabel(this.l.pr("Scalefactor") + " (in %): ");
        this.scalePanel = new JPanel();
        this.scalePanel.add(this.scaleLabel);
        this.scalePanel.add(this.scaleSpinner);
        this.opacityBox = new JCheckBox(this.l.pr("Background color is transparent"), false);
        this.opacityBox.setActionCommand("opacity");
        this.opacityBox.addActionListener(this);
        this.opacityBox.setEnabled(false);
        this.qualityLabel = new JLabel(this.l.pr("Compression:"));
        this.qualitySlider = new JSlider(0, 0, 100, 0);
        this.labelTable = new Hashtable();
        this.labelTable.put(new Integer(0), new JLabel(this.l.pr("low")));
        this.labelTable.put(new Integer(50), new JLabel(this.l.pr("medium")));
        this.labelTable.put(new Integer(100), new JLabel(this.l.pr("high")));
        this.qualitySlider.setLabelTable(this.labelTable);
        this.qualitySlider.setMinorTickSpacing(10);
        this.qualitySlider.setMajorTickSpacing(25);
        this.qualitySlider.setPaintTicks(true);
        this.qualitySlider.setPaintLabels(true);
        this.qualitySlider.setEnabled(false);
        this.qualitySlider.addMouseListener(new MouseAdapter(){

            public void mouseReleased(MouseEvent mouseEvent) {
                if (!MainFrame.this.qualitySlider.isEnabled()) {
                    return;
                }
                MainFrame.this.updateConverted();
                MainFrame.this.qualitySlider.setToolTipText("" + MainFrame.this.qualitySlider.getValue());
            }
        });
        Component component = Box.createHorizontalGlue();
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.add((Component)this.qualityLabel, "South");
        jPanel2.add(component, "Center");
        jPanel2.setMaximumSize(new Dimension(290, (int)jPanel2.getPreferredSize().getHeight()));
        Box box7 = Box.createVerticalBox();
        box7.setBorder(BorderFactory.createTitledBorder("Output"));
        box7.add(box6);
        box7.add(this.scalePanel);
        box7.add(this.opacityBox);
        box7.add(jPanel2);
        box7.add(this.qualitySlider);
        this.userBox.add(box7);
        this.userBox.add(Box.createVerticalGlue());
        this.german.addActionListener(this);
        this.german.setActionCommand("german");
        this.english.addActionListener(this);
        this.english.setActionCommand("english");
        this.french.addActionListener(this);
        this.french.setActionCommand("french");
        this.italian.addActionListener(this);
        this.italian.setActionCommand("italian");
        this.spanish.addActionListener(this);
        this.spanish.setActionCommand("spanish");
        this.blank.addActionListener(this);
        this.blank.setActionCommand("italian");
        this.blank.setEnabled(false);
        this.bg.add(this.german);
        this.bg.add(this.english);
        this.bg.add(this.french);
        this.bg.add(this.italian);
        this.bg.add(this.spanish);
        this.bg.add(this.blank);
        this.langBox1.add(this.german);
        this.langBox1.add(this.english);
        this.langBox2.add(this.french);
        this.langBox2.add(this.italian);
        this.langBox3.add(this.spanish);
        this.langBox3.add(this.blank);
        this.langBoxC.add(this.langBox1);
        this.langBoxC.add(this.langBox2);
        this.langBoxC.add(this.langBox3);
        this.langBoxC.setBorder(BorderFactory.createBevelBorder(1));
        this.userBox.add(this.langBoxC);
        this.userBox.setBorder(BorderFactory.createTitledBorder(this.l.pr("Operations")));
        this.pictureBox.setBorder(BorderFactory.createTitledBorder(this.l.pr("Images")));
        this.pictureBox.addMouseListener(this);
        this.c.add((Component)this.userBox, "West");
        this.c.add((Component)this.pictureBox, "Center");
        this.setBounds(0, 0, 1024, 768);
        this.setExtendedState(6);
        if (retypar.lang.equals("GER")) {
            this.german.doClick();
        }
        if (retypar.lang.equals("ENG")) {
            this.english.doClick();
        }
        if (retypar.lang.equals("FRA")) {
            this.french.doClick();
        }
        if (retypar.lang.equals("ITA")) {
            this.italian.doClick();
        }
        if (retypar.lang.equals("SPA")) {
            this.spanish.doClick();
        }
        this.setPlaf();
        this.setVisible(true);
        this.initPopUp();
        this.pictureBox.add(this.popUp);
        this.fontCombo.setSelectedIndex(this.fontCombo.getSelectedIndex());
        this.addSplashBackground();
    }

    private void startMemoryCheckTimer() {
        this.memoryCheckTimer = new Timer(1000, new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MainFrame.this.memoryCheckTimer.stop();
                MainFrame.this.doMemoryCheck();
                MainFrame.this.memoryCheckTimer.setInitialDelay(10000);
                MainFrame.this.memoryCheckTimer.restart();
            }
        });
        this.memoryCheckTimer.setRepeats(true);
        this.memoryCheckTimer.setCoalesce(true);
        this.memoryCheckTimer.start();
    }

    private void addSplashBackground() {
        JLabel jLabel;
        if (retypar.runningInJar) {
            try {
                InputStream inputStream = this.getClass().getResourceAsStream("/retypar_splash.gif");
                GifDecoder gifDecoder = new GifDecoder();
                gifDecoder.read(inputStream);
                inputStream.close();
                jLabel = new JLabel(new ImageIcon(gifDecoder.getImage()));
            }
            catch (Exception exception) {
                retypar.logError("error accessing splash-image in jar: " + exception.toString());
                jLabel = new JLabel();
            }
        } else {
            File file = new File(retypar.basedir + "retypar_splash.gif");
            jLabel = new JLabel(new ImageIcon(file.getPath()));
        }
        jLabel.setAlignmentX(0.5f);
        this.pictureBox.add(Box.createVerticalGlue());
        this.pictureBox.add(jLabel);
        this.pictureBox.add(Box.createVerticalGlue());
        this.pictureBox.doLayout();
    }

    private void initPopUp() {
        this.popUp = new PopupMenu();
        this.popReload = new MenuItem(this.l.pr("Reload"));
        this.popLoadNew = new MenuItem(this.l.pr("Load new..."));
        this.popSave = new MenuItem(this.l.pr("Save..."));
        this.popConvert = new MenuItem(this.l.pr("Convert"));
        this.popView = new MenuItem(this.l.pr("View"));
        this.popAbout = new MenuItem(this.l.pr("About"));
        this.popReload.setActionCommand("reload");
        this.popLoadNew.setActionCommand("load");
        this.popSave.setActionCommand("store");
        this.popConvert.setActionCommand("convert");
        this.popView.setActionCommand("view");
        this.popAbout.setActionCommand("about");
        this.popUp.add(this.popReload);
        this.popUp.addSeparator();
        this.popUp.add(this.popLoadNew);
        this.popUp.add(this.popSave);
        this.popUp.addSeparator();
        this.popUp.add(this.popConvert);
        this.popUp.add(this.popView);
        this.popUp.addSeparator();
        this.popUp.add(this.popAbout);
        this.popUp.addActionListener(this);
    }

    private void labelComponents() {
        this.pictureBox.remove(this.popUp);
        this.initPopUp();
        this.pictureBox.add(this.popUp);
        this.loadButton.setText(this.l.pr("Open image..."));
        this.convertButton.setText(this.l.pr("Convert image!"));
        this.viewConvertedButton.setText(this.l.pr("View converted image."));
        this.storeButton.setText(this.l.pr("Store image..."));
        this.optionsButton.setText(this.l.pr("Options") + "...");
        this.aboutButton.setText(this.l.pr("About"));
        this.cancelButton.setText(this.l.pr("Cancel!"));
        this.specials.setText(this.l.pr("Blank"));
        this.colored.setText(this.l.pr("colored"));
        this.qualityLabel.setText(this.l.pr("Compression:"));
        this.scaleLabel.setText(this.l.pr("Scalefactor") + " (in %): ");
        this.labelTable.put(new Integer(0), new JLabel(this.l.pr("low")));
        this.labelTable.put(new Integer(50), new JLabel(this.l.pr("medium")));
        this.labelTable.put(new Integer(100), new JLabel(this.l.pr("high")));
        this.qualitySlider.setLabelTable(this.labelTable);
        this.exportFormatLabel.setText(this.l.pr("Preview as:"));
        this.opacityBox.setText(this.l.pr("Background color is transparent"));
        this.showColor.setBorder(BorderFactory.createTitledBorder(this.l.pr("Background color: ")));
        this.optionsBoxC.setBorder(BorderFactory.createTitledBorder(this.l.pr("Characters")));
        this.algoSelectionBox.setBorder(BorderFactory.createTitledBorder(this.l.pr("Algorithm and threshold:")));
        this.fontSelectionBox.setBorder(BorderFactory.createTitledBorder(this.l.pr("Font and font size: ")));
        this.userBox.setBorder(BorderFactory.createTitledBorder(this.l.pr("Operations")));
        this.userBox.revalidate();
        try {
            this.slider1.setToolTipText(this.l.pr("adjust brightness: ") + this.slider1.getValue());
            this.slider2.setToolTipText(this.l.pr("adjust contrast: ") + this.slider2.getValue());
            this.slider3.setToolTipText(this.l.pr("adjust saturation: ") + this.slider3.getValue());
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (!this.convertButton.isEnabled()) {
            this.pictureBox.setBorder(BorderFactory.createTitledBorder(this.l.pr("Images")));
        }
    }

    protected void fillRenderCombo() {
        this.renderCombo.removeAllItems();
        for (int i = 0; i < retypar.converters.size(); ++i) {
            this.renderCombo.addItem(retypar.converters.get(i));
        }
        this.renderCombo.invalidate();
    }

    protected void setPlaf() {
        this.plaf = retypar.plaf != null ? retypar.plaf : UIManager.getSystemLookAndFeelClassName();
        try {
            UIManager.setLookAndFeel(this.plaf);
            SwingUtilities.updateComponentTreeUI(this);
        }
        catch (Exception exception) {
            retypar.logError("Error setting look-and-feel.");
        }
    }

    public void stateChanged(ChangeEvent changeEvent) {
        this.fontCombo.setSelectedIndex(this.fontCombo.getSelectedIndex());
    }

    public void actionPerformed(ActionEvent actionEvent) {
        File file;
        if (actionEvent.getActionCommand().equals("load") && (file = this.chooseImage(null)) != null) {
            this.imgF = file;
            this.convertButton.setEnabled(true);
        }
        if (actionEvent.getActionCommand().equals("reload")) {
            this.chooseImage(this.imgF);
        }
        if (actionEvent.getActionCommand().equals("store") && !this.storeImage()) {
            JOptionPane.showMessageDialog(this, this.l.pr("Could not write to file!"), this.l.pr("I/O Error"), 0);
        }
        if (actionEvent.getActionCommand().equals("convert")) {
            this.triggerConversion();
        }
        if (actionEvent.getActionCommand().equals("options")) {
            this.displayOptions();
        }
        if (actionEvent.getActionCommand().equals("uppercase") | actionEvent.getActionCommand().equals("lowercase") | actionEvent.getActionCommand().equals("digits")) {
            this.checkOptions();
        }
        if (actionEvent.getActionCommand().equals("render")) {
            this.checkThresholdSpinner();
        }
        if (actionEvent.getActionCommand().equals("algoInfo")) {
            this.popUpAlgoInfo((Converter)this.renderCombo.getSelectedItem());
        }
        if (actionEvent.getActionCommand().equals("view")) {
            this.viewConverted();
        }
        if (actionEvent.getActionCommand().equals("cancel")) {
            this.cancelConversion();
        }
        if (actionEvent.getActionCommand().equals("newFont")) {
            this.fontExample1.setFont(new Font(this.fontCombo.getSelectedItem().toString(), retypar.fonts[this.fontCombo.getSelectedIndex()].getStyle(), (Integer)this.fontSizeSpinner.getValue()));
            this.fontExample2.setFont(new Font(this.fontCombo.getSelectedItem().toString(), retypar.fonts[this.fontCombo.getSelectedIndex()].getStyle(), (Integer)this.fontSizeSpinner.getValue()));
        }
        if (actionEvent.getActionCommand().equals("newExportFormat")) {
            if (this.exportFormatCombo.getSelectedItem().toString().equals("JPEG")) {
                this.qualitySlider.setEnabled(true);
            } else {
                this.qualitySlider.setEnabled(false);
            }
            if (!this.exportFormatCombo.getSelectedItem().toString().equals("GIF")) {
                this.opacityBox.setSelected(false);
                this.opacityBox.setEnabled(false);
            } else {
                this.opacityBox.setEnabled(true);
            }
            this.updateConverted();
        }
        if (actionEvent.getActionCommand().equals("opacity")) {
            // empty if block
        }
        if (actionEvent.getActionCommand().equals("german")) {
            this.switchLang("GER");
        }
        if (actionEvent.getActionCommand().equals("english")) {
            this.switchLang("ENG");
        }
        if (actionEvent.getActionCommand().equals("french")) {
            this.switchLang("FRA");
        }
        if (actionEvent.getActionCommand().equals("italian")) {
            this.switchLang("ITA");
        }
        if (actionEvent.getActionCommand().equals("spanish")) {
            this.switchLang("SPA");
        }
        if (actionEvent.getActionCommand().equals("about")) {
            this.displayAbout();
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (!mouseEvent.isPopupTrigger()) {
            return;
        }
        if (this.convertButton.isEnabled()) {
            this.popReload.setEnabled(true);
        } else {
            this.popReload.setEnabled(false);
        }
        if (this.convertButton.isEnabled()) {
            this.popConvert.setEnabled(true);
        } else {
            this.popConvert.setEnabled(false);
        }
        if (this.storeButton.isEnabled()) {
            this.popSave.setEnabled(true);
        } else {
            this.popSave.setEnabled(false);
        }
        if (this.viewConvertedButton.isEnabled()) {
            this.popView.setEnabled(true);
        } else {
            this.popView.setEnabled(false);
        }
        this.popUp.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    private void popUpAlgoInfo(Converter converter) {
        String string = converter.getWebsite().length() == 0 ? "" : ", " + converter.getWebsite();
        String string2 = "Algorithm " + ((Object)converter).toString() + "\nAuthor: " + converter.getAuthor() + string + "\n\n" + converter.getDescription() + "\n";
        String string3 = "Algorithm information";
        JOptionPane.showMessageDialog(this, string2, string3, 1);
    }

    private void popUpAlgoError(String string) {
        String string2 = "Conversion Error";
        String string3 = string;
        JOptionPane.showMessageDialog(this, string3, string2, 1);
    }

    public void errorLogged(String string) {
        String string2 = "Error!";
        JOptionPane.showMessageDialog(this, string, string2, 0);
    }

    public void messageLogged(String string) {
    }

    private File chooseImage(File file) {
        JFileChooser jFileChooser;
        try {
            jFileChooser = new JFileChooser();
        }
        catch (Exception exception) {
            return null;
        }
        jFileChooser.setDialogTitle(this.l.pr("Open image..."));
        FileFilter fileFilter = new FileFilter(){

            public boolean accept(File file) {
                String[] stringArray = new String[]{"jpg", "jpeg", "gif", "bmp", "png", "tga"};
                if (file.isDirectory()) {
                    return true;
                }
                for (int i = 0; i < 6; ++i) {
                    if (!file.getName().toLowerCase().endsWith("." + stringArray[i])) continue;
                    return true;
                }
                return false;
            }

            public String getDescription() {
                return MainFrame.this.l.pr("Images");
            }
        };
        jFileChooser.setFileFilter(fileFilter);
        jFileChooser.setMultiSelectionEnabled(true);
        try {
            this.currentDir = new File(retypar.lastPath);
        }
        catch (Exception exception) {
            this.currentDir = new File(System.getProperty("user.home"));
        }
        jFileChooser.setCurrentDirectory(this.currentDir);
        ImagePreviewPanel imagePreviewPanel = new ImagePreviewPanel();
        jFileChooser.setAccessory(imagePreviewPanel);
        jFileChooser.addPropertyChangeListener(imagePreviewPanel);
        if (file != null) {
            this.filename = file.getName();
        } else if (jFileChooser.showOpenDialog(this) == 0) {
            this.fileArray = jFileChooser.getSelectedFiles();
            file = this.fileArray[0];
            this.filename = file.getName();
            this.currentDir = file.getParentFile();
            retypar.lastPath = this.currentDir.getPath();
            retypar.writeINI();
        } else {
            this.paint(this.getGraphics());
            return null;
        }
        try {
            this.pictureBox.removeAll();
            this.converted = null;
            this.qualitySlider.setEnabled(false);
            this.qualitySlider.setValue(0);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.previewLabel.removeAll();
        this.addSlidersAndOriginal(file);
        this.walker.setValue(0);
        this.currentDir = file.getParentFile();
        this.pictureBox.setBorder(BorderFactory.createTitledBorder(this.filename + " (" + (int)this.wI + "x" + (int)this.hI + ", " + this.origFileSizeKB + "KB)"));
        this.storeButton.setEnabled(false);
        this.viewConvertedButton.setEnabled(false);
        jFileChooser.removeAll();
        System.gc();
        this.doMemoryCheck();
        return file;
    }

    private void doMemoryCheck() {
        if (!retypar.hasEnoughMemoryToConvert((int)(this.wI * this.hI))) {
            JOptionPane.showMessageDialog(this, this.l.pr("Most probably not enough memory for conversion!"), this.l.pr("Out-of-memory warning"), 2);
        }
    }

    private void addSlidersAndOriginal(final File file) {
        this.slider1 = new JSlider(1, -100, 100, 0);
        this.slider2 = new JSlider(0, -100, 100, 0);
        this.slider3 = new JSlider(1, -100, 100, 0);
        this.slider1.setToolTipText(this.l.pr("adjust brightness: ") + this.slider1.getValue());
        this.slider2.setToolTipText(this.l.pr("adjust contrast: ") + this.slider2.getValue());
        this.slider3.setToolTipText(this.l.pr("adjust saturation: ") + this.slider3.getValue());
        this.slider1.addMouseListener(new MouseAdapter(){

            public void mouseReleased(MouseEvent mouseEvent) {
                MainFrame.this.adjustBCS(file);
            }
        });
        this.slider2.addMouseListener(new MouseAdapter(){

            public void mouseReleased(MouseEvent mouseEvent) {
                MainFrame.this.adjustBCS(file);
            }
        });
        this.slider3.addMouseListener(new MouseAdapter(){

            public void mouseReleased(MouseEvent mouseEvent) {
                MainFrame.this.adjustBCS(file);
            }
        });
        this.original = new JScrollPane(new JLabel(new ImageIcon(this.getScaledFromDisk(file))));
        this.updateOriginal();
    }

    private void updateOriginal() {
        try {
            this.pictureBox.remove(0);
        }
        catch (Exception exception) {
            // empty catch block
        }
        Box box = Box.createHorizontalBox();
        Box box2 = Box.createVerticalBox();
        this.original.setBorder(BorderFactory.createTitledBorder(""));
        box2.add(this.original);
        box2.add(this.slider2);
        box.add(this.slider1);
        box.add(box2);
        box.add(this.slider3);
        this.pictureBox.add((Component)box, 0);
        this.pictureBox.invalidate();
        this.pictureBox.validate();
        this.original.addMouseListener(this);
    }

    private void adjustBCS(File file) {
        this.setCursor(Cursor.getPredefinedCursor(3));
        Image image = this.getScaledFromDisk(file);
        if (this.slider1.getValue() != 0) {
            image = retypar.adjustBrightness(image, this.slider1.getValue());
        }
        if (this.slider2.getValue() != 0) {
            image = retypar.adjustContrast(image, this.slider2.getValue());
        }
        if (this.slider3.getValue() != 0) {
            image = retypar.adjustSaturation(image, this.slider3.getValue());
        }
        this.original = new JScrollPane(new JLabel(new ImageIcon(image)));
        this.slider1.setToolTipText(this.l.pr("adjust brightness: ") + this.slider1.getValue());
        this.slider2.setToolTipText(this.l.pr("adjust contrast: ") + this.slider2.getValue());
        this.slider3.setToolTipText(this.l.pr("adjust color: ") + this.slider3.getValue());
        this.updateOriginal();
        this.setCursor(Cursor.getPredefinedCursor(0));
    }

    private boolean storeImage() {
        boolean bl = false;
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setCurrentDirectory(this.currentDir);
        jFileChooser.setMultiSelectionEnabled(false);
        jFileChooser.setAcceptAllFileFilterUsed(false);
        jFileChooser.setApproveButtonText(this.l.pr("Save"));
        jFileChooser.setDialogTitle(this.l.pr("Save image..."));
        FileFilter fileFilter = new FileFilter(){

            public boolean accept(File file) {
                String[] stringArray = new String[]{"jpg", "jpeg"};
                if (file.isDirectory()) {
                    return true;
                }
                for (int i = 0; i < stringArray.length; ++i) {
                    if (!file.getName().toLowerCase().endsWith("." + stringArray[i])) continue;
                    return true;
                }
                return false;
            }

            public String getDescription() {
                return MainFrame.this.l.pr("JPEG Images");
            }
        };
        FileFilter fileFilter2 = new FileFilter(){

            public boolean accept(File file) {
                String[] stringArray = new String[]{"gif"};
                if (file.isDirectory()) {
                    return true;
                }
                for (int i = 0; i < stringArray.length; ++i) {
                    if (!file.getName().toLowerCase().endsWith("." + stringArray[i])) continue;
                    return true;
                }
                return false;
            }

            public String getDescription() {
                return MainFrame.this.l.pr("GIF Images");
            }
        };
        FileFilter fileFilter3 = new FileFilter(){

            public boolean accept(File file) {
                String[] stringArray = new String[]{"txt"};
                if (file.isDirectory()) {
                    return true;
                }
                for (int i = 0; i < stringArray.length; ++i) {
                    if (!file.getName().toLowerCase().endsWith("." + stringArray[i])) continue;
                    return true;
                }
                return false;
            }

            public String getDescription() {
                return MainFrame.this.l.pr("Textfiles");
            }
        };
        FileFilter fileFilter4 = new FileFilter(){

            public boolean accept(File file) {
                String[] stringArray = new String[]{"html", "htm"};
                if (file.isDirectory()) {
                    return true;
                }
                for (int i = 0; i < stringArray.length; ++i) {
                    if (!file.getName().toLowerCase().endsWith("." + stringArray[i])) continue;
                    return true;
                }
                return false;
            }

            public String getDescription() {
                return MainFrame.this.l.pr("HTML documents");
            }
        };
        FileFilter fileFilter5 = new FileFilter(){

            public boolean accept(File file) {
                String[] stringArray = new String[]{"ans"};
                if (file.isDirectory()) {
                    return true;
                }
                for (int i = 0; i < stringArray.length; ++i) {
                    if (!file.getName().toLowerCase().endsWith("." + stringArray[i])) continue;
                    return true;
                }
                return false;
            }

            public String getDescription() {
                return MainFrame.this.l.pr("ANSI files");
            }
        };
        FileFilter fileFilter6 = new FileFilter(){

            public boolean accept(File file) {
                String[] stringArray = new String[]{"txv"};
                if (file.isDirectory()) {
                    return true;
                }
                for (int i = 0; i < stringArray.length; ++i) {
                    if (!file.getName().toLowerCase().endsWith("." + stringArray[i])) continue;
                    return true;
                }
                return false;
            }

            public String getDescription() {
                return MainFrame.this.l.pr("Textvideo");
            }
        };
        if (this.converter.returnsASCII()) {
            jFileChooser.setFileFilter(fileFilter3);
            jFileChooser.setFileFilter(fileFilter4);
            jFileChooser.setFileFilter(fileFilter5);
        }
        if (this.fileArray.length > 1) {
            jFileChooser.setFileFilter(fileFilter6);
        }
        jFileChooser.setFileFilter(fileFilter);
        jFileChooser.setFileFilter(fileFilter2);
        if (jFileChooser.showSaveDialog(this) != 0) {
            return true;
        }
        if (!this.permForOverwrite(jFileChooser.getSelectedFile())) {
            return true;
        }
        if (jFileChooser.getFileFilter() == fileFilter) {
            bl = retypar.storeImage(jFileChooser.getSelectedFile(), this.convertedImage, this.qualitySlider.getValue(), 2, this.colored.isSelected(), this.showColor.getComponent(0).getBackground(), this.converter.getASCII(), this.converter.getColors(), false);
        }
        if (jFileChooser.getFileFilter() == fileFilter2) {
            bl = retypar.storeImage(jFileChooser.getSelectedFile(), this.convertedImage, this.qualitySlider.getValue(), 5, this.colored.isSelected(), this.showColor.getComponent(0).getBackground(), this.converter.getASCII(), this.converter.getColors(), this.opacityBox.isSelected());
        }
        if (jFileChooser.getFileFilter() == fileFilter3) {
            bl = retypar.storeImage(jFileChooser.getSelectedFile(), this.convertedImage, this.qualitySlider.getValue(), 0, this.colored.isSelected(), this.showColor.getComponent(0).getBackground(), this.converter.getASCII(), this.converter.getColors(), false);
        }
        if (jFileChooser.getFileFilter() == fileFilter4) {
            bl = retypar.storeImage(jFileChooser.getSelectedFile(), this.convertedImage, this.qualitySlider.getValue(), 1, this.colored.isSelected(), this.showColor.getComponent(0).getBackground(), this.converter.getASCII(), this.converter.getColors(), false);
        }
        if (jFileChooser.getFileFilter() == fileFilter5) {
            bl = retypar.storeImage(jFileChooser.getSelectedFile(), this.convertedImage, this.qualitySlider.getValue(), 4, this.colored.isSelected(), this.showColor.getComponent(0).getBackground(), this.converter.getASCII(), this.converter.getColors(), false);
        }
        if (jFileChooser.getFileFilter() == fileFilter6) {
            this.setButtonState(false);
            this.setCursor(Cursor.getPredefinedCursor(3));
            this.cancelButton.setEnabled(true);
            this.paint(this.getGraphics());
            int n = 0;
            while (n < this.fileArray.length) {
                if (!this.convertImage(this.fileArray[n])) {
                    return false;
                }
                bl = retypar.storeImage(jFileChooser.getSelectedFile(), this.convertedImage, this.qualitySlider.getValue(), 3, this.colored.isSelected(), this.showColor.getBackground(), this.converter.getASCII(), this.converter.getColors(), false);
                this.walker.setValue(100 / this.fileArray.length * ++n);
                this.walker.updateUI();
            }
            this.duration.setText("--:--:---");
            this.walker.setValue(100);
            this.setButtonState(true);
            this.setCursor(Cursor.getPredefinedCursor(0));
            this.cancelButton.setEnabled(false);
            this.validate();
        }
        this.convertedImage.flush();
        return bl;
    }

    private void triggerConversion() {
        this.setButtonState(false);
        this.setCursor(Cursor.getPredefinedCursor(3));
        this.cancelButton.setEnabled(true);
        this.paint(this.getGraphics());
        this.converter = (Converter)this.renderCombo.getSelectedItem();
        this.walker.setEnabled(true);
        if (this.converter.monitorsProgess()) {
            this.walker.walk();
        } else {
            this.walker.setEnabled(false);
        }
        try {
            this.pictureBox.remove(this.converted);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (!this.convertImage(this.imgF)) {
            return;
        }
        this.imConvertedImage = this.getScaled(this.reEncodeConverted(this.convertedImage, this.qualitySlider.getValue()));
        this.converted = new JScrollPane(new JLabel(new ImageIcon(this.imConvertedImage)));
        this.converted.setBorder(BorderFactory.createTitledBorder(this.convertedImage.getWidth() + "x" + this.convertedImage.getHeight() + ", " + this.convFileSizeKB + "kB"));
        this.converted.addMouseListener(this);
        this.pictureBox.add(this.converted);
        this.setButtonState(true);
        this.setCursor(Cursor.getPredefinedCursor(0));
        this.cancelButton.setEnabled(false);
        this.validate();
        this.duration.setText(retypar.getDuration());
    }

    private boolean convertImage(File file) {
        int n = (Integer)this.thresholdSpinner.getValue();
        this.converter = (Converter)this.renderCombo.getSelectedItem();
        retypar.setFont((String)this.fontCombo.getSelectedItem());
        retypar.setFontSize((Integer)this.fontSizeSpinner.getValue());
        this.convertedImage = retypar.convertImage(file, this.uppercase.isSelected(), this.lowercase.isSelected(), this.digits.isSelected(), this.specials.isSelected(), this.colored.isSelected(), this.showColor.getComponent(0).getBackground(), (Integer)this.scaleSpinner.getValue(), this.slider1.getValue(), this.slider2.getValue(), this.slider3.getValue(), this.converter, n);
        retypar.stopTimer();
        if (this.converter.getErrors() != null) {
            this.popUpAlgoError(this.converter.getErrors());
            return false;
        }
        return true;
    }

    private void checkOptions() {
        if (this.uppercase.isSelected() | this.lowercase.isSelected() | this.digits.isSelected() && this.imgF != null) {
            this.convertButton.setEnabled(true);
        } else {
            this.convertButton.setEnabled(false);
        }
    }

    private void displayOptions() {
        OptionsFrame optionsFrame = new OptionsFrame(this);
    }

    private void displayAbout() {
        String string = "";
        String string2 = "AnimatedGifEncoder 1.03 by Kevin Weiner, FM Software";
        string2 = string2 + "<br>ImagePreviewPanel by Michael Urban, javalobby.org";
        for (int i = 0; i < retypar.converters.size(); ++i) {
            string = string + "<br><b>" + ((Object)((Converter)retypar.converters.get(i))).toString() + "</b> (" + ((Converter)retypar.converters.get(i)).getShortName() + ") by " + ((Converter)retypar.converters.get(i)).getAuthor() + " (<a href=\"" + ((Converter)retypar.converters.get(i)).getWebsite() + "\">" + ((Converter)retypar.converters.get(i)).getWebsite() + "</a>)";
        }
        String string3 = "<HTML><table><tr><td><i>Author:</i></td><td>Jens Heuser</td></tr><tr><td><i>Homepage:</i></td><td><a href=\"http://www.retypar.de.vu\">http://www.retypar.de.vu</a></td></tr><tr><td><i>Email:</i></td><td><a href=\"mailto:retypar.image2ascii@gmail.com\">retypar.image2ascii@gmail.com</a></td></tr><tr><td><i>Version:</i></td><td>0.9.4</td></tr></table><br><br><i>Installed algorithms:</i>" + string + "<br><br><i>Third party software:</i><br>" + string2 + "</HTML>";
        String string4 = this.l.pr("About") + " retypar";
        JOptionPane.showMessageDialog(this, string3, string4, 1);
    }

    private void checkThresholdSpinner() {
        if (this.renderCombo.getItemCount() == 0) {
            return;
        }
        Converter converter = (Converter)this.renderCombo.getSelectedItem();
        if (converter.usesThreshold()) {
            int n = converter.getInitThreshold();
            int n2 = converter.getMinThreshold();
            int n3 = converter.getMaxThreshold();
            int n4 = converter.getThresholdStep();
            this.thresholdSpinner.setModel(new SpinnerNumberModel(n, n2, n3, n4));
            this.thresholdSpinner.setEditor(new JSpinner.NumberEditor(this.thresholdSpinner));
            this.thresholdSpinner.setEnabled(true);
        } else if (!converter.usesThreshold()) {
            this.thresholdSpinner.setEnabled(false);
        }
    }

    private void checkOutputFormats() {
        if (this.renderCombo.getItemCount() == 0) {
            return;
        }
        Converter converter = (Converter)this.renderCombo.getSelectedItem();
        if (!converter.returnsASCII()) {
            if (this.exportFormatCombo.getSelectedIndex() > 1) {
                this.exportFormatCombo.setSelectedIndex(0);
            }
            this.removeTextExport();
        } else {
            this.addAllExport();
        }
    }

    private void removeTextExport() {
        try {
            if (this.exportFormatCombo.getItemCount() < 3) {
                return;
            }
            ((DefaultComboBoxModel)this.exportFormatCombo.getModel()).removeElement("Text");
            ((DefaultComboBoxModel)this.exportFormatCombo.getModel()).removeElement("HTML");
            ((DefaultComboBoxModel)this.exportFormatCombo.getModel()).removeElement("ANSI");
            ((DefaultComboBoxModel)this.exportFormatCombo.getModel()).removeElement("TVID");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void addAllExport() {
        try {
            if (this.exportFormatCombo.getItemCount() > 2) {
                return;
            }
            this.exportFormatCombo.setModel(new DefaultComboBoxModel<String>(retypar.availableGraphicalExportFormats));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private Image getScaled(BufferedImage bufferedImage) {
        float f = this.pictureBox.getWidth();
        float f2 = (float)(this.pictureBox.getHeight() / 2) * 0.9f;
        this.wI = bufferedImage.getWidth();
        this.hI = bufferedImage.getHeight();
        if (this.wI < f && this.hI < f2) {
            return bufferedImage;
        }
        float f3 = f / this.wI;
        if (this.hI * f3 <= f2) {
            return bufferedImage.getScaledInstance((int)(f3 * this.wI), -1, 4);
        }
        f3 = f2 / this.hI;
        return bufferedImage.getScaledInstance(-1, (int)(f3 * this.hI), 4);
    }

    private Image getScaledFromDisk(File file) {
        try {
            this.origFileSizeKB = file.length() / 1024L;
            BufferedImage bufferedImage = ImageIO.read(file);
            return this.getScaled(bufferedImage);
        }
        catch (Exception exception) {
            return new BufferedImage(100, 100, 12);
        }
    }

    private void viewConverted() {
        JFrame jFrame = new JFrame(this.l.pr("ASCII version, " + this.convFileSizeKB + "KB"));
        JScrollPane jScrollPane = new JScrollPane(new JLabel(new ImageIcon(this.reEncodeConverted(this.convertedImage, this.qualitySlider.getValue()))));
        jFrame.getContentPane().add(jScrollPane);
        jFrame.setBounds(this.getWidth() / 2, this.getHeight() / 2, this.getWidth() / 2, this.getHeight() / 2);
        jFrame.setVisible(true);
        jFrame.setDefaultCloseOperation(2);
        jFrame.setExtendedState(6);
    }

    private void setButtonState(boolean bl) {
        this.loadButton.setEnabled(bl);
        this.storeButton.setEnabled(bl);
        this.convertButton.setEnabled(bl);
        this.viewConvertedButton.setEnabled(bl);
        this.optionsBox1.setEnabled(bl);
        this.qualitySlider.setEnabled(bl);
        this.exportFormatCombo.setEnabled(bl);
        this.paint(this.getGraphics());
    }

    public boolean permForOverwrite(File file) {
        if (!file.exists()) {
            return true;
        }
        return JOptionPane.showConfirmDialog(this, this.l.pr("File already exists. Overwrite?"), this.l.pr("Warning!"), 0) == 0;
    }

    private void cancelConversion() {
        System.out.println("cancelling at " + this.walker.getValue() + "%");
        this.converter.stop();
    }

    private void doPossibleUpdate() {
        if (!retypar.checkUpd) {
            return;
        }
        if (!Update.newVersionAvailable("retypar", "0.9.4", "http://retypar.sourceforge.net/download/")) {
            return;
        }
        if (JOptionPane.showConfirmDialog(this, this.l.pr("There is a newer version available. Install?"), this.l.pr("Internet update"), 0) == 0) {
            Update.installNew();
        }
        if (Update.error) {
            JOptionPane.showMessageDialog(this, Update.getErrors(), this.l.pr("Error while updating!"), 0);
        }
    }

    private void switchLang(String string) {
        this.l.setLang(string);
        retypar.lang = string;
        this.labelComponents();
        retypar.plaf = UIManager.getSystemLookAndFeelClassName();
        if (!this.l.error) {
            retypar.writeINI();
        } else {
            JOptionPane.showMessageDialog(this, this.l.pr(this.l.getError()), this.l.pr("Error in multi language module!"), 2);
        }
        this.l.clearErrors();
    }

    private void checkMaxRes() {
        if (Toolkit.getDefaultToolkit().getScreenSize().height < 768) {
            JOptionPane.showMessageDialog(this, "Your screen resolution is too low. Please use the command line interface. \nSee 'java -jar retypar_0.9.4 -?'", "Fatal error:", 0);
            System.exit(1);
        }
    }

    private void updateConverted() {
        this.pictureBox.remove(this.converted);
        this.imConvertedImage = this.reEncodeConverted(this.convertedImage, this.qualitySlider.getValue());
        this.converted = new JScrollPane(new JLabel(new ImageIcon(this.getScaled((BufferedImage)this.imConvertedImage))));
        this.converted.setBorder(BorderFactory.createTitledBorder(this.convertedImage.getWidth() + "x" + this.convertedImage.getHeight() + ", " + this.convFileSizeKB + "kB"));
        this.pictureBox.add(this.converted);
        this.pictureBox.validate();
    }

    private BufferedImage reEncodeConverted(BufferedImage bufferedImage, int n) {
        if (this.exportFormatCombo.getSelectedItem().toString().equals("JPEG")) {
            return this.reEncodeConvertedAsJPEG(bufferedImage, n);
        }
        if (this.exportFormatCombo.getSelectedItem().toString().equals("GIF")) {
            return this.reEncodeConvertedAsGIF(bufferedImage, n);
        }
        return null;
    }

    private BufferedImage reEncodeConvertedAsASCII(BufferedImage bufferedImage, int n) {
        bufferedImage = this.reEncodeConvertedAsJPEG(bufferedImage, 0);
        switch (n) {
            case 0: {
                this.convFileSizeKB = this.converter.getASCII().length * this.converter.getASCII()[0].length() / 1024;
                this.converted.setBorder(BorderFactory.createTitledBorder(this.converter.getASCII()[0].length() + "x" + this.converter.getASCII().length + ", " + this.converter.getASCII().length * this.converter.getASCII()[0].length() + "B"));
                break;
            }
            case 1: {
                this.convFileSizeKB = 0L;
                this.converted.setBorder(BorderFactory.createTitledBorder(this.converter.getASCII()[0].length() + "x" + this.converter.getASCII().length + ", ??? kB"));
                break;
            }
            case 4: {
                this.convFileSizeKB = 0L;
                this.converted.setBorder(BorderFactory.createTitledBorder(this.converter.getASCII()[0].length() + "x" + this.converter.getASCII().length + ", ??? kB"));
            }
        }
        return bufferedImage;
    }

    private BufferedImage reEncodeConvertedAsJPEG(BufferedImage bufferedImage, int n) {
        BufferedImage bufferedImage2 = new BufferedImage((int)this.wI, (int)this.hI, 1);
        this.setCursor(Cursor.getPredefinedCursor(3));
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            retypar.streamJPEG(byteArrayOutputStream, bufferedImage, n);
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
            JPEGImageDecoder jPEGImageDecoder = JPEGCodec.createJPEGDecoder((InputStream)byteArrayInputStream);
            bufferedImage2 = jPEGImageDecoder.decodeAsBufferedImage();
            this.convFileSizeKB = byteArrayOutputStream.size() / 1024;
        }
        catch (Exception exception) {
            retypar.logError("JPEG error: " + exception.toString());
        }
        bufferedImage.flush();
        bufferedImage2.flush();
        this.setCursor(Cursor.getPredefinedCursor(0));
        return bufferedImage2;
    }

    private BufferedImage reEncodeConvertedAsGIF(BufferedImage bufferedImage, int n) {
        BufferedImage bufferedImage2 = new BufferedImage((int)this.wI, (int)this.hI, 1);
        this.setCursor(Cursor.getPredefinedCursor(3));
        Color color = this.opacityBox.isSelected() ? this.showColor.getBackground() : null;
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            retypar.streamGIF(byteArrayOutputStream, bufferedImage, n, color);
            GifDecoder gifDecoder = new GifDecoder();
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
            gifDecoder.read(byteArrayInputStream);
            bufferedImage2 = gifDecoder.getImage();
            this.convFileSizeKB = byteArrayOutputStream.size() / 1024;
        }
        catch (Exception exception) {
            retypar.logError("GIF error: " + exception.toString());
        }
        bufferedImage.flush();
        bufferedImage2.flush();
        this.setCursor(Cursor.getPredefinedCursor(0));
        return bufferedImage2;
    }
}

