/* ProfiGleisEditor.java - demonstrate a custom editor based on jfig
 *
 * (C) 1998-2005 fnh
 *
 * 08.08.05 - refactor to jfig.demo package
 * 07.08.05 - several additions
 * 05.08.05 - new class
 */

package jfig.demo;

// import java.awt.*;
import java.awt.Container;
import java.awt.GridLayout;
import java.awt.event.*;
import javax.swing.*;

import jfig.gui.*;
import jfig.canvas.*;
import jfig.commands.*;
import jfig.objects.*;
import jfig.utils.MouseMapper;


/**
 * example subclass of JModularEditor to demonstrate user extensions.
 */
public class ProfiGleisEditor extends JModularEditor {

  private JPanel customButtonPanel;
  private ProfiGleisFactory factory;


  public ProfiGleisEditor() {
    super();
    factory = new ProfiGleisFactory();

    buildUserMenu();
    hideLayerManager();
    buildCustomButtonPanel();
    ((JFrame)getFrame()).getContentPane().add( "East", customButtonPanel );
    getFrame().setTitle( "ProfiGleis Editor" );
    getFrame().validate();

    getObjectCanvas().getComponent().
      addMouseListener( new RequestFocusOnMouseEnterAdapter() );

    doSetUnitsMillimeter( null );
  }


  public void buildUserMenu() {
    JMenu     userMenu    = new JMenu( "User" );
    JMenuItem bulletMI    = new JMenuItem( "create bullet" );
    JMenuItem zoomValueMI = new JMenuItem( "enter zoom value..." );

    userMenu.add( bulletMI );
    userMenu.add( zoomValueMI );
    ((JFrame) frame).getJMenuBar().add( userMenu );
  
    bulletMI.addActionListener( new ActionListener() {
      public void actionPerformed( ActionEvent evt ) {
        if (!checkCanCancel()) return; // editor is busy now
        command = new jfig.commands.CreateBulletCommand(  
                        ProfiGleisEditor.this, getObjectCanvas() );
      }
    });   

    zoomValueMI.addActionListener( new ActionListener() {
      public void actionPerformed( ActionEvent evt ) {
        String raw = JOptionPane.showInputDialog( 
                       getFrame(),
                       "Enter zoom factor (0.1 .. 50):",
                       "" + getObjectCanvas().getTrafo().getZoomFactor() );
        if (raw == null) return; // canceled 
        try {
          double zoom = Double.parseDouble( raw );
          getObjectCanvas().getTrafo().set_zoom( zoom );
          getObjectCanvas().doFullRedraw();
          setZoomMessage(); 
        }
        catch( Exception e ) { /* should be handled here */ }
      }
    });
  }


  private void hideLayerManager() {
    Container c = ((JFrame) getFrame()).getContentPane();

    c.remove( layerManager.getPanel() );
  }


  private JButton cmb( String label, boolean enabled ) {
    JButton button = new JButton( label );
    button.setEnabled( enabled );
    button.addActionListener( this ); 
    addCallback( label, "doCreate"+label );
    customButtonPanel.add( button );
    return button;
  }


  private JLabel cms( String s ) {
    JLabel label = new JLabel( s );
    customButtonPanel.add( label );
    return label;
  }


  private void buildCustomButtonPanel() {
    customButtonPanel = new JPanel();
    customButtonPanel.setLayout( 
      new GridLayout( 19, 2 ));
      // new BoxLayout( customButtonPanel, BoxLayout.Y_AXIS ));

    // cms( "tracks:" ); 
    cmb( "6101", true );
    cmb( "6102", true );
    cmb( "6103", true );
    // cmb( "6106", false );
    cmb( "6107", true );

    cmb( "6110", true );
    cmb( "6111", true );
    cmb( "6114", true );
    cmb( "6116", true );

    // cms( "curves:" );
    cms( "" ); cms( "" );

    cmb( "6120", true );
    cmb( "6122", true );
    cmb( "6125", true );
    cmb( "6127", true );
    cmb( "6131", true );
    cmb( "6133", true );
    cmb( "6138", true );
    cmb( "6139", true );

    // cms( "points:" ); 
    cms( "" ); cms( "" );
    cmb( "6170", true );
    cmb( "6171", true );
    cmb( "6157", true );
    cms( "" );
    cmb( "6174", true );
    cmb( "6175", true );
    cmb( "6178", true );
    cmb( "6179", true );

    // cms( "crossings:" );
    cms( "" ); cms( "" );
    cmb( "6160", true );
    cmb( "6162", true );
    cmb( "6163", true );
    cms( "" ); 

    // cms( "turntable:" );
    cms( "" ); cms( "" );
    cmb( "6150", true );
    cmb( "6152", true );

    // getFrame().pack(); 
  }

  public void doCreate6101(Object o) { create( factory.make6101() ); }
  public void doCreate6102(Object o) { create( factory.make6102() ); }
  public void doCreate6103(Object o) { create( factory.make6103() ); }
  public void doCreate6106(Object o) { create( factory.make6106() ); }
  public void doCreate6107(Object o) { create( factory.make6107() ); }
  public void doCreate6110(Object o) { create( factory.make6110() ); }
  public void doCreate6111(Object o) { create( factory.make6111() ); }
  public void doCreate6114(Object o) { create( factory.make6114() ); }
  public void doCreate6116(Object o) { create( factory.make6116() ); }

  public void doCreate6120(Object o) { create( factory.make6120() ); }
  public void doCreate6122(Object o) { create( factory.make6122() ); }
  public void doCreate6125(Object o) { create( factory.make6125() ); }
  public void doCreate6127(Object o) { create( factory.make6127() ); }
  public void doCreate6131(Object o) { create( factory.make6131() ); }
  public void doCreate6133(Object o) { create( factory.make6133() ); }
  public void doCreate6138(Object o) { create( factory.make6138() ); }
  public void doCreate6139(Object o) { create( factory.make6139() ); }

  public void doCreate6170(Object o) { create( factory.make6170() ); }
  public void doCreate6171(Object o) { create( factory.make6171() ); }
  public void doCreate6157(Object o) { create( factory.make6157() ); }
  public void doCreate6174(Object o) { create( factory.make6174() ); }
  public void doCreate6175(Object o) { create( factory.make6175() ); }
  public void doCreate6178(Object o) { create( factory.make6178() ); }
  public void doCreate6179(Object o) { create( factory.make6179() ); }

  public void doCreate6160(Object o) { create( factory.make6160() ); }
  public void doCreate6162(Object o) { create( factory.make6162() ); }
  public void doCreate6163(Object o) { create( factory.make6163() ); }

  public void doCreate6150(Object o) { create( factory.make6150() ); }
  public void doCreate6152(Object o) { create( factory.make6152() ); }


  public void create( FigCompound tmp ) {
    CreateTrackCommand ctc = new CreateTrackCommand( this, objectCanvas );
    ctc.setTrack( tmp );
    this.command = ctc;
  }


  public void keyPressed( KeyEvent evt ) {
    // msg( "-#- ProfiGleisEditor.keyPressed: " + evt );
    char key = evt.getKeyChar();
    int code = evt.getKeyCode();

    if ((key == 27) || (code == KeyEvent.VK_ESCAPE)) { // ESCAPE!
      doCancel( null );
      return;
    }
    else if (command instanceof CreateTrackCommand) {
      CreateTrackCommand ctc = (CreateTrackCommand) command;
      ctc.keyPressed( evt );
    }
    else {
      super.keyPressed( evt );
    }
  }


  public void keyTyped( KeyEvent evt ) {
   dbg( "-I- JModularEditor: keyTyped()..." + evt );
    char key = evt.getKeyChar();
    int code = evt.getKeyCode();

   if ((key == 27) || (code == KeyEvent.VK_ESCAPE)) { // ESCAPE!
      dbg( "-W- got an ESCAPE key..." );
      doCancel( null );
      return;
    }
    else if (command instanceof CreateTrackCommand) {
      ; // ignore
    }
    else if (command instanceof CreateTextCommand) {
      //message( "-#- Editor.keyTyped: calling CTC..." );
      ((CreateTextCommand) command).keyTyped( evt );
    }
    else {
       keyHandler.keyPressed( evt );
    }
  }


  /**
   * inner class to request the keyboard focus on the objectCanvas 
   * on mouseEntered events. 
   * We need this because Swing transfers the focus to the track JButtons,
   * and we need the bindkeys to work on the object canvas at all times.
   */
  public class RequestFocusOnMouseEnterAdapter extends MouseAdapter {
    public void mouseEntered( MouseEvent evt ) {
      dbg( "-#- RFOMEA.mouseEntered..." );
      getObjectCanvas().getComponent().requestFocus();
    }
  }



  public static void main( String argv[] ) {
    jfig.utils.ExceptionTracer.setEnabled( false ); // or true
    ProfiGleisEditor editor = new ProfiGleisEditor();

    String fname = (argv.length > 0) ? argv[0] : null;
    if (fname != null) editor.doParseFile( fname, false );
  }
}
