/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jaxodraw;

import net.sf.jaxodraw.gui.launch.JaxoLauncher;
import net.sf.jaxodraw.gui.launch.JaxoShutDown;
import net.sf.jaxodraw.io.JaxoCLIConvert;
import net.sf.jaxodraw.util.JaxoDictionary;
import net.sf.jaxodraw.util.JaxoInfo;
import net.sf.jaxodraw.util.JaxoLog;
import net.sf.jaxodraw.util.JaxoPrefs;

public final class JaxoDraw {
    private static final JaxoDictionary LANGUAGE;

    private JaxoDraw() {
    }

    public static void main(String[] args) {
        String[] fileNames = JaxoDraw.getCommandLineArgs(args);
        JaxoLauncher launcher = new JaxoLauncher();
        launcher.setFilesToOpen(fileNames);
        launcher.setShutDownHook(new JaxoShutDown(){

            public void shutdown(int status) {
                JaxoDraw.shutdown(status);
            }
        });
        launcher.launch(JaxoPrefs.getBooleanPref("prefSHOWSPLASHWINDOW"));
    }

    private static String[] getCommandLineArgs(String[] args) {
        boolean shutdown = false;
        boolean convert = false;
        int files = 0;
        String[] filesToOpen = new String[args.length];
        for (int i = 0; i < args.length; ++i) {
            if (args[i].startsWith("--")) {
                if (args[i].equals("--version")) {
                    JaxoLog.info(JaxoInfo.VERSION);
                } else if (args[i].equals("--info")) {
                    JaxoLog.info(JaxoInfo.info());
                } else if (args[i].equals("--help")) {
                    JaxoLog.info(JaxoInfo.help());
                } else if (args[i].equals("--convert")) {
                    convert = true;
                } else {
                    JaxoLog.warn(LANGUAGE.message("unknownOption%0", args[i]));
                }
                shutdown = true;
                continue;
            }
            if (args[i].endsWith(".xml") || args[i].endsWith(".tex")) {
                filesToOpen[files] = args[i];
                ++files;
                continue;
            }
            if (args[i].equals("-verbose") || args[i].equals("-debug")) {
                JaxoLog.setLevel(JaxoLog.DEBUG);
                continue;
            }
            if (args[i].equals("-quiet")) {
                JaxoLog.setLevel(JaxoLog.WARN);
                continue;
            }
            if (args[i].equals("-nosplash")) {
                JaxoPrefs.setBooleanPref("prefSHOWSPLASHWINDOW", false);
                continue;
            }
            JaxoLog.warn(LANGUAGE.message("unknownOption%0", args[i]));
        }
        if (shutdown && !convert) {
            JaxoDraw.shutdown(0);
        }
        String[] returnFiles = new String[files];
        System.arraycopy(filesToOpen, 0, returnFiles, 0, files);
        if (convert) {
            JaxoCLIConvert.convert(returnFiles);
            JaxoDraw.shutdown(0);
        }
        return returnFiles;
    }

    private static void shutdown(int status) {
        if (status != 0) {
            JaxoLog.warn("JaxoDraw terminated with exit status: " + status);
        }
        System.exit(status);
    }

    static {
        JaxoPrefs.initSessionPrefs();
        LANGUAGE = new JaxoDictionary(JaxoDraw.class);
    }
}

