/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jaxodraw.graph;

import java.awt.Rectangle;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.sf.jaxodraw.object.JaxoList;
import net.sf.jaxodraw.object.JaxoObject;
import net.sf.jaxodraw.object.JaxoObjectList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JaxoSaveGraph
implements Serializable {
    public static final int LIST_INIT_SIZE = 5;
    private static final long serialVersionUID = 2L;
    private final JaxoList<JaxoObject> objectList;
    private String description;
    private final List<String> packageList;
    private String jaxoDrawVersion;

    public JaxoSaveGraph() {
        this(new JaxoObjectList<JaxoObject>(5), "", new ArrayList<String>(5));
    }

    public JaxoSaveGraph(JaxoList<JaxoObject> list) {
        this(list, "", new ArrayList<String>(5));
    }

    public JaxoSaveGraph(JaxoList<JaxoObject> list, String describe) {
        this(list, describe, new ArrayList<String>(5));
    }

    public JaxoSaveGraph(JaxoList<JaxoObject> list, String describe, List<String> packages) {
        this.objectList = new JaxoObjectList<JaxoObject>(list);
        this.description = describe;
        this.packageList = new ArrayList<String>(packages);
        this.addDefaultPackages();
    }

    public final JaxoList<JaxoObject> getObjectList() {
        return this.objectList;
    }

    public final void setObjectList(JaxoList<JaxoObject> list) {
        this.objectList.clear();
        this.objectList.addAll(list);
    }

    public final List<String> getPackageList() {
        return this.packageList;
    }

    public final void setPackageList(List<String> list) {
        this.packageList.clear();
        this.packageList.addAll(list);
        this.addDefaultPackages();
    }

    public final void setDescription(String describe) {
        this.description = describe;
    }

    public final String getDescription() {
        return this.description;
    }

    public final String getJaxoDrawVersion() {
        return this.jaxoDrawVersion;
    }

    public final void setJaxoDrawVersion(String version) {
        this.jaxoDrawVersion = version;
    }

    public final JaxoObject listElementAt(int i) {
        if (i >= 0 && i < this.listSize()) {
            return (JaxoObject)this.objectList.get(i);
        }
        return null;
    }

    public final int listSize() {
        return this.objectList.size();
    }

    public final boolean foreground(JaxoObject object) {
        return this.objectList.toEnd(object);
    }

    public final boolean background(JaxoObject object) {
        return this.objectList.toFront(object);
    }

    public final void move(int index, int newIndex) {
        this.objectList.move(index, newIndex);
    }

    public final boolean delete(JaxoObject object) {
        return this.objectList.remove(object);
    }

    public final boolean deleteMarkedObjects() {
        return this.objectList.removeMarkedObjects();
    }

    public final boolean deleteAll(Collection<JaxoObject> objects) {
        return this.objectList.removeAll(objects);
    }

    public final boolean addObject(JaxoObject object) {
        if (object != null) {
            return this.objectList.add(object);
        }
        return false;
    }

    public final boolean addObject(int index, JaxoObject object) {
        if (object != null) {
            this.objectList.add(index, object);
            return true;
        }
        return false;
    }

    public final void addPackage(String pack) {
        this.packageList.add(pack);
    }

    public final boolean clear() {
        boolean listIsEmpty = this.objectList.isEmpty();
        if (!listIsEmpty) {
            this.objectList.clear();
        }
        return listIsEmpty;
    }

    public final boolean clearAll() {
        boolean graphIsEmpty = true;
        if (!this.objectList.isEmpty() || this.description != null && this.description.length() != 0 || this.packageList.size() != 3) {
            this.packageList.clear();
            this.addDefaultPackages();
            this.objectList.clear();
            this.setDescription("");
            graphIsEmpty = false;
        }
        return graphIsEmpty;
    }

    public final Rectangle getBounds() {
        return this.objectList.getBounds();
    }

    public final Rectangle getBoundsExcept(Collection<JaxoObject> except) {
        return this.objectList.getBoundsExcept(except);
    }

    public final Rectangle getBounds(Rectangle inside) {
        return this.objectList.intersection(inside);
    }

    public JaxoSaveGraph copyOf() {
        JaxoList<JaxoObject> copyObjectList = this.objectList.copyOf();
        int size = this.packageList.size();
        ArrayList<String> copyPackageList = new ArrayList<String>(size);
        for (int i = 0; i < size; ++i) {
            copyPackageList.add(this.packageList.get(i));
        }
        JaxoSaveGraph copy = new JaxoSaveGraph(copyObjectList, this.description, copyPackageList);
        copy.setJaxoDrawVersion(this.jaxoDrawVersion);
        return copy;
    }

    public boolean isCopy(JaxoSaveGraph graph) {
        boolean equalDesc;
        boolean bl = this.description == null ? graph.getDescription() == null : (equalDesc = this.description.equals(graph.getDescription()));
        boolean equalVersion = this.jaxoDrawVersion == null ? graph.getJaxoDrawVersion() == null : this.jaxoDrawVersion.equals(graph.getJaxoDrawVersion());
        boolean equalObjects = this.objectList.isCopy(graph.getObjectList());
        boolean equalPackages = ((Object)this.packageList).equals(graph.getPackageList());
        return equalDesc && equalObjects && equalPackages && equalVersion;
    }

    private void addDefaultPackages() {
        if (this.packageList.contains("axodraw")) {
            this.packageList.remove("axodraw");
        }
        if (!this.packageList.contains("axodraw4j")) {
            this.packageList.add("axodraw4j");
        }
        if (!this.packageList.contains("pstricks")) {
            this.packageList.add("pstricks");
        }
        if (!this.packageList.contains("color")) {
            this.packageList.add("color");
        }
    }
}

