/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jaxodraw.gui;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.geom.GeneralPath;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import javax.swing.AbstractAction;
import javax.swing.KeyStroke;
import net.sf.jaxodraw.graph.JaxoGraph;
import net.sf.jaxodraw.gui.AbstractJaxoCanvas;
import net.sf.jaxodraw.gui.JaxoCanvasEventListener;
import net.sf.jaxodraw.gui.JaxoDialogs;
import net.sf.jaxodraw.object.JaxoExtendedObject;
import net.sf.jaxodraw.object.JaxoList;
import net.sf.jaxodraw.object.JaxoObject;
import net.sf.jaxodraw.object.JaxoObjectFactory;
import net.sf.jaxodraw.object.group.JaxoGroup;
import net.sf.jaxodraw.util.JaxoConstants;
import net.sf.jaxodraw.util.JaxoGeometry;
import net.sf.jaxodraw.util.graphics.JaxoGraphics2D;

public final class JaxoCanvas
extends AbstractJaxoCanvas {
    private static final long serialVersionUID = 7526471155622776147L;
    private static final String COMMIT_CHANGES = "commitGraphChanges";
    private static final int GRAPH_PADDING = 10;
    private static final int CROSS_LENGTH = 4;
    private static final Insets FAINT_BOX_PADDING = new Insets(5, 5, 5, 5);
    private static final boolean PUT_DRAGGED_OBJECTS_TO_FOREGROUND = false;
    private final ActionListener actionListener;
    private transient Image offScreenImage;
    private final Point fixed = new Point();
    private int curHandle;
    private int currentMode = 0;
    private boolean fboxON;
    private final Point fboxOrigin = new Point();
    private final Point fboxLocation = new Point();
    private static final Color FBOX_FILL_COLOR = new Color(1.0f, 1.0f, 1.0f, 0.4f);
    private static final Color FBOX_LINE_COLOR = new Color(0.5f, 0.5f, 0.5f, 1.0f);
    private boolean visualAidPainted;
    private final List<Point> points = new ArrayList<Point>(4);
    private final Point pointsAidLocation = new Point();
    private boolean pointsON;
    private Rectangle rgbox;
    private float newRf = 1.0f;
    private int gHandle;
    private JaxoObject cachedGroup;
    private JaxoObject selectedObject;
    private JaxoObject hoveringObject;
    private boolean selectInside;
    private transient Rectangle cachedGraphBounds;

    public JaxoCanvas(ActionListener listener) {
        this.actionListener = listener;
        this.setBackground(Color.gray);
        this.setForeground(Color.black);
        this.setOpaque(true);
        this.setFocusable(true);
        Dimension d = this.getMinimumCanvasSize();
        JaxoGeometry.grow(d, this.getInsets());
        this.setPreferredSize(d);
        JaxoCanvasEventListener eventListener = new JaxoCanvasEventListener(this);
        eventListener.setMode(this.currentMode);
        this.addMouseListener(eventListener);
        this.addMouseMotionListener(eventListener);
        this.addPropertyChangeListener(eventListener);
        this.setupPointMouseAction();
        this.getFboxPopup().addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JaxoCanvas.this.actionListener.actionPerformed(e);
                JaxoCanvas.this.stopFaintBox();
            }
        });
    }

    private void fireActionPerformed(String actionCommand) {
        this.fireActionPerformed(actionCommand, 1001);
    }

    private void fireActionPerformed(String actionCommand, int actionId) {
        this.actionListener.actionPerformed(new ActionEvent(this, actionId, actionCommand));
    }

    public void markImageInvalid(Rectangle boundingBox) {
        this.updateOffScreenImage(boundingBox);
    }

    public void refresh() {
        this.dropHoveringObject();
        this.setSelectedObject(null);
        this.markImageInvalid();
    }

    private void dropHoveringObject() {
        if (this.hoveringObject != null) {
            JaxoList<JaxoObject> l = this.getCanvasGraph().getObjectList();
            int index = l.lastIndexOf(this.hoveringObject);
            if (!l.isEmpty() && index == l.size() - 1) {
                this.putObjectOnOffScreenImage(this.hoveringObject);
                this.hoveringObject = null;
            } else if (index == -1) {
                this.hoveringObject = null;
                this.updateOffScreenImage(null);
            } else {
                Rectangle bounds = this.hoveringObject.getBounds();
                this.hoveringObject = null;
                this.updateOffScreenImage(bounds);
            }
            this.cachedGraphBounds = null;
        }
    }

    private void setHoveringObject(JaxoObject value) {
        if (this.hoveringObject != value) {
            this.dropHoveringObject();
            this.hoveringObject = value;
            this.cachedGraphBounds = null;
            if (this.getCanvasGraph().getObjectList().contains(this.hoveringObject)) {
                this.markImageInvalid(this.hoveringObject.getBounds());
            } else {
                this.repaintObject(this.hoveringObject);
            }
        }
    }

    private void setSelectedObject(JaxoObject newOb) {
        this.selectedObject = newOb;
    }

    public void setCanvasGraph(JaxoGraph value) {
        if (this.getCanvasGraph() != value) {
            super.setCanvasGraph(value);
            if (this.hoveringObject != null) {
                this.hoveringObject = null;
            }
            this.markImageInvalid();
            if (this.getHandlePaintMode() != 0 || this.visualAidPainted) {
                this.repaint();
            }
            this.revalidateCanvas();
        }
    }

    private void ensureValidOffScreenImage() {
        if (this.offScreenImage == null) {
            this.createOffScreenImage();
            this.updateOffScreenImage(null);
        }
    }

    protected void paintComponent(Graphics g) {
        JaxoGraphics2D g2 = new JaxoGraphics2D((Graphics2D)g.create());
        Insets n = this.getInsets();
        this.ensureValidOffScreenImage();
        Dimension d = this.getSize();
        Dimension canvasSize = this.getCanvasSize();
        if (d.width != canvasSize.width || d.height != canvasSize.height) {
            g2.setColor(this.getBackground());
            g2.fillRect(0, 0, this.getWidth(), this.getHeight());
        }
        g2.translate(n.left, n.top);
        g2.clipRect(0, 0, canvasSize.width, canvasSize.height);
        g2.drawImage(this.offScreenImage, 0, 0, null);
        if (this.hoveringObject != null) {
            Object old = g2.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
            Object oldControl = g2.getRenderingHint(RenderingHints.KEY_STROKE_CONTROL);
            g2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
            if (this.isAntialiasEnabled()) {
                g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            }
            this.hoveringObject.paint(g2);
            if (this.isAntialiasEnabled()) {
                g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, old);
            }
            g2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, oldControl);
        }
        if (this.visualAidPainted && this.selectedObject != null) {
            g2.setColor(DEFAULT_HELP_COLOR);
            g2.setStroke(DEFAULT_HELP_STROKE);
            this.selectedObject.paintVisualAid(g2);
        }
        if (this.getHandlePaintMode() == 1) {
            int handleMode = this.fboxON ? 460 : this.currentMode;
            this.getCanvasGraph().paintHandles(g2, this.getHandle(), handleMode);
        } else if (this.getHandlePaintMode() == 2) {
            this.selectedObject.paintHandles(g2, this.getHandle(), this.currentMode);
        }
        if (this.fboxON) {
            this.paintFaintBox(g2);
        }
        if (this.pointsON) {
            this.paintPointsAid(g2);
        }
        g2.dispose();
    }

    protected void printComponent(Graphics gr) {
        JaxoGraphics2D g = new JaxoGraphics2D((Graphics2D)gr.create());
        g.setPrinting(true);
        g.setColor(this.getBackground());
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        Insets n = this.getInsets();
        g.translate(n.left, n.top);
        this.paintBackgroundAndGrid(g, new Rectangle(this.getCanvasSize()));
        if (this.isAntialiasEnabled()) {
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        }
        g.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
        this.getCanvasGraph().paintClipped(g);
        g.dispose();
    }

    protected void rebuildImage() {
        if (this.offScreenImage != null) {
            this.offScreenImage.flush();
            this.offScreenImage = null;
        }
        this.ensureValidOffScreenImage();
    }

    private void createOffScreenImage() {
        Dimension d = this.getEffectiveMaximumCanvasSize();
        this.offScreenImage = this.createImage(d.width, d.height);
        this.getZoom().setBackground(this.offScreenImage);
    }

    private void updateOffScreenImage(Rectangle oldbb) {
        if (this.offScreenImage == null) {
            return;
        }
        JaxoGraphics2D g2 = new JaxoGraphics2D((Graphics2D)this.offScreenImage.getGraphics());
        if (this.isAntialiasEnabled()) {
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        }
        g2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
        Rectangle damagedBounds = oldbb == null ? new Rectangle(0, 0, this.offScreenImage.getWidth(null), this.offScreenImage.getHeight(null)) : oldbb;
        this.paintBackgroundAndGrid(g2, damagedBounds);
        g2.clip(damagedBounds);
        if (this.hoveringObject == null) {
            this.getCanvasGraph().getObjectList().paintClipped(g2);
        } else {
            this.getCanvasGraph().getObjectList().paintClippedExcept(Collections.singleton(this.hoveringObject), g2);
        }
        g2.dispose();
        this.repaintBoundingBox(damagedBounds);
    }

    private void repaintHandles(JaxoObject o) {
        this.repaintBoundingBox(o.getBoundsWithHandles(this.getHandle()));
    }

    private void repaintObject(JaxoObject o) {
        this.repaintBoundingBox(o.getBounds());
    }

    private void selectObjectsToGroup(Point p) {
        JaxoObject newSelectedOb = null;
        int i = this.getCanvasGraph().listSize();
        this.setSelectedObject(null);
        while (newSelectedOb == null && i >= 1) {
            int grabbedHandle;
            JaxoObject curOb = this.getCanvasGraph().listElementAt(--i);
            if (!curOb.canBeSelected(grabbedHandle = curOb.getGrabbedHandle(p.x, p.y, this.getHandle()), this.currentMode)) continue;
            newSelectedOb.setAsMarked(!(newSelectedOb = curOb).isMarked());
            this.setSelectedObject(curOb);
            this.repaintHandles(newSelectedOb);
        }
    }

    private void selectObject(Point p, int editmode) {
        JaxoObject newSelectedOb = null;
        int i = this.getCanvasGraph().listSize();
        while (newSelectedOb == null && i >= 1) {
            int grabbedHandle;
            JaxoObject curOb = this.getCanvasGraph().listElementAt(--i);
            if (curOb == null || !curOb.canBeSelected(grabbedHandle = curOb.getGrabbedHandle(p.x, p.y, this.getHandle()), editmode)) continue;
            newSelectedOb = curOb;
            this.setSelectedObject(newSelectedOb);
            if (editmode != 451) continue;
            this.curHandle = grabbedHandle;
            this.setStartCoordinates();
        }
        this.setSelectedObject(newSelectedOb);
    }

    private void setStartCoordinates() {
        if (this.selectedObject == null) {
            return;
        }
        JaxoExtendedObject selectedOb = (JaxoExtendedObject)this.selectedObject;
        this.fixed.x = selectedOb.getX();
        this.fixed.y = selectedOb.getY();
        if (this.curHandle == 0) {
            this.fixed.x = selectedOb.getX2();
            this.fixed.y = selectedOb.getY2();
        } else if (this.curHandle == -3) {
            this.fixed.x = selectedOb.getX2();
        } else if (this.curHandle == -4) {
            this.fixed.y = selectedOb.getY2();
        }
    }

    private void finishModeDragAction() {
        this.finishModeDragAction(false);
    }

    private void stopModeDragAction() {
        this.finishModeDragAction(true);
    }

    private void finishModeDragAction(boolean cancel) {
        if (this.fboxON) {
            return;
        }
        boolean resetMode = false;
        if (this.currentMode == 450 || this.currentMode == 452 || this.currentMode == 451) {
            if (this.selectedObject != null) {
                this.dropHoveringObject();
                this.setVisualAidPainted(false);
                this.setHandlePaintMode(1);
                this.revalidateCanvas();
                this.fireActionPerformed(COMMIT_CHANGES);
                resetMode = true;
            }
        } else if (JaxoConstants.isParticleMode(this.currentMode) || this.currentMode == 230 || this.currentMode == 231 || this.currentMode == 233 || JaxoConstants.isVertexMode(this.currentMode)) {
            if (this.selectedObject != null) {
                boolean empty = false;
                if (this.selectedObject.getPointCount() != 1) {
                    boolean bl = empty = this.selectedObject.getWidth() == 0 && this.selectedObject.getHeight() == 0;
                }
                if (empty) {
                    this.getCanvasGraph().delete(this.selectedObject);
                } else {
                    this.fireActionPerformed("commitRepeatableGraphChanges");
                }
                this.dropHoveringObject();
                this.setVisualAidPainted(false);
                this.revalidateCanvas();
                resetMode = true;
            }
        } else if (JaxoConstants.isSelectMode(this.currentMode)) {
            if (this.selectedObject != null && this.selectedObject.isMarked() && !cancel) {
                if (this.currentMode == 459) {
                    if (this.selectedObject instanceof JaxoGroup) {
                        this.ungroupSelectedObject();
                    }
                    resetMode = true;
                } else if (this.currentMode == 453) {
                    this.selectedObject.setAsMarked(false);
                    this.setHandlePaintMode(2);
                    this.showColorChooser(this.selectedObject);
                    resetMode = true;
                } else if (this.currentMode == 455) {
                    this.getCanvasGraph().delete(this.selectedObject);
                    this.fireActionPerformed(COMMIT_CHANGES);
                    this.markImageInvalid(this.selectedObject.getBounds());
                    this.revalidateCanvas();
                    resetMode = true;
                } else if (this.currentMode == 456) {
                    this.getCanvasGraph().background(this.selectedObject);
                    this.fireActionPerformed(COMMIT_CHANGES);
                    this.markImageInvalid(this.getCanvasGraph().getBounds());
                    resetMode = true;
                } else if (this.currentMode == 457) {
                    this.getCanvasGraph().foreground(this.selectedObject);
                    this.fireActionPerformed(COMMIT_CHANGES);
                    this.markImageInvalid(this.getCanvasGraph().getBounds());
                    resetMode = true;
                } else if (this.currentMode == 454) {
                    this.selectedObject.setAsMarked(false);
                    this.showEditPanelFor(this.selectedObject);
                }
                if (this.currentMode != 460 && this.selectedObject != null) {
                    this.selectedObject.setAsMarked(false);
                    this.repaintHandles(this.selectedObject);
                }
            }
            this.selectInside = false;
        }
        if (resetMode) {
            this.fireActionPerformed("resetMode");
        }
    }

    private void startFaintBox(Point p) {
        this.fboxON = true;
        this.fboxOrigin.setLocation(p);
        this.fboxLocation.setLocation(p);
        this.repaint();
    }

    private void dragFaintBox(Point p) {
        this.fboxLocation.setLocation(p);
        this.setCursor(Cursor.getPredefinedCursor(5));
        this.setHandlePaintMode(1);
        this.setVisualAidPainted(false);
        this.updateFaintBoxContents();
        this.repaint();
    }

    private void stopFaintBox() {
        if (this.fboxON) {
            this.fboxON = false;
            this.getCanvasGraph().setAsMarked(false);
            this.repaint();
        }
    }

    private void updateFaintBoxContents() {
        Rectangle faintbox = this.getFaintBoxBounds();
        for (int i = 0; i < this.getCanvasGraph().listSize(); ++i) {
            JaxoObject jaxoOb = this.getCanvasGraph().listElementAt(i);
            Rectangle bounds = jaxoOb.getBounds();
            JaxoGeometry.grow(bounds, FAINT_BOX_PADDING);
            if (faintbox.contains(bounds)) {
                jaxoOb.setAsMarked(true);
                continue;
            }
            jaxoOb.setAsMarked(false);
        }
    }

    private Rectangle getFaintBoxBounds() {
        int width = this.fboxLocation.x - this.fboxOrigin.x;
        int height = this.fboxLocation.y - this.fboxOrigin.y;
        Rectangle faintbox = height < 0 ? (width < 0 ? new Rectangle(this.fboxLocation.x, this.fboxLocation.y, -width, -height) : new Rectangle(this.fboxOrigin.x, this.fboxLocation.y, width, -height)) : (width < 0 ? new Rectangle(this.fboxLocation.x, this.fboxOrigin.y, -width, height) : new Rectangle(this.fboxOrigin.x, this.fboxOrigin.y, width, height));
        return faintbox;
    }

    private void paintFaintBox(JaxoGraphics2D g2) {
        Rectangle f = this.getFaintBoxBounds();
        g2.setColor(FBOX_FILL_COLOR);
        g2.fill(f);
        g2.draw(f);
        g2.setColor(FBOX_LINE_COLOR);
        g2.setStroke(DEFAULT_HELP_STROKE);
        g2.draw(f);
    }

    private void setVisualAidPainted(boolean value) {
        if (this.visualAidPainted != value) {
            this.visualAidPainted = value;
            if (this.selectedObject != null) {
                this.repaint();
            }
        }
    }

    private void setupPointMouseAction() {
        this.getInputMap().put(KeyStroke.getKeyStroke("ESCAPE"), "stopPointMouseAction");
        this.getActionMap().put("stopPointMouseAction", new AbstractAction(){
            private static final long serialVersionUID = 75264711556226147L;

            public void actionPerformed(ActionEvent e) {
                JaxoCanvas.this.stopPointMouseAction();
            }

            public boolean isEnabled() {
                return JaxoCanvas.this.pointsON;
            }
        });
        this.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                JaxoCanvas.this.stopPointMouseAction();
            }
        });
    }

    private void startPointMouseAction() {
        if (!this.pointsON) {
            this.pointsON = true;
            this.pointsAidLocation.setLocation(this.points.get(0));
            this.requestFocusInWindow();
            this.fireActionPerformed("setGlassPaneVisible");
            this.revalidateCanvas();
            this.repaint();
        }
    }

    private void stopPointMouseAction() {
        if (this.pointsON) {
            this.pointsON = false;
            this.points.clear();
            this.fireActionPerformed("setGlassPaneInvisible");
            this.revalidateCanvas();
            this.repaint();
        }
    }

    private void paintPointsAid(JaxoGraphics2D g2) {
        g2.setColor(DEFAULT_HELP_COLOR);
        g2.setStroke(DEFAULT_HELP_STROKE);
        Point first = this.points.get(0);
        this.paintCrossAt(g2, first.x, first.y);
        GeneralPath gp = new GeneralPath();
        gp.moveTo(first.x, first.y);
        ListIterator<Point> i = this.points.listIterator(1);
        while (i.hasNext()) {
            Point p = (Point)i.next();
            gp.lineTo(p.x, p.y);
        }
        gp.lineTo(this.pointsAidLocation.x, this.pointsAidLocation.y);
        g2.draw(gp);
    }

    private void paintCrossAt(JaxoGraphics2D g, int x, int y) {
        g.drawLine(x - 4, y - 4, x + 4, y + 4);
        g.drawLine(x - 4, y + 4, x + 4, y - 4);
    }

    private JaxoObject createNewObject(Point q) {
        JaxoObject newob = JaxoObjectFactory.newObject(this.currentMode);
        int pointCount = newob.getPointCount();
        Point[] location = new Point[pointCount];
        if (pointCount == 1) {
            location[0] = q;
        } else if (pointCount == 2) {
            location[0] = q;
            location[1] = q;
        } else {
            this.points.add(new Point(q));
            if (this.points.size() == pointCount) {
                for (int i = 0; i < pointCount; ++i) {
                    location[i] = this.points.get(i);
                }
                this.stopPointMouseAction();
            } else {
                this.startPointMouseAction();
                return null;
            }
        }
        newob.setPoints(location);
        newob.setPreferences();
        if (JaxoConstants.isTextMode(this.currentMode)) {
            String text = JaxoDialogs.getText(this.asComponent());
            newob.setParameter("textString", text);
            if (text.length() == 0) {
                newob = null;
            }
        }
        return newob;
    }

    private void showColorChooser(JaxoObject ob) {
        this.setHoveringObject(ob);
        boolean hasChanged = this.showColorPanel(ob);
        this.dropHoveringObject();
        if (hasChanged) {
            this.fireActionPerformed(COMMIT_CHANGES);
        }
    }

    private void putObjectOnOffScreenImage(JaxoObject ob) {
        JaxoGraphics2D g2 = new JaxoGraphics2D((Graphics2D)this.offScreenImage.getGraphics());
        if (this.isAntialiasEnabled()) {
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        }
        g2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
        ob.paint(g2);
        g2.dispose();
        this.repaintBoundingBox(ob.getBounds());
    }

    private void setCachedGroup(JaxoGroup group) {
        this.cachedGroup = group.copy();
    }

    private void swapGroups(JaxoGroup scaledGroup, JaxoGroup copyGroup) {
        this.getCanvasGraph().delete(scaledGroup);
        JaxoObject scalableGroup = copyGroup.copy();
        this.getCanvasGraph().addObject(scalableGroup);
        this.setSelectedObject(scalableGroup);
    }

    private void setFixedPointAndScaleFactor(int selectedHandle, int xpos) {
        if (selectedHandle == 0) {
            this.fixed.x = this.rgbox.x + this.rgbox.width;
            this.fixed.y = this.rgbox.y + this.rgbox.height;
            if (xpos < this.fixed.x) {
                this.newRf = Math.abs((float)(xpos - this.fixed.x) / (float)this.rgbox.width);
            }
        } else if (selectedHandle == -4) {
            this.fixed.x = this.rgbox.x;
            this.fixed.y = this.rgbox.y + this.rgbox.height;
            if (xpos > this.fixed.x) {
                this.newRf = Math.abs((float)(xpos - this.fixed.x) / (float)this.rgbox.width);
            }
        } else if (selectedHandle == 1) {
            this.fixed.x = this.rgbox.x;
            this.fixed.y = this.rgbox.y;
            if (xpos > this.fixed.x) {
                this.newRf = Math.abs((float)(xpos - this.fixed.x) / (float)this.rgbox.width);
            }
        } else if (selectedHandle == -3) {
            this.fixed.x = this.rgbox.x + this.rgbox.width;
            this.fixed.y = this.rgbox.y;
            if (xpos < this.fixed.x) {
                this.newRf = Math.abs((float)(xpos - this.fixed.x) / (float)this.rgbox.width);
            }
        }
        if (this.newRf < 0.1f) {
            this.newRf = 0.1f;
        }
    }

    void revalidateCanvasFast() {
        if (this.cachedGraphBounds == null) {
            this.revalidateCanvas();
        } else {
            this.continueRevalidate(new Rectangle(this.cachedGraphBounds));
        }
    }

    protected void revalidateCanvas() {
        Rectangle bBox = this.hoveringObject == null ? this.getCanvasGraph().getBounds() : this.getCanvasGraph().getBoundsExcept(Collections.singleton(this.hoveringObject));
        if (bBox == null) {
            bBox = new Rectangle();
        }
        this.cachedGraphBounds = new Rectangle(bBox);
        this.continueRevalidate(bBox);
    }

    private void continueRevalidate(Rectangle bBox) {
        Dimension maximum = this.getEffectiveMaximumCanvasSize();
        if (this.hoveringObject != null) {
            bBox.add(this.hoveringObject.getBounds());
        }
        if (this.pointsON) {
            Iterator<Point> i = this.points.iterator();
            while (i.hasNext()) {
                bBox.add(i.next());
            }
            bBox.add(this.pointsAidLocation);
        }
        int graphWidth = bBox.x + bBox.width + 10;
        int graphHeight = bBox.y + bBox.height + 10;
        Insets n = this.getInsets();
        int newWidth = JaxoCanvas.valueBetween(this.getMinimumCanvasSize().width, graphWidth, maximum.width) + n.left + n.right;
        int newHeight = JaxoCanvas.valueBetween(this.getMinimumCanvasSize().height, graphHeight, maximum.height) + n.top + n.bottom;
        Dimension d = this.getPreferredSize();
        if (d.width != newWidth || d.height != newHeight) {
            this.setPreferredSize(new Dimension(newWidth, newHeight));
            this.revalidate();
        }
    }

    private static int valueBetween(int minimum, int value, int maximum) {
        return Math.max(minimum, Math.min(value, maximum));
    }

    protected void deleteMarkedObjects() {
        Rectangle oldBounds = this.getCanvasGraph().getBounds();
        this.getCanvasGraph().deleteMarkedObjects();
        this.fireActionPerformed(COMMIT_CHANGES);
        this.markImageInvalid(oldBounds);
        this.revalidateCanvas();
    }

    public void pasteFromClipboard() {
        JaxoGraph g = this.getSystemClipboardGraph();
        if (g != null) {
            this.paste(g);
        }
        this.dropHoveringObject();
        this.setSelectedObject(null);
    }

    private void paste(JaxoGraph g) {
        int[] delta = this.getPastingDelta(g);
        for (int k = 0; k < g.listSize(); ++k) {
            JaxoObject obj = g.listElementAt(k).copy();
            obj.moveBy(delta[0], delta[1]);
            this.getCanvasGraph().addObject(obj);
        }
        this.fireActionPerformed("commitRepeatableGraphChangesN", g.listSize());
        this.markImageInvalid();
        this.revalidateCanvas();
    }

    private int[] getPastingDelta(JaxoGraph g) {
        int[] delta = new int[]{0, 0};
        if (this.fboxON) {
            Rectangle bbox = g.getBounds();
            Rectangle f = this.getFaintBoxBounds();
            delta[0] = f.x - bbox.x;
            delta[1] = f.y - bbox.y;
        }
        return delta;
    }

    public void ungroupMarkedObjects() {
        if (this.getCanvasGraph().ungroupMarkedObjects()) {
            this.fireActionPerformed(COMMIT_CHANGES);
            if (this.getHandlePaintMode() != 0) {
                this.repaint();
            }
        }
    }

    public void ungroupSelectedObject() {
        if (this.getCanvasGraph().ungroup(this.selectedObject)) {
            if (this.getHandlePaintMode() != 0) {
                this.repaint();
            }
            this.setSelectedObject(null);
            this.fireActionPerformed(COMMIT_CHANGES);
        }
    }

    public void groupMarkedObjects() {
        if (this.getCanvasGraph().groupMarkedObjects()) {
            if (this.getHandlePaintMode() != 0) {
                this.repaint();
            }
            this.fireActionPerformed("commitRepeatableGraphChanges");
        }
    }

    public void updateMode(int mode) {
        this.currentMode = mode;
        this.stopPointMouseAction();
        this.dropHoveringObject();
        this.setSelectedObject(null);
        this.setCursor(Cursor.getPredefinedCursor(1));
        this.setHandlePaintMode(0);
        this.setVisualAidPainted(false);
        if (JaxoConstants.isMiscMode(mode)) {
            if (mode == 234 || mode == 235) {
                this.setCursor(Cursor.getPredefinedCursor(2));
            }
        } else if (JaxoConstants.isEditMode(mode)) {
            if (mode != 450 && mode != 451 && mode != 452) {
                this.setCursor(Cursor.getPredefinedCursor(12));
            }
            this.setHandlePaintMode(1);
        }
    }

    public void clear() {
        this.dropHoveringObject();
        this.getCanvasGraph().clear();
        this.fireActionPerformed(COMMIT_CHANGES);
        this.setSelectedObject(null);
        this.markImageInvalid();
        this.revalidateCanvas();
    }

    public void moveSelection(boolean backGround) {
        this.dropHoveringObject();
        this.setSelectedObject(null);
        if (backGround) {
            this.getCanvasGraph().objectsToBackground();
        } else {
            this.getCanvasGraph().objectsToForeground();
        }
        this.fireActionPerformed(COMMIT_CHANGES);
        this.markImageInvalid();
    }

    public void editNearestObject(Point p) {
        this.stopFaintBox();
        this.stopPointMouseAction();
        this.stopModeDragAction();
        this.setSelectedObject(this.getCanvasGraph().getNearestObject(p.x, p.y));
        this.showEditPanelFor(this.selectedObject);
    }

    private void showEditPanelFor(JaxoObject o) {
        if (o == null) {
            return;
        }
        this.setHoveringObject(o);
        boolean hasChanged = this.showEditPanel(o);
        this.dropHoveringObject();
        if (hasChanged) {
            this.fireActionPerformed(COMMIT_CHANGES);
            this.revalidateCanvas();
        }
        this.fireActionPerformed("resetMode");
    }

    public void initiateEdit(Point p) {
        if (this.currentMode == 0) {
            return;
        }
        if (this.currentMode == 450 || this.currentMode == 451) {
            this.selectObject(p, this.currentMode);
            if (this.selectedObject != null) {
                this.setHandlePaintMode(0);
                this.setVisualAidPainted(true);
                if (this.selectedObject instanceof JaxoGroup) {
                    this.setCachedGroup((JaxoGroup)this.selectedObject);
                    this.gHandle = this.curHandle;
                    this.rgbox = ((JaxoGroup)this.selectedObject).getBounds();
                }
                this.setHoveringObject(this.selectedObject);
                if (this.currentMode == 450) {
                    this.snapObject(this.selectedObject);
                }
            }
        } else if (this.currentMode == 452) {
            this.selectObject(p, 450);
            if (this.selectedObject != null) {
                this.setHandlePaintMode(0);
                this.setVisualAidPainted(true);
                JaxoObject copyOb = this.selectedObject.copy();
                this.getCanvasGraph().addObject(copyOb);
                this.setSelectedObject(copyOb);
                this.snapObject(copyOb);
                this.setHoveringObject(copyOb);
            }
        } else {
            if (JaxoConstants.isSelectMode(this.currentMode)) {
                if (this.currentMode == 460) {
                    this.selectObjectsToGroup(p);
                    this.selectInside = this.selectedObject != null && this.selectedObject.isMarked();
                } else {
                    this.selectObject(p, 450);
                    this.selectInside = true;
                    if (this.selectedObject != null) {
                        this.selectedObject.setAsMarked(true);
                        this.repaintHandles(this.selectedObject);
                    }
                }
                return;
            }
            Point q = new Point(p);
            this.snapPoint(q);
            JaxoObject newob = this.createNewObject(q);
            if (newob == null) {
                if (this.pointsON) {
                    this.repaint();
                }
            } else {
                this.getCanvasGraph().addObject(newob);
                this.setSelectedObject(newob);
                this.setHoveringObject(newob);
                if (JaxoConstants.isTextMode(this.currentMode)) {
                    this.dropHoveringObject();
                    this.fireActionPerformed("commitRepeatableGraphChanges");
                    this.fireActionPerformed("resetMode");
                } else {
                    this.setHandlePaintMode(0);
                    this.setVisualAidPainted(true);
                    this.curHandle = newob.getPointCount() - 1;
                    this.setStartCoordinates();
                }
                this.revalidateCanvas();
                this.repaint();
            }
        }
    }

    public void continueEdit(Point p, Point last) {
        int grabbedHandle;
        boolean inside;
        if (this.pointsON) {
            Point q = this.points.get(this.points.size() - 1);
            q.setLocation(p);
            this.updatePointsAid(q);
            return;
        }
        if (this.selectedObject == null) {
            return;
        }
        if (this.currentMode == 451 || JaxoConstants.isNewObjectMode(this.currentMode)) {
            Point q = new Point(p);
            this.snapPoint(q);
            if (this.selectedObject instanceof JaxoGroup) {
                this.swapGroups((JaxoGroup)this.selectedObject, (JaxoGroup)this.cachedGroup);
                this.setFixedPointAndScaleFactor(this.gHandle, q.x);
                JaxoGroup group = (JaxoGroup)this.selectedObject;
                group.rescaleObject(this.fixed.x, this.fixed.y, this.newRf);
                if (this.hoveringObject == this.selectedObject) {
                    this.hoveringObject = group;
                }
            }
            if (this.curHandle >= 0) {
                this.selectedObject.setX(this.curHandle, q.x);
                this.selectedObject.setY(this.curHandle, q.y);
            } else if (this.curHandle == -3) {
                this.selectedObject.setLocation(q.x, this.fixed.y);
                ((JaxoExtendedObject)this.selectedObject).setRelWAndH(this.fixed.x - q.x, q.y - this.fixed.y);
            } else if (this.curHandle == -4) {
                this.selectedObject.setLocation(this.fixed.x, q.y);
                ((JaxoExtendedObject)this.selectedObject).setRelWAndH(q.x - this.fixed.x, this.fixed.y - q.y);
            }
            this.repaint();
        } else if (this.currentMode == 450 || this.currentMode == 452) {
            Point m = new Point(last);
            Point q = new Point(p);
            this.snapObject(this.selectedObject);
            this.snapPoint(m);
            this.snapPoint(q);
            this.selectedObject.moveBy(q.x - m.x, q.y - m.y);
            this.repaint();
        } else if (JaxoConstants.isSelectMode(this.currentMode) && (inside = (grabbedHandle = this.selectedObject.getGrabbedHandle(p.x, p.y, this.getHandle())) != -1 && this.selectedObject.canBeSelected(grabbedHandle, this.currentMode)) == this.selectInside != this.selectedObject.isMarked()) {
            this.selectedObject.setAsMarked(inside == this.selectInside);
            this.repaintHandles(this.selectedObject);
        }
    }

    public void finalizeEdit() {
        if (!this.pointsON) {
            this.finishModeDragAction();
            this.updateMode(this.currentMode);
        }
    }

    public void updatePointsAid(Point p) {
        if (this.pointsON) {
            this.pointsAidLocation.setLocation(p);
            this.snapPoint(this.pointsAidLocation);
            this.repaint();
        }
    }

    public void initiateSelect(Point p) {
        this.startFaintBox(p);
    }

    public void continueSelect(Point p) {
        this.dragFaintBox(p);
    }

    public void finalizeSelect(Point p) {
        this.popupSelectionPanel(p);
        this.updateMode(this.currentMode);
    }

    private void popupSelectionPanel(Point location) {
        if (!this.showSelectionPanel(location)) {
            this.stopFaintBox();
        }
    }
}

