/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jaxodraw.gui;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import javax.swing.event.MouseInputAdapter;
import net.sf.jaxodraw.gui.JaxoCanvasComponent;
import net.sf.jaxodraw.util.JaxoColor;
import net.sf.jaxodraw.util.JaxoGeometry;
import net.sf.jaxodraw.util.JaxoUtils;

public class JaxoZoom
extends MouseInputAdapter {
    private static final boolean PRINT_ZOOM = true;
    public static final int ZOOM_FACTOR_X2 = 2;
    public static final int ZOOM_FACTOR_X4 = 4;
    public static final int ZOOM_FACTOR_X8 = 8;
    private static final int PADDING = 1;
    private Graphics graphics;
    private final JaxoCanvasComponent theCanvas;
    private final Point zoomWindowLocation;
    private final Dimension zoomWindowSize;
    private Image background;
    private Image foreground;
    private int zoomFactor;
    private boolean active;
    private boolean visible;
    private final Rectangle damagedBounds;

    public JaxoZoom(JaxoCanvasComponent canvas) {
        this.theCanvas = canvas;
        this.zoomFactor = 2;
        this.zoomWindowSize = new Dimension();
        this.zoomWindowLocation = new Point();
        this.damagedBounds = new Rectangle();
    }

    public final boolean isActive() {
        return this.active;
    }

    public void setActive(boolean value) {
        if (this.active != value) {
            this.active = value;
            if (this.active) {
                this.theCanvas.addMouseListener(this);
                this.theCanvas.addMouseMotionListener(this);
            } else {
                this.cleanup();
                this.theCanvas.removeMouseListener(this);
                this.theCanvas.removeMouseMotionListener(this);
            }
        }
    }

    public final void setZoomFactor(int zf) {
        this.zoomFactor = zf;
    }

    public final int getZoomFactor() {
        return this.zoomFactor;
    }

    public final void setZoomWindowSize(int width, int height) {
        this.zoomWindowSize.setSize(width, height);
    }

    public void setBackground(Image bg) {
        this.background = bg;
    }

    private void setGraphics(Graphics value) {
        this.graphics = value;
        if (this.graphics != null) {
            Rectangle r = this.theCanvas.getCanvasBounds();
            this.graphics.clipRect(r.x, r.y, r.width, r.height);
            this.graphics.translate(r.x, r.y);
        }
    }

    private void damage(int x, int y, int width, int height) {
        JaxoGeometry.add(this.damagedBounds, x, y, width, height);
    }

    private void paintToGraphics() {
        int x = this.damagedBounds.x - 1;
        int y = this.damagedBounds.y - 1;
        JaxoUtils.drawImageArea(this.foreground, x, y, this.damagedBounds.width + 2, this.damagedBounds.height + 2, this.graphics);
        JaxoGeometry.clear(this.damagedBounds);
    }

    private void paintZoom() {
        int width = this.zoomWindowSize.width;
        int height = this.zoomWindowSize.height;
        int x = this.zoomWindowLocation.x;
        int y = this.zoomWindowLocation.y;
        Graphics g = this.foreground.getGraphics();
        g.clipRect(x, y, width, height);
        Graphics2D h = (Graphics2D)g.create();
        Point p = this.theCanvas.getCanvasOrigin();
        h.translate(-p.x, -p.y);
        h.translate((1 - this.zoomFactor) * (x + width / 2), (1 - this.zoomFactor) * (y + height / 2));
        h.scale(this.zoomFactor, this.zoomFactor);
        this.theCanvas.print(h);
        h.dispose();
        g.setColor(JaxoColor.BLACK);
        g.drawRect(x, y, width - 1, height - 1);
        g.dispose();
        this.damage(x, y, width, height);
    }

    private void drawZoomWindow() {
        if (this.foreground == null) {
            this.createForeground();
        }
        this.paintZoom();
        this.paintToGraphics();
    }

    private void eraseZoomWindow() {
        int width = this.zoomWindowSize.width;
        int height = this.zoomWindowSize.height;
        int x = this.zoomWindowLocation.x;
        int y = this.zoomWindowLocation.y;
        JaxoUtils.drawImageArea(this.background, x, y, width, height, this.graphics);
    }

    private void restoreBackground(int oldX, int oldY, int newX, int newY) {
        if (this.foreground == null) {
            this.createForeground();
        }
        Graphics g = this.foreground.getGraphics();
        int width = this.zoomWindowSize.width;
        int height = this.zoomWindowSize.height;
        if (newX <= oldX && newY <= oldY) {
            JaxoUtils.drawImageArea(this.background, newX + width, oldY, oldX - newX, newY + height - oldY, g);
            JaxoUtils.drawImageArea(this.background, oldX, newY + height, width, oldY - newY, g);
        } else if (newX > oldX && newY <= oldY) {
            JaxoUtils.drawImageArea(this.background, oldX, oldY, newX - oldX, newY + height - oldY, g);
            JaxoUtils.drawImageArea(this.background, oldX, newY + height, width, oldY - newY, g);
        } else if (newX > oldX && newY > oldY) {
            JaxoUtils.drawImageArea(this.background, oldX, oldY, width, newY - oldY, g);
            JaxoUtils.drawImageArea(this.background, oldX, newY, newX - oldX, oldY + height - newY, g);
        } else {
            JaxoUtils.drawImageArea(this.background, oldX, oldY, width, newY - oldY, g);
            JaxoUtils.drawImageArea(this.background, newX + width, newY, oldX - newX, oldY + height - newY, g);
        }
        g.dispose();
    }

    private void dragZoomWindow(int eX, int eY) {
        int oldX = this.zoomWindowLocation.x;
        int oldY = this.zoomWindowLocation.y;
        int width = this.zoomWindowSize.width;
        int height = this.zoomWindowSize.height;
        int newX = eX - width / 2;
        int newY = eY - height / 2;
        Rectangle r = this.theCanvas.getCanvasBounds();
        if (newX - r.x >= r.width - width / 2) {
            newX = r.width - width / 2 + r.x - 1;
        } else if (newX - r.x < -width / 2) {
            newX = r.x - width / 2;
        }
        if (newY - r.y >= r.height - height / 2) {
            newY = r.height - height / 2 + r.y - 1;
        } else if (newY - r.y < -height / 2) {
            newY = r.y - height / 2;
        }
        this.restoreBackground(oldX, oldY, newX, newY);
        this.damage(oldX, oldY, width, height);
        this.zoomWindowLocation.setLocation(newX, newY);
        this.drawZoomWindow();
    }

    public static final int getZoomFactorFor(int mode) {
        int factor = -1;
        if (mode == 792) {
            factor = 2;
        } else if (mode == 793) {
            factor = 4;
        } else if (mode == 794) {
            factor = 8;
        }
        return factor;
    }

    public void setZoomFactorFor(int mode) {
        this.setZoomFactor(JaxoZoom.getZoomFactorFor(mode));
    }

    private void createForeground() {
        this.foreground = ((Graphics2D)this.graphics).getDeviceConfiguration().createCompatibleImage(this.background.getWidth(null), this.background.getHeight(null));
        Graphics g = this.foreground.getGraphics();
        g.drawImage(this.background, 0, 0, null);
        g.dispose();
        JaxoGeometry.clear(this.damagedBounds);
    }

    public final void mousePressed(MouseEvent e) {
        if (!this.visible) {
            if (JaxoUtils.isButton1(e)) {
                this.setZoomWindowSize(160, 100);
            } else if (JaxoUtils.isButton2(e)) {
                this.setZoomWindowSize(240, 150);
            } else if (JaxoUtils.isButton3(e)) {
                this.setZoomWindowSize(320, 200);
            }
            this.visible = true;
            this.setGraphics(this.theCanvas.getGraphics());
            this.zoomWindowLocation.setLocation(e.getX() - this.zoomWindowSize.width / 2, e.getY() - this.zoomWindowSize.height / 2);
            this.drawZoomWindow();
        }
    }

    public final void mouseDragged(MouseEvent e) {
        if (this.visible) {
            this.dragZoomWindow(e.getX(), e.getY());
        }
    }

    public final void mouseReleased(MouseEvent e) {
        if (this.visible) {
            this.visible = false;
            this.eraseZoomWindow();
            this.cleanup();
        }
    }

    private void cleanup() {
        if (this.visible) {
            this.theCanvas.repaint();
        }
        this.visible = false;
        if (this.graphics != null) {
            this.graphics.dispose();
            this.setGraphics(null);
        }
        if (this.foreground != null) {
            this.foreground.flush();
            this.foreground = null;
        }
    }
}

