/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jaxodraw.gui.handle;

import java.awt.BasicStroke;
import java.awt.Color;
import net.sf.jaxodraw.gui.handle.AbstractJaxoHandle;
import net.sf.jaxodraw.util.JaxoColor;
import net.sf.jaxodraw.util.graphics.JaxoGraphics2D;

public class JaxoRoundHandle
extends AbstractJaxoHandle {
    public JaxoRoundHandle() {
        this.setColor(JaxoColor.GREEN);
        this.setSecondaryColor(JaxoColor.CARNATION_PINK);
        this.setFillColor(JaxoColor.YELLOW);
        this.setSize(20);
        this.setStroke(new BasicStroke(2.0f));
    }

    public void paint(JaxoGraphics2D g2, int x, int y, boolean marked, Color handleColor) {
        int handleSize = this.getSize();
        int h2 = handleSize / 2;
        if (marked) {
            g2.setColor(this.getFillColor());
            g2.fillOval(x - h2, y - h2, handleSize, handleSize);
        }
        g2.setColor(handleColor);
        g2.setStroke(this.getStroke());
        g2.drawOval(x - h2, y - h2, handleSize, handleSize);
    }

    public boolean contains(int handleX, int handleY, int x, int y) {
        int l2 = this.getSize() / 2;
        double distX = handleX - x;
        double distY = handleY - y;
        double dist = Math.sqrt(distX * distX + distY * distY);
        return dist < (double)l2;
    }
}

