/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jaxodraw.gui.panel;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import net.sf.jaxodraw.gui.JaxoDialogs;
import net.sf.jaxodraw.gui.JaxoTab;
import net.sf.jaxodraw.gui.launch.JaxoLauncher;
import net.sf.jaxodraw.gui.menu.JaxoMenuBar;
import net.sf.jaxodraw.gui.panel.JaxoCommunicator;
import net.sf.jaxodraw.gui.panel.JaxoGlassPane;
import net.sf.jaxodraw.gui.panel.JaxoGridBar;
import net.sf.jaxodraw.gui.panel.JaxoLookAndFeelPanel;
import net.sf.jaxodraw.gui.panel.JaxoPluginManagerPanel;
import net.sf.jaxodraw.gui.panel.JaxoPrefsPanel;
import net.sf.jaxodraw.gui.panel.JaxoStatusBar;
import net.sf.jaxodraw.gui.panel.JaxoTabbedCanvasPanel;
import net.sf.jaxodraw.gui.panel.JaxoToolBar;
import net.sf.jaxodraw.gui.panel.button.JaxoButtonPanel;
import net.sf.jaxodraw.util.JaxoColor;
import net.sf.jaxodraw.util.JaxoConstants;
import net.sf.jaxodraw.util.JaxoInfo;
import net.sf.jaxodraw.util.JaxoLanguage;
import net.sf.jaxodraw.util.JaxoLocalized;
import net.sf.jaxodraw.util.JaxoLog;
import net.sf.jaxodraw.util.JaxoLooknFeel;
import net.sf.jaxodraw.util.JaxoPrefs;
import net.sf.jaxodraw.util.JaxoUtils;

public final class JaxoMainPanel
extends JFrame
implements JaxoCommunicator,
JaxoLocalized {
    private static final long serialVersionUID = 7526471155622776147L;
    private final JaxoButtonPanel buttonPanel;
    private final JaxoMenuBar jaxomenubar;
    private final JaxoToolBar toolBar;
    private final JaxoStatusBar statusBar;
    private final JaxoGridBar gridBar;
    private JaxoPrefsPanel preferencesPanel;
    private transient JaxoPluginManagerPanel pluginManagerPanel;
    private final transient JaxoTabbedCanvasPanel canvasPanel;

    public JaxoMainPanel() {
        this((String[])null);
    }

    public JaxoMainPanel(String[] inputFileNames) {
        this.applyLookAndFeel(this.getLookAndFeelClassName(), false);
        JaxoLooknFeel.applyLocale(JaxoLanguage.locale());
        this.buttonPanel = new JaxoButtonPanel(this);
        this.addPropertyChangeListener(this.buttonPanel);
        this.toolBar = new JaxoToolBar(this);
        this.addPropertyChangeListener("Jaxo.watchMode", this.toolBar);
        this.jaxomenubar = new JaxoMenuBar(this);
        this.addPropertyChangeListener(this.jaxomenubar);
        this.canvasPanel = new JaxoTabbedCanvasPanel(this, this);
        this.addPropertyChangeListener(this.canvasPanel);
        this.addPropertyChangeListener(this.canvasPanel.getCanvas());
        this.statusBar = new JaxoStatusBar(this.canvasPanel.getSelectedTab());
        this.addPropertyChangeListener(this.statusBar);
        this.canvasPanel.getCanvas().addPropertyChangeListener(this.statusBar);
        this.gridBar = new JaxoGridBar(this);
        this.addPropertyChangeListener(this.gridBar);
        this.setGlassPane(new JaxoGlassPane(this, (JComponent)this.canvasPanel.getCanvas().asComponent()));
        ((JPanel)this.getContentPane()).setBorder(JaxoButtonPanel.RAISED_ETCHED_BORDER);
        this.getContentPane().add((Component)this.getBarsPanel(this.toolBar, this.gridBar), "First");
        this.getContentPane().add((Component)this.canvasPanel.getRoot(), "Center");
        this.setJMenuBar(this.jaxomenubar);
        this.getContentPane().add((Component)this.buttonPanel, "Before");
        this.getContentPane().add((Component)this.statusBar, "Last");
        this.setupInitialState();
        this.applyPrefs();
        this.setIconImage(JaxoUtils.newImage("frame.png"));
        this.setTitle(JaxoInfo.VERSION);
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent we) {
                JaxoMainPanel.this.canvasPanel.performAction(3163);
            }
        });
        this.addWindowFocusListener(new WindowAdapter(){

            public void windowLostFocus(WindowEvent e) {
                JaxoMainPanel.this.firePropertyChange("Jaxo.mouseLocation", null, null);
                JaxoMainPanel.this.firePropertyChange("Jaxo.mainPanelFocused", true, false);
            }

            public void windowGainedFocus(WindowEvent e) {
                JaxoMainPanel.this.firePropertyChange("Jaxo.mainPanelFocused", false, true);
            }
        });
        this.openOrImport(inputFileNames);
    }

    public void distributePropertyChange(String name, Object oldValue, Object newValue) {
        this.firePropertyChange(name, oldValue, newValue);
    }

    public void distributePropertyChange(String name, boolean oldValue, boolean newValue) {
        this.firePropertyChange(name, oldValue, newValue);
    }

    public void distributePropertyChange(String name, int oldValue, int newValue) {
        this.firePropertyChange(name, oldValue, newValue);
    }

    private String getLookAndFeelClassName() {
        return JaxoPrefs.getStringPref("prefLOOKNFEEL");
    }

    private void openOrImport(String[] inputFileNames) {
        if (inputFileNames == null) {
            return;
        }
        for (int i = 0; i < inputFileNames.length; ++i) {
            JaxoLog.info(JaxoLanguage.message("Reading_file__0", inputFileNames[i]));
            this.canvasPanel.openOrImport(inputFileNames[i]);
        }
    }

    private void setLanguage(String languageString) {
        String old = JaxoPrefs.getStringPref("prefLANGUAGE");
        if (!languageString.equals(old)) {
            Dimension oldPreferredSize = this.getPreferredSize();
            JaxoPrefs.setStringPref("prefLANGUAGE", languageString);
            this.updateLanguage();
            this.firePropertyChange("Jaxo.language", old, languageString);
            Dimension d = this.getSize();
            Dimension s = this.getPreferredSize();
            if (d.width >= oldPreferredSize.width) {
                d.width = Math.max(d.width, s.width);
            }
            if (d.height >= oldPreferredSize.height) {
                d.height = Math.max(d.height, s.height);
            }
            this.setSize(d.width, d.height);
        }
    }

    public void updateLanguage() {
        this.jaxomenubar.updateLanguage();
        this.gridBar.updateLanguage();
        this.toolBar.updateLanguage();
        this.buttonPanel.updateLanguage();
        this.statusBar.updateLanguage();
        this.canvasPanel.updateLanguage();
        if (this.preferencesPanel != null) {
            this.preferencesPanel.dispose();
            this.preferencesPanel = null;
        }
        if (this.pluginManagerPanel != null) {
            this.pluginManagerPanel.updateLanguage();
        }
        JaxoLooknFeel.applyLocale(JaxoLanguage.locale());
    }

    private void optionEvent(int i) {
        switch (i) {
            case 5182: {
                this.setToolBarVisible(!this.toolBar.isVisible());
                break;
            }
            case 5183: {
                this.setStatusBarVisible(!this.statusBar.isVisible());
                break;
            }
            case 5190: {
                this.setGridBarVisible(!this.gridBar.isVisible());
                break;
            }
            case 5184: {
                this.setAntialiasEnabled(!this.canvasPanel.isAntialiasEnabled());
                break;
            }
            case 5185: {
                this.setWithArrow(!JaxoPrefs.getBooleanPref("prefARROW"));
                break;
            }
            case 5189: {
                this.setGridOn(!this.canvasPanel.getSelectedTab().getGrid().isPainted());
                break;
            }
            case 5191: {
                this.setSnap(!this.canvasPanel.getSelectedTab().isSnappingToGrid());
                break;
            }
            case 5187: {
                JaxoLookAndFeelPanel laf = new JaxoLookAndFeelPanel();
                laf.setToUIManagerValue();
                JaxoDialogs.showMiniDialog(this, JaxoLanguage.translate("Look_And_Feel"), laf.getRoot(), new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        JaxoMainPanel.this.applyLookAndFeel(JaxoMainPanel.this.getLookAndFeelClassName(), true);
                    }
                });
                break;
            }
            case 5188: {
                if (this.preferencesPanel == null) {
                    this.preferencesPanel = new JaxoPrefsPanel(this);
                    this.preferencesPanel.addComponentListener(new ComponentAdapter(){

                        public void componentHidden(ComponentEvent e) {
                            JaxoMainPanel.this.applyPrefs();
                        }
                    });
                }
                this.preferencesPanel.setFromPrefs();
                this.preferencesPanel.setVisible(true);
                break;
            }
            case 5192: {
                if (this.pluginManagerPanel == null) {
                    this.pluginManagerPanel = new JaxoPluginManagerPanel(this);
                }
                this.pluginManagerPanel.setVisible(true);
                break;
            }
        }
    }

    private void setupInitialState() {
        this.toolBar.setVisible(JaxoPrefs.getBooleanPref("prefSHOWTOOL"));
        this.statusBar.setVisible(JaxoPrefs.getBooleanPref("prefSHOWSTATUS"));
        this.gridBar.setVisible(JaxoPrefs.getBooleanPref("prefSHOWGRIDBAR"));
        this.firePropertyChange("Jaxo.gridOn", true, JaxoPrefs.getBooleanPref("prefGRIDONOFF"));
        this.firePropertyChange("Jaxo.snap", false, JaxoPrefs.getBooleanPref("prefSNAPONOFF"));
        this.firePropertyChange("Jaxo.antialiasEnabled", false, JaxoPrefs.getBooleanPref("prefANTIALIAS"));
        this.firePropertyChange("selectedTab", null, this.canvasPanel.getSelectedTab());
    }

    private void applyPrefs() {
        this.setLanguage(JaxoPrefs.getStringPref("prefLANGUAGE"));
        this.setToolBarVisible(JaxoPrefs.getBooleanPref("prefSHOWTOOL"));
        this.setStatusBarVisible(JaxoPrefs.getBooleanPref("prefSHOWSTATUS"));
        this.setGridBarVisible(JaxoPrefs.getBooleanPref("prefSHOWGRIDBAR"));
        this.setGridOn(JaxoPrefs.getBooleanPref("prefGRIDONOFF"));
        this.setSnap(JaxoPrefs.getBooleanPref("prefSNAPONOFF"));
        this.setAntialiasEnabled(JaxoPrefs.getBooleanPref("prefANTIALIAS"));
        this.setWithArrow(JaxoPrefs.getBooleanPref("prefARROW"));
        this.setDefaultAction(JaxoPrefs.getIntPref("prefDEFAULTACTION"));
        this.buttonPanel.setDefault(this.getDefaultMode());
        this.setCanvasBackground(JaxoColor.getColor(JaxoPrefs.getStringPref("prefCANVASBACKGROUND"), 2));
        this.canvasPanel.getCanvas().setMinimumCanvasSize(new Dimension(JaxoPrefs.getIntPref("prefSCREENSIZEX"), JaxoPrefs.getIntPref("prefSCREENSIZEY")));
        this.canvasPanel.getCanvas().setMaximumCanvasSize(JaxoInfo.SCREEN_SIZE);
        this.applyLookAndFeel(this.getLookAndFeelClassName(), false);
    }

    private void applyLookAndFeel(String lookAndFeelClassName, boolean warning) {
        boolean success = JaxoLooknFeel.applyLookAndFeel(lookAndFeelClassName);
        if (!success && warning) {
            String message = JaxoLooknFeel.info(lookAndFeelClassName).getName() + JaxoLanguage.translate("_Look_and_Feel_is_not_supported_on_this_platform!");
            JaxoDialogs.showErrorDialog(null, message);
        }
    }

    private void setCanvasBackground(Color value) {
        this.firePropertyChange("Jaxo.canvasBackground", null, value);
    }

    private void setToolBarVisible(boolean show) {
        if (show != this.toolBar.isVisible()) {
            this.toolBar.setVisible(show);
            this.firePropertyChange("Jaxo.toolBarVisible", !show, show);
        }
    }

    private void setStatusBarVisible(boolean show) {
        if (show != this.statusBar.isVisible()) {
            this.statusBar.setVisible(show);
            this.firePropertyChange("Jaxo.statusBarVisible", !show, show);
        }
    }

    private void setGridBarVisible(boolean show) {
        if (show != this.gridBar.isVisible()) {
            this.gridBar.setVisible(show);
            this.firePropertyChange("Jaxo.gridBarVisible", !show, show);
        }
    }

    private void setAntialiasEnabled(boolean on) {
        if (on != this.canvasPanel.isAntialiasEnabled()) {
            this.canvasPanel.setAntialiasEnabled(on);
            this.firePropertyChange("Jaxo.antialiasEnabled", !on, on);
        }
    }

    private void setGridOn(boolean on) {
        this.firePropertyChange("Jaxo.gridOn", !on, on);
    }

    private void setWithArrow(boolean on) {
        if (on != JaxoPrefs.getBooleanPref("prefARROW")) {
            this.firePropertyChange("Jaxo.withArrow", !on, on);
            JaxoPrefs.setBooleanPref("prefARROW", on);
        }
    }

    private void setSnap(boolean setSnap) {
        this.firePropertyChange("Jaxo.snap", !setSnap, setSnap);
    }

    private int getDefaultMode() {
        return JaxoConstants.defaultActionToMode(JaxoPrefs.getIntPref("prefDEFAULTACTION"));
    }

    private void setDefaultAction(int value) {
        int old;
        int newValue = value;
        if (!JaxoConstants.isDefaultMode(newValue)) {
            newValue = 6201;
        }
        if (newValue != (old = JaxoPrefs.getIntPref("prefDEFAULTACTION"))) {
            int oldMode = this.getDefaultMode();
            JaxoPrefs.setIntPref("prefDEFAULTACTION", newValue);
            this.firePropertyChange("Jaxo.defaultAction", old, newValue);
            this.firePropertyChange("Jaxo.defaultMode", oldMode, this.getDefaultMode());
        }
    }

    private void addRecentFile(String saveFileName) {
        this.firePropertyChange("Jaxo.recentFile", null, saveFileName);
    }

    private void removeRecentFile(String saveFileName) {
        this.firePropertyChange("Jaxo.recentFile", saveFileName, null);
    }

    public void actionPerformed(ActionEvent evt) {
        if ("setGlassPaneVisible".equals(evt.getActionCommand())) {
            this.getGlassPane().setVisible(true);
            return;
        }
        if ("setGlassPaneInvisible".equals(evt.getActionCommand())) {
            this.getGlassPane().setVisible(false);
            return;
        }
        Component source = (Component)evt.getSource();
        int mode = JaxoConstants.getModeAsInt(evt.getActionCommand());
        if (mode == 685) {
            AbstractButton sourceButton = (AbstractButton)source;
            String fileName = sourceButton.getName();
            JaxoTab t = this.canvasPanel.getTabWithSaveFileName(fileName);
            if (t != null) {
                this.canvasPanel.setSelectedTab(t);
                this.addRecentFile(fileName);
                return;
            }
            this.canvasPanel.openOrImport(fileName);
            t = this.canvasPanel.getTabWithSaveFileName(fileName);
            if (t == null) {
                this.removeRecentFile(fileName);
            }
        } else {
            this.performAction(mode);
        }
    }

    private void performAction(int mode) {
        if (JaxoConstants.isZoomFactorMode(mode)) {
            this.firePropertyChange("zoomFactor", -1, mode);
        } else if (JaxoConstants.isLanguageMode(mode)) {
            this.setLanguage(JaxoLanguage.getLanguageFor(mode));
        } else if (JaxoConstants.isOptionMode(mode)) {
            this.optionEvent(mode);
        } else if (JaxoConstants.isDefaultMode(mode)) {
            this.setDefaultAction(mode);
        } else {
            this.canvasPanel.performAction(mode);
        }
    }

    public void shutdown(int exitStatus) {
        if (exitStatus == 0) {
            try {
                JaxoPrefs.saveRecentFiles();
            }
            catch (Exception e) {
                JaxoLog.debug(e);
                JaxoDialogs.showI18NErrorDialog(this, "Cannot_save_preferences!");
            }
        }
        this.setVisible(false);
        this.dispose();
        JaxoLauncher.shutdown(exitStatus);
    }

    private JPanel getBarsPanel(JaxoToolBar tB, JaxoGridBar gB) {
        JPanel barP = JaxoDialogs.newPageBoxLayoutPanel();
        barP.add(tB);
        barP.add(gB);
        return barP;
    }
}

