/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jaxodraw.gui.panel;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.Map;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.sf.jaxodraw.gui.JaxoTab;
import net.sf.jaxodraw.gui.panel.button.JaxoButtonPanel;
import net.sf.jaxodraw.io.JaxoIO;
import net.sf.jaxodraw.util.JaxoDictionary;
import net.sf.jaxodraw.util.JaxoLocalized;

public class JaxoStatusBar
extends JPanel
implements JaxoLocalized,
PropertyChangeListener,
ChangeListener {
    private static final JaxoDictionary LANGUAGE = new JaxoDictionary(JaxoStatusBar.class);
    private static final long serialVersionUID = 7526471155622776147L;
    private static final String VERTEX = "/Vertex";
    private static final Map<Integer, String> MODE_KEYS = new HashMap<Integer, String>(44);
    private static final int MAX_NAME_LENGTH = 46;
    private final JLabel controlFlag;
    private final JLabel coordFlag;
    private final JLabel fileFlag;
    private String currentFile = "";
    private String currentModeKey = "";

    public JaxoStatusBar() {
        this((JaxoTab)null);
    }

    public JaxoStatusBar(JaxoTab tab) {
        super(null, false);
        this.setLayout(new BoxLayout(this, 2));
        this.controlFlag = new JLabel(this.currentModeKey, 0);
        JPanel controlFlagPanel = new JPanel(new BorderLayout(), false);
        controlFlagPanel.add((Component)this.controlFlag, "Center");
        controlFlagPanel.setBorder(JaxoButtonPanel.RAISED_ETCHED_BORDER);
        controlFlagPanel.setMinimumSize(new Dimension(270, 30));
        controlFlagPanel.setPreferredSize(new Dimension(270, 30));
        this.coordFlag = new JLabel("", 0);
        JPanel coordFlagPanel = new JPanel(new BorderLayout(), false);
        coordFlagPanel.add((Component)this.coordFlag, "Center");
        coordFlagPanel.setBorder(JaxoButtonPanel.RAISED_ETCHED_BORDER);
        coordFlagPanel.setMinimumSize(new Dimension(170, 30));
        coordFlagPanel.setPreferredSize(new Dimension(170, 30));
        this.fileFlag = new JLabel(this.currentFile, 0);
        JPanel fileFlagPanel = new JPanel(new BorderLayout(), false);
        fileFlagPanel.add((Component)this.fileFlag, "Center");
        fileFlagPanel.setBorder(JaxoButtonPanel.RAISED_ETCHED_BORDER);
        fileFlagPanel.setMinimumSize(new Dimension(390, 30));
        fileFlagPanel.setPreferredSize(new Dimension(490, 30));
        this.add(fileFlagPanel);
        this.add(controlFlagPanel);
        this.add(coordFlagPanel);
        if (tab != null) {
            tab.addChangeListener(this);
            this.currentFile = tab.getSaveFileName();
        }
        this.updateFileFlagText();
        this.updateCurrentModeText();
        this.updateMouseLocation(null);
    }

    public void propertyChange(PropertyChangeEvent e) {
        String name = e.getPropertyName();
        if ("Jaxo.mouseLocation".equals(name)) {
            this.updateMouseLocation((Point)e.getNewValue());
        } else if ("Jaxo.mode".equals(name)) {
            this.currentModeKey = MODE_KEYS.get((Integer)e.getNewValue());
            this.updateCurrentModeText();
        } else if ("Jaxo.selectedTab".equals(name)) {
            JaxoTab t;
            JaxoTab old = (JaxoTab)e.getOldValue();
            if (old != null) {
                old.removeChangeListener(this);
            }
            if ((t = (JaxoTab)e.getNewValue()) != null) {
                t.addChangeListener(this);
                this.currentFile = t.getSaveFileName();
            }
            this.updateFileFlagText();
        }
    }

    public void stateChanged(ChangeEvent e) {
        if (e.getSource() instanceof JaxoTab) {
            this.currentFile = ((JaxoTab)e.getSource()).getSaveFileName();
            this.updateFileFlagText();
        }
    }

    public String getCurrentModeText() {
        return this.controlFlag.getText();
    }

    public String getCurrentFileText() {
        return this.fileFlag.getText();
    }

    public String getCurrentCoordinateText() {
        return this.coordFlag.getText();
    }

    public final void updateLanguage() {
        this.updateFileFlagText();
        this.updateCurrentModeText();
    }

    private void updateCurrentModeText() {
        String noControl = LANGUAGE.value("mode_none");
        String currentModeText = LANGUAGE.value(this.currentModeKey);
        this.controlFlag.setText("".equals(currentModeText) ? noControl : LANGUAGE.message("mode%0", currentModeText));
    }

    private void updateMouseLocation(Point value) {
        String noMouseCoordinates = LANGUAGE.value("mouseCoordinates_none");
        this.coordFlag.setText(value == null ? noMouseCoordinates : LANGUAGE.message("mouseCoordinates%0%1", value.x, value.y));
    }

    private void updateFileFlagText() {
        String filename = this.currentFile;
        filename = filename.length() == 0 ? JaxoIO.currentDirectoryString() : JaxoIO.directoryString(filename);
        if (filename.length() > 46) {
            this.fileFlag.setText(LANGUAGE.message("directory%0ending", filename.substring(filename.length() - 46)));
        } else {
            this.fileFlag.setText(LANGUAGE.message("directory%0", filename));
        }
    }

    static {
        MODE_KEYS.put(0, "");
        MODE_KEYS.put(3, "/Fermion_Line");
        MODE_KEYS.put(4, "/Fermion_Loop");
        MODE_KEYS.put(5, "/Fermion_Arc");
        MODE_KEYS.put(18, "/Fermion_Bezier");
        MODE_KEYS.put(6, "/Scalar_Line");
        MODE_KEYS.put(7, "/Scalar_Loop");
        MODE_KEYS.put(8, "/Scalar_Arc");
        MODE_KEYS.put(21, "/Scalar_Bezier");
        MODE_KEYS.put(9, "/Ghost_Line");
        MODE_KEYS.put(10, "/Ghost_Loop");
        MODE_KEYS.put(11, "/Ghost_Arc");
        MODE_KEYS.put(22, "/Ghost_Bezier");
        MODE_KEYS.put(12, "/Photon_Line");
        MODE_KEYS.put(13, "/Photon_Loop");
        MODE_KEYS.put(14, "/Photon_Arc");
        MODE_KEYS.put(19, "/Photon_Bezier");
        MODE_KEYS.put(15, "/Gluon_Line");
        MODE_KEYS.put(16, "/Gluon_Loop");
        MODE_KEYS.put(17, "/Gluon_Arc");
        MODE_KEYS.put(20, "/Gluon_Bezier");
        MODE_KEYS.put(450, "/Move");
        MODE_KEYS.put(451, "/Resize");
        MODE_KEYS.put(453, "/Color");
        MODE_KEYS.put(454, "/Edit");
        MODE_KEYS.put(452, "/Duplicate");
        MODE_KEYS.put(456, "/Background");
        MODE_KEYS.put(457, "/Foreground");
        MODE_KEYS.put(455, "/Delete");
        MODE_KEYS.put(459, "/Ungroup");
        MODE_KEYS.put(460, "/Select");
        MODE_KEYS.put(3162, "/Zoom");
        MODE_KEYS.put(233, "/Zigzag");
        MODE_KEYS.put(230, "/Box");
        MODE_KEYS.put(231, "/Blob");
        MODE_KEYS.put(232, VERTEX);
        MODE_KEYS.put(336, VERTEX);
        MODE_KEYS.put(337, VERTEX);
        MODE_KEYS.put(338, VERTEX);
        MODE_KEYS.put(339, VERTEX);
        MODE_KEYS.put(340, VERTEX);
        MODE_KEYS.put(341, VERTEX);
        MODE_KEYS.put(234, "/Text");
        MODE_KEYS.put(235, "/LaTex");
    }
}

