/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jaxodraw.gui.panel.button;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JPanel;
import net.sf.jaxodraw.gui.panel.button.JaxoButtonPanel;
import net.sf.jaxodraw.gui.panel.button.JaxoPanelButton;
import net.sf.jaxodraw.util.JaxoConstants;
import net.sf.jaxodraw.util.JaxoLanguage;
import net.sf.jaxodraw.util.JaxoLocalized;
import net.sf.jaxodraw.util.JaxoUtils;

public class JaxoActionButtons
extends JPanel
implements PropertyChangeListener,
JaxoLocalized {
    private static final long serialVersionUID = 7526471155622776147L;
    private static final String[] ACTION_BUTTON_ICONS = new String[]{"undo.png", "redo.png", "clear.png", "refresh.png"};
    private static final int[] ACTION_MODES = new int[]{1101, 1103, 1102, 1104};
    private static final int NOF_BUTTONS = ACTION_MODES.length;
    private static final String[] TOOLTIP_KEYS = new String[]{"Undo_the_last_operation", "Redo_the_last_operation", "Clear_the_screen", "Refresh_the_Screen"};
    private final JaxoPanelButton[] actionButtons = new JaxoPanelButton[NOF_BUTTONS];

    public JaxoActionButtons() {
        super(new GridBagLayout());
        for (int i = 0; i < NOF_BUTTONS; ++i) {
            this.actionButtons[i] = new JaxoPanelButton();
            this.actionButtons[i].setIcon(JaxoUtils.newImageIcon(ACTION_BUTTON_ICONS[i]));
            this.actionButtons[i].setToolTipText(JaxoLanguage.translate(TOOLTIP_KEYS[i]));
            this.actionButtons[i].setId(JaxoConstants.getModeAsString(ACTION_MODES[i]));
        }
        GridBagConstraints c = (GridBagConstraints)JaxoButtonPanel.BUTTON_CONSTRAINTS.clone();
        for (int y = 0; y < 1; ++y) {
            for (int x = 0; x < 4; ++x) {
                c.gridx = x;
                c.gridy = y;
                this.add((Component)this.actionButtons[x + 4 * y], c);
            }
        }
        this.actionButtons[0].setEnabled(false);
        this.actionButtons[1].setEnabled(false);
    }

    public void propertyChange(PropertyChangeEvent e) {
        String name = e.getPropertyName();
        if ("Jaxo.canUndo".equals(name)) {
            this.actionButtons[0].setEnabled(Boolean.TRUE.equals(e.getNewValue()));
        } else if ("Jaxo.canRedo".equals(name)) {
            this.actionButtons[1].setEnabled(Boolean.TRUE.equals(e.getNewValue()));
        }
    }

    public final void addActionListener(ActionListener l) {
        for (int i = 0; i < NOF_BUTTONS; ++i) {
            this.actionButtons[i].addActionListener(l);
        }
    }

    public final void updateLanguage() {
        for (int i = 0; i < NOF_BUTTONS; ++i) {
            this.actionButtons[i].setToolTipText(JaxoLanguage.translate(TOOLTIP_KEYS[i]));
        }
    }
}

