/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jaxodraw.gui.panel.button;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.LayoutManager2;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.border.EtchedBorder;
import net.sf.jaxodraw.gui.panel.button.JaxoActionButtons;
import net.sf.jaxodraw.gui.panel.button.JaxoEditButtons;
import net.sf.jaxodraw.gui.panel.button.JaxoGridButtons;
import net.sf.jaxodraw.gui.panel.button.JaxoMiscButtons;
import net.sf.jaxodraw.gui.panel.button.JaxoPanelButton;
import net.sf.jaxodraw.gui.panel.button.JaxoParticleButtons;
import net.sf.jaxodraw.util.JaxoLocalized;

public class JaxoButtonPanel
extends JPanel
implements PropertyChangeListener,
JaxoLocalized {
    private static final long serialVersionUID = 7526471155622776147L;
    public static final EtchedBorder RAISED_ETCHED_BORDER = (EtchedBorder)BorderFactory.createEtchedBorder(0);
    public static final GridBagConstraints BUTTON_CONSTRAINTS = new GridBagConstraints();
    private final JaxoParticleButtons pbtpanel;
    private final JaxoEditButtons ebtpanel;
    private final JaxoMiscButtons mbtpanel;
    private final JaxoActionButtons abtpanel;
    private final JaxoGridButtons gbtpanel;

    public JaxoButtonPanel(ActionListener l) {
        super(null, false);
        int paddingWidth = JaxoPanelButton.getButtonHeight() / 6;
        int paddingHeight = JaxoPanelButton.getButtonHeight() / 4;
        this.setLayout(new ButtonPanelLayout(paddingHeight * 2));
        this.setBorder(BorderFactory.createCompoundBorder(RAISED_ETCHED_BORDER, BorderFactory.createEmptyBorder(paddingHeight, paddingWidth, paddingHeight, paddingWidth)));
        this.pbtpanel = (JaxoParticleButtons)this.add(new JaxoParticleButtons());
        this.mbtpanel = (JaxoMiscButtons)this.add(new JaxoMiscButtons());
        this.abtpanel = (JaxoActionButtons)this.add(new JaxoActionButtons());
        this.ebtpanel = (JaxoEditButtons)this.add(new JaxoEditButtons());
        this.gbtpanel = (JaxoGridButtons)this.add(new JaxoGridButtons());
        this.setDefault(0);
        this.addPropertyChangeListeners();
        this.addActionListener(l);
    }

    protected void paintBorder(Graphics g) {
        super.paintBorder(g);
        boolean first = true;
        int width = this.getWidth();
        int lastY = 0;
        for (int i = 0; i < this.getComponentCount(); ++i) {
            Component c = this.getComponent(i);
            if (!c.isVisible()) continue;
            if (first) {
                first = false;
            } else {
                int y = (c.getY() + lastY) / 2;
                g.setColor(RAISED_ETCHED_BORDER.getHighlightColor(this));
                g.drawLine(1, y, width - 3, y);
                g.setColor(RAISED_ETCHED_BORDER.getShadowColor(this));
                g.drawLine(2, y + 1, width - 3, y + 1);
            }
            lastY = c.getY() + c.getHeight();
        }
    }

    public void propertyChange(PropertyChangeEvent e) {
        if (e.getPropertyName().equals("Jaxo.mode")) {
            this.pressButton((Integer)e.getNewValue());
        } else if (e.getPropertyName().equals("Jaxo.defaultMode")) {
            this.setDefault((Integer)e.getNewValue());
        } else {
            this.firePropertyChange(e.getPropertyName(), e.getOldValue(), e.getNewValue());
        }
    }

    private void addActionListener(ActionListener l) {
        this.pbtpanel.addActionListener(l);
        this.mbtpanel.addActionListener(l);
        this.abtpanel.addActionListener(l);
        this.ebtpanel.addActionListener(l);
        this.gbtpanel.addActionListener(l);
    }

    public final void updateLanguage() {
        this.pbtpanel.updateLanguage();
        this.mbtpanel.updateLanguage();
        this.abtpanel.updateLanguage();
        this.ebtpanel.updateLanguage();
        this.gbtpanel.updateLanguage();
    }

    public final void setDefault(int mode) {
        this.ebtpanel.setDefault(mode);
        this.pbtpanel.setDefault(mode);
        this.mbtpanel.setDefault(mode);
        this.gbtpanel.setDefault(mode);
    }

    public final void pressButton(int mode) {
        this.ebtpanel.pressButton(mode);
        this.pbtpanel.pressButton(mode);
        this.mbtpanel.pressButton(mode);
        this.gbtpanel.pressButton(mode);
    }

    private void addPropertyChangeListeners() {
        this.addPropertyChangeListener("Jaxo.vertexType", this.mbtpanel);
        this.addPropertyChangeListener(this.abtpanel);
        this.addPropertyChangeListener(this.gbtpanel);
    }

    private static class ButtonPanelLayout
    implements LayoutManager2 {
        private final int gap;

        ButtonPanelLayout(int newGap) {
            this.gap = newGap;
        }

        public float getLayoutAlignmentX(Container p) {
            return 0.5f;
        }

        public float getLayoutAlignmentY(Container p) {
            return 0.5f;
        }

        public Dimension minimumLayoutSize(Container p) {
            return this.preferredLayoutSize(p);
        }

        public Dimension maximumLayoutSize(Container p) {
            return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
        }

        public void addLayoutComponent(String constraints, Component c) {
        }

        public void addLayoutComponent(Component c, Object constraints) {
        }

        public void removeLayoutComponent(Component c) {
        }

        public void invalidateLayout(Container p) {
        }

        public Dimension preferredLayoutSize(Container p) {
            Dimension result = new Dimension();
            int count = 0;
            for (int i = 0; i < p.getComponentCount(); ++i) {
                Component c = p.getComponent(i);
                if (!c.isVisible()) continue;
                ++count;
                Dimension d = c.getPreferredSize();
                result.width = Math.max(result.width, d.width);
                result.height += d.height;
            }
            if (count > 0) {
                result.height += this.gap * (count - 1);
            }
            Insets n = p.getInsets();
            result.width += n.left + n.right;
            result.height += n.top + n.bottom;
            return result;
        }

        public void layoutContainer(Container p) {
            Insets n = p.getInsets();
            int x = n.left;
            int y = n.top;
            int width = p.getWidth() - n.left - n.right;
            for (int i = 0; i < p.getComponentCount(); ++i) {
                Component c = p.getComponent(i);
                if (!c.isVisible()) continue;
                Dimension d = c.getPreferredSize();
                c.setBounds(x, y, width, d.height);
                y += d.height + this.gap;
            }
        }
    }
}

