/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jaxodraw.gui.panel.button;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JPanel;
import net.sf.jaxodraw.gui.menu.popup.JaxoZoomPopupMenu;
import net.sf.jaxodraw.gui.panel.button.JaxoButtonPanel;
import net.sf.jaxodraw.gui.panel.button.JaxoPanelButton;
import net.sf.jaxodraw.util.JaxoConstants;
import net.sf.jaxodraw.util.JaxoLanguage;
import net.sf.jaxodraw.util.JaxoLocalized;
import net.sf.jaxodraw.util.JaxoUtils;

public class JaxoGridButtons
extends JPanel
implements MouseListener,
PropertyChangeListener,
JaxoLocalized {
    private static final long serialVersionUID = 7526471155622776147L;
    private static final String[] GRID_BUTTON_ICONS = new String[]{"snap.png", "viewmag1.png", "empty.png", "exit.png"};
    private static final int[] GRID_MODES = new int[]{3161, 3162, 10000, 3163};
    private static final int NOF_BUTTONS = GRID_MODES.length;
    private static final String[] TOOLTIP_KEYS = new String[]{"Snap_points_to_the_grid", "Dynamical_zoom", "", "Exits_JaxoDraw"};
    private final JaxoPanelButton[] gridButtons = new JaxoPanelButton[NOF_BUTTONS];
    private final JaxoZoomPopupMenu zoomPopup;

    public JaxoGridButtons() {
        super(new GridBagLayout());
        for (int i = 0; i < NOF_BUTTONS; ++i) {
            this.gridButtons[i] = new JaxoPanelButton();
            this.gridButtons[i].setIcon(JaxoUtils.newImageIcon(GRID_BUTTON_ICONS[i]));
            this.gridButtons[i].setToolTipText(JaxoLanguage.translate(TOOLTIP_KEYS[i]));
            this.gridButtons[i].setId(JaxoConstants.getModeAsString(GRID_MODES[i]));
        }
        GridBagConstraints c = (GridBagConstraints)JaxoButtonPanel.BUTTON_CONSTRAINTS.clone();
        for (int y = 0; y < 1; ++y) {
            for (int x = 0; x < 4; ++x) {
                c.gridx = x;
                c.gridy = y;
                this.add((Component)this.gridButtons[x + 4 * y], c);
            }
        }
        this.zoomPopup = new JaxoZoomPopupMenu();
        this.gridButtons[0].addMouseListener(this);
        this.gridButtons[1].addMouseListener(this);
        this.updateGrid(false);
        this.updateSnap(false);
        this.gridButtons[2].setEnabled(false);
    }

    public void propertyChange(PropertyChangeEvent e) {
        String name = e.getPropertyName();
        if ("Jaxo.gridOn".equals(name)) {
            this.updateGrid(Boolean.TRUE.equals(e.getNewValue()));
        } else if ("Jaxo.snap".equals(name)) {
            this.updateSnap(Boolean.TRUE.equals(e.getNewValue()));
        }
    }

    public final void addActionListener(ActionListener l) {
        for (int i = 0; i < NOF_BUTTONS; ++i) {
            this.gridButtons[i].addActionListener(l);
        }
        this.zoomPopup.addActionListener(l);
    }

    private void updateGrid(boolean on) {
        this.gridButtons[this.getIndex(3161)].setEnabled(on);
    }

    private void updateSnap(boolean on) {
        this.gridButtons[this.getIndex(3161)].setSelected(on);
    }

    private void unsetButtons() {
        this.gridButtons[this.getIndex(3162)].setSelected(false);
    }

    private int getIndex(int i) {
        int j = -1;
        if (i == 3161) {
            j = 0;
        } else if (i == 3162) {
            j = 1;
        } else if (i == 3163) {
            j = 3;
        }
        return j;
    }

    public final void setDefault(int mode) {
        this.resetDefault();
        if (JaxoConstants.isGridMode(mode)) {
            int j = this.getIndex(mode);
            this.gridButtons[j].setDefault(true);
        }
    }

    private void resetDefault() {
        for (int i = 0; i < NOF_BUTTONS; ++i) {
            this.gridButtons[i].setDefault(false);
        }
    }

    public final void pressButton(int mode) {
        this.unsetButtons();
        if (JaxoConstants.isGridMode(mode) && mode != 3163) {
            int j = this.getIndex(mode);
            this.gridButtons[j].setSelected(true);
        }
    }

    public final void updateLanguage() {
        for (int i = 0; i < NOF_BUTTONS; ++i) {
            this.gridButtons[i].setToolTipText(JaxoLanguage.translate(TOOLTIP_KEYS[i]));
        }
        this.zoomPopup.updateLanguage();
    }

    public final void mousePressed(MouseEvent e) {
        if (JaxoUtils.isButton3(e) && e.getComponent() == this.gridButtons[1]) {
            this.zoomPopup.show(e.getComponent(), e.getX(), e.getY());
        }
    }

    public final void mouseClicked(MouseEvent e) {
    }

    public final void mouseEntered(MouseEvent e) {
    }

    public final void mouseExited(MouseEvent e) {
    }

    public final void mouseReleased(MouseEvent e) {
    }
}

