/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jaxodraw.io.exports;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.io.File;
import java.io.IOException;
import java.util.Vector;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import net.sf.jaxodraw.gui.panel.JaxoColorChooser;
import net.sf.jaxodraw.gui.panel.button.JaxoColorButton;
import net.sf.jaxodraw.io.JaxoPreview;
import net.sf.jaxodraw.io.exports.JaxoExport;
import net.sf.jaxodraw.plugin.JaxoPluginExecutionException;
import net.sf.jaxodraw.util.JaxoDictionary;
import net.sf.jaxodraw.util.graphics.JaxoGraphics2D;

public class JaxoExportImg
extends JaxoExport {
    private static final JaxoDictionary LANGUAGE = new JaxoDictionary(JaxoExportImg.class);
    private final Format mode;
    private Color background;
    private boolean translucent;
    private boolean antialiasing;
    private float resolution;
    private JComponent panel;
    private JTextField resolutionText;
    private JaxoColorButton backgroundButton;
    private JLabel bgColorLabel;
    private JLabel noBackgroundPaintingLabel;
    private JLabel antialiasLabel;
    private JLabel resolutionLabel;
    private JFrame previewFrame;
    private static final String PLUGIN_ID = JaxoExportImg.class.getName();
    private Dimension size;
    private Point2D origin;
    private float scale;

    public JaxoExportImg(Format exportMode) {
        this.mode = exportMode;
        this.background = Color.white;
        this.translucent = !this.mode.equals((Object)Format.JPG);
        this.resolution = 72.0f;
    }

    public final float getResolution() {
        return this.resolution;
    }

    public final void setResolution(float value) {
        this.resolution = value;
    }

    public final Format getMode() {
        return this.mode;
    }

    public final void setAntialiasing(boolean value) {
        this.antialiasing = value;
    }

    public final boolean isAntialiasing() {
        return this.antialiasing;
    }

    public final String getFormatName() {
        return LANGUAGE.value("formatName." + this.getFileExtension());
    }

    public final String getFileExtension() {
        return this.getMode().equals((Object)Format.PNG) ? "png" : "jpg";
    }

    public final String getFileExtensionDescription() {
        return LANGUAGE.value("fileDescription." + this.getFileExtension());
    }

    public String description() {
        return LANGUAGE.value("description." + this.getFileExtension());
    }

    public String pluginId() {
        return PLUGIN_ID;
    }

    public String getShortName() {
        return "img-export";
    }

    private boolean canBeTranslucent() {
        return this.getMode().equals((Object)Format.PNG);
    }

    protected void exportTo(String fileName) throws JaxoPluginExecutionException {
        try {
            File file = new File(fileName);
            ImageIO.write(this.newRenderedImage(), this.getFileExtension(), file);
        }
        catch (IOException e) {
            throw new JaxoPluginExecutionException(this.errorDialogMessage(fileName), e, this);
        }
    }

    private RenderedImage newRenderedImage() {
        this.setupImage();
        return new ExportImage(new BufferedImage(1, 1, this.translucent ? 2 : 1));
    }

    private BufferedImage newBufferedImage() {
        this.setupImage();
        BufferedImage result = new BufferedImage(this.size.width, this.size.height, this.translucent ? 2 : 1);
        this.paintToImage(result, 0);
        return result;
    }

    private void setupImage() {
        Rectangle bb = this.getGraph().getBounds();
        if (bb == null) {
            bb = new Rectangle();
        }
        int x = bb.x;
        int y = bb.y;
        int w = Math.max(1, bb.width + 1);
        int h = Math.max(1, bb.height + 1);
        this.scale = this.resolution / 72.0f;
        this.origin = new Point2D.Double((float)(-x) * this.scale, (float)(-y) * this.scale);
        this.size = new Rectangle2D.Double(0.0, 0.0, this.scale * (float)w, this.scale * (float)h).getBounds().getSize();
    }

    private void paintToImage(BufferedImage m, int dy) {
        JaxoGraphics2D g = new JaxoGraphics2D(m.createGraphics());
        g.setPrinting(true);
        if (this.antialiasing) {
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        }
        g.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
        if (this.translucent) {
            g.setColor(Color.black);
            g.setComposite(AlphaComposite.Clear);
            g.fillRect(0, 0, m.getWidth(), m.getHeight());
            g.setComposite(AlphaComposite.SrcOver);
        } else {
            g.setColor(this.background);
            g.fillRect(0, 0, m.getWidth(), m.getHeight());
        }
        g.translate(0, -dy);
        g.translate(this.origin.getX(), this.origin.getY());
        g.scale(this.scale, this.scale);
        this.getGraph().paintClipped(g);
        g.dispose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void preview(JaxoPreview p, boolean sameWindow) {
        Color oldBackground = this.background;
        boolean oldTranslucent = this.translucent;
        try {
            if (this.translucent) {
                this.translucent = false;
                this.background = Color.white;
            }
            if (!sameWindow || this.previewFrame == null) {
                this.previewFrame = new JFrame();
            }
            p.setTitle(LANGUAGE.message("preview%0Title." + this.getFileExtension(), this.getShortGraphName()));
            p.showComponent(new JLabel(new ImageIcon(this.newBufferedImage())), this.previewFrame);
        }
        finally {
            this.translucent = oldTranslucent;
            this.background = oldBackground;
        }
    }

    public void commitConfiguration() {
        this.setResolution(Float.parseFloat(this.resolutionText.getText()));
        this.background = this.backgroundButton.getColor();
    }

    public JComponent getConfigurationPanel() {
        if (this.panel == null) {
            this.panel = new JPanel(new GridBagLayout(), false);
            GridBagConstraints labels = new GridBagConstraints();
            GridBagConstraints components = new GridBagConstraints();
            labels.anchor = 22;
            labels.gridx = 0;
            labels.gridy = 0;
            components.anchor = 21;
            components.gridx = 1;
            components.gridy = 0;
            components.weightx = 1.0;
            this.backgroundButton = new JaxoColorButton(this.background);
            this.backgroundButton.setChooserMode(2);
            this.backgroundButton.setChooser(new JaxoColorChooser(this.backgroundButton));
            this.bgColorLabel = new JLabel();
            this.panel.add((Component)this.bgColorLabel, labels);
            this.panel.add((Component)this.backgroundButton, components);
            ++labels.gridy;
            ++components.gridy;
            final JCheckBox noBackgroundPainting = new JCheckBox();
            noBackgroundPainting.setSelected(true);
            this.noBackgroundPaintingLabel = new JLabel();
            if (this.canBeTranslucent()) {
                this.panel.add((Component)this.noBackgroundPaintingLabel, labels);
                this.panel.add((Component)noBackgroundPainting, components);
            }
            ++labels.gridy;
            ++components.gridy;
            noBackgroundPainting.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    JaxoExportImg.this.translucent = noBackgroundPainting.isSelected();
                }
            });
            final JCheckBox antialiasingBox = new JCheckBox();
            this.antialiasLabel = new JLabel();
            this.panel.add((Component)this.antialiasLabel, labels);
            this.panel.add((Component)antialiasingBox, components);
            ++labels.gridy;
            ++components.gridy;
            antialiasingBox.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    JaxoExportImg.this.setAntialiasing(antialiasingBox.isSelected());
                }
            });
            this.resolutionLabel = new JLabel();
            this.panel.add((Component)this.resolutionLabel, labels);
            this.resolutionText = new JTextField(String.valueOf(this.resolution), 8);
            this.panel.add((Component)this.resolutionText, components);
            ++labels.gridy;
            ++components.gridy;
        }
        this.updateLanguage();
        return this.panel;
    }

    public final void updateLanguage() {
        if (this.bgColorLabel != null) {
            this.bgColorLabel.setText(LANGUAGE.label("background"));
            this.noBackgroundPaintingLabel.setText(LANGUAGE.label("translucent"));
            this.antialiasLabel.setText(LANGUAGE.label("antialiasing"));
            this.resolutionLabel.setText(LANGUAGE.label("resolution"));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ExportImage
    implements RenderedImage {
        private final BufferedImage prototype;
        private int y;
        private final int height;
        private BufferedImage partialImage;
        private BufferedImage completeImage;

        ExportImage(BufferedImage proto) {
            this.prototype = proto;
            this.height = 128;
        }

        @Override
        public Vector<RenderedImage> getSources() {
            return null;
        }

        @Override
        public Object getProperty(String name) {
            return Image.UndefinedProperty;
        }

        @Override
        public String[] getPropertyNames() {
            return null;
        }

        @Override
        public ColorModel getColorModel() {
            return this.prototype.getColorModel();
        }

        @Override
        public SampleModel getSampleModel() {
            return this.prototype.getSampleModel();
        }

        @Override
        public int getWidth() {
            return ((JaxoExportImg)JaxoExportImg.this).size.width;
        }

        @Override
        public int getHeight() {
            return ((JaxoExportImg)JaxoExportImg.this).size.height;
        }

        @Override
        public int getMinX() {
            return 0;
        }

        @Override
        public int getMinY() {
            return 0;
        }

        @Override
        public int getNumXTiles() {
            return 1;
        }

        @Override
        public int getNumYTiles() {
            return 1;
        }

        @Override
        public int getMinTileX() {
            return 0;
        }

        @Override
        public int getMinTileY() {
            return 0;
        }

        @Override
        public int getTileWidth() {
            return this.getWidth();
        }

        @Override
        public int getTileHeight() {
            return this.getHeight();
        }

        @Override
        public int getTileGridXOffset() {
            return 0;
        }

        @Override
        public int getTileGridYOffset() {
            return 0;
        }

        @Override
        public Raster getTile(int tileX, int tileY) {
            return this.completeImage().getTile(tileX, tileY);
        }

        @Override
        public Raster getData() {
            return this.completeImage().getData();
        }

        @Override
        public Raster getData(Rectangle r) {
            if (this.completeImage != null) {
                return this.completeImage.getData(r);
            }
            if (r.height > this.height) {
                return this.completeImage().getData(r);
            }
            if (this.partialImage == null) {
                this.partialImage = new BufferedImage(((JaxoExportImg)JaxoExportImg.this).size.width, this.height, this.prototype.getType());
                this.y = r.y;
                JaxoExportImg.this.paintToImage(this.partialImage, this.y);
            } else if (this.y > r.y || this.y + this.height < r.y + r.height) {
                this.y = r.y;
                JaxoExportImg.this.paintToImage(this.partialImage, this.y);
            }
            Raster result = this.partialImage.getData(new Rectangle(r.x, r.y - this.y, r.width, r.height));
            return new Raster(result.getSampleModel(), result.getDataBuffer(), r, new Point(0, result.getSampleModelTranslateY() + this.y), null){};
        }

        @Override
        public WritableRaster copyData(WritableRaster r) {
            return this.completeImage().copyData(r);
        }

        private BufferedImage completeImage() {
            if (this.completeImage == null) {
                this.completeImage = new BufferedImage(((JaxoExportImg)JaxoExportImg.this).size.width, ((JaxoExportImg)JaxoExportImg.this).size.height, this.prototype.getType());
                JaxoExportImg.this.paintToImage(this.completeImage, 0);
            }
            return this.completeImage;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Format {
        JPG,
        PNG;

    }
}

