/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jaxodraw.logging;

import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.logging.FileHandler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import net.sf.jaxodraw.logging.LogFormatter;

public final class JaxoFileHandler
extends FileHandler {
    private static final String DEFAULT_FILE = "jaxodraw%g.log";
    private static final int DEFAULT_LIMIT = 0x100000;
    private static final int DEFAULT_NUM = 3;

    public JaxoFileHandler(String logDir, String pattern, int limit, int logFiles) throws IOException {
        super(logDir + pattern, limit, logFiles, true);
        this.setLevel(Level.ALL);
        this.setFormatter(new TimeLogFormatter());
    }

    public JaxoFileHandler(String logDir) throws IOException {
        this(logDir, DEFAULT_FILE, 0x100000, 3);
    }

    public JaxoFileHandler(String logDir, String pattern) throws IOException {
        this(logDir, pattern, 0x100000, 3);
    }

    public JaxoFileHandler(String logDir, String pattern, int limit) throws IOException {
        this(logDir, pattern, limit, 3);
    }

    private static class TimeLogFormatter
    extends LogFormatter {
        private TimeLogFormatter() {
        }

        public String format(LogRecord rec) {
            String log = super.format(rec);
            SimpleDateFormat formatter = new SimpleDateFormat("MMM d HH:mm:ss ", Locale.ENGLISH);
            String time = formatter.format(new Date());
            return time + log;
        }
    }
}

