/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jaxodraw.object;

import java.awt.BasicStroke;
import java.awt.Dimension;
import java.io.IOException;
import java.io.ObjectInputStream;
import net.sf.jaxodraw.object.JaxoHandle;
import net.sf.jaxodraw.object.JaxoObject;
import net.sf.jaxodraw.util.JaxoPrefs;
import net.sf.jaxodraw.util.JaxoUtils;
import net.sf.jaxodraw.util.graphics.JaxoGraphics2D;

public abstract class JaxoExtendedObject
extends JaxoObject {
    public static final int SELECT_DX = -3;
    public static final int SELECT_DY = -4;
    public static final int SELECT_P2 = 1;
    private static final long serialVersionUID = 2L;
    private static final int POINT_COUNT = 2;
    private int x2;
    private int y2;
    private float strokeWidth;
    private transient BasicStroke stroke = new BasicStroke();

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.stroke = new BasicStroke();
    }

    public int getPointCount() {
        return 2;
    }

    public int getX(int index) {
        if (index == 1) {
            return this.x2;
        }
        return super.getX(index);
    }

    public int getY(int index) {
        if (index == 1) {
            return this.y2;
        }
        return super.getY(index);
    }

    public void setX(int index, int value) {
        if (index == 1) {
            this.x2 = value;
        } else {
            super.setX(index, value);
        }
    }

    public void setY(int index, int value) {
        if (index == 1) {
            this.y2 = value;
        } else {
            super.setY(index, value);
        }
    }

    public final int getX2() {
        return this.getX(1);
    }

    public final void setX2(int newX2) {
        this.setX(1, newX2);
    }

    public final int getY2() {
        return this.getY(1);
    }

    public final void setY2(int newY2) {
        this.setY(1, newY2);
    }

    public final float getStrokeWidth() {
        return this.strokeWidth;
    }

    public void setStrokeWidth(float newStroke) {
        float old = this.getStrokeWidth();
        this.strokeWidth = newStroke;
        this.resetStroke();
        this.firePropertyChange("strokeWidth", Float.valueOf(old), Float.valueOf(newStroke));
    }

    public final int getWidth() {
        return Math.abs(this.getRelw());
    }

    public final int getHeight() {
        return Math.abs(this.getRelh());
    }

    public final int getRelw() {
        return this.getX2() - this.getX();
    }

    public final int getRelh() {
        return this.getY2() - this.getY();
    }

    public final void setRelWAndH(int w, int h) {
        this.setX2(this.getX() + w);
        this.setY2(this.getY() + h);
    }

    public final void setRelativeWidth(int w) {
        this.setX2(this.getX() + w);
    }

    public final void setRelativeHeight(int h) {
        this.setY2(this.getY() + h);
    }

    public void setRadius(float newRadius) {
        float oldrelh;
        float oldrelw = this.getRelw();
        double oldR = Math.sqrt(oldrelw * oldrelw + (oldrelh = (float)this.getRelh()) * oldrelh);
        if (JaxoUtils.zero(oldR)) {
            this.setRelWAndH(Math.round(newRadius), 0);
        } else {
            int newRelW = (int)Math.round((double)newRadius / oldR * (double)oldrelw);
            int newRelH = (int)Math.round((double)newRadius / oldR * (double)oldrelh);
            this.setRelWAndH(newRelW, newRelH);
        }
    }

    public double getRadius() {
        return Math.sqrt(this.getWidth() * this.getWidth() + this.getHeight() * this.getHeight());
    }

    public final void setLocation(int newX, int newY, int newX2, int newY2) {
        this.setLocation(newX, newY);
        this.setX2(newX2);
        this.setY2(newY2);
    }

    public void moveBy(int deltaX, int deltaY) {
        if (deltaX != 0 || deltaY != 0) {
            super.moveBy(deltaX, deltaY);
            this.setX2(this.getX2() + deltaX);
            this.setY2(this.getY2() + deltaY);
        }
    }

    public final Dimension getSize() {
        return new Dimension(this.getWidth(), this.getHeight());
    }

    public final Dimension getRelSize() {
        return new Dimension(this.getRelw(), this.getRelh());
    }

    public boolean isCopy(JaxoObject comp) {
        JaxoExtendedObject tmp;
        boolean isCopy = false;
        if (comp instanceof JaxoExtendedObject && (tmp = (JaxoExtendedObject)comp).getX2() == this.getX2() && tmp.getY2() == this.getY2() && tmp.strokeIs(this.getStrokeWidth()) && super.isCopy(tmp)) {
            isCopy = true;
        }
        return isCopy;
    }

    public void copyFrom(JaxoExtendedObject temp) {
        super.copyFrom(temp);
        this.setX2(temp.getX2());
        this.setY2(temp.getY2());
        this.setStrokeWidth(temp.getStrokeWidth());
    }

    public void setState(JaxoObject o) {
        if (!(o instanceof JaxoExtendedObject)) {
            throw new UnsupportedOperationException("Cannot copy from super type!");
        }
        this.copyFrom((JaxoExtendedObject)o);
    }

    public float smallestDistanceTo(int px, int py) {
        int distY;
        int distX;
        float dist2;
        float dist1 = super.smallestDistanceTo(px, py);
        return dist1 < (dist2 = (float)Math.sqrt((distX = px - this.getX2()) * distX + (distY = py - this.getY2()) * distY)) ? dist1 : dist2;
    }

    public int getGrabbedHandle(int clickX, int clickY, JaxoHandle h) {
        int selected = super.getGrabbedHandle(clickX, clickY, h);
        if (this.isAround(1, clickX, clickY, h)) {
            selected = 1;
        }
        return selected;
    }

    public void paintHandles(JaxoGraphics2D g2, JaxoHandle h, int editMode) {
        if (editMode == 459) {
            return;
        }
        h.paint(g2, this.getX(), this.getY(), this.isMarked(), !this.canBeSelected(0, editMode));
        h.paint(g2, this.getX2(), this.getY2(), this.isMarked(), !this.canBeSelected(1, editMode));
    }

    public boolean canBeSelected(int handle, int mode) {
        boolean active;
        boolean bl = active = handle == 0 || handle == 1;
        if (mode == 451) {
            active = handle == 1;
        }
        return active;
    }

    public String latexWidth() {
        String thisValue = Float.toString(this.getStrokeWidth());
        return "\\SetWidth{".concat(thisValue.concat("}"));
    }

    public void setPreferences() {
        super.setPreferences();
        this.setStrokeWidth(JaxoPrefs.getFloatPref("prefLINEWIDTH"));
    }

    public final boolean strokeIs(float comp) {
        return JaxoUtils.equal(comp, this.getStrokeWidth());
    }

    protected final BasicStroke getStroke() {
        return this.stroke;
    }

    protected final void setStroke(BasicStroke newStroke) {
        this.stroke = newStroke;
    }

    protected void resetStroke() {
        this.setStroke(new BasicStroke(this.getStrokeWidth()));
    }

    static {
        JaxoExtendedObject.setTransient(JaxoExtendedObject.class, new String[]{"x2", "y2"});
    }
}

