/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jaxodraw.object.arc;

import net.sf.jaxodraw.object.JaxoObject;
import net.sf.jaxodraw.object.JaxoObjectEditPanel;
import net.sf.jaxodraw.object.arc.JaxoDashArc;

public class JaxoSArc
extends JaxoDashArc {
    private static final long serialVersionUID = 314159L;

    public final boolean isCopy(JaxoObject comp) {
        boolean isCopy = false;
        if (comp instanceof JaxoSArc) {
            isCopy = super.isCopy(comp);
        }
        return isCopy;
    }

    protected float[] strokeDashes() {
        return new float[]{this.getDash()};
    }

    protected float[] innerStrokeDashes(double radius) {
        float cf1 = 1.0f;
        float dlsep = this.getDLSeparation() / 2.0f;
        if (radius > (double)dlsep) {
            cf1 = (float)((radius - (double)dlsep) / radius);
        }
        return new float[]{cf1 * this.getDash()};
    }

    protected float[] outerStrokeDashes(double radius) {
        float cf1 = 1.0f;
        if (radius > 0.0) {
            cf1 = (float)((radius + (double)(this.getDLSeparation() / 2.0f)) / radius);
        }
        return new float[]{cf1 * this.getDash()};
    }

    public void setPreferences() {
        this.setDash(10.0f);
        super.setPreferences();
    }

    public void prepareEditPanel(JaxoObjectEditPanel editPanel) {
        editPanel.add3PointsPanel(this.getPoints(), 0, 0, 2);
        editPanel.addArrowPanel(this.isPaintArrow(), this.isFlip(), this.getArrowPosition(), 2, 0);
        editPanel.addArrowOptionsEditPanel(this.getArrow(), 3, 0);
        editPanel.addStrokePanel(this.getStrokeWidth(), 0, 1);
        editPanel.addDashPanel(this.getDash(), 1, 1);
        editPanel.addDoubleLinePanel(this.isDoubleLine(), this.getDLSeparation(), 2, 1);
        editPanel.addLineColorPanel(this.getColor(), 3, 1);
        editPanel.setTitleAndIcon("Scalar_arc_parameters", "sarc.png");
    }
}

