/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jaxodraw.object.bezier;

import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.List;
import net.sf.jaxodraw.object.JaxoObject;
import net.sf.jaxodraw.object.JaxoObjectEditPanel;
import net.sf.jaxodraw.object.JaxoWiggleObject;
import net.sf.jaxodraw.object.bezier.JaxoBezierObject;
import net.sf.jaxodraw.util.JaxoUtils;
import net.sf.jaxodraw.util.graphics.JaxoGraphics2D;

public class JaxoGlBezier
extends JaxoBezierObject
implements JaxoWiggleObject {
    private static final long serialVersionUID = 2L;
    private transient float freq;
    private transient Point2D b2;
    private transient Point2D cp1;
    private transient Point2D cp1up;
    private transient Point2D cp1down;
    private transient Point2D cp2;
    private transient Point2D cp2up;
    private transient Point2D cp2down;
    private transient Point2D sp1;
    private transient Point2D sp2;
    private transient Point2D sp3;
    private transient Point2D sp4;
    private transient Point2D spbuffer1;
    private transient Point2D spbuffer2;
    private transient Point2D spbuffer3;
    private transient List<Double> renormsteps;
    private static final int TOLERANCE = 1;

    public JaxoGlBezier() {
        this.initParams();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.initParams();
    }

    private void initParams() {
        this.freq = 0.0f;
        this.b2 = new Point2D.Double();
        this.cp1 = new Point2D.Double(0.0, 0.0);
        this.cp1up = new Point2D.Double(0.0, 0.0);
        this.cp1down = new Point2D.Double(0.0, 0.0);
        this.cp2 = new Point2D.Double(0.0, 0.0);
        this.cp2up = new Point2D.Double(0.0, 0.0);
        this.cp2down = new Point2D.Double(0.0, 0.0);
        this.sp1 = new Point2D.Double(0.0, 0.0);
        this.sp2 = new Point2D.Double(0.0, 0.0);
        this.sp3 = new Point2D.Double(0.0, 0.0);
        this.sp4 = new Point2D.Double(0.0, 0.0);
        this.spbuffer1 = new Point2D.Double(0.0, 0.0);
        this.spbuffer2 = new Point2D.Double(0.0, 0.0);
        this.spbuffer3 = new Point2D.Double(0.0, 0.0);
        this.renormsteps = new ArrayList<Double>(500);
    }

    public final JaxoObject copy() {
        JaxoGlBezier temp = new JaxoGlBezier();
        temp.copyFrom(this);
        return temp;
    }

    public final boolean isCopy(JaxoObject comp) {
        boolean isCopy = false;
        if (comp instanceof JaxoGlBezier) {
            isCopy = super.isCopy(comp);
        }
        return isCopy;
    }

    public void copyFrom(JaxoGlBezier temp) {
        super.copyFrom(temp);
        this.freq = temp.getFrequency();
    }

    public void setState(JaxoObject o) {
        if (!(o instanceof JaxoGlBezier)) {
            throw new UnsupportedOperationException("Cannot copy from super type!");
        }
        this.copyFrom((JaxoGlBezier)o);
    }

    public final void paint(JaxoGraphics2D g2) {
        g2.setColor(this.getColor());
        g2.setStroke(this.getStroke());
        g2.draw(this.getObjectPath());
    }

    public Rectangle getBounds() {
        return this.getStroke().createStrokedShape(new Area(this.getObjectPath())).getBounds();
    }

    public final String latexCommand(float scale, Dimension canvasDim) {
        if (JaxoUtils.zero(this.freq)) {
            this.setFrequencyFromWiggles(this.getWiggles());
        } else {
            this.setWigglesFromFrequency();
        }
        this.initRenormSteps();
        String command = this.constructLatexString(scale, canvasDim.height);
        String jdIdentifier = "%JaxoID:GlBez(" + this.getX() + "," + this.getY() + ")" + "(" + this.getX2() + "," + this.getY2() + ")" + "(" + this.getX3() + "," + this.getY3() + ")" + "(" + this.getX4() + "," + this.getY4() + ")" + "{" + this.getAmp() + "}" + "{" + this.getWiggles() + "}" + "[" + this.isNoFreqStretching() + "]";
        return command + jdIdentifier;
    }

    public float getFrequency() {
        return this.freq;
    }

    public void setWigglesFromFrequency(float frequency) {
        this.freq = frequency;
        this.setWigglesFromFrequency();
    }

    public void setWigglesFromFrequency() {
        int n = (int)Math.round(this.getBezierLength() * (double)this.getFrequency());
        this.setWiggles(n);
    }

    public void setFrequencyFromWiggles(int wiggles) {
        this.setWiggles(wiggles);
        this.freq = (float)((double)wiggles / this.getBezierLength());
    }

    public void setPreferences() {
        super.setPreferences();
        this.setWigglesFromFrequency(0.08f);
    }

    public void prepareEditPanel(JaxoObjectEditPanel editPanel) {
        editPanel.add4PointsPanel(this.getPoints(), 0, 0, 3);
        editPanel.addLineColorPanel(this.getColor(), 3, 0);
        editPanel.addStrokePanel(this.getStrokeWidth(), 0, 1);
        editPanel.addWigglePanel(this.getAmp(), this.getWiggles(), 1, 1);
        editPanel.addStretchingPanel(this.isNoFreqStretching(), 2, 1);
        editPanel.setTitleAndIcon("Gluon_bezier_parameters", "beziergl.png");
    }

    private double setNextPoint(Point2D b1, double par, double tstep, boolean noFreqStretching) {
        double tpar = par;
        this.tryNextBezierPoint(tpar);
        if (noFreqStretching) {
            double reflength;
            double length = this.b2.distance(b1);
            if (length - (reflength = 1.0 / (double)this.getFrequency()) > 1.0) {
                int alter = -1;
                for (int l = 1; l < 20; ++l) {
                    double rtpar = tpar + (double)alter * tstep / Math.pow(2.0, l);
                    this.tryNextBezierPoint(rtpar);
                    length = this.b2.distance(b1);
                    if (Math.abs(length - reflength) <= 1.0) {
                        tpar = rtpar;
                        break;
                    }
                    if (length - reflength > 1.0) {
                        alter = -1;
                        tpar = rtpar;
                        continue;
                    }
                    tpar = rtpar;
                    alter = 1;
                }
            } else if (length - reflength < -1.0) {
                double rtpar;
                int l;
                int alter = -1;
                boolean seconditer = true;
                for (l = 1; l < 10; ++l) {
                    rtpar = tpar + (double)l * tstep;
                    this.tryNextBezierPoint(rtpar);
                    length = this.b2.distance(b1);
                    if (Math.abs(length - reflength) <= 1.0) {
                        seconditer = false;
                        tpar = rtpar;
                        break;
                    }
                    if (length - reflength > 1.0) {
                        seconditer = true;
                        alter = -1;
                        tpar = rtpar;
                        break;
                    }
                    tpar = rtpar;
                }
                if (seconditer) {
                    for (l = 1; l < 20; ++l) {
                        rtpar = tpar + (double)alter * tstep / Math.pow(2.0, l);
                        this.tryNextBezierPoint(rtpar);
                        length = this.b2.distance(b1);
                        if (Math.abs(length - reflength) <= 1.0) {
                            tpar = rtpar;
                            break;
                        }
                        if (length - reflength > 1.0) {
                            alter = -1;
                            tpar = rtpar;
                            continue;
                        }
                        tpar = rtpar;
                        alter = 1;
                    }
                }
            }
        }
        this.renormsteps.add(tpar);
        return tpar;
    }

    private void tryNextBezierPoint(double t) {
        this.b2.setLocation(this.getPointOnCurve(t));
    }

    private double getBFStep(Point2D b1, double rfact) {
        double length = this.b2.distance(b1);
        return length / rfact;
    }

    private void setAllCP1(Point2D b1, double bfstep, boolean first) {
        Point2D.Double tmpcp1ud = new Point2D.Double(0.0, 0.0);
        AffineTransform at = new AffineTransform();
        double theta = Math.atan2(this.b2.getY() - b1.getY(), this.b2.getX() - b1.getX());
        double lx = 0.5 * (double)this.getAmp() * Math.cos(theta);
        double ly = 0.5 * (double)this.getAmp() * Math.sin(theta);
        double lx1 = bfstep * Math.cos(theta);
        double ly1 = bfstep * Math.sin(theta);
        if (first) {
            this.cp1.setLocation(b1);
        } else {
            this.cp1.setLocation(b1.getX() + lx1, b1.getY() + ly1);
        }
        ((Point2D)tmpcp1ud).setLocation(this.cp1.getX() + lx, this.cp1.getY() + ly);
        at.rotate(-1.5707963267948966, this.cp1.getX(), this.cp1.getY());
        at.transform(tmpcp1ud, this.cp1up);
        at.setToRotation(1.5707963267948966, this.cp1.getX(), this.cp1.getY());
        at.transform(tmpcp1ud, this.cp1down);
    }

    private void setAllCP2(Point2D b1, double bfstep, boolean last) {
        Point2D.Double tmpcp2ud = new Point2D.Double(0.0, 0.0);
        AffineTransform at = new AffineTransform();
        double theta = Math.atan2(this.b2.getY() - b1.getY(), this.b2.getX() - b1.getX());
        double lx = 0.5 * (double)this.getAmp() * Math.cos(theta);
        double ly = 0.5 * (double)this.getAmp() * Math.sin(theta);
        double lx1 = bfstep * Math.cos(theta);
        double ly1 = bfstep * Math.sin(theta);
        if (last) {
            this.cp2.setLocation(this.b2);
        } else {
            this.cp2.setLocation(this.b2.getX() - lx1, this.b2.getY() - ly1);
        }
        ((Point2D)tmpcp2ud).setLocation(this.cp2.getX() + lx, this.cp2.getY() + ly);
        at.rotate(-1.5707963267948966, this.cp2.getX(), this.cp2.getY());
        at.transform(tmpcp2ud, this.cp2up);
        at.setToRotation(1.5707963267948966, this.cp2.getX(), this.cp2.getY());
        at.transform(tmpcp2ud, this.cp2down);
    }

    private void storePoints(boolean first) {
        this.spbuffer1.setLocation(this.sp3);
        this.spbuffer2.setLocation(this.sp2);
        if (first) {
            this.spbuffer3.setLocation(this.cp1);
        } else {
            this.spbuffer3.setLocation(this.sp1);
        }
        this.sp1.setLocation(this.cp2down);
        this.sp2.setLocation(this.cp2);
        this.sp3.setLocation(this.cp2up);
        if (first) {
            this.sp4.setLocation(this.cp1);
        } else {
            this.sp4.setLocation(this.cp1down);
        }
    }

    private GeneralPath getObjectPath() {
        if (JaxoUtils.zero(this.freq)) {
            this.setFrequencyFromWiggles(this.getWiggles());
        } else {
            this.setWigglesFromFrequency();
        }
        this.initRenormSteps();
        return this.drawingRoutine();
    }

    private GeneralPath drawingRoutine() {
        GeneralPath gp = this.getGeneralPath();
        gp.reset();
        boolean firststep = true;
        boolean firstleftcurl = true;
        boolean laststep = false;
        Point2D.Double b1 = new Point2D.Double(this.getX(), this.getY());
        for (int t = 0; t < this.renormsteps.size(); ++t) {
            if (t == this.renormsteps.size() - 1) {
                laststep = true;
            }
            this.tryNextBezierPoint(this.renormsteps.get(t));
            if (firststep) {
                this.setAllCP1(b1, 0.45 * (double)this.getAmp(), firststep);
                this.setAllCP2(b1, 0.45 * (double)this.getAmp(), laststep);
                this.sp2.setLocation(this.cp1);
                this.sp3.setLocation(this.cp1up);
                this.storePoints(firststep);
                firststep = false;
            } else {
                double p1y;
                double p1x;
                double p4y;
                double p4x;
                double p3y;
                double p3x;
                this.setAllCP1(b1, 0.45 * (double)this.getAmp(), firststep);
                this.setAllCP2(b1, 0.45 * (double)this.getAmp(), laststep);
                if (firstleftcurl) {
                    double p2x = (this.sp4.getX() + this.spbuffer3.getX()) * 0.5;
                    double p2y = (this.sp4.getY() + this.spbuffer3.getY()) * 0.5;
                    double p1x2 = (this.spbuffer1.getX() + this.cp1up.getX()) * 0.5;
                    double p1y2 = (this.spbuffer1.getY() + this.cp1up.getY()) * 0.5;
                    p3x = (this.spbuffer1.getX() + p2x) * 0.5;
                    p3y = (this.spbuffer1.getY() + p2y) * 0.5;
                    p4x = (this.spbuffer1.getX() - this.cp1up.getX()) * 0.75 + this.cp1up.getX();
                    p4y = (this.spbuffer1.getY() - this.cp1up.getY()) * 0.75 + this.cp1up.getY();
                    double p11x = (this.sp1.getX() + this.cp1down.getX()) * 0.5;
                    double p11y = (this.sp1.getY() + this.cp1down.getY()) * 0.5;
                    gp.moveTo(p2x, p2y);
                    gp.curveTo(p3x, p3y, p4x, p4y, p1x2, p1y2);
                    gp.curveTo(this.cp1up.getX(), this.cp1up.getY(), this.cp1down.getX(), this.cp1down.getY(), p11x, p11y);
                    firstleftcurl = false;
                } else {
                    p1x = (this.spbuffer1.getX() - this.cp1up.getX()) * 0.5 + this.cp1up.getX();
                    p1y = (this.spbuffer1.getY() - this.cp1up.getY()) * 0.5 + this.cp1up.getY();
                    double p11x = (this.sp1.getX() + this.cp1down.getX()) * 0.5;
                    double p11y = (this.sp1.getY() + this.cp1down.getY()) * 0.5;
                    double p2x = (this.sp4.getX() + this.spbuffer3.getX()) * 0.5;
                    double p2y = (this.sp4.getY() + this.spbuffer3.getY()) * 0.5;
                    gp.moveTo(p2x, p2y);
                    gp.curveTo(this.spbuffer3.getX(), this.spbuffer3.getY(), this.spbuffer1.getX(), this.spbuffer1.getY(), p1x, p1y);
                    gp.curveTo(this.cp1up.getX(), this.cp1up.getY(), this.cp1down.getX(), this.cp1down.getY(), p11x, p11y);
                }
                if (laststep) {
                    this.storePoints(firststep);
                    this.setAllCP2(b1, 0.45 * (double)this.getAmp(), laststep);
                    p1x = (this.spbuffer1.getX() + this.cp2up.getX()) * 0.5;
                    p1y = (this.spbuffer1.getY() + this.cp2up.getY()) * 0.5;
                    double p2x = (this.sp4.getX() + this.spbuffer3.getX()) * 0.5;
                    double p2y = (this.sp4.getY() + this.spbuffer3.getY()) * 0.5;
                    p3x = (this.spbuffer1.getX() - this.cp2up.getX()) * 0.25 + this.cp2up.getX();
                    p3y = (this.spbuffer1.getY() - this.cp2up.getY()) * 0.25 + this.cp2up.getY();
                    p4x = (this.cp2up.getX() + this.cp2.getX()) * 0.5;
                    p4y = (this.cp2up.getY() + this.cp2.getY()) * 0.5;
                    gp.moveTo(p2x, p2y);
                    gp.curveTo(this.spbuffer3.getX(), this.spbuffer3.getY(), this.spbuffer1.getX(), this.spbuffer1.getY(), p1x, p1y);
                    gp.curveTo(p3x, p3y, p4x, p4y, this.cp2.getX(), this.cp2.getY());
                }
                this.storePoints(firststep);
            }
            b1.setLocation(this.b2);
        }
        return gp;
    }

    private String constructLatexString(float scale, int canvasHeight) {
        StringBuffer command = new StringBuffer(128);
        boolean firststep = true;
        boolean firstleftcurl = true;
        boolean laststep = false;
        Point2D.Double b1 = new Point2D.Double(this.getX(), this.getY());
        for (int t = 0; t < this.renormsteps.size(); ++t) {
            if (t == this.renormsteps.size() - 1) {
                laststep = true;
            }
            this.tryNextBezierPoint(this.renormsteps.get(t));
            if (firststep) {
                this.setAllCP1(b1, 0.45 * (double)this.getAmp(), firststep);
                this.setAllCP2(b1, 0.45 * (double)this.getAmp(), laststep);
                this.sp2.setLocation(this.cp1);
                this.sp3.setLocation(this.cp1up);
                this.storePoints(firststep);
                firststep = false;
            } else {
                double p1y;
                double p1x;
                double p4y;
                double p4x;
                double p3y;
                double p3x;
                this.setAllCP1(b1, 0.45 * (double)this.getAmp(), firststep);
                this.setAllCP2(b1, 0.45 * (double)this.getAmp(), laststep);
                if (firstleftcurl) {
                    double p2x = (this.sp4.getX() + this.spbuffer3.getX()) * 0.5;
                    double p2y = (this.sp4.getY() + this.spbuffer3.getY()) * 0.5;
                    double p1x2 = (this.spbuffer1.getX() + this.cp1up.getX()) * 0.5;
                    double p1y2 = (this.spbuffer1.getY() + this.cp1up.getY()) * 0.5;
                    p3x = (this.spbuffer1.getX() + p2x) * 0.5;
                    p3y = (this.spbuffer1.getY() + p2y) * 0.5;
                    p4x = (this.spbuffer1.getX() - this.cp1up.getX()) * 0.75 + this.cp1up.getX();
                    p4y = (this.spbuffer1.getY() - this.cp1up.getY()) * 0.75 + this.cp1up.getY();
                    double p11x = (this.sp1.getX() + this.cp1down.getX()) * 0.5;
                    double p11y = (this.sp1.getY() + this.cp1down.getY()) * 0.5;
                    Point2D latexP1 = JaxoGlBezier.getLatexPoint(p1x2, p1y2, scale, canvasHeight);
                    Point2D latexP2 = JaxoGlBezier.getLatexPoint(p2x, p2y, scale, canvasHeight);
                    Point2D latexP3 = JaxoGlBezier.getLatexPoint(p3x, p3y, scale, canvasHeight);
                    Point2D latexP4 = JaxoGlBezier.getLatexPoint(p4x, p4y, scale, canvasHeight);
                    Point2D latexP11 = JaxoGlBezier.getLatexPoint(p11x, p11y, scale, canvasHeight);
                    Point2D latexCp1up = JaxoGlBezier.getLatexPoint(this.cp1up.getX(), this.cp1up.getY(), scale, canvasHeight);
                    Point2D latexCp1down = JaxoGlBezier.getLatexPoint(this.cp1down.getX(), this.cp1down.getY(), scale, canvasHeight);
                    command.append(' ').append(JaxoGlBezier.bezierLatexCommand("", latexP2, latexP3, latexP4, latexP1));
                    command.append(' ').append(JaxoGlBezier.bezierLatexCommand("", latexP1, latexCp1up, latexCp1down, latexP11));
                    firstleftcurl = false;
                } else {
                    p1x = (this.spbuffer1.getX() - this.cp1up.getX()) * 0.5 + this.cp1up.getX();
                    p1y = (this.spbuffer1.getY() - this.cp1up.getY()) * 0.5 + this.cp1up.getY();
                    double p11x = (this.sp1.getX() + this.cp1down.getX()) * 0.5;
                    double p11y = (this.sp1.getY() + this.cp1down.getY()) * 0.5;
                    double p2x = (this.sp4.getX() + this.spbuffer3.getX()) * 0.5;
                    double p2y = (this.sp4.getY() + this.spbuffer3.getY()) * 0.5;
                    Point2D latexP1 = JaxoGlBezier.getLatexPoint(p1x, p1y, scale, canvasHeight);
                    Point2D latexP2 = JaxoGlBezier.getLatexPoint(p2x, p2y, scale, canvasHeight);
                    Point2D latexP11 = JaxoGlBezier.getLatexPoint(p11x, p11y, scale, canvasHeight);
                    Point2D latexCp1up = JaxoGlBezier.getLatexPoint(this.cp1up.getX(), this.cp1up.getY(), scale, canvasHeight);
                    Point2D latexCp1down = JaxoGlBezier.getLatexPoint(this.cp1down.getX(), this.cp1down.getY(), scale, canvasHeight);
                    Point2D latexSpbuf1 = JaxoGlBezier.getLatexPoint(this.spbuffer1.getX(), this.spbuffer1.getY(), scale, canvasHeight);
                    Point2D latexSpbuf3 = JaxoGlBezier.getLatexPoint(this.spbuffer3.getX(), this.spbuffer3.getY(), scale, canvasHeight);
                    command.append(' ').append(JaxoGlBezier.bezierLatexCommand("", latexP2, latexSpbuf3, latexSpbuf1, latexP1));
                    command.append(' ').append(JaxoGlBezier.bezierLatexCommand("", latexP1, latexCp1up, latexCp1down, latexP11));
                }
                if (laststep) {
                    this.storePoints(firststep);
                    this.setAllCP2(b1, this.getBFStep(b1, 4.0), laststep);
                    p1x = (this.spbuffer1.getX() + this.cp2up.getX()) * 0.5;
                    p1y = (this.spbuffer1.getY() + this.cp2up.getY()) * 0.5;
                    double p2x = (this.sp4.getX() + this.spbuffer3.getX()) * 0.5;
                    double p2y = (this.sp4.getY() + this.spbuffer3.getY()) * 0.5;
                    p3x = (this.spbuffer1.getX() - this.cp2up.getX()) * 0.25 + this.cp2up.getX();
                    p3y = (this.spbuffer1.getY() - this.cp2up.getY()) * 0.25 + this.cp2up.getY();
                    p4x = (this.cp2up.getX() + this.cp2.getX()) * 0.5;
                    p4y = (this.cp2up.getY() + this.cp2.getY()) * 0.5;
                    Point2D latexP1 = JaxoGlBezier.getLatexPoint(p1x, p1y, scale, canvasHeight);
                    Point2D latexP2 = JaxoGlBezier.getLatexPoint(p2x, p2y, scale, canvasHeight);
                    Point2D latexP3 = JaxoGlBezier.getLatexPoint(p3x, p3y, scale, canvasHeight);
                    Point2D latexP4 = JaxoGlBezier.getLatexPoint(p4x, p4y, scale, canvasHeight);
                    Point2D latexCp2 = JaxoGlBezier.getLatexPoint(this.cp2.getX(), this.cp2.getY(), scale, canvasHeight);
                    Point2D latexSpbuf1 = JaxoGlBezier.getLatexPoint(this.spbuffer1.getX(), this.spbuffer1.getY(), scale, canvasHeight);
                    Point2D latexSpbuf3 = JaxoGlBezier.getLatexPoint(this.spbuffer3.getX(), this.spbuffer3.getY(), scale, canvasHeight);
                    command.append(' ').append(JaxoGlBezier.bezierLatexCommand("", latexP2, latexSpbuf3, latexSpbuf1, latexP1));
                    command.append(' ').append(JaxoGlBezier.bezierLatexCommand("", latexP1, latexP3, latexP4, latexCp2));
                }
                this.storePoints(firststep);
            }
            b1.setLocation(this.b2);
        }
        return command.toString();
    }

    private void initRenormSteps() {
        this.renormsteps.clear();
        double length = this.getBezierLength();
        int wnumb = (int)Math.round(length * (double)this.getFrequency());
        double tstep = 1.0f / (float)wnumb;
        double lptol = this.isNoFreqStretching() ? 0.015 : 1.0E-4;
        Point2D.Double b1 = new Point2D.Double(this.getX(), this.getY());
        double tpar = tstep;
        while (tpar <= 1.0 + tstep && (!(Math.abs((tpar = this.setNextPoint(b1, tpar, tstep, this.isNoFreqStretching())) - 1.0 - tstep) < lptol) || !(Math.abs(this.b2.getX() - (double)this.getX()) > 0.1) && !(Math.abs(this.b2.getY() - (double)this.getY()) > 0.1))) {
            b1.setLocation(this.b2);
            tpar += tstep;
        }
        if (this.renormsteps.get(this.renormsteps.size() - 1) - 1.0 > 1.0E-7) {
            this.renormsteps.remove(this.renormsteps.size() - 1);
        }
        double corr = (1.0 - this.renormsteps.get(this.renormsteps.size() - 1)) / (double)this.renormsteps.size();
        for (int i = 0; i < this.renormsteps.size(); ++i) {
            double rvalue = this.renormsteps.get(i) + corr * (double)(i + 1);
            this.renormsteps.set(i, rvalue);
        }
    }
}

