/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jaxodraw.object.line;

import java.awt.Dimension;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.io.IOException;
import java.io.ObjectInputStream;
import net.sf.jaxodraw.object.JaxoObject;
import net.sf.jaxodraw.object.JaxoObjectEditPanel;
import net.sf.jaxodraw.object.JaxoSymmetricObject;
import net.sf.jaxodraw.object.JaxoWiggleObject;
import net.sf.jaxodraw.object.line.JaxoLineObject;
import net.sf.jaxodraw.util.JaxoUtils;

public class JaxoPLine
extends JaxoLineObject
implements JaxoWiggleObject,
JaxoSymmetricObject {
    private static final long serialVersionUID = 314159L;
    private transient float freq;
    private boolean symmetric;

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.freq = 0.0f;
    }

    public final boolean isSymmetric() {
        return this.symmetric;
    }

    public final void setSymmetric(boolean newSymm) {
        Boolean old = this.symmetric;
        this.symmetric = newSymm;
        this.firePropertyChange("symmetric", old, this.symmetric);
    }

    public void copyFrom(JaxoPLine temp) {
        super.copyFrom(temp);
        this.freq = temp.getFrequency();
        this.symmetric = temp.isSymmetric();
    }

    public void setState(JaxoObject o) {
        if (!(o instanceof JaxoPLine)) {
            throw new UnsupportedOperationException("Cannot copy from super type!");
        }
        this.copyFrom((JaxoPLine)o);
    }

    public boolean isCopy(JaxoObject comp) {
        JaxoPLine line;
        boolean isCopy = false;
        if (comp instanceof JaxoPLine && (line = (JaxoPLine)comp).isSymmetric() == this.isSymmetric() && super.isCopy(line)) {
            isCopy = true;
        }
        return isCopy;
    }

    public final String latexCommand(float scale, Dimension canvasDim) {
        int canvasHeight = canvasDim.height;
        Point2D startPoint = this.getLaTexStartPoint(scale, canvasHeight);
        Point2D endPoint = this.getLaTexEndPoint(scale, canvasHeight);
        if ((int)endPoint.getX() == (int)startPoint.getX() && (int)endPoint.getY() == (int)startPoint.getY()) {
            return "%";
        }
        float amplitude = (float)this.getAmp() / (2.0f * scale);
        float wiggles = this.getLaTexWiggleNumber();
        String options = this.getAxo4JOptions(scale);
        return "\\Photon" + options + "(" + D_FORMAT.format(startPoint.getX()) + "," + D_FORMAT.format(startPoint.getY()) + ")" + "(" + D_FORMAT.format(endPoint.getX()) + "," + D_FORMAT.format(endPoint.getY()) + ")" + "{" + D_FORMAT.format(amplitude) + "}" + "{" + D_FORMAT.format(wiggles) + "}";
    }

    public float getFrequency() {
        return this.freq;
    }

    public void setWigglesFromFrequency(float frequency) {
        this.freq = frequency;
        this.setWigglesFromFrequency();
    }

    public void setWigglesFromFrequency() {
        int n = (int)Math.round(this.length() * (double)this.getFrequency());
        this.setWiggles(n);
    }

    public void setFrequencyFromWiggles(int wiggles) {
        this.setWiggles(wiggles);
        this.freq = (float)((double)wiggles / this.length());
    }

    public void setPreferences() {
        super.setPreferences();
        this.setPaintArrow(false);
        this.setArrowPosition(0.0f);
        this.setSymmetric(false);
        this.setWigglesFromFrequency(0.05f);
    }

    public void prepareEditPanel(JaxoObjectEditPanel editPanel) {
        editPanel.add2PointsPanel(this.getPoints(), 0, 0);
        editPanel.addWigglePanel(this.getAmp(), this.getWiggles(), 1, 0);
        editPanel.addSymmPanel(this.isSymmetric(), 2, 0);
        editPanel.addStrokePanel(this.getStrokeWidth(), 0, 1);
        editPanel.addDoubleLinePanel(this.isDoubleLine(), this.getDLSeparation(), 1, 1);
        editPanel.addColorPanel(this.getColor(), 2, 2, 1);
        editPanel.setTitleAndIcon("Photon_line_parameters", "photon.png");
    }

    private float getLaTexWiggleNumber() {
        float n = this.getWiggles();
        if (this.isSymmetric()) {
            n += 0.5f;
        }
        return n;
    }

    protected GeneralPath getObjectPath() {
        GeneralPath gp = this.getGeneralPath();
        gp.reset();
        if (JaxoUtils.zero(this.freq)) {
            this.setFrequencyFromWiggles(this.getWiggles());
        } else {
            this.setWigglesFromFrequency();
        }
        if (this.isDoubleLine()) {
            float dlsep = this.getDLSeparation() / 2.0f;
            this.appendFullLine(gp, dlsep);
            this.appendFullLine(gp, -dlsep);
        } else {
            this.appendFullLine(gp, 0.0f);
        }
        return gp;
    }

    private void appendFullLine(GeneralPath gp, float sep) {
        float length = (float)this.getRadius();
        int n = 2 * this.getWiggles();
        if (this.isSymmetric()) {
            ++n;
        }
        float ts = length / (float)n;
        float sin = (float)this.getRelh() / length;
        float cos = (float)this.getRelw() / length;
        float c = 1.3333334f * ts / (float)Math.PI;
        float amp = -0.6666667f * (float)this.getAmp();
        gp.moveTo(this.getX(), (float)this.getY() + sep);
        for (int i = 1; i <= n; ++i) {
            float x0 = (float)(i - 1) * ts;
            this.curveTo(gp, x0 + c, amp + sep, x0 + ts - c, amp + sep, x0 + ts, sep, cos, sin);
            amp = -amp;
        }
    }

    private void curveTo(GeneralPath gp, float x1, float y1, float x2, float y2, float x3, float y3, float cos, float sin) {
        gp.curveTo(x1 * cos - y1 * sin + (float)this.getX(), x1 * sin + y1 * cos + (float)this.getY(), x2 * cos - y2 * sin + (float)this.getX(), x2 * sin + y2 * cos + (float)this.getY(), x3 * cos - y3 * sin + (float)this.getX(), x3 * sin + y3 * cos + (float)this.getY());
    }

    protected String getAxo4JOptions(float scale) {
        String optioncmd = "";
        if (this.isDoubleLine()) {
            optioncmd = "[double,sep=" + D_FORMAT.format(this.getDLSeparation()) + "]";
        }
        return optioncmd;
    }
}

