/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jaxodraw.object.loop;

import java.awt.Dimension;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.io.IOException;
import java.io.ObjectInputStream;
import net.sf.jaxodraw.object.JaxoObject;
import net.sf.jaxodraw.object.JaxoObjectEditPanel;
import net.sf.jaxodraw.object.JaxoWiggleObject;
import net.sf.jaxodraw.object.loop.JaxoLoopObject;
import net.sf.jaxodraw.util.JaxoUtils;

public class JaxoGlLoop
extends JaxoLoopObject
implements JaxoWiggleObject {
    private static final long serialVersionUID = 314159L;
    private transient float freq;

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.freq = 0.0f;
    }

    public void copyFrom(JaxoGlLoop temp) {
        super.copyFrom(temp);
        this.freq = temp.getFrequency();
    }

    public void setState(JaxoObject o) {
        if (!(o instanceof JaxoGlLoop)) {
            throw new UnsupportedOperationException("Cannot copy from super type!");
        }
        this.copyFrom((JaxoGlLoop)o);
    }

    public final boolean isCopy(JaxoObject comp) {
        boolean isCopy = false;
        if (comp instanceof JaxoGlLoop) {
            isCopy = super.isCopy(comp);
        }
        return isCopy;
    }

    public final String latexCommand(float scale, Dimension canvasDim) {
        float radius = this.getLaTexRadius(scale);
        if ((int)radius == 0) {
            return "%";
        }
        Point2D center = this.getLaTexCenter(scale, canvasDim.height);
        Point2D angles = this.getLaTexAngles();
        float amplitude = (float)this.getAmp() / (2.0f * scale);
        float windings = this.getWiggles();
        String options = this.getAxo4JOptions(scale);
        return "\\GluonArc" + options + "(" + D_FORMAT.format(center.getX()) + "," + D_FORMAT.format(center.getY()) + ")" + "(" + D_FORMAT.format(radius) + "," + D_FORMAT.format(angles.getX() - 180.0) + "," + D_FORMAT.format(angles.getY() - 180.0) + ")" + "{" + D_FORMAT.format(amplitude) + "}" + "{" + D_FORMAT.format(windings) + "}";
    }

    public float getFrequency() {
        return this.freq;
    }

    public void setWigglesFromFrequency(float frequency) {
        this.freq = frequency;
        this.setWigglesFromFrequency();
    }

    public void setWigglesFromFrequency() {
        double r = this.getRadius();
        int n = (int)Math.round(2.0 * r * Math.PI * (double)this.getFrequency());
        this.setWiggles(n);
    }

    public void setFrequencyFromWiggles(int wiggles) {
        this.setWiggles(wiggles);
        double r = this.getRadius();
        this.freq = (float)((double)wiggles / (2.0 * r * Math.PI));
    }

    public void setPreferences() {
        super.setPreferences();
        this.setPaintArrow(false);
        this.setArrowPosition(0.0f);
        this.setWigglesFromFrequency(0.08f);
    }

    public void prepareEditPanel(JaxoObjectEditPanel editPanel) {
        int r = (int)Math.round(this.getRadius());
        editPanel.addXYRPanel(this.getX(), this.getY(), r, 0, 0);
        editPanel.addWigglePanel(this.getAmp(), this.getWiggles(), 1, 0);
        editPanel.addDoubleLinePanel(this.isDoubleLine(), this.getDLSeparation(), 2, 0);
        editPanel.addStrokePanel(this.getStrokeWidth(), 0, 1);
        editPanel.addColorPanel(this.getColor(), 2, 1, 1);
        editPanel.setTitleAndIcon("Gluon_loop_parameters", "gluonloop.png");
    }

    protected GeneralPath getObjectPath() {
        GeneralPath path = this.getGeneralPath();
        path.reset();
        if (JaxoUtils.zero(this.freq)) {
            this.setFrequencyFromWiggles(this.getWiggles());
        } else {
            this.setWigglesFromFrequency();
        }
        int wiggles = this.getWiggles();
        float amp = 0.5f * (float)this.getAmp();
        float radius = (float)this.getRadius();
        if (radius <= 1.0f) {
            return null;
        }
        if (this.isDoubleLine()) {
            float ds = this.getDLSeparation() / 2.0f;
            this.appendFullLoop(path, radius, ds, wiggles, amp);
            this.appendFullLoop(path, radius, -ds, wiggles, amp);
        } else {
            this.appendFullLoop(path, radius, 0.0f, wiggles, amp);
        }
        return path;
    }

    private void appendFullLoop(GeneralPath gp, float rad, float ds, int n, float a) {
        float cos = (float)this.getRelw() / rad;
        float sin = (float)this.getRelh() / rad;
        float r = rad + ds;
        float absa = Math.abs(a);
        float delta = (float)(Math.PI * 2 / (double)n);
        gp.moveTo((r - a) * cos + (float)this.getX(), (r - a) * sin + (float)this.getY());
        for (int j = 1; j <= n; ++j) {
            float thetaj = (float)(j - 1) * delta;
            this.polarCurveTo(gp, (float)((double)(r - a) / Math.cos(0.9 * (double)absa / (double)r)), thetaj - 0.9f * absa / r, (float)((double)(r + a) / Math.cos(0.5 * (double)delta + 0.9 * (double)absa / (double)r)), thetaj - 0.9f * absa / r, r + a, thetaj + 0.5f * delta, cos, sin);
            this.polarCurveTo(gp, (float)((double)(r + a) / Math.cos(0.5 * (double)delta + 0.9 * (double)absa / (double)r)), thetaj + delta + 0.9f * absa / r, (float)((double)(r - a) / Math.cos(0.9 * (double)absa / (double)r)), thetaj + delta + 0.9f * absa / r, r - a, thetaj + delta, cos, sin);
        }
    }

    private void polarCurveTo(GeneralPath gp, float r1, float th1, float r2, float th2, float r3, float th3, float cos, float sin) {
        float x1 = (float)((double)r1 * Math.cos(th1));
        float y1 = (float)((double)r1 * Math.sin(th1));
        float x2 = (float)((double)r2 * Math.cos(th2));
        float y2 = (float)((double)r2 * Math.sin(th2));
        float x3 = (float)((double)r3 * Math.cos(th3));
        float y3 = (float)((double)r3 * Math.sin(th3));
        gp.curveTo(x1 * cos - y1 * sin + (float)this.getX(), x1 * sin + y1 * cos + (float)this.getY(), x2 * cos - y2 * sin + (float)this.getX(), x2 * sin + y2 * cos + (float)this.getY(), x3 * cos - y3 * sin + (float)this.getX(), x3 * sin + y3 * cos + (float)this.getY());
    }

    protected String getAxo4JOptions(float scale) {
        String optioncmd = "";
        if (this.isDoubleLine()) {
            optioncmd = "[double,sep=" + D_FORMAT.format(this.getDLSeparation()) + "]";
        }
        return optioncmd;
    }
}

