/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jaxodraw.object.vertex;

import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import net.sf.jaxodraw.object.JaxoHandle;
import net.sf.jaxodraw.object.JaxoObject;
import net.sf.jaxodraw.object.JaxoObjectEditPanel;
import net.sf.jaxodraw.object.vertex.JaxoVertex;
import net.sf.jaxodraw.util.graphics.JaxoGraphics2D;

public class JaxoVertexT4
extends JaxoVertex {
    private static final long serialVersionUID = 314159L;

    public final boolean isCopy(JaxoObject comp) {
        boolean isCopy = false;
        if (comp instanceof JaxoVertexT4) {
            isCopy = super.isCopy(comp);
        }
        return isCopy;
    }

    public boolean canBeSelected(int handle, int mode) {
        boolean active;
        boolean bl = active = handle == 0 || handle == 1;
        if (mode == 451) {
            active = handle == 1;
        }
        return active;
    }

    public void paintHandles(JaxoGraphics2D g2, JaxoHandle h, int editMode) {
        if (editMode == 459) {
            return;
        }
        h.paint(g2, this.getX(), this.getY(), this.isMarked(), !this.canBeSelected(0, editMode));
        h.paint(g2, this.getX2(), this.getY2(), this.isMarked(), !this.canBeSelected(1, editMode));
    }

    public final void paint(JaxoGraphics2D g2) {
        g2.setColor(this.getColor());
        g2.setStroke(this.getStroke());
        g2.draw(this.getObjectPath());
    }

    public Rectangle getBounds() {
        return this.getStroke().createStrokedShape(this.getObjectPath()).getBounds();
    }

    public final String latexCommand(float scale, Dimension canvasDim) {
        float radius = this.getLaTexRadius(scale);
        if ((int)radius == 0) {
            return "%";
        }
        Point2D center = this.getLaTexCenter(scale, canvasDim.height);
        Point2D.Float invec1 = new Point2D.Float((float)(center.getX() - (double)(radius * 0.707f)), (float)(center.getY() - (double)(radius * 0.707f)));
        Point2D.Float finvec1 = new Point2D.Float((float)(center.getX() + (double)(radius * 0.707f)), (float)(center.getY() + (double)(radius * 0.707f)));
        Point2D.Float invec2 = new Point2D.Float((float)(center.getX() - (double)(radius * 0.707f)), (float)(center.getY() + (double)(radius * 0.707f)));
        Point2D.Float finvec2 = new Point2D.Float((float)(center.getX() + (double)(radius * 0.707f)), (float)(center.getY() - (double)(radius * 0.707f)));
        double theta = 0.7853981633974483 - Math.atan2(this.getRelh(), this.getRelw());
        AffineTransform at = new AffineTransform();
        at.rotate(theta, center.getX(), center.getY());
        Point2D invect1 = at.transform(invec1, null);
        Point2D finvect1 = at.transform(finvec1, null);
        Point2D invect2 = at.transform(invec2, null);
        Point2D finvect2 = at.transform(finvec2, null);
        String command1 = "\\Line(" + D_FORMAT.format(invect1.getX()) + "," + D_FORMAT.format(invect1.getY()) + ")" + "(" + D_FORMAT.format(finvect1.getX()) + "," + D_FORMAT.format(finvect1.getY()) + ")";
        String command2 = "\\Line(" + D_FORMAT.format(invect2.getX()) + "," + D_FORMAT.format(invect2.getY()) + ")" + "(" + D_FORMAT.format(finvect2.getX()) + "," + D_FORMAT.format(finvect2.getY()) + ")";
        return command1 + command2;
    }

    public void prepareEditPanel(JaxoObjectEditPanel editPanel) {
        int r = (int)Math.round(this.getRadius());
        editPanel.addXYRPanel(this.getX(), this.getY(), r, 0, 0);
        editPanel.addStrokePanel(this.getStrokeWidth(), 0, 1);
        editPanel.addColorPanel(this.getColor(), 2, 1, 0);
        editPanel.addRotationPanel(this.getRotationAngle(), 1, 1);
        editPanel.setTitleAndIcon("Vertex_parameters", "vertexT4.png");
    }

    private GeneralPath getObjectPath() {
        GeneralPath gp = this.getGeneralPath();
        gp.reset();
        int sepx = this.getRelh();
        int sepy = this.getRelw();
        gp.moveTo(this.getX() + sepx, this.getY() - sepy);
        gp.lineTo(this.getX() - sepx, this.getY() + sepy);
        gp.moveTo(this.getX() - sepy, this.getY() - sepx);
        gp.lineTo(this.getX() + sepy, this.getY() + sepx);
        return gp;
    }
}

