/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jaxodraw.plugin;

import java.awt.Component;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;
import net.sf.jaxodraw.plugin.JaxoPlugin;
import net.sf.jaxodraw.plugin.JaxoPluginDictionary;
import net.sf.jaxodraw.plugin.JaxoPluginExecutionException;
import net.sf.jaxodraw.plugin.JaxoPluginLogger;
import net.sf.jaxodraw.util.JaxoDictionary;
import net.sf.jaxodraw.util.JaxoInfo;
import net.sf.jaxodraw.util.JaxoLog;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractJaxoPlugin
implements JaxoPlugin {
    private Component parent;
    private String shortGraphName = "";
    private boolean silent;
    private Object failure;
    private final Properties pluginProperties = new Properties();
    private final File cachedProperties;
    private final String pluginName = "jaxodraw-" + this.getShortName() + "-plugin";
    private JaxoDictionary language;

    protected AbstractJaxoPlugin() {
        this.cachedProperties = new File(JaxoInfo.PLUGIN_DIR, this.pluginName + ".properties");
    }

    @Override
    public String pluginName() {
        return this.pluginName;
    }

    protected void registerDictionary(Class<?> c) {
        this.language = new JaxoDictionary(c);
    }

    public Component getParentComponent() {
        return this.parent;
    }

    public void setParentComponent(Component value) {
        this.parent = value;
    }

    public final boolean hasFailed() {
        return this.failure != null;
    }

    public final Object getFailure() {
        return this.failure;
    }

    protected void setFailure(Object value) {
        Object src;
        if (value instanceof Exception) {
            this.getLog().debug((Exception)value);
        }
        if (value instanceof JaxoPluginExecutionException && (src = ((JaxoPluginExecutionException)value).getSource()) != null) {
            this.getLog().debug("Source: " + src.toString());
        }
        this.failure = value;
    }

    public final boolean isSilent() {
        return this.silent;
    }

    public void setSilent(boolean value) {
        this.silent = value;
    }

    public final void setShortGraphName(String newName) {
        this.shortGraphName = newName;
    }

    public final String getShortGraphName() {
        return this.shortGraphName;
    }

    public String getProperty(String key) {
        return this.pluginProperties.getProperty(this.pluginId() + "." + key);
    }

    public String getProperty(String key, String defaultValue) {
        return this.pluginProperties.getProperty(this.pluginId() + "." + key, defaultValue);
    }

    public void setProperty(String key, String value) {
        Object old = this.pluginProperties.setProperty(this.pluginId() + "." + key, value);
        if (old == null) {
            this.getLog().debug(this.pluginId() + " added new property: " + key + " = " + value);
        } else if (!old.toString().equals(value)) {
            StringBuffer buffer = new StringBuffer(100);
            buffer.append(this.pluginId()).append(" changed existing property: ");
            buffer.append(key).append(" = ").append(value);
            buffer.append(" (was: ").append(old.toString()).append(')');
            this.getLog().debug(buffer.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void loadProperties() {
        if (!this.cachedProperties.exists()) {
            return;
        }
        try {
            FileInputStream fis = null;
            try {
                fis = new FileInputStream(this.cachedProperties);
                this.pluginProperties.load(fis);
            }
            finally {
                if (fis != null) {
                    fis.close();
                }
            }
        }
        catch (IOException e) {
            this.getLog().debug("Error loading pugin properties!", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void storeProperties() {
        String header = "Properties for jaxodraw-" + this.getShortName() + "-plugin";
        try {
            FileOutputStream fos = null;
            try {
                fos = new FileOutputStream(this.cachedProperties);
                this.pluginProperties.store(fos, header);
                this.close(fos);
            }
            catch (Throwable throwable) {
                this.close(fos);
                throw throwable;
            }
        }
        catch (IOException e) {
            this.getLog().debug("Error storing pugin properties!", e);
        }
    }

    public Properties getProperties() {
        return this.pluginProperties;
    }

    public final String getClassName() {
        String className = this.pluginId();
        int firstChar = className.lastIndexOf(46) + 1;
        if (firstChar > 0) {
            className = className.substring(firstChar);
        }
        return className;
    }

    protected void close(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException ioEx) {
                this.getLog().debug(ioEx);
            }
        }
    }

    protected JaxoPluginLogger getLog() {
        return PluginLogger.getInstance();
    }

    protected JaxoPluginDictionary getLang() {
        if (this.language == null) {
            throw new IllegalStateException("No dictionary registered!");
        }
        return PluginDictionary.getInstance(this.language);
    }

    public abstract String getFormatName();

    public abstract String getFileExtension();

    public abstract String getFileExtensionDescription();

    private static class PluginDictionary
    implements JaxoPluginDictionary {
        private static PluginDictionary dictionary;
        private static JaxoDictionary language;

        private PluginDictionary() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static PluginDictionary getInstance(JaxoDictionary lang) {
            Class<PluginDictionary> clazz = PluginDictionary.class;
            synchronized (PluginDictionary.class) {
                language = lang;
                if (dictionary == null) {
                    dictionary = new PluginDictionary();
                }
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return dictionary;
            }
        }

        public String label(String key) {
            return language.label(key);
        }

        public String translate(String key) {
            return language.value(key);
        }

        public String message(String key, Object argument) {
            return language.message(key, argument);
        }

        public String message(String key, Object argument1, Object argument2) {
            return language.message(key, argument1, argument2);
        }

        public String message(String key, Object[] arguments) {
            return language.message(key, arguments);
        }
    }

    private static class PluginLogger
    implements JaxoPluginLogger {
        private static PluginLogger logger;

        private PluginLogger() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static PluginLogger getInstance() {
            Class<PluginLogger> clazz = PluginLogger.class;
            synchronized (PluginLogger.class) {
                if (logger == null) {
                    logger = new PluginLogger();
                }
                // ** MonitorExit[var0] (shouldn't be in output)
                return logger;
            }
        }

        public boolean isDebugEnabled() {
            return JaxoLog.isLoggable(JaxoLog.DEBUG);
        }

        public boolean isInfoEnabled() {
            return JaxoLog.isLoggable(JaxoLog.INFO);
        }

        public boolean isWarnEnabled() {
            return JaxoLog.isLoggable(JaxoLog.WARN);
        }

        public void debug(String msg) {
            JaxoLog.debug(msg);
        }

        public void debug(Exception e) {
            JaxoLog.debug(e);
        }

        public void debug(String msg, Exception e) {
            JaxoLog.debug(msg, e);
        }

        public void info(String msg) {
            JaxoLog.info(msg);
        }

        public void info(Exception e) {
            JaxoLog.info(e);
        }

        public void info(String msg, Exception e) {
            JaxoLog.info(msg, e);
        }

        public void warn(String msg) {
            JaxoLog.warn(msg);
        }

        public void warn(Exception e) {
            JaxoLog.warn(e);
        }

        public void warn(String msg, Exception e) {
            JaxoLog.warn(msg, e);
        }
    }
}

