/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jaxodraw.util;

import java.awt.Color;
import java.util.HashMap;
import java.util.Map;

public final class JaxoColor {
    public static final int JAXO_COLORS_MODE = 0;
    public static final int JAXO_COLORS_NO_GRAYSCALES_MODE = 1;
    public static final int ALL_COLORS_MODE = 2;
    public static final Color GREEN_YELLOW = new Color(214, 232, 15);
    public static final Color YELLOW = new Color(249, 229, 38);
    public static final Color GOLDEN_ROD = new Color(249, 214, 22);
    public static final Color DANDELION = new Color(255, 198, 30);
    public static final Color APRICOT = new Color(252, 165, 119);
    public static final Color PEACH = new Color(252, 127, 63);
    public static final Color MELON = new Color(249, 130, 127);
    public static final Color YELLOW_ORANGE = new Color(234, 175, 15);
    public static final Color ORANGE = new Color(221, 79, 5);
    public static final Color BURNT_ORANGE = new Color(221, 117, 0);
    public static final Color BITTERSWEET = new Color(188, 79, 7);
    public static final Color RED_ORANGE = new Color(226, 61, 40);
    public static final Color MAHOGANY = new Color(155, 48, 28);
    public static final Color MAROON = new Color(163, 38, 56);
    public static final Color BRICK_RED = new Color(175, 38, 38);
    public static final Color RED = new Color(255, 0, 0);
    public static final Color ORANGE_RED = new Color(206, 0, 124);
    public static final Color RUBINE_RED = new Color(204, 0, 160);
    public static final Color WILDSTRAWBERRY = new Color(211, 5, 71);
    public static final Color SALMON = new Color(252, 140, 153);
    public static final Color CARNATION_PINK = new Color(237, 114, 170);
    public static final Color MAGENTA = new Color(219, 40, 165);
    public static final Color VIOLET_RED = new Color(226, 40, 130);
    public static final Color RHODAMINE = new Color(234, 107, 191);
    public static final Color MULBERRY = new Color(173, 0, 117);
    public static final Color RED_VIOLET = new Color(170, 0, 102);
    public static final Color FUCHSIA = new Color(163, 5, 127);
    public static final Color LAVENDER = new Color(249, 147, 196);
    public static final Color THISTLE = new Color(232, 127, 201);
    public static final Color ORCHID = new Color(211, 107, 198);
    public static final Color DARK_ORCHID = new Color(142, 71, 173);
    public static final Color PURPLE = new Color(137, 79, 191);
    public static final Color PLUM = new Color(81, 45, 68);
    public static final Color VIOLET = new Color(48, 68, 181);
    public static final Color ROYAL_PURPLE = new Color(89, 17, 142);
    public static final Color BLUE_VIOLET = new Color(53, 0, 109);
    public static final Color PERIWINKLE = new Color(147, 122, 204);
    public static final Color CADET_BLUE = new Color(94, 104, 196);
    public static final Color CORNFLOWER_BLUE = new Color(117, 178, 221);
    public static final Color MIDNIGHT_BLUE = new Color(0, 79, 109);
    public static final Color NAVY_BLUE = new Color(0, 81, 186);
    public static final Color ROYAL_BLUE = new Color(0, 132, 201);
    public static final Color BLUE = new Color(0, 56, 168);
    public static final Color CERULEAN = new Color(0, 198, 178);
    public static final Color CYAN = new Color(94, 221, 193);
    public static final Color PROCESS_BLUE = new Color(71, 214, 193);
    public static final Color SKY_BLUE = new Color(81, 191, 226);
    public static final Color TURQUOISE = new Color(0, 183, 198);
    public static final Color TEAL_BLUE = new Color(0, 132, 142);
    public static final Color AQUAMARINE = new Color(0, 155, 170);
    public static final Color BLUE_GREEN = new Color(0, 158, 160);
    public static final Color EMERALD = new Color(0, 183, 96);
    public static final Color JUNGLE_GREEN = new Color(0, 119, 112);
    public static final Color SEA_GREEN = new Color(0, 175, 153);
    public static final Color GREEN = new Color(0, 255, 0);
    public static final Color FOREST_GREEN = new Color(0, 107, 63);
    public static final Color PINE_GREEN = new Color(0, 102, 99);
    public static final Color LIME_GREEN = new Color(140, 214, 0);
    public static final Color YELLOW_GREEN = new Color(127, 186, 0);
    public static final Color SPRING_GREEN = new Color(204, 226, 38);
    public static final Color OLIVE_GREEN = new Color(135, 137, 5);
    public static final Color RAWSIENNA = new Color(153, 89, 5);
    public static final Color SEPIA = new Color(99, 58, 17);
    public static final Color BROWN = new Color(132, 63, 15);
    public static final Color TAN = new Color(249, 114, 66);
    public static final Color GRAY = new Color(102, 109, 112);
    public static final Color BLACK = new Color(0, 0, 0);
    public static final Color GRAYSCALE15 = new Color(15, 15, 15);
    public static final Color GRAYSCALE30 = new Color(30, 30, 30);
    public static final Color GRAYSCALE45 = new Color(45, 45, 45);
    public static final Color GRAYSCALE60 = new Color(60, 60, 60);
    public static final Color GRAYSCALE75 = new Color(75, 75, 75);
    public static final Color GRAYSCALE90 = new Color(90, 90, 90);
    public static final Color GRAYSCALE105 = new Color(105, 105, 105);
    public static final Color GRAYSCALE120 = new Color(120, 120, 120);
    public static final Color GRAYSCALE135 = new Color(135, 135, 135);
    public static final Color GRAYSCALE150 = new Color(150, 150, 150);
    public static final Color GRAYSCALE165 = new Color(165, 165, 165);
    public static final Color GRAYSCALE180 = new Color(180, 180, 180);
    public static final Color GRAYSCALE195 = new Color(195, 195, 195);
    public static final Color GRAYSCALE210 = new Color(210, 210, 210);
    public static final Color GRAYSCALE225 = new Color(225, 225, 225);
    public static final Color GRAYSCALE240 = new Color(240, 240, 240);
    public static final Color WHITE = new Color(255, 255, 255);
    private static final Color[] COLOR_LIST = new Color[]{GREEN_YELLOW, YELLOW, GOLDEN_ROD, DANDELION, APRICOT, PEACH, MELON, YELLOW_ORANGE, ORANGE, BURNT_ORANGE, BITTERSWEET, RED_ORANGE, MAHOGANY, MAROON, BRICK_RED, RED, ORANGE_RED, RUBINE_RED, WILDSTRAWBERRY, SALMON, CARNATION_PINK, MAGENTA, VIOLET_RED, RHODAMINE, MULBERRY, RED_VIOLET, FUCHSIA, LAVENDER, THISTLE, ORCHID, DARK_ORCHID, PURPLE, PLUM, VIOLET, ROYAL_PURPLE, BLUE_VIOLET, PERIWINKLE, CADET_BLUE, CORNFLOWER_BLUE, MIDNIGHT_BLUE, NAVY_BLUE, ROYAL_BLUE, BLUE, CERULEAN, CYAN, PROCESS_BLUE, SKY_BLUE, TURQUOISE, TEAL_BLUE, AQUAMARINE, BLUE_GREEN, EMERALD, JUNGLE_GREEN, SEA_GREEN, GREEN, FOREST_GREEN, PINE_GREEN, LIME_GREEN, YELLOW_GREEN, SPRING_GREEN, OLIVE_GREEN, RAWSIENNA, SEPIA, BROWN, TAN, GRAY, BLACK, GRAYSCALE15, GRAYSCALE30, GRAYSCALE45, GRAYSCALE60, GRAYSCALE75, GRAYSCALE90, GRAYSCALE105, GRAYSCALE120, GRAYSCALE135, GRAYSCALE150, GRAYSCALE165, GRAYSCALE180, GRAYSCALE195, GRAYSCALE210, GRAYSCALE225, GRAYSCALE240, WHITE};
    private static final String[] COLOR_NAME = new String[]{"GreenYellow", "Yellow", "Goldenrod", "Dandelion", "Apricot", "Peach", "Melon", "YellowOrange", "Orange", "BurntOrange", "Bittersweet", "RedOrange", "Mahogany", "Maroon", "BrickRed", "Red", "OrangeRed", "RubineRed", "WildStrawberry", "Salmon", "CarnationPink", "Magenta", "VioletRed", "Rhodamine", "Mulberry", "RedViolet", "Fuchsia", "Lavender", "Thistle", "Orchid", "DarkOrchid", "Purple", "Plum", "Violet", "RoyalPurple", "BlueViolet", "Periwinkle", "CadetBlue", "CornflowerBlue", "MidnightBlue", "NavyBlue", "RoyalBlue", "Blue", "Cerulean", "Cyan", "ProcessBlue", "SkyBlue", "Turquoise", "TealBlue", "Aquamarine", "BlueGreen", "Emerald", "JungleGreen", "SeaGreen", "Green", "ForestGreen", "PineGreen", "LimeGreen", "YellowGreen", "SpringGreen", "OliveGreen", "RawSienna", "Sepia", "Brown", "Tan", "Gray", "Black", "GrayScale15", "GrayScale30", "GrayScale45", "GrayScale60", "GrayScale75", "GrayScale90", "GrayScale105", "GrayScale120", "GrayScale135", "GrayScale150", "GrayScale165", "GrayScale180", "GrayScale195", "GrayScale210", "GrayScale225", "GrayScale240", "White"};
    private static final Map<String, Color> NAME_TO_COLOR;
    private static final Map<Color, String> COLOR_TO_NAME;
    private static final Map<Color, Integer> COLOR_TO_INDEX;
    private static final int FIRST_GRAYSCALE_INDEX;
    private static final int LAST_GRAYSCALE_INDEX;
    private static final String LATEX_COMMAND_BASE = "\\SetColor{";
    private static final String LATEX_COMMAND_CLOSING = "}";

    private JaxoColor() {
    }

    public static boolean isDefinedColor(Color color) {
        return COLOR_TO_NAME.containsKey(color);
    }

    public static boolean isDefinedColor(Color color, int mode) {
        if (mode == 2) {
            return true;
        }
        if (mode == 0) {
            return JaxoColor.isDefinedColor(color);
        }
        if (mode == 1) {
            Integer v = COLOR_TO_INDEX.get(color);
            return v != null && !JaxoColor.isGrayScaleIndex(v);
        }
        return false;
    }

    public static boolean isDefinedColorName(String cName) {
        return NAME_TO_COLOR.containsKey(cName);
    }

    public static boolean isDefinedColorName(String cName, int mode) {
        Color c = JaxoColor.getColorOrNull(cName, mode);
        return c != null && JaxoColor.isDefinedColor(c, mode);
    }

    public static int getColorCount() {
        return COLOR_LIST.length;
    }

    public static Color getColor(int i) {
        return COLOR_LIST[i];
    }

    public static String getColorName(int i) {
        return COLOR_NAME[i];
    }

    private static int getIndex(Color color) {
        Integer v = COLOR_TO_INDEX.get(color);
        return v == null ? JaxoColor.getColorCount() : v;
    }

    public static Color getDefaultColor() {
        return BLACK;
    }

    public static Color getDefaultFillColor(Color lineColor) {
        if (lineColor.equals(BLACK)) {
            return GRAYSCALE225;
        }
        return GRAY;
    }

    private static Color getColorOrNull(String cName) {
        return NAME_TO_COLOR.get(cName);
    }

    public static Color getColor(String cName) {
        Color c = JaxoColor.getColorOrNull(cName);
        return c == null ? JaxoColor.getDefaultColor() : c;
    }

    public static Color getColor(String cName, int mode) {
        Color c = JaxoColor.getColorOrNull(cName, mode);
        return c == null ? JaxoColor.getDefaultColor() : c;
    }

    private static Color getColorOrNull(String cName, int mode) {
        if (mode == 2) {
            try {
                Color color = JaxoColor.getColorOrNull(cName);
                if (color == null) {
                    color = cName.charAt(0) == '#' ? Color.decode(cName) : new Color(JaxoColor.getRComponent(cName), JaxoColor.getGComponent(cName), JaxoColor.getBComponent(cName));
                }
                return color;
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
        Color c = JaxoColor.getColor(cName);
        if (mode == 1 && JaxoColor.isGrayScale(c)) {
            return null;
        }
        return c;
    }

    public static String getColorName(Color color) {
        Color closestColor = JaxoColor.getClosestColorTo(color, 0);
        return COLOR_TO_NAME.get(closestColor);
    }

    public static String getColorName(Color color, int space) {
        if (space == 2) {
            String clrName = "";
            clrName = "r" + color.getRed() + "g" + color.getGreen() + "b" + color.getBlue();
            return clrName;
        }
        if (space == 1 && JaxoColor.isGrayScale(color)) {
            return null;
        }
        return JaxoColor.getColorName(color);
    }

    public static float getGrayScaleFloat(Color color) {
        float result = 0.0f;
        Color closestColor = JaxoColor.getClosestColorTo(color, 0);
        if (JaxoColor.isDefinedGrayScale(closestColor) || closestColor.equals(WHITE)) {
            result = (float)((int)(1000.0f * (float)color.getRed() / 255.0f)) / 1000.0f;
        }
        return result;
    }

    private static boolean isGrayScaleIndex(int index) {
        return FIRST_GRAYSCALE_INDEX <= index && index <= LAST_GRAYSCALE_INDEX;
    }

    public static boolean isGrayScale(Color color) {
        Color closestColor = JaxoColor.getClosestColorTo(color, 0);
        return JaxoColor.isDefinedGrayScale(closestColor);
    }

    private static boolean isDefinedGrayScale(Color color) {
        return JaxoColor.isGrayScaleIndex(JaxoColor.getIndex(color));
    }

    public static Color getGrayScaleColor(float f) {
        Color grayScale = null;
        if (f >= 0.0f && f <= 1.0f) {
            int offset = Math.round(17.0f * f);
            grayScale = COLOR_LIST[JaxoColor.getIndex(BLACK) + offset];
        }
        return grayScale;
    }

    public static String getLatexColorCommand(Color color) {
        Color closestColor = JaxoColor.getClosestColorTo(color, 0);
        String thisColor = JaxoColor.isGrayScale(closestColor) ? "Gray" : JaxoColor.getColorName(closestColor);
        return LATEX_COMMAND_BASE.concat(thisColor.concat(LATEX_COMMAND_CLOSING));
    }

    public static Color getClosestColorTo(Color refcolor, int mode) {
        if (refcolor == null) {
            return null;
        }
        if (mode == 2) {
            return refcolor;
        }
        int red = refcolor.getRed();
        int green = refcolor.getGreen();
        int blue = refcolor.getBlue();
        int minRGBdistanceSquared = 195075;
        Color closest = WHITE;
        boolean grayScalesAllowed = mode != 1;
        for (int i = 0; i < COLOR_LIST.length; ++i) {
            Color c = COLOR_LIST[i];
            if (grayScalesAllowed || !JaxoColor.isGrayScaleIndex(i)) {
                int curRGBdistanceSquared = (int)Math.pow(c.getRed() - red, 2.0) + (int)Math.pow(c.getGreen() - green, 2.0) + (int)Math.pow(c.getBlue() - blue, 2.0);
                if (curRGBdistanceSquared == 0) {
                    closest = c;
                    break;
                }
                if (curRGBdistanceSquared >= minRGBdistanceSquared) continue;
                minRGBdistanceSquared = curRGBdistanceSquared;
                closest = c;
                continue;
            }
            return GRAY;
        }
        return closest;
    }

    private static int getRComponent(String cName) {
        int start = cName.indexOf(114);
        int stop = cName.indexOf(103, start + 1);
        if (start == -1 || stop == -1) {
            throw new NumberFormatException();
        }
        String rcompstr = cName.substring(start + 1, stop);
        int rcompint = Integer.parseInt(rcompstr);
        return rcompint;
    }

    private static int getGComponent(String cName) {
        int gcompint = 0;
        int start = cName.indexOf(103);
        int stop = cName.indexOf(98, start + 1);
        if (start == -1 || stop == -1) {
            throw new NumberFormatException();
        }
        String gcompstr = cName.substring(start + 1, stop);
        gcompint = Integer.parseInt(gcompstr);
        return gcompint;
    }

    private static int getBComponent(String cName) {
        int bcompint = 0;
        int start = cName.indexOf(98);
        int stop = cName.length();
        if (start == -1 || stop == -1) {
            throw new NumberFormatException();
        }
        String bcompstr = cName.substring(start + 1, stop);
        bcompint = Integer.parseInt(bcompstr);
        return bcompint;
    }

    static {
        COLOR_TO_INDEX = new HashMap<Color, Integer>(COLOR_NAME.length);
        NAME_TO_COLOR = new HashMap<String, Color>(COLOR_NAME.length);
        COLOR_TO_NAME = new HashMap<Color, String>(COLOR_NAME.length);
        for (int i = 0; i < COLOR_NAME.length; ++i) {
            NAME_TO_COLOR.put(COLOR_NAME[i], COLOR_LIST[i]);
            COLOR_TO_INDEX.put(COLOR_LIST[i], i);
            COLOR_TO_NAME.put(COLOR_LIST[i], COLOR_NAME[i]);
        }
        FIRST_GRAYSCALE_INDEX = JaxoColor.getIndex(GRAYSCALE15);
        LAST_GRAYSCALE_INDEX = JaxoColor.getIndex(GRAYSCALE240);
    }
}

