/**
  Album Cover Grabber - Grabs album covers automatically off the internet
  Copyright (C) 2002  Kevin M Schmidt

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
package com.bluedragontavern.albumgrabber.allmusic.pages;

import org.apache.log4j.*;
import org.apache.regexp.*;
import com.bluedragontavern.albumgrabber.*;

public class AlbumPage
{
	private static Logger logger = Logger.getLogger(AlbumPage.class);

	private String html = null;
	private boolean imageAvailable = false;
	private String imageUrl = null;

	/**
	 * Constructor
	 */
	public AlbumPage(String html)
		throws Exception
	{
		this.html = html;

		/*
			<!--Begin Album Photo-->
			<table border="0" cellpadding="0" cellspacing="0">
		 <tr>
		  <td align="center" valign="middle" width="200" class="order">
			<table border="0" cellpadding="0" cellspacing="0">
			 <tr>
			  <td valign="top">
		 <img src="http://image.allmusic.com/00/amg/cov200/drg200/g278/g27873t7dwi.jpg">
		 */

		RE findImageRE = new RE(
			"<!--Begin Album Photo-->.*?<img src=\"(.*?jpg)\">");
		imageAvailable = findImageRE.match(html);
		imageUrl = findImageRE.getParen(1);
		//logger.debug("imageAvailable = " + imageAvailable + ", imageUrl = " + imageUrl);
	}

	/**
	 * Process an album page
	 * @param album DOCUMENT ME!
	 * @return DOCUMENT ME!
	 * @throws Exception DOCUMENT ME!
	 */
	public Album getAlbum(Album album)
		throws Exception
	{
		//If we find a direct match
		if (imageAvailable)
		{
			album.setImageUrl(imageUrl);

			if (Constants.DEBUG)
			{
				System.out.println("AlbumPage:imageUrl = " + imageUrl);
			}

			//If the found artist and album names are not set, then search the html
			if (album.getFoundArtistName() == null)
			{
				//<td class="titlebar">
				//   <span class="title"> Honkin' on Bobo</span><br />
				//   <a href="/cg/amg.dll?p=amg&sql=11:88qag4httv3z " class="subtitle"">Aerosmith</a>
				//</td>

				RE artist = new RE("class=\"subtitle\"\">(.*?)</a>");
				artist.match(html);
				album.setFoundArtistName(artist.getParen(1));

				if (Constants.DEBUG)
				{
					System.out.println("AlbumPage:artistName = " +
											 album.getFoundArtistName());
				}
			}

			if (album.getFoundAlbumName() == null)
			{
				//<span class="title"> Honkin' on Bobo</span>

				RE albumTitle = new RE("<span class=\"title\">(.*?)</span>");
				albumTitle.match(html);
				album.setFoundAlbumName(albumTitle.getParen(1).trim());

				if (Constants.DEBUG)
				{
					System.out.println("AlbumPage:albumName = " +
											 album.getFoundAlbumName());
				}
			}

			//Mark the album as being found
			album.found();
		}

		return album;
	}
}
