/**
 Album Cover Grabber - Grabs album covers automatically off the internet
 Copyright (C) 2002  Kevin M Schmidt

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
package com.bluedragontavern.albumgrabber.allmusic.pages;

import java.net.*;
import java.util.*;

import org.apache.regexp.*;
import com.bluedragontavern.albumgrabber.*;
import com.bluedragontavern.albumgrabber.util.*;
import com.bluedragontavern.albumgrabber.allmusic.AlbumSearch;
import org.apache.log4j.Logger;

public class ArtistPage
{
	private static Logger logger = Logger.getLogger(ArtistPage.class);

	private String html = null;
	private DiscographyPage discographyPage = null;

	/**
	 * Constructor
	 */
	public ArtistPage(String html)
		throws Exception
	{
		this.html = html;
		//logger.debug("Artist HTML = " + html);
	}

	public Artist getArtist(Artist artist)
		throws Exception
	{
		/*
			<!--Begin Page Photo-->
			<table cellpadding="0" cellspacing="0">
			<tr>
		 <td valign="top"><a href="JavaScript:nextPicture();">
		 <img src="http://image.allmusic.com/00/amg/pic200/drp100/p107/p10710vc1y4.jpg" id="Picture" border="0" />
			</tr>
		 */

		//Find artist image
		RE findImageRE = new RE(
			"<!--Begin Page Photo-->.*?<img src=\"(.*?)\" id=\"Picture\" border=\"0\" />");

		//If we find a direct match
		if (findImageRE.match(html))
		{
			artist.setImageUrl(findImageRE.getParen(1));

			if (Constants.DEBUG)
			{
				System.out.println("ArtistPage:imageUrl = " +
										 artist.getImageUrl());
			}

			//Set the found Artist name
			if (artist.getFoundArtistName() == null)
			{
				//<td class="titlebar"><span class="title">Aerosmith</span>
				RE artistNameRE = new RE(
					"<td class=\"titlebar\"><span class=\"title\">(.*?)</span>");
				artistNameRE.match(html);
				artist.setFoundArtistName(artistNameRE.getParen(1));

				if (Constants.DEBUG)
				{
					System.out.println("ArtistPage:artistName = " +
											 artist.getFoundArtistName());
				}
			}

			//Mark the artist as being found
			artist.found();
		}

		return artist;
	}

	/**
	 * Get the discography for this Artist
	 * @return DiscograpghyPage
	 */
	public DiscographyPage getDiscography()
		throws Exception
	{
		//If we ave already retrieved the discography, just return it
		if (discographyPage != null)
			return discographyPage;

		/*
			 <td class="tab_off" nowrap="nowrap" onmouseover="tabOver(this);" onmouseout="tabOff(this);">
			<a HREF="/cg/amg.dll?p=amg&searchlink=AEROSMITH&uid=CADMR0411020959&sql=11:88qag4httv3z~T2">Discography</a></td>
		 */

		//Find discography URL
		RE findDiscographyUrlRE = new RE("Biography.*?<a HREF=\"(.*?)\">Discography</a></td>");
		if (findDiscographyUrlRE.match(html) == false)
			throw new Exception("Couldnt find discography URL on Artist page!");

		URL url = new URL("http://www.allmusic.com" +
								findDiscographyUrlRE.getParen(1));

		if (Constants.DEBUG)
		{
			System.out.println("ArtistPage:discographyURL = " + url);
		}

		String html = NetUtil.doGet(url, null);
		discographyPage = new DiscographyPage(html);
		return discographyPage;
	}
}
